/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.CRC;
import java.io.IOException;
import java.util.zip.Deflater;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

final class IDATOutputStream
extends ImageOutputStreamImpl {
    private static byte[] chunkType = new byte[]{73, 68, 65, 84};
    private ImageOutputStream stream;
    private int chunkLength;
    private long startPos;
    private CRC crc = new CRC();
    Deflater def = new Deflater(9);
    byte[] buf = new byte[512];
    private int bytesRemaining;

    public IDATOutputStream(ImageOutputStream imageOutputStream, int n) throws IOException {
        this.stream = imageOutputStream;
        this.chunkLength = n;
        this.startChunk();
    }

    private void startChunk() throws IOException {
        this.crc.reset();
        this.startPos = this.stream.getStreamPosition();
        this.stream.writeInt(-1);
        this.crc.update(chunkType, 0, 4);
        this.stream.write(chunkType, 0, 4);
        this.bytesRemaining = this.chunkLength;
    }

    private void finishChunk() throws IOException {
        this.stream.writeInt(this.crc.getValue());
        long l = this.stream.getStreamPosition();
        this.stream.seek(this.startPos);
        this.stream.writeInt((int)(l - this.startPos) - 12);
        this.stream.seek(l);
        this.stream.flushBefore(l);
    }

    public int read() throws IOException {
        throw new RuntimeException("Method not available");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new RuntimeException("Method not available");
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(byArray, n, n2);
            while (!this.def.needsInput()) {
                this.deflate();
            }
        }
    }

    public void deflate() throws IOException {
        int n = this.def.deflate(this.buf, 0, this.buf.length);
        int n2 = 0;
        while (n > 0) {
            if (this.bytesRemaining == 0) {
                this.finishChunk();
                this.startChunk();
            }
            int n3 = Math.min(n, this.bytesRemaining);
            this.crc.update(this.buf, n2, n3);
            this.stream.write(this.buf, n2, n3);
            n2 += n3;
            n -= n3;
            this.bytesRemaining -= n3;
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        try {
            if (!this.def.finished()) {
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
            }
            this.finishChunk();
        }
        finally {
            this.def.end();
        }
    }

    protected void finalize() throws Throwable {
    }
}

