/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDEventMulticaster;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.SerializationTester;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.EventListener;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.security.action.GetIntegerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragSource
implements Serializable {
    private static final long serialVersionUID = 6236096958971414066L;
    public static final Cursor DefaultCopyDrop = DragSource.load("DnD.Cursor.CopyDrop");
    public static final Cursor DefaultMoveDrop = DragSource.load("DnD.Cursor.MoveDrop");
    public static final Cursor DefaultLinkDrop = DragSource.load("DnD.Cursor.LinkDrop");
    public static final Cursor DefaultCopyNoDrop = DragSource.load("DnD.Cursor.CopyNoDrop");
    public static final Cursor DefaultMoveNoDrop = DragSource.load("DnD.Cursor.MoveNoDrop");
    public static final Cursor DefaultLinkNoDrop = DragSource.load("DnD.Cursor.LinkNoDrop");
    private static final DragSource dflt = GraphicsEnvironment.isHeadless() ? null : new DragSource();
    static final String dragSourceListenerK = "dragSourceL";
    static final String dragSourceMotionListenerK = "dragSourceMotionL";
    private transient FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private transient DragSourceListener listener;
    private transient DragSourceMotionListener motionListener;

    private static Cursor load(String string) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        try {
            return (Cursor)Toolkit.getDefaultToolkit().getDesktopProperty(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("failed to load system cursor: " + string + " : " + exception.getMessage());
        }
    }

    public static DragSource getDefaultDragSource() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return dflt;
    }

    public static boolean isDragImageSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.isDragImageSupported");
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public DragSource() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener, FlavorMap flavorMap) throws InvalidDnDOperationException {
        SunDragSourceContextPeer.setDragDropInProgress(true);
        try {
            DragSourceContextPeer dragSourceContextPeer;
            DragSourceContext dragSourceContext;
            if (flavorMap != null) {
                this.flavorMap = flavorMap;
            }
            if ((dragSourceContext = this.createDragSourceContext(dragSourceContextPeer = Toolkit.getDefaultToolkit().createDragSourceContextPeer(dragGestureEvent), dragGestureEvent, cursor, image, point, transferable, dragSourceListener)) == null) {
                throw new InvalidDnDOperationException();
            }
            dragSourceContextPeer.startDrag(dragSourceContext, dragSourceContext.getCursor(), image, point);
        }
        catch (RuntimeException runtimeException) {
            SunDragSourceContextPeer.setDragDropInProgress(false);
            throw runtimeException;
        }
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener, FlavorMap flavorMap) throws InvalidDnDOperationException {
        this.startDrag(dragGestureEvent, cursor, null, null, transferable, dragSourceListener, flavorMap);
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.startDrag(dragGestureEvent, cursor, image, point, transferable, dragSourceListener, null);
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.startDrag(dragGestureEvent, cursor, null, null, transferable, dragSourceListener, null);
    }

    protected DragSourceContext createDragSourceContext(DragSourceContextPeer dragSourceContextPeer, DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        return new DragSourceContext(dragSourceContextPeer, dragGestureEvent, cursor, image, point, transferable, dragSourceListener);
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, Component component, int n, DragGestureListener dragGestureListener) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(clazz, this, component, n, dragGestureListener);
    }

    public DragGestureRecognizer createDefaultDragGestureRecognizer(Component component, int n, DragGestureListener dragGestureListener) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(MouseDragGestureRecognizer.class, this, component, n, dragGestureListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDragSourceListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.listener = DnDEventMulticaster.add(this.listener, dragSourceListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDragSourceListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.listener = DnDEventMulticaster.remove(this.listener, dragSourceListener);
            }
        }
    }

    public DragSourceListener[] getDragSourceListeners() {
        return (DragSourceListener[])this.getListeners(DragSourceListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDragSourceMotionListener(DragSourceMotionListener dragSourceMotionListener) {
        if (dragSourceMotionListener != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.motionListener = DnDEventMulticaster.add(this.motionListener, dragSourceMotionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDragSourceMotionListener(DragSourceMotionListener dragSourceMotionListener) {
        if (dragSourceMotionListener != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.motionListener = DnDEventMulticaster.remove(this.motionListener, dragSourceMotionListener);
            }
        }
    }

    public DragSourceMotionListener[] getDragSourceMotionListeners() {
        return (DragSourceMotionListener[])this.getListeners(DragSourceMotionListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener eventListener = null;
        if (clazz == DragSourceListener.class) {
            eventListener = this.listener;
        } else if (clazz == DragSourceMotionListener.class) {
            eventListener = this.motionListener;
        }
        return DnDEventMulticaster.getListeners((EventListener)eventListener, clazz);
    }

    void processDragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragEnter(dragSourceDragEvent);
        }
    }

    void processDragOver(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragOver(dragSourceDragEvent);
        }
    }

    void processDropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dropActionChanged(dragSourceDragEvent);
        }
    }

    void processDragExit(DragSourceEvent dragSourceEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragExit(dragSourceEvent);
        }
    }

    void processDragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        DragSourceListener dragSourceListener = this.listener;
        if (dragSourceListener != null) {
            dragSourceListener.dragDropEnd(dragSourceDropEvent);
        }
    }

    void processDragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceMotionListener dragSourceMotionListener = this.motionListener;
        if (dragSourceMotionListener != null) {
            dragSourceMotionListener.dragMouseMoved(dragSourceDragEvent);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializationTester.test(this.flavorMap) ? this.flavorMap : null);
        DnDEventMulticaster.save(objectOutputStream, dragSourceListenerK, this.listener);
        DnDEventMulticaster.save(objectOutputStream, dragSourceMotionListenerK, this.motionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        this.flavorMap = (FlavorMap)objectInputStream.readObject();
        if (this.flavorMap == null) {
            this.flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        }
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if (dragSourceListenerK == string) {
                this.addDragSourceListener((DragSourceListener)objectInputStream.readObject());
                continue;
            }
            if (dragSourceMotionListenerK == string) {
                this.addDragSourceMotionListener((DragSourceMotionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public static int getDragThreshold() {
        int n = AccessController.doPrivileged(new GetIntegerAction("awt.dnd.drag.threshold", 0));
        if (n > 0) {
            return n;
        }
        Integer n2 = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        if (n2 != null) {
            return n2;
        }
        return 5;
    }
}

