/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.oa.poa;

import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.POASystemException;
import com.sun.corba.se.impl.oa.poa.DelegateImpl;
import com.sun.corba.se.impl.oa.poa.POACurrent;
import com.sun.corba.se.impl.oa.poa.POAImpl;
import com.sun.corba.se.spi.ior.ObjectAdapterId;
import com.sun.corba.se.spi.oa.ObjectAdapter;
import com.sun.corba.se.spi.oa.ObjectAdapterFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.closure.Closure;
import com.sun.corba.se.spi.orbutil.closure.ClosureFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;

public class POAFactory
implements ObjectAdapterFactory {
    private Map exportedServantsToPOA = new WeakHashMap();
    private Set poaManagers = Collections.synchronizedSet(new HashSet(4));
    private int poaManagerId = 0;
    private int poaId = 0;
    private POAImpl rootPOA = null;
    private DelegateImpl delegateImpl = null;
    private ORB orb = null;
    private POASystemException wrapper;
    private OMGSystemException omgWrapper;
    private boolean isShuttingDown = false;

    public POASystemException getWrapper() {
        return this.wrapper;
    }

    public synchronized POA lookupPOA(Servant servant) {
        return (POA)this.exportedServantsToPOA.get(servant);
    }

    public synchronized void registerPOAForServant(POA pOA, Servant servant) {
        this.exportedServantsToPOA.put(servant, pOA);
    }

    public synchronized void unregisterPOAForServant(POA pOA, Servant servant) {
        this.exportedServantsToPOA.remove(servant);
    }

    public void init(ORB oRB) {
        this.orb = oRB;
        this.wrapper = POASystemException.get(oRB, "oa.lifecycle");
        this.omgWrapper = OMGSystemException.get(oRB, "oa.lifecycle");
        this.delegateImpl = new DelegateImpl(oRB, this);
        this.registerRootPOA();
        POACurrent pOACurrent = new POACurrent(oRB);
        oRB.getLocalResolver().register("POACurrent", ClosureFactory.makeConstant(pOACurrent));
    }

    public ObjectAdapter find(ObjectAdapterId objectAdapterId) {
        POA pOA = null;
        try {
            boolean bl = true;
            Iterator iterator = objectAdapterId.iterator();
            pOA = this.getRootPOA();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (bl) {
                    if (!string.equals("RootPOA")) {
                        throw this.wrapper.makeFactoryNotPoa(string);
                    }
                    bl = false;
                    continue;
                }
                pOA = pOA.find_POA(string, true);
            }
        }
        catch (AdapterNonExistent adapterNonExistent) {
            throw this.omgWrapper.noObjectAdaptor(adapterNonExistent);
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            throw oBJECT_NOT_EXIST;
        }
        catch (TRANSIENT tRANSIENT) {
            throw tRANSIENT;
        }
        catch (Exception exception) {
            throw this.wrapper.poaLookupError(exception);
        }
        if (pOA == null) {
            throw this.wrapper.poaLookupError();
        }
        return (ObjectAdapter)((java.lang.Object)pOA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        Iterator iterator = null;
        POAFactory pOAFactory = this;
        synchronized (pOAFactory) {
            this.isShuttingDown = true;
            iterator = new HashSet(this.poaManagers).iterator();
        }
        while (iterator.hasNext()) {
            try {
                ((POAManager)iterator.next()).deactivate(true, bl);
            }
            catch (AdapterInactive adapterInactive) {}
        }
    }

    public synchronized void removePoaManager(POAManager pOAManager) {
        this.poaManagers.remove(pOAManager);
    }

    public synchronized void addPoaManager(POAManager pOAManager) {
        this.poaManagers.add(pOAManager);
    }

    public synchronized int newPOAManagerId() {
        return this.poaManagerId++;
    }

    public void registerRootPOA() {
        Closure closure = new Closure(){

            public java.lang.Object evaluate() {
                return POAImpl.makeRootPOA(POAFactory.this.orb);
            }
        };
        this.orb.getLocalResolver().register("RootPOA", ClosureFactory.makeFuture(closure));
    }

    public synchronized POA getRootPOA() {
        if (this.rootPOA == null) {
            if (this.isShuttingDown) {
                throw this.omgWrapper.noObjectAdaptor();
            }
            try {
                Object object = this.orb.resolve_initial_references("RootPOA");
                this.rootPOA = (POAImpl)object;
            }
            catch (InvalidName invalidName) {
                throw this.wrapper.cantResolveRootPoa(invalidName);
            }
        }
        return this.rootPOA;
    }

    public Delegate getDelegateImpl() {
        return this.delegateImpl;
    }

    public synchronized int newPOAId() {
        return this.poaId++;
    }

    public ORB getORB() {
        return this.orb;
    }
}

