/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.util.ConsoleController;
import com.sun.deploy.util.ConsoleHelper;
import com.sun.deploy.util.ConsoleWindow;
import com.sun.deploy.util.TraceListener;

public final class ConsoleTraceListener
implements TraceListener {
    private static final long MIN_CONSOLE_OUTPUT_INTERVAL = 100L;
    private Object lock = new Object();
    private ConsoleWindow console = null;
    private StringBuffer buffer = new StringBuffer();

    public ConsoleTraceListener(ConsoleController consoleController) {
        ConsoleHelper.setConsoleController(consoleController);
    }

    public void setConsole(ConsoleWindow consoleWindow) {
        this.console = consoleWindow;
        new ConsoleWriterThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String string) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.buffer.length() == 0;
            this.buffer.append(string);
            if (bl && this.console != null) {
                this.lock.notifyAll();
            }
        }
    }

    class ConsoleWriterThread
    extends Thread {
        public ConsoleWriterThread() {
            super("ConsoleWriterThread");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            while (true) {
                long l2 = System.currentTimeMillis();
                Object object = ConsoleTraceListener.this.lock;
                synchronized (object) {
                    if (l2 - l >= 100L && ConsoleTraceListener.this.buffer.length() > 0) {
                        ConsoleTraceListener.this.console.append(ConsoleTraceListener.this.buffer.toString());
                        ConsoleTraceListener.this.buffer = new StringBuffer();
                        l = l2;
                    } else {
                        try {
                            if (ConsoleTraceListener.this.buffer.length() == 0) {
                                ConsoleTraceListener.this.lock.wait();
                            } else {
                                ConsoleTraceListener.this.lock.wait(100L - (l2 - l));
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

