/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import sun.security.x509.AlgorithmId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private static final String[] disabledAlgorithms = new String[]{"md2"};
    static final AlgorithmChecker INSTANCE = new AlgorithmChecker();

    private AlgorithmChecker() {
    }

    static AlgorithmChecker getInstance() {
        return INSTANCE;
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        AlgorithmChecker.check(certificate);
    }

    public static void check(Certificate certificate) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        AlgorithmChecker.check(x509Certificate.getSigAlgName());
    }

    static void check(AlgorithmId algorithmId) throws CertPathValidatorException {
        AlgorithmChecker.check(algorithmId.getName());
    }

    static void check(X509CRL x509CRL) throws CertPathValidatorException {
        AlgorithmChecker.check(x509CRL.getSigAlgName());
    }

    private static void check(String string) throws CertPathValidatorException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        for (String string3 : disabledAlgorithms) {
            if (string2.indexOf(string3) == -1) continue;
            throw new CertPathValidatorException("algorithm check failed: " + string + " is disabled");
        }
    }
}

