/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorAddressLink {
    private static final String CONNECTOR_ADDRESS_COUNTER = "sun.management.JMXConnectorServer.address";
    private static final String REMOTE_CONNECTOR_COUNTER_PREFIX = "sun.management.JMXConnectorServer.";
    private static AtomicInteger counter = new AtomicInteger();

    public static void export(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("address not specified");
        }
        Perf perf = Perf.getPerf();
        perf.createString(CONNECTOR_ADDRESS_COUNTER, 1, Units.STRING.intValue(), string);
    }

    public static String importFrom(int n) throws IOException {
        ByteBuffer byteBuffer;
        Perf perf = Perf.getPerf();
        try {
            byteBuffer = perf.attach(n, "r");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        List list = new PerfInstrumentation(byteBuffer).findByPattern(CONNECTOR_ADDRESS_COUNTER);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            Counter counter = (Counter)iterator.next();
            return (String)counter.getValue();
        }
        return null;
    }

    public static void exportRemote(Map<String, String> map) {
        int n = counter.getAndIncrement();
        Perf perf = Perf.getPerf();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            perf.createString(REMOTE_CONNECTOR_COUNTER_PREFIX + n + "." + entry.getKey(), 1, Units.STRING.intValue(), entry.getValue());
        }
    }

    public static Map<String, String> importRemoteFrom(int n) throws IOException {
        ByteBuffer byteBuffer;
        Perf perf = Perf.getPerf();
        try {
            byteBuffer = perf.attach(n, "r");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        List list = new PerfInstrumentation(byteBuffer).getAllCounters();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object e : list) {
            String string = ((Counter)e).getName();
            if (!string.startsWith(REMOTE_CONNECTOR_COUNTER_PREFIX) || string.equals(CONNECTOR_ADDRESS_COUNTER)) continue;
            hashMap.put(string, ((Counter)e).getValue().toString());
        }
        return hashMap;
    }
}

