/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import com.sun.imageio.stream.CloseableDisposerRecord;
import com.sun.imageio.stream.StreamFinalizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;
import sun.java2d.Disposer;

public class FileImageInputStream
extends ImageInputStreamImpl {
    private RandomAccessFile raf;
    private final Object disposerReferent;
    private final CloseableDisposerRecord disposerRecord;

    public FileImageInputStream(File file) throws FileNotFoundException, IOException {
        this(file == null ? null : new RandomAccessFile(file, "r"));
    }

    public FileImageInputStream(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            throw new IllegalArgumentException("raf == null!");
        }
        this.raf = randomAccessFile;
        this.disposerRecord = new CloseableDisposerRecord(randomAccessFile);
        if (this.getClass() == FileImageInputStream.class) {
            this.disposerReferent = new Object();
            Disposer.addRecord(this.disposerReferent, this.disposerRecord);
        } else {
            this.disposerReferent = new StreamFinalizer(this);
        }
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n = this.raf.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n3 = this.raf.read(byArray, n, n2);
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    public long length() {
        try {
            this.checkClosed();
            return this.raf.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.raf.seek(l);
        this.streamPos = this.raf.getFilePointer();
    }

    public void close() throws IOException {
        super.close();
        this.disposerRecord.dispose();
        this.raf = null;
    }

    protected void finalize() throws Throwable {
    }
}

