/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.SetupData;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.Util.ModuleCtrl;

public class DisplayPackageDescription {
    private PackageDescription data;
    private int size = 0;

    public DisplayPackageDescription(PackageDescription data) {
        this.data = data;
        ModuleCtrl.setDefaultModuleSettings(data);
    }

    public String getDescription() {
        return this.data.getDescription();
    }

    public int getSize() {
        return this.size;
    }

    public int getState() {
        return this.data.getSelectionState();
    }

    private int getSize(TreeNode peerNode) {
        return this.data.getSize();
    }

    public void setState(TreeNode node, int newState) {
        if (this.data.getSelectionState() != 6 && this.data.isOptional()) {
            this.data.setSelectionState(newState);
        }
        if (!node.isLeaf()) {
            this.size = this.data.getSize();
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                DisplayPackageDescription childInfo = this.getInfo(child);
                childInfo.setState(child, newState);
                if (!childInfo.isSelected()) continue;
                this.size += childInfo.getSize(child);
            }
        } else if (this.isSelected()) {
            this.size = this.data.getSize();
        }
    }

    public void toggleState(TreeNode node) {
        int state = this.data.getSelectionState();
        if (state != 6) {
            if (state == 3) {
                this.setState(node, 4);
            } else if (state == 4 || state == 5) {
                this.setState(node, 3);
            } else if (state == 0 || state == 2) {
                this.setState(node, 1);
            } else {
                this.setState(node, 0);
            }
            if (!node.isLeaf()) {
                this.updateState(node);
            }
            try {
                TreeNode parent = node.getParent();
                DisplayPackageDescription parentInfo = this.getInfo(parent);
                parentInfo.updateState(parent);
                try {
                    TreeNode grandpa = parent.getParent();
                    DisplayPackageDescription grandpaInfo = this.getInfo(grandpa);
                    grandpaInfo.updateState(grandpa);
                }
                catch (IllegalArgumentException e) {}
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void updateState(TreeNode node) {
        int state = 7;
        InstallData installdata = InstallData.getInstance();
        this.size = this.data.getSize();
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            DisplayPackageDescription childInfo = this.getInfo(child);
            int childState = childInfo.getState();
            if (state == 7 || state == 6) {
                state = childState;
            } else if (state != childState && childState != 6) {
                state = installdata.isUninstallationMode() ? 5 : 2;
            }
            if (!childInfo.isSelected()) continue;
            this.size += childInfo.getSize(child);
        }
        this.data.setSelectionState(state);
    }

    public void updateSize(TreeNode node) {
        this.size = this.data.getSize();
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            DisplayPackageDescription childInfo = this.getInfo(child);
            if (!childInfo.isSelected()) continue;
            this.size += childInfo.getSize(child);
        }
    }

    public String toString() {
        return this.data.getName();
    }

    public static boolean is(Object o) {
        return o != null && o.getClass().getName().equals("org.openoffice.setup.SetupData.DisplayPackageDescription");
    }

    public boolean isSelected() {
        int state = this.data.getSelectionState();
        return state == 1 || state == 2 || state == 3 || state == 5;
    }

    private DisplayPackageDescription getInfo(TreeNode node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        DisplayPackageDescription info = (DisplayPackageDescription)((DefaultMutableTreeNode)node).getUserObject();
        if (info != null && DisplayPackageDescription.is(info)) {
            return info;
        }
        throw new IllegalArgumentException();
    }
}

