/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ainfographic.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:54:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_ANIMATION_AINFOGRAPHIC_HXX
#define _SDR_ANIMATION_AINFOGRAPHIC_HXX

#ifndef _SDR_ANIMATION_ANIMATIONINFO_HXX
#include <svx/sdr/animation/animationinfo.hxx>
#endif

#ifndef _SV_ANIMATE_HXX
#include <vcl/animate.hxx>
#endif

#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class SdrGrafObj;
class GraphicObject;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AInfoGraphic : public AInfoMixer
		{
		private:
			// The animated object
			SdrGrafObj&								mrGrafObj;

			// Animation from vcl. Contains all animation data.
			::Animation								maAnimation;

			// full cycle time, derived from Animation
			sal_uInt32								mnFullCycleTime;

			// step count, derived from Animation (not used ATM)
			sal_uInt32								mnStepCount;

			// loop count
			sal_uInt32								mnLoopCount;

			// the mixed graphic and it's state (which step is visualized)
			VirtualDevice							maVirtualDevice;
			VirtualDevice							maVirtualDeviceMask;
			sal_uInt32								maStateOfReplay;

			// #i41470#
			GraphicObject**							mppGraphicObjects;

			// add a animation step to the VirtualDevice
			void AddStateToVirtualDevice(sal_uInt32 nState);

			// Create the BasicMixer, called from GetBasicMixer on demand
			virtual sdr::mixer::BasicMixer* CreateBasicMixer();

			// Centralized method to get the cycle time for a given animation state.
			// Handles some speclial cases (see implementation)
			sal_uInt32 GetAnimBitmapWaitTimeInMs(sal_uInt32 nIndex) const;

		protected:
			// calculate the MixerState value for given time
			virtual double GetMixerState(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo) const;

		public:
			// basic constructor.
			AInfoGraphic(SdrGrafObj& rGraphicObject);

			// access to SdrGrafObj
			SdrGrafObj& GetSdrGrafObj() const
			{
				return mrGrafObj;
			}

			// acces to animation
			::Animation& GetAnimation() const;

			// access to StepCount
			sal_uInt32 GetStepCount() const;

			// access to FullCycleTime
			sal_uInt32 GetFullCycleTime() const;

			// get a reference to the VirtualDevice in given state
			BitmapEx GetBitmapExInState(sal_uInt32 nState);

			// get the step index for given StepTime
			sal_uInt32 GetStepIndex(sal_uInt32 nTimeInCycle) const;

			// destructor
			virtual ~AInfoGraphic();

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const;

			// Decide if animation is allowed for the given VOC. Default always returns
			// sal_True. Maybe necessary to switch off for accessibility (e.g.)
			virtual sal_Bool IsAnimationAllowed(const sdr::contact::ViewObjectContact& rVOContact) const;
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_ANIMATION_AINFOGRAPHIC_HXX

// eof
