/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ViewController.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 16:13:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FRAMEWORK_VIEW_CONTROLLER_HXX
#define SD_FRAMEWORK_VIEW_CONTROLLER_HXX

#include "MutexOwner.hxx"

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XVIEWCONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XViewController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XCONFIGURATIONCONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XConfigurationController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XMODULECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XModuleController.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _CPPUHELPER_COMPBASE2_HXX_
#include <cppuhelper/compbase2.hxx>
#endif

#include <boost/scoped_ptr.hpp>



namespace {

typedef ::cppu::WeakComponentImplHelper2 <
    ::com::sun::star::drawing::framework::XViewController,
    ::com::sun::star::lang::XInitialization
    > ViewControllerInterfaceBase;

} // end of anonymous namespace.



namespace sd { namespace framework {

class FactoryContainer;

/** The ViewController is responsible for managing views and their
    factories.  It is called by the ConfigurationController to activate and
    deactivate views to reflect a requested configuration.
*/
class ViewController
    : private sd::MutexOwner,
      public ViewControllerInterfaceBase      
{
public:
    ViewController (
        const ::com::sun::star::uno::Reference<com::sun::star::uno::XComponentContext>& rxContext)
        throw();

    virtual void SAL_CALL disposing (void);

    
    // XViewController
    
    virtual void SAL_CALL addViewFactory(
        const ::rtl::OUString& sViewURL,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XViewFactory >& rxViewFactory)
        throw (::com::sun::star::uno::RuntimeException);
    
    virtual void SAL_CALL removeViewFactoryForURL(
        const ::rtl::OUString& sViewURL)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL removeViewFactoryForReference(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XViewFactory >& rxViewFactory)
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XView>
        SAL_CALL getView (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxViewId)
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XView>
        SAL_CALL getFirstViewForAnchor (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxAnchorId)
        throw (::com::sun::star::uno::RuntimeException);

    
    // XResourceController
    
    virtual void SAL_CALL updateStart (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToDeactivate)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL updateEnd (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToActivate)
        throw (::com::sun::star::uno::RuntimeException);

    
    // XInitialization
    
    virtual void SAL_CALL initialize(
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Any>& aArguments)
        throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);

private:
    ViewController (void); // Not implemented.
	virtual ~ViewController (void) throw();

    /** A reference to the XController is stored so that it can be used to
        initialize newly created views.
    */
    ::com::sun::star::uno::Reference<
        com::sun::star::frame::XController> mxController;
    
    /** The reference to the XConfigurationController is used for
        notification of listeners.
    */
    ::com::sun::star::uno::Reference<
        com::sun::star::drawing::framework::XConfigurationController> mxConfigurationController;

    ::boost::scoped_ptr<FactoryContainer> mpFactoryContainer;

    class ViewContainer;
    ::boost::scoped_ptr<ViewContainer> mpViewContainer;


    /** Create and initialize a new view and notify listeners about it.
        @param rsViewURL
            This URL specifies the type of view to create.
        @param rsPaneURL
            The URL of the pane in which the new view will be displayed.
            The pane has to exist already.  Otherwise this call is ignored.
    */
    bool CreateView (
        const ::com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId>& rxViewId);

    /** Release a view that was previously created by the CreateView()
        method.
        @param rxView
            The view that is not used anymore.  The factory that was used to
            create the view can then decide whether to put it into a cache
            or to destroy it.
    */
    bool ReleaseView (
        const ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XView>&
        rxView);

    void ThrowIfDisposed (void) const
        throw (::com::sun::star::lang::DisposedException);
};

} } // end of namespace sd::framework

#endif
