/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: PaneController.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 16:12:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FRAMEWORK_PANE_CONTROLLER_HXX
#define SD_FRAMEWORK_PANE_CONTROLLER_HXX

#include "MutexOwner.hxx"

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XPANECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XPaneController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XMODULECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XModuleController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XCONFIGURATIONCONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XConfigurationController.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _CPPUHELPER_COMPBASE3_HXX_
#include <cppuhelper/compbase3.hxx>
#endif

#include <boost/scoped_ptr.hpp>



namespace {

typedef ::cppu::WeakComponentImplHelper3 <
    ::com::sun::star::drawing::framework::XPaneController,
    ::com::sun::star::lang::XInitialization,
    ::com::sun::star::awt::XWindowListener
    > PaneControllerInterfaceBase;

} // end of anonymous namespace.



namespace sd { namespace framework {

class FactoryContainer;

/** The task of the PaneController is the management of panes and their
    factories.  It is called by the ConfigurationController to activate and
    deactive panes to reflect a requested configuration.
*/
class PaneController
    : private sd::MutexOwner,
      public PaneControllerInterfaceBase      
{
public:
    PaneController (
        const ::com::sun::star::uno::Reference<com::sun::star::uno::XComponentContext>& rxContext)
        throw();

    virtual void SAL_CALL disposing (void);

    
    // XPaneController
    
    virtual void SAL_CALL addPaneFactory(
        const ::rtl::OUString& sPaneURL,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XPaneFactory>& rxPaneFactory)
        throw (::com::sun::star::uno::RuntimeException);
    
    virtual void SAL_CALL removePaneFactoryForURL(
        const ::rtl::OUString& sPaneURL)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL removePaneFactoryForReference(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XPaneFactory>& rxPaneFactory)
        throw (::com::sun::star::uno::RuntimeException);

    virtual ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPane>
        SAL_CALL getPane (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxPaneId)
        throw (::com::sun::star::uno::RuntimeException);

    
    // XResourceController

    virtual void SAL_CALL updateStart (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToDeactivate)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL updateEnd (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToActivate)
        throw (::com::sun::star::uno::RuntimeException);

    
    // XInitialization
    
    virtual void SAL_CALL initialize(
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Any>& aArguments)
        throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);

    
    // XWindowListener

    virtual void SAL_CALL windowResized(
        const ::com::sun::star::awt::WindowEvent& rEvent)
        throw (::com::sun::star::uno::RuntimeException);
    
    virtual void SAL_CALL windowMoved(
        const ::com::sun::star::awt::WindowEvent& rEvent)
        throw (::com::sun::star::uno::RuntimeException);
    
    virtual void SAL_CALL windowShown(
        const ::com::sun::star::lang::EventObject& rEvent)
        throw (::com::sun::star::uno::RuntimeException);
    
    virtual void SAL_CALL windowHidden(
        const ::com::sun::star::lang::EventObject& rEvent)
        throw (::com::sun::star::uno::RuntimeException);


    // XEventListener

    virtual void SAL_CALL disposing(
        const com::sun::star::lang::EventObject& rEvent)
        throw (com::sun::star::uno::RuntimeException);

private:
    ::com::sun::star::uno::Reference<
        com::sun::star::drawing::framework::XConfigurationController> mxConfigurationController;
    
    ::boost::scoped_ptr<FactoryContainer> mpFactoryContainer;

    class PaneContainer;
    ::boost::scoped_ptr<PaneContainer> mpPaneContainer;

    PaneController (void); // Not implemented.
	virtual ~PaneController (void) throw();

    /** Create and initiaize a new pane and notify that to the listeners of
        the ConfigurationController.
    */
    bool CreatePane (
        const ::com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId>& rxPaneId);

    /** Release a pane and notify that to the listeners of the
        ConfigurationController.
    */
    bool ReleasePane (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XPane>& rxPane);

    void TraceController (void) const;

    /** Returns a XPane reference when a XWindow or XPane reference is
        given.  When an XPane reference is given then this method checks
        whether this pane managed by the PaneController and returns an empty
        reference when it is not.
        When an XWindow reference is given then the associated pane is
        looked up and returned.
    */
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPane>
        GetPaneForPaneOrWindow (const ::com::sun::star::uno::Reference<
            com::sun::star::uno::XInterface>& rxPaneOrWindow);

    /** Return whether the specified pane is used by at least one resource
        in the given configuration.
    */
    bool IsPaneUsed (
        const ::com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId>& rxPaneId,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxConfiguration);

    void ThrowIfDisposed (void) const
        throw (::com::sun::star::lang::DisposedException);
};

} } // end of namespace sd::framework

#endif
