/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: embeddocaccess.hxx,v $
 *
 *  $Revision: 1.4.12.1 $
 *
 *  last change: $Author: rt $ $Date: 2008/10/14 08:50:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EMBEDDOCACCESS_HXX_
#define _EMBEDDOCACCESS_HXX_

#include <cppuhelper/weak.hxx>

#define OLESERV_SAVEOBJECT	    1
#define OLESERV_CLOSE		    2
#define OLESERV_NOTIFY		    3
#define OLESERV_NOTIFYCLOSING	4
#define OLESERV_SHOWOBJECT	    5
#define OLESERV_DEACTIVATE	    6

#include <oleidl.h>
#ifndef __MINGW32__
#if defined(_MSC_VER) && (_MSC_VER > 1310)
#pragma warning(disable : 4265)
#include <atldbcli.h>
#else
#include <atlcomcli.h>
#endif
#endif
#include <cppuhelper/weak.hxx>

class EmbedDocument_Impl;
struct LockedEmbedDocument_Impl
{
private:
	EmbedDocument_Impl* m_pEmbedDocument;

public:
    LockedEmbedDocument_Impl();
    LockedEmbedDocument_Impl( EmbedDocument_Impl* pEmbedDocument );
    LockedEmbedDocument_Impl( const LockedEmbedDocument_Impl& aDocLock );

    ~LockedEmbedDocument_Impl();

    LockedEmbedDocument_Impl& operator=( const LockedEmbedDocument_Impl& aDocLock );

    EmbedDocument_Impl* GetEmbedDocument() { return m_pEmbedDocument; }

    void ExecuteMethod( sal_Int16 nId );
};

class EmbeddedDocumentInstanceAccess_Impl : public ::cppu::OWeakObject
{
	::osl::Mutex m_aMutex;
	EmbedDocument_Impl* m_pEmbedDocument;

	public:
	EmbeddedDocumentInstanceAccess_Impl( EmbedDocument_Impl* pDoc )
	: m_pEmbedDocument( pDoc )
	{}

	LockedEmbedDocument_Impl GetEmbedDocument();
	void ClearEmbedDocument();
};

#endif
