/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SelectionHelper.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2007/05/22 18:09:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHART2_SELECTIONHELPER_HXX
#define _CHART2_SELECTIONHELPER_HXX

#include "DrawViewWrapper.hxx"

class SdrObject;
// header for enum SdrDragMode
#ifndef _SVDTYPES_HXX
#include <svx/svdtypes.hxx>
#endif

#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

//-----------------------------------------------------------------------------
/**
*/
class Selection
{
public: //methods
    bool hasSelection();

    rtl::OUString getSelectedCID();
    ::com::sun::star::uno::Reference<
                    ::com::sun::star::drawing::XShape > getSelectedAdditionalShape();

    bool isResizeableObjectSelected();
    bool isRotateableObjectSelected( const ::com::sun::star::uno::Reference<
                        ::com::sun::star::frame::XModel >& xChartModel );
    bool isDragableObjectSelected();

    //returns true if selection has changed
    bool setSelection( const ::rtl::OUString& rCID );
    bool setSelection( const ::com::sun::star::uno::Reference<
                    ::com::sun::star::drawing::XShape >& xShape );

    void clearSelection();

    //returns true if the selection has changed
    bool maybeSwitchSelectionAfterSingleClickWasEnsured();
    void resetPossibleSelectionAfterSingleClickWasEnsured();

    void remindSelectionBeforeMouseDown();
    bool isSelectionDifferentFromBeforeMouseDown();

    void adaptSelectionToNewPos( const Point& rMousePos, DrawViewWrapper* pDrawViewWrapper
                                       , bool bIsRightMouse, bool bWaitingForDoubleClick );

    void applySelection( DrawViewWrapper* pDrawViewWrapper );

private: //member
    //the selection could be given by a CID or by a shape
    //if m_aSelectedObjectCID is not empty this indicates the selection
    //the content of m_xSelectedShape is ignored in that case
    //the strings are used for autogenerated chart specific objects
    //the shape reference is used for additional shapes
    ::rtl::OUString     m_aSelectedObjectCID;//only single object selection so far
    ::rtl::OUString     m_aSelectedObjectCID_beforeMouseDown;
    ::rtl::OUString     m_aSelectedObjectCID_selectOnlyIfNoDoubleClickIsFollowing;

    ::com::sun::star::uno::Reference<
                    ::com::sun::star::drawing::XShape > m_xSelectAdditionalShape;
};

class SelectionHelper : public MarkHandleProvider
{
public:
    static bool             findNamedParent( SdrObject*& pInOutObject
                                , rtl::OUString& rOutName
                                , bool bGivenObjectMayBeResult );
    static SdrObject*       getMarkHandlesObject( SdrObject* pObj );
    static E3dScene*        getSceneToRotate( SdrObject* pObj );
    static bool             isDragableObjectHitTwice( const Point& rMPos
                                , const rtl::OUString& rNameOfSelectedObject
                                , const DrawViewWrapper& rDrawViewWrapper );

    static ::rtl::OUString getHitObjectCID(
        const Point& rMPos,
        DrawViewWrapper& rDrawViewWrapper,
        bool bGetDiagramInsteadOf_Wall=false );

    static bool isRotateableObject( const ::rtl::OUString& rCID
                    , const ::com::sun::star::uno::Reference<
                        ::com::sun::star::frame::XModel >& xChartModel );


    SelectionHelper( SdrObject* pSelectedObj );
    virtual ~SelectionHelper();


    //MarkHandleProvider:
    virtual bool getMarkHandles( SdrHdlList& rHdlList );
    virtual bool getFrameDragSingles();

    SdrObject*   getObjectToMark();//sets also internally the mark object
    //-> getMarkHandles will behave different if this method has found a Mark Object different from m_pSelectedObj

private:
    SdrObject*      m_pSelectedObj;//hit and logically selected object
    SdrObject*      m_pMarkObj;//object that is marked instead to have more pretty handles
};

//.............................................................................
} //namespace chart
//.............................................................................
#endif
