/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.FastScatterPlot;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.ui.ApplicationFrame;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Dimension;
import java.awt.Window;

public class FastScatterPlotDemo
extends ApplicationFrame {
    private static final int COUNT = 1000000;
    private float[][] data = new float[2][1000000];

    public FastScatterPlotDemo(String string) {
        super(string);
        this.populateData();
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis("X");
        horizontalNumberAxis.setRange(0.0, 1000000.0);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis("Y");
        verticalNumberAxis.setRange(0.0, 3000100.0);
        FastScatterPlot fastScatterPlot = new FastScatterPlot(this.data, horizontalNumberAxis, verticalNumberAxis);
        JFreeChart jFreeChart = new JFreeChart("Fast Scatter Plot", JFreeChartConstants.DEFAULT_TITLE_FONT, fastScatterPlot, false);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private void populateData() {
        int n = 0;
        while (n < this.data[0].length) {
            float f;
            this.data[0][n] = f = (float)n;
            this.data[1][n] = 100.0f + 2.0f * f + (float)Math.random() * 1000000.0f;
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        FastScatterPlotDemo fastScatterPlotDemo = new FastScatterPlotDemo("Fast Scatter Plot Demo");
        fastScatterPlotDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)fastScatterPlotDemo));
        fastScatterPlotDemo.setVisible(true);
    }
}

