<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"  default-space="strip" result-encoding="ISO-8859-1"
	xmlns:nu="http://www.jclark.com/xt/java/com.sun.xmlsearch.tree.NodeUtils"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:office="http://openoffice.org/2000/office"
	xmlns:style="http://openoffice.org/2000/style"
	xmlns:text="http://openoffice.org/2000/text"
	xmlns:table="http://openoffice.org/2000/table"
	xmlns:draw="http://openoffice.org/2000/drawing"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:meta="http://openoffice.org/2000/meta"
	xmlns:number="http://openoffice.org/2000/datastyle"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:chart="http://openoffice.org/2000/chart"
	xmlns:help="http://openoffice.org/2000/help">

	<xsl:output method="html"
				indent-result="yes"/>    


	<!--     parameter for help-prefix   -->

	<xsl:param name="hp" select="''"/>
	<xsl:param name="sm" select="'vnd.sun.star.help://'"/>
	<xsl:param name="qm" select="'?'"/>
	<xsl:param name="es" select="'='"/>
	<xsl:param name="am" select="'&amp;'"/>
	<xsl:param name="cl" select="':'"/>
	<xsl:param name="sl" select="'/'"/>
	<xsl:param name="hm" select="'#'"/>


	<!-- Possible values for Program are OFFICE, WRITER, CALC, DRAW, IMPRESS, CHART, MATH, IMAGE, PORTAL -->

	<xsl:param name="Database" select="'WRITER'"/>
	<xsl:param name="Program" select="$Database"/>
	<!-- Possible values for Language: see language codes The XML companion s.438 -->
	<xsl:param name="Language" select="'de'"/>
	<!-- Possible values for System are WIN, OS2, MAC, and UNIX -->
	<xsl:param name="System" select="'WIN'"/>
	<xsl:param name="Device" select="'WARP'"/>

	<!-- From swante -->
	<xsl:param name="deviceType" select="'HTML4'"/>

	<!-- copy trough of elements, with attributes -->

    <xsl:template match="*|@*|comment()|processing-instruction()|text()">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()"/>
		</xsl:copy>
	</xsl:template>


	
	<!--normal processing -->

	<xsl:template match="help:document">
			<xsl:apply-templates/>	
	</xsl:template>	

	<xsl:template match="help:body">
	    <html>
			<xsl:apply-templates/>	
		</html>
	</xsl:template>	

    <xsl:template match="help:help-id|help:to-be-embedded|help:to-popup">
		<xsl:apply-templates/>
	</xsl:template>

    <xsl:template match="help:help-text[@value='visible']">
		<xsl:apply-templates/>
	</xsl:template>





	<!-- Switch statements -->

   	<xsl:template match="help:switch[@select='Program']">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="help:case[@select=$Program]">
  		<xsl:apply-templates/>
	</xsl:template>

   	<xsl:template match="help:switch[@select='System']">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="help:case[@select=$System]">
  		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="help:default">
  		<xsl:if test="../../help:switch[@select='System']">	
	  		<xsl:if test="not(../help:case[@select=$System])">
		    	<xsl:apply-templates/>
  			</xsl:if>
  		</xsl:if>

  		<xsl:if test="../../help:switch[@select='Program']">	
	  		<xsl:if test="not(../help:case[@select=$Program])">
			    <xsl:apply-templates/>
  			</xsl:if>
  		</xsl:if>
	</xsl:template>



	<!-- embedding and popups -->

   	<xsl:template match="help:embedded">
		<xsl:variable name="Link" select="concat('vnd.sun.star.help://',$Database,'/',@Id,'?Language=',$Language,'&amp;System=',$System)"/>
		<xsl:variable name="EmbeddedDoc" select="document($Link)"/>
		<xsl:variable name="Docpart" select="@Eid"/>
        <xsl:apply-templates select="$EmbeddedDoc//help:to-be-embedded[@Eid=$Docpart]"/>
	</xsl:template>

	<xsl:template match="help:popup-cut">
		<xsl:variable name="ref" select="concat('vnd.sun.star.help://',$Database,'/',@Id,'?Language=',$Language,'&amp;System=',$System)"/>
		<xsl:variable name="popupdoc" select="document($ref)"/>
		<xsl:variable name="part" select="@Eid"/>
        <xsl:apply-templates select="$popupdoc//help:to-popup[@Eid=$part]"/>
	</xsl:template>



	<!-- linking -->

	<xsl:template match="help:key-word">
		<xsl:variable name="key1" select="@tag"/>
		<A name="{$key1}"/>
	</xsl:template>

	<!-- used for the AnchorName property at contents -->
	<xsl:template match="help:help-id">
		<xsl:variable name="key2" select="@value"/>
		<A name="{$key2}"/>
	</xsl:template>

    <xsl:template match="help:link">
		<xsl:variable name="Link" select="concat($hp,$sm,$Database,$sl,@Id,$qm,'Language',$es,$Language,$am,'System',$es,$System,'#',@Eid)"/>
		<A href="{$Link}">
			<xsl:apply-templates/>
		</A>
	</xsl:template>

    <xsl:template match="help:popup">
		<xsl:variable name="Link" select="concat($hp,$sm,$Database,$sl,@Id,$qm,'Language',$es,$Language,$am,'System',$es,$System,$am,'Eid',$es,@Eid)"/>
		<A href="{$Link}">
			<xsl:apply-templates/>
		</A>
	</xsl:template>

	<xsl:template match="draw:image | office:image">
		<!-- NO IMAGES SUPPLIED FOR WAP OR PALM -->
		<xsl:if test="$deviceType = 'CSS' or $deviceType = 'HTML4'">
			<xsl:element name="img">
					<xsl:variable name="pictureLink" select="concat($hp,$sm,'picture',$sl,@xlink:href,$qm,'Language',$es,$Language,$am,'System',$es,$System)"/>
					<xsl:attribute name="src"><xsl:value-of select="$pictureLink"/></xsl:attribute>
			</xsl:element>
			</xsl:if>
	</xsl:template>


	<!--cascading stylesheet-->	<!--http://abi-11139:8084/CSS/custom.css-->

	<xsl:template match="help:css-file-link">
		<xsl:variable name="CssStylesheet" select="concat($hp,$sm,$sl,$qm,'Language',$es,$Language,$am,'System',$es,$System)"/>
		<link rel="STYLESHEET" href="{$CssStylesheet}" type="text/css"/>
	</xsl:template>


</xsl:stylesheet>