/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XXmlReader.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* Copyright 2006 SUN Microsystems, Inc. */
#ifndef INCLUDED_XXMLREADER_HXX
#define INCLUDED_XXMLREADER_HXX

#include <odiapi/xxml/ContentHandler.hxx>
#include <memory>

#include <com/sun/star/io/XInputStream.hpp>
#include <com/sun/star/embed/XStorage.hpp>

namespace writerfilter { namespace xxml {


class WRITERFILTER_DLLPUBLIC XXmlReader
{
public:
	static std::auto_ptr<XXmlReader> createXXmlReader(ContentHandler &handler);
	virtual void read(const char *fileName) = 0;
	virtual void read(com::sun::star::uno::Reference< com::sun::star::io::XInputStream > stream, const char* fileName = NULL) = 0;
	virtual void read(com::sun::star::uno::Reference< com::sun::star::embed::XStorage > xStorage, ::rtl::OUString& streamName) = 0;
};



} } /* writerfilter.xxml */

#endif /* INCLUDED_XXMLREADER_HXX */
