/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: vsound.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 19:52:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _VCL_VSOUND_HXX
#define _VCL_VSOUND_HXX

#if (defined(LINUX)) || defined(FREEBSD)
#define USE_OSS
#endif

#ifdef SOLARIS
#define USE_DEVAUDIO
#endif

#if STLPORT_VERSION>=321
#include <cstdarg>
#endif
#include <sys/stat.h>
#include <tools/string.hxx>

class X11SalSound;

namespace vcl_sal {
	class VSound
	{
        protected:
		VSound( ::X11SalSound* pSound ) : m_pSalSound( pSound ), m_pBuffer( NULL ) {}
        
		// instance data
		::X11SalSound*			m_pSalSound;
		// pointer to mmaped file
		char*		m_pBuffer;
		struct stat m_aStat;
        
        void initBuffer();
        void releaseBuffer();
        
		virtual BOOL isValid() = 0;
        public:
		virtual ~VSound() {}
        
		virtual void play() = 0;
		virtual void stop() = 0;
		virtual void pause() = 0;
		virtual void cont() = 0;
        
		static VSound* createVSound( X11SalSound* );
	};
    
    
    // a class to convert bytestreams from one codec to another
    class AudioConverter
    {
        public:
        virtual ~AudioConverter();
        
        virtual void reset() = 0;
        // the returned memory should be deleted by user
        virtual char* convert( char* pBuffer, int nBytesIn, int& nBytesOut ) = 0;
        
        // conversion from G721 encoded data
        // input is G721 conforming byte buffer (actually nibble buffer)
        // output is uLaw encoded byte buffer
        static AudioConverter* createG721ToULawConverter();
        
        static AudioConverter* createINT8ToUINT16Converter();
        static AudioConverter* createSwapINT16Converter();
    };
}

#if OSL_DEBUG_LEVEL > 1
#include <stdarg.h>
#include <stdio.h>
inline void SalDbgAssert( const char* pFmt, ... )
{
	va_list ap;
	va_start( ap, pFmt );
	vfprintf( stderr, pFmt, ap );
	va_end( ap );
}
#else
inline void SalDbgAssert( const char*, ... )
{
}
#endif

#endif
