/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docchart.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: vg $ $Date: 2007/05/22 16:24:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

#include <com/sun/star/chart2/XChartDocument.hpp>

#include <float.h>

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _NDINDEX_HXX
#include <ndindex.hxx>
#endif
#ifndef _SWTABLE_HXX
#include <swtable.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _NDOLE_HXX //autogen
#include <ndole.hxx>
#endif
#ifndef _CALC_HXX
#include <calc.hxx>
#endif
#ifndef _FRMFMT_HXX
#include <frmfmt.hxx>
#endif
#ifndef _CELLFML_HXX
#include <cellfml.hxx>
#endif
#ifndef _VIEWSH_HXX
#include <viewsh.hxx>
#endif
#ifndef _NDOLE_HXX
#include <ndole.hxx>
#endif
#ifndef _CALBCK_HXX
#include <calbck.hxx>
#endif
#ifndef _CNTFRM_HXX
#include <cntfrm.hxx>
#endif
#ifndef _SWTBLFMT_HXX
#include <swtblfmt.hxx>
#endif
#ifndef _TBLSEL_HXX
#include <tblsel.hxx>
#endif
#ifndef _CELLATR_HXX
#include <cellatr.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#include <unochart.hxx>

using namespace com::sun::star;
using namespace com::sun::star::uno;


void SwTable::UpdateCharts() const
{
    GetFrmFmt()->GetDoc()->UpdateCharts( GetFrmFmt()->GetName() );
}

BOOL SwTable::IsTblComplexForChart( const String& rSelection,
									SwChartLines* pGetCLines ) const
{
	const SwTableBox* pSttBox, *pEndBox;
	if( 2 < rSelection.Len() )
	{
		// spitze Klammern am Anfang & Ende enfernen
		String sBox( rSelection );
		if( '<' == sBox.GetChar( 0  ) ) sBox.Erase( 0, 1 );
		if( '>' == sBox.GetChar( sBox.Len()-1  ) ) sBox.Erase( sBox.Len()-1 );

		xub_StrLen nTrenner = sBox.Search( ':' );
		ASSERT( STRING_NOTFOUND != nTrenner, "keine gueltige Selektion" );

		pSttBox = GetTblBox( sBox.Copy( 0, nTrenner ));
		pEndBox = GetTblBox( sBox.Copy( nTrenner+1 ));
	}
	else
	{
		const SwTableLines* pLns = &GetTabLines();
		pSttBox = (*pLns)[ 0 ]->GetTabBoxes()[ 0 ];
		while( !pSttBox->GetSttNd() )
			// bis zur Content Box!
			pSttBox = pSttBox->GetTabLines()[ 0 ]->GetTabBoxes()[ 0 ];

		const SwTableBoxes* pBoxes = &(*pLns)[ pLns->Count()-1 ]->GetTabBoxes();
		pEndBox = (*pBoxes)[ pBoxes->Count()-1 ];
		while( !pEndBox->GetSttNd() )
		{
			// bis zur Content Box!
			pLns = &pEndBox->GetTabLines();
			pBoxes = &(*pLns)[ pLns->Count()-1 ]->GetTabBoxes();
			pEndBox = (*pBoxes)[ pBoxes->Count()-1 ];
		}
	}

	return !pSttBox || !pEndBox || !::ChkChartSel( *pSttBox->GetSttNd(),
										*pEndBox->GetSttNd(), pGetCLines );
}



IMPL_LINK( SwDoc, DoUpdateAllCharts, Timer *, /*pTimer*/ )
{
	ViewShell* pVSh;
	GetEditShell( &pVSh );
	if( pVSh )
	{
		const SwFrmFmts& rTblFmts = *GetTblFrmFmts();
		for( USHORT n = 0; n < rTblFmts.Count(); ++n )
		{
			SwTable* pTmpTbl;
			const SwTableNode* pTblNd;
			SwFrmFmt* pFmt = rTblFmts[ n ];

			if( 0 != ( pTmpTbl = SwTable::FindTable( pFmt ) ) &&
				0 != ( pTblNd = pTmpTbl->GetTableNode() ) &&
				pTblNd->GetNodes().IsDocNodes() )
			{
				_UpdateCharts( *pTmpTbl, *pVSh );
			}
		}
	}
	return 0;
}

void SwDoc::_UpdateCharts( const SwTable& rTbl, ViewShell& /*rVSh*/ ) const
{
	String aName( rTbl.GetFrmFmt()->GetName() );
	SwOLENode *pONd;
	SwStartNode *pStNd;
	SwNodeIndex aIdx( *GetNodes().GetEndOfAutotext().StartOfSectionNode(), 1 );
	while( 0 != (pStNd = aIdx.GetNode().GetStartNode()) )
	{
		aIdx++;
		SwFrm* pFrm;
		if( 0 != ( pONd = aIdx.GetNode().GetOLENode() ) &&
			aName.Equals( pONd->GetChartTblName() ) &&
			0 != ( pFrm = pONd->GetFrm() ) )
		{
            SwChartDataProvider *pPCD = GetChartDataProvider();
            if (pPCD)
                pPCD->InvalidateTable( &rTbl );
			// following this the framework will now take care of repainting
			// the chart or it's replacement image...
		}
		aIdx.Assign( *pStNd->EndOfSectionNode(), + 1 );
	}
}

void SwDoc::UpdateCharts( const String &rName ) const
{
	SwTable* pTmpTbl = SwTable::FindTable( FindTblFmtByName( rName ) );
	if( pTmpTbl )
	{
		ViewShell* pVSh;
		GetEditShell( &pVSh );

		if( pVSh )
			_UpdateCharts( *pTmpTbl, *pVSh );
	}
}

void SwDoc::SetTableName( SwFrmFmt& rTblFmt, const String &rNewName )
{
// 	BOOL bStop = 1;

	const String aOldName( rTblFmt.GetName() );

	BOOL bNameFound = 0 == rNewName.Len();
	if( !bNameFound )
	{
		SwFrmFmt* pFmt;
		const SwFrmFmts& rTbl = *GetTblFrmFmts();
		for( USHORT i = rTbl.Count(); i; )
			if( !( pFmt = rTbl[ --i ] )->IsDefault() &&
				pFmt->GetName() == rNewName && IsUsed( *pFmt ) )
			{
				bNameFound = TRUE;
				break;
			}
	}

	if( !bNameFound )
		rTblFmt.SetName( rNewName, sal_True );
	else
		rTblFmt.SetName( GetUniqueTblName(), sal_True );

	SwStartNode *pStNd;
	SwNodeIndex aIdx( *GetNodes().GetEndOfAutotext().StartOfSectionNode(), 1 );
	while ( 0 != (pStNd = aIdx.GetNode().GetStartNode()) )
	{
		aIdx++;
		SwOLENode *pNd = aIdx.GetNode().GetOLENode();
		if( pNd && aOldName == pNd->GetChartTblName() )
		{
			pNd->SetChartTblName( rNewName );

            ViewShell* pVSh;
            GetEditShell( &pVSh );

            SwTable* pTable = SwTable::FindTable( &rTblFmt );
            SwChartDataProvider *pPCD = GetChartDataProvider();
            if (pPCD)
                pPCD->InvalidateTable( pTable );
			// following this the framework will now take care of repainting
			// the chart or it's replacement image...
		}
		aIdx.Assign( *pStNd->EndOfSectionNode(), + 1 );
	}
	SetModified();
}


SwChartDataProvider * SwDoc::GetChartDataProvider( bool bCreate ) const
{
    // since there must be only one instance of this object per document
    // we need a mutex here
    vos::OGuard aGuard( Application::GetSolarMutex() );

    if (bCreate && !aChartDataProviderImplRef.get())
    {
        aChartDataProviderImplRef = comphelper::ImplementationReference< SwChartDataProvider
            , chart2::data::XDataProvider >( new SwChartDataProvider( this ) );
    }
    return aChartDataProviderImplRef.get();
}


void SwDoc::CreateChartInternalDataProviders( const SwTable *pTable )
{
    if (pTable)
    {
        String aName( pTable->GetFrmFmt()->GetName() );
        SwOLENode *pONd;
        SwStartNode *pStNd;
        SwNodeIndex aIdx( *GetNodes().GetEndOfAutotext().StartOfSectionNode(), 1 );
        while (0 != (pStNd = aIdx.GetNode().GetStartNode()))
        {
            aIdx++;
            if( 0 != ( pONd = aIdx.GetNode().GetOLENode() ) &&
                aName.Equals( pONd->GetChartTblName() ) /* OLE node is chart? */ &&
                0 != (pONd->GetFrm()) /* chart frame is not hidden */ )
            {
                uno::Reference < embed::XEmbeddedObject > xIP = pONd->GetOLEObj().GetOleRef();
                if ( svt::EmbeddedObjectRef::TryRunningState( xIP ) )
                {
                    uno::Reference< chart2::XChartDocument > xChart( xIP->getComponent(), UNO_QUERY );
                    if (xChart.is())
                        xChart->createInternalDataProvider( sal_True );

                    // there may be more than one chart for each table thus we need to continue the loop...
                }
            }
            aIdx.Assign( *pStNd->EndOfSectionNode(), + 1 );
        }
    }
}


SwChartLockController_Helper & SwDoc::GetChartControllerHelper()
{
    if (!pChartControllerHelper)
    {
        pChartControllerHelper = new SwChartLockController_Helper( this );
    }
    return *pChartControllerHelper;
}

