/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ihost_ce.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:13:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_IDL_IHOST_CE_HXX
#define ARY_IDL_IHOST_CE_HXX


// USED SERVICES
    // BASE CLASSES
#include <ary/host.hxx>
    // COMPONENTS
    // PARAMETERS
#include <ary/stdconstiter.hxx>
#include <ary/idl/i_language.hxx>

namespace ary
{
namespace idl
{

class CodeEntity;
class Parameter;


class CeHost : public ary::Host
{
  public:
    enum E_ClassId { class_id = 20 };

    virtual             ~CeHost() {}

    void                Do_Module(
                            const CodeEntity &  i_rData);
    void                Do_Service(
                            const CodeEntity &  i_rData );
    void                Do_Interface(
                            const CodeEntity &  i_rData );
    void                Do_Struct(
                            const CodeEntity &  i_rData );
    void                Do_Exception(
                            const CodeEntity &  i_rData );
    void                Do_Enum(
                            const CodeEntity &  i_rData );
    void                Do_Typedef(
                            const CodeEntity &  i_rData );
    void                Do_ConstantsGroup(
                            const CodeEntity &  i_rData );
    void                Do_Singleton(
                            const CodeEntity &  i_rData );
    void                Do_SglIfcService(
                            const CodeEntity &  i_rData );
    void                Do_SglIfcSingleton(
                            const CodeEntity &  i_rData );

    void                Do_Constant(
                            const CodeEntity &  i_rData );
    void                Do_Property(
                            const CodeEntity &  i_rData );
    void                Do_Function(
                            const CodeEntity &  i_rData );
    void                Do_StructElement(
                            const CodeEntity &  i_rData );
    void                Do_EnumValue(
                            const CodeEntity &  i_rData );
    void                Do_Attribute(
                            const CodeEntity &  i_rData );
  private:
    // Interface ary::Host:
    virtual Host_ClassId
                       inq_ClassId() const;

    // Locals
    virtual void        do_Module(
                            const CodeEntity &  i_rData );
    virtual void        do_Service(
                            const CodeEntity &  i_rData );
    virtual void        do_Interface(
                            const CodeEntity &  i_rData );
    virtual void        do_Struct(
                            const CodeEntity &  i_rData );
    virtual void        do_Exception(
                            const CodeEntity &  i_rData );
    virtual void        do_Enum(
                            const CodeEntity &  i_rData );
    virtual void        do_Typedef(
                            const CodeEntity &  i_rData );
    virtual void        do_ConstantsGroup(
                            const CodeEntity &  i_rData );
    virtual void        do_Singleton(
                            const CodeEntity &  i_rData );
    virtual void        do_SglIfcService(
                            const CodeEntity &  i_rData );
    virtual void        do_SglIfcSingleton(
                            const CodeEntity &  i_rData );

    virtual void        do_Constant(
                            const CodeEntity &  i_rData );
    virtual void        do_Property(
                            const CodeEntity &  i_rData );
    virtual void        do_Function(
                            const CodeEntity &  i_rData );
    virtual void        do_StructElement(
                            const CodeEntity &  i_rData );
    virtual void        do_EnumValue(
                            const CodeEntity &  i_rData );
    virtual void        do_Attribute(
                            const CodeEntity &  i_rData );
};



// IMPLEMENTATION

inline void
CeHost::Do_Module( const CodeEntity & i_rData )
    { do_Module(i_rData); }

inline void
CeHost::Do_Service( const CodeEntity & i_rData )
    { do_Service(i_rData); }

inline void
CeHost::Do_Interface( const CodeEntity & i_rData )
    { do_Interface(i_rData); }

inline void
CeHost::Do_Struct( const CodeEntity & i_rData )
    { do_Struct(i_rData); }

inline void
CeHost::Do_Exception( const CodeEntity & i_rData )
    { do_Exception(i_rData); }

inline void
CeHost::Do_Enum( const CodeEntity & i_rData )
    { do_Enum(i_rData); }

inline void
CeHost::Do_Typedef( const CodeEntity & i_rData )
    { do_Typedef(i_rData); }

inline void
CeHost::Do_ConstantsGroup( const CodeEntity & i_rData )
    { do_ConstantsGroup(i_rData); }

inline void
CeHost::Do_Singleton( const CodeEntity & i_rData )
    { do_Singleton(i_rData); }

inline void
CeHost::Do_SglIfcService( const CodeEntity & i_rData )
    { do_SglIfcService(i_rData); }

inline void
CeHost::Do_SglIfcSingleton( const CodeEntity & i_rData )
    { do_SglIfcSingleton(i_rData); }

inline void
CeHost::Do_Constant( const CodeEntity & i_rData )
    { do_Constant(i_rData); }

inline void
CeHost::Do_Property( const CodeEntity & i_rData )
    { do_Property(i_rData); }

inline void
CeHost::Do_Function( const CodeEntity & i_rData )
    { do_Function(i_rData); }

inline void
CeHost::Do_StructElement( const CodeEntity & i_rData )
    { do_StructElement(i_rData); }

inline void
CeHost::Do_EnumValue( const CodeEntity & i_rData )
    { do_EnumValue(i_rData); }
inline void
CeHost::Do_Attribute( const CodeEntity & i_rData )
    { do_Attribute(i_rData); }



}   // namespace idl
}   // namespace ary


#endif

