/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Block.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:19:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import java.io.IOException;
import java.io.RandomAccessFile;

/**

   Base class for (typically btree) blocks to hold either
   byte vectors representing graph/tree edges,
   or pairs (key, id) for dictionaries

   Each block has a header and a data section

 */

class Block {
    public static final int HEADERLEN = 8;
    // length of Block ID in bytes
    public static final int IDLEN = 4;
    
    // number of the block
    // used for both referring to the block
    // and addresssing the block in file
    public int          _number;
    public boolean      _isLeaf = true;
    // first available byte in data section
    public int          _free = 0;
    public final byte[] _data;
  
    public Block(int blocksize) {
	_data = new byte[blocksize - HEADERLEN];
    }

    public final void setBlockNumber(int n) {
	_number = n;
    }

    public void setFree(int free) {
	_free = free;
    }
  
    // interpret 4 bytes at 'i' as an integer
    public final int integerAt(int i) {
	return ((((((_data[i++]&0xFF)<<8)
		   |_data[i++]&0xFF)<<8)
		 |_data[i++]&0xFF)<<8)
	    |_data[i]&0xFF;
    }
  
    public final void setIntegerAt(int i, final int value) {
	/*
	for (int j = i + 3; j >= i; j--, value >>>= 8)
	    _data[j] = (byte)(value & 0xFF);
	*/
	_data[i++] = (byte)((value >>> 24) & 0xFF);
	_data[i++] = (byte)((value >>> 16) & 0xFF);
	_data[i++] = (byte)((value >>>  8) & 0xFF);
	_data[i]   = (byte)(value & 0xFF);
    }

    public static final Block readIn(RandomAccessFile in, Block block)
	throws IOException {
	block._number = in.readInt();
	final int twoFields = in.readInt();
	block._isLeaf = (twoFields & 0x80000000) != 0;
	block._free = twoFields & 0x7FFFFFFF;
	in.readFully(block._data);
	return block;
    }
  
    public final void writeOut(RandomAccessFile out) throws IOException {
	out.writeInt(_number);
	out.writeInt(_free | (_isLeaf ? 0x80000000 : 0));
	out.write(_data);
    }
}
