/**

 * ===========================================

 * LibLayout : a free Java layouting library

 * ===========================================

 *

 * Project Info:  http://reporting.pentaho.org/liblayout/

 *

 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.

 *

 * This library is free software; you can redistribute it and/or modify it under the terms

 * of the GNU Lesser General Public License as published by the Free Software Foundation;

 * either version 2.1 of the License, or (at your option) any later version.

 *

 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;

 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 * See the GNU Lesser General Public License for more details.

 *

 * You should have received a copy of the GNU Lesser General Public License along with this

 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,

 * Boston, MA 02111-1307, USA.

 *

 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.

 * in the United States and other countries.]

 *

 * ------------

 * $Id: ListStylePositionResolveHandler.java,v 1.8 2007/04/02 11:41:15 taqua Exp $

 * ------------

 * (C) Copyright 2006-2007, by Pentaho Corporation.

 */



package org.jfree.layouting.layouter.style.resolver.computed.lists;



import org.jfree.layouting.LayoutProcess;

import org.jfree.layouting.input.style.StyleKey;

import org.jfree.layouting.input.style.keys.list.ListStylePosition;

import org.jfree.layouting.input.style.values.CSSValue;

import org.jfree.layouting.layouter.context.ListSpecification;

import org.jfree.layouting.layouter.model.LayoutElement;

import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;



public class ListStylePositionResolveHandler extends ConstantsResolveHandler

{

  public ListStylePositionResolveHandler ()

  {

    addNormalizeValue(ListStylePosition.INSIDE);

    addNormalizeValue(ListStylePosition.OUTSIDE);

    setFallback(ListStylePosition.OUTSIDE);

  }



  /**

   * Resolves a single property.

   *

   * @param currentNode

   * @param style

   */

  public void resolve (final LayoutProcess process, LayoutElement currentNode,

                       StyleKey key)

  {

    CSSValue value = resolveValue(process, currentNode, key);

    ListSpecification listSpecification =

            currentNode.getLayoutContext().getListSpecification();

    listSpecification.setPosition((ListStylePosition) value);

  }

}

