/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DeployUIManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutDialog
extends JDialog
implements DeploySIListener {
    private SingleInstanceImpl sil = null;
    private static String ABOUT_JAVA_ID = "com_sun_deploy_AboutJava-" + Config.getProperty("deployment.version");

    public AboutDialog(JFrame jFrame, boolean bl, boolean bl2) {
        super((Frame)jFrame, bl);
        if (bl2) {
            this.initSIImpl();
        }
        this.initComponents();
    }

    public AboutDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.initComponents();
    }

    public AboutDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.initComponents();
    }

    private void initSIImpl() {
        this.sil = new SingleInstanceImpl();
        this.sil.addSingleInstanceListener(this, ABOUT_JAVA_ID);
    }

    public static boolean shouldStartNewInstance() {
        return !SingleInstanceManager.isServerRunning(ABOUT_JAVA_ID) || !SingleInstanceManager.connectToServer("");
    }

    private void initComponents() {
        this.setTitle(this.getMessage("about.dialog.title"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AboutDialog.this.closeDialog(windowEvent);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setForeground(new Color(210, 219, 228));
        jPanel.setBackground(new Color(210, 219, 228));
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        URL uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/aboutjava.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        final int n = imageIcon.getIconWidth() - 20;
        String string = System.getProperty("java.version");
        int n2 = string.lastIndexOf("_");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        String string2 = MessageFormat.format(this.getMessage("about.java.version"), string, System.getProperty("java.runtime.version"));
        String string3 = this.getMessage("about.copyright");
        String string4 = this.getMessage("about.legal.note");
        String string5 = this.getMessage("about.prompt.info");
        String string6 = this.getMessage("about.home.link");
        String string7 = string2 + "\n" + string3 + "\n" + string4;
        UITextArea uITextArea = new UITextArea(DialogTemplate.getSubpanelFontSize(), n, false);
        uITextArea.setText(string7);
        uITextArea.setForeground(new Color(112, 114, 119));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        final String string8 = "<font face=" + ResourceManager.getUIFont().getFamily() + " color=#707277>" + string5 + " " + " <a style='color:#35556b' href=" + string6 + '>' + string6 + "</a></font>";
        final JEditorPane jEditorPane = new JEditorPane(){

            public Dimension getPreferredSize() {
                Cloneable cloneable;
                if (this.getWidth() == 0) {
                    cloneable = this.getInsets();
                    this.setSize(n, cloneable.top + cloneable.bottom + 1);
                }
                cloneable = super.getPreferredSize();
                ((Dimension)cloneable).width = this.getWidth();
                return cloneable;
            }
        };
        Font font = ResourceManager.getUIFont().deriveFont((float)DialogTemplate.getSubpanelFontSize());
        jEditorPane.setFont(font);
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string8);
        jEditorPane.setForeground(new Color(112, 114, 119));
        jEditorPane.setBackground(new Color(210, 219, 228));
        FontMetrics fontMetrics = jEditorPane.getFontMetrics(font);
        int n3 = fontMetrics.stringWidth(string5 + string6);
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Config.getInstance().showDocument(hyperlinkEvent.getURL().toString());
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    jEditorPane.setText(string8.replaceFirst("'color:#35556b'", "'color:#c06600'"));
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    jEditorPane.setText(string8);
                }
            }
        });
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(uITextArea, gridBagConstraints);
        jPanel.add(uITextArea);
        gridBagConstraints.insets = new Insets(10, 10, 30, 10);
        gridBagLayout.setConstraints(jEditorPane, gridBagConstraints);
        jPanel.add(jEditorPane);
        JLabel jLabel2 = new JLabel();
        ImageIcon imageIcon2 = ResourceManager.getIcon("sun.logo.image");
        jLabel2.setIcon(imageIcon2);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 10, 10));
        JButton jButton = new JButton(this.getMessage("about.option.close"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.okBtnActionPerformed(actionEvent);
            }
        };
        jButton.addActionListener(abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(keyStroke, "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        jEditorPane.getInputMap().put(keyStroke, "cancel");
        jEditorPane.getActionMap().put("cancel", null);
        jPanel2.add(jButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setResizable(false);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void newActivation(String[] stringArray) {
        this.toFront();
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    static {
        DeployUIManager.setLookAndFeel();
    }
}

