/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.writer;

import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.bind.v2.schemagen.Util;
import com.sun.xml.internal.txw2.TXW;
import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.txw2.output.ResultFactory;
import com.sun.xml.internal.txw2.output.XmlSerializer;
import com.sun.xml.internal.ws.encoding.soap.SOAPVersion;
import com.sun.xml.internal.ws.model.CheckedException;
import com.sun.xml.internal.ws.model.JavaMethod;
import com.sun.xml.internal.ws.model.Parameter;
import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.model.soap.Style;
import com.sun.xml.internal.ws.model.soap.Use;
import com.sun.xml.internal.ws.wsdl.writer.WSDLOutputResolver;
import com.sun.xml.internal.ws.wsdl.writer.document.Binding;
import com.sun.xml.internal.ws.wsdl.writer.document.BindingOperationType;
import com.sun.xml.internal.ws.wsdl.writer.document.Definitions;
import com.sun.xml.internal.ws.wsdl.writer.document.Fault;
import com.sun.xml.internal.ws.wsdl.writer.document.FaultType;
import com.sun.xml.internal.ws.wsdl.writer.document.Import;
import com.sun.xml.internal.ws.wsdl.writer.document.Message;
import com.sun.xml.internal.ws.wsdl.writer.document.Operation;
import com.sun.xml.internal.ws.wsdl.writer.document.ParamType;
import com.sun.xml.internal.ws.wsdl.writer.document.Part;
import com.sun.xml.internal.ws.wsdl.writer.document.Port;
import com.sun.xml.internal.ws.wsdl.writer.document.PortType;
import com.sun.xml.internal.ws.wsdl.writer.document.Service;
import com.sun.xml.internal.ws.wsdl.writer.document.StartWithExtensionsType;
import com.sun.xml.internal.ws.wsdl.writer.document.Types;
import com.sun.xml.internal.ws.wsdl.writer.document.soap.Body;
import com.sun.xml.internal.ws.wsdl.writer.document.soap.BodyType;
import com.sun.xml.internal.ws.wsdl.writer.document.soap12.Header;
import com.sun.xml.internal.ws.wsdl.writer.document.soap12.SOAPAddress;
import com.sun.xml.internal.ws.wsdl.writer.document.soap12.SOAPFault;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGenerator {
    private JAXWSOutputSchemaResolver resolver;
    private WSDLOutputResolver wsdlResolver = null;
    private RuntimeModel model;
    private Definitions serviceDefinitions;
    private Definitions portDefinitions;
    private Types types;
    public static final String DOT_WSDL = ".wsdl";
    public static final String RESPONSE = "Response";
    public static final String PARAMETERS = "parameters";
    public static final String RESULT = "parameters";
    public static final String UNWRAPPABLE_RESULT = "result";
    public static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    public static final String WSDL_PREFIX = "wsdl";
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_PREFIX = "xsd";
    public static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP12_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String SOAP_PREFIX = "soap";
    public static final String SOAP12_PREFIX = "soap12";
    public static final String TNS_PREFIX = "tns";
    public static final String BINDING = "Binding";
    public static final String SOAP_HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP12_HTTP_TRANSPORT = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    public static final String DOCUMENT = "document";
    public static final String RPC = "rpc";
    public static final String LITERAL = "literal";
    public static final String REPLACE_WITH_ACTUAL_URL = "REPLACE_WITH_ACTUAL_URL";
    private Set<QName> processedExceptions = new HashSet<QName>();
    private String bindingId;
    private String wsdlLocation;
    private String portWSDLID;
    private String schemaPrefix;

    public WSDLGenerator(RuntimeModel runtimeModel, WSDLOutputResolver wSDLOutputResolver, String string) {
        this.model = runtimeModel;
        this.resolver = new JAXWSOutputSchemaResolver();
        this.wsdlResolver = wSDLOutputResolver;
        this.bindingId = string;
    }

    public void doGeneration() {
        XmlSerializer xmlSerializer = null;
        String string = JAXBRIContext.mangleNameToClassName(this.model.getServiceQName().getLocalPart());
        Result result = this.wsdlResolver.getWSDLOutput(string + DOT_WSDL);
        if (result == null) {
            return;
        }
        this.wsdlLocation = result.getSystemId();
        XmlSerializer xmlSerializer2 = ResultFactory.createSerializer(result);
        if (this.model.getServiceQName().getNamespaceURI().equals(this.model.getTargetNamespace())) {
            xmlSerializer = xmlSerializer2;
            this.schemaPrefix = string + "_";
        } else {
            String string2 = JAXBRIContext.mangleNameToClassName(this.model.getPortTypeName().getLocalPart());
            if (string2.equals(string)) {
                string2 = string2 + "PortType";
            }
            Holder<String> holder = new Holder<String>();
            holder.value = string2 + DOT_WSDL;
            result = this.wsdlResolver.getAbstractWSDLOutput(holder);
            if (result != null) {
                this.portWSDLID = result.getSystemId();
                xmlSerializer = this.portWSDLID.equals(this.wsdlLocation) ? xmlSerializer2 : ResultFactory.createSerializer(result);
            } else {
                this.portWSDLID = (String)holder.value;
            }
            this.schemaPrefix = new File(this.portWSDLID).getName();
            int n = this.schemaPrefix.lastIndexOf(46);
            if (n > 0) {
                this.schemaPrefix = this.schemaPrefix.substring(0, n);
            }
            this.schemaPrefix = JAXBRIContext.mangleNameToClassName(this.schemaPrefix) + "_";
        }
        this.generateDocument(xmlSerializer2, xmlSerializer);
    }

    private void generateDocument(XmlSerializer xmlSerializer, XmlSerializer xmlSerializer2) {
        this.serviceDefinitions = TXW.create(Definitions.class, xmlSerializer);
        this.serviceDefinitions._namespace(WSDL_NAMESPACE, "");
        this.serviceDefinitions._namespace(XSD_NAMESPACE, XSD_PREFIX);
        this.serviceDefinitions.targetNamespace(this.model.getServiceQName().getNamespaceURI());
        this.serviceDefinitions._namespace(this.model.getServiceQName().getNamespaceURI(), TNS_PREFIX);
        if (this.bindingId.equals(SOAP12_HTTP_TRANSPORT)) {
            this.serviceDefinitions._namespace(SOAP12_NAMESPACE, SOAP12_PREFIX);
        } else {
            this.serviceDefinitions._namespace(SOAP11_NAMESPACE, SOAP_PREFIX);
        }
        this.serviceDefinitions.name(this.model.getServiceQName().getLocalPart());
        if (xmlSerializer != xmlSerializer2 && xmlSerializer2 != null) {
            this.portDefinitions = TXW.create(Definitions.class, xmlSerializer2);
            this.portDefinitions._namespace(WSDL_NAMESPACE, "");
            this.portDefinitions._namespace(XSD_NAMESPACE, XSD_PREFIX);
            if (this.model.getTargetNamespace() != null) {
                this.portDefinitions.targetNamespace(this.model.getTargetNamespace());
                this.portDefinitions._namespace(this.model.getTargetNamespace(), TNS_PREFIX);
            }
            String string = WSDLGenerator.relativize(this.portWSDLID, this.wsdlLocation);
            Import import_ = this.serviceDefinitions._import().namespace(this.model.getTargetNamespace());
            import_.location(string);
        } else if (xmlSerializer2 != null) {
            this.portDefinitions = this.serviceDefinitions;
        } else {
            String string = WSDLGenerator.relativize(this.portWSDLID, this.wsdlLocation);
            Import import_ = this.serviceDefinitions._import().namespace(this.model.getTargetNamespace());
            import_.location(string);
        }
        if (this.portDefinitions != null) {
            this.generateTypes();
            this.generateMessages();
            this.generatePortType();
        }
        this.generateBinding();
        this.generateService();
        this.serviceDefinitions.commit();
        if (this.portDefinitions != null && this.portDefinitions != this.serviceDefinitions) {
            this.portDefinitions.commit();
        }
    }

    protected void generateTypes() {
        this.types = this.portDefinitions.types();
        if (this.model.getJAXBContext() != null) {
            try {
                this.model.getJAXBContext().generateSchema(this.resolver);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new WebServiceException(iOException.getMessage());
            }
        }
    }

    protected void generateMessages() {
        for (JavaMethod javaMethod : this.model.getJavaMethods()) {
            if (!(javaMethod.getBinding() instanceof SOAPBinding)) continue;
            this.generateSOAPMessages(javaMethod, (SOAPBinding)javaMethod.getBinding());
        }
    }

    protected void generateSOAPMessages(JavaMethod javaMethod, SOAPBinding sOAPBinding) {
        Part part;
        boolean bl = sOAPBinding.isDocLit();
        Message message = this.portDefinitions.message().name(javaMethod.getOperationName());
        JAXBRIContext jAXBRIContext = this.model.getJAXBContext();
        boolean bl2 = true;
        for (Parameter object : javaMethod.getRequestParameters()) {
            if (bl) {
                if (this.isHeaderParameter(object)) {
                    bl2 = false;
                }
                if (object.isWrapperStyle()) {
                    part = message.part().name("parameters");
                    part.element(object.getName());
                    continue;
                }
                part = message.part().name(object.getPartName());
                part.element(object.getName());
                continue;
            }
            if (object.isWrapperStyle()) {
                for (Parameter parameter : ((WrapperParameter)object).getWrapperChildren()) {
                    part = message.part().name(parameter.getPartName());
                    part.type(jAXBRIContext.getTypeName(parameter.getTypeReference()));
                }
                continue;
            }
            part = message.part().name(object.getPartName());
            part.element(object.getName());
        }
        if (javaMethod.getMEP() != 2) {
            message = this.portDefinitions.message().name(javaMethod.getOperationName() + RESPONSE);
            if (bl2) {
                for (Parameter parameter : javaMethod.getResponseParameters()) {
                    if (!this.isHeaderParameter(parameter)) continue;
                    bl2 = false;
                }
            }
            for (Parameter parameter : javaMethod.getResponseParameters()) {
                if (bl) {
                    if (parameter.isWrapperStyle()) {
                        part = bl2 ? message.part().name("parameters") : message.part().name(UNWRAPPABLE_RESULT);
                        part.element(parameter.getName());
                        continue;
                    }
                    part = message.part().name(parameter.getPartName());
                    part.element(parameter.getName());
                    continue;
                }
                if (parameter.isWrapperStyle()) {
                    for (Parameter parameter2 : ((WrapperParameter)parameter).getWrapperChildren()) {
                        part = message.part().name(parameter2.getPartName());
                        part.type(jAXBRIContext.getTypeName(parameter2.getTypeReference()));
                    }
                    continue;
                }
                part = message.part().name(parameter.getPartName());
                part.element(parameter.getName());
            }
        }
        for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
            Iterator<Parameter> iterator = checkedException.getDetailType().tagName;
            String string = checkedException.getMessageName();
            QName qName = new QName(this.model.getTargetNamespace(), string);
            if (this.processedExceptions.contains(qName)) continue;
            message = this.portDefinitions.message().name(string);
            part = message.part().name("fault");
            part.element((QName)((Object)iterator));
            this.processedExceptions.add(qName);
        }
    }

    protected void generatePortType() {
        PortType portType = this.portDefinitions.portType().name(this.model.getPortTypeName().getLocalPart());
        for (JavaMethod javaMethod : this.model.getJavaMethods()) {
            Operation operation = portType.operation().name(javaMethod.getOperationName());
            this.generateParameterOrder(operation, javaMethod);
            switch (javaMethod.getMEP()) {
                case 1: {
                    this.generateInputMessage(operation, javaMethod);
                    this.generateOutputMessage(operation, javaMethod);
                    break;
                }
                case 2: {
                    this.generateInputMessage(operation, javaMethod);
                }
            }
            for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
                QName qName = checkedException.getDetailType().tagName;
                QName qName2 = new QName(this.model.getTargetNamespace(), checkedException.getMessageName());
                FaultType faultType = operation.fault().name(checkedException.getMessageName()).message(qName2);
            }
        }
    }

    protected boolean isWrapperStyle(JavaMethod javaMethod) {
        if (javaMethod.getRequestParameters().size() > 0) {
            Parameter parameter = javaMethod.getRequestParameters().iterator().next();
            return parameter.isWrapperStyle();
        }
        return false;
    }

    protected boolean isRpcLit(JavaMethod javaMethod) {
        return javaMethod.getBinding() instanceof SOAPBinding && ((SOAPBinding)javaMethod.getBinding()).getStyle().equals((Object)Style.RPC);
    }

    protected void generateParameterOrder(Operation operation, JavaMethod javaMethod) {
        if (javaMethod.getMEP() == 2) {
            return;
        }
        if (this.isRpcLit(javaMethod)) {
            this.generateRpcParameterOrder(operation, javaMethod);
        } else {
            this.generateDocumentParameterOrder(operation, javaMethod);
        }
    }

    protected void generateRpcParameterOrder(Operation operation, JavaMethod javaMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        List<Parameter> list = this.sortMethodParameters(javaMethod);
        int n = 0;
        for (Parameter parameter : list) {
            String string;
            if (parameter.getIndex() < 0 || hashSet.contains(string = parameter.getPartName())) continue;
            if (n++ > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            hashSet.add(string);
        }
        operation.parameterOrder(stringBuffer.toString());
    }

    protected void generateDocumentParameterOrder(Operation operation, JavaMethod javaMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        List<Parameter> list = this.sortMethodParameters(javaMethod);
        boolean bl = this.isWrapperStyle(javaMethod);
        int n = 0;
        for (Parameter parameter : list) {
            if (parameter.getIndex() < 0) continue;
            String string = bl && this.isBodyParameter(parameter) ? (javaMethod.getRequestParameters().contains(parameter) ? "parameters" : RESPONSE) : parameter.getPartName();
            if (hashSet.contains(string)) continue;
            if (n++ > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            hashSet.add(string);
        }
        if (n > 1) {
            operation.parameterOrder(stringBuffer.toString());
        }
    }

    protected List<Parameter> sortMethodParameters(JavaMethod javaMethod) {
        Parameter parameter2;
        HashSet<Parameter> hashSet = new HashSet<Parameter>();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        if (this.isRpcLit(javaMethod)) {
            for (Parameter parameter2 : javaMethod.getRequestParameters()) {
                if (parameter2 instanceof WrapperParameter) {
                    hashSet.addAll(((WrapperParameter)parameter2).getWrapperChildren());
                    continue;
                }
                hashSet.add(parameter2);
            }
            for (Parameter parameter2 : javaMethod.getResponseParameters()) {
                if (parameter2 instanceof WrapperParameter) {
                    hashSet.addAll(((WrapperParameter)parameter2).getWrapperChildren());
                    continue;
                }
                hashSet.add(parameter2);
            }
        } else {
            hashSet.addAll(javaMethod.getRequestParameters());
            hashSet.addAll(javaMethod.getResponseParameters());
        }
        Iterator<Parameter> iterator = hashSet.iterator();
        if (hashSet.size() == 0) {
            return arrayList;
        }
        parameter2 = iterator.next();
        arrayList.add(parameter2);
        for (int i = 1; i < hashSet.size(); ++i) {
            int n;
            parameter2 = iterator.next();
            for (n = 0; n < i; ++n) {
                Parameter parameter3 = (Parameter)arrayList.get(n);
                if (parameter2.getIndex() == parameter3.getIndex() && parameter2 instanceof WrapperParameter || parameter2.getIndex() < parameter3.getIndex()) break;
            }
            arrayList.add(n, parameter2);
        }
        return arrayList;
    }

    protected boolean isBodyParameter(Parameter parameter) {
        ParameterBinding parameterBinding = parameter.getBinding();
        return parameterBinding.isBody();
    }

    protected boolean isHeaderParameter(Parameter parameter) {
        ParameterBinding parameterBinding = parameter.getBinding();
        return parameterBinding.isHeader();
    }

    protected boolean isAttachmentParameter(Parameter parameter) {
        ParameterBinding parameterBinding = parameter.getBinding();
        return parameterBinding.isAttachment();
    }

    protected void generateBinding() {
        Binding binding = this.serviceDefinitions.binding().name(this.model.getPortName().getLocalPart() + BINDING);
        binding.type(this.model.getPortTypeName());
        boolean bl = true;
        for (JavaMethod javaMethod : this.model.getJavaMethods()) {
            if (bl) {
                if (javaMethod.getBinding() instanceof SOAPBinding) {
                    TypedXmlWriter typedXmlWriter;
                    SOAPBinding sOAPBinding = (SOAPBinding)javaMethod.getBinding();
                    SOAPVersion sOAPVersion = sOAPBinding.getSOAPVersion();
                    if (sOAPVersion.equals(SOAP12_HTTP_TRANSPORT)) {
                        typedXmlWriter = binding.soap12Binding();
                        typedXmlWriter.transport(SOAP12_HTTP_TRANSPORT);
                        if (sOAPBinding.getStyle().equals((Object)Style.DOCUMENT)) {
                            typedXmlWriter.style(DOCUMENT);
                        } else {
                            typedXmlWriter.style(RPC);
                        }
                    } else {
                        typedXmlWriter = binding.soapBinding();
                        typedXmlWriter.transport(SOAP_HTTP_TRANSPORT);
                        if (sOAPBinding.getStyle().equals((Object)Style.DOCUMENT)) {
                            typedXmlWriter.style(DOCUMENT);
                        } else {
                            typedXmlWriter.style(RPC);
                        }
                    }
                }
                bl = false;
            }
            if (this.bindingId.equals(SOAP12_HTTP_TRANSPORT)) {
                this.generateSOAP12BindingOperation(javaMethod, binding);
                continue;
            }
            this.generateBindingOperation(javaMethod, binding);
        }
    }

    protected void generateBindingOperation(JavaMethod javaMethod, Binding binding) {
        BindingOperationType bindingOperationType = binding.operation().name(javaMethod.getOperationName());
        String string = this.model.getTargetNamespace();
        QName qName = new QName(string, javaMethod.getOperationName());
        QName qName2 = new QName(string, javaMethod.getOperationName() + RESPONSE);
        if (javaMethod.getBinding() instanceof SOAPBinding) {
            Object object;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
            this.splitParameters(arrayList, arrayList2, javaMethod.getRequestParameters());
            SOAPBinding sOAPBinding = (SOAPBinding)javaMethod.getBinding();
            bindingOperationType.soapOperation().soapAction(sOAPBinding.getSOAPAction());
            StartWithExtensionsType startWithExtensionsType = bindingOperationType.input();
            BodyType bodyType = startWithExtensionsType._element(Body.class);
            boolean bl = sOAPBinding.getStyle().equals((Object)Style.RPC);
            if (sOAPBinding.getUse().equals((Object)Use.LITERAL)) {
                bodyType.use(LITERAL);
                if (arrayList2.size() > 0) {
                    if (arrayList.size() > 0) {
                        Parameter parameter = (Parameter)arrayList.iterator().next();
                        if (bl) {
                            StringBuffer object22 = new StringBuffer();
                            int n = 0;
                            for (Parameter parameter2 : ((WrapperParameter)parameter).getWrapperChildren()) {
                                if (n++ > 0) {
                                    object22.append(' ');
                                }
                                object22.append(parameter2.getPartName());
                            }
                            bodyType.parts(object22.toString());
                        } else if (parameter.isWrapperStyle()) {
                            bodyType.parts("parameters");
                        } else {
                            bodyType.parts(parameter.getPartName());
                        }
                    } else {
                        bodyType.parts("");
                    }
                    this.generateSOAPHeaders(startWithExtensionsType, arrayList2, qName);
                }
                if (bl) {
                    bodyType.namespace(javaMethod.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            } else {
                throw new WebServiceException("encoded use is not supported");
            }
            if (javaMethod.getMEP() != 2) {
                boolean bl2 = arrayList2.size() == 0;
                arrayList.clear();
                arrayList2.clear();
                this.splitParameters(arrayList, arrayList2, javaMethod.getResponseParameters());
                bl2 = bl2 ? arrayList2.size() == 0 : bl2;
                StartWithExtensionsType startWithExtensionsType2 = bindingOperationType.output();
                bodyType = startWithExtensionsType2._element(Body.class);
                bodyType.use(LITERAL);
                if (arrayList2.size() > 0) {
                    String string2 = "";
                    if (arrayList.size() > 0) {
                        object = (Parameter)arrayList.iterator().next();
                        if (bl) {
                            int n = 0;
                            for (Parameter parameter : ((WrapperParameter)object).getWrapperChildren()) {
                                if (n++ > 0) {
                                    string2 = string2 + " ";
                                }
                                string2 = string2 + parameter.getPartName();
                            }
                        } else if (object != null) {
                            string2 = ((Parameter)object).isWrapperStyle() ? (bl2 ? "parameters" : UNWRAPPABLE_RESULT) : ((Parameter)object).getPartName();
                        }
                    }
                    bodyType.parts(string2);
                    this.generateSOAPHeaders(startWithExtensionsType2, arrayList2, qName2);
                }
                if (bl) {
                    bodyType.namespace(javaMethod.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            }
            for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
                Fault fault = bindingOperationType.fault().name(checkedException.getMessageName());
                object = fault._element(com.sun.xml.internal.ws.wsdl.writer.document.soap.SOAPFault.class).name(checkedException.getMessageName());
                object.use(LITERAL);
            }
        }
    }

    protected void generateSOAP12BindingOperation(JavaMethod javaMethod, Binding binding) {
        BindingOperationType bindingOperationType = binding.operation().name(javaMethod.getOperationName());
        String string = this.model.getTargetNamespace();
        QName qName = new QName(string, javaMethod.getOperationName());
        QName qName2 = new QName(string, javaMethod.getOperationName() + RESPONSE);
        if (javaMethod.getBinding() instanceof SOAPBinding) {
            Object object;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
            this.splitParameters(arrayList, arrayList2, javaMethod.getRequestParameters());
            SOAPBinding sOAPBinding = (SOAPBinding)javaMethod.getBinding();
            bindingOperationType.soap12Operation().soapAction(sOAPBinding.getSOAPAction());
            StartWithExtensionsType startWithExtensionsType = bindingOperationType.input();
            com.sun.xml.internal.ws.wsdl.writer.document.soap12.BodyType bodyType = startWithExtensionsType._element(com.sun.xml.internal.ws.wsdl.writer.document.soap12.Body.class);
            boolean bl = sOAPBinding.getStyle().equals((Object)Style.RPC);
            if (sOAPBinding.getUse().equals((Object)Use.LITERAL)) {
                bodyType.use(LITERAL);
                if (arrayList2.size() > 0) {
                    if (arrayList.size() > 0) {
                        Parameter parameter = (Parameter)arrayList.iterator().next();
                        if (bl) {
                            StringBuffer object22 = new StringBuffer();
                            int n = 0;
                            for (Parameter parameter2 : ((WrapperParameter)parameter).getWrapperChildren()) {
                                if (n++ > 0) {
                                    object22.append(' ');
                                }
                                object22.append(parameter2.getPartName());
                            }
                            bodyType.parts(object22.toString());
                        } else if (parameter.isWrapperStyle()) {
                            bodyType.parts("parameters");
                        } else {
                            bodyType.parts(parameter.getPartName());
                        }
                    } else {
                        bodyType.parts("");
                    }
                    this.generateSOAP12Headers(startWithExtensionsType, arrayList2, qName);
                }
                if (bl) {
                    bodyType.namespace(javaMethod.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            } else {
                throw new WebServiceException("encoded use is not supported");
            }
            if (javaMethod.getMEP() != 2) {
                boolean bl2 = arrayList2.size() == 0;
                arrayList.clear();
                arrayList2.clear();
                this.splitParameters(arrayList, arrayList2, javaMethod.getResponseParameters());
                bl2 = bl2 ? arrayList2.size() == 0 : bl2;
                StartWithExtensionsType startWithExtensionsType2 = bindingOperationType.output();
                bodyType = startWithExtensionsType2._element(com.sun.xml.internal.ws.wsdl.writer.document.soap12.Body.class);
                bodyType.use(LITERAL);
                if (arrayList2.size() > 0) {
                    if (arrayList.size() > 0) {
                        Parameter parameter = (Parameter)arrayList.iterator().next();
                        if (bl) {
                            object = "";
                            int n = 0;
                            for (Parameter parameter3 : ((WrapperParameter)parameter).getWrapperChildren()) {
                                if (n++ > 0) {
                                    object = (String)object + " ";
                                }
                                object = (String)object + parameter3.getPartName();
                            }
                            bodyType.parts((String)object);
                        } else if (parameter.isWrapperStyle()) {
                            if (bl2) {
                                bodyType.parts("parameters");
                            } else {
                                bodyType.parts(UNWRAPPABLE_RESULT);
                            }
                        } else {
                            bodyType.parts(parameter.getPartName());
                        }
                    } else {
                        bodyType.parts("");
                    }
                    this.generateSOAP12Headers(startWithExtensionsType2, arrayList2, qName2);
                }
                if (bl) {
                    bodyType.namespace(javaMethod.getRequestParameters().iterator().next().getName().getNamespaceURI());
                }
            }
            for (CheckedException checkedException : javaMethod.getCheckedExceptions()) {
                Fault fault = bindingOperationType.fault().name(checkedException.getMessageName());
                object = fault._element(SOAPFault.class).name(checkedException.getMessageName());
                object.use(LITERAL);
            }
        }
    }

    protected void splitParameters(List<Parameter> list, List<Parameter> list2, List<Parameter> list3) {
        for (Parameter parameter : list3) {
            if (this.isBodyParameter(parameter)) {
                list.add(parameter);
                continue;
            }
            list2.add(parameter);
        }
    }

    protected void generateSOAPHeaders(TypedXmlWriter typedXmlWriter, List<Parameter> list, QName qName) {
        for (Parameter parameter : list) {
            com.sun.xml.internal.ws.wsdl.writer.document.soap.Header header = typedXmlWriter._element(com.sun.xml.internal.ws.wsdl.writer.document.soap.Header.class);
            header.message(qName);
            header.part(parameter.getPartName());
            header.use(LITERAL);
        }
    }

    protected void generateSOAP12Headers(TypedXmlWriter typedXmlWriter, List<Parameter> list, QName qName) {
        for (Parameter parameter : list) {
            Header header = typedXmlWriter._element(Header.class);
            header.message(qName);
            header.part(parameter.getPartName());
            header.use(LITERAL);
        }
    }

    protected void generateService() {
        QName qName = this.model.getPortName();
        QName qName2 = this.model.getServiceQName();
        Service service = this.serviceDefinitions.service().name(qName2.getLocalPart());
        Port port = service.port().name(qName.getLocalPart());
        port.binding(new QName(qName2.getNamespaceURI(), qName.getLocalPart() + BINDING));
        if (this.model.getJavaMethods().size() == 0) {
            return;
        }
        if (this.model.getJavaMethods().iterator().next().getBinding() instanceof SOAPBinding) {
            if (this.bindingId.equals(SOAP12_HTTP_TRANSPORT)) {
                SOAPAddress sOAPAddress = port._element(SOAPAddress.class);
                sOAPAddress.location(REPLACE_WITH_ACTUAL_URL);
            } else {
                com.sun.xml.internal.ws.wsdl.writer.document.soap.SOAPAddress sOAPAddress = port._element(com.sun.xml.internal.ws.wsdl.writer.document.soap.SOAPAddress.class);
                sOAPAddress.location(REPLACE_WITH_ACTUAL_URL);
            }
        }
    }

    protected void generateInputMessage(Operation operation, JavaMethod javaMethod) {
        ParamType paramType = operation.input();
        paramType.message(new QName(this.model.getTargetNamespace(), javaMethod.getOperationName()));
    }

    protected void generateOutputMessage(Operation operation, JavaMethod javaMethod) {
        ParamType paramType = operation.output();
        paramType.message(new QName(this.model.getTargetNamespace(), javaMethod.getOperationName() + RESPONSE));
    }

    public Result createOutputFile(String string, String string2) throws IOException {
        if (string.equals("")) {
            return null;
        }
        com.sun.xml.internal.ws.wsdl.writer.document.xsd.Import import_ = this.types.schema()._import().namespace(string);
        Holder<String> holder = new Holder<String>();
        holder.value = this.schemaPrefix + string2;
        Result result = this.wsdlResolver.getSchemaOutput(string, holder);
        String string3 = result == null ? (String)holder.value : WSDLGenerator.relativize(result.getSystemId(), this.wsdlLocation);
        import_.schemaLocation(string3);
        return result;
    }

    protected static String relativize(String string, String string2) {
        try {
            assert (string != null);
            if (string2 == null) {
                return string;
            }
            URI uRI = new URI(Util.escapeURI(string));
            URI uRI2 = new URI(Util.escapeURI(string2));
            if (uRI.isOpaque() || uRI2.isOpaque()) {
                return string;
            }
            if (!Util.equalsIgnoreCase(uRI.getScheme(), uRI2.getScheme()) || !Util.equal(uRI.getAuthority(), uRI2.getAuthority())) {
                return string;
            }
            String string3 = uRI.getPath();
            String string4 = uRI2.getPath();
            if (!string4.endsWith("/")) {
                string4 = Util.normalizeUriPath(string4);
            }
            if (string3.equals(string4)) {
                return ".";
            }
            String string5 = WSDLGenerator.calculateRelativePath(string3, string4);
            if (string5 == null) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5);
            if (uRI.getQuery() != null) {
                stringBuffer.append('?').append(uRI.getQuery());
            }
            if (uRI.getFragment() != null) {
                stringBuffer.append('#').append(uRI.getFragment());
            }
            return stringBuffer.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError("Error escaping one of these uris:\n\t" + string + "\n\t" + string2);
        }
    }

    private static String calculateRelativePath(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return "../" + WSDLGenerator.calculateRelativePath(string, Util.getParentUriPath(string2));
    }

    protected class JAXWSOutputSchemaResolver
    extends SchemaOutputResolver {
        protected JAXWSOutputSchemaResolver() {
        }

        public Result createOutput(String string, String string2) throws IOException {
            return WSDLGenerator.this.createOutputFile(string, string2);
        }
    }
}

