/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.http.HTTPBindingImpl;
import com.sun.xml.internal.ws.binding.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.client.BindingProviderProperties;
import com.sun.xml.internal.ws.client.ClientConfigurationException;
import com.sun.xml.internal.ws.client.EndpointIFBase;
import com.sun.xml.internal.ws.client.EndpointIFContext;
import com.sun.xml.internal.ws.client.EndpointIFInvocationHandler;
import com.sun.xml.internal.ws.client.InternalBindingProvider;
import com.sun.xml.internal.ws.client.PortInfoBase;
import com.sun.xml.internal.ws.client.ServiceContext;
import com.sun.xml.internal.ws.client.ServiceContextBuilder;
import com.sun.xml.internal.ws.client.dispatch.DispatchBase;
import com.sun.xml.internal.ws.handler.PortInfoImpl;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.spi.runtime.StubBase;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.WSDLContext;
import com.sun.xml.internal.ws.wsdl.parser.Binding;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.spi.ServiceDelegate;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServiceDelegate
extends ServiceDelegate {
    protected static final String GET = "get";
    protected HashSet<QName> ports;
    protected HashMap<QName, PortInfoBase> dispatchPorts;
    protected HandlerResolver handlerResolver;
    protected Object serviceProxy;
    protected URL wsdlLocation;
    protected ServiceContext serviceContext;
    protected Executor executor;
    private HashSet<Object> seiProxies;
    private EntityResolver entityResolver;

    public WSServiceDelegate(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.dispatchPorts = new HashMap();
        this.seiProxies = new HashSet();
        if (this.serviceContext.getHandlerResolver() != null) {
            this.handlerResolver = this.serviceContext.getHandlerResolver();
        }
    }

    public WSServiceDelegate(URL uRL, QName qName, Class clazz) {
        if (qName == null) {
            throw new ClientConfigurationException("service.noServiceName", new Object[0]);
        }
        this.dispatchPorts = new HashMap();
        this.seiProxies = new HashSet();
        this.serviceContext = ServiceContextBuilder.build(uRL, qName, clazz, XmlUtil.createDefaultCatalogResolver());
        if (this.serviceContext.getHandlerResolver() != null) {
            this.handlerResolver = this.serviceContext.getHandlerResolver();
        }
        this.populatePorts();
    }

    private void processServiceContext(QName qName, Class clazz) throws WebServiceException {
        ServiceContextBuilder.completeServiceContext(qName, this.serviceContext, clazz);
    }

    public URL getWSDLLocation() {
        if (this.wsdlLocation == null) {
            this.setWSDLLocation(this.getWsdlLocation());
        }
        return this.wsdlLocation;
    }

    public void setWSDLLocation(URL uRL) {
        this.wsdlLocation = uRL;
    }

    @Override
    public Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        this.executor = Executors.newFixedThreadPool(3, new DaemonThreadFactory());
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    @Override
    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    public Object getPort(QName qName, Class clazz) throws WebServiceException {
        Object object = this.createEndpointIFBaseProxy(qName, clazz);
        this.seiProxies.add(object);
        if (qName != null) {
            this.addPort(qName);
        }
        return object;
    }

    public Object getPort(Class clazz) throws WebServiceException {
        return this.createEndpointIFBaseProxy(null, clazz);
    }

    @Override
    public void addPort(QName qName, String string, String string2) throws WebServiceException {
        if (this.dispatchPorts.containsKey(qName)) {
            throw new WebServiceException("Port " + qName.toString() + " already exists can not create a port with the same name.");
        }
        this.dispatchPorts.put(qName, new PortInfoBase(string2, qName, string));
        this.addPort(qName);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, Class<T> clazz, Service.Mode mode) throws WebServiceException {
        return this.createDispatchClazz(qName, clazz, mode);
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, JAXBContext jAXBContext, Service.Mode mode) throws WebServiceException {
        return this.createDispatchJAXB(qName, jAXBContext, mode);
    }

    @Override
    public QName getServiceName() {
        return this.serviceContext.getServiceName();
    }

    public Iterator getPorts() throws WebServiceException {
        if (this.ports == null) {
            this.populatePorts();
        }
        if (this.ports.size() == 0) {
            throw this.noWsdlException();
        }
        return this.ports.iterator();
    }

    @Override
    public URL getWSDLDocumentLocation() {
        return this.getWsdlLocation();
    }

    protected void addPorts(QName[] qNameArray) {
        if (qNameArray != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this.addPort(qNameArray[i]);
            }
        }
    }

    private void populatePorts() {
        QName qName;
        if (this.ports == null) {
            this.ports = new HashSet();
        }
        WSDLContext wSDLContext = this.serviceContext.getWsdlContext();
        if (this.serviceContext.getServiceName() == null && wSDLContext != null) {
            this.serviceContext.setServiceName(wSDLContext.getFirstServiceName());
        }
        Set<QName> set = null;
        if (wSDLContext != null && (set = wSDLContext.getPortsAsSet(qName = this.serviceContext.getServiceName())) != null) {
            QName[] qNameArray = set.toArray(new QName[set.size()]);
            this.addPorts(qNameArray);
            for (QName qName2 : qNameArray) {
                String string = wSDLContext.getEndpoint(qName, qName2);
                String string2 = wSDLContext.getWsdlBinding(qName, qName2).getBindingId();
                this.dispatchPorts.put(qName2, new PortInfoBase(string, qName2, string2));
            }
        }
    }

    protected void addPort(QName qName) {
        if (this.ports == null) {
            this.populatePorts();
        }
        this.ports.add(qName);
    }

    protected WebServiceException noWsdlException() {
        return new WebServiceException("dii.service.no.wsdl.available");
    }

    private Object createEndpointIFBaseProxy(QName qName, Class clazz) throws WebServiceException {
        if (this.serviceContext.getWsdlContext() == null) {
            throw new ClientConfigurationException("service.noWSDLUrl", new Object[0]);
        }
        if (qName != null && !this.serviceContext.getWsdlContext().contains(this.serviceContext.getServiceName(), qName)) {
            throw new ClientConfigurationException("service.invalidPort", qName, this.serviceContext.getServiceName(), this.serviceContext.getWsdlContext().getWsdlLocation().toString());
        }
        this.processServiceContext(qName, clazz);
        if (qName == null) {
            qName = this.serviceContext.getEndpointIFContext(clazz.getName()).getPortName();
        }
        return this.buildEndpointIFProxy(qName, clazz);
    }

    protected HashSet<QName> getPortsAsSet() {
        if (this.ports == null) {
            this.populatePorts();
        }
        return this.ports;
    }

    protected void setBindingOnProvider(InternalBindingProvider internalBindingProvider, QName qName, String string) {
        Object object;
        List<Handler> list = null;
        HandlerResolver handlerResolver = this.getHandlerResolver();
        if (this.handlerResolver != null && this.getServiceName() != null) {
            object = new PortInfoImpl(string, qName, this.getServiceName());
            list = this.handlerResolver.getHandlerChain((PortInfo)object);
        } else {
            list = new ArrayList<Handler>();
        }
        if (string.toString().equals("http://schemas.xmlsoap.org/wsdl/soap/http") || string.toString().equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || string.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || string.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            object = new SOAPBindingImpl(list, string, this.getServiceName());
            Set<String> set = this.serviceContext.getRoles(qName);
            if (set != null) {
                ((SOAPBindingImpl)object).setRoles(set);
            }
            internalBindingProvider._setBinding((BindingImpl)object);
        } else if (string.equals("http://www.w3.org/2004/08/wsdl/http")) {
            internalBindingProvider._setBinding(new HTTPBindingImpl(list));
        }
    }

    private Dispatch createDispatchClazz(QName qName, Class clazz, Service.Mode mode) throws WebServiceException {
        PortInfoBase portInfoBase = this.dispatchPorts.get(qName);
        if (portInfoBase != null) {
            DispatchBase dispatchBase = new DispatchBase(portInfoBase, clazz, mode, this);
            this.setBindingOnProvider(dispatchBase, qName, dispatchBase._getBindingId());
            return dispatchBase;
        }
        throw new WebServiceException("Port must be defined in order to create Dispatch");
    }

    private Dispatch createDispatchJAXB(QName qName, JAXBContext jAXBContext, Service.Mode mode) throws WebServiceException {
        PortInfoBase portInfoBase = this.dispatchPorts.get(qName);
        if (portInfoBase != null) {
            DispatchBase dispatchBase = new DispatchBase(portInfoBase, jAXBContext, mode, this);
            this.setBindingOnProvider(dispatchBase, qName, dispatchBase._getBindingId());
            return dispatchBase;
        }
        throw new WebServiceException("Port must be defined in order to create Dispatch");
    }

    private URL getWsdlLocation() {
        return this.serviceContext.getWsdlContext().getWsdlLocation();
    }

    private Object buildEndpointIFProxy(QName qName, Class clazz) throws WebServiceException {
        Object object;
        EndpointIFContext endpointIFContext = this.completeEndpointIFContext(this.serviceContext, qName, clazz);
        RuntimeModel runtimeModel = endpointIFContext.getRuntimeContext().getModel();
        if (qName != null) {
            object = this.getWSDLBinding(qName);
            endpointIFContext.setBindingID(((Binding)object).getBindingId());
            runtimeModel.applyParameterBinding((Binding)object);
        }
        object = new EndpointIFInvocationHandler(clazz, endpointIFContext, this, this.getServiceName());
        this.setBindingOnProvider((InternalBindingProvider)object, qName, ((EndpointIFBase)object)._getBindingId());
        Object object2 = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, BindingProvider.class, BindingProviderProperties.class, StubBase.class}, (InvocationHandler)object);
        ((EndpointIFInvocationHandler)object).setProxy(object2);
        return (BindingProvider)object2;
    }

    Binding getWSDLBinding(QName qName) {
        return this.serviceContext.getWsdlContext().getWsdlBinding(this.serviceContext.getServiceName(), qName);
    }

    private EndpointIFContext completeEndpointIFContext(ServiceContext serviceContext, QName qName, Class clazz) {
        EndpointIFContext endpointIFContext = serviceContext.getEndpointIFContext(clazz.getName());
        WSDLContext wSDLContext = serviceContext.getWsdlContext();
        if (wSDLContext != null) {
            String string = wSDLContext.getEndpoint(serviceContext.getServiceName(), qName);
            String string2 = wSDLContext.getBindingID(serviceContext.getServiceName(), qName);
            endpointIFContext.setServiceName(serviceContext.getServiceName());
            endpointIFContext.setPortInfo(qName, string, string2);
        }
        return endpointIFContext;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(Boolean.TRUE);
            return thread;
        }
    }
}

