#include "setup.h"
#ifndef HAVE_LIBZ
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Fri Oct  8 10:11:25 2004
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _     \n"
"  Project                     ___| | | |  _ \\| |    \n"
"                             / __| | | | |_) | |    \n"
"                            | (__| |_| |  _ <| |___ \n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options] [URL...]\n"
"\n"
"DESCRIPTION\n"
"       curl is a tool to transfer data from or to a server, using\n"
"       one of the supported protocols (HTTP,  HTTPS,  FTP,  FTPS,\n"
, stdout);
 fputs(
"       GOPHER,  DICT,  TELNET,  LDAP  or  FILE).  The  command is\n"
"       designed to work without user interaction.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support,\n"
"       user  authentication,  ftp upload, HTTP post, SSL (https:)\n"
"       connections, cookies, file transfer resume  and  more.  As\n"
"       you  will see below, the amount of features will make your\n"
"       head spin!\n"
"\n"
"       curl is powered by libcurl for all  transfer-related  fea\n"
, stdout);
 fputs(
"       tures. See libcurl(3) for details.\n"
"\n"
"URL\n"
"       The  URL  syntax  is  protocol  dependent.  You'll  find a\n"
"       detailed description in RFC 2396.\n"
"\n"
"       You can specify multiple URLs or parts of URLs by  writing\n"
"       part sets within braces as in:\n"
"\n"
"        http://site.{one,two,three}.com\n"
"\n"
"       or  you  can get sequences of alphanumeric series by using\n"
"       [] as in:\n"
"\n"
"        ftp://ftp.numericals.com/file[1-100].txt\n"
"        ftp://ftp.numericals.com/file[001-100].txt    (with lead\n"
, stdout);
 fputs(
"       ing zeros)\n"
"        ftp://ftp.letters.com/file[a-z].txt\n"
"\n"
"       No  nesting  of  the sequences is supported at the moment,\n"
"       but you can use several ones next to each other:\n"
"\n"
"        http://any.org/archive[1996-1999]/vol[1-4]/part{a,b,c}.html\n"
"\n"
"       You  can  specify  any amount of URLs on the command line.\n"
"       They will be fetched in a sequential manner in the  speci\n"
"       fied order.\n"
"\n"
"       Curl  will attempt to re-use connections for multiple file\n"
, stdout);
 fputs(
"       transfers, so that getting many files from the same server\n"
"       will  not do multiple connects / handshakes. This improves\n"
"       speed. Of course this is only done on files specified on a\n"
"       single  command  line  and cannot be used between separate\n"
"       curl invokes.\n"
"\n"
"OPTIONS\n"
"       -a/--append\n"
"              (FTP) When used in an FTP upload,  this  will  tell\n"
"              curl  to append to the target file instead of over\n"
, stdout);
 fputs(
"              writing it. If the file doesn't exist, it  will  be\n"
"              created.\n"
"\n"
"              If  this  option is used twice, the second one will\n"
"              disable append mode again.\n"
"\n"
"       -A/--user-agent <agent string>\n"
"              (HTTP) Specify the User-Agent string to send to the\n"
"              HTTP  server.  Some badly done CGIs fail if its not\n"
"              set to \"Mozilla/4.0\".   To  encode  blanks  in  the\n"
"              string,  surround  the  string  with  single  quote\n"
, stdout);
 fputs(
"              marks.  This can also be set with  the  -H/--header\n"
"              option of course.\n"
"\n"
"              If  this option is set more than once, the last one\n"
"              will be the one that's used.\n"
"\n"
"       --anyauth\n"
"              (HTTP) Tells  curl  to  figure  out  authentication\n"
"              method  by  itself, and use the most secure one the\n"
"              remote site claims it supports.  This  is  done  by\n"
"              first  doing  a  request and checking the response-\n"
, stdout);
 fputs(
"              headers, thus inducing an extra network round-trip.\n"
"              This  is used instead of setting a specific authen\n"
"              tication method, which you  can  do  with  --basic,\n"
"              --digest,   --ntlm,   and  --negotiate.  (Added  in\n"
"              7.10.6)\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       -b/--cookie <name=data>\n"
"              (HTTP)  Pass  the  data  to  the  HTTP  server as a\n"
, stdout);
 fputs(
"              cookie.  It  is  supposedly  the  data   previously\n"
"              received  from  the server in a \"Set-Cookie:\" line.\n"
"              The data should be  in  the  format  \"NAME1=VALUE1;\n"
"              NAME2=VALUE2\".\n"
"\n"
"              If no '=' letter is used in the line, it is treated\n"
"              as a filename to  use  to  read  previously  stored\n"
"              cookie  lines  from,  which  should be used in this\n"
"              session if they match. Using this method also acti\n"
, stdout);
 fputs(
"              vates  the  \"cookie  parser\"  which  will make curl\n"
"              record incoming cookies too, which may be handy  if\n"
"              you're   using   this   in   combination  with  the\n"
"              -L/--location option. The file format of  the  file\n"
"              to  read  cookies from should be plain HTTP headers\n"
"              or the Netscape/Mozilla cookie file format.\n"
"\n"
"              NOTE that the file specified  with  -b/--cookie  is\n"
, stdout);
 fputs(
"              only  used  as  input. No cookies will be stored in\n"
"              the file. To store cookies, use the -c/--cookie-jar\n"
"              option or you could even save the HTTP headers to a\n"
"              file using -D/--dump-header!\n"
"\n"
"              If this option is set more than once, the last  one\n"
"              will be the one that's used.\n"
"\n"
"       -B/--use-ascii\n"
"              Use ASCII transfer when getting an FTP file or LDAP\n"
, stdout);
 fputs(
"              info. For FTP, this can also be enforced  by  using\n"
"              an URL that ends with \";type=A\". This option causes\n"
"              data sent to stdout to be in text  mode  for  win32\n"
"              systems.\n"
"\n"
"              If  this  option is used twice, the second one will\n"
"              disable ASCII usage.\n"
"\n"
"       --basic\n"
"              (HTTP) Tells curl to use HTTP Basic authentication.\n"
"              This  is  the  default  and  this option is usually\n"
, stdout);
 fputs(
"              pointless, unless you use it to override  a  previ\n"
"              ously  set option that sets a different authentica\n"
"              tion method (such as --ntlm, --digest and --negoti\n"
"              ate). (Added in 7.10.6)\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (SSL) Specifies which ciphers to use in the connec\n"
, stdout);
 fputs(
"              tion.  The  list  of  ciphers  must  be using valid\n"
"              ciphers. Read up on SSL cipher list details on this\n"
"              URL: http://www.openssl.org/docs/apps/ciphers.html\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will override the others.\n"
"\n"
"       --compressed\n"
"              (HTTP) Request a compressed response using  one  of\n"
"              the  algorithms  libcurl  supports,  and return the\n"
, stdout);
 fputs(
"              uncompressed document.  If this option is used  and\n"
"              the server sends an unsupported encoding, Curl will\n"
"              report an error.\n"
"\n"
"              If this option is used several times,  each  occur\n"
"              rence will toggle it on/off.\n"
"\n"
"       --connect-timeout <seconds>\n"
"              Maximum  time in seconds that you allow the connec\n"
"              tion to the server to take.  This only  limits  the\n"
, stdout);
 fputs(
"              connection  phase,  once  curl  has  connected this\n"
"              option is of no more use. See  also  the  -m/--max-\n"
"              time option.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -c/--cookie-jar <file name>\n"
"              Specify to which file you want curl  to  write  all\n"
"              cookies  after  a  completed operation. Curl writes\n"
"              all cookies previously read from a  specified  file\n"
, stdout);
 fputs(
"              as   well  as  all  cookies  received  from  remote\n"
"              server(s). If no cookies are known, no file will be\n"
"              written.   The  file  will  be  written  using  the\n"
"              Netscape cookie file format. If you  set  the  file\n"
"              name  to  a  single  dash, \"-\", the cookies will be\n"
"              written to stdout.\n"
"\n"
"              NOTE If the cookie jar can't be created or  written\n"
"              to,  the  whole  curl  operation won't fail or even\n"
, stdout);
 fputs(
"              report an error clearly. Using -v will get a  warn\n"
"              ing  displayed,  but that is the only visible feed\n"
"              back you get about this possibly lethal  situation.\n"
"              If  this  option  is  used  several times, the last\n"
"              specfied file name will be used.\n"
"\n"
"       -C/--continue-at <offset>\n"
"              Continue/Resume a previous  file  transfer  at  the\n"
"              given  offset. The given offset is the exact number\n"
, stdout);
 fputs(
"              of bytes that will  be  skipped  counted  from  the\n"
"              beginning  of  the  source file before it is trans\n"
"              fered to the destination.  If  used  with  uploads,\n"
"              the  ftp  server  command  SIZE will not be used by\n"
"              curl.\n"
"\n"
"              Use \"-C -\" to tell curl to automatically  find  out\n"
"              where/how  to resume the transfer. It then uses the\n"
"              given output/input files to figure that out.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"       --create-dirs\n"
"              When  used  in conjunction with the -o option, curl\n"
"              will create the necessary local directory hierarchy\n"
"              as  needed.  This option creates the dirs mentioned\n"
"              with the -o option, nothing else. If  the  -o  file\n"
"              name uses no dir or if the dirs it mentions already\n"
"              exist, no dir will be created.\n"
"\n"
, stdout);
 fputs(
"              To create remote directories when  using  FTP,  try\n"
"              --ftp-create-dirs.\n"
"\n"
"       --crlf (FTP)  Convert LF to CRLF in upload. Useful for MVS\n"
"              (OS/390).\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable crlf converting.\n"
"\n"
"       -d/--data <data>\n"
"              (HTTP)  Sends  the specified data in a POST request\n"
"              to the HTTP server, in a way that can emulate as if\n"
, stdout);
 fputs(
"              a  user  has  filled in a HTML form and pressed the\n"
"              submit button. Note that the data is  sent  exactly\n"
"              as  specified  with  no  extra processing (with all\n"
"              newlines cut off).  The  data  is  expected  to  be\n"
"              \"url-encoded\".  This  will  cause  curl to pass the\n"
"              data to the server using the content-type  applica\n"
"              tion/x-www-form-urlencoded.  Compare  to -F/--form.\n"
, stdout);
 fputs(
"              If this option is used more than once on  the  same\n"
"              command  line,  the  data  pieces specified will be\n"
"              merged together with a separating  &-letter.  Thus,\n"
"              using  '-d name=daniel -d skill=lousy' would gener\n"
"              ate    a    post    chunk    that    looks     like\n"
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If  you  start the data with the letter @, the rest\n"
, stdout);
 fputs(
"              should be a file name to read the data from,  or  -\n"
"              if  you want curl to read the data from stdin.  The\n"
"              contents of the file must already  be  url-encoded.\n"
"              Multiple  files can also be specified. Posting data\n"
"              from a file named 'foobar' would thus be done  with\n"
"              --data @foobar\".\n"
"\n"
"              To  post data purely binary, you should instead use\n"
"              the --data-binary option.\n"
"\n"
, stdout);
 fputs(
"              -d/--data is the same as --data-ascii.\n"
"\n"
"              If this option is used several times, the ones fol\n"
"              lowing the first will append data.\n"
"\n"
"       --data-ascii <data>\n"
"              (HTTP) This is an alias for the -d/--data option.\n"
"\n"
"              If this option is used several times, the ones fol\n"
"              lowing the first will append data.\n"
"\n"
"       --data-binary <data>\n"
"              (HTTP) This posts  data  in  a  similar  manner  as\n"
, stdout);
 fputs(
"              --data-ascii  does, although when using this option\n"
"              the entire context of the posted data is  kept  as-\n"
"              is.  If  you want to post a binary file without the\n"
"              strip-newlines feature of the --data-ascii  option,\n"
"              this is for you.\n"
"\n"
"              If this option is used several times, the ones fol\n"
"              lowing the first will append data.\n"
"\n"
"       --digest\n"
"              (HTTP) Enables HTTP Digest authentication. This  is\n"
, stdout);
 fputs(
"              a  authentication  that  prevents the password from\n"
"              being sent over the wire in clear text. Use this in\n"
"              combination with the normal -u/--user option to set\n"
"              user name and password. See also --ntlm,  --negoti\n"
"              ate  and  --anyauth  for related options. (Added in\n"
"              curl 7.10.6)\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       --disable-eprt\n"
, stdout);
 fputs(
"              (FTP)  Tell curl to disable the use of the EPRT and\n"
"              LPRT commands when doing active FTP transfers. Curl\n"
"              will  normally  always  first  attempt to use EPRT,\n"
"              then LPRT before using PORT, but with this  option,\n"
"              it  will  use  PORT  right  away. EPRT and LPRT are\n"
"              extensions to the original FTP  protocol,  may  not\n"
"              work  on  all servers but enable more functionality\n"
, stdout);
 fputs(
"              in a better way than the traditional PORT  command.\n"
"              (Aded in 7.10.5)\n"
"\n"
"              If  this  option is used several times, each occur\n"
"              rence will toggle this on/off.\n"
"\n"
"       --disable-epsv\n"
"              (FTP) Tell curl to disable the use of the EPSV com\n"
"              mand  when  doing  passive FTP transfers. Curl will\n"
"              normally always first attempt to  use  EPSV  before\n"
"              PASV,  but  with this option, it will not try using\n"
, stdout);
 fputs(
"              EPSV.\n"
"\n"
"              If this option is used several times,  each  occur\n"
"              rence will toggle this on/off.\n"
"\n"
"       -D/--dump-header <file>\n"
"              Write the protocol headers to the specified file.\n"
"\n"
"              This  option is handy to use when you want to store\n"
"              the headers that a HTTP site sends to you.  Cookies\n"
"              from  the  headers  could  then be read in a second\n"
"              curl invoke by using the  -b/--cookie  option!  The\n"
, stdout);
 fputs(
"              -c/--cookie-jar  option  is however a better way to\n"
"              store cookies.\n"
"\n"
"              When used on FTP, the ftp server response lines are\n"
"              considered  being  \"headers\"  and  thus  are  saved\n"
"              there.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -e/--referer <URL>\n"
"              (HTTP)  Sends the \"Referer Page\" information to the\n"
, stdout);
 fputs(
"              HTTP  server.  This  can  also  be  set  with   the\n"
"              -H/--header   flag   of  course.   When  used  with\n"
"              -L/--location you can append \";auto\" to the referer\n"
"              URL to make curl automatically set the previous URL\n"
"              when it follows a  Location:  header.  The  \";auto\"\n"
"              string  can be used alone, even if you don't set an\n"
"              initial referer.\n"
"\n"
"              If this option is used several times, the last  one\n"
, stdout);
 fputs(
"              will be used.\n"
"       --environment\n"
"              (RISC  OS  ONLY)  Sets a range of environment vari\n"
"              ables, using the names the -w option  supports,  to\n"
"              easier allow extraction of useful information after\n"
"              having run curl.\n"
"\n"
"              If this option is used several times,  each  occur\n"
"              rence will toggle this on/off.\n"
"\n"
"       --egd-file <file>\n"
"              (HTTPS)  Specify the path name to the Entropy Gath\n"
, stdout);
 fputs(
"              ering Daemon socket. The socket is used to seed the\n"
"              random  engine  for  SSL  connections. See also the\n"
"              --random-file option.\n"
"\n"
"       -E/--cert <certificate[:password]>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              file  when  getting a file with HTTPS. The certifi\n"
"              cate must be in PEM format.  If the optional  pass\n"
"              word isn't specified, it will be queried for on the\n"
, stdout);
 fputs(
"              terminal. Note that this certificate is the private\n"
"              key and the private certificate concatenated!\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --cert-type <type>\n"
"              (SSL) Tells curl what certificate type the provided\n"
"              certificate  is in. PEM, DER and ENG are recognized\n"
"              types.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
, stdout);
 fputs(
"       --cacert <CA certificate>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              file to verify the peer. The file may contain  mul\n"
"              tiple  CA  certificates. The certificate(s) must be\n"
"              in PEM format.\n"
"\n"
"              curl  recognizes  the  environment  variable  named\n"
"              'CURL_CA_BUNDLE' if that is set, and uses the given\n"
"              path as a path to a CA  cert  bundle.  This  option\n"
"              overrides that variable.\n"
"\n"
, stdout);
 fputs(
"              The windows version of curl will automatically look\n"
"              for a CA  certs  file  named  curl-ca-bundle.crt,\n"
"              either in the same directory as curl.exe, or in the\n"
"              Current Working Directory, or in any  folder  along\n"
"              your PATH.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --capath <CA certificate directory>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
, stdout);
 fputs(
"              directory to verify the peer. The certificates must\n"
"              be in PEM format, and the directory must have  been\n"
"              processed  using the c_rehash utility supplied with\n"
"              openssl. Using --capath  can  allow  curl  to  make\n"
"              https  connections much more efficiently than using\n"
"              --cacert if the --cacert file contains many CA cer\n"
"              tificates.\n"
"\n"
"              If  this option is used several times, the last one\n"
, stdout);
 fputs(
"              will be used.\n"
"\n"
"       -f/--fail\n"
"              (HTTP) Fail silently (no output at all)  on  server\n"
"              errors.  This  is  mostly  done like this to better\n"
"              enable scripts  etc  to  better  deal  with  failed\n"
"              attempts.  In normal cases when a HTTP server fails\n"
"              to deliver a document, it returns a  HTML  document\n"
"              stating  so  (which  often  also  describes why and\n"
, stdout);
 fputs(
"              more). This flag will prevent curl from  outputting\n"
"              that and fail silently instead.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-create-dirs\n"
"              (FTP) When an FTP URL/operation uses  a  path  that\n"
"              doesn't currently exist on the server, the standard\n"
"              behavior of curl is to  fail.  Using  this  option,\n"
, stdout);
 fputs(
"              curl  will instead attempt to create missing direc\n"
"              tories. (Added in 7.10.7)\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-pasv\n"
"              (FTP) Use PASV when transfering. PASV is the inter\n"
"              nal default behavior, but using this option can  be\n"
"              used  to  override  a  previos  --ftp-port  option.\n"
"              (Added in 7.11.0)\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-ssl\n"
"              (FTP)   Make  the  FTP  connection  switch  to  use\n"
"              SSL/TLS. (Added in 7.11.0)\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable this.\n"
"\n"
"       -F/--form <name=content>\n"
"              (HTTP)  This  lets curl emulate a filled in form in\n"
"              which a user has pressed the  submit  button.  This\n"
, stdout);
 fputs(
"              causes  curl  to  POST  data using the Content-Type\n"
"              multipart/form-data  according  to  RFC1867.   This\n"
"              enables uploading of binary files etc. To force the\n"
"              'content' part to be be a  file,  prefix  the  file\n"
"              name  with  an @ sign. To just get the content part\n"
"              from a file, prefix the file name with  the  letter\n"
"              <.  The  difference  between @ and < is then that @\n"
, stdout);
 fputs(
"              makes a file get attached in the  post  as  a  file\n"
"              upload, while the < makes a text field and just get\n"
"              the contents for that text field from a file.\n"
"\n"
"              Example, to send your password file to the  server,\n"
"              where  'password'  is the name of the form-field to\n"
"              which /etc/passwd will be the input:\n"
"\n"
"              curl -F password=@/etc/passwd www.mypasswords.com\n"
"\n"
, stdout);
 fputs(
"              To read the file's content from stdin insted  of  a\n"
"              file,  use  -  where  the file name should've been.\n"
"              This goes for both @ and < constructs.\n"
"\n"
"              You can also tell curl what Content-Type to use  by\n"
"              using 'type=', in a manner similar to:\n"
"\n"
"              curl -F \"web=@index.html;type=text/html\" url.com\n"
"\n"
"              or\n"
"\n"
"              curl -F \"name=daniel;type=text/foo\" url.com\n"
"\n"
, stdout);
 fputs(
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       -g/--globoff\n"
"              This option switches off the \"URL globbing parser\".\n"
"              When you set this option, you can specify URLs that\n"
"              contain  the letters {}[] without having them being\n"
"              interpreted by curl itself. Note that these letters\n"
"              are  not  normal legal URL contents but they should\n"
, stdout);
 fputs(
"              be encoded according to the URI standard.\n"
"\n"
"       -G/--get\n"
"              When used, this option will make all data specified\n"
"              with  -d/--data  or  --data-binary  to be used in a\n"
"              HTTP GET request instead of the POST  request  that\n"
"              otherwise  would be used. The data will be appended\n"
"              to the URL with a '?'  separator.\n"
"\n"
"              If used in combination with -I, the POST data  will\n"
, stdout);
 fputs(
"              instead be appended to the URL with a HEAD request.\n"
"\n"
"              If used multiple times, nothing special happens.\n"
"\n"
"       -h/--help\n"
"              Usage help.\n"
"\n"
"       -H/--header <header>\n"
"              (HTTP) Extra header to use when getting a web page.\n"
"              You  may  specify any number of extra headers. Note\n"
"              that if you should add a custom header that has the\n"
"              same  name  as  one of the internal ones curl would\n"
, stdout);
 fputs(
"              use,  your  externally  set  header  will  be  used\n"
"              instead  of  the  internal  one. This allows you to\n"
"              make even trickier stuff than curl  would  normally\n"
"              do.  You  should not replace internally set headers\n"
"              without knowing perfectly well what  you're  doing.\n"
"              Replacing  an internal header with one without con\n"
"              tent on the right side of the  colon  will  prevent\n"
, stdout);
 fputs(
"              that header from appearing.\n"
"\n"
"              See   also  the  -A/--user-agent  and  -e/--referer\n"
"              options.\n"
"\n"
"              This  option  can  be  used   multiple   times   to\n"
"              add/replace/remove multiple headers.\n"
"\n"
"       -i/--include\n"
"              (HTTP)  Include  the HTTP-header in the output. The\n"
"              HTTP-header includes things like server-name,  date\n"
"              of the document, HTTP-version and more...\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable header include.\n"
"\n"
"       --interface <name>\n"
"              Perform an operation using a  specified  interface.\n"
"              You  can  enter  interface name, IP address or host\n"
"              name. An example could look like:\n"
"\n"
"               curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -I/--head\n"
, stdout);
 fputs(
"              (HTTP/FTP/FILE)  Fetch  the HTTP-header only! HTTP-\n"
"              servers feature the command HEAD which this uses to\n"
"              get nothing but the header of a document. When used\n"
"              on a FTP or FILE file, curl displays the file  size\n"
"              and last modification time only.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable header only.\n"
"\n"
"       -j/--junk-session-cookies\n"
, stdout);
 fputs(
"              (HTTP) When curl is told to  read  cookies  from  a\n"
"              given  file,  this  option will make it discard all\n"
"              \"session cookies\". This will basicly have the  same\n"
"              effect  as  if  a  new  session is started. Typical\n"
"              browsers  always  discard  session   cookies   when\n"
"              they're closed down. (Added in 7.9.7)\n"
"\n"
"              If  this  option is used several times, each occur\n"
"              rence will toggle this on/off.\n"
"\n"
, stdout);
 fputs(
"       -k/--insecure\n"
"              (SSL) This option explicitly allows curl to perform\n"
"              \"insecure\"  SSL connections and transfers. Starting\n"
"              with  curl  7.10,  all  SSL  connections  will   be\n"
"              attempted  to  be  made secure by using the CA cer\n"
"              tificate bundle installed by  default.  This  makes\n"
"              all   connections  considered  \"insecure\"  to  fail\n"
"              unless -k/--insecure is used.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second time  will\n"
"              again disable it.\n"
"\n"
"       --key <key>\n"
"              (SSL)  Private key file name. Allows you to provide\n"
"              your private key in this separate file.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       --key-type <type>\n"
"              (SSL)  Private  key  file  type. Specify which type\n"
"              your --key provided private key is.  DER,  PEM  and\n"
, stdout);
 fputs(
"              ENG are supported.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --krb4 <level>\n"
"              (FTP) Enable kerberos4 authentication and use.  The\n"
"              level must be entered and should be one of 'clear',\n"
"              'safe', 'confidential' or 'private'. Should you use\n"
"              a  level  that  is not one of these, 'private' will\n"
"              instead be used.\n"
"\n"
, stdout);
 fputs(
"              This option requiures that the  library  was  built\n"
"              with  kerberos4  support.  This is not very common.\n"
"              Use -V/--version to see if your curl supports it.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -K/--config <config file>\n"
"              Specify  which  config  file to read curl arguments\n"
"              from. The config file is a text file in which  com\n"
, stdout);
 fputs(
"              mand  line arguments can be written which then will\n"
"              be used as if they were written on the actual  com\n"
"              mand  line.  Options  and  their parameters must be\n"
"              specified on the same  config  file  line.  If  the\n"
"              parameter is to contain white spaces, the parameter\n"
"              must be inclosed within quotes.  If the first  col\n"
"              umn  of  a config line is a '#' character, the rest\n"
, stdout);
 fputs(
"              of the line will be treated as a comment.\n"
"\n"
"              Specify the filename as '-' to make curl  read  the\n"
"              file from stdin.\n"
"\n"
"              Note that to be able to specify a URL in the config\n"
"              file, you  need  to  specify  it  using  the  --url\n"
"              option,  and  not  by simply writing the URL on its\n"
"              own line. So, it could look similar to this:\n"
"\n"
"              url = \"http://curl.haxx.se/docs/\"\n"
"\n"
, stdout);
 fputs(
"              This option can be used multiple times.\n"
"\n"
"       --limit-rate <speed>\n"
"              Specify the maximum transfer rate you want curl  to\n"
"              use.  This  feature is useful if you have a limited\n"
"              pipe and you'd like  your  transfer  not  use  your\n"
"              entire bandwidth.\n"
"\n"
"              The given speed is measured in bytes/second, unless\n"
"              a suffix is appended.  Appending 'k'  or  'K'  will\n"
, stdout);
 fputs(
"              count  the  number as kilobytes, 'm' or M' makes it\n"
"              megabytes while 'g'  or  'G'  makes  it  gigabytes.\n"
"              Examples: 200K, 3m and 1G.\n"
"\n"
"              If  you are also using the -Y/--speed-limit option,\n"
"              that option will take precedence and might  cripple\n"
"              the  rate-limiting  slightly,  to  help keeping the\n"
"              speed-limit logic working.\n"
"\n"
"              This option was introduced in curl 7.10.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -l/--list-only\n"
"              (FTP)  When  listing  an FTP directory, this switch\n"
"              forces a name-only view.  Especially useful if  you\n"
"              want to machine-parse the contents of an FTP direc\n"
"              tory since the normal directory view doesn't use  a\n"
"              standard look or format.\n"
"\n"
"              This  option causes an FTP NLST command to be sent.\n"
, stdout);
 fputs(
"              Some FTP servers list only files in their  response\n"
"              to  NLST;  they  do  not include subdirectories and\n"
"              symbolic links.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable list only.\n"
"\n"
"       -L/--location\n"
"              (HTTP/HTTPS)   If   the  server  reports  that  the\n"
"              requested page has a different location  (indicated\n"
"              with  the header line Location:) this flag will let\n"
, stdout);
 fputs(
"              curl attempt to reattempt the get on the new place.\n"
"              If  used  together  with -i/--include or -I/--head,\n"
"              headers from all requested pages will be shown.  If\n"
"              authentication  is  used,  curl  will only send its\n"
"              credentials to the initial host, so if  a  redirect\n"
"              takes  curl to a different host, it won't intercept\n"
"              the user+password. See also  --location-trusted  on\n"
"              how to change this.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable location following.\n"
"\n"
"       --location-trusted\n"
"              (HTTP/HTTPS) Like  -L/--location,  but  will  allow\n"
"              sending  the  name + password to all hosts that the\n"
"              site may redirect to. This may or may not introduce\n"
"              a  security  breach  if the site redirects you do a\n"
"              site to which you'll send your authentication  info\n"
, stdout);
 fputs(
"              (which  is  plaintext  in  the  case  of HTTP Basic\n"
"              authentication).\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable location following.\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify  the  maximum  size (in bytes) of a file to\n"
"              download. If the file requested is larger than this\n"
"              value,  the  transfer  will not start and curl will\n"
"              return with exit code 63.\n"
"\n"
, stdout);
 fputs(
"              NOTE: The file size is not always  known  prior  to\n"
"              download,  and  for  such  files this option has no\n"
"              effect even if the  file  transfer  ends  up  being\n"
"              larger  than  this  given limit. This concerns both\n"
"              FTP and HTTP transfers.\n"
"       -m/--max-time <seconds>\n"
"              Maximum time in seconds that you  allow  the  whole\n"
"              operation  to  take.  This is useful for preventing\n"
, stdout);
 fputs(
"              your batch jobs from hanging for hours due to  slow\n"
"              networks  or  links  going down.  This doesn't work\n"
"              fully in win32 systems.  See  also  the  --connect-\n"
"              timeout option.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -M/--manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       -n/--netrc\n"
"              Makes curl scan the .netrc file in the user's  home\n"
, stdout);
 fputs(
"              directory for login name and password. This is typ\n"
"              ically used for ftp on unix.  If  used  with  http,\n"
"              curl  will enable user authentication. See netrc(4)\n"
"              or ftp(1) for details on the file format. Curl will\n"
"              not  complain if that file hasn't the right permis\n"
"              sions (it should not be world nor group  readable).\n"
"              The environment variable \"HOME\" is used to find the\n"
"              home directory.\n"
"\n"
, stdout);
 fputs(
"              A quick and very simple example of how to  setup  a\n"
"              .netrc   to  allow  curl  to  ftp  to  the  machine\n"
"              host.domain.com with user name 'myself'  and  pass\n"
"              word\n"
"\n"
"              machine   host.domain.com   login  myself  password\n"
"              secret\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable netrc usage.\n"
"\n"
"       --netrc-optional\n"
"              Very  similar to --netrc, but this option makes the\n"
, stdout);
 fputs(
"              .netrc usage optional  and  not  mandatory  as  the\n"
"              --netrc does.\n"
"\n"
"       --negotiate\n"
"              (HTTP)  Enables  GSS-Negotiate  authentication. The\n"
"              GSS-Negotiate method was designed by Microsoft  and\n"
"              is  used  in their web aplications. It is primarily\n"
"              meant as a support for Kerberos5 authentication but\n"
"              may  be also used along with another authentication\n"
, stdout);
 fputs(
"              methods. For more information see IETF draft draft-\n"
"              brezak-spnego-http-04.txt. (Added in 7.10.6)\n"
"\n"
"              This  option  requiures  that the library was built\n"
"              with GSSAPI support. This is not very  common.  Use\n"
"              -V/--version  to  see if your version supports GSS-\n"
"              Negotiate.\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       -N/--no-buffer\n"
, stdout);
 fputs(
"              Disables  the  buffering  of  the output stream. In\n"
"              normal work situations, curl will  use  a  standard\n"
"              buffered  output  stream  that will have the effect\n"
"              that it will output the data in chunks, not  neces\n"
"              sarily  exactly  when the data arrives.  Using this\n"
"              option will disable that buffering.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              switch on buffering.\n"
"\n"
, stdout);
 fputs(
"       --ntlm (HTTP)   Enables   NTLM  authentication.  The  NTLM\n"
"              authentication method was designed by Microsoft and\n"
"              is  used  by  IIS  web servers. It is a proprietary\n"
"              protocol, reversed engineered by clever people  and\n"
"              implemented  in  curl  based on their efforts. This\n"
"              kind of behavior should not be endorsed, you should\n"
"              encourage  everyone  who  uses  NTLM to switch to a\n"
, stdout);
 fputs(
"              public   and   documented   authentication   method\n"
"              instead. Such as Digest. (Added in 7.10.6)\n"
"\n"
"              If you want to enable NTLM for your proxy authenti\n"
"              cation, then use --proxy-ntlm.\n"
"\n"
"              This option requiures that the  library  was  built\n"
"              with  SSL  support. Use -V/--version to see if your\n"
"              curl supports NTLM.\n"
"\n"
"              If this option is used several times, the following\n"
, stdout);
 fputs(
"              occurrences make no difference.\n"
"\n"
"       -o/--output <file>\n"
"              Write  output  to  <file> instead of stdout. If you\n"
"              are using {} or [] to fetch multiple documents, you\n"
"              can  use  '#'  followed  by  a number in the <file>\n"
"              specifier. That variable will be replaced with  the\n"
"              current string for the URL being fetched. Like in:\n"
"\n"
"                curl http://{one,two}.site.com -o \"file_#1.txt\"\n"
"\n"
, stdout);
 fputs(
"              or use several variables like:\n"
"\n"
"                curl http://{site,host}.host[1-5].com -o \"#1_#2\"\n"
"\n"
"              You  may  use this option as many times as you have\n"
"              number of URLs.\n"
"\n"
"              See also the --create-dirs  option  to  create  the\n"
"              local directories dynamically.\n"
"\n"
"       -O/--remote-name\n"
"              Write  output to a local file named like the remote\n"
"              file we get. (Only the file part of the remote file\n"
, stdout);
 fputs(
"              is used, the path is cut off.)\n"
"\n"
"              You  may  use this option as many times as you have\n"
"              number of URLs.\n"
"       --pass <phrase>\n"
"              (SSL) Pass phrase for the private key\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"       --proxy-basic\n"
"              Tells  curl  to  use HTTP Basic authentication when\n"
"              communicating with the given proxy. Use --basic for\n"
, stdout);
 fputs(
"              enabling  HTTP  Basic  with a remote host. Basic is\n"
"              the default authentication method  curl  uses  with\n"
"              proxies.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable proxy HTTP Basic authentication.\n"
"\n"
"       --proxy-digest\n"
"              Tells curl to use HTTP Digest  authentication  when\n"
"              communicating  with  the  given proxy. Use --digest\n"
"              for enabling HTTP Digest with a remote host.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable proxy HTTP Digest.\n"
"\n"
"       --proxy-ntlm\n"
"              Tells  curl  to  use  HTTP NTLM authentication when\n"
"              communicating with the given proxy. Use --ntlm  for\n"
"              enabling NTLM with a remote host.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable proxy HTTP NTLM.\n"
"\n"
"       -p/--proxytunnel\n"
, stdout);
 fputs(
"              When an  HTTP  proxy  is  used  (-x/--proxy),  this\n"
"              option  will cause non-HTTP protocols to attempt to\n"
"              tunnel through the proxy instead of merely using it\n"
"              to  do HTTP-like operations. The tunnel approach is\n"
"              made  with  the  HTTP  proxy  CONNECT  request  and\n"
"              requires  that  the  proxy allows direct connect to\n"
"              the remote port number curl wants to tunnel through\n"
"              to.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable proxy tunnel.\n"
"\n"
"       -P/--ftp-port <address>\n"
"              (FTP) Reverses the  initiator/listener  roles  when\n"
"              connecting with ftp. This switch makes Curl use the\n"
"              PORT command instead of  PASV.  In  practice,  PORT\n"
"              tells  the server to connect to the client's speci\n"
"              fied address and port, while PASV asks  the  server\n"
, stdout);
 fputs(
"              for an ip address and port to connect to. <address>\n"
"              should be one of:\n"
"\n"
"              interface\n"
"                     i.e \"eth0\" to specify which  interface's  IP\n"
"                     address you want to use  (Unix only)\n"
"\n"
"              IP address\n"
"                     i.e  \"192.168.10.1\" to specify exact IP num\n"
"                     ber\n"
"\n"
"              host name\n"
"                     i.e \"my.host.domain\" to specify machine\n"
"\n"
, stdout);
 fputs(
"              -      (any single-letter string) to make  it  pick\n"
"                     the machine's default\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used. Disable the use of PORT with --ftp-pasv. Disable the\n"
"       attempt  to  use the EPRT command instead of PORT by using\n"
"       --disable-eprt. EPRT is really PORT++.\n"
"\n"
"       -q     If used as the first parameter on the command line,\n"
"              the $HOME/.curlrc file will not be read and used as\n"
, stdout);
 fputs(
"              a config file.\n"
"\n"
"       -Q/--quote <comand>\n"
"              (FTP) Send an arbitrary command to the  remote  FTP\n"
"              server. Quote commands are sent BEFORE the transfer\n"
"              is taking place. To make commands take place  after\n"
"              a successful transfer, prefix them with a dash '-'.\n"
"              You may specify any amount of commands  to  be  run\n"
"              before  and  after  the  transfer.  If  the  server\n"
, stdout);
 fputs(
"              returns failure for one of the commands, the entire\n"
"              operation  will be aborted. You must send syntacti\n"
"              cally correct FTP commands as RFC959 defines.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --random-file <file>\n"
"              (HTTPS) Specify the path name  to  file  containing\n"
"              what will be considered as random data. The data is\n"
"              used to seed the random engine for SSL connections.\n"
, stdout);
 fputs(
"              See also the --egd-file option.\n"
"\n"
"       -r/--range <range>\n"
"              (HTTP/FTP)  Retrieve  a  byte  range (i.e a partial\n"
"              document) from a HTTP/1.1 or FTP server. Ranges can\n"
"              be specified in a number of ways.\n"
"\n"
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
"              -500      specifies the last 500 bytes\n"
"\n"
"              9500      specifies  the bytes from offset 9500 and\n"
, stdout);
 fputs(
"                        forward\n"
"\n"
"              0-0,-1    specifies  the  first   and   last   byte\n"
"                        only(*)(H)\n"
"\n"
"              500-700,600-799\n"
"                        specifies 300 bytes from offset 500(H)\n"
"\n"
"              100-199,500-599\n"
"                        specifies    two   separate   100   bytes\n"
"                        ranges(*)(H)\n"
"\n"
"       (*) = NOTE that this will cause the server to reply with a\n"
"       multipart response!\n"
"\n"
, stdout);
 fputs(
"       You should also be aware that many HTTP/1.1 servers do not\n"
"       have this feature enabled, so that when you attempt to get\n"
"       a range, you'll instead get the whole document.\n"
"\n"
"       FTP range downloads only support the simple syntax 'start-\n"
"       stop' (optionally with one of  the  numbers  omitted).  It\n"
"       depends on the non-RFC command SIZE.\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used.\n"
"\n"
"       -R/--remote-time\n"
, stdout);
 fputs(
"              When used, this will make libcurl attempt to figure\n"
"              out  the  timestamp of the remote file, and if that\n"
"              is available make the  local  file  get  that  same\n"
"              timestamp.\n"
"\n"
"              If  this option is used twice, the second time dis\n"
"              ables this again.\n"
"\n"
"       -s/--silent\n"
"              Silent mode. Don't show  progress  meter  or  error\n"
"              messages.  Makes Curl mute.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable mute.\n"
"\n"
"       -S/--show-error\n"
"              When used with -s it makes curl show error  message\n"
"              if it fails.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable show error.\n"
"\n"
"       --socks <host[:port]>\n"
"              Use the specified SOCKS5 proxy. If the port  number\n"
"              is  not  specified,  it  is  assumed  at port 1080.\n"
, stdout);
 fputs(
"              (Option added in 7.11.1)\n"
"\n"
"              This  option  overrides   any   previous   use   of\n"
"              -x/--proxy, as they are mutually exclusive.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --stderr <file>\n"
"              Redirect all writes to stderr to the specified file\n"
"              instead.  If  the  file  name is a plain '-', it is\n"
"              instead written to stdout. This option has no point\n"
, stdout);
 fputs(
"              when  you're  using a shell with decent redirecting\n"
"              capabilities.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"       --tcp-nodelay\n"
"              Turn   on   the   TCP_NODELAY   option.   See   the\n"
"              curl_easy_setopt(3) man page for details about this\n"
"              option. (Added in 7.11.2)\n"
"\n"
"              If  this  option  is used several times, each occu\n"
"              rance toggles this on/off.\n"
"\n"
, stdout);
 fputs(
"       -t/--telnet-option <OPT=val>\n"
"              Pass options  to  the  telnet  protocol.  Supported\n"
"              options are:\n"
"\n"
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       -T/--upload-file <file>\n"
"              This  transfers  the  specified  local  file to the\n"
"              remote URL. If there is no file part in the  speci\n"
, stdout);
 fputs(
"              fied  URL,  Curl  will  append the local file name.\n"
"              NOTE that you must use a trailing  /  on  the  last\n"
"              directory  to really prove to Curl that there is no\n"
"              file name or curl will think that your last  direc\n"
"              tory name is the remote file name to use. That will\n"
"              most likely cause the upload operation to fail.  If\n"
"              this  is  used on a http(s) server, the PUT command\n"
"              will be used.\n"
"\n"
, stdout);
 fputs(
"              Use the file name \"-\" (a single dash) to use  stdin\n"
"              instead of a given file.\n"
"\n"
"              Before  7.10.8,  when  this option was used several\n"
"              times, the last one was used.\n"
"\n"
"              In curl 7.10.8 and later, you can  specify  one  -T\n"
"              for  each  URL  on  the command line. Each -T + URL\n"
"              pair specifies what to upload and  to  where.  curl\n"
"              also  supports \"globbing\" of the -T argument, mean\n"
, stdout);
 fputs(
"              ing that you can upload multiple files to a  single\n"
"              URL  by using the same URL globbing style supported\n"
"              in the URL, like this:\n"
"\n"
"              curl    -T    \"{file1,file2}\"    http://www.upload\n"
"              tothissite.com\n"
"\n"
"              or even\n"
"\n"
"              curl   -T   \"img[1-1000].png\"  ftp://ftp.picturema\n"
"              nia.com/upload/\n"
"\n"
"       --trace <file>\n"
"              Enables a full trace dump of all incoming and  out\n"
, stdout);
 fputs(
"              going  data,  including descriptive information, to\n"
"              the given output file. Use \"-\" as filename to  have\n"
"              the output sent to stdout.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used. (Added in 7.9.7)\n"
"\n"
"       --trace-ascii <file>\n"
"              Enables a full trace dump of all incoming and  out\n"
"              going  data,  including descriptive information, to\n"
, stdout);
 fputs(
"              the given output file. Use \"-\" as filename to  have\n"
"              the output sent to stdout.\n"
"\n"
"              This is very similar to --trace, but leaves out the\n"
"              hex part and only shows the ASCII part of the dump.\n"
"              It  makes  smaller  output  that might be easier to\n"
"              read for untrained humans.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used. (Added in 7.9.7)\n"
"\n"
"       -u/--user <user:password>\n"
, stdout);
 fputs(
"              Specify user and password to use for server authen\n"
"              tication.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -U/--proxy-user <user:password>\n"
"              Specify  user and password to use for proxy authen\n"
"              tication.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       --url <URL>\n"
"              Specify a URL to fetch. This option is mostly handy\n"
, stdout);
 fputs(
"              when you want to specify URL(s) in a config file.\n"
"\n"
"              This option may be used any  number  of  times.  To\n"
"              control   where   this  URL  is  written,  use  the\n"
"              -o/--output or the -O/--remote-name options.\n"
"\n"
"       -v/--verbose\n"
"              Makes the fetching more  verbose/talkative.  Mostly\n"
"              usable for debugging. Lines starting with '>' means\n"
"              data sent by curl, '<' means data received by  curl\n"
, stdout);
 fputs(
"              that  is  hidden in normal cases and lines starting\n"
"              with '*' means additional info provided by curl.\n"
"\n"
"              Note that if you want to see HTTP  headers  in  the\n"
"              output, -i/--include might be option you're looking\n"
"              for.\n"
"\n"
"              If you think this option  still  doesn't  give  you\n"
"              enough  details, consider using --trace or --trace-\n"
"              ascii instead.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable verbose.\n"
"\n"
"       -V/--version\n"
"              Displays  information  about  curl  and the libcurl\n"
"              version it uses.\n"
"\n"
"              The first line includes the full version  of  curl,\n"
"              libcurl  and  other 3rd party libraries linked with\n"
"              the executable.\n"
"\n"
"              The second line (starts  with  \"Protocols:\")  shows\n"
, stdout);
 fputs(
"              all protocols that libcurl reports to support.\n"
"\n"
"              The third line (starts with \"Features:\") shows spe\n"
"              cific features libcurl reports to offer.  Available\n"
"              features include:\n"
"\n"
"              IPv6   You can use IPv6 with this.\n"
"\n"
"              krb4   Krb4 for ftp is supported.\n"
"\n"
"              SSL    HTTPS and FTPS are supported.\n"
"\n"
"              libz   Automatic  decompression of compressed files\n"
"                     over HTTP is supported.\n"
"\n"
, stdout);
 fputs(
"              NTLM   NTLM authenticaion is supported.\n"
"\n"
"              GSS-Negotiate\n"
"                     Negotiate authenticaion is supported.\n"
"\n"
"              Debug  This curl uses a libcurl built  with  Debug.\n"
"                     This  enables more error-tracking and memory\n"
"                     debugging etc. For curl-developers only!\n"
"\n"
"              AsynchDNS\n"
"                     This curl uses asynchronous name resolves.\n"
"\n"
"              SPNEGO SPNEGO Negotiate authenticaion is supported.\n"
"\n"
, stdout);
 fputs(
"              Largefile\n"
"                     This curl supports transfers of large files,\n"
"                     files larger than 2GB.\n"
"\n"
"              IDN    This  curl  supports  IDN  -   international\n"
"                     domain names.\n"
"\n"
"       -w/--write-out <format>\n"
"              Defines  what to display after a completed and suc\n"
"              cessful operation. The format is a string that  may\n"
"              contain  plain  text mixed with any number of vari\n"
, stdout);
 fputs(
"              ables. The string can be specified as \"string\",  to\n"
"              get  read  from  a  particular  file you specify it\n"
"              \"@filename\" and to tell curl  to  read  the  format\n"
"              from stdin you write \"@-\".\n"
"\n"
"              The  variables present in the output format will be\n"
"              substituted by the value or text that  curl  thinks\n"
"              fit,  as  described below. All variables are speci\n"
, stdout);
 fputs(
"              fied like %{variable_name} and to output a normal %\n"
"              you  just write them like %%. You can output a new\n"
"              line by using \\n, a carriage return with \\r  and  a\n"
"              tab space with \\t.\n"
"\n"
"              NOTE:  The  %-letter  is  a  special  letter in the\n"
"              win32-environment, where all occurrences of %  must\n"
"              be doubled when using this option.\n"
"\n"
"              Available variables are at this point:\n"
"\n"
, stdout);
 fputs(
"              url_effective  The  URL that was fetched last. This\n"
"                             is mostly meaningful if you've  told\n"
"                             curl to follow location: headers.\n"
"\n"
"              http_code      The numerical code that was found in\n"
"                             the last retrieved HTTP(S) page.\n"
"\n"
"              time_total     The total time, in seconds, that the\n"
"                             full operation lasted. The time will\n"
, stdout);
 fputs(
"                             be displayed with millisecond  reso\n"
"                             lution.\n"
"\n"
"              time_namelookup\n"
"                             The  time,  in seconds, it took from\n"
"                             the start until the  name  resolving\n"
"                             was completed.\n"
"\n"
"              time_connect   The  time,  in seconds, it took from\n"
"                             the start until the connect  to  the\n"
, stdout);
 fputs(
"                             remote  host  (or  proxy)  was  com\n"
"                             pleted.\n"
"\n"
"              time_pretransfer\n"
"                             The time, in seconds, it  took  from\n"
"                             the start until the file transfer is\n"
"                             just about to begin.  This  includes\n"
"                             all  pre-transfer commands and nego\n"
"                             tiations that are  specific  to  the\n"
, stdout);
 fputs(
"                             particular protocol(s) involved.\n"
"\n"
"              time_starttransfer\n"
"                             The  time,  in seconds, it took from\n"
"                             the start until the  first  byte  is\n"
"                             just  about  to  be transfered. This\n"
"                             includes time_pretransfer  and  also\n"
"                             the  time the server needs to calcu\n"
"                             late the result.\n"
"\n"
, stdout);
 fputs(
"              size_download  The total amount of bytes that  were\n"
"                             downloaded.\n"
"\n"
"              size_upload    The  total amount of bytes that were\n"
"                             uploaded.\n"
"\n"
"              size_header    The total amount  of  bytes  of  the\n"
"                             downloaded headers.\n"
"\n"
"              size_request   The  total amount of bytes that were\n"
"                             sent in the HTTP request.\n"
"\n"
, stdout);
 fputs(
"              speed_download The average download speed that curl\n"
"                             measured  for the complete download.\n"
"\n"
"              speed_upload   The average upload speed  that  curl\n"
"                             measured for the complete upload.\n"
"\n"
"              content_type   The  Content-Type  of  the requested\n"
"                             document, if there was  any.  (Added\n"
"                             in 7.9.5)\n"
"\n"
, stdout);
 fputs(
"       If this option is used several times, the last one will be\n"
"       used.\n"
"\n"
"       -x/--proxy <proxyhost[:port]>\n"
"              Use specified HTTP proxy. If the port number is not\n"
"              specified, it is assumed at port 1080.\n"
"\n"
"              This  option  overrides  existing environment vari\n"
"              ables that sets proxy to use. If there's  an  envi\n"
"              ronment variable setting a proxy, you can set proxy\n"
"              to \"\" to override it.\n"
"\n"
, stdout);
 fputs(
"              Note that all operations that are performed over  a\n"
"              HTTP proxy will transparantly be converted to HTTP.\n"
"              It means that certain protocol specific  operations\n"
"              might not be available. This is not the case if you\n"
"              can tunnel through the  proxy,  as  done  with  the\n"
"              -p/--proxytunnel option.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -X/--request <command>\n"
, stdout);
 fputs(
"              (HTTP) Specifies a custom request to use when  com\n"
"              municating  with  the  HTTP  server.  The specified\n"
"              request will be used instead of the  standard  GET.\n"
"              Read  the  HTTP  1.1  specification for details and\n"
"              explanations.\n"
"\n"
"              (FTP) Specifies a custom FTP command to use instead\n"
"              of LIST when doing file lists with ftp.\n"
"\n"
"              If  this option is used several times, the last one\n"
, stdout);
 fputs(
"              will be used.\n"
"\n"
"       -y/--speed-time <time>\n"
"              If a download is slower than speed-limit bytes  per\n"
"              second  during  a  speed-time  period, the download\n"
"              gets aborted. If speed-time is  used,  the  default\n"
"              speed-limit will be 1 unless set with -y.\n"
"\n"
"              This  option  controls  transfers and thus will not\n"
"              affect slow connects etc. If this is a concern  for\n"
"              you, try the --connect-timeout option.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -Y/--speed-limit <speed>\n"
"              If a download is slower than this given  speed,  in\n"
"              bytes  per  second,  for speed-time seconds it gets\n"
"              aborted. speed-time is set with -Y and is 30 if not\n"
"              set.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -z/--time-cond <date expression>\n"
, stdout);
 fputs(
"              (HTTP) Request a file that has been modified  later\n"
"              than  the given time and date, or one that has been\n"
"              modified before that time. The date expression  can\n"
"              be all sorts of date strings or if it doesn't match\n"
"              any internal ones, it tries to get the time from  a\n"
"              given  file  name  instead! See the curl_getdate(3)\n"
"              man pages for date expression details.\n"
"\n"
, stdout);
 fputs(
"              Start the date expression with a dash (-)  to  make\n"
"              it  request  for  a document that is older than the\n"
"              given date/time, default  is  a  document  that  is\n"
"              newer than the specified date/time.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --max-redirs <num>\n"
"              Set  maximum   number   of   redirection-followings\n"
, stdout);
 fputs(
"              allowed.  If -L/--location is used, this option can\n"
"              be used to prevent curl from following redirections\n"
"              \"in absurdum\".\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -0/--http1.0\n"
"              (HTTP) Forces curl to issue its requests using HTTP\n"
"              1.0 instead of using its internally preferred: HTTP\n"
"              1.1.\n"
"\n"
"       -1/--tlsv1\n"
, stdout);
 fputs(
"              (HTTPS) Forces curl to use TSL version 1 when nego\n"
"              tiating with a remote TLS server.\n"
"\n"
"       -2/--sslv2\n"
"              (HTTPS) Forces curl to use SSL version 2 when nego\n"
"              tiating with a remote SSL server.\n"
"\n"
"       -3/--sslv3\n"
"              (HTTPS) Forces curl to use SSL version 3 when nego\n"
"              tiating with a remote SSL server.\n"
"\n"
"       -4/--ipv4\n"
"              If  libcurl  is  capable of resolving an address to\n"
, stdout);
 fputs(
"              multiple  IP  versions  (which  it  is  if  it   is\n"
"              ipv6-capable), this option tells libcurl to resolve\n"
"              names to IPv4 addresses only. (Added in 7.10.8)\n"
"\n"
"       -6/--ipv6\n"
"              If libcurl is capable of resolving  an  address  to\n"
"              multiple   IP  versions  (which  it  is  if  it  is\n"
"              ipv6-capable), this option tells libcurl to resolve\n"
"              names to IPv6 addresses only. (Added in 7.10.8)\n"
"\n"
"       -#/--progress-bar\n"
, stdout);
 fputs(
"              Make   curl   display  progress  information  as  a\n"
"              progress bar instead of the default statistics.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable the progress bar.\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
"              Default config file.\n"
"\n"
"ENVIRONMENT\n"
"       http_proxy [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTP.\n"
"\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTPS.\n"
"\n"
, stdout);
 fputs(
"       FTP_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for FTP.\n"
"\n"
"       GOPHER_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for GOPHER.\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
"              Sets  proxy  server  to use if no protocol-specific\n"
"              proxy is set.\n"
"\n"
"       NO_PROXY <comma-separated list of hosts>\n"
"              list of host names that shouldn't  go  through  any\n"
"              proxy. If set to a asterisk\n"
"\n"
"EXIT CODES\n"
, stdout);
 fputs(
"       There  exists  a  bunch of different error codes and their\n"
"       corresponding error messages that may  appear  during  bad\n"
"       conditions.  At  the  time of this writing, the exit codes\n"
"       are:\n"
"\n"
"       1      Unsupported protocol. This build  of  curl  has  no\n"
"              support for this protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformat. The syntax was not correct.\n"
"\n"
"       4      URL  user  malformatted.  The  user-part of the URL\n"
, stdout);
 fputs(
"              syntax was not correct.\n"
"\n"
"       5      Couldn't resolve proxy. The given proxy host  could\n"
"              not be resolved.\n"
"\n"
"       6      Couldn't  resolve  host.  The given remote host was\n"
"              not resolved.\n"
"\n"
"       7      Failed to connect to host.\n"
"\n"
"       8      FTP weird server reply. The server sent  data  curl\n"
"              couldn't parse.\n"
"\n"
"       9      FTP access denied. The server denied login.\n"
"\n"
"       10     FTP  user/password  incorrect.  Either  one or both\n"
, stdout);
 fputs(
"              were not accepted by the server.\n"
"\n"
"       11     FTP weird PASS reply. Curl couldn't parse the reply\n"
"              sent to the PASS request.\n"
"\n"
"       12     FTP weird USER reply. Curl couldn't parse the reply\n"
"              sent to the USER request.\n"
"\n"
"       13     FTP weird PASV reply, Curl couldn't parse the reply\n"
"              sent to the PASV request.\n"
"\n"
"       14     FTP  weird  227  format.  Curl  couldn't  parse the\n"
"              227-line the server sent.\n"
"\n"
, stdout);
 fputs(
"       15     FTP can't get host. Couldn't resolve the host IP we\n"
"              got in the 227-line.\n"
"\n"
"       16     FTP  can't  reconnect. Couldn't connect to the host\n"
"              we got in the 227-line.\n"
"\n"
"       17     FTP couldn't set binary. Couldn't  change  transfer\n"
"              method to binary.\n"
"\n"
"       18     Partial  file.  Only  a part of the file was trans\n"
"              fered.\n"
"\n"
"       19     FTP couldn't download/access the  given  file,  the\n"
, stdout);
 fputs(
"              RETR (or similar) command failed.\n"
"\n"
"       20     FTP  write  error. The transfer was reported bad by\n"
"              the server.\n"
"\n"
"       21     FTP quote error. A  quote  command  returned  error\n"
"              from the server.\n"
"\n"
"       22     HTTP  page not retrieved. The requested url was not\n"
"              found or returned another error with the HTTP error\n"
"              code  being  400  or  above.  This return code only\n"
"              appears if -f/--fail is used.\n"
"\n"
, stdout);
 fputs(
"       23     Write error. Curl couldn't write data  to  a  local\n"
"              filesystem or similar.\n"
"\n"
"       24     Malformed user. User name badly specified.\n"
"\n"
"       25     FTP  couldn't STOR file. The server denied the STOR\n"
"              operation, used for FTP uploading.\n"
"\n"
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request  failed.\n"
"       28     Operation  timeout.  The  specified time-out period\n"
, stdout);
 fputs(
"              was reached according to the conditions.\n"
"\n"
"       29     FTP couldn't set  ASCII.  The  server  returned  an\n"
"              unknown reply.\n"
"\n"
"       30     FTP  PORT  failed. The PORT command failed. Not all\n"
"              FTP servers support the PORT command, try  doing  a\n"
"              transfer using PASV instead!\n"
"\n"
"       31     FTP  couldn't  use  REST.  The REST command failed.\n"
"              This command is used for resumed FTP transfers.\n"
"\n"
, stdout);
 fputs(
"       32     FTP couldn't use SIZE. The SIZE command failed. The\n"
"              command  is  an  extension to the original FTP spec\n"
"              RFC 959.\n"
"\n"
"       33     HTTP range error. The range \"command\" didn't  work.\n"
"       34     HTTP  post  error. Internal post-request generation\n"
"              error.\n"
"\n"
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
"       36     FTP bad download resume. Couldn't continue an  ear\n"
"              lier aborted download.\n"
"\n"
, stdout);
 fputs(
"       37     FILE  couldn't  read file. Failed to open the file.\n"
"              Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
"       40     Library not found. The LDAP library was not  found.\n"
"       41     Function  not  found.  A required LDAP function was\n"
"              not found.\n"
"\n"
"       42     Aborted by callback. An application  told  curl  to\n"
"              abort the operation.\n"
"\n"
, stdout);
 fputs(
"       43     Internal  error.  A  function was called with a bad\n"
"              parameter.\n"
"\n"
"       44     Internal error. A function  was  called  in  a  bad\n"
"              order.\n"
"\n"
"       45     Interface  error.  A  specified  outgoing interface\n"
"              could not be used.\n"
"\n"
"       46     Bad password entered. An error  was  signaled  when\n"
"              the password was entered.\n"
"\n"
"       47     Too  many redirects. When following redirects, curl\n"
"              hit the maximum amount.\n"
"\n"
, stdout);
 fputs(
"       48     Unknown TELNET option specified.\n"
"\n"
"       49     Malformed telnet option.\n"
"\n"
"       51     The remote peer's SSL certificate wasn't ok\n"
"\n"
"       52     The server didn't reply  anything,  which  here  is\n"
"              considered an error.\n"
"\n"
"       53     SSL crypto engine not found\n"
"\n"
"       54     Cannot set SSL crypto engine as default\n"
"\n"
"       55     Failed sending network data\n"
"\n"
"       56     Failure in receiving network data\n"
"\n"
"       57     Share is in use (internal error)\n"
"\n"
, stdout);
 fputs(
"       58     Problem with the local certificate\n"
"\n"
"       59     Couldn't use specified SSL cipher\n"
"\n"
"       60     Problem with the CA cert (path? permission?)\n"
"\n"
"       61     Unrecognized transfer encoding\n"
"\n"
"       62     Invalid LDAP URL\n"
"\n"
"       63     Maximum file size exceeded\n"
"\n"
"       XX     There  will  appear more error codes here in future\n"
"              releases. The existing  ones  are  meant  to  never\n"
"              change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
, stdout);
 fputs(
"       Daniel  Stenberg is the main author, but the whole list of\n"
"       contributors is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       http://curl.haxx.se\n"
"\n"
"FTP\n"
"       ftp://ftp.sunet.se/pub/www/utilities/curl/\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1), snarf(1)\n"
"\n"
"LATEST VERSION\n"
"\n"
"  You always find news about what's going on as well as the latest versions\n"
"  from the curl web pages, located at:\n"
"\n"
"        http://curl.haxx.se\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from netscape's web-server:\n"
"\n"
, stdout);
 fputs(
"        curl http://www.netscape.com/\n"
"\n"
"  Get the README file the user's home directory at funet's ftp-server:\n"
"\n"
"        curl ftp://ftp.funet.fi/README\n"
"\n"
"  Get a web page from a server using port 8000:\n"
"\n"
"        curl http://www.weirdserver.com:8000/\n"
"\n"
"  Get a list of a directory of an FTP site:\n"
"\n"
"        curl ftp://cool.haxx.se/\n"
"\n"
"  Get a gopher document from funet's gopher server:\n"
"\n"
"        curl gopher://gopher.funet.fi\n"
"\n"
"  Get the definition of curl from a dictionary:\n"
"\n"
, stdout);
 fputs(
"        curl dict://dict.org/m:curl\n"
"\n"
"  Fetch two documents at once:\n"
"\n"
"        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
"  Get a web page and store in a local file:\n"
"\n"
"        curl -o thatpage.html http://www.netscape.com/\n"
"\n"
"  Get a web page and store in a local file, make the local file get the name\n"
"  of the remote document (if no file name part is specified in the URL, this\n"
"  will fail):\n"
"\n"
"        curl -O http://www.netscape.com/index.html\n"
"\n"
, stdout);
 fputs(
"  Fetch two files and store them with their remote names:\n"
"\n"
"        curl -O www.haxx.se/index.html -O curl.haxx.se/download.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
"        curl ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
"        curl -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" FTPS\n"
"\n"
"   It is just like for FTP, but you may also want to specify and use\n"
, stdout);
 fputs(
"   SSL-specific options for certificates etc.\n"
"\n"
" HTTP\n"
"\n"
"   The HTTP URL doesn't support user and password in the URL string. Curl\n"
"   does support that anyway to provide a ftp-style interface and thus you can\n"
"   pick a file like:\n"
"\n"
"        curl http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
"   or specify user and password separately like in\n"
"\n"
"        curl -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
"   HTTP offers many different methods of authentication and curl supports\n"
, stdout);
 fputs(
"   several: Basic, Digest, NTLM and Negotiate. Without telling which method to\n"
"   use, curl defaults to Basic. You can also ask curl to pick the most secure\n"
"   ones out of the ones that the server accepts for the given URL, by using\n"
"   --anyauth.\n"
"\n"
"   NOTE! Since HTTP URLs don't support user and password, you can't use that\n"
"   style when using Curl via a proxy. You _must_ use the -u style fetch\n"
"   during such circumstances.\n"
"\n"
" HTTPS\n"
"\n"
, stdout);
 fputs(
"   Probably most commonly used with private certificates, as explained below.\n"
"\n"
" GOPHER\n"
"\n"
"   Curl features no password support for gopher.\n"
"\n"
"PROXY\n"
"\n"
" Get an ftp file using a proxy named my-proxy that uses port 888:\n"
"\n"
"        curl -x my-proxy:888 ftp://ftp.leachsite.com/README\n"
"\n"
" Get a file from a HTTP server that requires user and password, using the\n"
" same proxy as above:\n"
"\n"
"        curl -u user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
" Some proxies require special authentication. Specify by using -U as above:\n"
"\n"
"        curl -U user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" See also the environment variables Curl support that offer further proxy\n"
" control.\n"
"\n"
"RANGES\n"
"\n"
"  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request\n"
"  to get only one or more subparts of a specified document. Curl supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        curl -r 0-99 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
"  Get the last 500 bytes of a document:\n"
"\n"
"        curl -r -500 http://www.get.this/\n"
"\n"
"  Curl also supports simple ranges for FTP files as well. Then you can only\n"
"  specify start and stop position.\n"
"\n"
"  Get the first 100 bytes of a document using FTP:\n"
"\n"
"        curl -r 0-99 ftp://www.get.this/README  \n"
"\n"
"UPLOADING\n"
"\n"
" FTP\n"
"\n"
"  Upload all data on stdin to a specified ftp site:\n"
"\n"
"        curl -T - ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload data from a specified file, login with user and password:\n"
"\n"
, stdout);
 fputs(
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload a local file to the remote site, and use the local file name remote\n"
"  too:\n"
" \n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
"  Upload a local file to get appended to the remote file using ftp:\n"
"\n"
"        curl -T localfile -a ftp://ftp.upload.com/remotefile\n"
"\n"
"  Curl also supports ftp upload through a proxy, but only if the proxy is\n"
, stdout);
 fputs(
"  configured to allow that kind of tunneling. If it does, you can run curl in\n"
"  a fashion similar to:\n"
"\n"
"        curl --proxytunnel -x proxy:port -T localfile ftp.upload.com\n"
"\n"
" HTTP\n"
"\n"
"  Upload all data on stdin to a specified http site:\n"
"\n"
"        curl -T - http://www.upload.com/myfile\n"
"\n"
"  Note that the http server must've been configured to accept PUT before this\n"
"  can be done successfully.\n"
"\n"
"  For other ways to do http data upload, see the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
, stdout);
 fputs(
"  If curl fails where it isn't supposed to, if the servers don't let you in,\n"
"  if you can't understand the responses: use the -v flag to get verbose\n"
"  fetching. Curl will output lots of info and what it sends and receives in\n"
"  order to let the user see all client-server interaction (but it won't show\n"
"  you the actual data).\n"
"\n"
"        curl -v ftp://ftp.upload.com/\n"
"\n"
"  To get even more details and information on what curl does, try using the\n"
, stdout);
 fputs(
"  --trace or --trace-ascii options with a given file name to log to, like\n"
"  this:\n"
"\n"
"        curl --trace trace.txt www.haxx.se\n"
" \n"
"\n"
"DETAILED INFORMATION\n"
"\n"
"  Different protocols provide different ways of getting detailed information\n"
"  about specific files/documents. To get curl to show detailed information\n"
"  about a single file, you should use -I/--head option. It displays all\n"
"  available info on a single file for HTTP and FTP. The HTTP information is a\n"
"  lot more extensive.\n"
"\n"
, stdout);
 fputs(
"  For HTTP, you can get the header information (the same as -I would show)\n"
"  shown before the data by using -i/--include. Curl understands the\n"
"  -D/--dump-header option when getting files from both FTP and HTTP, and it\n"
"  will then store the headers in the specified file.\n"
"\n"
"  Store the HTTP headers in a separate file (headers.txt in the example):\n"
"\n"
"        curl --dump-header headers.txt curl.haxx.se\n"
"\n"
"  Note that headers stored in a separate file can be very useful at a later\n"
, stdout);
 fputs(
"  time if you want curl to use cookies sent by the server. More about that in\n"
"  the cookies section.\n"
"\n"
"POST (HTTP)\n"
"\n"
"  It's easy to post data using curl. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"        curl -d \"name=Rafael%20Sagula&phone=3320780\" \\\n"
"                http://www.where.com/guest.cgi\n"
"\n"
"  How to post a form with curl, lesson #1:\n"
"\n"
, stdout);
 fputs(
"  Dig out all the <input> tags in the form that you want to fill in. (There's\n"
"  a perl program called formfind.pl on the curl site that helps with this).\n"
"\n"
"  If there's a \"normal\" post, you use -d to post. -d takes a full \"post\n"
"  string\", which is in the format\n"
"\n"
"        <variable1>=<data1>&<variable2>=<data2>&...\n"
"\n"
"  The 'variable' names are the names set with \"name=\" in the <input> tags, and\n"
"  the data is the contents you want to fill in for the inputs. The data *must*\n"
, stdout);
 fputs(
"  be properly URL encoded. That means you replace space with + and that you\n"
"  write weird letters with %XX where XX is the hexadecimal representation of\n"
"  the letter's ASCII code.\n"
"\n"
"  Example:\n"
"\n"
"  (page located at http://www.formpost.com/getthis/\n"
"\n"
"        <form action=\"post.cgi\" method=\"post\">\n"
"        <input name=user size=10>\n"
"        <input name=pass type=password size=10>\n"
"        <input name=id type=hidden value=\"blablabla\">\n"
"        <input name=ding value=\"submit\">\n"
"        </form>\n"
"\n"
, stdout);
 fputs(
"  We want to enter user 'foobar' with password '12345'.\n"
"\n"
"  To post to this, you enter a curl command line like:\n"
"\n"
"        curl -d \"user=foobar&pass=12345&id=blablabla&ding=submit\"  (continues)\n"
"          http://www.formpost.com/getthis/post.cgi\n"
"\n"
"\n"
"  While -d uses the application/x-www-form-urlencoded mime-type, generally\n"
"  understood by CGI's and similar, curl also supports the more capable\n"
"  multipart/form-data type. This latter type supports things like file upload.\n"
"\n"
, stdout);
 fputs(
"  -F accepts parameters like -F \"name=contents\". If you want the contents to\n"
"  be read from a file, use <@filename> as contents. When specifying a file,\n"
"  you can also specify the file content type by appending ';type=<mime type>'\n"
"  to the file name. You can also post the contents of several files in one\n"
"  field.  For example, the field name 'coolfiles' is used to send three files,\n"
"  with different content types using the following syntax:\n"
"\n"
, stdout);
 fputs(
"        curl -F \"coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html\" \\\n"
"        http://www.post.com/postit.cgi\n"
"\n"
"  If the content-type is not specified, curl will try to guess from the file\n"
"  extension (it only knows a few), or use the previously specified type (from\n"
"  an earlier file if several files are specified in a list) or else it will\n"
"  using the default type 'text/plain'.\n"
"\n"
"  Emulate a fill-in form with -F. Let's say you fill in three fields in a\n"
, stdout);
 fputs(
"  form. One field is a file name which to post, one field is your name and one\n"
"  field is a file description. We want to post the file we have written named\n"
"  \"cooltext.txt\". To let curl do the posting of this data instead of your\n"
"  favourite browser, you have to read the HTML source of the form page and\n"
"  find the names of the input fields. In our example, the input field names\n"
"  are 'file', 'yourname' and 'filedescription'.\n"
"\n"
"        curl -F \"file=@cooltext.txt\" -F \"yourname=Daniel\" \\\n"
, stdout);
 fputs(
"             -F \"filedescription=Cool text file with cool text inside\" \\\n"
"             http://www.post.com/postit.cgi\n"
"\n"
"  To send two files in one post you can do it in two ways:\n"
"\n"
"  1. Send multiple files in a single \"field\" with a single field name:\n"
" \n"
"        curl -F \"pictures=@dog.gif,cat.gif\" \n"
" \n"
"  2. Send two fields with two field names: \n"
"\n"
"        curl -F \"docpicture=@dog.gif\" -F \"catpicture=@cat.gif\" \n"
"\n"
"REFERRER\n"
"\n"
"  A HTTP request has the option to include information about which address\n"
, stdout);
 fputs(
"  that referred to actual page.  Curl allows you to specify the\n"
"  referrer to be used on the command line. It is especially useful to\n"
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"        curl -e www.coolsite.com http://www.showme.com/\n"
"\n"
"  NOTE: The referer field is defined in the HTTP spec to be a full URL.\n"
"\n"
"USER AGENT\n"
"\n"
"  A HTTP request has the option to include information about the browser\n"
, stdout);
 fputs(
"  that generated the request. Curl allows it to be specified on the command\n"
"  line. It is especially useful to fool or trick stupid servers or CGI\n"
"  scripts that only accept certain browsers.\n"
"\n"
"  Example:\n"
"\n"
"  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/\n"
"\n"
"  Other common strings:\n"
"    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95\n"
"    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95\n"
"    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2\n"
, stdout);
 fputs(
"    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX\n"
"    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux\n"
"\n"
"  Note that Internet Explorer tries hard to be compatible in every way:\n"
"    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95\n"
"\n"
"  Mozilla is not the only possible User-Agent name:\n"
"    'Konqueror/1.0'             KDE File Manager desktop client\n"
"    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser\n"
"\n"
"COOKIES\n"
"\n"
, stdout);
 fputs(
"  Cookies are generally used by web servers to keep state information at the\n"
"  client's side. The server sets cookies by sending a response line in the\n"
"  headers that looks like 'Set-Cookie: <data>' where the data part then\n"
"  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'\n"
"  like \"NAME1=VALUE1; NAME2=VALUE2;\"). The server can also specify for what\n"
"  path the \"cookie\" should be used for (by specifying \"path=value\"), when the\n"
, stdout);
 fputs(
"  cookie should expire (\"expire=DATE\"), for what domain to use it\n"
"  (\"domain=NAME\") and if it should be used on secure connections only\n"
"  (\"secure\").\n"
"\n"
"  If you've received a page from a server that contains a header like:\n"
"        Set-Cookie: sessionid=boo123; path=\"/foo\";\n"
"\n"
"  it means the server wants that first pair passed on when we get anything in\n"
"  a path beginning with \"/foo\".\n"
"\n"
"  Example, get a page that wants my name passed in a cookie:\n"
"\n"
"        curl -b \"name=Daniel\" www.sillypage.com\n"
"\n"
, stdout);
 fputs(
"  Curl also has the ability to use previously received cookies in following\n"
"  sessions. If you get cookies from a server and store them in a file in a\n"
"  manner similar to:\n"
"\n"
"        curl --dump-header headers www.example.com\n"
"\n"
"  ... you can then in a second connect to that (or another) site, use the\n"
"  cookies from the 'headers' file like:\n"
"\n"
"        curl -b headers www.example.com\n"
"\n"
"  While saving headers to a file is a working way to store cookies, it is\n"
, stdout);
 fputs(
"  however error-prone and not the prefered way to do this. Instead, make curl\n"
"  save the incoming cookies using the well-known netscape cookie format like\n"
"  this:\n"
"\n"
"        curl -c cookies.txt www.example.com\n"
"\n"
"  Note that by specifying -b you enable the \"cookie awareness\" and with -L\n"
"  you can make curl follow a location: (which often is used in combination\n"
"  with cookies). So that if a site sends cookies and a location, you can\n"
"  use a non-existing file to trigger the cookie awareness like:\n"
"\n"
, stdout);
 fputs(
"        curl -L -b empty.txt www.example.com\n"
"\n"
"  The file to read cookies from must be formatted using plain HTTP headers OR\n"
"  as netscape's cookie file. Curl will determine what kind it is based on the\n"
"  file contents.  In the above command, curl will parse the header and store\n"
"  the cookies received from www.example.com.  curl will send to the server the\n"
"  stored cookies which match the request as it follows the location.  The\n"
"  file \"empty.txt\" may be a non-existant file.\n"
"\n"
, stdout);
 fputs(
"  Alas, to both read and write cookies from a netscape cookie file, you can\n"
"  set both -b and -c to use the same file:\n"
"\n"
"        curl -b cookies.txt -c cookies.txt www.example.com\n"
"\n"
"PROGRESS METER\n"
"\n"
"  The progress meter exists to show a user that something actually is\n"
"  happening. The different fields in the output have the following meaning:\n"
"\n"
"  % Total    % Received % Xferd  Average Speed          Time             Curr.\n"
, stdout);
 fputs(
"                                 Dload  Upload Total    Current  Left    Speed\n"
"  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287\n"
"\n"
"  From left-to-right:\n"
"   %             - percentage completed of the whole transfer\n"
"   Total         - total size of the whole expected transfer\n"
"   %             - percentage completed of the download\n"
"   Received      - currently downloaded amount of bytes\n"
"   %             - percentage completed of the upload\n"
, stdout);
 fputs(
"   Xferd         - currently uploaded amount of bytes\n"
"   Average Speed\n"
"   Dload         - the average transfer speed of the download\n"
"   Average Speed\n"
"   Upload        - the average transfer speed of the upload\n"
"   Time Total    - expected time to complete the operation\n"
"   Time Current  - time passed since the invoke\n"
"   Time Left     - expected time left to completetion\n"
"   Curr.Speed    - the average transfer speed the last 5 seconds (the first\n"
, stdout);
 fputs(
"                   5 seconds of a transfer is based on less time of course.)\n"
"\n"
"  The -# option will display a totally different progress bar that doesn't\n"
"  need much explanation!\n"
"\n"
"SPEED LIMIT\n"
"\n"
"  Curl allows the user to set the transfer speed conditions that must be met\n"
"  to let the transfer keep going. By using the switch -y and -Y you\n"
"  can make curl abort transfers if the transfer speed is below the specified\n"
"  lowest limit for a specified time.\n"
"\n"
, stdout);
 fputs(
"  To have curl abort the download if the speed is slower than 3000 bytes per\n"
"  second for 1 minute, run:\n"
"\n"
"        curl -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  This can very well be used in combination with the overall time limit, so\n"
"  that the above operatioin must be completed in whole within 30 minutes:\n"
"\n"
"        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  Forcing curl not to transfer data faster than a given rate is also possible,\n"
, stdout);
 fputs(
"  which might be useful if you're using a limited bandwidth connection and you\n"
"  don't want your transfer to use all of it (sometimes referred to as\n"
"  \"bandwith throttle\").\n"
"\n"
"  Make curl transfer data no faster than 10 kilobytes per second:\n"
"\n"
"        curl --limit-rate 10K www.far-away-site.com\n"
"\n"
"    or\n"
"\n"
"        curl --limit-rate 10240 www.far-away-site.com\n"
"\n"
"  Or prevent curl from uploading data faster than 1 megabyte per second:\n"
"\n"
"        curl -T upload --limit-rate 1M ftp://uploadshereplease.com\n"
"\n"
, stdout);
 fputs(
"  When using the --limit-rate option, the transfer rate is regulated on a\n"
"  per-second basis, which will cause the total transfer speed to become lower\n"
"  than the given number. Sometimes of course substantially lower, if your\n"
"  transfer stalls during periods.\n"
"\n"
"CONFIG FILE\n"
"\n"
"  Curl automatically tries to read the .curlrc file (or _curlrc file on win32\n"
"  systems) from the user's home dir on startup.\n"
"\n"
"  The config file could be made up with normal command line switches, but you\n"
, stdout);
 fputs(
"  can also specify the long options without the dashes to make it more\n"
"  readable. You can separate the options and the parameter with spaces, or\n"
"  with = or :. Comments can be used within the file. If the first letter on a\n"
"  line is a '#'-letter the rest of the line is treated as a comment.\n"
"\n"
"  If you want the parameter to contain spaces, you must inclose the entire\n"
"  parameter within double quotes (\"). Within those quotes, you specify a\n"
"  quote as \\\".\n"
"\n"
, stdout);
 fputs(
"  NOTE: You must specify options and their arguments on the same line.\n"
"\n"
"  Example, set default time out and proxy in a config file:\n"
"\n"
"        # We want a 30 minute timeout:\n"
"        -m 1800\n"
"        # ... and we use a proxy for all accesses:\n"
"        proxy = proxy.our.domain.com:8080\n"
"\n"
"  White spaces ARE significant at the end of lines, but all white spaces\n"
"  leading up to the first characters of each line are ignored.\n"
"\n"
"  Prevent curl from reading the default file by using -q as the first command\n"
, stdout);
 fputs(
"  line parameter, like:\n"
"\n"
"        curl -q www.thatsite.com\n"
"\n"
"  Force curl to get and display a local help page in case it is invoked\n"
"  without URL by making a config file similar to:\n"
"\n"
"        # default url to get\n"
"        url = \"http://help.with.curl.com/curlhelp.html\"\n"
"\n"
"  You can specify another config file to be read by using the -K/--config\n"
"  flag. If you set config file name to \"-\" it'll read the config from stdin,\n"
"  which can be handy if you want to hide options from being visible in process\n"
, stdout);
 fputs(
"  tables etc:\n"
"\n"
"        echo \"user = user:passwd\" | curl -K - http://that.secret.site.com\n"
"\n"
"EXTRA HEADERS\n"
"\n"
"  When using curl in your own very special programs, you may end up needing\n"
"  to pass on your own custom headers when getting a web page. You can do\n"
"  this by using the -H flag.\n"
"\n"
"  Example, send the header \"X-you-and-me: yes\" to the server when getting a\n"
"  page:\n"
"\n"
"        curl -H \"X-you-and-me: yes\" www.love.com\n"
"\n"
"  This can also be useful in case you want curl to send a different text in a\n"
, stdout);
 fputs(
"  header than it normally does. The -H header you specify then replaces the\n"
"  header curl would normally send. If you replace an internal header with an\n"
"  empty one, you prevent that header from being sent. To prevent the Host:\n"
"  header from being used:\n"
"\n"
"        curl -H \"Host:\" www.server.com\n"
"\n"
"FTP and PATH NAMES\n"
"\n"
"  Do note that when getting files with the ftp:// URL, the given path is\n"
"  relative the directory you enter. To get the file 'README' from your home\n"
"  directory at your ftp site, do:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://user:passwd@my.site.com/README\n"
"\n"
"  But if you want the README file from the root directory of that very same\n"
"  site, you need to specify the absolute file name:\n"
"\n"
"        curl ftp://user:passwd@my.site.com//README\n"
"\n"
"  (I.e with an extra slash in front of the file name.)\n"
"\n"
"FTP and firewalls\n"
"\n"
"  The FTP protocol requires one of the involved parties to open a second\n"
"  connction as soon as data is about to get transfered. There are two ways to\n"
"  do this.\n"
"\n"
, stdout);
 fputs(
"  The default way for curl is to issue the PASV command which causes the\n"
"  server to open another port and await another connection performed by the\n"
"  client. This is good if the client is behind a firewall that don't allow\n"
"  incoming connections.\n"
"\n"
"        curl ftp.download.com\n"
"\n"
"  If the server for example, is behind a firewall that don't allow connections\n"
"  on other ports than 21 (or if it just doesn't support the PASV command), the\n"
, stdout);
 fputs(
"  other way to do it is to use the PORT command and instruct the server to\n"
"  connect to the client on the given (as parameters to the PORT command) IP\n"
"  number and port.\n"
"\n"
"  The -P flag to curl supports a few different options. Your machine may have\n"
"  several IP-addresses and/or network interfaces and curl allows you to select\n"
"  which of them to use. Default address can also be used:\n"
"\n"
"        curl -P - ftp.download.com\n"
"\n"
, stdout);
 fputs(
"  Download with PORT but use the IP address of our 'le0' interface (this does\n"
"  not work on windows):\n"
"\n"
"        curl -P le0 ftp.download.com\n"
"\n"
"  Download with PORT but use 192.168.0.10 as our IP address to use:\n"
"\n"
"        curl -P 192.168.0.10 ftp.download.com\n"
"\n"
"NETWORK INTERFACE\n"
"\n"
"  Get a web page from a server using a specified port for the interface:\n"
"\n"
"        curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"  or\n"
"\n"
"        curl --interface 192.168.1.10 http://www.netscape.com/\n"
"\n"
"HTTPS\n"
"\n"
, stdout);
 fputs(
"  Secure HTTP requires SSL libraries to be installed and used when curl is\n"
"  built. If that is done, curl is capable of retrieving and posting documents\n"
"  using the HTTPS procotol.\n"
"\n"
"  Example:\n"
"\n"
"        curl https://www.secure-site.com\n"
"\n"
"  Curl is also capable of using your personal certificates to get/post files\n"
"  from sites that require valid certificates. The only drawback is that the\n"
"  certificate needs to be in PEM-format. PEM is a standard and open format to\n"
, stdout);
 fputs(
"  store certificates with, but it is not used by the most commonly used\n"
"  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you\n"
"  want curl to use the certificates you use with your (favourite) browser, you\n"
"  may need to download/compile a converter that can convert your browser's\n"
"  formatted certificates to PEM formatted ones. This kind of converter is\n"
"  included in recent versions of OpenSSL, and for older versions Dr Stephen\n"
, stdout);
 fputs(
"  N. Henson has written a patch for SSLeay that adds this functionality. You\n"
"  can get his patch (that requires an SSLeay installation) from his site at:\n"
"  http://www.drh-consultancy.demon.co.uk/\n"
"\n"
"  Example on how to automatically retrieve a document using a certificate with\n"
"  a personal password:\n"
"\n"
"        curl -E /path/to/cert.pem:password https://secure.site.com/\n"
"\n"
"  If you neglect to specify the password on the command line, you will be\n"
, stdout);
 fputs(
"  prompted for the correct password before any data can be received.\n"
"\n"
"  Many older SSL-servers have problems with SSLv3 or TLS, that newer versions\n"
"  of OpenSSL etc is using, therefore it is sometimes useful to specify what\n"
"  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL\n"
"  version to use (for SSLv3, SSLv2 or TLSv1 respectively):\n"
"\n"
"        curl -2 https://secure.site.com/\n"
"\n"
"  Otherwise, curl will first attempt to use v3 and then v2.\n"
"\n"
, stdout);
 fputs(
"  To use OpenSSL to convert your favourite browser's certificate into a PEM\n"
"  formatted one that curl can use, do something like this (assuming netscape,\n"
"  but IE is likely to work similarly):\n"
"\n"
"    You start with hitting the 'security' menu button in netscape. \n"
"\n"
"    Select 'certificates->yours' and then pick a certificate in the list \n"
"\n"
"    Press the 'export' button \n"
"\n"
"    enter your PIN code for the certs \n"
"\n"
"    select a proper place to save it \n"
"\n"
, stdout);
 fputs(
"    Run the 'openssl' application to convert the certificate. If you cd to the\n"
"    openssl installation, you can do it like:\n"
"\n"
"     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]\n"
"\n"
"\n"
"RESUMING FILE TRANSFERS\n"
"\n"
" To continue a file transfer where it was previously aborted, curl supports\n"
" resume on http(s) downloads as well as ftp uploads and downloads.\n"
"\n"
" Continue downloading a document:\n"
"\n"
"        curl -C - -o file ftp://ftp.server.com/path/file\n"
"\n"
" Continue uploading a document(*1):\n"
, stdout);
 fputs(
"\n"
"        curl -C - -T file ftp://ftp.server.com/path/file\n"
"\n"
" Continue downloading a document from a web server(*2):\n"
"\n"
"        curl -C - -o file http://www.server.com/\n"
"\n"
" (*1) = This requires that the ftp server supports the non-standard command\n"
"        SIZE. If it doesn't, curl will say so.\n"
"\n"
" (*2) = This requires that the web server supports at least HTTP/1.1. If it\n"
"        doesn't, curl will say so.\n"
"\n"
"TIME CONDITIONS\n"
"\n"
" HTTP allows a client to specify a time condition for the document it\n"
, stdout);
 fputs(
" requests. It is If-Modified-Since or If-Unmodified-Since. Curl allow you to\n"
" specify them with the -z/--time-cond flag.\n"
"\n"
" For example, you can easily make a download that only gets performed if the\n"
" remote file is newer than a local copy. It would be made like:\n"
"\n"
"        curl -z local.html http://remote.server.com/remote.html\n"
"\n"
" Or you can download a file only if the local file is newer than the remote\n"
" one. Do this by prepending the date string with a '-', as in:\n"
"\n"
, stdout);
 fputs(
"        curl -z -local.html http://remote.server.com/remote.html\n"
"\n"
" You can specify a \"free text\" date as condition. Tell curl to only download\n"
" the file if it was updated since yesterday:\n"
"\n"
"        curl -z yesterday http://remote.server.com/remote.html\n"
"\n"
" Curl will then accept a wide range of date formats. You always make the date\n"
" check the other way around by prepending it with a dash '-'.\n"
"\n"
"DICT\n"
"\n"
"  For fun try\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"        curl dict://dict.org/d:heisenbug:jargon\n"
, stdout);
 fputs(
"        curl dict://dict.org/d:daniel:web1913\n"
"\n"
"  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'\n"
"  and 'lookup'. For example,\n"
"\n"
"        curl dict://dict.org/find:curl\n"
"\n"
"  Commands that break the URL description of the RFC (but not the DICT\n"
"  protocol) are\n"
"\n"
"        curl dict://dict.org/show:db\n"
"        curl dict://dict.org/show:strat\n"
"\n"
"  Authentication is still missing (but this is not required by the RFC)\n"
"\n"
"LDAP\n"
"\n"
, stdout);
 fputs(
"  If you have installed the OpenLDAP library, curl can take advantage of it\n"
"  and offer ldap:// support.\n"
"\n"
"  LDAP is a complex thing and writing an LDAP query is not an easy task. I do\n"
"  advice you to dig up the syntax description for that elsewhere. Two places\n"
"  that might suit you are:\n"
"\n"
"  Netscape's \"Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:\n"
"  Working with LDAP URLs\":\n"
"  http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm\n"
"\n"
, stdout);
 fputs(
"  RFC 2255, \"The LDAP URL Format\" http://www.rfc-editor.org/rfc/rfc2255.txt\n"
"\n"
"  To show you an example, this is now I can get all people from my local LDAP\n"
"  server that has a certain sub-domain in their email address:\n"
"\n"
"        curl -B \"ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se\"\n"
"\n"
"  If I want the same info in HTML format, I can get it by not using the -B\n"
"  (enforce ASCII) flag.\n"
"\n"
"ENVIRONMENT VARIABLES\n"
"\n"
"  Curl reads and understands the following environment variables:\n"
"\n"
, stdout);
 fputs(
"        http_proxy, HTTPS_PROXY, FTP_PROXY, GOPHER_PROXY\n"
"\n"
"  They should be set for protocol-specific proxies. General proxy should be\n"
"  set with\n"
"        \n"
"        ALL_PROXY\n"
"\n"
"  A comma-separated list of host names that shouldn't go through any proxy is\n"
"  set in (only an asterisk, '*' matches all hosts)\n"
"\n"
"        NO_PROXY\n"
"\n"
"  If a tail substring of the domain-path for a host matches one of these\n"
"  strings, transactions with that node will not be proxied.\n"
"\n"
"\n"
, stdout);
 fputs(
"  The usage of the -x/--proxy flag overrides the environment variables.\n"
"\n"
"NETRC\n"
"\n"
"  Unix introduced the .netrc concept a long time ago. It is a way for a user\n"
"  to specify name and password for commonly visited ftp sites in a file so\n"
"  that you don't have to type them in each time you visit those sites. You\n"
"  realize this is a big security risk if someone else gets hold of your\n"
"  passwords, so therefor most unix programs won't read this file unless it is\n"
, stdout);
 fputs(
"  only readable by yourself (curl doesn't care though).\n"
"\n"
"  Curl supports .netrc files if told so (using the -n/--netrc and\n"
"  --netrc-optional options). This is not restricted to only ftp,\n"
"  but curl can use it for all protocols where authentication is used.\n"
"\n"
"  A very simple .netrc file could look something like:\n"
"\n"
"        machine curl.haxx.se login iamdaniel password mysecret\n"
"\n"
"CUSTOM OUTPUT\n"
"\n"
"  To better allow script programmers to get to know about the progress of\n"
, stdout);
 fputs(
"  curl, the -w/--write-out option was introduced. Using this, you can specify\n"
"  what information from the previous transfer you want to extract.\n"
"\n"
"  To display the amount of bytes downloaded together with some text and an\n"
"  ending newline:\n"
"\n"
"        curl -w 'We downloaded %{size_download} bytes\\n' www.download.com\n"
"\n"
"KERBEROS4 FTP TRANSFER\n"
"\n"
"  Curl supports kerberos4 for FTP transfers. You need the kerberos package\n"
"  installed and used at curl build time for it to be used.\n"
"\n"
, stdout);
 fputs(
"  First, get the krb-ticket the normal way, like with the kauth tool. Then use\n"
"  curl in way similar to:\n"
"\n"
"        curl --krb4 private ftp://krb4site.com -u username:fakepwd\n"
"\n"
"  There's no use for a password on the -u switch, but a blank one will make\n"
"  curl ask for one and you already entered the real password to kauth.\n"
"\n"
"TELNET\n"
"\n"
"  The curl telnet support is basic and very easy to use. Curl passes all data\n"
"  passed to it on stdin to the remote server. Connect to a remote telnet\n"
, stdout);
 fputs(
"  server using a command line similar to:\n"
"\n"
"        curl telnet://remote.server.com\n"
"\n"
"  And enter the data to pass to the server on stdin. The result will be sent\n"
"  to stdout or to the file you specify with -o.\n"
"\n"
"  You might want the -N/--no-buffer option to switch off the buffered output\n"
"  for slow connections or similar.\n"
"\n"
"  Pass options to the telnet protocol negotiation, by using the -t option. To\n"
"  tell the server we use a vt100 terminal, try something like:\n"
"\n"
, stdout);
 fputs(
"        curl -tTTYPE=vt100 telnet://remote.server.com\n"
"\n"
"  Other interesting options for it -t include:\n"
"\n"
"   - XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"   - NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"  NOTE: the telnet protocol does not specify any way to login with a specified\n"
"  user and password so curl can't do that automatically. To do that, you need\n"
"  to track when the login prompt is received and send the username and\n"
"  password accordingly.\n"
"\n"
"PERSISTANT CONNECTIONS\n"
"\n"
, stdout);
 fputs(
"  Specifying multiple files on a single command line will make curl transfer\n"
"  all of them, one after the other in the specified order.\n"
"\n"
"  libcurl will attempt to use persistant connections for the transfers so that\n"
"  the second transfer to the same host can use the same connection that was\n"
"  already initiated and was left open in the previous transfer. This greatly\n"
"  decreases connection time for all but the first transfer and it makes a far\n"
"  better use of the network.\n"
"\n"
, stdout);
 fputs(
"  Note that curl cannot use persistant connections for transfers that are used\n"
"  in subsequence curl invokes. Try to stuff as many URLs as possible on the\n"
"  same command line if they are using the same host, as that'll make the\n"
"  transfers faster. If you use a http proxy for file transfers, practicly\n"
"  all transfers will be persistant.\n"
"\n"
"MAILING LISTS\n"
"\n"
"  For your convenience, we have several open mailing lists to discuss curl,\n"
"  its development and things relevant to this. Get all info at\n"
, stdout);
 fputs(
"  http://curl.haxx.se/mail/. Some of the lists available are:\n"
"\n"
"  curl-users\n"
"\n"
"    Users of the command line tool. How to use it, what doesn't work, new\n"
"    features, related tools, questions, news, installations, compilations,\n"
"    running, porting etc.\n"
"\n"
"  curl-library\n"
"\n"
"    Developers using or developing libcurl. Bugs, extensions, improvements.\n"
"\n"
"  curl-announce\n"
"\n"
"    Low-traffic. Only receives announcements of new public versions. At worst,\n"
, stdout);
 fputs(
"    that makes something like one or two mails per month, but usually only one\n"
"    mail every second month.\n"
"\n"
"  curl-and-php\n"
"\n"
"    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP\n"
"    with a curl angle.\n"
"\n"
"  curl-and-python\n"
"\n"
"    Python hackers using curl with or without the python binding pycurl.\n"
"\n"
"  Please direct curl questions, feature requests and trouble reports to one of\n"
"  these mailing lists instead of mailing any individual.\n"
, stdout) ;
}
#endif /* USE_MANUAL */
#else
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Fri Oct  8 10:11:25 2004
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
#include <zlib.h>
static const unsigned char hugehelpgz[] = {
  /* This mumbo-jumbo is the huge help text compressed with gzip.
     Thanks to this operation, the size of this data shrunk from 97396
     to 29717 bytes. You can disable the use of compressed help
     texts by NOT passing -c to the mkhelp.pl tool. */
  0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0xed, 0xbd, 
  0xeb, 0x76, 0x1b, 0xd7, 0xb1, 0x2e, 0xfa, 0x9f, 0x4f, 0xd1, 0x81, 0x4f, 
  0x02, 0x32, 0x01, 0xc0, 0x8b, 0x24, 0xc7, 0x52, 0x24, 0xc7, 0x34, 0x45, 
  0xd9, 0x1c, 0xa6, 0x48, 0x6e, 0x92, 0xf2, 0x65, 0x3b, 0x1e, 0x1a, 0x4d, 
  0xa0, 0x41, 0x76, 0x08, 0x74, 0x23, 0xdd, 0x0d, 0x52, 0x70, 0x56, 0xf6, 
  0x1b, 0xe5, 0xdf, 0x7e, 0xc0, 0x53, 0xf5, 0x55, 0xd5, 0x9c, 0xb3, 0x2f, 
  0xa0, 0xe4, 0x24, 0x72, 0xce, 0x8f, 0xe3, 0xb5, 0x22, 0x92, 0x40, 0xf7, 
  0xbc, 0xd6, 0xac, 0x59, 0xd7, 0xaf, 0xa2, 0xe8, 0x7d, 0xff, 0xbd, 0xc5, 
  0xff, 0xde, 0xd2, 0x7f, 0xf2, 0x7b, 0x14, 0x6d, 0x44, 0xd1, 0x59, 0x91, 
  0xff, 0x35, 0x19, 0x57, 0xdd, 0x2f, 0xbc, 0x7d, 0xfb, 0x3f, 0x91, 0xfc, 
  0x1f, 0xbd, 0xf0, 0x17, 0xfc, 0xc4, 0x4b, 0x0f, 0xfc, 0xb7, 0x1d, 0xf9, 
  0x97, 0xfe, 0xe7, 0xed, 0x56, 0xf4, 0x21, 0x2f, 0xfd, 0x4f, 0xb4, 0x89, 
  0x97, 0xde, 0x6a, 0x4f, 0xcf, 0xf9, 0x77, 0x1a, 0xe5, 0xc3, 0x3d, 0xfd, 
  0x85, 0x87, 0xc7, 0xff, 0x6c, 0xf3, 0x8b, 0x7f, 0x79, 0xcb, 0xbf, 0xd2, 
  0x27, 0x1b, 0x1b, 0x27, 0xfb, 0xaf, 0x0f, 0xed, 0xd5, 0xf1, 0xb2, 0x98, 
  0x45, 0xc3, 0xa8, 0x2a, 0xe2, 0xac, 0x9c, 0x26, 0x45, 0x14, 0x47, 0x6f, 
  0xce, 0x8f, 0x37, 0x36, 0x2e, 0x7e, 0x38, 0x39, 0x3d, 0xbb, 0x38, 0xba, 
  0xa8, 0x3d, 0xf6, 0x63, 0xbe, 0xa8, 0xd2, 0x3c, 0x2b, 0x7f, 0x8a, 0x7e, 
  0xa4, 0x87, 0x46, 0xa3, 0xd1, 0x4f, 0x1b, 0x1b, 0x2f, 0x0f, 0x2f, 0x0e, 
  0xce, 0x8f, 0xce, 0x2e, 0x8f, 0x4e, 0x4f, 0x6a, 0xcf, 0xa6, 0x25, 0x35, 
  0x55, 0xe5, 0xf9, 0x8c, 0xfe, 0xf1, 0xad, 0x4f, 0xe2, 0x2a, 0x8e, 0xa6, 
  0x45, 0x3e, 0x8f, 0xf2, 0x82, 0xbf, 0x88, 0xa3, 0x32, 0x29, 0xee, 0x92, 
  0x62, 0x10, 0x2d, 0xcb, 0x34, 0xbb, 0xb6, 0x16, 0xf2, 0x2c, 0x89, 0xf2, 
  0x69, 0x54, 0xdd, 0x24, 0x51, 0xb9, 0x5c, 0x2c, 0xf2, 0xa2, 0x4a, 0x26, 
  0xd1, 0xa2, 0xc8, 0xab, 0x7c, 0x9c, 0xcf, 0xca, 0x68, 0xf3, 0xeb, 0xcb, 
  0xcb, 0xb3, 0x41, 0x14, 0xf1, 0x8f, 0x0b, 0xfa, 0xf9, 0x0a, 0x7f, 0xbd, 
  0xe2, 0x3f, 0xac, 0x85, 0xaf, 0x4e, 0xcf, 0xbe, 0x3e, 0x3c, 0xa7, 0x4f, 
  0x5f, 0x1e, 0x1d, 0x5c, 0xd2, 0x8f, 0xcb, 0xc3, 0xe3, 0x93, 0x43, 0xfe, 
  0xe5, 0xf8, 0xe5, 0xfe, 0x59, 0xc4, 0xbd, 0x47, 0xaf, 0x8e, 0x8e, 0x0f, 
  0xb7, 0x46, 0xf4, 0x15, 0xf5, 0x12, 0x8d, 0xf3, 0xf9, 0x3c, 0xce, 0x26, 
  0x34, 0x6c, 0x6b, 0x61, 0x92, 0x94, 0xe9, 0x75, 0x46, 0xfd, 0xd2, 0x30, 
  0xef, 0xf3, 0xe2, 0x36, 0xba, 0x4f, 0xab, 0x9b, 0x7c, 0x59, 0xd1, 0x48, 
  0x69, 0x22, 0x69, 0x56, 0x25, 0x45, 0x3c, 0xe6, 0xe5, 0x18, 0x6d, 0xd4, 
  0x26, 0x9e, 0x4f, 0x69, 0xa2, 0x3c, 0xf9, 0xab, 0x65, 0x39, 0xcb, 0xe3, 
  0x09, 0x4f, 0x84, 0x5e, 0x99, 0x2e, 0x69, 0x25, 0x8a, 0x74, 0x7c, 0x5b, 
  0x46, 0xb3, 0xf4, 0x36, 0xe1, 0xd9, 0xbc, 0x5b, 0xd9, 0xec, 0xdc, 0xb0, 
  0xd1, 0x76, 0x14, 0x2f, 0x69, 0xe6, 0x59, 0x95, 0x8e, 0x63, 0x6e, 0x9f, 
  0x06, 0x3d, 0xad, 0x16, 0xd1, 0x72, 0xc1, 0xad, 0x0d, 0x30, 0xe9, 0x68, 
  0x91, 0x97, 0xd5, 0x20, 0xba, 0xb8, 0x38, 0x8e, 0x36, 0x6f, 0xaa, 0x6a, 
  0x51, 0x3e, 0xdb, 0x72, 0x63, 0xc8, 0xb3, 0x2c, 0xc1, 0xb8, 0xca, 0x01, 
  0xfd, 0x91, 0xdf, 0xa6, 0x09, 0xfd, 0x32, 0x4d, 0x67, 0x89, 0xdf, 0x85, 
  0x22, 0x29, 0x97, 0x73, 0x9a, 0x34, 0x4f, 0x38, 0x9a, 0xe7, 0x45, 0x42, 
  0xab, 0xb0, 0xef, 0x26, 0xbe, 0xca, 0x97, 0x11, 0x4d, 0x76, 0x36, 0xa3, 
  0xbd, 0x49, 0xa2, 0xab, 0x64, 0x96, 0xdf, 0x0f, 0xb0, 0x15, 0xf1, 0x3c, 
  0x5f, 0x66, 0x15, 0xcf, 0x67, 0x9a, 0xc4, 0xd5, 0x92, 0x5a, 0x91, 0xc7, 
  0xe6, 0x31, 0xcd, 0x87, 0xde, 0x2a, 0xac, 0x85, 0x9b, 0x84, 0xa6, 0x5d, 
  0x2e, 0xd2, 0xec, 0x37, 0x1b, 0x4d, 0x9a, 0x58, 0xe4, 0xf7, 0x49, 0x41, 
  0x8b, 0x7a, 0xb5, 0xa2, 0x65, 0xb8, 0xc2, 0xa7, 0x53, 0xda, 0x8c, 0x98, 
  0x9a, 0x71, 0xe3, 0x1b, 0x16, 0xc9, 0x2c, 0xe6, 0x1d, 0xe7, 0x7e, 0xfe, 
  0x69, 0x2d, 0xa0, 0xc3, 0x51, 0x74, 0x41, 0x63, 0xd2, 0x37, 0x37, 0x1f, 
  0x6d, 0xe1, 0xe5, 0x49, 0x52, 0xc5, 0xe9, 0xac, 0xa4, 0x7d, 0x60, 0xd2, 
  0xd5, 0xc7, 0xb1, 0xab, 0xf4, 0x77, 0x14, 0x95, 0xab, 0xac, 0x8a, 0xdf, 
  0x45, 0xdc, 0xbb, 0xa3, 0x21, 0xde, 0xde, 0x45, 0x92, 0x4d, 0x68, 0x95, 
  0x69, 0xee, 0x3f, 0xe4, 0xcb, 0x3e, 0x0f, 0x60, 0x9a, 0xd2, 0x82, 0xc4, 
  0x9e, 0x00, 0xb8, 0x59, 0x1a, 0x06, 0x51, 0xc2, 0xb8, 0x48, 0x41, 0xfa, 
  0xb4, 0xef, 0xd1, 0xf9, 0xab, 0x83, 0x68, 0xef, 0xd1, 0xd3, 0x4f, 0xfd, 
  0xbe, 0xd3, 0xfb, 0xd1, 0x38, 0xce, 0x68, 0xca, 0xc9, 0x38, 0x9d, 0xae, 
  0xa2, 0xf9, 0x72, 0x56, 0xa5, 0x0b, 0x5a, 0x71, 0xea, 0xbf, 0x64, 0x5a, 
  0x5b, 0xc4, 0x45, 0x55, 0xf2, 0xc2, 0xe1, 0x03, 0x9a, 0x7b, 0x74, 0x5f, 
  0xa4, 0x55, 0x40, 0xf0, 0xfc, 0x00, 0x2d, 0x77, 0x55, 0x82, 0xca, 0xa8, 
  0x93, 0x2b, 0x22, 0x2e, 0x5a, 0xdf, 0xb8, 0xa4, 0x1e, 0x9f, 0xb9, 0x8e, 
  0x22, 0xde, 0xec, 0x67, 0xdb, 0xdb, 0x65, 0x5a, 0x25, 0xa3, 0xbf, 0xd3, 
  0x29, 0x19, 0x54, 0xf7, 0xf9, 0xa0, 0xba, 0x29, 0x92, 0xe4, 0x1f, 0x23, 
  0x22, 0x61, 0xf7, 0x20, 0xd3, 0x37, 0xf6, 0x91, 0x87, 0x75, 0x9d, 0x70, 
  0xdb, 0x7f, 0x5b, 0x26, 0x19, 0x37, 0x49, 0xa3, 0x88, 0x67, 0x8b, 0x9b, 
  0x38, 0x23, 0x12, 0x20, 0x7a, 0xe4, 0x03, 0x48, 0x24, 0xc2, 0x83, 0xaa, 
  0x1d, 0xc1, 0x1f, 0x7f, 0x6a, 0x75, 0x3e, 0x45, 0xdf, 0xf4, 0xef, 0x48, 
  0xdf, 0x8d, 0x69, 0xd1, 0xa9, 0xd7, 0x6d, 0xa6, 0xae, 0x1f, 0x77, 0x87, 
  0xbb, 0x3b, 0x3b, 0x3f, 0x8d, 0xaa, 0x77, 0xd5, 0x07, 0xbe, 0xb0, 0xb3, 
  0xe3, 0x5f, 0xe1, 0xa7, 0x37, 0x79, 0xea, 0xd1, 0x8c, 0x68, 0xc7, 0xed, 
  0x39, 0x8d, 0x27, 0xfa, 0x39, 0x29, 0xf2, 0x72, 0xab, 0xa3, 0xcd, 0x59, 
  0x52, 0xd1, 0x19, 0x0c, 0x1a, 0x8c, 0x87, 0x3f, 0x4b, 0xff, 0xf6, 0xf0, 
  0x49, 0x1e, 0x45, 0x59, 0x52, 0xf2, 0x42, 0x47, 0x3c, 0x6f, 0x61, 0x28, 
  0x6e, 0x25, 0x88, 0x20, 0x3c, 0x77, 0x89, 0x2b, 0x7c, 0x3b, 0xcf, 0xe7, 
  0x44, 0x13, 0xee, 0x3c, 0x5e, 0xd1, 0x79, 0x5f, 0xe9, 0xee, 0xd2, 0xd9, 
  0xa4, 0x97, 0x89, 0x59, 0xc5, 0x33, 0x66, 0x50, 0x25, 0x35, 0x4d, 0x03, 
  0x27, 0xee, 0x90, 0xc4, 0xe3, 0x9b, 0x28, 0xa7, 0xb7, 0x8b, 0xf6, 0x4e, 
  0xc5, 0xd9, 0x6a, 0x94, 0x17, 0xd7, 0xdb, 0x71, 0x31, 0xbe, 0x49, 0xef, 
  0x68, 0x95, 0x9e, 0x3e, 0xfd, 0x74, 0x48, 0xff, 0x3c, 0xfd, 0x69, 0xfb, 
  0x2e, 0x9f, 0xd1, 0xa2, 0x3d, 0xfe, 0x69, 0x9b, 0x37, 0xff, 0xef, 0xf1, 
  0xe0, 0x6a, 0x30, 0xfe, 0xc7, 0xe8, 0xa6, 0x9a, 0xcf, 0x6a, 0x74, 0x85, 
  0xae, 0x1d, 0x65, 0xd1, 0x91, 0x5d, 0x05, 0xe7, 0x50, 0xe8, 0x2b, 0xc3, 
  0xc8, 0x8d, 0x83, 0xcd, 0xd2, 0x2c, 0x19, 0x05, 0xa7, 0x60, 0x25, 0x87, 
  0xf4, 0x2a, 0xa1, 0xd3, 0x54, 0x8d, 0x6f, 0x68, 0xaa, 0x44, 0x5e, 0xb1, 
  0x2e, 0x43, 0x95, 0xc6, 0x7c, 0x7e, 0x89, 0x65, 0x30, 0x4b, 0x43, 0x3b, 
  0xd2, 0x97, 0xdb, 0x82, 0x69, 0x4a, 0x6f, 0xe4, 0xc5, 0x24, 0x29, 0x3c, 
  0xbd, 0x1f, 0xf0, 0xb1, 0x95, 0x66, 0x63, 0xda, 0x83, 0xf9, 0x02, 0xcb, 
  0x50, 0x24, 0x43, 0x5e, 0xa2, 0x80, 0x01, 0xe1, 0x74, 0xba, 0xc3, 0xc0, 
  0x7b, 0xe4, 0x0e, 0xb3, 0x1e, 0x75, 0x62, 0x4d, 0x25, 0x5d, 0x0f, 0x37, 
  0xb4, 0xfa, 0x44, 0xa5, 0xd8, 0xa8, 0x39, 0x4f, 0x91, 0x9f, 0x2d, 0xe5, 
  0xa2, 0xc0, 0x9e, 0xc5, 0xf3, 0x44, 0x6f, 0x0a, 0x6b, 0x01, 0xbd, 0x47, 
  0x59, 0x5e, 0x45, 0x93, 0xdc, 0xf7, 0xa1, 0x9d, 0x97, 0x74, 0xcb, 0x12, 
  0x85, 0x4f, 0xca, 0x1b, 0x62, 0x4d, 0xc4, 0x34, 0x2e, 0x6f, 0x68, 0xaf, 
  0xd3, 0x39, 0x9d, 0xfe, 0xbb, 0xc4, 0xf1, 0x39, 0x9a, 0x67, 0x32, 0x19, 
  0x45, 0xa7, 0x53, 0x7a, 0x6b, 0x59, 0xd0, 0xc8, 0x2b, 0x3c, 0xc5, 0x0b, 
  0x3a, 0x5b, 0x51, 0xab, 0x7c, 0x07, 0x65, 0x3a, 0x12, 0x59, 0x7f, 0x2c, 
  0x45, 0xe6, 0x39, 0x04, 0x9f, 0x97, 0x59, 0x70, 0x79, 0x60, 0xed, 0x85, 
  0xad, 0xd2, 0xae, 0xf1, 0xd8, 0x68, 0xd5, 0x69, 0x4d, 0x88, 0xdd, 0x25, 
  0xd5, 0x7d, 0x92, 0x10, 0x87, 0x48, 0x68, 0xb3, 0x89, 0xb7, 0xd5, 0xd9, 
  0x62, 0x76, 0x97, 0xf3, 0x30, 0x37, 0x36, 0x4e, 0x71, 0x8f, 0xba, 0x4b, 
  0x77, 0x18, 0x6f, 0x0f, 0x87, 0xf1, 0x82, 0x19, 0x55, 0xe3, 0xa6, 0xdf, 
  0xa4, 0xcb, 0x6e, 0x2b, 0xfa, 0x8e, 0x6e, 0x09, 0x69, 0x9f, 0xb7, 0x34, 
  0xe3, 0x1b, 0xd0, 0x5d, 0x13, 0x32, 0x1b, 0x5d, 0xa6, 0x2a, 0x99, 0xcd, 
  0x1a, 0x2d, 0xa0, 0x67, 0x5c, 0xc1, 0x68, 0x1f, 0xb7, 0x34, 0xad, 0x74, 
  0x15, 0x17, 0xcc, 0x2e, 0x70, 0x5f, 0xa4, 0x59, 0x59, 0x25, 0x72, 0x81, 
  0xd1, 0xba, 0x15, 0xff, 0x6c, 0xb4, 0xa0, 0x2c, 0x2c, 0x4a, 0x89, 0x85, 
  0x1e, 0xc9, 0x65, 0x8d, 0xd7, 0x26, 0x79, 0x52, 0x66, 0xfd, 0x2a, 0x4a, 
  0xde, 0xa5, 0x7c, 0x49, 0xa5, 0x95, 0x8d, 0xe2, 0x2a, 0x69, 0x8e, 0xa1, 
  0x48, 0x98, 0xcf, 0x7b, 0xc2, 0xd2, 0xff, 0x8e, 0xa6, 0x36, 0xfc, 0x5c, 
  0xb9, 0x6e, 0x29, 0xd3, 0xac, 0xee, 0xd3, 0x71, 0x32, 0xd0, 0x63, 0x4c, 
  0x7b, 0x3d, 0x81, 0xa4, 0xc0, 0xad, 0x37, 0x5a, 0x98, 0xa4, 0x65, 0x7c, 
  0x45, 0x63, 0xd1, 0xc9, 0xcd, 0xf3, 0x09, 0xfd, 0x7e, 0x1d, 0xa7, 0xc1, 
  0x65, 0x3d, 0xdc, 0xa7, 0xc5, 0xe5, 0xfb, 0x76, 0x18, 0x5f, 0xd3, 0x41, 
  0x88, 0x9e, 0xcb, 0x8f, 0x92, 0x2e, 0xe9, 0xec, 0xfa, 0xf3, 0xe6, 0x7a, 
  0xf3, 0xad, 0xbb, 0x15, 0x5d, 0xe8, 0x31, 0xe4, 0x01, 0xbc, 0xe1, 0x57, 
  0xf7, 0x83, 0x77, 0x78, 0x09, 0x4b, 0xbf, 0x94, 0x8d, 0x16, 0x70, 0x6d, 
  0x2b, 0x0d, 0xd3, 0x95, 0x73, 0x41, 0x7c, 0x26, 0xba, 0x8a, 0x27, 0x46, 
  0x69, 0x07, 0x5f, 0x1d, 0x11, 0xbd, 0xd3, 0x7d, 0x13, 0xa5, 0x53, 0x5a, 
  0xb2, 0x92, 0x29, 0xbb, 0xd1, 0x02, 0x5d, 0x0f, 0xdc, 0x74, 0xef, 0x75, 
  0xfe, 0x33, 0x4d, 0x38, 0xde, 0x7e, 0x3c, 0xda, 0xe9, 0x8d, 0xf8, 0x8c, 
  0x13, 0x97, 0x23, 0x86, 0xc6, 0x53, 0x8c, 0xae, 0x66, 0x71, 0x46, 0x12, 
  0x06, 0xd3, 0x43, 0xc7, 0x18, 0x64, 0x9c, 0x44, 0x1b, 0xe5, 0xb2, 0x28, 
  0x88, 0x87, 0x4c, 0x22, 0x3d, 0xf1, 0x32, 0x7e, 0xdc, 0x3d, 0x9e, 0xaa, 
  0xff, 0xb6, 0xcc, 0xab, 0x66, 0x0b, 0xf3, 0xb8, 0xb8, 0x2d, 0x21, 0x33, 
  0xd1, 0x96, 0x30, 0x67, 0x22, 0x8e, 0x9e, 0x33, 0x95, 0xf3, 0xe0, 0xe4, 
  0x75, 0xb4, 0x38, 0xfc, 0x9a, 0x16, 0x97, 0xc5, 0x00, 0x7f, 0x60, 0xed, 
  0x66, 0x92, 0x1d, 0xcd, 0xed, 0xd4, 0xad, 0xdf, 0x7c, 0xbf, 0xf7, 0xdc, 
  0x38, 0x8b, 0x29, 0xcc, 0x28, 0xe8, 0xd5, 0xcc, 0x68, 0x60, 0x16, 0x97, 
  0x15, 0x53, 0x40, 0x93, 0x30, 0x95, 0xdf, 0xf1, 0x23, 0xbc, 0xb6, 0xcc, 
  0x5e, 0xfa, 0x42, 0x41, 0xc1, 0xf6, 0x0f, 0x89, 0xcf, 0xb0, 0xa0, 0xd5, 
  0xbd, 0xd3, 0x97, 0x74, 0x62, 0xca, 0xe0, 0x94, 0x10, 0x69, 0x5f, 0x93, 
  0x00, 0x42, 0xe3, 0xa7, 0x1b, 0xa1, 0x21, 0xa0, 0x35, 0xd7, 0x28, 0x21, 
  0x39, 0x91, 0x96, 0x96, 0xaf, 0x79, 0xda, 0xc9, 0x64, 0x36, 0x1d, 0x80, 
  0x25, 0x2c, 0xcb, 0x44, 0xaf, 0x98, 0x92, 0xef, 0xe3, 0x31, 0x37, 0x27, 
  0xc3, 0x6b, 0x4e, 0xa0, 0x48, 0xe6, 0xb4, 0xf4, 0x11, 0xdf, 0xf2, 0xd1, 
  0x78, 0x16, 0xa7, 0xf3, 0x92, 0x4f, 0x91, 0xde, 0x55, 0x6e, 0xf9, 0x21, 
  0xd0, 0x80, 0x78, 0xa8, 0xab, 0x46, 0x0b, 0xd3, 0xb4, 0xa0, 0x4e, 0xe8, 
  0x5b, 0xec, 0x6b, 0xcc, 0x4d, 0x12, 0xbb, 0xa7, 0x8f, 0xc0, 0x9b, 0x6e, 
  0x92, 0xf1, 0x2d, 0x08, 0x96, 0x46, 0x43, 0x42, 0xd5, 0x82, 0x58, 0x75, 
  0x32, 0x6c, 0xb4, 0x20, 0x9b, 0x57, 0xf2, 0x42, 0x2f, 0x59, 0x0e, 0x98, 
  0x2c, 0xc7, 0xfc, 0x0a, 0xad, 0x3f, 0xdd, 0x7a, 0x45, 0x4c, 0x97, 0x5f, 
  0x05, 0xa9, 0x18, 0x74, 0x34, 0x24, 0x02, 0x5a, 0x8c, 0x1a, 0x2d, 0xb8, 
  0x41, 0x2a, 0x87, 0x72, 0xcc, 0xa4, 0x54, 0x4e, 0x1f, 0x1b, 0x5b, 0x1d, 
  0xeb, 0x82, 0x36, 0x39, 0x8c, 0x2d, 0xb0, 0x2e, 0xe9, 0x20, 0xba, 0xbf, 
  0x49, 0xe9, 0xaa, 0x75, 0x82, 0x0d, 0xb3, 0x7e, 0xa5, 0xba, 0xe1, 0xf0, 
  0x2a, 0x2e, 0xd3, 0xf1, 0xa0, 0xd1, 0xc2, 0x70, 0x38, 0x49, 0xaf, 0x13, 
  0x66, 0x43, 0xfc, 0x7b, 0x56, 0xcd, 0xe6, 0xfc, 0x1b, 0x78, 0x35, 0xfd, 
  0x99, 0x5c, 0xe7, 0x74, 0x01, 0x56, 0x2c, 0xfe, 0x6e, 0xee, 0x4f, 0x26, 
  0x2c, 0x71, 0xa6, 0xcd, 0xdd, 0xfc, 0xe3, 0x68, 0x77, 0x67, 0xf4, 0xe9, 
  0x56, 0x07, 0x95, 0x36, 0x88, 0x14, 0xb3, 0x34, 0xf9, 0xa0, 0x4a, 0xe7, 
  0x49, 0x29, 0x44, 0x3a, 0xcd, 0x67, 0x24, 0x41, 0x07, 0x92, 0x95, 0x1d, 
  0x84, 0x31, 0x51, 0x40, 0x21, 0x92, 0x08, 0x24, 0xe8, 0x2c, 0x27, 0xb6, 
  0xc5, 0xca, 0x03, 0x7f, 0x16, 0x10, 0xea, 0x15, 0x1d, 0x25, 0x11, 0xe4, 
  0xa3, 0xe7, 0x19, 0x5d, 0x84, 0x2f, 0x58, 0x89, 0x5a, 0xc3, 0xa0, 0xa2, 
  0xb3, 0xb8, 0x2c, 0xf5, 0x0c, 0x42, 0xd7, 0x02, 0xed, 0xe2, 0xcf, 0x90, 
  0x01, 0xb1, 0x68, 0x17, 0x37, 0x99, 0x31, 0xba, 0xa0, 0xa5, 0x38, 0xaa, 
  0x84, 0xb4, 0x40, 0x6f, 0x34, 0x29, 0x62, 0x51, 0x61, 0x83, 0x24, 0x43, 
  0x27, 0x77, 0x69, 0x4e, 0xca, 0xcd, 0xaa, 0x45, 0xb6, 0xe3, 0x84, 0x64, 
  0x1c, 0x96, 0xdb, 0xf9, 0xe2, 0x56, 0x36, 0x8d, 0xfe, 0x20, 0x72, 0xf4, 
  0x2e, 0x92, 0x6a, 0x78, 0x80, 0x6e, 0x9e, 0xf5, 0xea, 0x72, 0x4a, 0x20, 
  0xb4, 0xa3, 0x97, 0x92, 0x34, 0xad, 0x19, 0x5f, 0x9b, 0x8e, 0x95, 0x45, 
  0x2c, 0x4c, 0xcc, 0x49, 0x4e, 0x88, 0x7a, 0xac, 0xbe, 0xee, 0xbe, 0xf8, 
  0x76, 0xff, 0xf8, 0xcd, 0xe1, 0xee, 0x9f, 0x1a, 0x2d, 0xf0, 0x77, 0x7b, 
  0xf2, 0xdd, 0x5e, 0xaf, 0x8b, 0xb7, 0xd0, 0x2a, 0xf7, 0x5f, 0xf4, 0x23, 
  0x11, 0x1e, 0x03, 0xea, 0x14, 0x86, 0x42, 0x63, 0xc2, 0x8d, 0x45, 0x9f, 
  0x57, 0x72, 0x39, 0x35, 0x5a, 0xe0, 0x85, 0xc3, 0x35, 0xc7, 0x3b, 0x81, 
  0xc5, 0xe5, 0x63, 0x8d, 0x5f, 0x0a, 0x26, 0xef, 0x60, 0x75, 0x98, 0xaf, 
  0x12, 0xd3, 0x9a, 0x74, 0xae, 0xb3, 0xc8, 0x0a, 0xa5, 0x2c, 0x15, 0xd1, 
  0xa4, 0x50, 0x76, 0x30, 0x6f, 0x3f, 0x2c, 0xaf, 0x92, 0xba, 0x8b, 0xa0, 
  0x2c, 0x41, 0x74, 0xb8, 0x74, 0x49, 0xdd, 0x88, 0x49, 0xae, 0x1b, 0xd1, 
  0x85, 0x24, 0x67, 0x9a, 0xc6, 0xae, 0x2c, 0x08, 0xcc, 0x99, 0x95, 0xd4, 
  0xe6, 0xc1, 0xba, 0xa3, 0x99, 0x19, 0x99, 0xf4, 0x6c, 0x40, 0x24, 0x99, 
  0xd0, 0x6e, 0xf5, 0xdc, 0x58, 0xbc, 0x6e, 0xc7, 0x5c, 0xb0, 0xbd, 0xd7, 
  0x24, 0x14, 0xd2, 0x00, 0x49, 0xf6, 0xe1, 0x6e, 0x55, 0xd3, 0x64, 0x8d, 
  0xdf, 0x8e, 0xe9, 0x3c, 0x5e, 0xf1, 0x44, 0x58, 0x0e, 0x63, 0x4e, 0x38, 
  0x6d, 0xb4, 0x40, 0xa7, 0xb8, 0xcf, 0x0c, 0x55, 0xd4, 0x8e, 0xc8, 0x6e, 
  0x7c, 0xec, 0x37, 0x4b, 0x54, 0x57, 0x69, 0x26, 0x87, 0xdf, 0xdf, 0x2b, 
  0xcd, 0xc3, 0x7d, 0x4c, 0x27, 0x63, 0x96, 0x2b, 0x8f, 0x90, 0x93, 0x38, 
  0x02, 0x0d, 0x41, 0x0e, 0x51, 0x7a, 0x31, 0xb9, 0xbf, 0x26, 0x7f, 0x1a, 
  0x83, 0x71, 0xdb, 0x66, 0xe3, 0x07, 0xe5, 0xfa, 0x5d, 0x58, 0x10, 0xf7, 
  0xcd, 0xe4, 0xe8, 0x28, 0x43, 0x6c, 0x9e, 0xe2, 0x02, 0x8d, 0x9f, 0x90, 
  0xea, 0x36, 0x8e, 0x17, 0xc9, 0xb6, 0x5e, 0xce, 0xb6, 0xcb, 0xc1, 0x40, 
  0x5a, 0xc4, 0x78, 0x72, 0x7a, 0x79, 0x28, 0xa2, 0xaf, 0x13, 0x9d, 0xbc, 
  0x98, 0x69, 0x6c, 0x2d, 0x38, 0xfc, 0x51, 0x8b, 0x10, 0x20, 0xa8, 0x0a, 
  0xa5, 0x30, 0x61, 0xd2, 0xd2, 0x2d, 0x96, 0x24, 0x8c, 0x91, 0xda, 0x63, 
  0xd3, 0xb1, 0xab, 0x50, 0x28, 0xb1, 0xcd, 0xdd, 0xac, 0xe7, 0x11, 0x4b, 
  0x11, 0x78, 0xc8, 0xdb, 0x0c, 0xec, 0xbe, 0x1a, 0x8e, 0xdd, 0x18, 0x86, 
  0x7f, 0x8d, 0xd7, 0xdd, 0xe7, 0x85, 0xe8, 0x49, 0x58, 0x38, 0x62, 0x82, 
  0x24, 0xea, 0xc6, 0x77, 0xf2, 0x7e, 0xb8, 0x7a, 0x10, 0x38, 0x5b, 0x77, 
  0xd5, 0x2c, 0x51, 0x22, 0x18, 0xbe, 0xa4, 0xae, 0x26, 0xcb, 0xf9, 0x42, 
  0x65, 0x87, 0xdf, 0xbc, 0x9f, 0xed, 0x3e, 0x28, 0x1b, 0xfc, 0xcb, 0xc2, 
  0xc1, 0x97, 0x22, 0x1b, 0x0e, 0xe3, 0x72, 0x9c, 0xa6, 0x8d, 0x16, 0x48, 
  0xf0, 0x8b, 0xf6, 0x2f, 0x0e, 0x8e, 0x8e, 0xbc, 0x41, 0xe5, 0x9e, 0x05, 
  0x71, 0x53, 0x60, 0x54, 0x10, 0xc7, 0xb4, 0x68, 0x59, 0xd8, 0xe0, 0xd4, 
  0x68, 0x21, 0xcd, 0xa6, 0xf9, 0x28, 0x7a, 0x45, 0x5f, 0xc2, 0x72, 0x55, 
  0x35, 0x85, 0xa9, 0x84, 0xbe, 0x2f, 0xc6, 0x89, 0xca, 0x10, 0x35, 0xb5, 
  0xdc, 0xd8, 0x50, 0x06, 0xdb, 0x06, 0xa8, 0x87, 0x44, 0x4e, 0x31, 0x1b, 
  0x44, 0xbd, 0x3f, 0x55, 0xab, 0x45, 0xf2, 0x62, 0xbf, 0xa7, 0x1a, 0x8f, 
  0xae, 0xd2, 0x38, 0xa6, 0xa9, 0x34, 0x69, 0x47, 0xd8, 0x2c, 0x4b, 0xaf, 
  0x2c, 0xb6, 0x56, 0x13, 0x96, 0x6b, 0x2a, 0xf4, 0xce, 0x4c, 0x87, 0x35, 
  0x5b, 0x91, 0x9a, 0xa1, 0xc3, 0x51, 0xf3, 0xd9, 0xa3, 0xbd, 0x26, 0x1b, 
  0x5a, 0xd1, 0x8d, 0x3e, 0x2f, 0x3f, 0xa2, 0xf4, 0x2e, 0xab, 0xbc, 0x2c, 
  0x49, 0x32, 0x0f, 0x05, 0x37, 0xdc, 0xf4, 0x0f, 0x89, 0x6d, 0x90, 0xda, 
  0x68, 0x32, 0x4c, 0xc1, 0xa0, 0xbe, 0x2f, 0xf9, 0x8d, 0x86, 0xd4, 0xb6, 
  0x56, 0x5c, 0xd1, 0xcb, 0x2e, 0x99, 0xc6, 0xa4, 0x55, 0xaa, 0xb0, 0xd0, 
  0xba, 0xeb, 0x97, 0xf1, 0xac, 0x75, 0xff, 0x2d, 0x48, 0xda, 0xaa, 0x48, 
  0x5b, 0xe4, 0xb3, 0x93, 0xf1, 0x4f, 0x1c, 0x09, 0x1e, 0x44, 0x8a, 0xb5, 
  0x65, 0x25, 0xaa, 0x48, 0x79, 0x4d, 0x63, 0xbd, 0x27, 0x9a, 0x7c, 0xd9, 
  0xee, 0x0d, 0xa2, 0x69, 0xed, 0x0c, 0x3b, 0x0c, 0xc3, 0x50, 0xec, 0xa4, 
  0x83, 0x2a, 0x98, 0x49, 0x5b, 0x64, 0x72, 0xe2, 0x52, 0xb4, 0x59, 0x2e, 
  0x89, 0x0d, 0x13, 0x63, 0x30, 0xc9, 0xc7, 0xa4, 0x21, 0xcc, 0xc9, 0xe4, 
  0x9f, 0x66, 0x0b, 0x74, 0x35, 0x6c, 0x8d, 0x4c, 0x1e, 0x22, 0x5a, 0xf8, 
  0xef, 0x0b, 0x40, 0xc3, 0x71, 0xba, 0xb8, 0x61, 0xe6, 0xf1, 0x7c, 0x96, 
  0x96, 0x60, 0xe8, 0xfa, 0x41, 0x4b, 0x08, 0xba, 0xb8, 0x38, 0x36, 0x25, 
  0x0d, 0xdc, 0x0f, 0xf7, 0x90, 0xbd, 0xad, 0x04, 0x91, 0x9a, 0xb9, 0x84, 
  0x2d, 0x05, 0x5d, 0xcb, 0x67, 0x26, 0x61, 0x74, 0x86, 0xeb, 0xc3, 0x5a, 
  0x88, 0xe6, 0x4b, 0xfe, 0xe8, 0xca, 0xd8, 0xd5, 0x5d, 0x3c, 0x4b, 0x5b, 
  0xd7, 0xbb, 0x3c, 0x3b, 0x8a, 0xce, 0xf9, 0x5e, 0x59, 0x2e, 0xd8, 0x60, 
  0xc0, 0x76, 0x5a, 0xf9, 0x5c, 0x1a, 0x55, 0x83, 0xa5, 0x58, 0x6e, 0x5a, 
  0x5c, 0x9d, 0x0e, 0xf6, 0x33, 0x33, 0x1f, 0xdd, 0xdf, 0xdf, 0x8f, 0x72, 
  0x52, 0x61, 0xcb, 0x72, 0x06, 0x33, 0xd2, 0x24, 0x1f, 0x97, 0xdb, 0xa4, 
  0xd4, 0x96, 0xdb, 0xd6, 0x4f, 0xcd, 0x60, 0xb4, 0x5e, 0x85, 0x5a, 0xb7, 
  0x39, 0x0f, 0xa9, 0x50, 0x8e, 0x5e, 0xc1, 0x2b, 0x2b, 0x74, 0x17, 0xee, 
  0x4a, 0x3e, 0x27, 0x22, 0x2e, 0xcb, 0x96, 0x84, 0xa3, 0x67, 0xf1, 0xdc, 
  0x54, 0x8e, 0xc8, 0x3f, 0xe9, 0xd4, 0x0d, 0xbb, 0xf5, 0xa1, 0xbe, 0xe4, 
  0xd3, 0x8e, 0x6b, 0x89, 0xb8, 0xe1, 0x75, 0x5e, 0x10, 0x5b, 0x23, 0xed, 
  0xc7, 0xd9, 0x8a, 0x9d, 0x12, 0x34, 0x90, 0x83, 0x59, 0x24, 0xd5, 0xb2, 
  0xc8, 0x3a, 0x64, 0x83, 0x65, 0x16, 0x74, 0x4a, 0xab, 0xb6, 0x9c, 0x8b, 
  0xa9, 0x77, 0x0d, 0xd9, 0x72, 0x63, 0x1d, 0x63, 0x50, 0xe9, 0xb5, 0x04, 
  0x8b, 0x65, 0x13, 0x60, 0xe6, 0x0d, 0x86, 0x50, 0xb9, 0xa1, 0x4e, 0xc3, 
  0x1c, 0xd6, 0xc1, 0xc6, 0x8a, 0x84, 0x1f, 0x85, 0xca, 0x44, 0xea, 0x76, 
  0x31, 0xfa, 0xd7, 0x8e, 0x90, 0x98, 0x17, 0xe5, 0xb4, 0xfc, 0xb3, 0xd5, 
  0x03, 0x9d, 0x14, 0xd9, 0xac, 0x2a, 0xbf, 0x66, 0xad, 0x3d, 0xe5, 0xdd, 
  0xdc, 0xce, 0xa7, 0xd3, 0xfa, 0x4e, 0xc1, 0x2a, 0x36, 0xe4, 0x16, 0x99, 
  0xcf, 0x3f, 0x17, 0xf6, 0xdb, 0x3a, 0x3f, 0xaf, 0xe3, 0x77, 0xe9, 0x7c, 
  0xc9, 0x92, 0x3b, 0x3d, 0xc8, 0x07, 0x45, 0x9f, 0x13, 0x2e, 0xc4, 0xcc, 
  0x2c, 0xe6, 0xa3, 0xfc, 0x9e, 0xf3, 0x63, 0xa6, 0x24, 0x5d, 0x3c, 0xfe, 
  0x8b, 0x4e, 0xb7, 0x69, 0xad, 0x22, 0xb3, 0xcc, 0xd2, 0x39, 0x1b, 0x39, 
  0x3a, 0x36, 0xce, 0x9b, 0x0f, 0x89, 0x47, 0xde, 0xc4, 0x25, 0x5d, 0x18, 
  0xb8, 0xd5, 0x4d, 0x17, 0xbf, 0x61, 0x41, 0x47, 0x1f, 0xe2, 0x3b, 0xa5, 
  0x7d, 0x7e, 0xfc, 0x72, 0xe6, 0x10, 0xf7, 0x21, 0x1d, 0xd0, 0xca, 0x8a, 
  0xef, 0x40, 0x2e, 0x59, 0xb5, 0x52, 0xcc, 0xe9, 0x9a, 0x9f, 0xc7, 0xef, 
  0x86, 0xad, 0x59, 0xd0, 0xf4, 0x55, 0x9e, 0xfc, 0x48, 0x67, 0x4b, 0x25, 
  0xfc, 0x60, 0x97, 0xea, 0x52, 0x56, 0xf4, 0x1c, 0xf2, 0x03, 0x6b, 0x19, 
  0xcd, 0x5d, 0x72, 0x46, 0xa8, 0x5c, 0x19, 0x1c, 0x9e, 0xe4, 0xdd, 0xb9, 
  0x8f, 0xe9, 0x6e, 0xf0, 0x26, 0x0b, 0x36, 0xd0, 0x61, 0xc2, 0xb3, 0x4e, 
  0x15, 0x84, 0xd6, 0x31, 0x9e, 0x56, 0xf0, 0x37, 0x41, 0xe0, 0x5e, 0x90, 
  0x4e, 0xc4, 0x06, 0xce, 0x05, 0xcd, 0x43, 0xf8, 0xa0, 0x10, 0x36, 0xb7, 
  0xd2, 0x5c, 0x63, 0xf6, 0xd7, 0x58, 0x2b, 0x81, 0xc6, 0x03, 0x59, 0x1a, 
  0x22, 0x74, 0x1c, 0x85, 0xc2, 0x6c, 0x87, 0xe8, 0xcd, 0xdb, 0x18, 0xdd, 
  0x27, 0x6c, 0x17, 0xe4, 0x5f, 0xe1, 0x00, 0x72, 0xe3, 0x6a, 0x6a, 0x92, 
  0x62, 0x10, 0x69, 0xa9, 0x41, 0x4c, 0x5f, 0x9b, 0xe5, 0xd6, 0x48, 0xf5, 
  0x3a, 0x7b, 0x3d, 0xa6, 0xfd, 0xbe, 0xcd, 0xf2, 0xfb, 0x6c, 0xc0, 0x9f, 
  0x62, 0x75, 0x74, 0xcd, 0x3b, 0x2c, 0x98, 0x55, 0x92, 0x8d, 0xcc, 0x5d, 
  0x84, 0x47, 0x9d, 0xb1, 0xd2, 0x7d, 0xef, 0x54, 0x94, 0x36, 0xb5, 0x9a, 
  0xdc, 0xdf, 0x25, 0xef, 0xf3, 0xa8, 0x60, 0xaa, 0xe0, 0xeb, 0x7c, 0xad, 
  0x0a, 0x02, 0x3d, 0x12, 0xdb, 0x15, 0x7b, 0xd3, 0xdb, 0x24, 0x2e, 0x6f, 
  0x06, 0x51, 0x6f, 0xd8, 0x1b, 0xe8, 0x59, 0xab, 0x49, 0xf3, 0xdd, 0xb3, 
  0xf0, 0x72, 0x5c, 0xb7, 0xa6, 0xa1, 0x26, 0x5a, 0x1d, 0x28, 0x93, 0x18, 
  0x89, 0x9c, 0x7d, 0x98, 0xa8, 0xd5, 0x0e, 0x0b, 0xaf, 0x91, 0xb6, 0xd6, 
  0x52, 0x94, 0x06, 0x3a, 0x85, 0xfb, 0x9b, 0x7c, 0xe6, 0x0e, 0xa3, 0xa3, 
  0x95, 0xe8, 0x3e, 0xe7, 0xb6, 0x60, 0xc0, 0xa4, 0x56, 0x58, 0x01, 0x78, 
  0x98, 0x19, 0x46, 0xe3, 0x59, 0x12, 0x17, 0xb3, 0x95, 0xa9, 0xad, 0xc3, 
  0x3b, 0x99, 0x1d, 0x1b, 0x9f, 0x69, 0x21, 0xee, 0xe3, 0xa2, 0x65, 0x0d, 
  0xc2, 0x16, 0x90, 0x68, 0x48, 0x3a, 0xd9, 0x2a, 0x61, 0x0b, 0x37, 0x3b, 
  0x67, 0xc0, 0x99, 0x58, 0x5b, 0x87, 0x38, 0x4f, 0x24, 0x78, 0x97, 0x96, 
  0x29, 0xcb, 0x8e, 0xd3, 0x24, 0x99, 0x34, 0x5b, 0xb8, 0x8a, 0xc7, 0xb7, 
  0xd8, 0x12, 0xf4, 0x72, 0x05, 0x91, 0xf7, 0x06, 0x4e, 0xc9, 0x92, 0x5f, 
  0x5a, 0xb1, 0x55, 0xe0, 0x26, 0xe6, 0x5b, 0x26, 0xad, 0x96, 0x9d, 0x42, 
  0x62, 0x4b, 0xb6, 0x85, 0xc0, 0x28, 0x57, 0xc8, 0x1a, 0x0e, 0xd0, 0xa4, 
  0x5a, 0x3a, 0x15, 0x38, 0x14, 0xee, 0x7c, 0xaf, 0x63, 0x08, 0x07, 0x60, 
  0x08, 0x24, 0xe5, 0x65, 0x4b, 0x52, 0x44, 0x88, 0x6b, 0x13, 0x57, 0x27, 
  0x52, 0x6a, 0xb2, 0x83, 0x03, 0x7d, 0x64, 0xfb, 0x5c, 0xbc, 0xba, 0xb1, 
  0x3b, 0x90, 0x46, 0xd0, 0x4e, 0x4d, 0x61, 0x27, 0x57, 0x07, 0x11, 0x5f, 
  0xa7, 0xac, 0xaf, 0x45, 0xd2, 0xbc, 0x28, 0xd0, 0xf2, 0x91, 0x7c, 0x62, 
  0xcb, 0x9b, 0xbc, 0x8b, 0xc7, 0x55, 0x94, 0x2d, 0xe7, 0x57, 0x6d, 0xa3, 
  0xee, 0x94, 0x34, 0x15, 0x36, 0x29, 0x60, 0x3b, 0xfc, 0x01, 0x2a, 0x6f, 
  0xd3, 0xc5, 0x22, 0x81, 0x7a, 0xbd, 0xcc, 0xaa, 0x9a, 0x65, 0xa8, 0xb9, 
  0x35, 0xc9, 0x75, 0x9a, 0x65, 0x35, 0x47, 0x5d, 0x54, 0xe6, 0x4b, 0xd2, 
  0x82, 0x64, 0x12, 0x57, 0xc9, 0x94, 0xd9, 0xb8, 0x99, 0x66, 0x68, 0x42, 
  0xcd, 0xcd, 0x9d, 0xc2, 0xaf, 0xac, 0x77, 0xcf, 0x04, 0x5e, 0x3f, 0x65, 
  0x63, 0xd8, 0x35, 0xd9, 0x23, 0xd1, 0xaa, 0xc5, 0x47, 0x52, 0x0e, 0xba, 
  0xa4, 0x0e, 0x76, 0xb5, 0xdb, 0xd5, 0xe5, 0x1d, 0x3b, 0x17, 0x47, 0xff, 
  0xfb, 0x50, 0xe6, 0x55, 0xf3, 0xea, 0xac, 0x3a, 0x9c, 0x2a, 0xad, 0xd3, 
  0xc7, 0xfa, 0x62, 0x6f, 0x78, 0x10, 0x0d, 0x7b, 0x18, 0x1d, 0xb3, 0x3c, 
  0x53, 0x50, 0x48, 0x8e, 0xcf, 0x89, 0x55, 0xb0, 0x63, 0x94, 0x6f, 0x45, 
  0xf8, 0x9f, 0xd9, 0xc2, 0xdc, 0x3c, 0xe1, 0x24, 0x7a, 0x25, 0xdb, 0x37, 
  0x74, 0xf3, 0x8a, 0x9f, 0x0d, 0xfb, 0x0c, 0x6f, 0x8d, 0xee, 0xec, 0x88, 
  0x8d, 0x76, 0x95, 0x7a, 0x83, 0xca, 0xb5, 0x5b, 0x4c, 0x2d, 0x2f, 0x96, 
  0xd5, 0x36, 0xcc, 0x04, 0xea, 0xd8, 0xaa, 0x72, 0xb3, 0x6c, 0x63, 0xeb, 
  0xba, 0xb8, 0xc7, 0x87, 0x4b, 0xfa, 0xef, 0xd3, 0xb9, 0x85, 0xc0, 0xbd, 
  0x58, 0x02, 0xb6, 0x43, 0x3a, 0x49, 0xcb, 0xaa, 0x02, 0xc7, 0x96, 0x6e, 
  0x19, 0x89, 0x21, 0x74, 0x0a, 0xfe, 0x4a, 0x02, 0x9d, 0x30, 0x1a, 0xde, 
  0x41, 0x98, 0x25, 0x72, 0x1d, 0xd1, 0xa0, 0xcb, 0x3e, 0x85, 0x2e, 0xa5, 
  0x03, 0x3c, 0x4d, 0xe2, 0x02, 0xc9, 0x82, 0x71, 0x41, 0x67, 0x3c, 0xa7, 
  0xd5, 0x26, 0x3e, 0x42, 0x77, 0x4c, 0x95, 0xd3, 0xdf, 0x37, 0x29, 0x4d, 
  0xa3, 0x18, 0xdf, 0xac, 0x3a, 0x2e, 0xa8, 0x8c, 0x98, 0x08, 0xfb, 0x08, 
  0xeb, 0xea, 0x34, 0x5a, 0x95, 0x33, 0xc1, 0x63, 0x8f, 0x58, 0xb4, 0xa4, 
  0x2f, 0x5a, 0x72, 0x70, 0xd7, 0x50, 0x89, 0x7c, 0x6e, 0x98, 0xca, 0x93, 
  0x19, 0x0b, 0x24, 0x47, 0x46, 0xea, 0xc3, 0x7c, 0xfd, 0xe5, 0x80, 0x2d, 
  0x85, 0x6e, 0x54, 0x30, 0x6f, 0x15, 0xab, 0x9f, 0xf4, 0x4c, 0xc7, 0x41, 
  0x3b, 0xa7, 0x5b, 0x6f, 0xc6, 0xb7, 0x6f, 0x73, 0x16, 0xea, 0x84, 0xd3, 
  0xd7, 0x6d, 0x23, 0xd6, 0x39, 0xde, 0x2e, 0x73, 0x5b, 0x33, 0x75, 0x41, 
  0xd8, 0x32, 0x89, 0x36, 0x15, 0x5c, 0x85, 0x12, 0x72, 0x53, 0x15, 0xab, 
  0x96, 0xc1, 0x9d, 0x0e, 0x50, 0xb8, 0xb3, 0x35, 0x39, 0xb4, 0x98, 0x4d, 
  0xd5, 0x75, 0xc9, 0x6c, 0x8b, 0xe8, 0xa7, 0x8a, 0x8e, 0x5f, 0x31, 0x0d, 
  0x1e, 0x9c, 0xd3, 0x4f, 0xda, 0x69, 0x39, 0x99, 0x7c, 0x29, 0x20, 0x60, 
  0x86, 0x6d, 0x0f, 0xaf, 0xbf, 0xbd, 0x68, 0xea, 0x17, 0xa7, 0x17, 0xdb, 
  0x8f, 0x9e, 0xee, 0x6c, 0x7d, 0x28, 0xa5, 0xb6, 0xed, 0x0e, 0xe2, 0xba, 
  0x66, 0x7f, 0xe0, 0x1a, 0xcb, 0x03, 0x46, 0x3a, 0x96, 0x21, 0xd2, 0x7c, 
  0x83, 0x49, 0x4c, 0xd8, 0x42, 0xc5, 0xb6, 0x93, 0xe7, 0x0f, 0x99, 0xe1, 
  0x2f, 0xa0, 0x31, 0x48, 0x97, 0x4e, 0x0c, 0xc2, 0x6b, 0xb0, 0x84, 0x9f, 
  0x9d, 0x5e, 0x5c, 0x9a, 0x4b, 0xa6, 0x6d, 0x92, 0x74, 0x46, 0x33, 0x8b, 
  0x8d, 0xc2, 0x3b, 0xf7, 0xf1, 0x4a, 0xce, 0x28, 0x5b, 0x8a, 0x92, 0xf9, 
  0x92, 0x43, 0x64, 0x10, 0xa2, 0xd1, 0x54, 0x9e, 0x62, 0x0b, 0x23, 0x82, 
  0xa8, 0x4c, 0x54, 0x35, 0x33, 0x9f, 0xff, 0xd7, 0x97, 0xaf, 0x8f, 0x21, 
  0x9d, 0x40, 0x77, 0x32, 0xed, 0xa8, 0xc3, 0x4f, 0xb8, 0xbc, 0x22, 0xf1, 
  0x9c, 0xef, 0xd7, 0x8a, 0xf9, 0xe7, 0x49, 0x5e, 0x25, 0xde, 0x50, 0x29, 
  0xb3, 0x60, 0xff, 0x00, 0x5b, 0x22, 0xe4, 0x56, 0x98, 0x75, 0x1d, 0x9e, 
  0x96, 0x31, 0x33, 0x63, 0x47, 0x25, 0x9c, 0x47, 0x8b, 0x22, 0xe7, 0xe3, 
  0xc8, 0x94, 0x24, 0x51, 0x1f, 0x6d, 0x19, 0x35, 0x4b, 0xee, 0xc5, 0x42, 
  0x3e, 0x5e, 0xb2, 0xca, 0x3f, 0x75, 0x91, 0x5a, 0xe2, 0x85, 0xe0, 0x01, 
  0x24, 0xef, 0x16, 0xa2, 0x04, 0x40, 0x7c, 0x6a, 0xc9, 0x45, 0x3d, 0xe2, 
  0x0a, 0x43, 0x71, 0x8c, 0x4e, 0x7a, 0xce, 0x69, 0x26, 0x97, 0x13, 0x4c, 
  0x62, 0x91, 0xe3, 0xc3, 0x0b, 0xf6, 0x9a, 0xb4, 0xd7, 0x01, 0x5d, 0xd5, 
  0xb5, 0x99, 0x65, 0x69, 0x8e, 0x33, 0xbe, 0x9a, 0x69, 0x05, 0x86, 0x6c, 
  0x72, 0x8b, 0xd8, 0xd1, 0x3c, 0x5b, 0x63, 0x8e, 0xd9, 0x7e, 0x37, 0x24, 
  0x35, 0x7e, 0xc8, 0xeb, 0x3e, 0xa4, 0xfe, 0x74, 0x44, 0x23, 0x3e, 0x02, 
  0xf3, 0x05, 0xcb, 0xaa, 0xdc, 0xc5, 0xf0, 0x15, 0xd1, 0x15, 0x3f, 0x32, 
  0xfa, 0x30, 0x9a, 0xae, 0x9b, 0x3c, 0xd9, 0x92, 0xa0, 0x77, 0x26, 0x71, 
  0x8c, 0x96, 0xb4, 0x1f, 0x44, 0x27, 0x0c, 0x6a, 0xbe, 0x9c, 0x45, 0xca, 
  0x6c, 0x31, 0xd8, 0xa9, 0x6e, 0x09, 0x73, 0x9e, 0x14, 0xd7, 0xb8, 0x5b, 
  0x49, 0x6e, 0x62, 0x23, 0x86, 0x6c, 0x99, 0x05, 0x33, 0x80, 0x1f, 0xfc, 
  0x6e, 0x28, 0x1e, 0x15, 0xac, 0xf3, 0xb2, 0x75, 0xb5, 0x2a, 0xd7, 0xe8, 
  0x0f, 0x27, 0x91, 0xba, 0xb0, 0xb2, 0x34, 0x99, 0xd1, 0x69, 0x62, 0x11, 
  0x61, 0x36, 0x7b, 0x31, 0x23, 0x71, 0x65, 0xd5, 0x27, 0x29, 0x92, 0xcd, 
  0xc7, 0xd7, 0x49, 0xd6, 0x8e, 0x36, 0x60, 0x6a, 0x17, 0xe2, 0x8e, 0x10, 
  0xfd, 0x86, 0x99, 0xdd, 0x2c, 0xb3, 0x5b, 0xb9, 0xb9, 0x63, 0x7c, 0x30, 
  0x23, 0xe1, 0xb6, 0xc4, 0xe3, 0x1c, 0x63, 0xd7, 0x68, 0xa1, 0x1f, 0xf4, 
  0xfc, 0xbb, 0xb0, 0xdb, 0x4e, 0x1d, 0x4f, 0x24, 0xf7, 0x8a, 0xe3, 0xb2, 
  0x1c, 0xd5, 0x3b, 0x86, 0xae, 0xde, 0xa3, 0x2f, 0x06, 0xe6, 0x42, 0x6d, 
  0x49, 0x79, 0xce, 0x83, 0x10, 0x07, 0x82, 0x1e, 0x2e, 0xef, 0x78, 0xe2, 
  0x1b, 0x54, 0xe7, 0x0f, 0xcb, 0xdd, 0x4d, 0x1d, 0x34, 0xd5, 0x31, 0x78, 
  0x9d, 0xae, 0xf3, 0x6d, 0x16, 0xf9, 0x53, 0x35, 0x59, 0xb5, 0x35, 0x69, 
  0x26, 0xd0, 0xd2, 0x22, 0x29, 0x31, 0x0e, 0x58, 0xb0, 0xf4, 0xaa, 0x10, 
  0x19, 0x2d, 0x38, 0x25, 0x4d, 0xda, 0x7b, 0x6d, 0x61, 0x35, 0x2a, 0x2c, 
  0xd4, 0x1c, 0xfe, 0x46, 0x33, 0xa3, 0xe8, 0x2c, 0x97, 0x10, 0x2b, 0x1e, 
  0x54, 0x53, 0x28, 0x13, 0x5d, 0xd0, 0x2d, 0xc1, 0x24, 0xea, 0x4f, 0xf3, 
  0xfc, 0x2a, 0x2e, 0x6c, 0xaf, 0xe1, 0x5d, 0xbe, 0x4a, 0xd4, 0x8f, 0xcd, 
  0x0b, 0xdc, 0xf6, 0xe0, 0xf2, 0x5c, 0xbf, 0x90, 0xd7, 0x7a, 0x5d, 0x57, 
  0x96, 0xd0, 0x03, 0x1e, 0x5b, 0x90, 0x24, 0x43, 0x92, 0x14, 0xfb, 0x8e, 
  0x8a, 0xd5, 0x00, 0x0b, 0xa8, 0x5b, 0x61, 0xfe, 0x67, 0x3a, 0x3d, 0x1d, 
  0x62, 0x9f, 0xf4, 0x32, 0x94, 0xf7, 0xd6, 0xa9, 0xfe, 0x9e, 0xf7, 0xab, 
  0x44, 0x8c, 0xb0, 0x24, 0xd8, 0x57, 0xf1, 0x36, 0x9c, 0x05, 0xff, 0x86, 
  0xf8, 0x84, 0xa0, 0xb2, 0x69, 0x3e, 0x6b, 0x92, 0xbe, 0x58, 0x4f, 0x75, 
  0x0f, 0xd9, 0xaf, 0x2f, 0xd7, 0x97, 0x84, 0xb6, 0x70, 0xcf, 0xe1, 0x1d, 
  0xeb, 0x47, 0xf2, 0xe0, 0x0d, 0x75, 0xa9, 0xb1, 0x4e, 0xd8, 0xd1, 0x34, 
  0x96, 0x50, 0x2d, 0xac, 0x84, 0x9b, 0xe4, 0x7a, 0x03, 0xc8, 0xaf, 0x3e, 
  0x1f, 0xdd, 0x97, 0xf7, 0x4e, 0x88, 0x09, 0xa1, 0x74, 0x57, 0x44, 0xa6, 
  0x3a, 0xf5, 0x3c, 0x9d, 0x91, 0xb6, 0x6b, 0x61, 0x6e, 0xb4, 0x61, 0x9d, 
  0x24, 0xa6, 0x8b, 0x86, 0xf0, 0xa5, 0x01, 0x2d, 0x0a, 0x07, 0xfb, 0x5e, 
  0xdf, 0x88, 0xd4, 0xb3, 0xf4, 0xae, 0x55, 0x99, 0x76, 0x07, 0x09, 0xb1, 
  0x1c, 0x56, 0xe8, 0xb5, 0xf0, 0xae, 0xb2, 0x43, 0xc7, 0x23, 0x72, 0x57, 
  0x3f, 0x0d, 0xed, 0x36, 0x59, 0xb0, 0x4f, 0xa1, 0x6c, 0x1d, 0xf7, 0x72, 
  0xe4, 0xf9, 0x0e, 0xce, 0x3c, 0x5f, 0x4b, 0x39, 0xcc, 0xa7, 0x3a, 0x7b, 
  0x35, 0x64, 0x48, 0x10, 0x72, 0x77, 0x70, 0xcf, 0x62, 0xe8, 0xae, 0x4d, 
  0x0d, 0xd1, 0xb5, 0x71, 0xd4, 0xe7, 0xa8, 0xd2, 0x68, 0x6b, 0x16, 0x42, 
  0x13, 0x53, 0x71, 0xe6, 0xfd, 0xd7, 0x77, 0x1e, 0xbe, 0x8a, 0xee, 0xdd, 
  0x3e, 0xcc, 0x58, 0x4c, 0x2b, 0x45, 0x4c, 0x7a, 0xa9, 0x4e, 0x8d, 0xba, 
  0x7b, 0xc7, 0x39, 0x74, 0xda, 0xe2, 0x51, 0xfd, 0x49, 0xbb, 0x3e, 0x58, 
  0x6d, 0x06, 0xbf, 0xc4, 0xbe, 0x91, 0x44, 0x70, 0xcf, 0x1e, 0x6e, 0xe6, 
  0x60, 0x2d, 0x5d, 0x95, 0x27, 0x01, 0xf1, 0x27, 0x87, 0x85, 0xf3, 0x86, 
  0xf7, 0xa5, 0x80, 0xc5, 0x14, 0x66, 0x0d, 0xf8, 0xcf, 0x20, 0xc4, 0xea, 
  0x9a, 0x66, 0xed, 0x2b, 0xd9, 0xb9, 0xb7, 0xdd, 0xa5, 0x92, 0xb1, 0xd9, 
  0x88, 0xee, 0xc4, 0xa5, 0xc6, 0xa5, 0x39, 0x17, 0x10, 0x87, 0x95, 0x55, 
  0xad, 0x0b, 0x95, 0x1e, 0xc0, 0xa5, 0x02, 0x51, 0x4e, 0x47, 0x2b, 0x26, 
  0x4e, 0xb0, 0x68, 0x17, 0xed, 0xf2, 0x80, 0x9f, 0xc7, 0x45, 0xc2, 0x68, 
  0x28, 0x94, 0x38, 0xfb, 0x2c, 0xfa, 0x5a, 0x83, 0xfd, 0x03, 0x5f, 0x50, 
  0x57, 0x08, 0xe1, 0xff, 0x07, 0xdc, 0x43, 0x2a, 0xb4, 0x0f, 0x93, 0x45, 
  0x51, 0x75, 0xc6, 0x49, 0xc2, 0x2d, 0xe8, 0x2e, 0x51, 0x93, 0xf1, 0xb9, 
  0x73, 0x96, 0x02, 0xf5, 0x84, 0x1c, 0x9e, 0x9d, 0x5f, 0x76, 0xb8, 0x01, 
  0x8e, 0xf9, 0x63, 0x15, 0xa1, 0x54, 0x07, 0x92, 0xa8, 0x2a, 0x8e, 0xab, 
  0xb8, 0x4b, 0xe0, 0xea, 0x75, 0xd1, 0xac, 0x62, 0x32, 0xed, 0x52, 0x45, 
  0x75, 0x77, 0x59, 0xcb, 0x8f, 0x67, 0x24, 0xca, 0x97, 0x2e, 0x46, 0x2b, 
  0x88, 0xa0, 0xe5, 0xd1, 0xf0, 0x30, 0x3a, 0x0c, 0x13, 0x99, 0x0c, 0x44, 
  0xcd, 0x20, 0xc2, 0x8f, 0xce, 0x4e, 0xe9, 0x51, 0x58, 0xc1, 0x94, 0x86, 
  0xbc, 0x5d, 0xaa, 0xd9, 0x82, 0x0f, 0xc2, 0x84, 0xdc, 0xcb, 0x6f, 0x46, 
  0x51, 0x91, 0x5e, 0xdf, 0xf0, 0x00, 0x68, 0x38, 0x23, 0x37, 0x7d, 0xe9, 
  0x87, 0xc4, 0xd2, 0x96, 0x22, 0x49, 0xc2, 0x44, 0x09, 0x4d, 0x53, 0x25, 
  0x62, 0xd2, 0x0a, 0xaf, 0x89, 0x88, 0x67, 0x58, 0x02, 0x17, 0x59, 0x3f, 
  0x88, 0x10, 0xf8, 0xd1, 0x11, 0xbf, 0x88, 0x70, 0x31, 0x48, 0xaa, 0x31, 
  0x72, 0x0b, 0x58, 0x9e, 0x2e, 0x31, 0xfc, 0x04, 0xa7, 0x59, 0x64, 0xda, 
  0xa9, 0x2a, 0xfa, 0x74, 0x2b, 0x55, 0xab, 0x96, 0x05, 0x90, 0xb9, 0xa1, 
  0xc8, 0x5e, 0xaa, 0x0e, 0x65, 0x66, 0x07, 0x99, 0xa4, 0xf2, 0x96, 0xce, 
  0x4d, 0x77, 0xac, 0x29, 0xd1, 0x10, 0x29, 0x07, 0x5e, 0xcd, 0x27, 0x5b, 
  0x1f, 0xec, 0xbb, 0x6e, 0x10, 0xae, 0x84, 0x7c, 0x7f, 0x98, 0x4b, 0x46, 
  0xce, 0x41, 0xcb, 0x29, 0xe3, 0xa9, 0xb6, 0xbc, 0xeb, 0xa4, 0xda, 0x0f, 
  0x23, 0xda, 0x8b, 0x6f, 0x79, 0xae, 0xff, 0x6c, 0xc5, 0x69, 0xf2, 0xc1, 
  0x16, 0x8d, 0x5d, 0x83, 0x00, 0x99, 0x47, 0xac, 0x21, 0xd8, 0x2e, 0xe7, 
  0x95, 0xa3, 0x57, 0x25, 0x57, 0xa1, 0xd6, 0x80, 0x58, 0x85, 0x92, 0x30, 
  0x00, 0x25, 0xcb, 0x46, 0x0b, 0x67, 0xfb, 0x17, 0xdf, 0xaa, 0x95, 0x36, 
  0x20, 0x50, 0x33, 0x84, 0xa4, 0x95, 0xb7, 0xa7, 0x55, 0xc5, 0xaa, 0x33, 
  0xca, 0x81, 0x1b, 0xff, 0x55, 0xbc, 0x66, 0xdd, 0x5b, 0xd4, 0x08, 0x46, 
  0x11, 0x97, 0x4c, 0x53, 0xfc, 0xf8, 0x0e, 0x4e, 0x16, 0x5c, 0x19, 0x96, 
  0x5b, 0x12, 0xc4, 0xba, 0xd4, 0x0d, 0x00, 0x88, 0xb4, 0xd9, 0xe8, 0x8c, 
  0x3b, 0xf0, 0xb3, 0x91, 0x78, 0x29, 0xe5, 0x06, 0xd8, 0xc1, 0x50, 0x24, 
  0x40, 0x8c, 0x4e, 0x87, 0xf4, 0xe1, 0xfa, 0xe4, 0xab, 0x2c, 0x56, 0xf3, 
  0x01, 0x8f, 0x4c, 0x7c, 0x97, 0xf4, 0x26, 0xdf, 0xe8, 0xac, 0x73, 0xc2, 
  0x95, 0xd0, 0x25, 0xa6, 0x8b, 0x62, 0x68, 0x0d, 0x69, 0x28, 0x8f, 0xf0, 
  0x9e, 0xab, 0x44, 0x54, 0x0f, 0xcd, 0x1c, 0x60, 0x1b, 0x4a, 0xd7, 0x5d, 
  0x20, 0x81, 0xec, 0x2e, 0x95, 0x44, 0x4d, 0x5b, 0x61, 0x08, 0x93, 0x4c, 
  0xf3, 0x37, 0x5d, 0xea, 0x4a, 0xd3, 0x01, 0x16, 0x5a, 0xd8, 0x6f, 0xf2, 
  0xfb, 0x04, 0x61, 0x8b, 0xb5, 0xd3, 0x9f, 0xb7, 0x24, 0xa0, 0x20, 0x7e, 
  0xa9, 0xb5, 0xce, 0x3e, 0x58, 0x3e, 0xcf, 0x2c, 0xee, 0x26, 0x81, 0xb9, 
  0x57, 0x55, 0x7b, 0xe7, 0x9a, 0x16, 0x01, 0xaa, 0xcd, 0x02, 0x69, 0xda, 
  0x65, 0x3a, 0x81, 0x99, 0x59, 0x65, 0x80, 0xa8, 0xa7, 0xcb, 0xd5, 0x73, 
  0x71, 0x22, 0x6c, 0x76, 0x87, 0x52, 0xcf, 0xf1, 0x4f, 0x1d, 0x3e, 0xe5, 
  0x22, 0xf9, 0xe8, 0x06, 0x56, 0x47, 0xc0, 0x09, 0xad, 0x68, 0x91, 0xf0, 
  0x8d, 0x49, 0xc4, 0xfb, 0xe6, 0xfc, 0xf8, 0x61, 0x6b, 0x15, 0x77, 0xd0, 
  0x3b, 0xd7, 0xc7, 0xcf, 0xe2, 0xeb, 0xa4, 0x87, 0x40, 0x25, 0xf6, 0x65, 
  0x79, 0xaf, 0xee, 0xc3, 0x51, 0xed, 0x42, 0xcb, 0x08, 0xcd, 0x15, 0x37, 
  0x2b, 0x9c, 0x00, 0x89, 0x31, 0x80, 0xce, 0x20, 0x3e, 0x1f, 0x29, 0xce, 
  0x84, 0x38, 0x8b, 0xaf, 0x23, 0x0d, 0xba, 0x90, 0xf0, 0xf0, 0x86, 0x35, 
  0xb8, 0x4b, 0x43, 0xac, 0x85, 0x01, 0x5a, 0xb6, 0x8e, 0x0a, 0x95, 0xbd, 
  0x3f, 0xb1, 0x8d, 0xbd, 0x67, 0x67, 0x51, 0x57, 0xa3, 0x1d, 0x71, 0xc1, 
  0x0f, 0xb8, 0x58, 0xc7, 0x86, 0x5d, 0x1e, 0x81, 0xf7, 0x38, 0xe0, 0xea, 
  0x57, 0x09, 0xd2, 0xcc, 0xbc, 0x85, 0x3e, 0x63, 0x96, 0x26, 0xc2, 0x0c, 
  0x07, 0xeb, 0x44, 0xc7, 0x3a, 0xa2, 0x67, 0x76, 0xa6, 0xcc, 0x80, 0xa5, 
  0x43, 0xea, 0x8c, 0xcd, 0x97, 0xc5, 0x33, 0xff, 0x42, 0x3c, 0xe3, 0x14, 
  0x2f, 0x09, 0xa7, 0x4b, 0xc5, 0x99, 0x38, 0x81, 0x9f, 0x8d, 0x47, 0x14, 
  0x67, 0xad, 0xdb, 0x31, 0x45, 0x3a, 0x8f, 0xce, 0xf1, 0xd7, 0xb3, 0xe3, 
  0x27, 0xd9, 0x5d, 0x5a, 0xe4, 0x19, 0x5b, 0xa2, 0x9b, 0x04, 0x76, 0x7e, 
  0x74, 0x71, 0x10, 0x45, 0xa7, 0x17, 0xf4, 0xbf, 0x93, 0xe3, 0x1f, 0x40, 
  0x6a, 0x08, 0x65, 0xa2, 0xfb, 0xe7, 0x1a, 0x97, 0x58, 0xf0, 0x6e, 0x74, 
  0x17, 0x17, 0x6d, 0x29, 0x95, 0xc5, 0xfc, 0x41, 0xc0, 0x4f, 0x58, 0xe6, 
  0x15, 0x5a, 0x1d, 0xde, 0x3b, 0x16, 0x11, 0x44, 0x85, 0xb4, 0xb8, 0x42, 
  0x12, 0x97, 0x69, 0x52, 0x68, 0xe4, 0x02, 0xcc, 0x8f, 0x63, 0xcb, 0x40, 
  0xd0, 0xb4, 0xcc, 0x90, 0xca, 0xe1, 0x11, 0x6f, 0x86, 0xc2, 0xc7, 0x77, 
  0xdc, 0x7b, 0xb1, 0xcc, 0xba, 0x1d, 0x3c, 0xbf, 0xde, 0x8d, 0x34, 0x4c, 
  0xae, 0x27, 0x43, 0xe8, 0x81, 0x9d, 0x77, 0x11, 0xce, 0xf3, 0xc5, 0x56, 
  0x54, 0xcb, 0x53, 0x59, 0xc4, 0x74, 0xf2, 0xcc, 0xfc, 0x04, 0x99, 0x21, 
  0xab, 0x8a, 0x7c, 0xb1, 0x8a, 0xbe, 0xa2, 0x2f, 0x9a, 0x03, 0x49, 0x40, 
  0x84, 0x2f, 0xe3, 0x64, 0x4e, 0x13, 0x29, 0xf3, 0xf1, 0xad, 0x39, 0x04, 
  0xe5, 0x77, 0x6f, 0x52, 0x67, 0x9d, 0xa4, 0xd3, 0x76, 0x4c, 0x3b, 0x3b, 
  0xe1, 0xcb, 0x24, 0xc9, 0xae, 0x91, 0x0c, 0x85, 0xf0, 0x41, 0x0e, 0x80, 
  0x0a, 0x13, 0xc3, 0x02, 0x3d, 0xa5, 0x83, 0x23, 0x0c, 0xa5, 0x0d, 0x99, 
  0x68, 0xd3, 0x0a, 0x31, 0x3c, 0xe4, 0x6b, 0x82, 0x3d, 0x07, 0xcf, 0xf9, 
  0x5f, 0xce, 0x1e, 0x20, 0x6d, 0xe5, 0xc7, 0x67, 0xa6, 0x02, 0xfd, 0xb4, 
  0x6e, 0x51, 0xda, 0xa1, 0x81, 0xf5, 0xcb, 0x39, 0x68, 0xad, 0x2b, 0x40, 
  0x55, 0x85, 0x29, 0x17, 0xe4, 0xe9, 0xd5, 0x71, 0x49, 0x43, 0x96, 0x65, 
  0xd2, 0x46, 0x9a, 0xcb, 0xca, 0x8d, 0x8a, 0xe9, 0x4d, 0xe2, 0x2b, 0xcf, 
  0x0e, 0x5f, 0xbb, 0x28, 0x01, 0x73, 0xcc, 0xcb, 0x44, 0xd9, 0xfb, 0xcc, 
  0x53, 0xf9, 0x67, 0x5b, 0x78, 0xe6, 0xe4, 0x64, 0x1c, 0x7e, 0x1b, 0xb2, 
  0x17, 0xa2, 0xa8, 0xd5, 0xbf, 0x2d, 0x39, 0x8f, 0x73, 0x82, 0xf5, 0xce, 
  0xbb, 0x22, 0xa2, 0x88, 0xae, 0xe7, 0x2c, 0xae, 0xd7, 0xed, 0xf9, 0x1c, 
  0x79, 0xea, 0x27, 0x6e, 0x86, 0xad, 0x45, 0x91, 0xde, 0xb5, 0xd7, 0xe1, 
  0x36, 0x59, 0xe1, 0x96, 0x0b, 0x9e, 0xa8, 0xbd, 0x4c, 0x1b, 0xcc, 0x3f, 
  0x33, 0xd6, 0x1e, 0x7f, 0xf3, 0xab, 0xc5, 0xcd, 0x80, 0x18, 0xc4, 0x0a, 
  0xff, 0x9c, 0xff, 0xed, 0x0e, 0x0a, 0x0c, 0x76, 0xff, 0x1e, 0x4e, 0x94, 
  0x60, 0xdc, 0x78, 0x57, 0x25, 0xb8, 0x3b, 0xba, 0xe0, 0x5b, 0xb2, 0x4d, 
  0xf0, 0x6c, 0x04, 0x75, 0x7e, 0xc4, 0x3b, 0x38, 0x88, 0x5e, 0x1e, 0x9e, 
  0x63, 0x41, 0x0e, 0x4f, 0xbe, 0xc2, 0x9d, 0xcf, 0x41, 0xf1, 0xd7, 0x59, 
  0xfa, 0x73, 0xfb, 0xde, 0xa7, 0x1e, 0xca, 0x5f, 0xef, 0xde, 0x1f, 0x8e, 
  0x63, 0x39, 0x21, 0x07, 0xfb, 0xe1, 0xe0, 0x3f, 0xd2, 0xc9, 0xa0, 0x77, 
  0x68, 0xc0, 0x8e, 0xdd, 0x24, 0x7c, 0xd3, 0xb9, 0x20, 0x7c, 0xd6, 0x05, 
  0xd9, 0x24, 0xc6, 0x61, 0xf4, 0x9c, 0xa6, 0xd9, 0x76, 0x90, 0xc0, 0xbe, 
  0x4c, 0x03, 0x0d, 0xbb, 0x29, 0x6b, 0xa7, 0x89, 0x3f, 0xd9, 0x2c, 0xb7, 
  0xec, 0x00, 0xb5, 0x95, 0xc2, 0xe0, 0x38, 0x6d, 0x74, 0xa6, 0x39, 0xba, 
  0x8d, 0xb1, 0xe8, 0xde, 0xf0, 0xda, 0xc1, 0xbd, 0x03, 0xe5, 0x4a, 0x4c, 
  0xd4, 0x4d, 0xb7, 0xc1, 0x01, 0x5d, 0xf7, 0x6f, 0x0f, 0xf6, 0xdf, 0x7e, 
  0xf9, 0xe6, 0xe4, 0xe5, 0xf1, 0x61, 0x5f, 0x1c, 0xb0, 0x12, 0x75, 0x42, 
  0xf7, 0xb0, 0xcb, 0xed, 0x92, 0x93, 0x03, 0x47, 0x7b, 0x33, 0x2e, 0x98, 
  0x39, 0x30, 0x12, 0x47, 0xf0, 0x1b, 0x60, 0x0f, 0x6c, 0xc2, 0xac, 0x1f, 
  0x65, 0x93, 0x99, 0x0b, 0x8f, 0xeb, 0xb6, 0x2f, 0x5a, 0x24, 0xa6, 0xca, 
  0xf7, 0x36, 0xe0, 0x0e, 0x5d, 0x82, 0x59, 0x12, 0x31, 0x4f, 0x12, 0x41, 
  0x58, 0xbb, 0xb6, 0x4c, 0x3b, 0xd3, 0xf1, 0x1a, 0x82, 0x0d, 0xbb, 0x4b, 
  0x9a, 0x3b, 0xca, 0xc9, 0xf8, 0x6e, 0x74, 0x2e, 0x84, 0x44, 0x6c, 0xf7, 
  0xd1, 0xff, 0xe5, 0x96, 0x88, 0xba, 0x86, 0x3a, 0xe8, 0x71, 0x51, 0xfd, 
  0xdf, 0xa6, 0xa9, 0x21, 0x49, 0xe1, 0x23, 0xd2, 0x30, 0x5b, 0x98, 0xc8, 
  0xbd, 0xb3, 0x3d, 0x16, 0x3a, 0x1b, 0x25, 0xef, 0x48, 0xae, 0xc9, 0xed, 
  0xa9, 0x66, 0x44, 0x0b, 0xec, 0x3e, 0x55, 0xf4, 0x5d, 0x5e, 0x20, 0x4d, 
  0xed, 0xa5, 0xbd, 0x6e, 0xaf, 0x70, 0x86, 0x30, 0x8b, 0x5a, 0x90, 0x19, 
  0x59, 0x48, 0xba, 0x6e, 0xe7, 0x96, 0x90, 0x08, 0xbb, 0x7f, 0xf9, 0xf5, 
  0xe8, 0x57, 0x64, 0x43, 0x31, 0x76, 0xb7, 0x71, 0xe6, 0xfc, 0xdc, 0xff, 
  0xf3, 0xa7, 0xcf, 0x2f, 0xeb, 0xba, 0x23, 0x18, 0x1e, 0x29, 0x1c, 0x9f, 
  0x96, 0x25, 0xb3, 0x7e, 0x7c, 0x06, 0x8e, 0xbf, 0xfb, 0xb6, 0x71, 0xea, 
  0x6e, 0x38, 0x99, 0x83, 0x1e, 0x6f, 0xd3, 0xb6, 0x78, 0x72, 0x99, 0x38, 
  0x02, 0xd7, 0xe8, 0xdb, 0x22, 0xb9, 0x89, 0xcb, 0x9b, 0x68, 0x59, 0xa5, 
  0x6c, 0xc6, 0x81, 0x7c, 0x36, 0x13, 0xff, 0x62, 0x4b, 0x7c, 0xb7, 0xf0, 
  0x66, 0x0b, 0x04, 0xb3, 0x85, 0x34, 0x35, 0x82, 0xc5, 0xb6, 0x20, 0xa8, 
  0x91, 0x85, 0xf4, 0xa6, 0x7c, 0xc6, 0x08, 0x18, 0x35, 0xf9, 0x82, 0x06, 
  0xcd, 0x09, 0x48, 0xac, 0x0e, 0x26, 0x53, 0x9a, 0x7f, 0x4a, 0xe4, 0x34, 
  0x53, 0x7b, 0x51, 0x97, 0xa1, 0xc1, 0x71, 0xcc, 0xd4, 0xac, 0xe5, 0xfa, 
  0x37, 0xa8, 0x5f, 0xf9, 0x57, 0x29, 0xa9, 0xe9, 0xb2, 0xbf, 0x6d, 0x3e, 
  0x66, 0x9c, 0xeb, 0x57, 0xa3, 0xb8, 0x29, 0x7b, 0x8c, 0xe3, 0x74, 0xd6, 
  0xad, 0xd4, 0xbd, 0xe2, 0x50, 0xbc, 0x92, 0x13, 0xd5, 0x78, 0xe6, 0x9b, 
  0x59, 0xae, 0xd1, 0x3f, 0x1c, 0x03, 0x46, 0x8b, 0xba, 0x25, 0x96, 0xb8, 
  0x7a, 0x4e, 0xbd, 0x13, 0x02, 0x8b, 0xbc, 0xa8, 0xa7, 0x99, 0x72, 0xce, 
  0x2a, 0xdb, 0x2e, 0xe1, 0xa6, 0x03, 0x7e, 0x09, 0xa6, 0x84, 0x84, 0x91, 
  0xaa, 0x2d, 0x31, 0xab, 0x41, 0x4f, 0x60, 0x33, 0xd8, 0x53, 0x5f, 0x8d, 
  0xcd, 0x49, 0x0f, 0xf5, 0x3d, 0x9a, 0x24, 0xf1, 0xcc, 0x94, 0xc2, 0x29, 
  0x50, 0x36, 0x5a, 0xd6, 0x69, 0x18, 0x9a, 0xe0, 0x15, 0xc9, 0xcc, 0x34, 
  0x3e, 0x8e, 0x4b, 0x8b, 0x43, 0x89, 0xc3, 0x08, 0x09, 0x34, 0x51, 0xb6, 
  0x03, 0x29, 0x26, 0xc9, 0x2c, 0x15, 0xb3, 0x81, 0x45, 0x80, 0x43, 0x64, 
  0x92, 0xa0, 0x71, 0x28, 0x69, 0x88, 0x88, 0x70, 0xdf, 0xb6, 0x54, 0x32, 
  0x75, 0x6e, 0xb3, 0x26, 0xbb, 0xa9, 0x59, 0x71, 0xf9, 0x14, 0x11, 0xa1, 
  0xa2, 0xde, 0x0a, 0x32, 0xc8, 0x15, 0x06, 0xb5, 0xea, 0x30, 0x1e, 0x33, 
  0x05, 0x6e, 0xa9, 0x27, 0x02, 0xaa, 0x2d, 0xb6, 0x52, 0x1d, 0x0d, 0x42, 
  0xd4, 0x62, 0x7a, 0x91, 0xbd, 0xa9, 0xda, 0x94, 0x29, 0xf6, 0x1c, 0x3a, 
  0x94, 0xd3, 0xda, 0x7e, 0xaa, 0x37, 0xf3, 0x23, 0x46, 0xc0, 0x48, 0x57, 
  0xe8, 0x76, 0x59, 0xd4, 0xcc, 0xed, 0x8d, 0x00, 0x9f, 0xf5, 0xc8, 0x04, 
  0x9a, 0x08, 0x45, 0xd7, 0xe7, 0xb6, 0x0f, 0x14, 0xc5, 0x4d, 0x89, 0x04, 
  0x98, 0x58, 0xb2, 0xfa, 0xe2, 0xe6, 0xb2, 0x1b, 0x7e, 0x80, 0x98, 0xff, 
  0x79, 0xb6, 0x08, 0x62, 0x32, 0x9c, 0x0b, 0x0b, 0x8a, 0xc1, 0xef, 0x15, 
  0x2d, 0x4d, 0x5c, 0x4c, 0x5a, 0x6c, 0x8d, 0x55, 0x36, 0x16, 0x84, 0xa7, 
  0x0e, 0x78, 0x06, 0x39, 0xdc, 0x34, 0x99, 0x51, 0xa4, 0x8c, 0xe6, 0x41, 
  0x7b, 0xf9, 0xd8, 0x23, 0x5c, 0x98, 0xe3, 0x38, 0x30, 0x7d, 0x6a, 0x8c, 
  0xd4, 0x3c, 0x95, 0x10, 0x16, 0xf0, 0xca, 0x16, 0x43, 0x40, 0xd0, 0x54, 
  0x2b, 0x91, 0xe6, 0x8f, 0x5b, 0xff, 0xad, 0x2d, 0x23, 0xad, 0xa2, 0xdb, 
  0xce, 0xcc, 0x6e, 0x2a, 0xb6, 0xd5, 0xca, 0xc1, 0x32, 0xd3, 0x30, 0x47, 
  0x3d, 0xc9, 0xc7, 0xaa, 0x13, 0x00, 0xf1, 0xe8, 0x9f, 0xad, 0x00, 0xb5, 
  0x99, 0xcb, 0x94, 0xb2, 0x55, 0x17, 0x97, 0x44, 0xcb, 0x65, 0x2a, 0xfc, 
  0xbc, 0x25, 0xbe, 0x89, 0x59, 0x87, 0x77, 0xa7, 0x9d, 0x1e, 0x95, 0x97, 
  0x6e, 0xf0, 0x1c, 0x3b, 0xec, 0x74, 0xc1, 0x96, 0x4d, 0xdf, 0xaf, 0xf0, 
  0xee, 0x68, 0xe7, 0xbf, 0xb6, 0xc2, 0x74, 0x8b, 0x75, 0xbb, 0x9f, 0xa2, 
  0xd7, 0x6c, 0x59, 0x12, 0xc9, 0x13, 0xce, 0x92, 0x30, 0xc9, 0xa1, 0x24, 
  0x2e, 0xc8, 0x8c, 0x45, 0x4d, 0xea, 0xcd, 0x60, 0xff, 0x8b, 0xe3, 0xed, 
  0xcb, 0xe3, 0x8b, 0xd1, 0xaf, 0x39, 0x4b, 0x6e, 0x26, 0x98, 0x9b, 0x45, 
  0x26, 0x69, 0xf6, 0xb9, 0x86, 0x95, 0xac, 0xb3, 0x25, 0xca, 0x9d, 0x31, 
  0x63, 0x33, 0x0f, 0x0e, 0x91, 0x8b, 0x54, 0x0b, 0x22, 0xd1, 0xd0, 0x5a, 
  0xab, 0x7b, 0x61, 0xb0, 0xb1, 0xb8, 0x36, 0x39, 0x76, 0x2d, 0x08, 0x50, 
  0x73, 0x31, 0x69, 0x2e, 0x28, 0x0d, 0x1d, 0xb5, 0xd4, 0x6c, 0xe1, 0x2e, 
  0x5e, 0x5a, 0x40, 0xa0, 0x9d, 0x78, 0xdf, 0xbd, 0x78, 0x72, 0xa0, 0x91, 
  0x5b, 0x97, 0xa4, 0x95, 0x35, 0x19, 0x36, 0x22, 0x5e, 0xe2, 0xa2, 0xda, 
  0x46, 0xb8, 0x96, 0x04, 0x12, 0xc4, 0x63, 0xce, 0x75, 0x16, 0x9e, 0x41, 
  0x6d, 0x9e, 0xbf, 0x3a, 0xd8, 0xfd, 0xec, 0xd3, 0x3f, 0x8e, 0xa2, 0xce, 
  0x31, 0x24, 0xea, 0x99, 0x96, 0x48, 0x46, 0x7e, 0x89, 0x83, 0xa3, 0xbd, 
  0x07, 0xbf, 0xe4, 0xcb, 0x10, 0xe9, 0xb6, 0xc8, 0xf1, 0xec, 0x10, 0x7f, 
  0xfb, 0xba, 0xc2, 0x7d, 0x41, 0x85, 0x92, 0xa4, 0x4c, 0x44, 0x12, 0xa1, 
  0x81, 0x01, 0x0e, 0xc7, 0x34, 0x7d, 0xf7, 0xbe, 0x9c, 0x02, 0xb9, 0x5d, 
  0xe9, 0xd0, 0x7d, 0x11, 0x31, 0x92, 0x19, 0xfa, 0xfc, 0x2b, 0x0b, 0x73, 
  0xd7, 0x6a, 0xcf, 0xd4, 0x7e, 0xd0, 0xcd, 0xfa, 0xb8, 0x9d, 0x81, 0x75, 
  0xe7, 0x62, 0x88, 0x34, 0x68, 0xdd, 0x81, 0x7d, 0xcc, 0xba, 0x44, 0x80, 
  0xe7, 0x2e, 0x5e, 0xcf, 0xf9, 0x6c, 0x23, 0x07, 0x83, 0xf3, 0x05, 0xae, 
  0xb4, 0xe7, 0xca, 0x5a, 0x34, 0xcb, 0xf1, 0x8b, 0x96, 0x0f, 0xeb, 0x36, 
  0xb1, 0x6c, 0x7b, 0x89, 0xd8, 0xaf, 0xaa, 0xd8, 0x00, 0x8c, 0xd0, 0xb1, 
  0xc4, 0x81, 0xc5, 0x72, 0x9f, 0x74, 0xac, 0x83, 0x61, 0xe1, 0x10, 0x65, 
  0xa9, 0xeb, 0xec, 0xb9, 0x6b, 0x15, 0x41, 0x1a, 0x24, 0x60, 0xcf, 0x26, 
  0x18, 0x8b, 0x2d, 0x4c, 0x87, 0x6b, 0xc5, 0xc5, 0x51, 0x49, 0x88, 0x0c, 
  0x9b, 0x4d, 0xfc, 0xbb, 0xc1, 0x42, 0xb5, 0x2e, 0xe3, 0xc3, 0x77, 0x31, 
  0x27, 0xd5, 0x0c, 0x1c, 0x30, 0x0c, 0xd4, 0x12, 0x1f, 0x59, 0xa0, 0xca, 
  0xb3, 0x90, 0xb7, 0xdc, 0x6a, 0x5d, 0x81, 0xdf, 0x44, 0x11, 0xf6, 0x4e, 
  0x3f, 0x32, 0x6e, 0x8c, 0x3d, 0xb0, 0xc0, 0x2e, 0x26, 0x55, 0x19, 0x4e, 
  0xcb, 0xfa, 0x29, 0x87, 0x6a, 0x9b, 0x68, 0x6e, 0x1b, 0x8d, 0x4c, 0x6a, 
  0x09, 0xd0, 0x88, 0x04, 0x7f, 0xd6, 0xa9, 0x33, 0x0f, 0x5f, 0xb9, 0x91, 
  0xbe, 0xf8, 0xa2, 0xf6, 0xfe, 0xfd, 0xfd, 0x68, 0xbe, 0xb2, 0xef, 0xca, 
  0x1a, 0xec, 0x98, 0x8f, 0xc9, 0x72, 0x91, 0x6a, 0x3c, 0xcb, 0x7e, 0xe9, 
  0x68, 0xcd, 0xc7, 0xac, 0xc9, 0xc5, 0x3a, 0x11, 0x63, 0x7f, 0x57, 0x4e, 
  0xf8, 0x40, 0x5d, 0x8c, 0x43, 0xb7, 0x0e, 0x75, 0x0a, 0x94, 0xc0, 0xae, 
  0xfe, 0x5d, 0x02, 0xbd, 0xa4, 0x33, 0x9d, 0xf7, 0x3a, 0x4f, 0x64, 0xdb, 
  0xae, 0x72, 0xa2, 0x56, 0xa3, 0x3a, 0xf6, 0xe3, 0x54, 0xc5, 0x72, 0x5c, 
  0xb5, 0x85, 0x75, 0x43, 0x72, 0x13, 0xd3, 0xa4, 0x73, 0xc0, 0xc2, 0x64, 
  0x14, 0xb2, 0x0d, 0x53, 0xd5, 0xda, 0x29, 0x00, 0xc2, 0x66, 0xfa, 0x48, 
  0xc4, 0xee, 0x6b, 0xe8, 0xae, 0x46, 0x1e, 0x59, 0x24, 0x52, 0x95, 0xaf, 
  0x5d, 0xf2, 0xde, 0x7d, 0x72, 0xf5, 0xe2, 0x0b, 0xd2, 0xe0, 0x93, 0x77, 
  0xc8, 0xec, 0x94, 0x84, 0x6e, 0xa6, 0xb7, 0x6d, 0xfe, 0xb3, 0xc7, 0xd1, 
  0x7a, 0x5d, 0x2b, 0x9e, 0x17, 0x6b, 0x5b, 0x0c, 0xa2, 0x1e, 0x83, 0xd6, 
  0xa6, 0x79, 0xbe, 0xb6, 0x31, 0xb6, 0xcd, 0x4e, 0x97, 0x05, 0xd4, 0xf8, 
  0x44, 0x68, 0xb8, 0xc4, 0xd2, 0x59, 0xde, 0xaa, 0x9e, 0xbf, 0xd7, 0xfb, 
  0x27, 0x6f, 0xf6, 0x8f, 0xbb, 0x1d, 0x9a, 0xc1, 0x9d, 0x6f, 0xde, 0x0c, 
  0x07, 0xd2, 0x05, 0x8d, 0x27, 0xb8, 0x60, 0xae, 0xe9, 0x82, 0xb9, 0x9e, 
  0xe5, 0x57, 0xf9, 0x74, 0xfa, 0x40, 0x53, 0x72, 0x4f, 0x02, 0xc0, 0x4e, 
  0xc8, 0xbe, 0xc7, 0x6e, 0x1b, 0x7e, 0xef, 0x8a, 0x57, 0x5c, 0xd1, 0x2b, 
  0x46, 0x5d, 0x5e, 0x3f, 0x84, 0x01, 0x26, 0x55, 0xdd, 0x01, 0xbd, 0x6a, 
  0x80, 0xf6, 0x01, 0x4b, 0xad, 0x43, 0x1c, 0x75, 0xd6, 0x2b, 0x1f, 0xf8, 
  0x59, 0x46, 0x7f, 0xff, 0xc7, 0x8f, 0x3f, 0xb9, 0x58, 0x2c, 0xf5, 0x0f, 
  0xd0, 0xf7, 0x73, 0xf1, 0x0b, 0xb6, 0x2c, 0x54, 0xf4, 0x0e, 0x31, 0xd1, 
  0x4a, 0x70, 0x0f, 0x45, 0x22, 0x05, 0x30, 0x50, 0x23, 0xb6, 0xba, 0x74, 
  0x1d, 0x34, 0xb5, 0x21, 0xa6, 0x7e, 0xf6, 0x94, 0x9b, 0x26, 0x34, 0x4b, 
  0xae, 0xe9, 0x5f, 0x5e, 0x00, 0xc7, 0x9d, 0x24, 0x1b, 0x2a, 0x59, 0xe9, 
  0xb9, 0x68, 0x6b, 0xfa, 0x1a, 0xe4, 0x19, 0x5c, 0x67, 0xca, 0x7c, 0xde, 
  0x9c, 0x1f, 0x39, 0x49, 0x3a, 0xd8, 0x96, 0xaf, 0x78, 0x5b, 0x5a, 0x1c, 
  0xd1, 0xb9, 0x51, 0x07, 0x35, 0x71, 0xc3, 0x83, 0x85, 0x70, 0x70, 0x87, 
  0x80, 0x0b, 0x98, 0x09, 0xa3, 0x2b, 0x2d, 0x22, 0x88, 0x33, 0x94, 0xf0, 
  0xd7, 0x5a, 0xa0, 0x9f, 0x5e, 0x7a, 0x0e, 0xda, 0xac, 0xcb, 0xeb, 0xf8, 
  0xd5, 0xa1, 0x0b, 0xa1, 0x0f, 0xc1, 0x85, 0x78, 0x42, 0x72, 0xeb, 0xdb, 
  0x97, 0x5d, 0x9b, 0x8a, 0x6c, 0xe6, 0xfb, 0x94, 0x4f, 0xf0, 0x7d, 0x88, 
  0xb8, 0x32, 0xf2, 0x10, 0x34, 0xc6, 0x27, 0xc5, 0x91, 0xd8, 0x36, 0xe9, 
  0xda, 0xda, 0x1d, 0x5b, 0x38, 0x74, 0xff, 0xcf, 0xfd, 0xc8, 0x62, 0xa2, 
  0xbb, 0xb3, 0x7d, 0x6d, 0x3e, 0xad, 0xf0, 0xaf, 0xe1, 0xd1, 0xc0, 0x0f, 
  0x5c, 0x16, 0xa5, 0x23, 0x24, 0xc3, 0x66, 0x19, 0x0c, 0xaa, 0x63, 0x18, 
  0x5f, 0x1f, 0xee, 0xbf, 0xb4, 0xb9, 0xaf, 0x1d, 0x44, 0xfd, 0x2c, 0xfa, 
  0xb4, 0x14, 0xec, 0x19, 0x51, 0xd6, 0x0d, 0x3a, 0x08, 0x0f, 0xe9, 0x0d, 
  0xdc, 0xb4, 0xb3, 0x45, 0x2b, 0xb9, 0x29, 0xbe, 0xe6, 0xe8, 0x83, 0xd9, 
  0x22, 0x78, 0x36, 0x70, 0xe9, 0x3e, 0x97, 0x9f, 0x6b, 0xa4, 0xc5, 0x43, 
  0x64, 0x03, 0xe8, 0xa3, 0x61, 0xc8, 0x83, 0x77, 0xb3, 0x10, 0x43, 0xa4, 
  0xb3, 0x7d, 0xdd, 0x82, 0x0a, 0x02, 0x36, 0x22, 0x22, 0x8d, 0xec, 0x00, 
  0xb3, 0x71, 0x46, 0xb2, 0xd3, 0xe0, 0x58, 0x0c, 0x9a, 0x2e, 0xe5, 0x9c, 
  0x75, 0xa9, 0xd6, 0xea, 0x56, 0xd5, 0x20, 0xe1, 0x78, 0x32, 0xe1, 0x74, 
  0x75, 0x92, 0x05, 0xe8, 0x96, 0xb2, 0x61, 0xf1, 0x63, 0x2c, 0x8e, 0x76, 
  0x84, 0x5c, 0x42, 0xce, 0x12, 0x69, 0x8b, 0xa5, 0x90, 0x00, 0xb6, 0x16, 
  0x67, 0x3e, 0x33, 0xa4, 0x48, 0xb9, 0x44, 0x3a, 0x8e, 0xe5, 0x12, 0xf9, 
  0xcd, 0x90, 0x0b, 0x10, 0x61, 0xc5, 0xaf, 0x18, 0x02, 0x84, 0x0d, 0x20, 
  0xc8, 0xa7, 0x5b, 0xb6, 0x93, 0xed, 0x8d, 0x28, 0x7c, 0xda, 0x9c, 0xeb, 
  0x9a, 0xfb, 0x56, 0xe3, 0x43, 0x2c, 0x6e, 0x69, 0x9e, 0x6a, 0x4b, 0x44, 
  0xc0, 0xa9, 0x85, 0x8f, 0x19, 0xf8, 0xb4, 0xec, 0x2c, 0x2d, 0xab, 0x25, 
  0x98, 0x6c, 0x9c, 0x99, 0x26, 0x2c, 0xc1, 0x20, 0x16, 0x14, 0xd4, 0xd2, 
  0xd8, 0x47, 0xba, 0x21, 0xba, 0x8e, 0xcc, 0xaa, 0x8a, 0x64, 0x31, 0x8b, 
  0xc7, 0x7e, 0x25, 0xd4, 0x91, 0xde, 0x0d, 0xa3, 0x63, 0xac, 0x94, 0xd3, 
  0x76, 0xc1, 0xcd, 0x93, 0x62, 0x9a, 0x70, 0x5e, 0x89, 0xa4, 0x08, 0xe3, 
  0xfe, 0x75, 0x88, 0x41, 0x08, 0x68, 0x6a, 0xd2, 0xc3, 0x39, 0xba, 0x13, 
  0xb8, 0xb3, 0xcc, 0xaf, 0x81, 0xae, 0x21, 0xce, 0x86, 0xa0, 0x8d, 0x48, 
  0x47, 0xc4, 0x36, 0x5b, 0x1a, 0x3b, 0x02, 0x3a, 0xe5, 0x6a, 0x93, 0xd0, 
  0x38, 0x8e, 0xf6, 0xb0, 0x0d, 0xa5, 0x37, 0x66, 0x02, 0x46, 0xc4, 0x9b, 
  0xa1, 0x26, 0x9c, 0x2e, 0x8a, 0xd2, 0x1e, 0x45, 0x30, 0xa4, 0x53, 0x14, 
  0x17, 0xb5, 0x04, 0xa2, 0xe0, 0x8e, 0xad, 0xe7, 0xa2, 0x37, 0xe0, 0x08, 
  0x35, 0x34, 0x33, 0x08, 0xe1, 0xe8, 0x4c, 0x73, 0x2f, 0x1f, 0x8e, 0x27, 
  0x32, 0xa5, 0xdb, 0xf4, 0x6c, 0x7f, 0xf0, 0x25, 0xcb, 0xbd, 0x8c, 0x3a, 
  0x3c, 0xe6, 0x74, 0x0a, 0xb6, 0x75, 0xf7, 0xb6, 0x39, 0x0f, 0xec, 0x2e, 
  0xf1, 0xaf, 0xd9, 0x81, 0xf2, 0x87, 0x3d, 0xa5, 0x11, 0xa6, 0xd9, 0x78, 
  0xb6, 0x9c, 0x24, 0x6b, 0x54, 0xc2, 0x23, 0xf9, 0x36, 0x72, 0x89, 0x4d, 
  0xc6, 0x1c, 0x54, 0x8e, 0x10, 0xe3, 0xd7, 0xa8, 0x23, 0x26, 0xa8, 0xfe, 
  0x30, 0x5a, 0xe1, 0x73, 0x48, 0x0b, 0xaa, 0x28, 0xca, 0x22, 0x36, 0x0f, 
  0xf9, 0x08, 0x0e, 0xa0, 0xe7, 0x25, 0xed, 0xcc, 0x54, 0x98, 0xb3, 0x9d, 
  0xfd, 0x0f, 0x4d, 0x9a, 0x6f, 0x24, 0xce, 0x24, 0x93, 0x66, 0x34, 0xfa, 
  0x88, 0x96, 0xb4, 0xfa, 0xf8, 0x43, 0xa3, 0x01, 0xa8, 0x74, 0xca, 0x87, 
  0xe4, 0x79, 0x57, 0xa2, 0xff, 0x19, 0x7d, 0x29, 0xc9, 0x5a, 0x51, 0x68, 
  0x3f, 0x13, 0xbe, 0x18, 0xa6, 0x57, 0xb9, 0x76, 0x3a, 0x99, 0x24, 0x48, 
  0x20, 0xc9, 0x60, 0x77, 0xf5, 0x3d, 0xca, 0x92, 0x1d, 0x9d, 0xf1, 0x6e, 
  0xb3, 0x9e, 0xcd, 0xb7, 0xf0, 0x4d, 0xde, 0xf2, 0x10, 0xf0, 0x63, 0xa3, 
  0x68, 0x3f, 0x33, 0x41, 0x50, 0xc3, 0xc2, 0xd8, 0x73, 0x84, 0x1d, 0x68, 
  0x49, 0xb2, 0x2a, 0x78, 0x06, 0x73, 0x4b, 0xaa, 0x9b, 0x9d, 0x67, 0xbb, 
  0x21, 0xa2, 0x49, 0xa6, 0x59, 0xf3, 0x80, 0xee, 0xfd, 0xd5, 0xbc, 0xa2, 
  0x47, 0x7a, 0x2b, 0x75, 0x51, 0xe9, 0xf6, 0x2b, 0xfe, 0x1f, 0x03, 0x82, 
  0x47, 0xd1, 0xab, 0x44, 0xec, 0x31, 0x0d, 0x62, 0xe5, 0xec, 0xf2, 0xdf, 
  0xc8, 0x27, 0x9d, 0x40, 0x04, 0x3e, 0xe4, 0x3e, 0x44, 0xe3, 0xc5, 0x6d, 
  0x2c, 0x4a, 0x18, 0x66, 0x25, 0x8e, 0xc2, 0xe6, 0x89, 0x63, 0xed, 0xd6, 
  0xae, 0x60, 0x95, 0xe3, 0x8c, 0x6c, 0x18, 0xae, 0x39, 0x00, 0x30, 0x71, 
  0xe2, 0x57, 0x0b, 0x0a, 0x8c, 0x1e, 0x63, 0xdb, 0x12, 0x83, 0x4a, 0xd1, 
  0x3c, 0x54, 0x83, 0xc2, 0x66, 0x68, 0xce, 0x7c, 0xe9, 0xf5, 0x27, 0xe2, 
  0x6c, 0x3f, 0xb7, 0x00, 0x19, 0x18, 0x3b, 0x98, 0x57, 0x74, 0x9e, 0x4f, 
  0xc4, 0x99, 0x81, 0xa8, 0x2f, 0x40, 0x61, 0xd0, 0xd4, 0x3f, 0xfe, 0x01, 
  0xa9, 0xf7, 0x32, 0xfc, 0x2b, 0x6d, 0xd7, 0x5f, 0x97, 0xd9, 0xed, 0x50, 
  0xe1, 0xee, 0x34, 0x36, 0xb0, 0xec, 0x66, 0x32, 0x58, 0x17, 0x6f, 0xeb, 
  0x85, 0x2a, 0xdc, 0xc4, 0x76, 0x53, 0x5b, 0x7b, 0xdc, 0x9d, 0xfe, 0xae, 
  0x2a, 0x67, 0x2d, 0xfa, 0xd7, 0x4b, 0xb5, 0x69, 0xc5, 0xc3, 0x1d, 0x93, 
  0x84, 0xdc, 0x91, 0xab, 0xd8, 0x33, 0x44, 0x3e, 0xed, 0xc9, 0xf0, 0xb7, 
  0x84, 0x10, 0x19, 0x7b, 0x8a, 0x2e, 0xb2, 0x1b, 0xc3, 0x43, 0xeb, 0xca, 
  0xd1, 0x4b, 0xa6, 0x53, 0xd4, 0x18, 0x00, 0x8a, 0xdb, 0x14, 0xf6, 0x8c, 
  0x2c, 0xb9, 0x0f, 0xa0, 0xfe, 0x4a, 0xc9, 0x45, 0x83, 0x84, 0xba, 0x5a, 
  0xb0, 0xff, 0xb6, 0x29, 0xe0, 0x17, 0x74, 0xc1, 0x23, 0x70, 0xd3, 0xe2, 
  0xcb, 0x6d, 0xbc, 0xae, 0x91, 0x60, 0x25, 0x20, 0x65, 0xb5, 0x6d, 0x1d, 
  0x2b, 0xbe, 0x5f, 0xc7, 0xb3, 0x5c, 0x40, 0x73, 0xee, 0xb3, 0xba, 0xd9, 
  0xf1, 0x69, 0xb7, 0xf5, 0xfa, 0x57, 0x0a, 0x98, 0xbe, 0xc5, 0x3d, 0x23, 
  0xb8, 0xa9, 0xdd, 0x21, 0x1e, 0x01, 0x35, 0x26, 0xef, 0x38, 0x1d, 0x33, 
  0xad, 0x10, 0xbf, 0x0c, 0xd1, 0xc7, 0xa5, 0x7a, 0x0a, 0x53, 0x6d, 0xee, 
  0xa0, 0xb5, 0xdc, 0x93, 0x60, 0xa5, 0xd0, 0x97, 0x08, 0x97, 0xa8, 0x0f, 
  0x98, 0xbe, 0xe0, 0x7d, 0x68, 0x2b, 0x79, 0xa2, 0xd5, 0x88, 0xb4, 0xc4, 
  0x96, 0xfe, 0x81, 0x62, 0x9a, 0x34, 0x43, 0x9f, 0x4c, 0x82, 0x68, 0x5b, 
  0xc2, 0xd5, 0xc1, 0xe0, 0xf3, 0x59, 0x59, 0x34, 0x9b, 0x24, 0x06, 0x15, 
  0x5b, 0x8b, 0xaa, 0x7d, 0xd8, 0x09, 0xa9, 0x31, 0x05, 0x90, 0x0d, 0x63, 
  0x18, 0x5d, 0x19, 0x47, 0x4e, 0xed, 0xf4, 0xce, 0xaf, 0x07, 0x4b, 0x58, 
  0x07, 0xae, 0x4b, 0x63, 0xb8, 0x61, 0xd4, 0x6b, 0xb8, 0x4c, 0xe6, 0x50, 
  0x69, 0x01, 0x2f, 0x01, 0xf9, 0xac, 0xb6, 0x5d, 0x46, 0x14, 0xff, 0x3a, 
  0x0f, 0x01, 0x1b, 0xea, 0xd2, 0x89, 0xc0, 0x57, 0x1c, 0x27, 0x49, 0xab, 
  0xf0, 0x7a, 0xe5, 0x78, 0xa5, 0xe7, 0xf4, 0x4f, 0x77, 0x44, 0x50, 0x74, 
  0xa6, 0x21, 0x4c, 0xfc, 0x98, 0xb3, 0x2a, 0xd1, 0x5d, 0x17, 0x8a, 0xca, 
  0x16, 0x12, 0xd4, 0x15, 0x5f, 0xb0, 0x08, 0xde, 0x57, 0xa0, 0x4e, 0x87, 
  0xef, 0xdd, 0x6d, 0x10, 0xfc, 0x78, 0x01, 0x3f, 0x34, 0x86, 0xf7, 0x86, 
  0x40, 0xb9, 0x09, 0x63, 0xc4, 0x86, 0x0d, 0x42, 0x8f, 0x8f, 0x5c, 0xbc, 
  0xa0, 0x5e, 0x54, 0x6d, 0xbb, 0x38, 0x26, 0x2c, 0x2b, 0x6a, 0x41, 0x52, 
  0xf5, 0xf9, 0xb3, 0xa3, 0xf6, 0x25, 0x0a, 0x6e, 0x70, 0x34, 0x41, 0x87, 
  0x2b, 0xd4, 0x62, 0xa4, 0x1c, 0x80, 0xd6, 0xaf, 0x18, 0x9a, 0x71, 0x5b, 
  0x5c, 0x3d, 0x8e, 0x9e, 0xcf, 0xa8, 0x9d, 0xd9, 0xe7, 0x9d, 0x1e, 0x1a, 
  0x49, 0x27, 0xa3, 0x99, 0x14, 0x57, 0x5c, 0x6d, 0xe0, 0x71, 0x33, 0x43, 
  0x4c, 0x43, 0x7c, 0x3a, 0xd3, 0x6c, 0xd1, 0xac, 0x0b, 0xee, 0x83, 0x9c, 
  0x95, 0x88, 0x4d, 0xd9, 0x27, 0x01, 0xab, 0x62, 0xd8, 0x47, 0x76, 0x58, 
  0xbf, 0x69, 0xe5, 0xed, 0x97, 0xf1, 0x34, 0xe9, 0x0f, 0x60, 0xf8, 0x9f, 
  0xa6, 0x13, 0x41, 0xe5, 0xef, 0xf3, 0x4d, 0xde, 0xd7, 0x35, 0xee, 0xd3, 
  0x16, 0x49, 0x63, 0x8a, 0x28, 0xd8, 0xce, 0x69, 0x93, 0x61, 0x68, 0x2a, 
  0x5b, 0x0a, 0xfc, 0xf0, 0x40, 0x1f, 0x65, 0x35, 0xd3, 0x35, 0xf6, 0x1e, 
  0xdb, 0x42, 0xe7, 0x49, 0x0d, 0x99, 0x2b, 0x1b, 0x17, 0x52, 0x94, 0xff, 
  0x70, 0xa0, 0x00, 0x0c, 0xd0, 0x56, 0xc0, 0x72, 0x73, 0xcf, 0x57, 0xd8, 
  0xd5, 0x32, 0x9d, 0x55, 0x9d, 0x0c, 0xd2, 0x2f, 0xb1, 0x51, 0x82, 0xf1, 
  0x23, 0x1d, 0x33, 0xed, 0xf5, 0x0a, 0xd2, 0x53, 0xdb, 0xd1, 0xc7, 0x8e, 
  0xca, 0xe1, 0xb7, 0xc4, 0x57, 0x4c, 0x7c, 0x97, 0x28, 0x54, 0xd5, 0xe1, 
  0x0b, 0x61, 0xbe, 0x16, 0x0a, 0x5c, 0xe3, 0x05, 0x1f, 0xfb, 0xfc, 0x7d, 
  0x23, 0x50, 0x3d, 0xd3, 0xf4, 0x3a, 0x7a, 0xae, 0x3f, 0xbb, 0xe2, 0x73, 
  0xed, 0x98, 0x19, 0xc2, 0xae, 0x3e, 0xea, 0x3c, 0x01, 0x10, 0x57, 0x24, 
  0x00, 0xbd, 0xb8, 0x86, 0xc0, 0xd7, 0x95, 0xa8, 0xa1, 0xa1, 0x3d, 0xbe, 
  0x1b, 0xad, 0xb5, 0x23, 0x4e, 0x09, 0xb0, 0x7d, 0xdf, 0xc1, 0x9a, 0xcc, 
  0x20, 0x14, 0x2a, 0x70, 0x9d, 0x98, 0x99, 0xd6, 0x90, 0xa4, 0x4c, 0x5e, 
  0x4d, 0xb2, 0x2e, 0x52, 0x71, 0xd1, 0xe9, 0xa5, 0x43, 0x20, 0xe6, 0x9a, 
  0x2e, 0xee, 0x6d, 0x55, 0xa1, 0xe3, 0x71, 0xb5, 0x8c, 0x67, 0xef, 0x19, 
  0x03, 0x6d, 0xfe, 0xe9, 0x42, 0x2f, 0x1a, 0x4d, 0xa0, 0x48, 0x52, 0xd4, 
  0x4b, 0x21, 0x5e, 0x0c, 0x4b, 0x6b, 0x77, 0xd0, 0x5f, 0xad, 0x1e, 0x83, 
  0x8b, 0x33, 0xab, 0x2f, 0xa8, 0x75, 0xa0, 0x20, 0x2b, 0xad, 0xa0, 0x3c, 
  0xed, 0x42, 0x83, 0x03, 0xcc, 0xcc, 0x4b, 0x73, 0xe7, 0xac, 0x99, 0x05, 
  0x97, 0x5f, 0x19, 0x68, 0x00, 0xb5, 0x3e, 0xd9, 0xf2, 0x15, 0x5a, 0x3c, 
  0xaf, 0x4a, 0x4c, 0x5a, 0xba, 0x05, 0xb8, 0xf9, 0xa5, 0x0f, 0xec, 0xd5, 
  0x3c, 0xbf, 0x71, 0x3b, 0x1d, 0x76, 0x39, 0xcf, 0xd4, 0xfd, 0x61, 0x23, 
  0xc7, 0xbe, 0x60, 0x3b, 0xfb, 0x9f, 0xf4, 0xa3, 0xf1, 0x4d, 0xcc, 0xd1, 
  0xea, 0x16, 0xed, 0xd0, 0x81, 0x33, 0xa0, 0xea, 0x2d, 0x5e, 0x73, 0x8e, 
  0x1d, 0x45, 0xf3, 0x42, 0xc4, 0x21, 0x9f, 0x24, 0x56, 0x1c, 0x36, 0xd6, 
  0x81, 0xc8, 0xa9, 0x4a, 0x90, 0x69, 0x2a, 0x7b, 0x7f, 0xd8, 0xaf, 0xa7, 
  0x42, 0xa8, 0x0c, 0xdd, 0x5e, 0x40, 0x81, 0x3a, 0xf3, 0x10, 0x04, 0x2d, 
  0xd0, 0x31, 0x6f, 0xd9, 0x86, 0x31, 0x57, 0x5c, 0xcb, 0xb9, 0x37, 0xd7, 
  0xc1, 0x68, 0xe9, 0xd1, 0x38, 0x69, 0xfa, 0x9d, 0x4e, 0x20, 0x00, 0x31, 
  0x30, 0x10, 0x8f, 0x88, 0x1c, 0xae, 0x12, 0x0a, 0x3b, 0x83, 0x3d, 0x2e, 
  0x1b, 0xb3, 0xf9, 0x76, 0xea, 0xa5, 0xd9, 0xfa, 0x85, 0xb6, 0x60, 0x40, 
  0x27, 0x49, 0xa8, 0x4c, 0x49, 0x93, 0x5d, 0xb9, 0xfa, 0x15, 0x66, 0x3f, 
  0x65, 0x8e, 0xd0, 0x3a, 0x70, 0x24, 0x04, 0x2b, 0x1d, 0x5d, 0xe4, 0x08, 
  0x1e, 0x0a, 0xf4, 0x5f, 0xef, 0xcf, 0x01, 0x5b, 0x69, 0xa9, 0xc2, 0xbc, 
  0x7c, 0x2f, 0xa2, 0x9e, 0x2a, 0xbe, 0x88, 0x7b, 0xbc, 0x89, 0xdf, 0xbd, 
  0x1b, 0x95, 0x89, 0xe0, 0x78, 0xf6, 0xfe, 0x6d, 0xcf, 0xc9, 0x10, 0x38, 
  0x8a, 0x43, 0x48, 0x1c, 0xcf, 0x51, 0xcf, 0xe4, 0xf3, 0x07, 0xf6, 0x79, 
  0xae, 0xf0, 0x8e, 0xbe, 0x0e, 0x14, 0xbf, 0xd7, 0x02, 0x0e, 0x6c, 0x9b, 
  0x28, 0x9d, 0xc8, 0x68, 0x1a, 0xae, 0x70, 0x4e, 0xe4, 0x4e, 0x88, 0xfd, 
  0x14, 0xca, 0x4d, 0x2c, 0xb0, 0x8e, 0x2d, 0xdd, 0x74, 0x91, 0x2e, 0x24, 
  0x4d, 0x99, 0x0d, 0x78, 0x13, 0x31, 0xdc, 0xa8, 0xcd, 0xd3, 0x43, 0x93, 
  0x61, 0x73, 0xe0, 0x52, 0x0b, 0x2b, 0x49, 0x39, 0xa7, 0x3a, 0x72, 0xeb, 
  0xaf, 0xa8, 0x91, 0xfb, 0x74, 0x52, 0xdd, 0x74, 0x06, 0xbe, 0x8a, 0x1e, 
  0x87, 0x55, 0x88, 0x80, 0x81, 0x1e, 0x97, 0x4b, 0x01, 0xbd, 0x16, 0x70, 
  0xb2, 0x6d, 0x91, 0x25, 0x0d, 0x9c, 0xb7, 0x75, 0x85, 0x96, 0xcb, 0x29, 
  0xbb, 0xb9, 0xf9, 0xf4, 0xa9, 0x75, 0x9d, 0xcb, 0x62, 0xe1, 0x57, 0xb8, 
  0xf4, 0x6e, 0xfb, 0xe2, 0xaa, 0xe8, 0x7f, 0xd3, 0xef, 0x14, 0x45, 0x81, 
  0x71, 0xa6, 0xc4, 0xa8, 0x76, 0x68, 0x3a, 0x50, 0xb7, 0xe9, 0x2c, 0x47, 
  0xf7, 0x74, 0x01, 0xcf, 0x71, 0xa9, 0xbf, 0xee, 0xab, 0x13, 0x3a, 0xad, 
  0x5a, 0x38, 0x2b, 0xd7, 0xb1, 0xe0, 0xa8, 0x89, 0xc7, 0xba, 0x7f, 0x6d, 
  0x5d, 0x7e, 0xd5, 0x37, 0x7f, 0x38, 0xe8, 0xfe, 0x3a, 0xd5, 0x07, 0x47, 
  0xdd, 0x2e, 0xe7, 0xf2, 0x59, 0xb4, 0xb7, 0xb3, 0xf3, 0xcd, 0x20, 0x7a, 
  0x24, 0x50, 0x3f, 0xbb, 0x5f, 0xad, 0xc5, 0x38, 0x61, 0x99, 0x0c, 0x66, 
  0x48, 0xaf, 0x5c, 0x0c, 0x7f, 0xa0, 0xeb, 0x0c, 0xeb, 0x28, 0xf4, 0xb5, 
  0x16, 0x2e, 0x20, 0xae, 0x6a, 0x8a, 0x32, 0xc3, 0x7c, 0xb2, 0x65, 0x74, 
  0x9c, 0x4c, 0xa0, 0xd3, 0xc1, 0xba, 0x26, 0x39, 0xc6, 0x1c, 0x08, 0xb8, 
  0x98, 0x75, 0x25, 0x2e, 0x82, 0x08, 0xa5, 0x1f, 0x89, 0xb5, 0x9b, 0xf1, 
  0x1b, 0xb3, 0xd5, 0x40, 0x8e, 0x3b, 0x7b, 0x16, 0x48, 0x68, 0x48, 0x16, 
  0x3a, 0xb8, 0xf6, 0x3d, 0xe0, 0x46, 0x39, 0xcb, 0xaf, 0xd3, 0x31, 0xb2, 
  0x8c, 0xbb, 0x0c, 0xae, 0xe1, 0xd9, 0xba, 0x47, 0x65, 0xab, 0xaa, 0xc8, 
  0x27, 0xcb, 0xb1, 0x7a, 0x64, 0x5c, 0x2a, 0xfb, 0xaf, 0x26, 0x33, 0xcc, 
  0x38, 0x6b, 0x2d, 0x2d, 0xab, 0x21, 0xdb, 0x3d, 0xba, 0xe3, 0x86, 0x24, 
  0xf1, 0x8d, 0x1f, 0x32, 0xbb, 0x36, 0x5b, 0x78, 0x26, 0x3e, 0x1c, 0x5a, 
  0x74, 0x0e, 0x38, 0x46, 0xdb, 0x71, 0xdc, 0xa8, 0x1f, 0x06, 0xa5, 0x66, 
  0xa8, 0xc8, 0x88, 0xc9, 0x3d, 0x51, 0xf4, 0xa1, 0xfa, 0x78, 0x66, 0xab, 
  0xe0, 0x0c, 0x33, 0x29, 0x34, 0x87, 0xad, 0x19, 0xa7, 0x73, 0xd2, 0xdc, 
  0x89, 0x01, 0x0e, 0xe1, 0x60, 0xad, 0x07, 0x44, 0xb0, 0x6d, 0x2a, 0x18, 
  0x53, 0x47, 0x08, 0x1c, 0x33, 0xdb, 0x6c, 0x9c, 0x84, 0xf8, 0x06, 0x3e, 
  0xb2, 0x98, 0x07, 0xe4, 0xa2, 0xfd, 0x70, 0xf4, 0xe3, 0x76, 0x04, 0x26, 
  0xbc, 0x92, 0xc2, 0x6f, 0xe9, 0x24, 0xac, 0x89, 0xf2, 0xaf, 0xd9, 0xbc, 
  0x35, 0x0a, 0x48, 0x47, 0x76, 0x72, 0x7c, 0xe1, 0xf2, 0xf7, 0xf5, 0x26, 
  0x2a, 0x71, 0x21, 0x36, 0xf8, 0x24, 0xd7, 0xe3, 0x79, 0xe5, 0x22, 0x4a, 
  0x4b, 0x01, 0x6a, 0xc6, 0xba, 0x49, 0xd4, 0x8e, 0x5c, 0x54, 0x24, 0x9b, 
  0xb8, 0x3c, 0xd1, 0x8e, 0x5a, 0x02, 0xdc, 0xd9, 0x9f, 0xc4, 0x92, 0x22, 
  0xc5, 0x49, 0x98, 0xab, 0xa9, 0xe1, 0x97, 0x23, 0x98, 0x42, 0x38, 0xb5, 
  0xb6, 0x8a, 0x54, 0xae, 0xe6, 0x57, 0xf9, 0x8c, 0x68, 0x98, 0x2e, 0x9c, 
  0xdb, 0xf2, 0x23, 0x1a, 0xdc, 0xdc, 0xdc, 0x02, 0x72, 0x0c, 0x93, 0x28, 
  0x3b, 0x2d, 0xa4, 0x96, 0x5b, 0x06, 0xce, 0x11, 0x06, 0xad, 0x18, 0xb6, 
  0x67, 0x69, 0xda, 0x47, 0x57, 0x41, 0x1b, 0xb8, 0x23, 0x59, 0x69, 0x84, 
  0xbb, 0x30, 0xae, 0xc3, 0x99, 0xbb, 0xe4, 0xcd, 0x68, 0x33, 0x25, 0x66, 
  0x3b, 0xee, 0xa8, 0xbb, 0xe1, 0xc3, 0x8d, 0xd4, 0x5a, 0x08, 0x91, 0xc7, 
  0xe5, 0x58, 0x6e, 0xc9, 0xd2, 0xf8, 0x18, 0xdb, 0x59, 0xcb, 0x71, 0x2d, 
  0x72, 0x75, 0x58, 0xae, 0xcc, 0xfd, 0x71, 0x23, 0xf1, 0x45, 0x2a, 0x4a, 
  0xb2, 0xe1, 0x0d, 0xce, 0x8f, 0x2e, 0xf0, 0x4f, 0x0b, 0x57, 0x54, 0x24, 
  0x2c, 0x75, 0xdf, 0x06, 0x3e, 0x10, 0xa6, 0x52, 0x67, 0x6a, 0x1e, 0x74, 
  0x17, 0xd5, 0x51, 0xe7, 0xd0, 0x6c, 0xd6, 0x58, 0x98, 0xa0, 0x5e, 0xc3, 
  0x0d, 0xac, 0x6f, 0xd4, 0x65, 0xf3, 0x9a, 0x6a, 0x40, 0x97, 0x18, 0xfc, 
  0xe8, 0xa0, 0x16, 0xb3, 0x0a, 0xba, 0x45, 0xc8, 0x51, 0x5b, 0xa2, 0x19, 
  0x17, 0x89, 0xaa, 0x98, 0x2e, 0x43, 0xdd, 0x32, 0x47, 0x6f, 0x50, 0x55, 
  0x92, 0xee, 0x02, 0x35, 0x41, 0xd2, 0x93, 0x20, 0xd8, 0x26, 0xa5, 0xcb, 
  0x45, 0xe4, 0x40, 0x2c, 0x83, 0x9d, 0x94, 0x16, 0x38, 0x2d, 0x0d, 0x79, 
  0xaa, 0x70, 0x02, 0x8c, 0x93, 0x45, 0x57, 0x58, 0x15, 0xfb, 0xba, 0xfe, 
  0xd0, 0x01, 0x5c, 0x12, 0x79, 0x3a, 0x1c, 0x56, 0xc5, 0x52, 0x63, 0x84, 
  0x9a, 0x34, 0xc9, 0x60, 0x98, 0x2c, 0xb5, 0xdf, 0x20, 0x91, 0xb4, 0x1e, 
  0xb1, 0xf8, 0x9f, 0x3f, 0x2f, 0x46, 0x9f, 0x0e, 0xab, 0xa4, 0x26, 0x83, 
  0x35, 0x46, 0xfb, 0xd0, 0xe9, 0x39, 0x86, 0xec, 0x53, 0x3b, 0x6c, 0x1e, 
  0x22, 0x01, 0x58, 0xc8, 0xdc, 0x41, 0xcb, 0xbf, 0x90, 0x4d, 0xbc, 0x9c, 
  0x0b, 0x49, 0xfd, 0x0f, 0x3e, 0x8c, 0x8c, 0x77, 0x60, 0x26, 0x7b, 0xe7, 
  0x15, 0xf2, 0x66, 0x0b, 0xac, 0xd3, 0xb0, 0xb3, 0xdc, 0x76, 0x94, 0xde, 
  0x52, 0x1b, 0x35, 0x7f, 0xca, 0x55, 0xfa, 0xe8, 0x87, 0x30, 0x2b, 0xbd, 
  0x16, 0xdb, 0x16, 0x06, 0xd8, 0xf2, 0x38, 0x9b, 0x23, 0xba, 0x2a, 0x24, 
  0x97, 0x55, 0xb3, 0x25, 0xd0, 0xba, 0xb5, 0x5c, 0x6a, 0x9a, 0x72, 0x9b, 
  0x97, 0x03, 0x27, 0x21, 0xf7, 0x35, 0x9c, 0xfa, 0x40, 0x01, 0xb1, 0xb0, 
  0xb8, 0x16, 0x61, 0x67, 0xd3, 0xa6, 0x24, 0x6a, 0x21, 0xf8, 0x28, 0xe4, 
  0xc9, 0x85, 0x59, 0xa4, 0x4c, 0x85, 0x2b, 0x10, 0xc4, 0xe9, 0x01, 0x50, 
  0x89, 0x7c, 0xcd, 0x87, 0x07, 0x4f, 0xcf, 0xd6, 0x7f, 0x8d, 0x64, 0x18, 
  0x73, 0x1c, 0xd7, 0x4a, 0xfa, 0x33, 0x09, 0xee, 0x90, 0xe4, 0xd6, 0xda, 
  0x0a, 0x30, 0x35, 0x13, 0xdd, 0xe1, 0xb8, 0x61, 0x2e, 0x29, 0x22, 0xed, 
  0x96, 0xb8, 0x87, 0xd4, 0x7e, 0xd0, 0xf2, 0xca, 0xdf, 0x67, 0x82, 0xa6, 
  0x19, 0x56, 0xe7, 0xf3, 0x1c, 0x87, 0x66, 0x37, 0xe3, 0x6a, 0x7f, 0x85, 
  0xe1, 0xa8, 0xb4, 0x62, 0x59, 0xef, 0xe2, 0xd9, 0xd2, 0x21, 0x06, 0x7a, 
  0x51, 0xdd, 0xe1, 0x76, 0x08, 0x3c, 0x1e, 0x4a, 0x8a, 0xad, 0x85, 0xc0, 
  0x07, 0x3e, 0x3f, 0xb8, 0x64, 0xf2, 0x0e, 0xea, 0x13, 0xb1, 0xc8, 0x4f, 
  0x1f, 0x75, 0x42, 0x54, 0x3f, 0xf3, 0x69, 0x83, 0x98, 0xa6, 0x5a, 0x84, 
  0xcc, 0x9f, 0x01, 0x48, 0x6f, 0x76, 0xbd, 0x73, 0x64, 0xff, 0xfa, 0xe9, 
  0x9a, 0xb6, 0x87, 0xc4, 0x63, 0x54, 0xc0, 0x30, 0xa8, 0xdb, 0x60, 0x67, 
  0xf9, 0x06, 0xca, 0xf2, 0x6e, 0x27, 0x8c, 0xa5, 0xdb, 0x57, 0x1e, 0x12, 
  0xdc, 0xcf, 0x5d, 0x70, 0x3d, 0x97, 0x8b, 0xa8, 0x33, 0xd2, 0x4b, 0xd7, 
  0x53, 0x16, 0x54, 0xfd, 0x22, 0xa2, 0x96, 0x40, 0x44, 0xd5, 0x23, 0xc7, 
  0x79, 0xb2, 0x09, 0x27, 0xa0, 0x70, 0x54, 0x62, 0xa3, 0x05, 0x16, 0x41, 
  0xe0, 0x37, 0xbc, 0xac, 0xc1, 0xb4, 0x38, 0xd2, 0x31, 0xc4, 0x7a, 0x18, 
  0xc4, 0xdf, 0x87, 0xe3, 0xbf, 0x16, 0xc6, 0xdf, 0xd2, 0xaa, 0x3c, 0xa2, 
  0x77, 0x3b, 0x29, 0xab, 0x30, 0x70, 0xac, 0x3c, 0xaa, 0x01, 0xf8, 0x7b, 
  0xdd, 0x8f, 0x57, 0x58, 0x03, 0x21, 0xd2, 0xee, 0x14, 0xbc, 0x2b, 0xae, 
  0x4c, 0x15, 0xfd, 0x35, 0xbf, 0xd2, 0x2b, 0x8f, 0xb9, 0x35, 0x73, 0xb2, 
  0x29, 0x9c, 0xcd, 0x4b, 0xba, 0x09, 0x27, 0x4b, 0xa9, 0xa2, 0x55, 0xb6, 
  0xd9, 0x9e, 0x56, 0x98, 0x2b, 0x45, 0x05, 0x82, 0x4c, 0x44, 0xab, 0x09, 
  0x30, 0x1b, 0xf1, 0x4d, 0xc9, 0x78, 0x4c, 0x80, 0xe4, 0x67, 0x9b, 0x42, 
  0xf0, 0x72, 0x86, 0x5c, 0x19, 0x29, 0x5f, 0xe3, 0x0a, 0xd6, 0x44, 0xed, 
  0x42, 0x00, 0xae, 0x44, 0x42, 0x47, 0x25, 0x00, 0x0e, 0x17, 0xf9, 0xb5, 
  0x8b, 0x01, 0xbc, 0xc6, 0x36, 0x67, 0xcb, 0x96, 0x9b, 0xef, 0x35, 0x3e, 
  0x1c, 0x45, 0x2f, 0xc5, 0xa7, 0x2b, 0x12, 0xd1, 0x52, 0x43, 0xb0, 0x04, 
  0x77, 0xcc, 0xb7, 0x92, 0x6d, 0x33, 0xf8, 0x57, 0x55, 0x8c, 0x5b, 0x8d, 
  0xdc, 0x5a, 0x50, 0x52, 0x39, 0x56, 0x08, 0xa5, 0x11, 0x1e, 0x74, 0x06, 
  0x44, 0xbb, 0xa1, 0xfb, 0x25, 0xdf, 0xb5, 0xf3, 0xf5, 0xa9, 0x87, 0xbc, 
  0x95, 0xac, 0x79, 0x65, 0x5d, 0x68, 0x64, 0x46, 0x30, 0xd5, 0x6a, 0xd1, 
  0x42, 0x73, 0x1f, 0x9b, 0x0a, 0x22, 0x39, 0xeb, 0x0c, 0xc4, 0xc2, 0xe1, 
  0x0d, 0x59, 0xfa, 0xae, 0x03, 0xb1, 0x9b, 0x6d, 0x28, 0x0f, 0xe4, 0xe8, 
  0x68, 0xbe, 0x19, 0x32, 0x07, 0x9a, 0x30, 0x70, 0xbc, 0xd7, 0x98, 0xdb, 
  0xe6, 0xe3, 0xad, 0x76, 0xf1, 0x2e, 0xea, 0x76, 0x73, 0xb7, 0x56, 0x46, 
  0xda, 0xc4, 0xc0, 0x1a, 0x94, 0xff, 0x7a, 0x94, 0xa4, 0x4a, 0x6b, 0x27, 
  0xb0, 0xed, 0xd0, 0x32, 0x83, 0xf1, 0x2a, 0xb1, 0x18, 0x26, 0x4b, 0x1f, 
  0x4d, 0xb4, 0xe0, 0x04, 0xfc, 0x56, 0x62, 0xbf, 0x40, 0x6a, 0x6d, 0x72, 
  0x7d, 0x47, 0x1f, 0x3b, 0xc5, 0xb6, 0xd8, 0xbc, 0xc0, 0x1f, 0x45, 0x74, 
  0x5d, 0xe4, 0xcc, 0x6f, 0xd8, 0x0e, 0xc7, 0xb3, 0xdc, 0xea, 0x2a, 0x9a, 
  0xd7, 0x84, 0xd1, 0xc0, 0x72, 0xf4, 0xbe, 0x3e, 0x7d, 0x7d, 0xd8, 0x0b, 
  0x31, 0x1b, 0x00, 0x30, 0xde, 0x16, 0x0f, 0x78, 0x83, 0xfd, 0x96, 0xb6, 
  0xa8, 0x7c, 0x3f, 0xfa, 0xdb, 0x32, 0x1d, 0xdf, 0x62, 0x6f, 0x61, 0x9e, 
  0x87, 0x01, 0x2d, 0x71, 0x21, 0x21, 0x74, 0x07, 0xa9, 0x38, 0xc6, 0x11, 
  0x5e, 0x3c, 0xd6, 0xe6, 0xdd, 0xaf, 0xc4, 0xa5, 0x75, 0x0e, 0x9a, 0x29, 
  0x9d, 0x80, 0x5c, 0x77, 0x75, 0x0a, 0x55, 0xdf, 0x6c, 0x0d, 0xb1, 0xac, 
  0x46, 0x93, 0x7c, 0xce, 0x25, 0x5c, 0x69, 0xbd, 0x85, 0x2c, 0x3c, 0x08, 
  0x5e, 0x7f, 0xbe, 0xe2, 0x78, 0xda, 0xbe, 0xf2, 0xfe, 0x75, 0x08, 0x0a, 
  0x1b, 0x2d, 0x43, 0x34, 0xfa, 0xea, 0x68, 0x3f, 0x52, 0xa2, 0x8e, 0xa4, 
  0xe1, 0xc8, 0x11, 0x75, 0x4b, 0x36, 0x23, 0x79, 0xba, 0xfa, 0x78, 0x72, 
  0x84, 0x2c, 0x5c, 0xab, 0x04, 0x16, 0x3e, 0x1e, 0x1a, 0x64, 0x44, 0xe3, 
  0xdd, 0x6f, 0x79, 0x8f, 0x42, 0xeb, 0xa4, 0x3e, 0x3f, 0xd0, 0xd8, 0x12, 
  0x3f, 0x30, 0x31, 0x29, 0xb5, 0x09, 0x62, 0x14, 0x74, 0x1b, 0x00, 0x53, 
  0x78, 0x2b, 0x2a, 0x6b, 0xd3, 0x31, 0xce, 0x3f, 0x42, 0x16, 0xba, 0x40, 
  0x3c, 0xa4, 0x09, 0xe6, 0xce, 0xf5, 0x81, 0x6b, 0xcd, 0xcd, 0x35, 0xb1, 
  0x62, 0x06, 0xec, 0x18, 0x7d, 0x75, 0x71, 0x31, 0x3c, 0xb1, 0x87, 0xa3, 
  0x0e, 0x70, 0xc7, 0x66, 0x0b, 0xf5, 0x17, 0xb4, 0x04, 0x16, 0x5b, 0x7a, 
  0x26, 0x09, 0xa7, 0xbf, 0x88, 0x13, 0xfc, 0x75, 0x3a, 0x2e, 0xf2, 0x32, 
  0x9f, 0x56, 0x5d, 0x2e, 0x4a, 0x5f, 0xca, 0xc1, 0x29, 0xfb, 0x1c, 0x7d, 
  0x1a, 0x03, 0xd9, 0x59, 0x71, 0x4b, 0x8e, 0x90, 0xf7, 0x4f, 0x32, 0xc8, 
  0x9c, 0x4e, 0x59, 0xcb, 0x6e, 0x33, 0x4f, 0xd8, 0x68, 0x02, 0xed, 0x56, 
  0xfd, 0x50, 0xe0, 0x2c, 0xdf, 0xa8, 0xd3, 0xeb, 0x49, 0x53, 0xca, 0xbd, 
  0x6a, 0x41, 0xfd, 0x23, 0xa2, 0xf5, 0xca, 0x99, 0xe4, 0x14, 0x04, 0xe8, 
  0x5a, 0x83, 0x7b, 0x33, 0xc4, 0x2d, 0x7f, 0x48, 0xf9, 0xd9, 0x52, 0xea, 
  0xcb, 0x21, 0x05, 0x3a, 0xc4, 0xb7, 0x61, 0x7f, 0xd9, 0xd1, 0xe1, 0xe5, 
  0xab, 0x68, 0x52, 0xc4, 0xb4, 0x0a, 0xf8, 0x77, 0xd8, 0x0a, 0x25, 0x49, 
  0x7e, 0x8e, 0x6f, 0x87, 0xe5, 0x82, 0x37, 0x6b, 0xc8, 0xac, 0x77, 0xb8, 
  0xf3, 0x98, 0x0b, 0xab, 0x7f, 0x40, 0x59, 0xb0, 0x7a, 0xf4, 0xa1, 0xf7, 
  0x14, 0x7a, 0x57, 0xa1, 0x79, 0x0a, 0x79, 0x6b, 0xd6, 0xfa, 0x09, 0x69, 
  0x33, 0xf7, 0xcf, 0x8e, 0xbc, 0x8b, 0xb0, 0xe5, 0x21, 0x34, 0x17, 0x21, 
  0xbc, 0x82, 0x4d, 0xda, 0x0b, 0x7d, 0x84, 0xca, 0x96, 0xbc, 0x97, 0xd0, 
  0xbe, 0x70, 0x8e, 0x42, 0x26, 0x9c, 0x56, 0x59, 0x17, 0xab, 0x0c, 0xfb, 
  0x5f, 0xc4, 0xb5, 0x3c, 0xe1, 0xdb, 0x3b, 0x1f, 0x5e, 0x2d, 0xf9, 0xbb, 
  0x46, 0x23, 0x2f, 0x85, 0x3d, 0x18, 0x9c, 0x85, 0x3c, 0x53, 0xab, 0x9e, 
  0xa1, 0xd9, 0xde, 0x25, 0x7b, 0x83, 0xe6, 0x44, 0xb7, 0x59, 0x27, 0xbe, 
  0x9f, 0x80, 0x32, 0xba, 0x72, 0x27, 0xe5, 0x20, 0xc0, 0x8a, 0x50, 0x93, 
  0x5c, 0xb4, 0x36, 0xcb, 0x16, 0x9d, 0x26, 0x13, 0xcb, 0x5e, 0x8e, 0xb4, 
  0xb3, 0x28, 0xa8, 0x02, 0xe2, 0x82, 0x9e, 0x44, 0xb6, 0xee, 0x8c, 0xc0, 
  0xd6, 0x47, 0xb5, 0x11, 0x0f, 0x31, 0x9f, 0x09, 0xbe, 0xb7, 0x44, 0xa7, 
  0x47, 0x52, 0xc1, 0xa1, 0x75, 0x7b, 0xe2, 0x14, 0x3a, 0x14, 0x7a, 0x45, 
  0xe9, 0x71, 0x6d, 0xc4, 0x45, 0x41, 0xd2, 0x77, 0xe9, 0x72, 0x7e, 0xd7, 
  0x57, 0x8b, 0xc2, 0x10, 0x7c, 0x02, 0x64, 0x5c, 0xf9, 0x35, 0xfd, 0x08, 
  0x5a, 0xa2, 0xe6, 0x7c, 0x82, 0x03, 0xb4, 0x7a, 0x11, 0xe4, 0x56, 0xc7, 
  0x11, 0x3d, 0x4b, 0x8c, 0x4e, 0x2e, 0x8f, 0x5f, 0xb7, 0x59, 0xa1, 0xa4, 
  0xd9, 0xf1, 0x77, 0x0f, 0xdb, 0x8a, 0xde, 0xcb, 0x12, 0x1f, 0xe2, 0x88, 
  0x1c, 0x40, 0x74, 0x74, 0x74, 0x11, 0x81, 0x23, 0xaa, 0x8d, 0xd4, 0xb8, 
  0x21, 0xf0, 0xfc, 0x89, 0x25, 0x92, 0xfc, 0xd4, 0xaa, 0x07, 0xe1, 0x61, 
  0x41, 0x59, 0x51, 0x28, 0x4a, 0x14, 0x4e, 0x63, 0x64, 0x28, 0x50, 0x0e, 
  0x67, 0xc3, 0xcc, 0x80, 0xec, 0xb7, 0x48, 0x72, 0x44, 0x25, 0x77, 0x8c, 
  0x81, 0x65, 0x0c, 0x16, 0x6c, 0x94, 0x31, 0xab, 0xe0, 0x70, 0x15, 0x97, 
  0xce, 0xfb, 0x4b, 0x8c, 0x9a, 0xe8, 0x4b, 0x6a, 0x63, 0x77, 0xa4, 0x64, 
  0xde, 0xb2, 0xd4, 0xc3, 0x59, 0x98, 0x96, 0x16, 0x5e, 0x97, 0xb4, 0x48, 
  0xa5, 0xcb, 0x0b, 0x98, 0xd0, 0x7c, 0x26, 0x40, 0xcb, 0xff, 0xc4, 0x68, 
  0x74, 0x7c, 0x19, 0xb2, 0x76, 0x58, 0xac, 0x04, 0xac, 0xfc, 0x46, 0x32, 
  0x76, 0x4b, 0xdd, 0x18, 0xf6, 0x6d, 0xca, 0xbe, 0x76, 0x14, 0x39, 0x5d, 
  0x2c, 0xaf, 0xd8, 0xb2, 0xab, 0x77, 0xa8, 0x0b, 0xe8, 0x44, 0x4c, 0x76, 
  0xd3, 0xf4, 0xa1, 0x3b, 0xd5, 0x1d, 0xa1, 0x41, 0x02, 0xad, 0x56, 0x75, 
  0x14, 0xd8, 0xe3, 0x0f, 0x2b, 0xd5, 0x18, 0x42, 0x48, 0xaa, 0xb0, 0x8c, 
  0x31, 0x2b, 0xd4, 0x33, 0xeb, 0x71, 0xf9, 0xbb, 0x95, 0x1b, 0x49, 0x07, 
  0x7e, 0x15, 0x2c, 0x55, 0x56, 0x62, 0x86, 0x68, 0x14, 0x2f, 0x80, 0x52, 
  0x3f, 0x5a, 0xac, 0x08, 0x42, 0xe7, 0xdc, 0x15, 0xf0, 0x9e, 0xe8, 0x8f, 
  0x2e, 0xe5, 0xc0, 0xb1, 0x78, 0x9e, 0xeb, 0x7f, 0x93, 0x95, 0xe7, 0x34, 
  0x6c, 0xe5, 0x6f, 0x0f, 0x80, 0x88, 0x3a, 0x3e, 0xca, 0x57, 0x96, 0x3c, 
  0x57, 0x2b, 0x9b, 0x2e, 0xc5, 0xbd, 0x74, 0x3b, 0x3b, 0x32, 0xc4, 0xc4, 
  0x83, 0xf7, 0xf7, 0x7f, 0xb0, 0x5e, 0xf3, 0xe3, 0x4f, 0x90, 0xf7, 0x11, 
  0xca, 0xec, 0xdc, 0xc7, 0x46, 0x75, 0xe5, 0xa0, 0xa3, 0x05, 0x84, 0x89, 
  0x83, 0xe5, 0x73, 0xe8, 0x81, 0xce, 0xd9, 0x8e, 0x7e, 0x6c, 0x1e, 0x4d, 
  0x55, 0x0d, 0x3b, 0x67, 0x61, 0x41, 0x19, 0x00, 0x9f, 0x09, 0x60, 0x8a, 
  0x9c, 0x92, 0xab, 0x49, 0x05, 0x93, 0xb5, 0x15, 0x9d, 0x15, 0xf2, 0xc1, 
  0xc0, 0x10, 0x0d, 0x93, 0x9e, 0xbd, 0xf3, 0x02, 0xb8, 0x89, 0x09, 0xb1, 
  0x63, 0x16, 0x86, 0xd4, 0x34, 0x6b, 0x87, 0x9f, 0xcb, 0xce, 0xab, 0xcf, 
  0xfd, 0xef, 0x8c, 0x9f, 0x58, 0xdd, 0xe7, 0xff, 0x18, 0xb1, 0xf5, 0x11, 
  0x82, 0xfd, 0x30, 0x8f, 0x7a, 0x3c, 0xf8, 0xb7, 0x9f, 0xec, 0xb2, 0x48, 
  0xd3, 0x6b, 0x67, 0x52, 0x62, 0x11, 0x8c, 0x0a, 0x6c, 0x0e, 0xe5, 0x9a, 
  0x68, 0xf7, 0x7a, 0x77, 0xdc, 0xcb, 0x80, 0x55, 0x89, 0x7f, 0x8c, 0xf8, 
  0xdf, 0x1f, 0x77, 0x87, 0x4f, 0x7e, 0x72, 0xbd, 0x7e, 0xb2, 0xfb, 0xf6, 
  0x93, 0xbd, 0xde, 0xc6, 0xda, 0x3c, 0xa6, 0xa5, 0xc1, 0x85, 0x2b, 0x41, 
  0xc6, 0x0a, 0x38, 0x23, 0x79, 0x1a, 0x71, 0xe9, 0x1c, 0xed, 0xcd, 0x9b, 
  0xdc, 0xe5, 0x3c, 0x71, 0x0a, 0x63, 0x67, 0xa6, 0x89, 0x21, 0xed, 0xd5, 
  0x8b, 0x2e, 0x79, 0x39, 0x8d, 0x09, 0x4e, 0x41, 0x2d, 0x3a, 0x76, 0xa5, 
  0x5e, 0x31, 0x89, 0x7d, 0x57, 0x93, 0x15, 0x69, 0x5d, 0xa2, 0xc1, 0x07, 
  0x54, 0x7e, 0x8a, 0x5c, 0x15, 0xae, 0x1b, 0x84, 0x84, 0x8c, 0x07, 0x69, 
  0x1c, 0x7e, 0x03, 0x69, 0x38, 0x28, 0x0e, 0xa1, 0xc8, 0x32, 0x49, 0x77, 
  0xc1, 0x3f, 0x41, 0xdc, 0x83, 0xaf, 0x86, 0xb8, 0xde, 0x69, 0x36, 0xf3, 
  0xe1, 0x2b, 0x92, 0x2a, 0xaf, 0xd1, 0x30, 0x5a, 0xbb, 0xa8, 0x23, 0x21, 
  0x5c, 0xcf, 0xf8, 0xc0, 0x03, 0x23, 0xa6, 0xae, 0xc0, 0xcc, 0x68, 0xeb, 
  0xe3, 0x6f, 0x8d, 0xbb, 0xe1, 0x51, 0x70, 0xe6, 0xf9, 0xe2, 0xa6, 0xa0, 
  0x5b, 0xac, 0x3b, 0x5a, 0xf3, 0x8c, 0x9f, 0x90, 0x07, 0xdc, 0x39, 0x08, 
  0x22, 0x2e, 0x7f, 0x35, 0x70, 0x4f, 0xe1, 0xf3, 0x5d, 0x25, 0x97, 0x05, 
  0xb8, 0x2a, 0xd0, 0xe3, 0x1f, 0x2c, 0xb7, 0xdc, 0x15, 0x71, 0xce, 0x32, 
  0xfc, 0x32, 0xc3, 0x03, 0xa6, 0xe2, 0x38, 0x0c, 0x35, 0xb9, 0x91, 0x94, 
  0xed, 0x4b, 0xff, 0xbc, 0x0e, 0x5d, 0x68, 0x0b, 0x90, 0x7b, 0x05, 0x89, 
  0x56, 0x7a, 0xb6, 0x54, 0x48, 0x25, 0x04, 0xe8, 0xf6, 0xfa, 0x55, 0x4b, 
  0x38, 0x90, 0x6a, 0x71, 0x82, 0x60, 0xd2, 0x2d, 0x30, 0xe9, 0x0c, 0xe5, 
  0xa6, 0xef, 0x00, 0xb0, 0xe2, 0x81, 0xa6, 0xc9, 0xc7, 0xf4, 0x3f, 0xc9, 
  0xe5, 0xfc, 0x40, 0x25, 0xeb, 0xe6, 0x76, 0x75, 0x96, 0x4e, 0x58, 0x53, 
  0x1b, 0x5b, 0xab, 0x27, 0xb4, 0xa4, 0x90, 0xf7, 0xee, 0x57, 0x08, 0x01, 
  0xd1, 0xb1, 0x65, 0x9d, 0x63, 0x60, 0x4a, 0x76, 0x7b, 0x16, 0x76, 0xdf, 
  0xb1, 0x63, 0xbf, 0xca, 0x7a, 0xaa, 0x10, 0xd5, 0x5a, 0x41, 0x16, 0x6c, 
  0x3e, 0x84, 0xde, 0xa5, 0x15, 0xc8, 0x52, 0xff, 0x49, 0x7a, 0x87, 0x06, 
  0xf0, 0x10, 0xbd, 0xa3, 0xc7, 0xff, 0xd6, 0xa2, 0xd5, 0xc5, 0xa9, 0xe1, 
  0x62, 0x5b, 0x57, 0xad, 0x5a, 0x66, 0x59, 0x32, 0xeb, 0x4a, 0x18, 0x67, 
  0xd9, 0x42, 0x4e, 0xa8, 0x34, 0x13, 0x68, 0x16, 0x9b, 0xc3, 0x77, 0xf6, 
  0xfe, 0x96, 0xe6, 0xdf, 0x74, 0xab, 0x68, 0x5a, 0xd3, 0x0f, 0x95, 0xbb, 
  0xb2, 0x3c, 0x1b, 0xa2, 0x3d, 0xd3, 0x2f, 0xe0, 0xcb, 0xf6, 0xde, 0xfd, 
  0xe6, 0x21, 0xc7, 0xc0, 0xa8, 0xed, 0x02, 0x35, 0x5d, 0x14, 0xeb, 0xf3, 
  0xdd, 0x2a, 0x14, 0xaf, 0xe6, 0x09, 0x4a, 0x07, 0x89, 0x10, 0x95, 0x76, 
  0x94, 0x65, 0x63, 0xa7, 0x26, 0xd2, 0xbf, 0x70, 0x4b, 0x39, 0x0f, 0x89, 
  0x62, 0x55, 0x6a, 0x17, 0xf1, 0x82, 0x1a, 0x66, 0xe7, 0x68, 0x6b, 0x16, 
  0xc8, 0xe5, 0x08, 0xcf, 0x4c, 0x6d, 0x3d, 0x0e, 0x4e, 0x4f, 0x4e, 0x0e, 
  0x0f, 0xc2, 0xac, 0xf5, 0xb6, 0x26, 0x04, 0x59, 0xda, 0x1b, 0x53, 0x14, 
  0x03, 0x45, 0x04, 0x77, 0x49, 0x5a, 0x50, 0xe7, 0xae, 0x3a, 0x33, 0x3a, 
  0xd6, 0xc1, 0xdf, 0x8e, 0x30, 0x4e, 0xe9, 0xfd, 0x24, 0x3a, 0x7f, 0x8c, 
  0xda, 0x27, 0x79, 0x63, 0xb1, 0x5a, 0xeb, 0xf0, 0xd1, 0x49, 0x4c, 0xfa, 
  0x0f, 0xe8, 0xeb, 0x6c, 0x3b, 0x00, 0x81, 0x7a, 0xae, 0xf9, 0x8a, 0xdd, 
  0x81, 0xfc, 0xe7, 0xa2, 0x64, 0x96, 0x96, 0x09, 0xcd, 0x71, 0x0d, 0x24, 
  0xb3, 0x6c, 0x73, 0xc4, 0x4b, 0x82, 0xea, 0x3f, 0x45, 0x0e, 0x5d, 0xba, 
  0xf3, 0x74, 0x4a, 0xd6, 0x8b, 0x1d, 0x4d, 0xea, 0x52, 0x0d, 0x4f, 0xaa, 
  0xd6, 0x89, 0xb5, 0x14, 0xae, 0x00, 0x85, 0x69, 0x6c, 0x26, 0x6c, 0x9e, 
  0xfa, 0x5a, 0x21, 0x21, 0x69, 0x01, 0x47, 0x4b, 0x90, 0xec, 0x68, 0x8e, 
  0x8c, 0x3f, 0xcd, 0x2b, 0x83, 0xc7, 0x5b, 0x39, 0xc8, 0xe0, 0x31, 0xf5, 
  0xf2, 0xd9, 0x7e, 0x3b, 0x25, 0xfc, 0x6a, 0xc6, 0x70, 0x86, 0x7d, 0x2d, 
  0xdb, 0xd6, 0x2a, 0x83, 0xca, 0x41, 0xd1, 0x96, 0xd3, 0x09, 0x6f, 0x0c, 
  0xad, 0x9a, 0x41, 0xe0, 0x00, 0xcf, 0x2b, 0x2e, 0x6f, 0xcb, 0x5a, 0x00, 
  0x4f, 0x17, 0x04, 0x28, 0xed, 0xe3, 0xa2, 0xd5, 0x4c, 0x7d, 0x30, 0xa3, 
  0xb5, 0x7b, 0xd1, 0x4c, 0x7c, 0x68, 0x89, 0xcd, 0x2e, 0x39, 0xb4, 0x25, 
  0x4e, 0xcb, 0xd7, 0xa3, 0x24, 0xea, 0x71, 0xda, 0x68, 0x2f, 0x0c, 0x18, 
  0x36, 0xef, 0xbf, 0xbd, 0xcb, 0xae, 0xa9, 0xa3, 0xb3, 0xee, 0x16, 0x6c, 
  0xe4, 0xa1, 0xde, 0x0b, 0x76, 0xbd, 0xf9, 0x26, 0x4b, 0xdf, 0x21, 0x3e, 
  0xa6, 0xad, 0x26, 0xbb, 0x5c, 0xd8, 0xf5, 0xa3, 0x8a, 0x7a, 0xbb, 0x4f, 
  0xf7, 0x46, 0xbb, 0x9f, 0x7e, 0xc6, 0x9a, 0xf6, 0x6e, 0x6d, 0x78, 0x52, 
  0x1e, 0x97, 0x1a, 0xa1, 0x43, 0xf5, 0xcf, 0xee, 0x16, 0xb8, 0x70, 0x6e, 
  0x87, 0x5f, 0x23, 0xea, 0x90, 0x96, 0xc3, 0x95, 0x98, 0xaf, 0x46, 0x81, 
  0x7b, 0xa2, 0xd6, 0xa9, 0x39, 0x4b, 0x9a, 0x16, 0x50, 0x3d, 0x13, 0x2c, 
  0xa3, 0x4a, 0x4d, 0x69, 0x2d, 0xcf, 0xa7, 0x9a, 0xd5, 0x96, 0x8b, 0xf1, 
  0x46, 0x38, 0xe9, 0x22, 0x1d, 0xdf, 0x76, 0xf7, 0x2f, 0x61, 0xc3, 0xe8, 
  0xa3, 0x5f, 0x9a, 0x9c, 0xe4, 0x7a, 0xfb, 0x85, 0x42, 0x67, 0x9e, 0xb5, 
  0x0a, 0x71, 0x0b, 0xe6, 0xc6, 0xcb, 0x76, 0x71, 0x13, 0x1c, 0x25, 0x09, 
  0xae, 0x72, 0xe8, 0x75, 0xb5, 0x07, 0x37, 0xea, 0x59, 0x73, 0xfe, 0x46, 
  0x76, 0xb5, 0x7c, 0x3a, 0x0e, 0x22, 0x5a, 0xbd, 0x6a, 0x14, 0x1b, 0xa9, 
  0x17, 0x10, 0xd2, 0x4a, 0x38, 0x34, 0x17, 0xd2, 0x87, 0xd8, 0x43, 0xc9, 
  0xef, 0xfc, 0xe1, 0x0f, 0x01, 0x3b, 0xfa, 0x5b, 0x0d, 0x49, 0x23, 0x2e, 
  0x83, 0x20, 0x7f, 0x9f, 0x54, 0x90, 0x67, 0xb5, 0x34, 0x60, 0x94, 0x5e, 
  0xec, 0x60, 0xc6, 0xff, 0x0f, 0xbb, 0xe8, 0xb6, 0x47, 0xcc, 0x80, 0xcd, 
  0xf9, 0x1a, 0x56, 0x19, 0x46, 0xec, 0xbd, 0x26, 0x1f, 0x4d, 0xda, 0x85, 
  0xcb, 0xe2, 0x30, 0x0b, 0x24, 0x18, 0xe1, 0xff, 0x22, 0x86, 0x89, 0x2c, 
  0x04, 0xce, 0x46, 0xe1, 0xfe, 0xbb, 0x99, 0x25, 0x97, 0x7d, 0x40, 0x01, 
  0xb8, 0xe2, 0x2a, 0xad, 0x60, 0x91, 0x09, 0xe2, 0x24, 0x25, 0x36, 0x57, 
  0xee, 0x0a, 0x8e, 0x4a, 0xe8, 0xcc, 0x79, 0x1e, 0x45, 0xff, 0x0b, 0xdd, 
  0xb8, 0xfa, 0x48, 0xc8, 0xf0, 0x62, 0x0d, 0xfe, 0xcb, 0xc3, 0x57, 0xa7, 
  0xe7, 0x87, 0xb5, 0x22, 0xc5, 0x6d, 0x5d, 0xac, 0x8a, 0x81, 0xef, 0x2b, 
  0xc1, 0x76, 0x8c, 0x1a, 0x25, 0x69, 0x07, 0xd6, 0x98, 0xc4, 0x13, 0x03, 
  0x44, 0xa2, 0x13, 0x97, 0x9f, 0x9d, 0x2c, 0x63, 0x46, 0x9f, 0xe5, 0x60, 
  0x04, 0xeb, 0x25, 0x84, 0x2b, 0x9b, 0x9b, 0x84, 0xc4, 0xf5, 0xd4, 0x39, 
  0xb5, 0xa1, 0x2b, 0x3f, 0x9e, 0x15, 0xbc, 0x10, 0x42, 0x24, 0x9e, 0x23, 
  0x8e, 0x9b, 0xa1, 0x23, 0x6d, 0x20, 0x2e, 0x1f, 0xb3, 0x58, 0x66, 0xad, 
  0x64, 0x18, 0x14, 0x64, 0x12, 0xb3, 0x1e, 0x06, 0xd9, 0x08, 0x97, 0xf1, 
  0x09, 0x28, 0x6b, 0xd8, 0xad, 0xa1, 0x91, 0x2a, 0xa8, 0xa0, 0x02, 0xb8, 
  0x3b, 0xdc, 0x09, 0x1b, 0xc4, 0x20, 0x28, 0x32, 0xb7, 0x3e, 0x58, 0xc3, 
  0x81, 0xd6, 0x5c, 0x49, 0x8e, 0x9d, 0xcc, 0x90, 0x13, 0x55, 0x10, 0x69, 
  0x55, 0xae, 0xb2, 0x8a, 0xaf, 0x9f, 0xb6, 0x7d, 0x8f, 0x29, 0x7d, 0x9c, 
  0x17, 0x10, 0x1f, 0x38, 0x06, 0xc5, 0xef, 0x68, 0xc9, 0x80, 0x77, 0x4f, 
  0x9f, 0x3c, 0xe5, 0xd3, 0xcf, 0x85, 0x51, 0xfe, 0x7d, 0xbc, 0xa7, 0x1a, 
  0xbe, 0xff, 0x83, 0x85, 0x0c, 0xba, 0xeb, 0x18, 0x88, 0xd3, 0x18, 0x81, 
  0x39, 0x9a, 0xb5, 0xd3, 0x91, 0x8e, 0xeb, 0x5c, 0x10, 0x57, 0x49, 0x98, 
  0xc2, 0x4a, 0xd3, 0xd1, 0x0a, 0x05, 0x28, 0x37, 0xe7, 0xe1, 0x7e, 0x5a, 
  0xf2, 0x5a, 0xb3, 0xce, 0x81, 0xbd, 0xa7, 0x85, 0x0d, 0x78, 0x9b, 0x1a, 
  0x99, 0xc2, 0xa3, 0x87, 0x2d, 0x2f, 0xae, 0x76, 0x43, 0xab, 0xa4, 0x41, 
  0xb1, 0x8d, 0x35, 0xb9, 0xa6, 0xd5, 0xc0, 0x8f, 0xcf, 0xd7, 0x41, 0x14, 
  0x6c, 0x31, 0xce, 0x09, 0x71, 0xf0, 0xe4, 0x4e, 0x3c, 0x33, 0x1c, 0x04, 
  0x16, 0x69, 0x31, 0x8d, 0x4d, 0xbe, 0x2b, 0x62, 0x18, 0x42, 0xd2, 0x96, 
  0x4b, 0xd8, 0x2c, 0x7f, 0x5b, 0x06, 0x58, 0x87, 0x16, 0x77, 0x47, 0xbb, 
  0xc0, 0x0b, 0x70, 0x61, 0xcf, 0xa3, 0xe8, 0x9c, 0xdb, 0x42, 0x42, 0x58, 
  0x3b, 0xeb, 0xcb, 0x27, 0x5d, 0x01, 0xd5, 0xcc, 0x1b, 0x37, 0x38, 0x3e, 
  0xab, 0x45, 0x16, 0x3b, 0xc3, 0xc7, 0x4f, 0x9f, 0xd6, 0xec, 0x82, 0x21, 
  0xa7, 0x7c, 0xb2, 0xb3, 0x23, 0x21, 0x6c, 0xcd, 0xd7, 0xe8, 0x8b, 0xe1, 
  0x53, 0xbc, 0x58, 0x7f, 0x4d, 0x65, 0xc8, 0xb5, 0xef, 0x0d, 0xf9, 0x9b, 
  0x8e, 0xee, 0x70, 0xf3, 0xac, 0x7d, 0xeb, 0x69, 0xc7, 0x5b, 0x78, 0x4d, 
  0xd2, 0x30, 0xb0, 0x58, 0xf9, 0x74, 0xca, 0xc0, 0x35, 0x78, 0xb4, 0x2d, 
  0x94, 0xd7, 0xe4, 0xa6, 0xfb, 0xb8, 0x1d, 0x63, 0xb0, 0x33, 0xdc, 0x19, 
  0x0c, 0x77, 0x3b, 0xba, 0xb0, 0xc4, 0x30, 0x75, 0x09, 0x88, 0x5d, 0x06, 
  0x1d, 0xaf, 0xed, 0x82, 0xe5, 0x96, 0xcd, 0xdf, 0x6f, 0x6d, 0x7e, 0xbd, 
  0xd5, 0xb5, 0x6c, 0x7f, 0xdc, 0xd9, 0x19, 0x7c, 0xca, 0x3f, 0x9f, 0x3e, 
  0x5d, 0xdb, 0x82, 0x1f, 0xc3, 0x23, 0x5b, 0x93, 0xda, 0x2c, 0xa9, 0x9d, 
  0x8e, 0xd6, 0x77, 0xa9, 0xd5, 0xdd, 0xa7, 0x4f, 0x07, 0xdc, 0xcb, 0x93, 
  0x0f, 0x6a, 0x9d, 0xef, 0xb7, 0xfb, 0x3c, 0x8a, 0x7c, 0x46, 0x34, 0x5a, 
  0xd1, 0x09, 0x96, 0x6b, 0x5b, 0x00, 0x2d, 0x97, 0x8d, 0x39, 0xd2, 0x9f, 
  0xd1, 0x0b, 0x84, 0x08, 0x06, 0x65, 0x2b, 0x02, 0x6d, 0xb0, 0x2e, 0x2e, 
  0xb3, 0x95, 0x79, 0xa5, 0x9c, 0x7f, 0xc3, 0xe5, 0xea, 0x29, 0xae, 0xa7, 
  0x8b, 0xde, 0xf7, 0x05, 0x2a, 0x7e, 0x08, 0xf0, 0x9f, 0xb4, 0xb8, 0x6d, 
  0x7c, 0x1f, 0x17, 0xea, 0x06, 0x84, 0x9d, 0xcf, 0x9d, 0x16, 0xcb, 0x0e, 
  0x20, 0x55, 0x30, 0x28, 0x70, 0xa7, 0x5e, 0xce, 0xd4, 0x43, 0x80, 0x88, 
  0x8f, 0x65, 0x82, 0x60, 0x6a, 0xf1, 0x86, 0x1a, 0x0e, 0x5d, 0x10, 0x81, 
  0x1e, 0x80, 0xab, 0x69, 0x45, 0x9c, 0x81, 0xc5, 0xc5, 0x9a, 0xcc, 0x62, 
  0x50, 0x9d, 0x88, 0xd1, 0xf3, 0x30, 0x20, 0x6e, 0xec, 0x7c, 0x74, 0xe5, 
  0xf8, 0x5b, 0xf8, 0x63, 0xa9, 0xc1, 0xdf, 0x1a, 0x7e, 0x20, 0xf1, 0xb9, 
  0x08, 0xd3, 0x01, 0xf3, 0x7f, 0x17, 0xf5, 0x11, 0xb5, 0xe9, 0x3c, 0xde, 
  0x65, 0x95, 0x2f, 0xfa, 0xd1, 0xa6, 0x05, 0x79, 0xd8, 0xca, 0xe9, 0x0d, 
  0x14, 0x66, 0x33, 0xb1, 0xbd, 0x78, 0xce, 0x29, 0x9e, 0x13, 0xae, 0xc5, 
  0x7d, 0xe4, 0xc6, 0x3e, 0x49, 0x16, 0x88, 0x8a, 0xb4, 0xf0, 0x79, 0x52, 
  0xcd, 0xe9, 0xc6, 0x70, 0xb2, 0xc4, 0xc5, 0xd1, 0xff, 0x3e, 0x1c, 0xfd, 
  0xa7, 0x45, 0x46, 0xcf, 0x3b, 0xcf, 0xbd, 0xd1, 0x99, 0x5f, 0x7e, 0x0f, 
  0x5a, 0x9d, 0x07, 0xf4, 0x98, 0xa5, 0x57, 0xcd, 0x8c, 0x00, 0x92, 0xa4, 
  0xda, 0xd8, 0x12, 0xf9, 0xd2, 0x34, 0x6d, 0x8c, 0xad, 0x8a, 0xe7, 0x8b, 
  0x0e, 0x3b, 0xb3, 0x00, 0xe7, 0x6b, 0xfc, 0x57, 0x5b, 0xd0, 0x89, 0xef, 
  0xe8, 0x72, 0x97, 0x1a, 0x87, 0xb1, 0x5a, 0xb8, 0xd5, 0xf8, 0xad, 0xf7, 
  0x18, 0xef, 0xb3, 0x6a, 0xf5, 0x1d, 0xe8, 0x20, 0xae, 0xe7, 0x0f, 0x0e, 
  0x40, 0x5c, 0x83, 0xa0, 0x30, 0x69, 0xc7, 0x9f, 0x89, 0x73, 0x03, 0x6d, 
  0x40, 0x35, 0x0f, 0x96, 0xb6, 0xe4, 0x34, 0x30, 0x20, 0x1e, 0x37, 0x2f, 
  0x36, 0x81, 0x41, 0x9e, 0xe7, 0x13, 0x12, 0xdb, 0x5e, 0x4a, 0x45, 0x2a, 
  0x8e, 0x00, 0x63, 0x05, 0xfe, 0x1a, 0x7a, 0x57, 0x24, 0x52, 0x30, 0x22, 
  0x37, 0x01, 0x27, 0xdf, 0x0a, 0x52, 0x29, 0x39, 0xb6, 0x88, 0x3d, 0xf3, 
  0xaf, 0xbd, 0x56, 0x3d, 0x5f, 0x7e, 0x78, 0xc4, 0xc5, 0xbf, 0x60, 0x5e, 
  0xa8, 0x37, 0x3f, 0xbc, 0xe0, 0xe9, 0xd1, 0xb0, 0x87, 0x5d, 0x03, 0xf4, 
  0xd5, 0xe2, 0x44, 0x09, 0xe1, 0x6c, 0x3d, 0x35, 0x00, 0x88, 0x6b, 0x91, 
  0xe7, 0x8b, 0x17, 0xdd, 0x64, 0xda, 0x05, 0xbc, 0x53, 0x81, 0x8a, 0xfe, 
  0x98, 0xa6, 0x61, 0x3f, 0x8e, 0x50, 0xc0, 0xe2, 0x6a, 0x4d, 0x65, 0xf4, 
  0x1c, 0x3e, 0xa8, 0x67, 0xcc, 0x07, 0x5a, 0x55, 0x91, 0xde, 0xb4, 0xea, 
  0x4c, 0x5c, 0x9c, 0x1e, 0x7c, 0x73, 0xf1, 0xc4, 0xcc, 0x90, 0x47, 0x56, 
  0xbe, 0x98, 0x71, 0xb7, 0xe5, 0xfc, 0x77, 0xc4, 0x06, 0x20, 0x30, 0x23, 
  0xa8, 0x47, 0x04, 0x6d, 0x92, 0xbf, 0x88, 0xcb, 0x72, 0x89, 0x8a, 0x21, 
  0x44, 0xd1, 0x68, 0x63, 0x77, 0xe7, 0xb3, 0x9d, 0x16, 0x70, 0xf7, 0xa9, 
  0x7a, 0x53, 0x6a, 0xc8, 0xd6, 0xbb, 0xef, 0x89, 0x29, 0xf2, 0xb5, 0x50, 
  0x22, 0x29, 0x04, 0xe2, 0xeb, 0xb2, 0xa9, 0x49, 0x96, 0xce, 0x67, 0x53, 
  0x38, 0x70, 0x26, 0xc6, 0x81, 0x2a, 0x6c, 0x2b, 0xa8, 0x2a, 0x44, 0x11, 
  0x4b, 0xf0, 0xbc, 0xe4, 0xdd, 0x78, 0xb6, 0xe4, 0xf2, 0x98, 0xbf, 0x22, 
  0x2a, 0x45, 0x59, 0x91, 0x48, 0xba, 0xa6, 0xaa, 0xe4, 0xb9, 0xe5, 0x69, 
  0x70, 0x6a, 0x07, 0x27, 0x2a, 0x03, 0x35, 0x2a, 0xd2, 0x57, 0x3a, 0x0b, 
  0x4b, 0xae, 0x0b, 0x17, 0xf0, 0xea, 0x87, 0x2f, 0xe5, 0xa2, 0x51, 0x1b, 
  0x08, 0x5a, 0x25, 0xb5, 0x08, 0x19, 0x3b, 0x2d, 0x01, 0xd8, 0xee, 0x20, 
  0xcb, 0xeb, 0x97, 0xfe, 0xf3, 0xa5, 0x85, 0x63, 0xd5, 0x42, 0xe9, 0x69, 
  0x97, 0xd3, 0x16, 0x9f, 0x90, 0x92, 0x59, 0x06, 0xdb, 0x67, 0xc8, 0x65, 
  0xe5, 0x0d, 0x20, 0xfd, 0xf8, 0x58, 0x4d, 0x92, 0x31, 0x33, 0x12, 0xcb, 
  0x1d, 0x69, 0x8b, 0xf1, 0x5c, 0x0b, 0xe4, 0x8a, 0x6b, 0x88, 0xa4, 0xbf, 
  0x42, 0xfd, 0x24, 0xb7, 0x33, 0xd5, 0x78, 0x31, 0xcc, 0x88, 0xb9, 0xcd, 
  0xe2, 0x66, 0x38, 0xcb, 0x25, 0x67, 0x33, 0x48, 0xe9, 0x0c, 0x59, 0xd3, 
  0xe8, 0xf2, 0xe0, 0xec, 0xed, 0xc9, 0xe9, 0xcb, 0xc3, 0xe3, 0xfd, 0x1f, 
  0x9c, 0xa9, 0x7a, 0x14, 0x19, 0xc0, 0x5f, 0xa7, 0x8b, 0x7b, 0xf6, 0x36, 
  0x89, 0xcb, 0xd5, 0x5b, 0x12, 0xb7, 0xe8, 0xf1, 0xcd, 0x47, 0x5b, 0x2c, 
  0x63, 0x48, 0x62, 0x5c, 0x18, 0x86, 0x4c, 0x2a, 0x9c, 0x46, 0x6b, 0x76, 
  0x9a, 0xc3, 0x5b, 0x88, 0xf0, 0x7b, 0xef, 0xc7, 0x66, 0x7a, 0x2f, 0x38, 
  0xd3, 0x3f, 0xdb, 0xc5, 0xdc, 0x38, 0x79, 0x13, 0xb0, 0x4c, 0xe5, 0x1a, 
  0x5c, 0xa6, 0x8a, 0x8e, 0x56, 0x95, 0xcc, 0xb2, 0xa4, 0xd2, 0x78, 0xd4, 
  0xe8, 0xf9, 0xe9, 0xd9, 0xe5, 0x8b, 0xbb, 0xb8, 0x85, 0xb5, 0x02, 0x97, 
  0x66, 0x6e, 0x70, 0x0f, 0x2e, 0xe0, 0x57, 0x5e, 0xf6, 0xa1, 0x42, 0x1c, 
  0x9f, 0x6f, 0x20, 0x31, 0xdd, 0x98, 0x87, 0x7c, 0x76, 0x5b, 0x36, 0xc5, 
  0xcb, 0xcb, 0x1f, 0xce, 0x0e, 0x5f, 0x3c, 0xe7, 0x32, 0x67, 0x9f, 0x4b, 
  0x99, 0x41, 0x18, 0x1f, 0xb4, 0xea, 0x99, 0x00, 0xdd, 0x34, 0xdf, 0xf9, 
  0xfe, 0xe5, 0xd1, 0xc5, 0xd9, 0xf1, 0xe9, 0xc1, 0x8b, 0xe7, 0xdf, 0x1b, 
  0x4a, 0x5a, 0xf0, 0xae, 0xfb, 0xcc, 0x65, 0xf3, 0xb4, 0xd3, 0x56, 0x0e, 
  0xbf, 0x7b, 0x7b, 0x78, 0xf2, 0xed, 0x8b, 0xe7, 0x77, 0x71, 0x31, 0xe0, 
  0x29, 0x6b, 0x81, 0xc3, 0xac, 0x33, 0x22, 0x3b, 0x58, 0xb5, 0x4b, 0x46, 
  0x7b, 0x04, 0x3c, 0xf9, 0x03, 0x6a, 0xb0, 0x30, 0x3e, 0x97, 0x05, 0x62, 
  0x56, 0x04, 0x0f, 0xfc, 0x17, 0xca, 0x10, 0x9d, 0xf5, 0x39, 0x55, 0x44, 
  0x79, 0x73, 0x7e, 0x6c, 0x2c, 0xbd, 0xd0, 0xbc, 0x9a, 0xc0, 0x6d, 0x6e, 
  0x70, 0xea, 0xeb, 0xed, 0xc9, 0xdc, 0xc0, 0x20, 0x92, 0x4b, 0xda, 0x12, 
  0xd5, 0xa4, 0xbe, 0x26, 0x4e, 0x57, 0xdd, 0x8d, 0x3f, 0xea, 0x48, 0xed, 
  0xf1, 0xa9, 0x27, 0x30, 0x46, 0x30, 0x9b, 0x8e, 0x79, 0x62, 0xa9, 0x38, 
  0x6f, 0xb7, 0xe5, 0x48, 0x89, 0x5c, 0x14, 0xb7, 0xbc, 0x86, 0x3e, 0xdb, 
  0x40, 0x13, 0x37, 0x99, 0x65, 0x33, 0x0e, 0x11, 0x66, 0x8d, 0x51, 0x59, 
  0x74, 0x91, 0x4d, 0xaf, 0x2b, 0x74, 0x40, 0x30, 0xd3, 0x8b, 0x20, 0xc4, 
  0x91, 0xf1, 0x3a, 0x6e, 0xdd, 0xd8, 0x0a, 0xe5, 0x13, 0xeb, 0x93, 0x99, 
  0x8d, 0x77, 0x36, 0xa4, 0x3f, 0x57, 0x5e, 0x11, 0x58, 0x09, 0x97, 0x66, 
  0x7a, 0x68, 0x15, 0x83, 0xa1, 0xc6, 0xd9, 0x77, 0xc4, 0xa6, 0x16, 0xa7, 
  0xb7, 0x08, 0x11, 0x04, 0x36, 0x1c, 0x16, 0x44, 0xa5, 0x4e, 0x49, 0x2b, 
  0xf9, 0xb3, 0x72, 0xf5, 0x78, 0xac, 0x8e, 0x6d, 0x8c, 0xd0, 0x13, 0x2e, 
  0x8e, 0x16, 0x96, 0x45, 0x39, 0x7b, 0xe3, 0xac, 0x9f, 0x1f, 0x74, 0x17, 
  0x35, 0x64, 0x02, 0x3f, 0xa5, 0xde, 0xb0, 0x17, 0x6d, 0xc6, 0x6a, 0x42, 
  0x86, 0x15, 0x6d, 0xcb, 0x59, 0xd2, 0x81, 0xfa, 0xb1, 0xe6, 0xca, 0x40, 
  0x56, 0x9a, 0xb8, 0x35, 0x3b, 0x81, 0xb0, 0xbe, 0x54, 0xab, 0x19, 0x02, 
  0xd6, 0x3e, 0x1b, 0xd8, 0x4d, 0x51, 0x35, 0x72, 0xf4, 0x43, 0x5e, 0xd5, 
  0x25, 0x12, 0x37, 0x15, 0x85, 0x78, 0x1d, 0xcc, 0x58, 0x98, 0xe0, 0xff, 
  0x99, 0x22, 0x1d, 0x02, 0x56, 0xc5, 0x40, 0xc0, 0x3d, 0xac, 0x08, 0x42, 
  0xfb, 0x86, 0x97, 0x1d, 0x3e, 0x11, 0x2d, 0xe0, 0xc9, 0xc1, 0x48, 0x8e, 
  0x5a, 0x43, 0xfb, 0xee, 0x28, 0x3a, 0xe4, 0x07, 0x86, 0x97, 0xd1, 0x1f, 
  0x3a, 0x2a, 0xc4, 0x2e, 0xe2, 0xb4, 0x08, 0xf4, 0xe3, 0x7b, 0x05, 0x46, 
  0xd1, 0xed, 0x17, 0xec, 0x9b, 0x5c, 0x91, 0xee, 0x47, 0x72, 0x4d, 0xb4, 
  0xb0, 0xd9, 0x38, 0x5f, 0xc9, 0xc5, 0xb4, 0xf5, 0x0c, 0xfa, 0xbc, 0x67, 
  0xfa, 0xc8, 0xf0, 0xd2, 0x41, 0xfa, 0x0c, 0x10, 0x8a, 0xde, 0xca, 0xb9, 
  0x41, 0x08, 0xac, 0x1e, 0x44, 0x9e, 0xb6, 0xf6, 0xee, 0x2c, 0x75, 0x9a, 
  0x28, 0x97, 0x23, 0xea, 0x17, 0x9b, 0xde, 0x51, 0x29, 0xb7, 0x8e, 0x44, 
  0x07, 0xe0, 0x9d, 0x1a, 0x12, 0x7b, 0x59, 0xad, 0x66, 0x01, 0xce, 0x57, 
  0xbb, 0x5c, 0x9f, 0x86, 0x74, 0x0d, 0x7c, 0x21, 0xa9, 0x6e, 0x3c, 0x7c, 
  0xf0, 0x49, 0xfe, 0xb7, 0xf7, 0x77, 0x1e, 0xd8, 0xee, 0x80, 0xff, 0xdd, 
  0xfb, 0x47, 0x0f, 0x2a, 0xb7, 0x47, 0x13, 0x95, 0x49, 0xb4, 0xcf, 0x2b, 
  0x37, 0x6c, 0x61, 0x5f, 0x1d, 0x51, 0x5e, 0x9c, 0xb7, 0xb6, 0xa6, 0x5b, 
  0xf4, 0xda, 0x4b, 0xe7, 0xd7, 0x3f, 0xee, 0x0e, 0x77, 0x77, 0x76, 0x76, 
  0x7e, 0x1a, 0x2d, 0x78, 0x99, 0xd9, 0x23, 0x48, 0x7d, 0xb2, 0x5f, 0x70, 
  0x91, 0x8e, 0x59, 0xcf, 0x9f, 0xc7, 0xad, 0x82, 0x38, 0x69, 0x0c, 0x54, 
  0x53, 0x19, 0xd4, 0x76, 0x20, 0xee, 0x71, 0xe1, 0xd9, 0x35, 0x7c, 0xde, 
  0x22, 0x7c, 0x63, 0x64, 0xac, 0x45, 0xf2, 0x24, 0x57, 0x1e, 0xc7, 0x41, 
  0x82, 0x39, 0x80, 0xda, 0x84, 0xf4, 0x94, 0x49, 0xb8, 0x75, 0xb3, 0x5b, 
  0x49, 0x8b, 0x83, 0x25, 0x93, 0xa5, 0x70, 0xa4, 0xa2, 0x23, 0x51, 0x2e, 
  0x91, 0x1a, 0x5c, 0x5c, 0xf8, 0x3d, 0x48, 0x03, 0x18, 0x74, 0xbb, 0x86, 
  0xe5, 0xc4, 0x6a, 0x84, 0x16, 0x0e, 0x2e, 0x78, 0x02, 0x73, 0x81, 0xb8, 
  0xf4, 0x30, 0x41, 0xc0, 0xe5, 0x68, 0x07, 0x3b, 0x85, 0x51, 0xe7, 0x89, 
  0x55, 0x2b, 0x87, 0xbc, 0xf8, 0x91, 0x65, 0xea, 0xf5, 0x20, 0x95, 0xba, 
  0xea, 0xc3, 0xb8, 0x1c, 0xa7, 0xe9, 0xff, 0xbf, 0xf6, 0x4e, 0xa6, 0x48, 
  0x4b, 0x97, 0xc8, 0xe5, 0x73, 0x84, 0x30, 0x75, 0xc9, 0x11, 0x9a, 0x25, 
  0xd4, 0x45, 0x19, 0x89, 0x00, 0xda, 0x4a, 0xc5, 0x4a, 0xde, 0x89, 0xdc, 
  0xc0, 0x0b, 0x22, 0xc6, 0xa6, 0x1b, 0x0e, 0x3e, 0xe0, 0x31, 0xec, 0x5f, 
  0x1c, 0x1c, 0x1d, 0xd5, 0x82, 0xf1, 0x78, 0x29, 0x5b, 0x40, 0x0a, 0x95, 
  0x43, 0xb3, 0x29, 0x19, 0x4f, 0x1c, 0x96, 0x02, 0x8b, 0x7d, 0x85, 0xd1, 
  0x0d, 0x09, 0x73, 0x1c, 0x9b, 0x2d, 0xc5, 0x9b, 0x5b, 0x2b, 0x06, 0xc7, 
  0x18, 0x33, 0xe5, 0x65, 0xc6, 0x52, 0x04, 0x87, 0xb2, 0xdf, 0x2c, 0x89, 
  0x13, 0x7f, 0x74, 0x25, 0xe1, 0x01, 0x5a, 0x5b, 0x2a, 0x80, 0x77, 0xf4, 
  0x9c, 0xff, 0x75, 0x05, 0x89, 0xd7, 0x25, 0x76, 0x4b, 0xb2, 0x62, 0x90, 
  0x2e, 0x69, 0x37, 0x2b, 0x4f, 0x4b, 0xad, 0x99, 0x12, 0x52, 0xd4, 0x86, 
  0xf9, 0x5c, 0x23, 0x8d, 0x7e, 0x34, 0xac, 0x9a, 0x37, 0xa6, 0x3e, 0xff, 
  0x92, 0x09, 0x3e, 0x3c, 0xc3, 0x30, 0xe0, 0xfc, 0xbf, 0x3f, 0x41, 0xc6, 
  0x0e, 0x8b, 0x9e, 0xd3, 0xa5, 0xb4, 0x6e, 0x32, 0xb1, 0x15, 0x89, 0x47, 
  0x04, 0x72, 0x5d, 0x03, 0x66, 0x14, 0x05, 0xa9, 0x8f, 0x78, 0x43, 0xb3, 
  0x5d, 0x75, 0x29, 0xc1, 0x61, 0x1c, 0x42, 0x50, 0x70, 0x84, 0x05, 0x37, 
  0xf8, 0x52, 0x3a, 0xfd, 0xb8, 0x1d, 0xfe, 0x35, 0x76, 0x56, 0x3a, 0xfc, 
  0x3d, 0x36, 0x7e, 0xa8, 0x13, 0x46, 0x6c, 0xb5, 0xf0, 0xb3, 0x71, 0xf9, 
  0x9d, 0x8e, 0x12, 0x26, 0x45, 0x3e, 0x8b, 0x5c, 0x21, 0x1d, 0x95, 0x24, 
  0x71, 0x9b, 0xf3, 0x2f, 0xaa, 0xe2, 0x5b, 0xc5, 0x9d, 0x8e, 0x74, 0xbe, 
  0x20, 0x82, 0x5d, 0x83, 0x51, 0x9b, 0xe1, 0xbe, 0x6d, 0x40, 0xfa, 0xe1, 
  0x9d, 0x44, 0xeb, 0x5f, 0xe5, 0xad, 0x14, 0xad, 0xd7, 0x96, 0x78, 0x28, 
  0xeb, 0xc9, 0xec, 0x12, 0xa9, 0x6a, 0x91, 0x3e, 0xbe, 0x5d, 0xc5, 0xb3, 
  0xdb, 0x98, 0x59, 0x27, 0x5b, 0x08, 0xb1, 0xb8, 0x2d, 0xf7, 0x1c, 0xec, 
  0x5f, 0xa2, 0x31, 0x5f, 0x2d, 0xaf, 0xaf, 0x51, 0xb0, 0xee, 0x98, 0x3d, 
  0x94, 0x82, 0x4b, 0xe0, 0xe2, 0x78, 0xfa, 0x9f, 0xf7, 0x21, 0x0d, 0x35, 
  0xf5, 0x68, 0x29, 0x52, 0xc2, 0xdc, 0x52, 0x8b, 0xb2, 0x0c, 0xa2, 0xfe, 
  0x73, 0x7d, 0x54, 0xbe, 0x64, 0x28, 0x2b, 0x1a, 0x82, 0xc0, 0xe7, 0x76, 
  0x48, 0x64, 0x0e, 0x6c, 0x33, 0xba, 0x49, 0x89, 0x2b, 0x70, 0xd9, 0x81, 
  0x7a, 0xa9, 0x4a, 0x13, 0x0d, 0xfd, 0x90, 0xba, 0x12, 0x1d, 0xfa, 0xbf, 
  0xb7, 0x5e, 0xe3, 0xc9, 0x24, 0xd5, 0x64, 0x4b, 0xbe, 0x31, 0x3c, 0xd6, 
  0xaa, 0x8e, 0xf0, 0x01, 0x90, 0xbd, 0xb4, 0x9e, 0xe4, 0xc1, 0x99, 0x11, 
  0x12, 0x60, 0x66, 0x98, 0x33, 0x86, 0x93, 0xd1, 0xb6, 0x6f, 0xd3, 0xa6, 
  0x0e, 0xea, 0x18, 0x36, 0x8e, 0xff, 0x2a, 0xd9, 0xa9, 0x09, 0x87, 0x51, 
  0x98, 0xda, 0x73, 0x98, 0x76, 0x17, 0x3b, 0x01, 0x80, 0xae, 0xea, 0x57, 
  0x9e, 0x80, 0x69, 0x21, 0xa0, 0x3e, 0x5a, 0xd6, 0x3e, 0xee, 0xbd, 0x2e, 
  0xf8, 0xa9, 0x24, 0x43, 0xa8, 0x9e, 0x99, 0x43, 0x06, 0xce, 0x89, 0xab, 
  0xb2, 0xa7, 0x09, 0x54, 0x0c, 0xb7, 0xa3, 0xb7, 0x7c, 0x53, 0x5e, 0xc6, 
  0xa5, 0xff, 0xf1, 0x2b, 0x65, 0x2a, 0xc9, 0x06, 0x74, 0x1f, 0x64, 0xa9, 
  0xb4, 0xf3, 0xf6, 0x04, 0x8a, 0xbd, 0x96, 0x94, 0xa9, 0xb6, 0x1e, 0x15, 
  0x3f, 0xad, 0x04, 0xaf, 0x7a, 0x28, 0x9a, 0x98, 0x1c, 0x9a, 0xfd, 0x92, 
  0x42, 0x8b, 0x2e, 0x3b, 0x91, 0xf0, 0xc4, 0xb1, 0x28, 0x58, 0x92, 0xbe, 
  0x6a, 0x42, 0x22, 0x12, 0x8e, 0x4b, 0x8c, 0x64, 0x96, 0x01, 0xb2, 0x6f, 
  0x86, 0xfb, 0xab, 0x67, 0x44, 0x05, 0x1e, 0x64, 0x9c, 0x3e, 0x2a, 0x26, 
  0xb8, 0xd5, 0x57, 0x9a, 0xbc, 0x93, 0x22, 0x21, 0x22, 0xbb, 0xed, 0x2e, 
  0xe9, 0x8b, 0x48, 0x85, 0x77, 0xc9, 0x78, 0x59, 0xad, 0xad, 0x52, 0xad, 
  0x8b, 0x8b, 0x31, 0x6e, 0xe2, 0x70, 0x94, 0x16, 0x1c, 0xd9, 0x3b, 0xb3, 
  0x98, 0xce, 0x67, 0xbd, 0xad, 0x48, 0x84, 0x8b, 0x0e, 0x98, 0xea, 0x20, 
  0xf2, 0x93, 0xe9, 0xdf, 0x46, 0x6d, 0x58, 0x54, 0x7c, 0x06, 0x34, 0x75, 
  0xa8, 0xab, 0x7f, 0xda, 0xfb, 0xa2, 0xd1, 0x3d, 0x7a, 0xef, 0xbd, 0x12, 
  0x0f, 0x1e, 0xfa, 0x16, 0xb9, 0x86, 0xf8, 0x75, 0x2b, 0x5e, 0x82, 0x81, 
  0xb6, 0xcd, 0xd9, 0x57, 0x76, 0xf5, 0x9d, 0x4f, 0x25, 0xf6, 0x63, 0xdf, 
  0x3c, 0x3f, 0xcd, 0x43, 0x63, 0xef, 0xea, 0x06, 0x3d, 0x6b, 0x47, 0xa3, 
  0xdd, 0x7d, 0x1a, 0xf9, 0x82, 0x64, 0xcc, 0x97, 0xf1, 0x91, 0x46, 0x0d, 
  0x77, 0xe0, 0x1d, 0x01, 0xe5, 0x38, 0x8a, 0xbe, 0xe1, 0x1f, 0x86, 0xa8, 
  0xc0, 0xc1, 0x8b, 0x6b, 0x01, 0x97, 0x91, 0x5f, 0x25, 0x71, 0xa8, 0x17, 
  0xd8, 0xec, 0x57, 0xf8, 0xe5, 0x41, 0x90, 0x66, 0x9a, 0xea, 0xcf, 0x0c, 
  0x09, 0x60, 0x75, 0xc4, 0xf9, 0x80, 0x32, 0xfe, 0x41, 0xa1, 0x18, 0xf3, 
  0x12, 0x36, 0x63, 0x95, 0x1b, 0xa1, 0x4f, 0x76, 0xfb, 0x7a, 0xd9, 0x8c, 
  0x2f, 0x1c, 0xea, 0xc1, 0x31, 0x4a, 0xca, 0x63, 0x33, 0xc0, 0xda, 0x20, 
  0xf1, 0xd7, 0xbe, 0x56, 0x4b, 0x06, 0xef, 0x1e, 0x80, 0xcf, 0x15, 0xff, 
  0x05, 0xed, 0xbe, 0xe4, 0xab, 0x46, 0xaf, 0xe4, 0xb1, 0x06, 0x82, 0x96, 
  0x00, 0xbe, 0x14, 0x0a, 0x40, 0x32, 0x9b, 0x11, 0x32, 0x1e, 0x1e, 0x75, 
  0xf7, 0x2e, 0xa6, 0x3d, 0x2b, 0x16, 0x29, 0x95, 0xaa, 0xd9, 0x8b, 0x03, 
  0x56, 0x76, 0x6b, 0xea, 0xc6, 0x9c, 0xae, 0xd7, 0x56, 0x4a, 0xa5, 0x73, 
  0xbb, 0xea, 0xad, 0x27, 0x05, 0x25, 0x5f, 0xa9, 0x61, 0x6b, 0x38, 0x61, 
  0x20, 0x68, 0x36, 0x27, 0x89, 0x27, 0xf8, 0x37, 0x2d, 0x34, 0x87, 0x72, 
  0x95, 0x8d, 0x6f, 0x5e, 0x9e, 0x5c, 0x3c, 0x30, 0xb0, 0x60, 0x6a, 0x78, 
  0xba, 0xc8, 0x33, 0xf6, 0xaf, 0xe0, 0x9a, 0xa7, 0xad, 0xcd, 0x67, 0x77, 
  0x1d, 0x9c, 0xe7, 0xe2, 0xec, 0xe4, 0xf0, 0xab, 0x53, 0xfb, 0xf1, 0x2f, 
  0x2d, 0xef, 0x31, 0xe3, 0xe7, 0x74, 0x38, 0x33, 0x5a, 0x63, 0x73, 0x56, 
  0x10, 0x6f, 0x1c, 0x25, 0xca, 0x03, 0xfc, 0x8e, 0x10, 0xdd, 0xa0, 0xbb, 
  0x05, 0x31, 0x70, 0x84, 0xb0, 0x47, 0x7b, 0x5f, 0x7d, 0xd9, 0xbe, 0x1b, 
  0x5e, 0x9e, 0xf8, 0x3d, 0x12, 0x5e, 0xe8, 0x3a, 0x94, 0x2f, 0x87, 0x91, 
  0xab, 0xb3, 0xd4, 0x09, 0xc1, 0xe0, 0xc2, 0x6e, 0x38, 0x62, 0x13, 0xeb, 
  0x16, 0xca, 0x45, 0xf7, 0x74, 0x3f, 0xc0, 0xa9, 0xc3, 0x22, 0x15, 0xa9, 
  0xa5, 0xb8, 0x08, 0x3e, 0x6f, 0x91, 0x1a, 0xc2, 0xad, 0x22, 0x67, 0x2a, 
  0x32, 0x63, 0xb4, 0x44, 0x99, 0xc5, 0x02, 0x3b, 0x82, 0xa2, 0x72, 0x00, 
  0x1b, 0x5f, 0xb6, 0x4c, 0x96, 0x16, 0x1a, 0xe7, 0x6c, 0x8b, 0x12, 0xee, 
  0x24, 0xdd, 0x89, 0x0b, 0x48, 0x13, 0xed, 0x44, 0x90, 0x99, 0xb7, 0xdc, 
  0x1d, 0xae, 0xf6, 0x9d, 0xb8, 0x8a, 0x04, 0x63, 0x7a, 0x9e, 0xbe, 0x33, 
  0xb7, 0x68, 0xbd, 0xe4, 0x16, 0x9b, 0xb9, 0x3b, 0xdd, 0xcb, 0xd2, 0xaf, 
  0xf6, 0xa5, 0x21, 0x62, 0xde, 0x8a, 0x4d, 0xea, 0x6d, 0x4f, 0xbe, 0xeb, 
  0x0d, 0xa2, 0xee, 0xda, 0x28, 0x0a, 0x42, 0xac, 0xf5, 0x3b, 0x22, 0x09, 
  0x72, 0x1a, 0x2f, 0x59, 0x75, 0x15, 0x6b, 0x25, 0x32, 0x77, 0x55, 0xae, 
  0x6e, 0xc5, 0xee, 0xf7, 0xbe, 0x30, 0xf5, 0xb9, 0x17, 0x59, 0x74, 0xa3, 
  0x2b, 0xed, 0x18, 0xd4, 0x09, 0x11, 0x27, 0x19, 0x56, 0xa7, 0xab, 0x1c, 
  0xaa, 0x54, 0xad, 0x84, 0x90, 0x85, 0x54, 0xb6, 0xde, 0x17, 0xc3, 0x5e, 
  0xe7, 0xdd, 0x12, 0x24, 0x0d, 0x32, 0x23, 0x64, 0x09, 0xb3, 0x56, 0xe9, 
  0xc8, 0x76, 0xa0, 0x11, 0xd8, 0x60, 0x01, 0x19, 0xcb, 0x2b, 0x92, 0x91, 
  0xaa, 0xa5, 0x56, 0x0b, 0xe4, 0xd7, 0x80, 0xc3, 0x05, 0xb9, 0x9b, 0xd7, 
  0x5f, 0x36, 0x4b, 0x07, 0xcf, 0x02, 0x56, 0x0b, 0x24, 0x3c, 0xad, 0x06, 
  0x82, 0xcb, 0x61, 0xf5, 0xc9, 0x39, 0x16, 0x7b, 0x96, 0xdf, 0xa3, 0xb8, 
  0x41, 0x30, 0x3a, 0xb0, 0xfa, 0xb5, 0x46, 0x7f, 0x58, 0xe7, 0x7e, 0xfb, 
  0x77, 0x7b, 0xfc, 0x2d, 0x2f, 0xe0, 0x3f, 0x6c, 0x01, 0xad, 0x98, 0xbc, 
  0xc9, 0xbb, 0xbf, 0x6d, 0xc3, 0x3f, 0x45, 0x52, 0x54, 0x55, 0x16, 0x0b, 
  0xd1, 0x98, 0xd2, 0xe2, 0x6f, 0x47, 0xee, 0x56, 0xf3, 0xad, 0x24, 0xf7, 
  0xff, 0x6c, 0xdd, 0x34, 0x59, 0x50, 0xf4, 0xe2, 0x2f, 0xa4, 0x9c, 0x10, 
  0xc9, 0x73, 0x42, 0x3f, 0x3b, 0xca, 0x42, 0x5c, 0xb1, 0xbf, 0x14, 0x16, 
  0x7e, 0xd9, 0xc2, 0x29, 0xbc, 0x12, 0x20, 0x6f, 0x7d, 0xae, 0x5a, 0x83, 
  0x3a, 0x26, 0x9b, 0xf6, 0x5b, 0x0b, 0x91, 0x16, 0x07, 0x76, 0xe4, 0x6a, 
  0xe1, 0x69, 0x4d, 0x46, 0xdd, 0xc3, 0x96, 0x00, 0x9f, 0x3d, 0xda, 0x1b, 
  0x06, 0xce, 0x9e, 0x81, 0xea, 0x58, 0x2c, 0xa2, 0x84, 0xf9, 0xc1, 0x74, 
  0x3e, 0x7e, 0x2b, 0x98, 0xe1, 0xed, 0xc0, 0xba, 0x49, 0xbe, 0xe4, 0x68, 
  0x21, 0x51, 0x15, 0x5b, 0x85, 0xb3, 0xdb, 0x78, 0x3c, 0x2e, 0x9a, 0xa4, 
  0xbe, 0x95, 0x16, 0x19, 0x05, 0x57, 0x6c, 0x17, 0x1a, 0xf5, 0x5b, 0x41, 
  0x61, 0x80, 0xc4, 0x8d, 0x39, 0x43, 0xa7, 0x85, 0xbb, 0x82, 0x6d, 0x4c, 
  0x92, 0x5b, 0x0b, 0xd5, 0xb9, 0x33, 0x8f, 0x3e, 0x6a, 0x05, 0x00, 0xa8, 
  0xda, 0xcb, 0xca, 0x0b, 0x0d, 0xda, 0xe3, 0x41, 0x73, 0x51, 0x56, 0x54, 
  0xe1, 0x79, 0xb8, 0x05, 0xcb, 0x45, 0x93, 0x5c, 0x63, 0xe7, 0x65, 0x7b, 
  0xd6, 0xae, 0x32, 0x66, 0xa6, 0xa7, 0xaa, 0x5a, 0xbc, 0x05, 0x84, 0x9c, 
  0x3b, 0x6c, 0xc4, 0x7e, 0x92, 0x82, 0x53, 0x51, 0x05, 0x5a, 0xce, 0xcf, 
  0x26, 0x5f, 0x22, 0xf6, 0xfb, 0xe1, 0x11, 0x38, 0x53, 0x41, 0xa1, 0x61, 
  0x95, 0x82, 0xbc, 0xb6, 0x79, 0xb1, 0xa5, 0x45, 0x07, 0x3b, 0xdc, 0x0e, 
  0x6f, 0xab, 0xbc, 0x8a, 0x67, 0x5e, 0x92, 0xc4, 0x5f, 0xfc, 0xc5, 0x20, 
  0xc0, 0x5a, 0x1b, 0xac, 0x83, 0x62, 0x6c, 0x5e, 0x48, 0x2c, 0x92, 0x7b, 
  0xe7, 0x0f, 0x8f, 0xc5, 0xaa, 0x50, 0x22, 0x62, 0xa7, 0xc3, 0x8f, 0x14, 
  0xb5, 0xe9, 0x47, 0x6e, 0x06, 0xe3, 0xca, 0x73, 0x7a, 0x27, 0x55, 0x01, 
  0x1b, 0xd7, 0xf5, 0x3f, 0x1f, 0x6e, 0x61, 0xb6, 0xec, 0x24, 0x33, 0xcc, 
  0x95, 0x0f, 0x3d, 0xab, 0x7d, 0xcb, 0xc5, 0xc3, 0x6d, 0x5c, 0x5a, 0x84, 
  0x14, 0x4c, 0xa0, 0x7e, 0x15, 0x52, 0xbe, 0xba, 0xf2, 0x5b, 0x70, 0xd0, 
  0xf7, 0x6f, 0x85, 0x00, 0x0a, 0x2e, 0x49, 0x58, 0x98, 0x05, 0x60, 0x97, 
  0x2a, 0x72, 0xb4, 0x35, 0xcf, 0xc6, 0x7f, 0xbc, 0xed, 0xee, 0x52, 0xec, 
  0x9e, 0x8e, 0x65, 0xaf, 0x7c, 0xac, 0x01, 0xbb, 0xf6, 0xd5, 0xbb, 0xfd, 
  0x70, 0x0b, 0x16, 0x5e, 0x8f, 0x24, 0x90, 0x68, 0x93, 0x7d, 0x4c, 0x92, 
  0x07, 0xa7, 0xd0, 0x08, 0x1d, 0xa5, 0x13, 0x1a, 0xff, 0x3d, 0x34, 0x57, 
  0xae, 0x38, 0xdb, 0x1d, 0x7a, 0xdf, 0xb1, 0x77, 0x6d, 0xfa, 0x4d, 0x31, 
  0x0b, 0x5a, 0x89, 0x7f, 0x71, 0x29, 0xc4, 0x29, 0x6d, 0xc0, 0x89, 0xef, 
  0x63, 0x26, 0xb8, 0x2a, 0x34, 0xe4, 0x81, 0x43, 0x30, 0x49, 0xb0, 0x75, 
  0xa8, 0xf3, 0xa6, 0xc3, 0x3e, 0xdc, 0x42, 0xac, 0x75, 0x19, 0x87, 0xae, 
  0x4f, 0x1f, 0xc3, 0x4e, 0x07, 0x81, 0xb1, 0x8c, 0xde, 0xb3, 0x98, 0x2c, 
  0xae, 0x22, 0xbc, 0x00, 0x47, 0x17, 0x35, 0x77, 0x55, 0x4a, 0x19, 0x7f, 
  0xe0, 0x86, 0x06, 0x72, 0x89, 0xa9, 0xa7, 0x62, 0xe2, 0xbb, 0x63, 0x91, 
  0x79, 0xcd, 0x3e, 0x61, 0xe1, 0x3e, 0x7c, 0xa7, 0x3e, 0xc2, 0x29, 0xd3, 
  0x40, 0x64, 0x89, 0x26, 0xff, 0xa0, 0x9d, 0x32, 0x8b, 0x85, 0x26, 0x46, 
  0xd8, 0xe8, 0x93, 0xc9, 0x07, 0x5d, 0x1c, 0xce, 0x26, 0xd1, 0x20, 0x53, 
  0xbb, 0xc7, 0x67, 0x65, 0xfe, 0xfe, 0x59, 0x08, 0x7f, 0x0c, 0x42, 0x7f, 
  0xb9, 0x46, 0x84, 0x94, 0xf2, 0x88, 0x67, 0xed, 0x50, 0x96, 0x26, 0xcf, 
  0x8b, 0x2b, 0x43, 0x1a, 0x28, 0xb9, 0x28, 0xd6, 0x46, 0x0b, 0x96, 0xef, 
  0xe7, 0xe4, 0xad, 0xc5, 0xd4, 0x86, 0x8c, 0xde, 0xa7, 0x87, 0x48, 0xf0, 
  0xb4, 0x48, 0x63, 0x5c, 0x00, 0xe5, 0xe1, 0x0e, 0xad, 0xad, 0x0e, 0x2a, 
  0x40, 0x5f, 0xea, 0x8a, 0x75, 0x9b, 0xbc, 0xbe, 0xb3, 0xf7, 0xf7, 0x25, 
  0x6d, 0xad, 0xeb, 0xc9, 0xca, 0xca, 0x76, 0xcc, 0x0a, 0x36, 0x21, 0xe9, 
  0xca, 0xa2, 0x7f, 0x3f, 0x74, 0x56, 0x6b, 0xef, 0x6c, 0xf4, 0xe9, 0xb2, 
  0x5a, 0xff, 0x03, 0xb3, 0x0b, 0x05, 0x6a, 0x18, 0x10, 0xd6, 0x15, 0x3b, 
  0x46, 0x71, 0x00, 0xbf, 0x89, 0xdc, 0x73, 0xcc, 0x8e, 0x82, 0x20, 0x5a, 
  0x5a, 0xcb, 0x45, 0xa0, 0xe7, 0x0e, 0x63, 0x5b, 0xd4, 0x8c, 0x5a, 0xd5, 
  0x92, 0x12, 0x0e, 0x91, 0xc1, 0xae, 0x1b, 0x0f, 0xb6, 0xdb, 0x3d, 0x08, 
  0xb7, 0xbb, 0xe1, 0x20, 0xf4, 0x43, 0x19, 0x42, 0x20, 0xd6, 0x7f, 0xe0, 
  0x20, 0x5a, 0x63, 0x90, 0xf6, 0x5a, 0x23, 0x50, 0xb8, 0xfe, 0xb7, 0xa8, 
  0x0f, 0xa6, 0x1b, 0x50, 0xab, 0x65, 0xef, 0x02, 0xbd, 0x1d, 0x36, 0xf0, 
  0xfb, 0x36, 0xdd, 0x8a, 0xa9, 0xa6, 0x16, 0x52, 0x84, 0xeb, 0x8a, 0xb4, 
  0x41, 0xe2, 0xd9, 0xe2, 0x20, 0x7b, 0x1f, 0x07, 0x80, 0xf7, 0xec, 0xc9, 
  0xd6, 0xc7, 0x8b, 0x0b, 0x77, 0x11, 0x9f, 0xd1, 0x73, 0xfc, 0x78, 0x4f, 
  0x2c, 0xac, 0x57, 0x47, 0x2d, 0xad, 0xbc, 0x19, 0x05, 0x6b, 0x00, 0x38, 
  0x65, 0x18, 0xf9, 0xdf, 0xc8, 0x7b, 0x98, 0x68, 0x24, 0xa5, 0x8b, 0x7f, 
  0xad, 0x87, 0xbf, 0x7e, 0x68, 0x5c, 0x6b, 0xf2, 0x4e, 0x4b, 0x3e, 0x34, 
  0x83, 0xc8, 0xd6, 0x05, 0x6f, 0xc7, 0xec, 0xf6, 0xad, 0x4a, 0x4b, 0xa0, 
  0xd6, 0x40, 0x24, 0x0b, 0xf8, 0xea, 0x63, 0x6f, 0x22, 0xb4, 0xd6, 0x8a, 
  0xf0, 0x6b, 0x82, 0x86, 0x96, 0xae, 0xf2, 0xb6, 0xc6, 0xcb, 0x5a, 0xac, 
  0x08, 0x67, 0x87, 0xe0, 0xa3, 0x76, 0x66, 0x7c, 0x0f, 0x39, 0xa9, 0x36, 
  0x81, 0xae, 0xca, 0x5b, 0xde, 0x4f, 0x11, 0x87, 0xf2, 0x6e, 0x70, 0xd5, 
  0x6a, 0x5d, 0x46, 0x0e, 0x6b, 0x42, 0x4d, 0x81, 0xce, 0x9a, 0xef, 0x32, 
  0x3f, 0x09, 0xdd, 0xe2, 0x3b, 0x83, 0x53, 0x4b, 0x32, 0xd6, 0x40, 0x24, 
  0xc9, 0x8b, 0x5e, 0xac, 0x24, 0x69, 0x8b, 0x9f, 0xee, 0xf0, 0x3a, 0x8b, 
  0x97, 0x45, 0x4e, 0x3b, 0x3d, 0xcb, 0x36, 0x0d, 0xbb, 0xa7, 0x83, 0xab, 
  0xde, 0x0f, 0xaf, 0x19, 0xc1, 0x05, 0xb7, 0x88, 0xe6, 0x66, 0xba, 0x98, 
  0xfe, 0x3a, 0x3a, 0x21, 0x4e, 0x24, 0x83, 0xb6, 0xa4, 0xd3, 0x35, 0x20, 
  0x4b, 0x1d, 0x60, 0x04, 0xb6, 0xd6, 0xa2, 0xb4, 0x0b, 0xba, 0xd8, 0x1a, 
  0x88, 0xa4, 0x26, 0xda, 0xc2, 0xaf, 0x0e, 0x4d, 0xfc, 0x3d, 0xdc, 0x7e, 
  0xc2, 0xce, 0x9f, 0xab, 0x88, 0xb5, 0xa6, 0xbc, 0xfb, 0x85, 0x0b, 0x77, 
  0x72, 0x45, 0xd5, 0xed, 0xcd, 0xb0, 0xd8, 0x7b, 0x67, 0x89, 0xb0, 0x6e, 
  0x9c, 0x11, 0x71, 0x69, 0x59, 0xb2, 0x9a, 0x98, 0x95, 0xec, 0xec, 0x75, 
  0xd7, 0x9c, 0xa8, 0x4d, 0x23, 0x0c, 0x50, 0x93, 0x90, 0x47, 0x2b, 0x30, 
  0x12, 0x7d, 0x75, 0x78, 0xd9, 0x2e, 0x29, 0xee, 0xac, 0x42, 0xd2, 0x2f, 
  0x67, 0x00, 0x39, 0x3a, 0x31, 0x78, 0xf7, 0x20, 0x62, 0xb7, 0x15, 0x6e, 
  0xc7, 0x65, 0x48, 0xe3, 0x2c, 0xee, 0x2e, 0xd4, 0xad, 0x49, 0xb8, 0xed, 
  0x35, 0x0a, 0xf2, 0x2f, 0x6d, 0x9d, 0x74, 0xdc, 0xed, 0xea, 0x5f, 0xc7, 
  0x47, 0x17, 0x97, 0xb2, 0x8a, 0xa8, 0x8a, 0x2e, 0x52, 0x37, 0xa3, 0x1d, 
  0x94, 0x1e, 0xc4, 0xe0, 0x57, 0x23, 0x8d, 0x95, 0xab, 0x1b, 0x24, 0xf0, 
  0xe4, 0xfc, 0xef, 0xe7, 0xed, 0xce, 0x63, 0x7f, 0xfd, 0xb2, 0x35, 0x98, 
  0x61, 0xc6, 0xd4, 0x18, 0x1b, 0x96, 0xf3, 0x51, 0x31, 0x64, 0xd1, 0x92, 
  0x89, 0x4d, 0xb3, 0x9d, 0x2c, 0x05, 0xf1, 0x32, 0xb6, 0x32, 0x40, 0x52, 
  0x24, 0x94, 0x5e, 0x48, 0x73, 0x85, 0x78, 0xb2, 0x7e, 0xda, 0x26, 0xc5, 
  0xd2, 0xa7, 0xc8, 0xd2, 0x88, 0x82, 0xf7, 0x83, 0x82, 0x1a, 0xd8, 0x79, 
  0xcb, 0x79, 0xef, 0xb8, 0xd5, 0x75, 0xa0, 0xb6, 0x18, 0xbb, 0x56, 0xfb, 
  0x94, 0x39, 0xa5, 0x64, 0x8d, 0xac, 0xde, 0x57, 0x9d, 0x5d, 0x1c, 0xf3, 
  0xb5, 0x20, 0x5f, 0x71, 0xff, 0x2d, 0x4b, 0x97, 0x08, 0xde, 0xe4, 0xf9, 
  0x82, 0x52, 0xcf, 0xcb, 0x66, 0xea, 0x66, 0x29, 0x2e, 0x00, 0xbb, 0x43, 
  0x53, 0x29, 0xfc, 0x06, 0x90, 0xf9, 0x2e, 0x10, 0x19, 0x62, 0x4b, 0xb4, 
  0x3c, 0xc5, 0xca, 0x10, 0xc1, 0x14, 0xfa, 0xfc, 0xbf, 0x85, 0x75, 0xde, 
  0xac, 0x36, 0xd5, 0x5d, 0xc8, 0xec, 0x41, 0xba, 0xc1, 0xb8, 0xb4, 0x8e, 
  0x33, 0xde, 0x86, 0x7e, 0xd4, 0x34, 0xb4, 0x39, 0x82, 0x32, 0x1a, 0x1a, 
  0x88, 0x20, 0x17, 0xec, 0xbe, 0x21, 0xe5, 0xd3, 0x30, 0x98, 0x48, 0x5a, 
  0xd7, 0xad, 0x92, 0x4c, 0x9d, 0x5e, 0xfc, 0x7e, 0xff, 0x20, 0x69, 0x60, 
  0x9c, 0x5c, 0xc9, 0xfc, 0xbf, 0x43, 0x50, 0x48, 0xaa, 0x5f, 0x6f, 0x61, 
  0x7f, 0xe6, 0xc8, 0x7c, 0x7a, 0x79, 0x88, 0xf3, 0xf2, 0x7c, 0xc2, 0x2a, 
  0x0f, 0x71, 0x24, 0x75, 0xd5, 0xad, 0xe1, 0xd9, 0xe7, 0xca, 0x36, 0xad, 
  0xaa, 0x04, 0xdf, 0x95, 0x9c, 0xe2, 0x71, 0x95, 0xd0, 0xe2, 0x4a, 0x69, 
  0x70, 0x44, 0x9e, 0xc7, 0xed, 0x7c, 0x7c, 0xab, 0x7a, 0x60, 0xc1, 0x6c, 
  0x58, 0x1f, 0x5e, 0x10, 0xee, 0x79, 0x10, 0x69, 0x5e, 0x7b, 0xad, 0xc5, 
  0x56, 0x88, 0xb4, 0xb6, 0xaf, 0x69, 0xf5, 0x62, 0x43, 0x4b, 0xe7, 0x89, 
  0x4b, 0xd4, 0x0e, 0x67, 0x10, 0x75, 0xa7, 0x29, 0xb3, 0x84, 0x51, 0xc2, 
  0x57, 0x43, 0xfc, 0x11, 0xaf, 0x88, 0x77, 0x01, 0x25, 0xee, 0x25, 0x2b, 
  0xcb, 0xa2, 0x0f, 0xe6, 0x71, 0xbb, 0x72, 0x16, 0xfb, 0x34, 0xd4, 0xb5, 
  0xc3, 0x85, 0x74, 0x12, 0x55, 0xaf, 0xe1, 0xf2, 0x96, 0xa4, 0x4d, 0x49, 
  0x2c, 0xe0, 0xc9, 0xbd, 0xb7, 0xa0, 0xb8, 0x59, 0xb0, 0x94, 0x7f, 0xff, 
  0x06, 0x69, 0x21, 0x10, 0x11, 0xd8, 0x1c, 0x4b, 0x6d, 0xf1, 0xf8, 0x36, 
  0x1f, 0x6d, 0xb5, 0x0b, 0x64, 0x6a, 0x41, 0x20, 0xdc, 0x2f, 0x8d, 0x69, 
  0xeb, 0x7d, 0xd3, 0x76, 0xc0, 0x41, 0xaf, 0xaf, 0x3a, 0x16, 0x2a, 0x84, 
  0x41, 0xd8, 0x1c, 0x6e, 0x89, 0xde, 0xce, 0x11, 0x78, 0xcd, 0xe0, 0xdc, 
  0x2a, 0x00, 0x20, 0x42, 0xcc, 0xb3, 0xaf, 0x3d, 0xaf, 0x61, 0x26, 0xb4, 
  0x8a, 0xb3, 0x89, 0x3f, 0x77, 0x49, 0xe7, 0xdc, 0xb9, 0xff, 0x6d, 0xb1, 
  0x53, 0x18, 0xb6, 0x9a, 0x59, 0xd5, 0x5d, 0x73, 0x2e, 0x7a, 0xa6, 0x55, 
  0xf6, 0x21, 0x38, 0xd6, 0xa1, 0x60, 0xee, 0x1a, 0xfd, 0x15, 0x73, 0xb4, 
  0xb8, 0xd4, 0x06, 0xb2, 0x93, 0xca, 0xe8, 0x39, 0x29, 0x00, 0xad, 0xe8, 
  0xb0, 0xa4, 0x0a, 0x6a, 0xb3, 0xb8, 0x60, 0x2c, 0x28, 0x54, 0x3e, 0xab, 
  0x29, 0xcf, 0x86, 0x0e, 0x41, 0xb4, 0x23, 0x92, 0x81, 0x51, 0x36, 0x25, 
  0x4d, 0xab, 0x56, 0x17, 0x28, 0x04, 0x2b, 0xac, 0x01, 0x2c, 0xac, 0x29, 
  0xc7, 0x8a, 0x62, 0xd5, 0x28, 0xc6, 0x21, 0x76, 0x75, 0xd0, 0xa6, 0xeb, 
  0x37, 0x1c, 0x4d, 0xd9, 0x2e, 0x7e, 0x4e, 0xac, 0x8d, 0x94, 0xca, 0xc9, 
  0x72, 0xde, 0xfb, 0xf5, 0x16, 0x77, 0x87, 0x8b, 0x64, 0x55, 0xd5, 0x62, 
  0x77, 0xb4, 0xd3, 0xcd, 0x8a, 0x5e, 0x49, 0x0d, 0x3b, 0xf3, 0x12, 0xa4, 
  0xa4, 0x53, 0xb1, 0x72, 0x51, 0x1a, 0x89, 0x96, 0xea, 0x2b, 0xe1, 0xa7, 
  0x9b, 0x09, 0xeb, 0xa3, 0x9d, 0x50, 0xd6, 0x33, 0x50, 0xaf, 0xd2, 0x9d, 
  0x6c, 0x24, 0x90, 0x24, 0x74, 0xe1, 0xd2, 0xba, 0x3c, 0xeb, 0x6e, 0x61, 
  0x37, 0x18, 0xeb, 0x2e, 0xb3, 0xd2, 0x59, 0x79, 0xb7, 0xbb, 0x06, 0xa8, 
  0xa2, 0x31, 0x54, 0x16, 0xd9, 0x2e, 0x2f, 0x8e, 0x5d, 0xac, 0xcd, 0xae, 
  0x88, 0x68, 0x5d, 0x36, 0x48, 0x18, 0x1d, 0x1d, 0xc0, 0xbb, 0x99, 0x84, 
  0x2f, 0x8f, 0x2f, 0x4c, 0xca, 0xf5, 0x83, 0xd8, 0xe3, 0x8b, 0xb2, 0x9c, 
  0xdd, 0xed, 0x7d, 0xf8, 0x20, 0x2e, 0x82, 0x41, 0xec, 0xfd, 0xd2, 0x41, 
  0xf0, 0xcb, 0xad, 0x41, 0x3c, 0xd2, 0x41, 0x3c, 0xfa, 0xd7, 0x06, 0xf1, 
  0xe8, 0x3f, 0x32, 0x88, 0xc7, 0x1c, 0xab, 0xb6, 0xb8, 0x7b, 0xdc, 0x41, 
  0xaa, 0x2e, 0x7a, 0x09, 0xbe, 0x7b, 0x4e, 0x1f, 0x94, 0x0a, 0x15, 0xce, 
  0x87, 0x00, 0xc4, 0x1b, 0x85, 0x87, 0x6a, 0x39, 0x9b, 0x5d, 0x26, 0x04, 
  0x03, 0x39, 0xd9, 0xa0, 0xcb, 0xa0, 0xf4, 0x94, 0x32, 0x32, 0x2e, 0x90, 
  0xc6, 0xbf, 0x77, 0x64, 0x4d, 0x2e, 0xee, 0x3e, 0x1d, 0x6a, 0xbf, 0x5b, 
  0xf5, 0xb3, 0x2b, 0xe0, 0x5e, 0x36, 0x40, 0x64, 0x32, 0x21, 0x94, 0xa2, 
  0xc9, 0x00, 0x39, 0x5a, 0x80, 0xbf, 0x3e, 0x3a, 0xbb, 0x7b, 0x6c, 0x43, 
  0x4d, 0x24, 0x9a, 0xa3, 0x85, 0xf6, 0xfc, 0x59, 0x10, 0x80, 0xfc, 0xa9, 
  0xac, 0xca, 0xa7, 0xed, 0x55, 0xb1, 0x3e, 0x39, 0x7c, 0xa2, 0x6b, 0x49, 
  0x60, 0x1e, 0xb0, 0x45, 0x79, 0x68, 0x55, 0x3e, 0x70, 0x59, 0x3e, 0xf2, 
  0xaa, 0x7c, 0xfa, 0x4b, 0x56, 0xe5, 0x13, 0xd1, 0x97, 0x91, 0x97, 0x3e, 
  0xbc, 0x8a, 0x8b, 0x8e, 0x48, 0x54, 0x9f, 0xf9, 0x61, 0x31, 0x16, 0x41, 
  0x26, 0x7b, 0x3d, 0x50, 0xaf, 0x6c, 0x5f, 0xf7, 0xee, 0x51, 0x6a, 0xbc, 
  0xa9, 0x60, 0xda, 0xed, 0x47, 0x7a, 0x66, 0xc5, 0x36, 0x9d, 0xf1, 0xc7, 
  0xcc, 0x05, 0x57, 0x58, 0x43, 0x37, 0x18, 0xea, 0xea, 0xd5, 0xd1, 0xf1, 
  0xa1, 0x0b, 0xf4, 0xf9, 0x3f, 0x06, 0x34, 0xd5, 0x8e, 0x34, 0xc1, 0x20, 
  0xeb, 0x41, 0xc8, 0x87, 0x27, 0xdf, 0x1e, 0x9d, 0x9f, 0x9e, 0xbc, 0x3e, 
  0x3c, 0x71, 0xc9, 0x50, 0x70, 0xbf, 0x8a, 0x0d, 0xe6, 0x47, 0xb3, 0x9b, 
  0x3c, 0xdb, 0xde, 0xfe, 0x09, 0x89, 0xe6, 0x9f, 0xab, 0x75, 0xad, 0x7d, 
  0x45, 0x9a, 0x5d, 0xca, 0x43, 0x74, 0x58, 0x10, 0xb8, 0x98, 0x69, 0x36, 
  0x02, 0x13, 0xcf, 0xc5, 0xdb, 0xb3, 0xf3, 0xd3, 0xef, 0x7f, 0xf8, 0x0f, 
  0xb6, 0x7f, 0x51, 0x43, 0xcb, 0xf8, 0x8f, 0x36, 0xff, 0x2a, 0x1c, 0xfd, 
  0x57, 0xa7, 0x67, 0x5f, 0x1f, 0x9e, 0xff, 0x47, 0xdb, 0x97, 0x26, 0x9d, 
  0x59, 0x62, 0xff, 0xf8, 0xf8, 0x5f, 0x6a, 0xde, 0x30, 0x26, 0xad, 0x5c, 
  0xa7, 0xd9, 0x14, 0xa6, 0xc8, 0xdb, 0xd6, 0x96, 0x86, 0x66, 0xd7, 0xe8, 
  0x40, 0xb7, 0x5d, 0xa9, 0x96, 0xe3, 0x27, 0x7b, 0x72, 0xaa, 0x23, 0x11, 
  0x0b, 0xd0, 0xd0, 0x50, 0x5e, 0x26, 0x5a, 0x5b, 0x74, 0x2a, 0xf5, 0x08, 
  0x3f, 0x6f, 0xc5, 0x74, 0xf8, 0x2f, 0xed, 0x44, 0xc3, 0x78, 0x09, 0xf8, 
  0x15, 0x89, 0x07, 0x86, 0x9f, 0x4d, 0x4c, 0x63, 0x2c, 0x8b, 0x77, 0x0d, 
  0x47, 0x74, 0xf6, 0x44, 0x51, 0xa4, 0xd9, 0x65, 0x5e, 0xa4, 0xe5, 0x2d, 
  0x91, 0xec, 0xf7, 0x47, 0x97, 0xd1, 0xc1, 0xe9, 0x4b, 0x4f, 0xf2, 0x97, 
  0x12, 0xef, 0x0e, 0x83, 0xaa, 0xc8, 0x9f, 0x57, 0xcb, 0x8c, 0x93, 0x9d, 
  0xa7, 0x41, 0xd1, 0x4a, 0x81, 0x71, 0xe0, 0xf0, 0x01, 0xd3, 0xbe, 0x93, 
  0xd4, 0xb1, 0x09, 0x80, 0x62, 0x31, 0x64, 0x0c, 0x72, 0x7a, 0xe4, 0x51, 
  0x43, 0xaf, 0x30, 0x84, 0x98, 0x95, 0xa4, 0xc3, 0x72, 0x34, 0x92, 0x19, 
  0x25, 0xae, 0xbc, 0xd1, 0x81, 0x0f, 0x6f, 0xaa, 0x48, 0xa1, 0xd1, 0x7e, 
  0x88, 0x26, 0x22, 0x5c, 0x82, 0x61, 0x49, 0xa4, 0x14, 0xb9, 0x62, 0x7c, 
  0x59, 0x9d, 0x3c, 0xc7, 0x44, 0x6b, 0xe9, 0xce, 0xbb, 0x6a, 0xb4, 0xce, 
  0x5c, 0x18, 0x5d, 0x90, 0x39, 0x0d, 0xf3, 0x02, 0x07, 0x21, 0x4e, 0x7c, 
  0x7c, 0x6f, 0x04, 0x6d, 0xab, 0x9d, 0x13, 0x1b, 0x56, 0xa8, 0x91, 0xb8, 
  0x11, 0x6b, 0xc6, 0xf5, 0xb5, 0xa7, 0xe7, 0x86, 0xd4, 0x0d, 0x91, 0x30, 
  0xb5, 0x52, 0x68, 0xfa, 0x73, 0x20, 0x84, 0x3f, 0xf2, 0xa9, 0x81, 0xf3, 
  0x78, 0x66, 0x15, 0xb3, 0x60, 0x9a, 0x13, 0xc4, 0x99, 0xfb, 0x58, 0x4c, 
  0xa3, 0x8a, 0x2f, 0xe6, 0xdf, 0x7c, 0x1c, 0x24, 0x15, 0x22, 0x59, 0xc4, 
  0x37, 0x00, 0x35, 0x5b, 0x7c, 0x15, 0xfc, 0xcd, 0x30, 0x4c, 0x29, 0x6a, 
  0x27, 0x57, 0xbe, 0xaf, 0xa3, 0x27, 0xf2, 0xe3, 0xc0, 0xa8, 0x4c, 0xaf, 
  0x18, 0xa3, 0xa6, 0xcb, 0x3a, 0x08, 0xaf, 0xfa, 0xe3, 0xc7, 0x1d, 0x85, 
  0x20, 0x1c, 0x2e, 0x5f, 0xd9, 0x70, 0xe8, 0x7e, 0xda, 0xe8, 0xc1, 0x75, 
  0xa1, 0xe8, 0xd3, 0x41, 0x1f, 0x01, 0x5c, 0x2f, 0x8f, 0xb8, 0xa3, 0x87, 
  0x76, 0xf3, 0x7f, 0x6c, 0x6e, 0x44, 0x80, 0x09, 0x5a, 0xc7, 0xfd, 0xfd, 
  0xcc, 0xb1, 0xba, 0xe8, 0x3e, 0xe1, 0x18, 0x67, 0x3d, 0xf5, 0x40, 0x45, 
  0xd2, 0x6d, 0x91, 0x4f, 0xe0, 0x47, 0x93, 0x44, 0x87, 0x2e, 0xb7, 0xd3, 
  0xd8, 0xa6, 0x82, 0xc2, 0xcf, 0xbe, 0x83, 0xa7, 0xbe, 0x83, 0x18, 0xe8, 
  0x7b, 0x74, 0xc9, 0x65, 0xa9, 0x05, 0xad, 0x68, 0xdb, 0xf2, 0x91, 0xd4, 
  0xd0, 0xf2, 0xaf, 0xee, 0xee, 0xb8, 0x57, 0xb1, 0xab, 0xdb, 0x2e, 0x31, 
  0x08, 0x59, 0x76, 0xb2, 0x69, 0x51, 0x74, 0x98, 0x4a, 0x6d, 0x5d, 0x60, 
  0x10, 0x15, 0x5d, 0x55, 0x12, 0xd9, 0x49, 0x28, 0xb5, 0x21, 0xc7, 0x5c, 
  0x5d, 0xd6, 0x47, 0xca, 0x35, 0x25, 0xc5, 0xdd, 0xdd, 0xc6, 0x6a, 0x9c, 
  0xed, 0x5f, 0x5c, 0xd8, 0x5a, 0x20, 0x71, 0xbc, 0x3e, 0x4d, 0x75, 0x83, 
  0x2d, 0x5a, 0xe9, 0x26, 0x96, 0x55, 0x87, 0xf4, 0x6a, 0x69, 0xa3, 0xe1, 
  0x74, 0xdc, 0xdd, 0x6b, 0x74, 0xf5, 0xe6, 0xe2, 0xf0, 0xfc, 0xdf, 0xed, 
  0x4a, 0xdb, 0x68, 0x76, 0xf5, 0xa8, 0x3d, 0xab, 0x6f, 0xa5, 0xad, 0xc1, 
  0xbf, 0x33, 0xab, 0x6f, 0x3b, 0xba, 0x7a, 0xec, 0xb7, 0x4c, 0xfa, 0x8a, 
  0xf6, 0xf6, 0xfe, 0x18, 0xb9, 0xc2, 0x78, 0x8a, 0x09, 0xe0, 0xfa, 0xf3, 
  0x1d, 0x36, 0xba, 0xa2, 0xb7, 0x86, 0x08, 0xe9, 0xab, 0xea, 0x14, 0x18, 
  0x74, 0xf5, 0xc4, 0x75, 0x45, 0x5a, 0x6e, 0x1f, 0x16, 0x38, 0x3d, 0x3d, 
  0xad, 0x83, 0x8b, 0xb2, 0x87, 0x7c, 0x80, 0x8e, 0x78, 0x09, 0x5a, 0x09, 
  0x99, 0xce, 0x3f, 0x6c, 0xbd, 0x06, 0xbd, 0x7c, 0xea, 0x27, 0x24, 0xdd, 
  0x70, 0x9a, 0x8f, 0x9c, 0xa6, 0xa0, 0xa3, 0x06, 0xe6, 0x2e, 0xf7, 0xd5, 
  0xa2, 0xc1, 0xf7, 0x74, 0xf4, 0x47, 0x3f, 0x1d, 0x6b, 0x95, 0xef, 0xac, 
  0xab, 0x34, 0x8b, 0x8b, 0x55, 0xd0, 0x95, 0x15, 0x31, 0x5e, 0x07, 0x94, 
  0xa9, 0x30, 0xf4, 0x1c, 0x16, 0x23, 0xaf, 0xfa, 0x2e, 0x3e, 0x53, 0x5c, 
  0x0d, 0x40, 0xfe, 0x45, 0x9a, 0x36, 0x1a, 0xa1, 0x32, 0x82, 0x42, 0x01, 
  0x1a, 0xcf, 0x14, 0x68, 0xd1, 0x58, 0x03, 0xa6, 0x5b, 0xf1, 0x9e, 0x08, 
  0xdd, 0xf0, 0xed, 0x3e, 0x6d, 0x0f, 0xdd, 0x4c, 0xaf, 0xdb, 0x7a, 0xe8, 
  0x03, 0xd8, 0x77, 0x45, 0xc0, 0xea, 0xd8, 0xf4, 0xf3, 0xc3, 0xcb, 0x73, 
  0xc4, 0x35, 0x69, 0xa2, 0xe9, 0x96, 0xf3, 0x6b, 0x4c, 0xc1, 0xc9, 0x82, 
  0x9b, 0x26, 0x60, 0x0d, 0x12, 0x31, 0xaa, 0xa8, 0x46, 0x12, 0xa4, 0x60, 
  0x01, 0x22, 0x3c, 0x03, 0xc9, 0xb2, 0xe0, 0x33, 0x1f, 0xf3, 0xb9, 0xef, 
  0xc8, 0x3d, 0x69, 0x72, 0x81, 0x3d, 0xcf, 0x05, 0x04, 0x16, 0x55, 0x9b, 
  0xde, 0x8f, 0xf4, 0x6f, 0x37, 0x2c, 0x0d, 0x2c, 0x65, 0x0b, 0x67, 0x17, 
  0x2a, 0x14, 0x6c, 0x2a, 0x9d, 0x3d, 0xec, 0x79, 0x27, 0xa5, 0x40, 0xb9, 
  0x08, 0x1f, 0xd7, 0xa0, 0x42, 0x99, 0x85, 0x2f, 0xbd, 0x2b, 0x78, 0xdb, 
  0x5d, 0x9e, 0x64, 0x09, 0x5b, 0xcc, 0x0b, 0x3f, 0x10, 0x2b, 0xfa, 0x26, 
  0xa2, 0x87, 0x03, 0x8d, 0x47, 0x57, 0x5d, 0x63, 0x94, 0xf0, 0x48, 0x29, 
  0x97, 0x12, 0x3d, 0x66, 0xc8, 0x3d, 0xd8, 0xf1, 0xae, 0xf2, 0x3b, 0x57, 
  0xc2, 0x55, 0xa3, 0x67, 0xf1, 0x24, 0xeb, 0x4f, 0x4d, 0x9b, 0x14, 0x64, 
  0x99, 0x92, 0x05, 0xc4, 0xe1, 0x94, 0xb1, 0xb7, 0x69, 0xaf, 0x4c, 0x2f, 
  0x09, 0xa6, 0x2c, 0x4c, 0x48, 0xca, 0x7a, 0xe8, 0x82, 0xd6, 0x79, 0x8f, 
  0xec, 0xa3, 0x5c, 0x30, 0x28, 0xfc, 0xa8, 0x80, 0x25, 0x1d, 0xd8, 0x1c, 
  0x52, 0x9a, 0x35, 0xf2, 0x94, 0x12, 0xf4, 0xf3, 0x58, 0xf5, 0xb4, 0x99, 
  0xfa, 0x87, 0xf9, 0xe6, 0x40, 0x72, 0xb4, 0xd6, 0x7e, 0x24, 0x32, 0x98, 
  0xad, 0xbc, 0x9d, 0x30, 0x78, 0xf3, 0x49, 0x70, 0xd4, 0x6d, 0x50, 0x17, 
  0x97, 0xa7, 0xe7, 0x7a, 0x50, 0xda, 0xf7, 0x15, 0x2f, 0x2c, 0x3f, 0xb0, 
  0x0e, 0x60, 0x75, 0xe0, 0xeb, 0x95, 0x72, 0xab, 0x12, 0x70, 0x51, 0x2b, 
  0xde, 0xb5, 0xf7, 0xa9, 0x77, 0x1d, 0xea, 0xa2, 0x7c, 0x1b, 0x17, 0x40, 
  0xa7, 0xe2, 0x20, 0x73, 0xc0, 0xdd, 0x16, 0x39, 0x69, 0x6b, 0xf3, 0x40, 
  0x13, 0xdc, 0x13, 0x56, 0x71, 0x8a, 0x42, 0x24, 0x9a, 0xf4, 0xc1, 0xd4, 
  0x29, 0xbf, 0xc1, 0x46, 0xa8, 0x36, 0x41, 0x6f, 0x9c, 0xd5, 0xf3, 0x63, 
  0x2d, 0x08, 0x27, 0x38, 0x0d, 0xca, 0xf6, 0x8a, 0x37, 0xc7, 0x84, 0x28, 
  0x6f, 0x46, 0x85, 0x47, 0x80, 0xfd, 0x3c, 0xe2, 0x28, 0xdb, 0x68, 0xc7, 
  0x50, 0xa2, 0xba, 0x37, 0x53, 0xde, 0x98, 0xee, 0x64, 0x0c, 0xd9, 0x90, 
  0xc7, 0xbd, 0x24, 0xeb, 0xc7, 0xfe, 0xb4, 0x9b, 0xcd, 0x49, 0x2a, 0xb8, 
  0xeb, 0x5e, 0x55, 0x0f, 0x7f, 0xbc, 0x5a, 0x76, 0xcc, 0x65, 0x26, 0x05, 
  0x9e, 0xe5, 0xc6, 0xf4, 0xd2, 0x65, 0xc0, 0x18, 0x00, 0xdf, 0x6c, 0x53, 
  0x47, 0xc3, 0x35, 0xc4, 0x75, 0xfb, 0xe2, 0x04, 0x45, 0xa3, 0x67, 0x1d, 
  0x95, 0x95, 0x0d, 0xbe, 0x31, 0x44, 0x47, 0x0c, 0x9b, 0x10, 0xb7, 0x98, 
  0xba, 0x52, 0xdb, 0xf1, 0xe4, 0xc6, 0x85, 0xc4, 0x9c, 0x88, 0x0b, 0xd3, 
  0x0c, 0xfb, 0x7e, 0xbc, 0xbb, 0x1d, 0x44, 0x27, 0x69, 0xb5, 0xe7, 0x87, 
  0x17, 0x97, 0xba, 0x20, 0xfc, 0x6b, 0x8b, 0x17, 0x76, 0x25, 0xbb, 0x18, 
  0x86, 0x75, 0xe9, 0x29, 0x8f, 0x23, 0xd6, 0xf8, 0x1c, 0xbc, 0xaa, 0x57, 
  0x88, 0x76, 0x03, 0xd8, 0x6b, 0x6f, 0x08, 0xac, 0x70, 0x8c, 0xc3, 0x88, 
  0xce, 0xf9, 0xb7, 0xd6, 0xa2, 0xb5, 0x0b, 0x6a, 0x3a, 0x9e, 0x98, 0x5a, 
  0xfc, 0xc8, 0xbb, 0x2a, 0xc9, 0xac, 0xf4, 0x16, 0xd2, 0x19, 0x8a, 0xf4, 
  0x1a, 0xe0, 0x4a, 0x58, 0x5b, 0xa2, 0xb0, 0x26, 0xfb, 0x7f, 0x75, 0x10, 
  0x3d, 0x7d, 0xf2, 0x34, 0x18, 0xdb, 0x23, 0xcf, 0x26, 0x05, 0xb6, 0x32, 
  0x60, 0xf2, 0xf2, 0x41, 0x4f, 0xbb, 0xed, 0x91, 0x82, 0x26, 0x6b, 0xc7, 
  0x25, 0x0a, 0xdd, 0xe2, 0x3c, 0x7a, 0x1c, 0x32, 0x5a, 0xc8, 0xe9, 0xda, 
  0xc4, 0x91, 0xf9, 0x6c, 0xf8, 0x53, 0x17, 0xa1, 0x70, 0xcd, 0xa8, 0xff, 
  0x5d, 0x65, 0x32, 0x1b, 0x98, 0x79, 0x8f, 0x9e, 0xb8, 0x94, 0x38, 0xbb, 
  0xfa, 0x83, 0xa1, 0xf1, 0xc7, 0x9c, 0xdb, 0x5d, 0xde, 0x08, 0x62, 0x75, 
  0xf3, 0xf6, 0x7a, 0xe4, 0x85, 0x0a, 0xbe, 0x94, 0x9c, 0x9b, 0x52, 0xb6, 
  0xaa, 0x2e, 0x56, 0x90, 0xa2, 0xb7, 0x4c, 0x64, 0x3d, 0xe3, 0xa2, 0x9d, 
  0xf4, 0xc0, 0xa9, 0x3d, 0xe2, 0x66, 0xec, 0x88, 0x29, 0x7b, 0xa4, 0x32, 
  0xc5, 0xd1, 0xf1, 0x61, 0x48, 0x5d, 0x82, 0x86, 0x00, 0x9e, 0xe6, 0x35, 
  0x04, 0x62, 0x5a, 0xbe, 0x90, 0x71, 0x93, 0xb8, 0xce, 0x50, 0x8b, 0x18, 
  0x56, 0xbc, 0x3f, 0xfb, 0xd6, 0x85, 0x89, 0x1c, 0xbf, 0xdc, 0x87, 0x04, 
  0x06, 0x5d, 0x27, 0xcd, 0xb8, 0xd8, 0x16, 0x7f, 0x72, 0x85, 0x2a, 0x7a, 
  0x8e, 0xc1, 0xb4, 0x96, 0xe0, 0xa9, 0x7f, 0xb9, 0xa4, 0x99, 0x91, 0x92, 
  0xdd, 0x7c, 0xe4, 0xb1, 0x1c, 0xe5, 0x63, 0x2d, 0xff, 0xc6, 0xed, 0xe3, 
  0xba, 0x93, 0x35, 0xc6, 0x9b, 0x61, 0x71, 0x50, 0x80, 0x0b, 0xca, 0x03, 
  0xae, 0x05, 0x3d, 0x5c, 0xa4, 0xc3, 0x0b, 0x97, 0x0b, 0x9e, 0xe1, 0x3a, 
  0xc5, 0x5a, 0x21, 0x63, 0x22, 0x8d, 0x4d, 0xed, 0xb1, 0x6e, 0x2d, 0x4b, 
  0x9b, 0x76, 0x6d, 0xcb, 0xb9, 0xd9, 0xd7, 0xc5, 0xe7, 0x8c, 0x6b, 0x62, 
  0x22, 0x57, 0xf1, 0xf8, 0x96, 0x58, 0x71, 0xc6, 0x97, 0xe2, 0xcc, 0xd5, 
  0xc6, 0xe1, 0xd4, 0x06, 0x5f, 0x09, 0xa6, 0xcb, 0x4b, 0x2c, 0xe7, 0xc3, 
  0x25, 0x5e, 0xf9, 0x5e, 0xe4, 0x04, 0x38, 0x62, 0x35, 0x2a, 0x63, 0x59, 
  0x24, 0x1c, 0x2f, 0x3a, 0x77, 0x69, 0x56, 0xa1, 0x39, 0xc1, 0x87, 0x1a, 
  0x0b, 0xd4, 0x7c, 0xd0, 0xf6, 0xe3, 0x7a, 0xdb, 0x4e, 0xca, 0x71, 0x0d, 
  0x6b, 0x58, 0xb9, 0x34, 0x8d, 0x84, 0xf0, 0x38, 0xea, 0x68, 0x9b, 0xb8, 
  0x7e, 0xad, 0xdd, 0x27, 0xbe, 0xdd, 0x29, 0xd0, 0xd8, 0x83, 0x41, 0x07, 
  0x68, 0x64, 0x74, 0xa9, 0x08, 0x16, 0xca, 0xba, 0xf2, 0x0e, 0xe3, 0xb0, 
  0xec, 0x62, 0x5d, 0x9a, 0x78, 0x2c, 0x27, 0xe8, 0xcb, 0x38, 0x40, 0x8b, 
  0xe0, 0xfa, 0x88, 0x08, 0x29, 0xa6, 0xe5, 0x57, 0xa8, 0x4d, 0x8c, 0x9f, 
  0x6b, 0x57, 0xc6, 0x98, 0x41, 0x47, 0x15, 0x0f, 0x81, 0x0a, 0xd7, 0x16, 
  0xf8, 0x71, 0x6b, 0xc5, 0x77, 0x25, 0x87, 0xe8, 0x32, 0x87, 0x0f, 0x34, 
  0x5b, 0x39, 0xd7, 0x58, 0x39, 0x12, 0xd8, 0xcf, 0xb6, 0xd3, 0x4c, 0xeb, 
  0xa2, 0x36, 0xb3, 0x51, 0xd2, 0x4a, 0x0b, 0x24, 0x88, 0x03, 0x50, 0xe2, 
  0x59, 0x83, 0x8e, 0x3e, 0x53, 0x4b, 0x8d, 0x5c, 0x6c, 0x97, 0x87, 0xc7, 
  0x27, 0x87, 0x97, 0x66, 0xe7, 0xed, 0x90, 0x57, 0x1e, 0x3f, 0x6d, 0x48, 
  0x3a, 0x8a, 0x8c, 0xd7, 0x0c, 0xc8, 0x78, 0xb2, 0xeb, 0x82, 0xc1, 0xad, 
  0x98, 0x4b, 0x82, 0x4a, 0xed, 0xe0, 0x5e, 0x09, 0x29, 0x03, 0x08, 0x4f, 
  0x82, 0xbc, 0xcf, 0xfc, 0x21, 0xbf, 0xf5, 0xaf, 0xee, 0x05, 0x19, 0xd8, 
  0x22, 0xf9, 0xa4, 0xaa, 0x58, 0x2d, 0xa0, 0x34, 0x64, 0x2b, 0x4e, 0x29, 
  0xbb, 0x06, 0x24, 0x17, 0x4c, 0xfb, 0x62, 0x40, 0x6b, 0x19, 0xf4, 0x43, 
  0x48, 0xf5, 0xac, 0xc9, 0x4c, 0x9f, 0x3c, 0xf2, 0xcc, 0xb4, 0x58, 0x2d, 
  0x50, 0x73, 0x12, 0xa0, 0xe9, 0xee, 0xd8, 0xf9, 0x47, 0x85, 0x66, 0x0f, 
  0x84, 0xdd, 0xb0, 0xe0, 0xd0, 0x7e, 0x2b, 0x6e, 0x57, 0x9e, 0x78, 0xf2, 
  0x24, 0xb4, 0x87, 0x30, 0xb6, 0x3d, 0x6f, 0x17, 0x2d, 0x16, 0xea, 0xd9, 
  0xb2, 0xc8, 0xe9, 0x1f, 0xfd, 0xd4, 0x3d, 0xba, 0x44, 0x31, 0x64, 0x85, 
  0x75, 0x58, 0xff, 0x82, 0xd0, 0xc7, 0xc5, 0x4d, 0x2c, 0x60, 0x72, 0xa9, 
  0x64, 0x5f, 0x6f, 0xa6, 0xb5, 0x73, 0xe5, 0x3d, 0x0c, 0x4f, 0x54, 0x0b, 
  0x13, 0xb1, 0xce, 0x4b, 0xe8, 0x02, 0x8b, 0x17, 0xec, 0x87, 0x7f, 0xe3, 
  0x69, 0xdd, 0x58, 0xb4, 0xac, 0x05, 0xa0, 0x62, 0x01, 0xd2, 0xc5, 0x4d, 
  0x50, 0x2c, 0xe4, 0xd3, 0x9d, 0xee, 0x2e, 0x0e, 0xf6, 0xd1, 0x7e, 0xb4, 
  0xc9, 0xe0, 0xf8, 0x7f, 0xd6, 0x0a, 0xf3, 0xcc, 0xd5, 0xff, 0xec, 0x87, 
  0xf7, 0xe9, 0xae, 0x52, 0x21, 0xab, 0xb9, 0xd7, 0x59, 0xfa, 0x33, 0x13, 
  0x96, 0x49, 0x32, 0x5c, 0xd8, 0x94, 0x97, 0xce, 0x3f, 0xbd, 0xa7, 0x67, 
  0xfd, 0x2e, 0x9e, 0xa5, 0xca, 0x47, 0xd9, 0xde, 0xe6, 0xbe, 0x7f, 0xa4, 
  0x34, 0x2a, 0x24, 0x0f, 0xb5, 0x92, 0x23, 0xbc, 0x19, 0x41, 0x35, 0x49, 
  0x38, 0xf0, 0xd7, 0x9e, 0xfc, 0xfe, 0xfb, 0xd0, 0x02, 0xeb, 0x41, 0x03, 
  0xe3, 0x22, 0x48, 0x77, 0x56, 0xab, 0xab, 0xe0, 0xf6, 0xd1, 0xc9, 0x5b, 
  0x56, 0x6d, 0x04, 0xe6, 0x22, 0x99, 0x25, 0x8c, 0xa6, 0x21, 0xd7, 0x84, 
  0x8b, 0x8d, 0x45, 0x6c, 0x86, 0x14, 0xbe, 0xd4, 0xba, 0xdb, 0x50, 0x32, 
  0xb2, 0xa4, 0x5d, 0x62, 0x41, 0x14, 0x6c, 0xa2, 0xcf, 0xfd, 0x37, 0x97, 
  0x5f, 0x9f, 0x9e, 0x5f, 0x44, 0xdb, 0x5c, 0x6f, 0xe9, 0xf2, 0xfc, 0xe8, 
  0xcb, 0x37, 0x24, 0xec, 0x3b, 0x63, 0xf1, 0xcb, 0x98, 0x94, 0x80, 0x19, 
  0xc7, 0x51, 0x24, 0xd9, 0x55, 0x52, 0x5c, 0x1b, 0xd2, 0x1f, 0x72, 0x78, 
  0x39, 0x8b, 0x39, 0x2f, 0xac, 0x84, 0xba, 0x21, 0x72, 0xab, 0x41, 0x7b, 
  0x23, 0x04, 0x5a, 0x49, 0xe9, 0x91, 0xbc, 0x40, 0x18, 0x96, 0x25, 0xa1, 
  0xa9, 0xce, 0xa8, 0x48, 0xe8, 0x97, 0x5f, 0xef, 0x9f, 0x7c, 0x73, 0x61, 
  0x7e, 0x96, 0xef, 0xbe, 0xfb, 0x2e, 0xf4, 0xaf, 0x3c, 0xdb, 0xde, 0x06, 
  0xd2, 0xc7, 0x4d, 0xfc, 0xee, 0xdd, 0xa8, 0x24, 0x9a, 0x09, 0x6a, 0x6f, 
  0x78, 0xfc, 0xb1, 0x72, 0x49, 0xa4, 0x4b, 0x5f, 0x6f, 0x2f, 0x96, 0x57, 
  0x0c, 0x82, 0xb6, 0xbd, 0xac, 0x14, 0x25, 0x15, 0x6f, 0x6f, 0x6f, 0x6c, 
  0x5c, 0x1c, 0x1e, 0x46, 0xfb, 0xc7, 0x17, 0xa7, 0xc1, 0xbb, 0x9b, 0xbb, 
  0x5b, 0x83, 0xe8, 0xfe, 0x3a, 0xa9, 0xf0, 0x4b, 0x99, 0xc5, 0xc5, 0x74, 
  0x93, 0xd1, 0x76, 0x8f, 0xf7, 0x2f, 0x59, 0x1c, 0xfd, 0xf6, 0xf0, 0xfc, 
  0xe2, 0xe8, 0xf4, 0x84, 0x37, 0x90, 0xf3, 0x33, 0xe3, 0x19, 0xc3, 0xfa, 
  0xd3, 0x28, 0x91, 0x3c, 0x73, 0x6f, 0x80, 0xa4, 0x9c, 0x8d, 0x4c, 0xac, 
  0x46, 0x18, 0xbd, 0x94, 0x42, 0xbc, 0xe7, 0x64, 0xda, 0xd8, 0xe0, 0xf6, 
  0x2b, 0x16, 0xbb, 0xcc, 0x45, 0xb8, 0x11, 0xe8, 0xcc, 0x02, 0xbb, 0x98, 
  0x5c, 0x49, 0x64, 0xcb, 0x40, 0xd2, 0xfd, 0x10, 0x23, 0x1d, 0xe4, 0x2a, 
  0x76, 0x2e, 0xc1, 0xc5, 0xd1, 0xeb, 0x33, 0x92, 0x78, 0xde, 0x5c, 0xec, 
  0x7f, 0x75, 0xc8, 0x8f, 0x7e, 0x95, 0x54, 0x7e, 0x63, 0x04, 0x38, 0x95, 
  0x3b, 0xa1, 0x25, 0x29, 0xc7, 0xf1, 0x82, 0xe3, 0x9d, 0xa9, 0x9b, 0xa1, 
  0x30, 0xb8, 0xa0, 0xed, 0xb0, 0x54, 0x27, 0x03, 0xc7, 0xd9, 0xf3, 0x00, 
  0x6c, 0x0b, 0xdb, 0x3d, 0x3f, 0xdc, 0x7f, 0xf9, 0xfa, 0xd0, 0x02, 0xa0, 
  0x70, 0x55, 0x31, 0x7b, 0xbd, 0xc9, 0x01, 0xa1, 0x6d, 0x58, 0x94, 0x71, 
  0xc5, 0x17, 0x6b, 0xc2, 0xab, 0xc1, 0x15, 0x6a, 0xba, 0xbb, 0xf3, 0x5b, 
  0x86, 0x67, 0x47, 0xd3, 0x74, 0x5b, 0x5a, 0xb7, 0xfe, 0x62, 0xb7, 0x24, 
  0x56, 0x9a, 0x41, 0x19, 0xb3, 0x28, 0x19, 0x50, 0x53, 0x3e, 0xdb, 0xd9, 
  0xd9, 0x79, 0x60, 0x1e, 0xb0, 0xcb, 0xa9, 0x45, 0x82, 0xa6, 0xf2, 0x8c, 
  0x1f, 0xdf, 0xf6, 0xed, 0x9b, 0xd3, 0x25, 0x0e, 0xc6, 0xce, 0x7f, 0x66, 
  0x22, 0xb6, 0x93, 0x8e, 0xde, 0x3d, 0xe8, 0x71, 0x9e, 0xbb, 0x3d, 0x08, 
  0x9a, 0xbb, 0xce, 0x99, 0x35, 0xf9, 0x38, 0x1e, 0x89, 0x33, 0xd1, 0x85, 
  0xd0, 0x2f, 0xbb, 0xd7, 0x42, 0xbe, 0xa4, 0x96, 0xe5, 0x17, 0xb7, 0x22, 
  0xe1, 0xd2, 0xa3, 0xc8, 0x08, 0x74, 0x4c, 0x40, 0x49, 0xb8, 0x40, 0x16, 
  0x1e, 0x3c, 0x64, 0x18, 0x92, 0x0e, 0x9b, 0xed, 0xf2, 0x37, 0xd4, 0x2a, 
  0xff, 0x18, 0xe5, 0xc5, 0xf5, 0xf6, 0xfc, 0x19, 0x2e, 0x6b, 0x7a, 0xe8, 
  0x15, 0xea, 0xdf, 0x72, 0x21, 0x02, 0x57, 0xfa, 0x96, 0xb7, 0x8d, 0x43, 
  0x23, 0x3f, 0x60, 0xce, 0x1f, 0xb0, 0xc6, 0x2f, 0x4f, 0xbf, 0x3b, 0x39, 
  0x3e, 0xdd, 0x7f, 0x19, 0x5d, 0x9e, 0x92, 0x30, 0xc4, 0x72, 0x79, 0xc7, 
  0xbe, 0x22, 0x3d, 0xbf, 0xca, 0x85, 0xc5, 0x85, 0x55, 0x4f, 0x9b, 0x63, 
  0x18, 0x4a, 0xb1, 0x00, 0x64, 0x9e, 0xde, 0x54, 0xf3, 0xf7, 0x13, 0xeb, 
  0x87, 0x74, 0x32, 0xf0, 0x98, 0xf3, 0x01, 0x50, 0xab, 0x85, 0xb1, 0x69, 
  0xe9, 0xa9, 0x3a, 0xa2, 0xbd, 0xdb, 0xdb, 0x4d, 0xf1, 0x11, 0x7a, 0x40, 
  0x50, 0xc1, 0x8b, 0x2d, 0xeb, 0xa5, 0x40, 0x1c, 0x9e, 0xa3, 0x82, 0x15, 
  0x83, 0xd7, 0xb3, 0xf0, 0xbf, 0xd5, 0x9a, 0xe0, 0xe9, 0xda, 0x29, 0x11, 
  0x9b, 0x49, 0xde, 0x61, 0xd6, 0xf5, 0x8d, 0x13, 0xc4, 0x06, 0x3f, 0x3b, 
  0x5f, 0xd6, 0x47, 0x0a, 0x7f, 0xeb, 0x90, 0xe1, 0x4c, 0xec, 0xe8, 0x8e, 
  0xfb, 0xb1, 0xfd, 0xf4, 0x5d, 0xf0, 0x37, 0x21, 0x8b, 0xd9, 0x76, 0xaa, 
  0x96, 0x0c, 0xe0, 0xcd, 0xc5, 0xd1, 0xc9, 0x57, 0xb0, 0xf3, 0x7f, 0x77, 
  0x7a, 0xfe, 0xf2, 0x82, 0x9a, 0x65, 0x2e, 0xbc, 0x01, 0xa9, 0x11, 0xb8, 
  0x2a, 0x32, 0x2a, 0x39, 0xa2, 0xdc, 0xf5, 0x1f, 0x20, 0x72, 0x72, 0xfa, 
  0x87, 0x22, 0x28, 0x61, 0x98, 0x7e, 0x6d, 0x9a, 0xd5, 0x83, 0x03, 0x92, 
  0xe3, 0xd7, 0x05, 0x4b, 0x6d, 0xf2, 0x85, 0x96, 0xda, 0xd2, 0x4a, 0x5f, 
  0xf0, 0xe8, 0x6e, 0x73, 0x86, 0xf0, 0x36, 0xdf, 0xef, 0xdb, 0x55, 0xbe, 
  0x0d, 0x6c, 0x8c, 0x0d, 0x88, 0xe8, 0x0e, 0xef, 0xa0, 0xb6, 0x22, 0xd1, 
  0x70, 0x19, 0x4d, 0x67, 0xf1, 0x35, 0x3a, 0x6c, 0x2e, 0xc7, 0x32, 0x0a, 
  0x3a, 0xd3, 0xee, 0x3f, 0xb4, 0x4b, 0xc6, 0x86, 0x41, 0x7b, 0x52, 0xf3, 
  0x1d, 0x59, 0x80, 0xc8, 0xe7, 0x57, 0x63, 0x98, 0xdc, 0x8c, 0x2b, 0x2d, 
  0xa8, 0x04, 0xac, 0xd2, 0x26, 0xe0, 0x99, 0x16, 0xb2, 0xda, 0x10, 0xd1, 
  0xd0, 0x39, 0x9c, 0x1d, 0xaa, 0x33, 0xb7, 0x14, 0x88, 0x4b, 0x12, 0xd5, 
  0x4c, 0x7d, 0x22, 0x3a, 0x6b, 0x43, 0xc5, 0x56, 0x68, 0xfe, 0xbc, 0xa2, 
  0x16, 0xc3, 0x69, 0xb6, 0x9c, 0x36, 0xda, 0x5c, 0xb0, 0xfc, 0x12, 0x01, 
  0x2a, 0x06, 0xca, 0x8d, 0x48, 0xe0, 0xa7, 0x02, 0x2b, 0x10, 0xe7, 0xa0, 
  0x64, 0x2b, 0xba, 0xef, 0x24, 0x8a, 0x0e, 0xa0, 0x5b, 0x1c, 0x01, 0xcb, 
  0x6c, 0x1d, 0x68, 0xa6, 0x4e, 0xa3, 0xf1, 0xe1, 0xd9, 0x9a, 0x17, 0xc3, 
  0xad, 0x71, 0xfd, 0x34, 0x0b, 0x98, 0xed, 0xda, 0x68, 0xa5, 0xf9, 0xf5, 
  0x3b, 0xfd, 0xfe, 0x4d, 0x6e, 0xcf, 0xce, 0xc4, 0x89, 0xd9, 0x4a, 0xf6, 
  0x21, 0xcd, 0x1e, 0xde, 0x6e, 0x1d, 0xc4, 0x07, 0x75, 0x8c, 0x45, 0x06, 
  0x84, 0x91, 0x16, 0x3a, 0xf6, 0xce, 0x72, 0xf1, 0x46, 0x20, 0xb6, 0xb6, 
  0x51, 0xf0, 0x94, 0x47, 0x57, 0x03, 0x67, 0xd9, 0x80, 0x87, 0x09, 0x51, 
  0x82, 0xcf, 0xa4, 0x70, 0xed, 0x40, 0xeb, 0xad, 0x0e, 0x14, 0xd0, 0x87, 
  0xde, 0x70, 0x38, 0x31, 0xa4, 0x7c, 0x11, 0x0d, 0x23, 0x01, 0x98, 0xe4, 
  0x09, 0x04, 0x82, 0x41, 0x03, 0x71, 0xee, 0x8f, 0x0d, 0x49, 0xf2, 0x1a, 
  0x28, 0xd3, 0x17, 0x8d, 0x00, 0x21, 0x41, 0x68, 0xdb, 0xa3, 0x4a, 0x80, 
  0xf8, 0xe2, 0xf2, 0xd6, 0x05, 0xa1, 0x61, 0x7f, 0x20, 0x30, 0xe4, 0xa8, 
  0x84, 0x35, 0x56, 0x21, 0x13, 0x12, 0x64, 0xbe, 0x74, 0x4e, 0x12, 0xfc, 
  0xed, 0xea, 0xd4, 0x1b, 0x06, 0x23, 0x5c, 0x8c, 0xa5, 0x4b, 0xb7, 0x13, 
  0x9f, 0x07, 0xf8, 0x5d, 0x58, 0x49, 0x6e, 0x38, 0xa4, 0x75, 0xe2, 0x15, 
  0x11, 0x35, 0x88, 0x91, 0x25, 0x7e, 0x13, 0x5d, 0xa4, 0x8c, 0x9f, 0x6e, 
  0x24, 0xcb, 0x65, 0x63, 0x1e, 0xa4, 0x58, 0x97, 0x6c, 0xa5, 0x3a, 0x81, 
  0x15, 0x13, 0x11, 0x1a, 0x0c, 0xd0, 0x21, 0x60, 0x67, 0xbf, 0x4b, 0x63, 
  0xcb, 0xd2, 0x92, 0xb9, 0xbf, 0x65, 0x74, 0x89, 0xb7, 0xae, 0x08, 0x1e, 
  0xed, 0xbf, 0xbc, 0x08, 0x60, 0x07, 0x50, 0xbd, 0x04, 0x27, 0x94, 0x4b, 
  0x5a, 0xd6, 0x71, 0x5a, 0x10, 0x93, 0xe7, 0xfc, 0x97, 0xb1, 0x60, 0xd3, 
  0x20, 0x56, 0x06, 0x63, 0x67, 0x35, 0x23, 0xbe, 0x62, 0x5c, 0x07, 0x5e, 
  0x2e, 0xb6, 0xc7, 0x01, 0xe5, 0xd3, 0x57, 0xc3, 0xb0, 0x3a, 0xd4, 0xe1, 
  0x61, 0x45, 0x61, 0x05, 0xe4, 0xbb, 0x00, 0x8d, 0x53, 0xf0, 0x46, 0xa8, 
  0x39, 0x89, 0x61, 0x41, 0xbb, 0x18, 0xb5, 0x03, 0xbe, 0xe2, 0xd8, 0x13, 
  0x47, 0xcb, 0x41, 0x28, 0x82, 0x0a, 0x07, 0x1b, 0x1b, 0x08, 0x30, 0xe1, 
  0x16, 0xf8, 0xa2, 0xcb, 0x1c, 0xdb, 0x75, 0x75, 0x04, 0xc4, 0x57, 0x2f, 
  0x85, 0xc3, 0xe7, 0x2b, 0x4d, 0xf6, 0xc3, 0xee, 0x01, 0xb9, 0x48, 0x24, 
  0xa7, 0xcf, 0x3e, 0x6b, 0x5d, 0x0a, 0xef, 0xdc, 0xd3, 0xcf, 0xe8, 0xeb, 
  0x40, 0x42, 0x9b, 0xb1, 0xdd, 0xdb, 0x10, 0x83, 0xbd, 0x98, 0x26, 0x17, 
  0x2d, 0xba, 0x0e, 0x8a, 0x67, 0xb9, 0x70, 0x1d, 0xee, 0xd0, 0x55, 0x66, 
  0xed, 0xd8, 0x52, 0x07, 0x95, 0xbc, 0x21, 0x58, 0xc9, 0x0a, 0x7c, 0x59, 
  0x8a, 0x4b, 0xe6, 0x59, 0xfb, 0xd0, 0x7a, 0x70, 0xcd, 0x49, 0x6b, 0xb0, 
  0xc1, 0xed, 0xc9, 0x55, 0xd0, 0xf9, 0xc2, 0x65, 0x61, 0xe0, 0x22, 0xd7, 
  0x86, 0x39, 0x48, 0x5d, 0x07, 0xe3, 0xf0, 0x4b, 0x1a, 0xc5, 0xa2, 0x1d, 
  0xa4, 0xa5, 0xc3, 0x56, 0x19, 0xbe, 0x59, 0x3f, 0x9c, 0x37, 0xff, 0xd2, 
  0x70, 0xc2, 0xc2, 0x67, 0x5d, 0x40, 0xf8, 0x5a, 0xef, 0xa5, 0xc6, 0x80, 
  0xc1, 0x6e, 0x48, 0x90, 0x2c, 0xe0, 0xed, 0xd2, 0x4c, 0x43, 0x4d, 0x90, 
  0x21, 0x6a, 0x38, 0xdf, 0x3f, 0xf9, 0xea, 0x10, 0xf4, 0xc9, 0x6c, 0x42, 
  0xb6, 0x80, 0xf3, 0xb1, 0x38, 0xab, 0x43, 0x8a, 0xa7, 0x95, 0x12, 0x16, 
  0x90, 0xf2, 0x1b, 0x93, 0xe5, 0x98, 0x0d, 0x47, 0x6f, 0x1c, 0x96, 0x0a, 
  0xd0, 0x63, 0x50, 0x38, 0x15, 0x2c, 0x42, 0xcd, 0xc3, 0x1b, 0x91, 0x85, 
  0xf4, 0x83, 0xc2, 0x35, 0xe0, 0x00, 0xea, 0x69, 0xb9, 0xbc, 0x5a, 0xc4, 
  0x9a, 0x44, 0x10, 0x87, 0x51, 0xe8, 0x56, 0x83, 0xa9, 0x36, 0x05, 0xe6, 
  0x75, 0x5a, 0x60, 0xc8, 0xee, 0xe1, 0x02, 0xf7, 0xf0, 0x28, 0x14, 0x6e, 
  0x25, 0xcf, 0x7e, 0xd7, 0x15, 0xde, 0x12, 0xa1, 0x5c, 0x1b, 0x6c, 0x2d, 
  0x7d, 0x11, 0x71, 0x25, 0xb4, 0x75, 0x6b, 0xec, 0x1a, 0xad, 0x17, 0x38, 
  0x7b, 0x6f, 0x9b, 0xa8, 0x93, 0xb6, 0xae, 0x4d, 0x4c, 0x09, 0x3b, 0xe7, 
  0xf0, 0xae, 0xb4, 0x78, 0x94, 0xae, 0xb0, 0x79, 0xbe, 0x54, 0x2a, 0x13, 
  0xdd, 0x0f, 0x8a, 0x79, 0xe6, 0x12, 0x45, 0xd5, 0xa3, 0x68, 0x37, 0x97, 
  0xa0, 0x0d, 0xa8, 0x00, 0xb7, 0x60, 0xeb, 0x7c, 0xea, 0xcc, 0x59, 0x1f, 
  0xb4, 0x30, 0x4a, 0xa5, 0xd4, 0xed, 0xba, 0x25, 0x9a, 0xb6, 0x67, 0xa3, 
  0x2a, 0x5c, 0x44, 0xb2, 0xdc, 0x19, 0x0b, 0xe8, 0x24, 0xcf, 0x79, 0x29, 
  0xee, 0x8d, 0x82, 0xae, 0x93, 0x98, 0x0a, 0xef, 0x24, 0x9b, 0xe3, 0x00, 
  0xee, 0x84, 0x78, 0xb2, 0xa0, 0xac, 0x0a, 0xb1, 0x9c, 0x2e, 0xfd, 0x68, 
  0x78, 0x19, 0x0d, 0x03, 0xbe, 0xa1, 0x79, 0xd7, 0xcc, 0x34, 0xe6, 0x2b, 
  0xbb, 0x43, 0xb5, 0x0f, 0xb4, 0x6f, 0x8a, 0x5d, 0xad, 0x5e, 0xcb, 0x40, 
  0xa2, 0x63, 0x84, 0x62, 0x5a, 0x7c, 0xa3, 0xa3, 0x4b, 0xe9, 0x06, 0x7c, 
  0xa8, 0xc1, 0x25, 0x3e, 0x6c, 0x28, 0xa1, 0x52, 0x60, 0x1e, 0x1c, 0x95, 
  0x9e, 0x79, 0x92, 0x03, 0x93, 0xcf, 0xba, 0x6a, 0x3a, 0xe8, 0x83, 0x38, 
  0x2f, 0xf9, 0xb3, 0x8d, 0xe8, 0xdf, 0x1d, 0xdc, 0x03, 0xc3, 0xe2, 0xd3, 
  0x28, 0xc5, 0x25, 0x92, 0x49, 0x63, 0x98, 0x01, 0xfb, 0xe7, 0x56, 0xdb, 
  0x4b, 0x84, 0x96, 0x64, 0x10, 0x71, 0x77, 0xc7, 0xd2, 0x92, 0xad, 0x4c, 
  0x07, 0xbd, 0xf3, 0x9e, 0x6b, 0x62, 0xbe, 0x85, 0x21, 0xba, 0x54, 0x68, 
  0x96, 0x70, 0xc1, 0x28, 0xd2, 0x69, 0x58, 0x43, 0x9c, 0x0f, 0xbf, 0xc4, 
  0xce, 0x22, 0x2f, 0x9f, 0x89, 0x08, 0x78, 0x46, 0x60, 0x6b, 0xb7, 0x70, 
  0x9b, 0x4c, 0x35, 0xeb, 0x17, 0x42, 0xe8, 0x91, 0xcb, 0x41, 0xf2, 0xd9, 
  0xd5, 0xc5, 0x52, 0x6b, 0x14, 0x20, 0xba, 0x97, 0x06, 0x1f, 0x97, 0x37, 
  0x30, 0x13, 0x3b, 0x84, 0xee, 0xd6, 0x74, 0x6b, 0x59, 0xc0, 0xc4, 0x99, 
  0x85, 0x2d, 0x83, 0xa1, 0xd6, 0x96, 0xa2, 0xbe, 0x02, 0x81, 0x3c, 0xfd, 
  0xa1, 0xc7, 0x80, 0xb9, 0xc5, 0xfa, 0x73, 0xd0, 0x42, 0xe2, 0x6f, 0x50, 
  0x9f, 0x4f, 0xfd, 0x46, 0x20, 0x0d, 0xda, 0x92, 0xab, 0x93, 0xc5, 0x15, 
  0x46, 0x8a, 0x42, 0x6a, 0x59, 0x63, 0x01, 0x21, 0x74, 0xa1, 0x90, 0x85, 
  0x4b, 0x05, 0x93, 0x75, 0x16, 0xf4, 0x38, 0xe4, 0x48, 0xfb, 0xea, 0xaf, 
  0xea, 0x30, 0x66, 0x0c, 0x44, 0x09, 0x96, 0x80, 0xe9, 0x8a, 0x31, 0xf3, 
  0x72, 0xe9, 0x11, 0xf3, 0x93, 0xe1, 0x0d, 0x80, 0x8d, 0x2b, 0x9e, 0xdf, 
  0x8b, 0x4b, 0x96, 0x06, 0x21, 0xbd, 0x9a, 0xc0, 0xf2, 0xed, 0xe1, 0xf9, 
  0x97, 0xa7, 0x17, 0x87, 0xd1, 0x76, 0xf4, 0xf2, 0xf0, 0xcb, 0x37, 0xcc, 
  0x34, 0x78, 0xbf, 0x44, 0x5f, 0x43, 0x96, 0xaf, 0xc0, 0x7b, 0x21, 0xcd, 
  0xdf, 0x09, 0x73, 0x92, 0x7f, 0x63, 0x78, 0x08, 0x41, 0x95, 0x40, 0x7e, 
  0x62, 0x96, 0x88, 0x5e, 0x94, 0x66, 0x0c, 0x4a, 0xa8, 0x38, 0xbd, 0x2a, 
  0xe4, 0x65, 0x0c, 0x99, 0x51, 0x19, 0xe2, 0xab, 0xd5, 0x26, 0x2c, 0x9f, 
  0x79, 0x21, 0xee, 0x4e, 0xd4, 0x39, 0x3d, 0x18, 0x1e, 0x4d, 0xd9, 0x70, 
  0x93, 0xf5, 0x1e, 0x82, 0xce, 0xad, 0x70, 0x6a, 0xb3, 0x5c, 0xae, 0x2d, 
  0x40, 0x08, 0x73, 0xdb, 0x40, 0x10, 0x4c, 0xa5, 0x06, 0xac, 0xe8, 0xd2, 
  0x8a, 0x6c, 0x5c, 0x0a, 0xb9, 0xc1, 0xdf, 0xc3, 0x5d, 0xcc, 0x94, 0x1f, 
  0x83, 0x1d, 0x95, 0x89, 0xe4, 0xd2, 0xc9, 0xb5, 0xa9, 0xf6, 0x2d, 0xd1, 
  0x84, 0x62, 0x59, 0xb3, 0x4d, 0x3e, 0x10, 0x9c, 0x01, 0xeb, 0x4a, 0xc0, 
  0x6d, 0x44, 0x8a, 0xfb, 0x4b, 0xaf, 0x8e, 0xb9, 0xb6, 0x16, 0x56, 0x7e, 
  0x6b, 0xd4, 0x24, 0x9c, 0xbb, 0xf5, 0x6c, 0xe1, 0x52, 0x66, 0xca, 0x99, 
  0x4c, 0x72, 0x13, 0x07, 0xe9, 0xd5, 0xb5, 0x60, 0x7c, 0x76, 0x94, 0x19, 
  0x6e, 0x87, 0x9e, 0x26, 0xf6, 0xde, 0x07, 0xf2, 0x56, 0x17, 0x48, 0xb0, 
  0xa0, 0x02, 0x9b, 0xca, 0xa9, 0xee, 0x35, 0x5f, 0xaa, 0xc4, 0x95, 0x72, 
  0x21, 0xe6, 0x8c, 0x2d, 0x85, 0x1e, 0x1d, 0x35, 0xab, 0x54, 0xe8, 0x09, 
  0x94, 0xd6, 0xf1, 0xef, 0xa8, 0x7a, 0x57, 0x85, 0xd6, 0x06, 0xe2, 0x91, 
  0x1b, 0x2f, 0x0f, 0x2f, 0xf7, 0x8f, 0x8e, 0x0f, 0x5f, 0x46, 0x47, 0x27, 
  0xaf, 0x4e, 0xcf, 0x5f, 0xef, 0x5f, 0xaa, 0x79, 0xf5, 0xa5, 0xd3, 0xa6, 
  0x3c, 0x88, 0xad, 0x69, 0x9d, 0x5e, 0xd3, 0x02, 0x0d, 0xd3, 0x36, 0x5e, 
  0x2b, 0x22, 0x83, 0xac, 0x43, 0x52, 0x5b, 0x84, 0x0d, 0x43, 0xe2, 0x71, 
  0xca, 0x34, 0x6e, 0xe6, 0x6d, 0x67, 0xee, 0x1a, 0xd9, 0x7a, 0x9a, 0x2e, 
  0x84, 0x82, 0x71, 0x0f, 0x36, 0xe5, 0xea, 0xbd, 0xc8, 0x2d, 0xb5, 0xf2, 
  0xe5, 0x31, 0x99, 0x28, 0x87, 0x47, 0x9c, 0xb6, 0x85, 0x14, 0x07, 0xad, 
  0x43, 0x75, 0x54, 0x59, 0xda, 0x44, 0xa9, 0x61, 0x17, 0xbe, 0xdc, 0x21, 
  0x48, 0x10, 0x75, 0x6a, 0x82, 0x36, 0x5d, 0x68, 0xbe, 0x81, 0xce, 0x8e, 
  0xbc, 0x66, 0x1f, 0x6e, 0x30, 0xe7, 0x31, 0x6f, 0x70, 0xcc, 0x50, 0xa5, 
  0x1e, 0x03, 0x89, 0x3f, 0xd0, 0x22, 0x6d, 0xaf, 0xb4, 0x11, 0xcf, 0x43, 
  0xcd, 0xa6, 0xa5, 0x00, 0x37, 0x61, 0x53, 0x9b, 0xae, 0x54, 0x09, 0xc9, 
  0x2c, 0xc3, 0x23, 0xa2, 0x58, 0x9e, 0x0f, 0xaf, 0x05, 0xa7, 0x5e, 0xf2, 
  0xcf, 0xcc, 0x33, 0x1a, 0x8d, 0x59, 0xf2, 0xf2, 0x71, 0x00, 0x8d, 0xad, 
  0xc7, 0xcd, 0x1f, 0xdc, 0xd2, 0x48, 0xed, 0x25, 0x3d, 0xc4, 0xc5, 0x0e, 
  0x86, 0xda, 0xbd, 0xd5, 0xb1, 0x61, 0xd1, 0xc8, 0xb6, 0x50, 0xc4, 0x26, 
  0x88, 0x03, 0x1c, 0xd5, 0x2a, 0x41, 0xb4, 0xd9, 0x44, 0xe7, 0x01, 0x02, 
  0xaf, 0xcc, 0x80, 0xc6, 0x42, 0xbb, 0xb7, 0x79, 0x39, 0x18, 0xef, 0x34, 
  0xeb, 0xa8, 0xfd, 0x86, 0x05, 0xb9, 0x70, 0xcf, 0x62, 0x25, 0x83, 0x17, 
  0x62, 0xef, 0x7b, 0xc0, 0xfa, 0x6f, 0x1a, 0x56, 0x0f, 0xd3, 0xac, 0x36, 
  0x98, 0xbc, 0x8b, 0x59, 0xd0, 0x6b, 0x9b, 0xec, 0x6a, 0x93, 0x0a, 0x5f, 
  0xac, 0xdb, 0xe8, 0x43, 0x46, 0x6f, 0x5d, 0x63, 0xf4, 0x93, 0xae, 0x11, 
  0x28, 0x1b, 0x47, 0x11, 0x0a, 0xa2, 0x2a, 0x46, 0x0e, 0x8c, 0x61, 0xab, 
  0xd6, 0xb4, 0x62, 0x49, 0xad, 0x0e, 0x20, 0xcd, 0xc3, 0x7c, 0xb2, 0x31, 
  0xc3, 0x90, 0xb3, 0xfd, 0x46, 0xb1, 0xdb, 0x83, 0x80, 0xbc, 0xe8, 0x35, 
  0xaf, 0x81, 0x95, 0x4e, 0x63, 0xae, 0x97, 0x6d, 0x58, 0xa5, 0x1e, 0x7b, 
  0x69, 0xac, 0xe2, 0x27, 0xd8, 0xbf, 0xa4, 0x1a, 0x82, 0xcb, 0xb3, 0xfd, 
  0x9a, 0x0b, 0xb3, 0xc1, 0x62, 0xc0, 0x9a, 0xaf, 0x5c, 0x1a, 0x20, 0x01, 
  0xcc, 0xd5, 0xe1, 0x7c, 0xe0, 0xf6, 0xf1, 0x25, 0x70, 0x86, 0x92, 0x5c, 
  0x1d, 0x73, 0xb6, 0x83, 0x2b, 0x00, 0x77, 0x09, 0xdc, 0x18, 0x6b, 0x05, 
  0x55, 0xaf, 0xd8, 0xe9, 0x5d, 0xcc, 0xe0, 0x72, 0x53, 0xb7, 0xef, 0x59, 
  0x5e, 0xca, 0x79, 0x83, 0x8c, 0xdd, 0xf3, 0x10, 0xa5, 0xbd, 0xc5, 0x0d, 
  0xf5, 0xd1, 0x8b, 0xae, 0x59, 0x4b, 0xb9, 0xa2, 0xa1, 0xb7, 0x38, 0xe8, 
  0x44, 0x1e, 0x7f, 0x71, 0x1e, 0x4f, 0xe3, 0x64, 0xf6, 0xdb, 0xbd, 0x9d, 
  0x8b, 0xf8, 0x7a, 0x39, 0x8b, 0x7f, 0x87, 0x17, 0x5f, 0x3c, 0x7a, 0xb4, 
  0xb7, 0xf3, 0xc7, 0xcf, 0x76, 0x7a, 0xd1, 0x5f, 0x5a, 0x40, 0x3c, 0xa1, 
  0x51, 0x1b, 0xc5, 0x86, 0x98, 0xf1, 0xa2, 0x9f, 0xd1, 0xf8, 0x1a, 0xb6, 
  0xf8, 0xaf, 0x59, 0x76, 0xd1, 0x35, 0x88, 0x11, 0xe9, 0x2b, 0x7c, 0x52, 
  0x30, 0xf2, 0x19, 0xe2, 0x80, 0xe8, 0xfa, 0x93, 0xdd, 0x67, 0xc2, 0xca, 
  0xae, 0x61, 0x41, 0x89, 0x85, 0x62, 0xa3, 0xe7, 0x69, 0x46, 0x57, 0xd0, 
  0xe7, 0x51, 0x15, 0x5f, 0x3b, 0x5a, 0x45, 0x0b, 0xae, 0xee, 0x90, 0x59, 
  0x05, 0xa7, 0x29, 0x8a, 0xab, 0x8c, 0xa2, 0xcd, 0x4b, 0x01, 0xa9, 0x81, 
  0xdc, 0xb3, 0x48, 0x8a, 0x99, 0x24, 0x31, 0xc5, 0x73, 0x0b, 0x54, 0xe0, 
  0xf7, 0xd9, 0x0d, 0x35, 0x5a, 0xcc, 0xac, 0xc8, 0xac, 0xd8, 0x99, 0x52, 
  0x4f, 0x70, 0xb3, 0x45, 0xe9, 0xa1, 0xb1, 0xe5, 0xbe, 0x09, 0xe0, 0x6f, 
  0x62, 0x5a, 0x2c, 0xe0, 0x94, 0xf6, 0x30, 0x2b, 0x61, 0x19, 0xe0, 0x66, 
  0x13, 0x9b, 0xe9, 0x08, 0xbf, 0xa3, 0x2c, 0x81, 0x96, 0x82, 0xe9, 0x2d, 
  0x24, 0xe8, 0xd7, 0x61, 0xd3, 0x8a, 0x3d, 0x2a, 0xad, 0xcd, 0x2b, 0xf6, 
  0x3e, 0xe9, 0xe8, 0xb9, 0xa9, 0xb7, 0xbb, 0x9f, 0xbf, 0x00, 0x41, 0xec, 
  0x7e, 0xfe, 0x3b, 0xf7, 0xd9, 0x9e, 0x7e, 0xb6, 0xf7, 0xf9, 0xef, 0x46, 
  0x23, 0x8c, 0x8f, 0x29, 0xa4, 0x6f, 0x5f, 0xf7, 0x35, 0x1d, 0x26, 0xd6, 
  0x23, 0x2c, 0x7f, 0x39, 0x64, 0x01, 0xd9, 0xeb, 0x9e, 0xf5, 0x1c, 0xae, 
  0xf2, 0x40, 0x71, 0x47, 0x2a, 0x5f, 0xc9, 0xdc, 0x82, 0xf5, 0x2a, 0x38, 
  0x3c, 0x3a, 0x16, 0xdd, 0x19, 0xb3, 0xd0, 0x4e, 0x19, 0x94, 0x41, 0xff, 
  0x3d, 0x53, 0xea, 0xef, 0x37, 0x90, 0x56, 0x4c, 0xdb, 0xc0, 0xdb, 0x81, 
  0x4a, 0x15, 0x91, 0x91, 0xad, 0x94, 0x37, 0x13, 0x20, 0x1d, 0x6e, 0x99, 
  0x03, 0x07, 0xf8, 0x12, 0x0c, 0x80, 0x56, 0xff, 0xa0, 0x46, 0x52, 0xd9, 
  0xf0, 0x0d, 0x0b, 0xe8, 0x95, 0xf0, 0x71, 0x01, 0x53, 0xd5, 0xcd, 0xfa, 
  0xed, 0xf7, 0xdf, 0xab, 0x3c, 0x45, 0xbf, 0xe8, 0xb8, 0x6f, 0x88, 0x13, 
  0x4d, 0x88, 0xb9, 0x31, 0xaa, 0x2c, 0x35, 0x2e, 0x00, 0xba, 0x7a, 0xe3, 
  0x4f, 0x75, 0x9e, 0xd2, 0x08, 0x6d, 0xac, 0xd4, 0x9b, 0xe1, 0x91, 0x61, 
  0x49, 0x0f, 0x85, 0x89, 0x81, 0x32, 0x37, 0xe1, 0x16, 0xf1, 0x4e, 0xc6, 
  0x90, 0xf0, 0x79, 0xe7, 0xb0, 0xe9, 0xa0, 0x7d, 0x6a, 0xcc, 0x14, 0x60, 
  0xdd, 0x48, 0x50, 0xac, 0x08, 0x39, 0x2f, 0x7a, 0xf2, 0xe0, 0x75, 0xda, 
  0x53, 0x53, 0xa4, 0x7c, 0xd2, 0xf3, 0xb9, 0x4d, 0xb2, 0x1b, 0xd8, 0xb2, 
  0x17, 0x22, 0x39, 0xa5, 0x3f, 0x27, 0x2f, 0x76, 0x77, 0xba, 0x9f, 0x60, 
  0xb5, 0x08, 0xd5, 0x08, 0x5f, 0x78, 0xf3, 0xd7, 0x43, 0xcf, 0xa7, 0x13, 
  0x79, 0x5a, 0x4b, 0x4c, 0x00, 0x0b, 0xf8, 0x45, 0xef, 0x8a, 0xef, 0x57, 
  0xfe, 0xff, 0x35, 0xe3, 0x40, 0x3c, 0x84, 0x3e, 0x5b, 0x2e, 0xaf, 0xe6, 
  0x69, 0x6d, 0xc0, 0xdb, 0x3c, 0xc1, 0xcf, 0x61, 0x4c, 0x49, 0x1c, 0x6d, 
  0x20, 0x50, 0x46, 0x44, 0xbf, 0xfe, 0x34, 0xcf, 0xaf, 0xe2, 0xa2, 0xaf, 
  0xe6, 0x3e, 0x1b, 0x67, 0x7f, 0x77, 0xef, 0xd1, 0xe3, 0x27, 0xfd, 0x91, 
  0x8a, 0x69, 0x60, 0x10, 0xd0, 0xd0, 0x52, 0xd5, 0x64, 0xa4, 0x89, 0x58, 
  0x8e, 0x67, 0x58, 0x1b, 0xad, 0xd3, 0x2c, 0xce, 0x3c, 0x8c, 0xbb, 0x7b, 
  0x21, 0xbd, 0xfd, 0x8e, 0xfb, 0x79, 0x81, 0x2e, 0x7e, 0x97, 0x4e, 0x5e, 
  0xb8, 0x19, 0xfe, 0x8e, 0xe7, 0xf2, 0x42, 0x27, 0x41, 0xfb, 0x6a, 0x31, 
  0x74, 0x65, 0x88, 0x9a, 0xf0, 0xbe, 0xcd, 0xb5, 0x4d, 0xdc, 0xc0, 0xa4, 
  0x6f, 0xa0, 0x22, 0x4e, 0xc4, 0x50, 0x08, 0x61, 0xd5, 0x47, 0x77, 0x6d, 
  0xbf, 0x1b, 0x52, 0x2b, 0x43, 0x6e, 0x65, 0xe8, 0xd9, 0x75, 0x34, 0xe7, 
  0xb0, 0x59, 0xde, 0x88, 0x81, 0xc6, 0x14, 0xce, 0x60, 0xe5, 0x50, 0x41, 
  0x20, 0xcf, 0x11, 0x31, 0x76, 0xf0, 0xd5, 0x51, 0x5f, 0x9d, 0x55, 0xa2, 
  0xb7, 0xa9, 0xb1, 0xba, 0xae, 0x62, 0x8a, 0x25, 0xba, 0x48, 0x2c, 0x17, 
  0x77, 0x23, 0xa8, 0x4f, 0x8e, 0x9d, 0x19, 0xe2, 0x28, 0xa2, 0x62, 0xa5, 
  0xdc, 0x39, 0xb3, 0x18, 0x08, 0xc4, 0x40, 0x70, 0x0b, 0x9a, 0x01, 0xa8, 
  0x85, 0x38, 0x61, 0xa0, 0x19, 0x7b, 0xfc, 0xb7, 0xe1, 0x2b, 0x67, 0xb7, 
  0x76, 0x81, 0x62, 0xfa, 0x28, 0x7d, 0x25, 0xdc, 0xc4, 0x18, 0x44, 0x6f, 
  0x64, 0xe5, 0x3a, 0x84, 0x12, 0x42, 0xde, 0x01, 0xab, 0x3b, 0x12, 0x9e, 
  0x38, 0xc2, 0x50, 0xcc, 0x18, 0x22, 0x16, 0x32, 0xf7, 0x7c, 0xee, 0x80, 
  0xb5, 0x3f, 0x8f, 0x80, 0xbd, 0x2a, 0x6f, 0x69, 0x18, 0x95, 0x1a, 0x80, 
  0xc4, 0x58, 0x8b, 0x97, 0x54, 0x3b, 0x70, 0x36, 0xfa, 0xc0, 0x83, 0xa5, 
  0x62, 0x81, 0xb4, 0x20, 0x13, 0xa5, 0xf5, 0x14, 0x3b, 0x00, 0xb7, 0xd0, 
  0xff, 0x13, 0x0e, 0xc1, 0xf3, 0x39, 0x40, 0x1f, 0xe9, 0xd7, 0xcf, 0xfb, 
  0x62, 0xbc, 0xab, 0x15, 0x2c, 0x6c, 0xf8, 0x00, 0x84, 0x40, 0xc3, 0xf9, 
  0xe4, 0x53, 0x87, 0x5b, 0x20, 0xb2, 0x58, 0x9a, 0x29, 0x60, 0x01, 0xc9, 
  0x52, 0x33, 0x0e, 0x22, 0x64, 0xb1, 0x52, 0x65, 0xa1, 0x81, 0x36, 0x9e, 
  0x70, 0xd0, 0x1a, 0xcb, 0x8e, 0x7d, 0x76, 0x0f, 0xe3, 0xbd, 0xbe, 0xcf, 
  0xd3, 0xcd, 0xa1, 0x56, 0xb1, 0xb1, 0x20, 0x09, 0xb0, 0xe7, 0xa5, 0xbc, 
  0xad, 0x93, 0xe5, 0xc3, 0x89, 0x95, 0x81, 0xe8, 0xe0, 0x43, 0xcd, 0x24, 
  0x85, 0xad, 0x75, 0x44, 0x5e, 0x71, 0x40, 0xac, 0x76, 0xfa, 0x82, 0x97, 
  0x7b, 0x77, 0x74, 0x9d, 0x4e, 0x65, 0x31, 0x88, 0x45, 0x5e, 0x27, 0xdb, 
  0xf4, 0x27, 0x17, 0xc6, 0xdb, 0x63, 0x99, 0x8c, 0x7f, 0x79, 0x04, 0x1f, 
  0x66, 0x78, 0xf3, 0x07, 0x67, 0xc3, 0x9d, 0x0b, 0xfe, 0x25, 0x75, 0x37, 
  0xbe, 0xe2, 0xdc, 0xe9, 0x28, 0x41, 0xe6, 0x86, 0x67, 0x16, 0x40, 0xdb, 
  0x05, 0x75, 0x33, 0x0b, 0x48, 0x49, 0x2c, 0x35, 0x94, 0x3e, 0xc0, 0x43, 
  0x81, 0xfb, 0x7d, 0x98, 0xf0, 0x66, 0xaa, 0xf6, 0x12, 0x0e, 0x80, 0xc3, 
  0xbd, 0x9a, 0xdc, 0x6f, 0x01, 0x08, 0xc6, 0xd4, 0x5b, 0x2b, 0xdd, 0x1c, 
  0x06, 0xf0, 0xcb, 0xee, 0x6f, 0x2a, 0x96, 0x29, 0x47, 0x97, 0xc5, 0x05, 
  0xe2, 0x62, 0xb1, 0xcd, 0x69, 0x73, 0x07, 0x1d, 0x88, 0xb9, 0xb9, 0xa3, 
  0x25, 0xe2, 0x61, 0x0b, 0x35, 0xfe, 0x66, 0x25, 0x54, 0x75, 0x45, 0x51, 
  0xf6, 0xeb, 0x6e, 0x79, 0xd9, 0xe8, 0xaa, 0xcf, 0xb0, 0xea, 0xdb, 0xf0, 
  0x5c, 0x08, 0x6f, 0x3b, 0xa4, 0xe3, 0x88, 0xca, 0x05, 0xb8, 0x2f, 0x87, 
  0x72, 0x5f, 0xaa, 0x10, 0x34, 0x7c, 0x35, 0x8a, 0x8e, 0x11, 0xeb, 0x50, 
  0xc6, 0x2b, 0x90, 0xb3, 0xdd, 0xa9, 0x46, 0x01, 0x44, 0x2e, 0x22, 0x75, 
  0x6f, 0x48, 0x9a, 0xd4, 0x28, 0x3a, 0xcd, 0x8c, 0x8c, 0x00, 0xcd, 0xe4, 
  0xf5, 0x4c, 0x91, 0x28, 0x54, 0x02, 0x19, 0xc0, 0xfe, 0xec, 0x9e, 0x43, 
  0x41, 0x52, 0x3c, 0x25, 0x75, 0xd6, 0x1c, 0x91, 0x06, 0x8d, 0xb8, 0x12, 
  0x73, 0x2c, 0x72, 0x06, 0xac, 0xdc, 0x11, 0xbe, 0xa4, 0xfd, 0x24, 0x28, 
  0x19, 0xe7, 0x0a, 0x39, 0xc3, 0x65, 0x42, 0xad, 0x81, 0xb2, 0x78, 0xee, 
  0x4c, 0x3a, 0x3d, 0x68, 0x8a, 0xb3, 0xc4, 0xe9, 0xd3, 0x8a, 0x7c, 0x28, 
  0xc1, 0x56, 0x96, 0xa8, 0x2a, 0x02, 0x86, 0xcf, 0x71, 0xe7, 0x41, 0xf2, 
  0xb8, 0xe2, 0x3b, 0xfa, 0x85, 0x2f, 0xf9, 0xab, 0x82, 0x76, 0xda, 0x2a, 
  0x6b, 0xa2, 0x57, 0xa9, 0xd8, 0x3a, 0x51, 0xc5, 0xe4, 0xf5, 0x71, 0x54, 
  0xd2, 0xa3, 0xe3, 0xc4, 0x25, 0x26, 0xf1, 0xca, 0x5a, 0x04, 0x03, 0xa6, 
  0xa8, 0xc6, 0x10, 0x91, 0x80, 0xf4, 0x29, 0xb9, 0xd9, 0x64, 0x6d, 0x39, 
  0xd4, 0x3b, 0xe2, 0xc5, 0xa9, 0x1d, 0xd3, 0xe0, 0x09, 0x79, 0x75, 0x43, 
  0x62, 0xc3, 0xfa, 0xbc, 0x04, 0xfd, 0x41, 0xd4, 0xe7, 0xa1, 0xf2, 0x17, 
  0x7d, 0xac, 0x27, 0x3e, 0x0e, 0x96, 0xaf, 0x3f, 0xea, 0x38, 0x79, 0xfc, 
  0xcc, 0x8b, 0x2f, 0x6a, 0xab, 0x84, 0xcf, 0xad, 0xa9, 0x17, 0x12, 0x31, 
  0xd6, 0x92, 0xb2, 0xed, 0xdd, 0xa0, 0xfd, 0x17, 0x07, 0xd4, 0x8a, 0xe0, 
  0xf7, 0xcb, 0x9e, 0x40, 0xa0, 0x76, 0x9f, 0xa5, 0x88, 0xa6, 0x6c, 0x35, 
  0xf4, 0xfe, 0x93, 0x7b, 0x69, 0xec, 0xc7, 0x85, 0x4a, 0x08, 0x47, 0x13, 
  0x12, 0x30, 0x6e, 0x4b, 0xbb, 0x99, 0x8a, 0xa6, 0x77, 0x9f, 0xc3, 0xae, 
  0x00, 0x3e, 0xb3, 0x3b, 0x8a, 0x2e, 0xf8, 0xdd, 0x46, 0xf9, 0xcf, 0x34, 
  0x50, 0xd7, 0x7b, 0x58, 0xd0, 0x9e, 0xd9, 0x49, 0x9c, 0x12, 0x6f, 0xab, 
  0xdc, 0x36, 0x05, 0xd3, 0xd4, 0xb5, 0x38, 0x26, 0xf1, 0xab, 0x49, 0x7e, 
  0xcd, 0xec, 0x6a, 0x40, 0x37, 0x2b, 0xff, 0xec, 0x45, 0x78, 0x7c, 0x4f, 
  0xfb, 0x95, 0x31, 0xe3, 0xb8, 0x88, 0xe8, 0x6e, 0x7f, 0x6b, 0x34, 0x47, 
  0xd4, 0xb1, 0x25, 0x93, 0x7c, 0xac, 0xcd, 0xbb, 0xd6, 0x65, 0x4f, 0xa8, 
  0x0b, 0xf7, 0x85, 0xef, 0x6e, 0xe3, 0xfc, 0xf0, 0xd5, 0xe1, 0xf9, 0xb9, 
  0x38, 0x20, 0xf7, 0x6b, 0x70, 0xb1, 0xc8, 0x8a, 0x96, 0x28, 0x6d, 0xab, 
  0xbb, 0x6b, 0xc1, 0x1b, 0xa1, 0xe5, 0xc0, 0xa2, 0xde, 0xf8, 0xa0, 0x2a, 
  0xea, 0xc4, 0x46, 0x64, 0x5e, 0x3f, 0xc1, 0x8f, 0x11, 0x83, 0x25, 0xac, 
  0x5d, 0x08, 0xdd, 0x71, 0x76, 0xe5, 0x19, 0x73, 0x3d, 0xd8, 0xc3, 0x6a, 
  0x77, 0xdd, 0x46, 0x64, 0xaf, 0x16, 0x02, 0x76, 0xed, 0xca, 0xf9, 0xb6, 
  0x4b, 0xca, 0x4a, 0xb4, 0x45, 0xa2, 0xbe, 0xbc, 0x99, 0xd3, 0x96, 0x71, 
  0x31, 0x4f, 0x99, 0x7e, 0x58, 0x92, 0x2f, 0xd8, 0xc1, 0x5d, 0x56, 0xcb, 
  0x45, 0x3a, 0x71, 0xc6, 0x47, 0xfa, 0x9c, 0xc4, 0x91, 0x48, 0x28, 0xb0, 
  0xb4, 0x11, 0xc3, 0xcb, 0x65, 0xaa, 0x71, 0x68, 0xfb, 0x91, 0x84, 0x31, 
  0x6f, 0xb9, 0x41, 0x6c, 0xa6, 0x54, 0xff, 0x30, 0xa8, 0x4c, 0x3e, 0xfc, 
  0xad, 0x63, 0x92, 0xc0, 0xe8, 0xc5, 0x94, 0x6c, 0x9e, 0xd3, 0x90, 0x6a, 
  0xd9, 0xb2, 0x32, 0xf7, 0x31, 0x4b, 0x52, 0x6f, 0x41, 0x02, 0x97, 0xf9, 
  0x66, 0x2c, 0x3c, 0x47, 0x43, 0xe0, 0x97, 0x8f, 0x27, 0x12, 0x17, 0x2b, 
  0xcd, 0x5a, 0x57, 0x48, 0x75, 0x32, 0x2e, 0x64, 0xcd, 0xe1, 0x39, 0x87, 
  0xe7, 0xd1, 0xfe, 0x57, 0x8c, 0x4c, 0xf1, 0xef, 0x6d, 0x2b, 0x3f, 0xa7, 
  0x1c, 0xcb, 0x36, 0x55, 0x13, 0x46, 0x92, 0x49, 0x88, 0x88, 0x3b, 0xaa, 
  0xed, 0x68, 0xaa, 0x18, 0xe5, 0xc1, 0xb5, 0x53, 0xdf, 0xbb, 0x8d, 0xe8, 
  0xbd, 0xbb, 0xf7, 0x21, 0x7b, 0xc7, 0xba, 0x67, 0xb8, 0x7b, 0xb8, 0x4a, 
  0xd5, 0x32, 0x6e, 0x7b, 0xa2, 0xa3, 0x2f, 0x5b, 0xea, 0x8f, 0xec, 0xce, 
  0x7e, 0xd4, 0x7f, 0x9d, 0xff, 0x4c, 0x17, 0x54, 0xbc, 0xfd, 0x68, 0xb4, 
  0x13, 0x6d, 0x7e, 0x97, 0x66, 0x4f, 0x9f, 0xfc, 0x29, 0x3a, 0xda, 0xea, 
  0xd7, 0x02, 0xb1, 0x04, 0xa1, 0xf2, 0x2a, 0xce, 0x6e, 0xdd, 0x56, 0x9d, 
  0xc2, 0x8e, 0x2e, 0xce, 0x7f, 0x03, 0x50, 0x7b, 0x86, 0xbd, 0x5f, 0xdb, 
  0xa2, 0x54, 0x55, 0x92, 0x98, 0xae, 0xe8, 0x5b, 0x07, 0xf8, 0xc3, 0xba, 
  0x26, 0x3d, 0x35, 0xe1, 0xa5, 0x7b, 0xfa, 0xa4, 0xd5, 0xc4, 0x63, 0xd7, 
  0xc6, 0x1b, 0x69, 0xe3, 0x17, 0x36, 0xb1, 0x37, 0xda, 0xd9, 0x8b, 0x36, 
  0x4f, 0x2f, 0xb6, 0xf7, 0x5c, 0x0b, 0xed, 0x26, 0xf6, 0xd0, 0x04, 0x3f, 
  0x54, 0x7f, 0xf9, 0x31, 0xf7, 0xff, 0x63, 0x92, 0xfd, 0x14, 0x6d, 0x7e, 
  0xbf, 0xbb, 0x4b, 0x0d, 0xfc, 0x29, 0xda, 0x3f, 0xfa, 0x3e, 0x7a, 0x3c, 
  0xa2, 0xc6, 0x4e, 0xe2, 0x3b, 0x6d, 0x4e, 0x31, 0x2f, 0x2e, 0xd0, 0x08, 
  0x7d, 0xdf, 0x6a, 0xe3, 0x49, 0xa3, 0x8d, 0x63, 0xd2, 0x4f, 0xde, 0x11, 
  0x9f, 0xdb, 0x19, 0x3d, 0xda, 0x8b, 0xd2, 0x27, 0x9f, 0x7d, 0x6a, 0x0d, 
  0x69, 0x1b, 0xf8, 0xbe, 0x6e, 0x33, 0x93, 0xac, 0x0d, 0xba, 0x7e, 0x0f, 
  0xdf, 0x91, 0x18, 0x0f, 0xd6, 0x00, 0xc8, 0xb9, 0x9b, 0x58, 0xea, 0x66, 
  0x5e, 0x09, 0xd0, 0x33, 0xed, 0x94, 0xd8, 0x55, 0xd9, 0x40, 0x8e, 0x44, 
  0x99, 0xd5, 0xb3, 0xd6, 0x70, 0x58, 0x47, 0xb2, 0x47, 0xff, 0x14, 0xbd, 
  0xbe, 0x38, 0x3a, 0xa4, 0x19, 0xed, 0xd0, 0xd0, 0xfc, 0x1a, 0xca, 0x80, 
  0xf0, 0x15, 0x16, 0x97, 0x56, 0x75, 0x83, 0x2b, 0x2d, 0xa2, 0x8d, 0x10, 
  0xcb, 0x16, 0x44, 0x47, 0x97, 0x49, 0x89, 0x7e, 0x39, 0xeb, 0x72, 0xb8, 
  0x7f, 0xcd, 0xa2, 0xac, 0xb2, 0x7f, 0xee, 0xfa, 0x9b, 0x3c, 0xa3, 0x63, 
  0x52, 0xe4, 0xc5, 0xf6, 0xee, 0x68, 0xa7, 0x5f, 0xbb, 0xc1, 0xbe, 0x79, 
  0x79, 0x18, 0xbd, 0xe2, 0x0b, 0xef, 0x75, 0x9c, 0xc5, 0xd7, 0xc8, 0xb4, 
  0x2c, 0x6f, 0xd9, 0x0f, 0x2c, 0x5e, 0x05, 0x79, 0xff, 0x78, 0x95, 0xbd, 
  0xa3, 0x7d, 0xfc, 0xe3, 0x68, 0x97, 0x13, 0x80, 0x58, 0xfb, 0x7a, 0xf5, 
  0x9a, 0xfe, 0xde, 0x7d, 0xdc, 0x8f, 0xf8, 0xab, 0xba, 0x26, 0x69, 0xe7, 
  0x75, 0xe3, 0xe0, 0xf4, 0xf4, 0x9b, 0x23, 0x09, 0x09, 0x38, 0x50, 0xe3, 
  0x1e, 0x5f, 0xf8, 0x4e, 0x3b, 0x13, 0xae, 0x4a, 0x5a, 0x04, 0xc7, 0x48, 
  0xda, 0xc9, 0xa2, 0x95, 0xbc, 0x4d, 0x92, 0x05, 0x00, 0x79, 0x1a, 0x1c, 
  0xc1, 0xaa, 0x75, 0xc8, 0xc8, 0x58, 0xc0, 0x4b, 0x27, 0x49, 0x03, 0x31, 
  0xa1, 0x2a, 0x9d, 0x21, 0xf1, 0x6a, 0xe5, 0xf2, 0x0e, 0x62, 0xe7, 0xb9, 
  0xb1, 0xa2, 0x7b, 0xda, 0x94, 0x19, 0x42, 0xa5, 0x42, 0x1d, 0xbd, 0xa8, 
  0x3a, 0x58, 0xff, 0x22, 0xa9, 0x86, 0x32, 0xe8, 0x67, 0x6a, 0x3b, 0xec, 
  0xab, 0x21, 0xc4, 0x99, 0x71, 0x16, 0x0a, 0xe6, 0x07, 0x03, 0xe6, 0x6a, 
  0xc1, 0x25, 0x4e, 0xb8, 0x70, 0xbc, 0xf0, 0x64, 0xd4, 0x6e, 0x4a, 0x10, 
  0xb8, 0x74, 0xb2, 0xff, 0xfa, 0xf0, 0xc5, 0xb7, 0xfb, 0xc7, 0x6f, 0x0e, 
  0x51, 0x63, 0xbc, 0x8c, 0x36, 0x3d, 0x18, 0x0b, 0xc6, 0x38, 0x4f, 0xc7, 
  0xf9, 0x8c, 0x9d, 0x1d, 0xfd, 0x3f, 0xf5, 0xc1, 0x99, 0x68, 0x00, 0x3d, 
  0x7e, 0x6b, 0x57, 0x5e, 0x23, 0xba, 0xe0, 0xbf, 0xf6, 0xe4, 0xaf, 0xbd, 
  0x3f, 0xf5, 0xb6, 0x6a, 0x93, 0x6e, 0x69, 0x6b, 0x4c, 0x2f, 0xf7, 0x12, 
  0x99, 0xc4, 0x81, 0x63, 0x18, 0x71, 0x4f, 0x56, 0xa5, 0x67, 0x9e, 0x02, 
  0xbb, 0xd3, 0xf8, 0xd9, 0xcd, 0xab, 0x55, 0xa8, 0x0b, 0xf6, 0xf8, 0xa5, 
  0x17, 0x30, 0x4d, 0xf4, 0xb6, 0x06, 0x62, 0x1f, 0xd7, 0x85, 0x47, 0x1b, 
  0xd6, 0x44, 0xf2, 0x6e, 0xc1, 0x51, 0x2c, 0x9b, 0x3d, 0xf9, 0xe5, 0xc5, 
  0xcb, 0xfd, 0xcb, 0x43, 0x7e, 0xc1, 0xba, 0xb7, 0xe2, 0x5a, 0x86, 0x66, 
  0xc3, 0xe3, 0xd9, 0xec, 0xc9, 0x87, 0x2f, 0x78, 0x42, 0xbd, 0x2d, 0xb1, 
  0xa8, 0xc3, 0xdb, 0xda, 0x18, 0x57, 0x9e, 0x69, 0x18, 0x98, 0x65, 0xfb, 
  0xc1, 0x1b, 0xa4, 0x91, 0x0b, 0x9b, 0x3d, 0xf9, 0xae, 0xe7, 0xec, 0x88, 
  0x5a, 0xd2, 0xc6, 0xd5, 0x03, 0x8d, 0xbb, 0x02, 0xb6, 0x05, 0x56, 0xda, 
  0xef, 0x8f, 0x9a, 0xcc, 0xc5, 0xf2, 0x11, 0x00, 0xf2, 0xb8, 0x8d, 0x2f, 
  0x05, 0x9d, 0x91, 0x6d, 0x1d, 0x79, 0xbe, 0xbb, 0xf7, 0xe8, 0x4f, 0x58, 
  0xcf, 0x17, 0xbd, 0x6d, 0xba, 0x1b, 0x7a, 0x7f, 0xe2, 0xae, 0x53, 0x0f, 
  0x59, 0xed, 0xf6, 0x83, 0x65, 0x7c, 0xa5, 0x28, 0x09, 0x9b, 0x40, 0x65, 
  0x79, 0xb6, 0x9d, 0xc8, 0xbc, 0xb0, 0xa0, 0xf7, 0x12, 0xe1, 0x6b, 0xe9, 
  0x3c, 0xe6, 0x55, 0xc6, 0x7e, 0xa1, 0xb8, 0x46, 0xe6, 0x90, 0xd6, 0xa4, 
  0xbb, 0xf0, 0xfe, 0x18, 0xc8, 0xbb, 0x32, 0x47, 0x2d, 0xa8, 0xc3, 0x7d, 
  0xce, 0x57, 0x16, 0x04, 0x5c, 0x96, 0xa6, 0x6a, 0xc9, 0x9e, 0xb5, 0xd4, 
  0xd6, 0x2b, 0xb5, 0x31, 0x98, 0x80, 0x0c, 0x59, 0x80, 0x58, 0xcb, 0x0a, 
  0x02, 0x92, 0x16, 0x64, 0xf7, 0xde, 0x77, 0xbb, 0xb3, 0xe3, 0x2b, 0xce, 
  0x62, 0x30, 0x04, 0xf3, 0x50, 0x3b, 0x74, 0x4b, 0x6f, 0xc7, 0x2f, 0x0d, 
  0xf2, 0xb4, 0xf8, 0xa2, 0x94, 0xb5, 0x2c, 0x9d, 0x2d, 0x03, 0x3e, 0x2f, 
  0x7d, 0xb6, 0xbe, 0x4f, 0x8d, 0x58, 0x62, 0x4c, 0x43, 0x54, 0x4b, 0xd1, 
  0xd9, 0x88, 0xd5, 0x64, 0x49, 0xf1, 0xa0, 0xe7, 0xbd, 0xc3, 0x25, 0x82, 
  0x29, 0xaa, 0x46, 0x62, 0x13, 0x1c, 0x8d, 0x46, 0x4e, 0x04, 0x87, 0x3b, 
  0x47, 0x3d, 0x21, 0x80, 0xf3, 0xaa, 0x21, 0x4c, 0xd0, 0x1a, 0x33, 0x4c, 
  0x82, 0xe6, 0xfa, 0x6f, 0x69, 0x40, 0xc6, 0xd2, 0x21, 0x69, 0xd4, 0x66, 
  0xc2, 0x2b, 0xd5, 0xd7, 0x6e, 0xfb, 0xeb, 0xa3, 0x4e, 0x69, 0x13, 0x1e, 
  0x18, 0x9b, 0xd8, 0xc0, 0xca, 0x18, 0x79, 0x50, 0x8e, 0x4f, 0xe5, 0x6e, 
  0x2d, 0x98, 0x82, 0x39, 0x37, 0x0a, 0x74, 0x22, 0x81, 0xb1, 0xb2, 0x68, 
  0x3a, 0x14, 0x45, 0xba, 0x67, 0x26, 0x97, 0xdf, 0xf3, 0x5d, 0xa4, 0xf5, 
  0x0b, 0x17, 0x05, 0x6b, 0x1f, 0xa8, 0xb8, 0xa2, 0x37, 0x88, 0xe0, 0x2c, 
  0x72, 0xec, 0xa0, 0x34, 0x33, 0x11, 0x8b, 0x21, 0xab, 0x71, 0xd0, 0x23, 
  0x35, 0x40, 0x5d, 0x13, 0xec, 0xca, 0x58, 0xe1, 0x3d, 0x5c, 0xdd, 0x75, 
  0x9b, 0xbb, 0xd7, 0xde, 0x39, 0xe8, 0x68, 0x28, 0x49, 0x75, 0x16, 0x43, 
  0x6e, 0xcc, 0x43, 0x4b, 0xab, 0x3d, 0xe4, 0xb5, 0x1d, 0x5b, 0x8b, 0xce, 
  0x65, 0xdb, 0x58, 0x1a, 0x7f, 0x29, 0xd7, 0x39, 0x17, 0x2d, 0xa8, 0x18, 
  0x39, 0x1d, 0xda, 0x9a, 0xb2, 0xbd, 0x28, 0xbe, 0xa7, 0x9b, 0x27, 0x23, 
  0x12, 0x14, 0xef, 0x8d, 0x18, 0x0a, 0x8e, 0x03, 0x73, 0x97, 0x9b, 0xa1, 
  0xd5, 0xba, 0x8a, 0x83, 0x6a, 0x57, 0x8a, 0xa2, 0x97, 0x4f, 0x59, 0x39, 
  0x37, 0xbb, 0x12, 0xcb, 0xdd, 0xf9, 0x9c, 0x11, 0x3f, 0x54, 0x40, 0x37, 
  0x8d, 0x91, 0x47, 0x4e, 0x1c, 0xfa, 0x22, 0x77, 0x75, 0x7f, 0x63, 0xf1, 
  0x84, 0x88, 0x77, 0xdf, 0x56, 0x8b, 0xc7, 0xe1, 0x3b, 0x19, 0x04, 0xe1, 
  0xca, 0x4c, 0x55, 0x5c, 0xb7, 0x2d, 0x1b, 0xba, 0x5c, 0x2a, 0x17, 0x12, 
  0x54, 0xa4, 0xd7, 0x52, 0x19, 0xd1, 0x2d, 0xa8, 0x9b, 0x5a, 0x37, 0x8d, 
  0x1d, 0xf3, 0xaa, 0x24, 0xf3, 0x45, 0xb5, 0x5a, 0xb7, 0x9a, 0x97, 0xae, 
  0x16, 0x90, 0x1a, 0x02, 0x6a, 0xb4, 0x6c, 0x8e, 0x31, 0x87, 0xfa, 0x64, 
  0x79, 0x2f, 0x28, 0x38, 0x58, 0x73, 0x64, 0x02, 0x96, 0x81, 0xf3, 0x82, 
  0x7d, 0x9a, 0x8f, 0x6d, 0x3a, 0x52, 0x9f, 0x7d, 0x1c, 0xc4, 0x84, 0xcd, 
  0x9d, 0x73, 0xbe, 0x89, 0xef, 0x5d, 0x08, 0x8e, 0xd4, 0x65, 0xb8, 0x8a, 
  0xbd, 0xa6, 0xb5, 0x11, 0xd5, 0x8c, 0x8e, 0x8c, 0xce, 0x75, 0x94, 0x29, 
  0x1b, 0xca, 0xef, 0x12, 0x8f, 0x09, 0xe0, 0xed, 0x5e, 0x1e, 0x4d, 0x47, 
  0x0f, 0xbf, 0xe3, 0x25, 0x0d, 0x2f, 0xa3, 0x63, 0x57, 0x98, 0x64, 0x63, 
  0x55, 0x46, 0x51, 0xd0, 0xa4, 0x68, 0xef, 0x79, 0xc8, 0xe1, 0x65, 0x6c, 
  0xea, 0x3c, 0xb5, 0x16, 0x35, 0x18, 0x3a, 0x46, 0x5e, 0x84, 0xd7, 0x4c, 
  0x78, 0x41, 0xd2, 0x4a, 0xa9, 0xaa, 0x74, 0xa1, 0x5b, 0xde, 0x09, 0x69, 
  0xb3, 0xec, 0xb9, 0x4d, 0xea, 0x59, 0x15, 0xf1, 0x80, 0x08, 0xd8, 0x6e, 
  0xe4, 0x1c, 0xc9, 0xfb, 0xb3, 0x98, 0x63, 0x29, 0x72, 0xf1, 0x51, 0x63, 
  0xcf, 0x40, 0xd5, 0x30, 0xf0, 0x34, 0x78, 0x6a, 0xeb, 0xfc, 0xb9, 0x98, 
  0x01, 0x21, 0x36, 0x20, 0xde, 0x70, 0x33, 0x44, 0x26, 0xdc, 0xc8, 0x70, 
  0x6c, 0xcc, 0xdd, 0x79, 0xe4, 0x3b, 0x33, 0x61, 0xae, 0x6a, 0x87, 0xf4, 
  0x7d, 0x67, 0xf6, 0xec, 0xfc, 0xf4, 0xab, 0xf3, 0xc3, 0x8b, 0x8b, 0xe8, 
  0xf5, 0xe1, 0xa5, 0xe8, 0xfa, 0x97, 0x21, 0x16, 0x22, 0xcc, 0xdf, 0x06, 
  0x02, 0x67, 0x31, 0x10, 0xb1, 0xb8, 0x3a, 0x04, 0x7f, 0x2e, 0x67, 0xd7, 
  0x0e, 0x44, 0x39, 0xe8, 0xf1, 0x33, 0x8d, 0xea, 0xba, 0x81, 0x01, 0x1a, 
  0x51, 0x36, 0xf0, 0x90, 0x39, 0x7b, 0xae, 0xb7, 0xf2, 0x05, 0x65, 0x1d, 
  0x6f, 0x8c, 0x75, 0x79, 0xab, 0xae, 0x56, 0xc6, 0xc3, 0xf4, 0x7e, 0x1b, 
  0x5d, 0x5a, 0xe1, 0xb8, 0xdf, 0x46, 0xe7, 0x46, 0x20, 0xbf, 0x8d, 0xbe, 
  0xa7, 0x36, 0x27, 0x5c, 0xd5, 0x4f, 0xaa, 0xc2, 0x5c, 0x48, 0x39, 0x18, 
  0x07, 0x03, 0x01, 0x50, 0xfb, 0xe0, 0x3f, 0x22, 0xf3, 0x62, 0xf4, 0x70, 
  0x79, 0x15, 0x24, 0x33, 0x4a, 0xc1, 0x19, 0x8d, 0xf1, 0x72, 0x3d, 0x1f, 
  0xa0, 0x20, 0x61, 0x15, 0x45, 0xc7, 0xc9, 0xb4, 0x82, 0x40, 0xc2, 0xdd, 
  0x51, 0x73, 0x3b, 0x0c, 0xc0, 0xb4, 0xcb, 0xb5, 0x76, 0xe9, 0xd7, 0x47, 
  0x9f, 0x7d, 0xba, 0xf3, 0x99, 0xfc, 0x6a, 0xff, 0x3e, 0x7d, 0xbc, 0xa3, 
  0x18, 0x67, 0xf4, 0xd7, 0xe3, 0x67, 0x8f, 0x77, 0x9f, 0x71, 0x2a, 0xfb, 
  0xce, 0xb3, 0x1d, 0xfa, 0xff, 0xc7, 0xfa, 0x09, 0x63, 0x00, 0x3c, 0xdd, 
  0xfb, 0xec, 0x8f, 0x08, 0xcf, 0x60, 0xfa, 0x98, 0x51, 0x27, 0xc3, 0x2a, 
  0x1f, 0x16, 0x5c, 0x38, 0x03, 0x42, 0xd0, 0x6f, 0xeb, 0x86, 0x32, 0xf6, 
  0xf7, 0x8e, 0xd9, 0xbf, 0x77, 0x9d, 0x04, 0xf5, 0x4c, 0xd5, 0xe8, 0x27, 
  0x29, 0x96, 0x21, 0x2a, 0x92, 0x9b, 0x86, 0xbe, 0x2d, 0x75, 0x84, 0x90, 
  0x7f, 0x5a, 0x7b, 0x87, 0x44, 0x46, 0xba, 0x5a, 0x83, 0x44, 0xd7, 0x5f, 
  0xda, 0x75, 0x58, 0x38, 0xc0, 0x6d, 0x95, 0xbe, 0x27, 0x35, 0x1d, 0xb9, 
  0xea, 0x48, 0x50, 0xfd, 0xa8, 0x51, 0xcb, 0xe8, 0x97, 0xf6, 0x27, 0xae, 
  0x1b, 0x7e, 0x4b, 0xa9, 0x21, 0x6a, 0xf7, 0x66, 0x55, 0x9d, 0xba, 0xfa, 
  0xaa, 0x11, 0xcf, 0x86, 0xdf, 0x7e, 0xbf, 0x52, 0x41, 0xdd, 0x21, 0x97, 
  0xfd, 0x2b, 0x95, 0x87, 0x3a, 0xa6, 0xdc, 0x6a, 0xee, 0xcd, 0x22, 0x6c, 
  0xef, 0x43, 0x9a, 0xf3, 0x33, 0x02, 0x05, 0xbb, 0x9d, 0x1b, 0x06, 0x9b, 
  0x93, 0x4a, 0xa8, 0x95, 0x2b, 0x60, 0x54, 0xc3, 0x4c, 0x70, 0xaf, 0x3a, 
  0x92, 0x1d, 0xca, 0x1b, 0x2a, 0x7e, 0x96, 0xc8, 0xad, 0x10, 0x49, 0xe1, 
  0x2e, 0x17, 0x28, 0x73, 0x3c, 0x6f, 0x94, 0xdd, 0xea, 0x8a, 0xa9, 0x31, 
  0xec, 0xcf, 0x7a, 0xc1, 0x89, 0x72, 0xc7, 0xee, 0xc1, 0xc9, 0xf9, 0x80, 
  0x6b, 0x57, 0x2a, 0x60, 0xd3, 0x05, 0x30, 0x77, 0x1d, 0x4a, 0xff, 0x1c, 
  0x62, 0x9a, 0x83, 0x7a, 0x78, 0xfe, 0x2e, 0x42, 0xd1, 0x08, 0xc3, 0x83, 
  0x1c, 0xe7, 0x4b, 0x86, 0xdb, 0xdb, 0x32, 0x26, 0x36, 0xfc, 0xc4, 0x45, 
  0x12, 0xe1, 0x6a, 0xb3, 0x22, 0xc0, 0x42, 0xfb, 0xb3, 0x30, 0x35, 0xa7, 
  0x06, 0x44, 0x5b, 0x89, 0x8a, 0x84, 0x1c, 0xa9, 0x8d, 0x08, 0xc5, 0xd1, 
  0xe8, 0xb2, 0xa5, 0xcb, 0x23, 0xa8, 0x49, 0xf2, 0x9b, 0x8d, 0x8d, 0x8b, 
  0xb3, 0xc3, 0xc3, 0x97, 0xd1, 0xf1, 0xd1, 0xeb, 0xa3, 0xcb, 0x40, 0x24, 
  0x77, 0x77, 0x89, 0xb0, 0xc8, 0x5c, 0xc0, 0x36, 0x6f, 0x5a, 0xcb, 0xe1, 
  0x01, 0x81, 0x14, 0x0a, 0x53, 0x6f, 0x73, 0xe2, 0xa6, 0xe2, 0x9d, 0x9b, 
  0x35, 0xdf, 0x83, 0xf2, 0x8d, 0xe4, 0xe1, 0x51, 0xf4, 0x65, 0x10, 0xac, 
  0x17, 0x95, 0x24, 0xdf, 0x8c, 0xb9, 0x64, 0x86, 0x5c, 0x13, 0x3f, 0x68, 
  0xe8, 0x40, 0x5d, 0x78, 0x52, 0x68, 0x0d, 0x57, 0x2b, 0x43, 0xe3, 0x2d, 
  0x1b, 0xa3, 0xe2, 0xb5, 0x4d, 0x24, 0x00, 0xb7, 0x5e, 0x1e, 0x86, 0xa1, 
  0xd6, 0x91, 0xb6, 0x36, 0x4f, 0x25, 0xd7, 0x24, 0x6e, 0xe0, 0x22, 0x99, 
  0x67, 0x1b, 0x9c, 0x3c, 0xec, 0x31, 0x38, 0x1f, 0x2e, 0xc8, 0xd3, 0xfa, 
  0x0a, 0x0b, 0x51, 0x3c, 0xda, 0x71, 0x31, 0xec, 0x52, 0xb8, 0x44, 0x85, 
  0x7d, 0xee, 0x6c, 0x37, 0x22, 0x91, 0x64, 0xc9, 0x72, 0x7d, 0xb1, 0xcc, 
  0x5a, 0x17, 0xde, 0x0f, 0xf2, 0x2e, 0xcd, 0xff, 0xd3, 0x1d, 0x5c, 0x70, 
  0xd3, 0xb8, 0x18, 0x92, 0xf0, 0xb5, 0x1a, 0x9a, 0x5d, 0x55, 0x28, 0x02, 
  0x10, 0xce, 0x99, 0x44, 0x4e, 0x21, 0xf1, 0xda, 0x97, 0xb6, 0x09, 0x05, 
  0x46, 0x9f, 0x88, 0x90, 0xc3, 0x59, 0x36, 0xd3, 0x23, 0xc0, 0x53, 0x1f, 
  0x44, 0xa8, 0xaf, 0xe7, 0x62, 0x72, 0x45, 0xdc, 0xb1, 0x83, 0x47, 0xed, 
  0xd8, 0x36, 0x7a, 0x36, 0xc5, 0x71, 0xea, 0xe0, 0xac, 0xdc, 0x6c, 0xca, 
  0xf3, 0xd4, 0xc9, 0xb4, 0xc5, 0xeb, 0x79, 0xb4, 0xfb, 0x19, 0x4f, 0xe4, 
  0xc3, 0x26, 0xc4, 0x70, 0xe1, 0x16, 0x60, 0x25, 0x1a, 0x43, 0xee, 0xb7, 
  0x53, 0x82, 0xe7, 0x81, 0xef, 0x2a, 0xcb, 0x6b, 0x91, 0x9a, 0x08, 0x24, 
  0x63, 0x15, 0x45, 0xbd, 0xbc, 0x30, 0x4e, 0xc1, 0xed, 0x2a, 0x52, 0x12, 
  0xea, 0x34, 0xc9, 0xc2, 0x04, 0x45, 0x69, 0x0b, 0x9f, 0x3b, 0x84, 0x75, 
  0x00, 0x84, 0x5c, 0x36, 0xb9, 0x4f, 0x27, 0x90, 0xac, 0xcd, 0x0e, 0x00, 
  0x02, 0x14, 0xea, 0x93, 0x00, 0x5e, 0x78, 0xd5, 0xe0, 0x8e, 0x73, 0x23, 
  0x53, 0x19, 0x06, 0xc5, 0xac, 0x60, 0x5f, 0xd8, 0x84, 0x08, 0xc1, 0x50, 
  0xf8, 0x75, 0xb7, 0x00, 0x73, 0xe7, 0x9e, 0xf4, 0x82, 0xfd, 0x28, 0xf2, 
  0xaa, 0x9a, 0x99, 0x65, 0xe1, 0xb5, 0x23, 0xec, 0xfa, 0x94, 0x39, 0xe5, 
  0x36, 0x98, 0xf5, 0xee, 0x0e, 0x89, 0xb0, 0xb3, 0xdc, 0x91, 0x95, 0x12, 
  0x55, 0x5b, 0x2d, 0xc5, 0xac, 0x86, 0x58, 0x9c, 0xdd, 0x9d, 0x6f, 0xd6, 
  0x2f, 0x3a, 0x47, 0xfc, 0x3e, 0xfc, 0xf2, 0xde, 0xe3, 0x07, 0xf6, 0xec, 
  0xb4, 0xe8, 0xa8, 0x34, 0xe0, 0xb0, 0xd0, 0xda, 0xbb, 0x46, 0x84, 0x9f, 
  0x5c, 0xc7, 0xa8, 0x2e, 0xf9, 0xc0, 0xe8, 0x2d, 0x87, 0xa0, 0x31, 0x94, 
  0xd7, 0x1a, 0x29, 0x2c, 0x5f, 0x96, 0x6c, 0x23, 0x5b, 0x00, 0x0f, 0xc2, 
  0x2b, 0xb2, 0x41, 0xd1, 0xe4, 0xa4, 0xfe, 0xb6, 0x70, 0xce, 0x41, 0x9d, 
  0x49, 0x18, 0xf1, 0x14, 0xc9, 0x35, 0xdc, 0xbc, 0xe0, 0xc1, 0xac, 0xf8, 
  0xd3, 0xe0, 0x86, 0x7a, 0x5e, 0x89, 0x37, 0x73, 0x4c, 0x8b, 0x90, 0x13, 
  0x18, 0xef, 0x38, 0x36, 0xa1, 0x55, 0x0b, 0xfe, 0x36, 0x2e, 0x06, 0xb6, 
  0xd0, 0x8e, 0x39, 0x0d, 0x0b, 0xdc, 0x60, 0x23, 0xf2, 0x15, 0x2c, 0x84, 
  0x64, 0xa5, 0x36, 0xc4, 0x08, 0xa9, 0x5a, 0x42, 0x27, 0x8e, 0xd9, 0x4b, 
  0xc9, 0x6f, 0x22, 0x32, 0xf1, 0x11, 0xa0, 0x81, 0x81, 0x12, 0x2d, 0x5a, 
  0x72, 0x5d, 0x31, 0xc7, 0x2f, 0x2d, 0x8d, 0x4f, 0xf0, 0xdb, 0xd8, 0xf2, 
  0x7f, 0x70, 0x7a, 0xf2, 0xea, 0xe8, 0x2b, 0x97, 0x7e, 0x2e, 0x4c, 0x7c, 
  0x59, 0xe5, 0x6c, 0xd9, 0x14, 0xb3, 0xa1, 0x2b, 0x5f, 0xe2, 0x5c, 0xb1, 
  0x0a, 0x05, 0xae, 0x01, 0xa1, 0xc4, 0x9e, 0xde, 0x86, 0x1f, 0x80, 0x81, 
  0x64, 0x8f, 0xd8, 0x5a, 0x2e, 0xd0, 0x7c, 0xe5, 0x96, 0xb7, 0x3d, 0x34, 
  0xe0, 0x10, 0x24, 0x6f, 0x20, 0x2e, 0xaa, 0xe5, 0xc2, 0xc5, 0xb5, 0x05, 
  0x50, 0xe2, 0x8a, 0xfa, 0xc3, 0xb7, 0x02, 0x49, 0x2f, 0xb4, 0xc9, 0xc2, 
  0x9a, 0xb4, 0x6e, 0x78, 0xcd, 0xb4, 0x2b, 0x77, 0x00, 0xdb, 0x16, 0x34, 
  0x97, 0x58, 0x2f, 0x80, 0x56, 0xb0, 0xc8, 0x2c, 0x67, 0x9f, 0x74, 0x10, 
  0xc3, 0x6d, 0xce, 0x1c, 0xae, 0x70, 0x22, 0x13, 0xc5, 0xa5, 0x91, 0x4a, 
  0xe4, 0xf0, 0x86, 0x40, 0x64, 0x49, 0xb1, 0xb6, 0x1f, 0x5c, 0x3d, 0x3b, 
  0x0d, 0x48, 0xf5, 0xce, 0x22, 0x07, 0xff, 0xec, 0x83, 0x66, 0x64, 0xb0, 
  0x08, 0x6e, 0x2b, 0x39, 0x72, 0xc1, 0x14, 0xf1, 0x17, 0xec, 0xa3, 0x79, 
  0xc6, 0xc8, 0x5e, 0x73, 0x81, 0x15, 0xd0, 0x88, 0x56, 0x97, 0x24, 0x99, 
  0x06, 0xe0, 0x5b, 0x16, 0x5f, 0x21, 0xf6, 0x3a, 0x2d, 0x27, 0xae, 0x44, 
  0x27, 0x06, 0x63, 0xb6, 0xb6, 0xf4, 0x3f, 0xe9, 0x5b, 0x09, 0x72, 0x4d, 
  0x06, 0x70, 0x89, 0xa9, 0xf6, 0x50, 0x45, 0xd3, 0x40, 0x34, 0x9b, 0x54, 
  0x78, 0x42, 0xd7, 0x81, 0x8d, 0xd2, 0x07, 0xf0, 0xf8, 0xf1, 0x0b, 0x56, 
  0x30, 0x7c, 0x45, 0x36, 0x0b, 0x24, 0x69, 0x33, 0x8b, 0x67, 0xc7, 0x58, 
  0xae, 0x54, 0xcd, 0x19, 0x82, 0x58, 0xa9, 0xfa, 0xd4, 0xd9, 0xed, 0x87, 
  0xea, 0xe4, 0x82, 0x94, 0x49, 0xe2, 0x0e, 0x9b, 0x87, 0xbf, 0xb3, 0x09, 
  0xf2, 0xdb, 0xf2, 0x85, 0x06, 0x8a, 0x5b, 0xaa, 0xf7, 0x86, 0x41, 0x6b, 
  0xd2, 0x50, 0xff, 0x22, 0xd6, 0x45, 0x71, 0xfe, 0xfd, 0x60, 0x9d, 0xdb, 
  0xa3, 0x8d, 0xa5, 0x27, 0x7a, 0x8a, 0x8b, 0x6b, 0xc5, 0x6a, 0x50, 0xb7, 
  0x1a, 0xd4, 0x44, 0x87, 0xae, 0xea, 0xac, 0x94, 0x2c, 0x94, 0xb8, 0x40, 
  0x0e, 0x88, 0x4f, 0x4b, 0x49, 0x34, 0xd3, 0xbc, 0x1c, 0xb1, 0x4f, 0x3a, 
  0x42, 0x0c, 0x38, 0xce, 0x27, 0x2e, 0x58, 0x22, 0xf6, 0x57, 0x99, 0x41, 
  0x26, 0x7a, 0x63, 0xad, 0xde, 0x65, 0xc1, 0x6b, 0x6c, 0xd1, 0x83, 0x2e, 
  0x9c, 0xa8, 0x19, 0x45, 0xba, 0x82, 0x2c, 0xc1, 0x20, 0x28, 0x48, 0x48, 
  0x49, 0x4a, 0xdf, 0x84, 0x7c, 0xff, 0x42, 0xd3, 0x74, 0xe9, 0x3c, 0x6b, 
  0xe2, 0xb5, 0x82, 0x48, 0x7c, 0xb6, 0xa3, 0xb6, 0xb8, 0x4a, 0x23, 0x28, 
  0xcb, 0x68, 0xff, 0xfc, 0x10, 0x08, 0x57, 0x48, 0xac, 0xe5, 0x11, 0x56, 
  0xba, 0x3f, 0x10, 0xad, 0x79, 0x15, 0xf4, 0x7c, 0x70, 0x87, 0xf7, 0xc1, 
  0x9b, 0x4c, 0x4c, 0x0a, 0x31, 0x49, 0x87, 0xcc, 0x85, 0x46, 0x31, 0xc9, 
  0x8d, 0x6f, 0x62, 0xce, 0xd9, 0x80, 0x6b, 0x71, 0x1a, 0x71, 0x9a, 0xab, 
  0x90, 0x14, 0x10, 0x8e, 0xae, 0xb3, 0xdc, 0xf0, 0xb1, 0xce, 0x5a, 0x6c, 
  0xdd, 0x40, 0x2b, 0xc3, 0xa0, 0x19, 0x9c, 0x6a, 0x1f, 0x1d, 0xff, 0x37, 
  0xc3, 0x7e, 0xd1, 0xbe, 0x6a, 0x3e, 0x50, 0x4f, 0x4e, 0x83, 0x6e, 0x03, 
  0xd2, 0xdf, 0x70, 0xcf, 0xb0, 0x2c, 0xd2, 0x14, 0x0b, 0x12, 0x17, 0xf4, 
  0x2d, 0xa6, 0xec, 0x49, 0x20, 0xfc, 0x4a, 0xca, 0x18, 0x87, 0xfd, 0x8a, 
  0x95, 0x9a, 0x85, 0x9f, 0xb8, 0xd4, 0xb4, 0x1c, 0x55, 0x08, 0x26, 0x7a, 
  0x56, 0x99, 0x2a, 0x38, 0x82, 0x95, 0x46, 0x3c, 0x17, 0xf8, 0xbe, 0x1a, 
  0x59, 0x74, 0x1b, 0x7a, 0x3f, 0x71, 0xb3, 0xf5, 0x63, 0x70, 0x5f, 0xf2, 
  0x47, 0x2f, 0xa2, 0x9e, 0x7a, 0x50, 0x79, 0x14, 0x23, 0xee, 0x08, 0x2c, 
  0x15, 0x0e, 0x54, 0xfe, 0x05, 0x1f, 0x23, 0x14, 0xcb, 0x10, 0x75, 0xc6, 
  0x71, 0x16, 0x60, 0x21, 0xe4, 0xea, 0x60, 0xf5, 0x03, 0x11, 0x2f, 0x1f, 
  0x38, 0xf4, 0x55, 0x28, 0x1a, 0x0f, 0xbf, 0xd9, 0x46, 0x95, 0x36, 0x7a, 
  0x90, 0xad, 0x39, 0x9c, 0x55, 0x6a, 0x07, 0xbe, 0x4c, 0x6a, 0x65, 0x1b, 
  0x5c, 0xf6, 0x4a, 0x6f, 0xd8, 0xa3, 0xb5, 0xe8, 0xcf, 0x66, 0x9e, 0xe1, 
  0xdb, 0x63, 0xbc, 0xab, 0x48, 0xf3, 0xf2, 0xf2, 0x92, 0xf2, 0x2e, 0x46, 
  0x38, 0x5c, 0xd5, 0xa2, 0xee, 0x19, 0x5d, 0x9c, 0x93, 0x52, 0x1c, 0x42, 
  0x03, 0x32, 0x17, 0x10, 0x29, 0x70, 0x97, 0x96, 0xe6, 0x89, 0x24, 0xda, 
  0x1e, 0x6b, 0x58, 0x84, 0x24, 0xf7, 0x26, 0xd5, 0x38, 0x58, 0xca, 0x64, 
  0x7c, 0x93, 0x4b, 0xa0, 0x27, 0x2d, 0x5a, 0x90, 0x19, 0xd8, 0x8b, 0xfe, 
  0x47, 0x69, 0xe0, 0x1b, 0x9f, 0x46, 0xc6, 0x84, 0x30, 0xa2, 0x4b, 0xb8, 
  0x60, 0x78, 0x23, 0x47, 0x10, 0x87, 0xdf, 0x5f, 0x9e, 0xef, 0x47, 0x5f, 
  0x1f, 0xee, 0xbf, 0x3c, 0x3c, 0xbf, 0x68, 0x5c, 0xfa, 0x9a, 0x35, 0x27, 
  0x02, 0x1a, 0x9b, 0x84, 0x21, 0x1a, 0x5b, 0xf2, 0xb3, 0x86, 0x92, 0x1b, 
  0xd7, 0x23, 0xe2, 0xe1, 0x83, 0x44, 0xe7, 0x83, 0x15, 0x22, 0x71, 0x1d, 
  0x54, 0x92, 0x88, 0xce, 0xcc, 0xc6, 0xb5, 0xa1, 0x95, 0x18, 0x9d, 0xfd, 
  0x3c, 0x4c, 0xe2, 0xf0, 0xa0, 0x2b, 0xfe, 0x32, 0x99, 0xe4, 0x96, 0x00, 
  0x5c, 0xdf, 0xb9, 0xaf, 0x7d, 0x12, 0x70, 0xc0, 0xb6, 0xf4, 0x92, 0x51, 
  0x1b, 0x62, 0xef, 0xfb, 0x21, 0xf5, 0x3b, 0xa4, 0xc5, 0x1f, 0xce, 0x93, 
  0x67, 0xd1, 0x2a, 0x29, 0x7b, 0x0d, 0x83, 0x60, 0xbd, 0xfb, 0x0d, 0x41, 
  0x18, 0x6e, 0x9d, 0xa4, 0xaf, 0x3b, 0x5b, 0xe2, 0xd3, 0x35, 0x63, 0xec, 
  0xdf, 0xa6, 0x06, 0x81, 0x4b, 0x35, 0x90, 0x91, 0xf5, 0x04, 0xb5, 0x32, 
  0x2e, 0x30, 0xdc, 0x38, 0x50, 0x33, 0x35, 0x60, 0x09, 0x03, 0xd1, 0x29, 
  0x40, 0xd6, 0x49, 0x2b, 0xbd, 0xd4, 0x61, 0x19, 0x31, 0xbc, 0x2e, 0x1a, 
  0x96, 0x3e, 0x14, 0xde, 0x0f, 0xf0, 0x86, 0x68, 0xe8, 0x78, 0x59, 0x73, 
  0x96, 0xaa, 0x69, 0x54, 0x91, 0x02, 0xb5, 0x39, 0x1e, 0x83, 0xa3, 0x79, 
  0x8b, 0x38, 0xe7, 0x2e, 0x0d, 0x92, 0x4d, 0xdf, 0x95, 0x30, 0x25, 0x56, 
  0xea, 0x61, 0xed, 0xe4, 0x40, 0x28, 0xd9, 0x78, 0x93, 0x57, 0x83, 0xf4, 
  0x94, 0x90, 0x98, 0x01, 0x44, 0x8e, 0x90, 0x66, 0xf7, 0x5c, 0x12, 0x7d, 
  0x9d, 0x97, 0xb8, 0x0b, 0xda, 0x8f, 0xf3, 0x25, 0xdf, 0xb5, 0xfc, 0x78, 
  0x43, 0x9d, 0x5d, 0x0e, 0x2a, 0x08, 0x08, 0x5e, 0x60, 0x5f, 0x67, 0xfb, 
  0x97, 0x5f, 0xc3, 0xd5, 0x0a, 0x12, 0x7e, 0x99, 0xb3, 0xbe, 0x63, 0x0e, 
  0xb6, 0x76, 0x96, 0x90, 0x53, 0xe0, 0x44, 0xfe, 0x35, 0x84, 0x1d, 0x57, 
  0xa9, 0x80, 0x5d, 0x79, 0x30, 0x52, 0x16, 0x09, 0x49, 0xb1, 0xa9, 0x9a, 
  0x1e, 0x3d, 0xc4, 0x93, 0x8b, 0xc7, 0x76, 0x29, 0x60, 0x2e, 0x20, 0xb0, 
  0x2f, 0xd9, 0xd1, 0x7d, 0x99, 0x13, 0x88, 0x9e, 0x85, 0x39, 0x56, 0x78, 
  0x42, 0x74, 0x2b, 0x7c, 0x61, 0x39, 0xd0, 0x03, 0xda, 0xd3, 0x6e, 0x00, 
  0x9b, 0xe0, 0x48, 0x7f, 0x31, 0x5f, 0x8d, 0xda, 0x00, 0x0a, 0xd1, 0x97, 
  0xcb, 0xaa, 0xce, 0x56, 0x1a, 0x18, 0x5b, 0x4e, 0xb2, 0x2c, 0xf2, 0xbc, 
  0xaa, 0xa3, 0x54, 0x61, 0x75, 0xe4, 0x44, 0x0b, 0x52, 0x91, 0x8c, 0x85, 
  0x9b, 0xca, 0x54, 0xee, 0x0e, 0x05, 0xc3, 0xf8, 0xaa, 0xcc, 0x67, 0xcb, 
  0x2a, 0x08, 0x09, 0xfe, 0x65, 0x63, 0x0e, 0x06, 0xbd, 0x79, 0x34, 0x4a, 
  0x8c, 0xa0, 0x38, 0xa6, 0xb5, 0x88, 0x49, 0xd3, 0xe7, 0x02, 0x7a, 0xec, 
  0x79, 0x2c, 0xf2, 0xac, 0x0e, 0xad, 0x8e, 0xe8, 0xe3, 0x2d, 0xbf, 0xd7, 
  0x74, 0x17, 0x26, 0xf7, 0x2c, 0xad, 0x9b, 0x44, 0xfc, 0x4a, 0xca, 0x17, 
  0x4b, 0xad, 0x61, 0x87, 0x17, 0x01, 0xc4, 0x81, 0xa9, 0xb3, 0x62, 0x71, 
  0xd1, 0x07, 0x38, 0xfe, 0x55, 0x5a, 0x07, 0x86, 0xab, 0x79, 0x0c, 0x25, 
  0xcb, 0x58, 0x91, 0x3c, 0xe9, 0xca, 0x2d, 0x73, 0xf9, 0x69, 0x49, 0x1f, 
  0x1a, 0xd2, 0xa4, 0x7b, 0xad, 0x3a, 0x83, 0x42, 0xfb, 0x16, 0x72, 0xd7, 
  0x5b, 0xf8, 0x9f, 0x84, 0x8f, 0x99, 0x23, 0xce, 0x86, 0x68, 0x37, 0x1e, 
  0xfb, 0xe9, 0x80, 0xc5, 0xa3, 0x25, 0xa3, 0x5c, 0xed, 0x35, 0x57, 0x26, 
  0xc0, 0xa4, 0x76, 0xbb, 0x3e, 0x2c, 0x8e, 0x7e, 0x23, 0x0a, 0xaa, 0xd8, 
  0xc8, 0xe0, 0xf5, 0x9e, 0x43, 0x5a, 0x32, 0x7c, 0x52, 0xf7, 0x71, 0x5a, 
  0x85, 0xd7, 0x9f, 0x69, 0xdd, 0xbe, 0x00, 0xf4, 0xd5, 0xaa, 0x16, 0x89, 
  0xe1, 0xf3, 0xae, 0xae, 0x39, 0xcc, 0x5e, 0xcd, 0x2f, 0x0a, 0xe6, 0x00, 
  0x5b, 0xcf, 0x4d, 0x0a, 0x16, 0x65, 0x6b, 0x6e, 0xb6, 0x2f, 0xd6, 0xdd, 
  0x61, 0xcb, 0xda, 0x88, 0x42, 0x6f, 0xa2, 0xf3, 0xf7, 0x8f, 0xda, 0xa4, 
  0x31, 0x72, 0x40, 0x50, 0xca, 0x2e, 0x8f, 0xc2, 0x8c, 0x5e, 0xac, 0x8a, 
  0x8b, 0x3a, 0xfd, 0xa0, 0xae, 0xc3, 0xfe, 0x38, 0x3d, 0x2c, 0x8b, 0xfc, 
  0x7a, 0x94, 0xc2, 0x37, 0xf7, 0x76, 0xa1, 0x7f, 0x49, 0x9c, 0x02, 0x70, 
  0x95, 0x9a, 0xd0, 0x46, 0xcd, 0x75, 0x47, 0x05, 0x2d, 0xc0, 0x76, 0x59, 
  0xb2, 0xb3, 0xfa, 0x55, 0x45, 0xfc, 0x09, 0x1c, 0x2c, 0x35, 0x7c, 0x6c, 
  0x49, 0xa0, 0x2d, 0xab, 0x62, 0x39, 0xae, 0x21, 0xdc, 0x80, 0x18, 0x1a, 
  0x05, 0x0f, 0x74, 0x79, 0xf3, 0x50, 0x85, 0xdd, 0x8c, 0x6b, 0xd9, 0x04, 
  0x56, 0x37, 0x22, 0xe8, 0x62, 0x2b, 0x3a, 0x62, 0xb0, 0x42, 0xad, 0x83, 
  0x08, 0x51, 0x9c, 0xc6, 0xef, 0x08, 0x6c, 0x78, 0xe6, 0x92, 0x99, 0x6b, 
  0x40, 0x41, 0x12, 0x19, 0x1e, 0x5c, 0x31, 0x2a, 0x6f, 0xe0, 0x7e, 0x2d, 
  0x22, 0x85, 0x2c, 0xc2, 0xed, 0xcd, 0x96, 0xb9, 0x0d, 0x07, 0x2b, 0x44, 
  0xdd, 0x0d, 0x7d, 0x29, 0x30, 0xea, 0x6f, 0x9b, 0x16, 0xd2, 0x40, 0x3d, 
  0x1d, 0x66, 0x53, 0xe9, 0xa1, 0x89, 0x1a, 0x31, 0x99, 0xc9, 0x8c, 0xa6, 
  0xec, 0xc4, 0x20, 0x39, 0x88, 0x73, 0x57, 0x3f, 0xdd, 0xea, 0x62, 0x59, 
  0x61, 0xb4, 0xc6, 0xad, 0xd9, 0xbe, 0x02, 0xce, 0x04, 0x16, 0xa2, 0x45, 
  0x44, 0x2f, 0xcd, 0x74, 0x08, 0x76, 0x82, 0x05, 0x63, 0x01, 0xde, 0x36, 
  0xe9, 0xe8, 0xcc, 0x75, 0x41, 0x43, 0xe0, 0x19, 0xf7, 0x67, 0xc9, 0x4e, 
  0x3f, 0x00, 0x9d, 0xda, 0x94, 0xe0, 0xeb, 0x1c, 0x42, 0x3e, 0x5b, 0xc9, 
  0x30, 0x41, 0x51, 0xd2, 0x39, 0xa0, 0x6b, 0xab, 0x63, 0x28, 0xd4, 0xc4, 
  0x2f, 0x1d, 0xcc, 0xee, 0xd3, 0xbd, 0xd1, 0xee, 0xa7, 0x9f, 0x8d, 0x76, 
  0x46, 0xbb, 0x3b, 0xcc, 0x59, 0x78, 0x28, 0xc1, 0xe0, 0x64, 0x5d, 0x3a, 
  0xba, 0xaa, 0xbd, 0xd7, 0xee, 0xf3, 0xe4, 0xf0, 0xf2, 0xbb, 0xd3, 0xf3, 
  0x6f, 0xa2, 0xa3, 0x93, 0xcb, 0xc3, 0xf3, 0x57, 0xfb, 0x07, 0x1f, 0x8a, 
  0x7d, 0x18, 0x5a, 0x67, 0x83, 0x4a, 0x45, 0x01, 0x1a, 0x57, 0xdb, 0x04, 
  0xe6, 0xd7, 0x2c, 0xa9, 0x6e, 0x76, 0x9e, 0xed, 0x3e, 0x08, 0xa1, 0xd7, 
  0x61, 0x05, 0xf3, 0xef, 0xdb, 0xa4, 0x76, 0x79, 0x52, 0xeb, 0x5b, 0x71, 
  0xb0, 0x49, 0x17, 0x12, 0x4f, 0xe4, 0x62, 0x51, 0xc1, 0xdf, 0x19, 0xcb, 
  0x55, 0x30, 0xad, 0x95, 0xa3, 0x5f, 0x49, 0x2d, 0x6f, 0x49, 0x6c, 0x54, 
  0xc0, 0x8d, 0x89, 0x5c, 0xff, 0xca, 0x6e, 0x39, 0x16, 0x77, 0x99, 0xce, 
  0x2a, 0xb5, 0x1a, 0x48, 0xcd, 0xd5, 0x09, 0x24, 0x99, 0xce, 0x1a, 0x7e, 
  0x28, 0x31, 0x21, 0x75, 0x0d, 0x27, 0x2e, 0x5e, 0xdf, 0xe5, 0x7f, 0xd7, 
  0xb2, 0x1e, 0x30, 0x56, 0x88, 0xeb, 0x74, 0x0f, 0xcd, 0x5a, 0x21, 0xa3, 
  0x0d, 0xc4, 0xb2, 0xd2, 0x62, 0x78, 0x31, 0xb1, 0x9a, 0x05, 0xf0, 0x40, 
  0x07, 0x82, 0xd3, 0x10, 0x8c, 0x46, 0xba, 0x82, 0xdc, 0x40, 0xec, 0xbc, 
  0xcc, 0xb3, 0x3a, 0x00, 0xae, 0x15, 0xd0, 0x45, 0x0c, 0xbb, 0x88, 0x39, 
  0x06, 0x10, 0xca, 0xad, 0x97, 0x35, 0x30, 0xa5, 0x48, 0x10, 0x68, 0xc3, 
  0xd7, 0x45, 0xa2, 0x44, 0x44, 0xe2, 0xa4, 0x88, 0xef, 0x19, 0x9b, 0x5b, 
  0xb2, 0x06, 0x7d, 0xec, 0x5e, 0x80, 0x7e, 0xcc, 0xf2, 0x81, 0x5f, 0xf3, 
  0xe8, 0xec, 0xf0, 0xf5, 0xd0, 0xaa, 0xd6, 0xd0, 0xef, 0x62, 0x73, 0x71, 
  0xf5, 0xdf, 0x63, 0x01, 0x37, 0xcf, 0x2c, 0x80, 0x04, 0x3c, 0x51, 0x03, 
  0x5e, 0xc2, 0x09, 0xf0, 0xa1, 0x11, 0xf5, 0x5b, 0x78, 0x2d, 0x1f, 0x46, 
  0x8b, 0x33, 0x74, 0x08, 0x63, 0x35, 0xc8, 0x2c, 0xde, 0x4f, 0x0d, 0xd2, 
  0x8d, 0x36, 0x5d, 0x60, 0x2a, 0xf7, 0x87, 0xe8, 0x4b, 0x38, 0xc7, 0x9d, 
  0x3f, 0x3c, 0xb7, 0x9c, 0xd7, 0xb3, 0x6f, 0x0e, 0x2e, 0x3e, 0xd9, 0xdd, 
  0xd3, 0xe1, 0x6c, 0x99, 0xf0, 0xcb, 0xbc, 0xaa, 0x99, 0x0e, 0x0d, 0x76, 
  0x1d, 0x8e, 0xd1, 0x92, 0x5b, 0x71, 0xc0, 0xb1, 0x19, 0x9b, 0x2e, 0x41, 
  0x63, 0xab, 0x96, 0xa1, 0x81, 0x68, 0xa7, 0x95, 0x93, 0xa4, 0x5c, 0x8d, 
  0x17, 0x36, 0xfc, 0xb3, 0x54, 0x03, 0x45, 0x99, 0x0e, 0x64, 0xe5, 0xc2, 
  0xdb, 0xe2, 0xcc, 0x3e, 0x92, 0x96, 0xb5, 0x35, 0x64, 0xef, 0xfa, 0x18, 
  0x8e, 0xe6, 0x9e, 0xf3, 0x7a, 0xfb, 0x6f, 0x19, 0x66, 0x4d, 0x2f, 0x75, 
  0x43, 0x47, 0xf1, 0xdd, 0xe0, 0x00, 0x68, 0xc4, 0xf6, 0xc4, 0xd0, 0x9a, 
  0x33, 0x8f, 0x28, 0xcb, 0x4f, 0x9f, 0xd2, 0x46, 0xd1, 0xc9, 0x92, 0x8c, 
  0x79, 0x66, 0x0a, 0x52, 0x92, 0xd8, 0x3d, 0xf2, 0xb2, 0x60, 0x0c, 0xdf, 
  0x85, 0xc4, 0x4e, 0x9e, 0x8c, 0xa2, 0xaf, 0x93, 0x8c, 0x53, 0x96, 0x39, 
  0xca, 0xcc, 0x72, 0x60, 0x10, 0x0b, 0xc7, 0x18, 0xf5, 0xf4, 0x36, 0x35, 
  0x95, 0xc4, 0x0a, 0x1d, 0x46, 0xbc, 0xae, 0x14, 0x45, 0xce, 0x40, 0xd3, 
  0x63, 0x8e, 0x48, 0xc3, 0x4d, 0xa4, 0xd6, 0x48, 0x94, 0x25, 0xe2, 0x72, 
  0x69, 0x68, 0x60, 0xb3, 0x0e, 0x00, 0x46, 0xdf, 0x6b, 0x73, 0x7a, 0xcc, 
  0xe1, 0x8d, 0x51, 0xe3, 0x29, 0xbf, 0x85, 0x50, 0x9d, 0x58, 0x14, 0x0b, 
  0xcf, 0x54, 0x26, 0xc5, 0x0d, 0x6b, 0xf8, 0x25, 0x5d, 0x37, 0x71, 0x36, 
  0x5e, 0x8d, 0x26, 0x09, 0x11, 0x10, 0x9d, 0xb6, 0xd1, 0xf2, 0x76, 0x3b, 
  0x38, 0xa6, 0xcc, 0xf2, 0x6f, 0x24, 0x3b, 0xbb, 0x6e, 0xdf, 0xb5, 0x4a, 
  0x33, 0x6d, 0xd8, 0xa4, 0xb8, 0x8e, 0x08, 0x9e, 0xa2, 0x96, 0x56, 0xec, 
  0x8f, 0xe7, 0x5a, 0xc0, 0xa1, 0xc3, 0xc8, 0xe1, 0x02, 0x72, 0x0b, 0xa3, 
  0x45, 0x32, 0x7f, 0xe6, 0x32, 0x41, 0x8d, 0x3f, 0x08, 0x6f, 0xf0, 0xf2, 
  0x73, 0x60, 0x8b, 0xcc, 0x92, 0xeb, 0x99, 0x0a, 0x14, 0xa1, 0x84, 0xee, 
  0x9a, 0xe8, 0x48, 0x77, 0x10, 0xb9, 0x5e, 0xcb, 0x05, 0x6f, 0xc0, 0x78, 
  0x36, 0x47, 0x75, 0x2f, 0x63, 0xfc, 0x5a, 0x23, 0xcc, 0x37, 0xa2, 0x98, 
  0x0d, 0x80, 0x28, 0x64, 0x31, 0x58, 0x2d, 0x19, 0x16, 0x7e, 0xa3, 0x5e, 
  0x16, 0xfa, 0x56, 0x28, 0x04, 0xb0, 0x93, 0x1a, 0x09, 0x0c, 0x1f, 0x9f, 
  0xd5, 0x62, 0x91, 0xb3, 0x42, 0x5f, 0xdf, 0x3d, 0x62, 0xc3, 0xee, 0xe5, 
  0xf1, 0xc5, 0x40, 0xe8, 0x41, 0xaa, 0x51, 0x07, 0x70, 0xc6, 0x9e, 0xfc, 
  0xd8, 0xcc, 0x21, 0xe1, 0x5a, 0x56, 0xba, 0xaf, 0x90, 0xd1, 0x08, 0x67, 
  0xf0, 0x0e, 0x21, 0x1f, 0xf4, 0x6f, 0x0b, 0xa1, 0xe1, 0xb3, 0x3c, 0x1c, 
  0x2b, 0x8c, 0x2b, 0x02, 0x91, 0xc3, 0xd9, 0x40, 0x81, 0x9b, 0x68, 0xf8, 
  0x68, 0x10, 0x0d, 0xf7, 0x00, 0x5f, 0xb2, 0x5b, 0x5f, 0x48, 0x1a, 0x1a, 
  0x09, 0xa2, 0x63, 0xc0, 0xa5, 0x6f, 0xb8, 0x92, 0xac, 0xc6, 0x12, 0x36, 
  0x95, 0xac, 0xef, 0xe8, 0x7d, 0xfe, 0xb1, 0xa7, 0x93, 0xba, 0xdb, 0x45, 
  0xa4, 0x32, 0xcb, 0xa3, 0x77, 0xc9, 0x6c, 0xd5, 0x16, 0x1b, 0xf6, 0x1e, 
  0xdc, 0x59, 0xe4, 0x04, 0xdc, 0xa7, 0x0e, 0x83, 0x51, 0x80, 0x5e, 0x61, 
  0xf5, 0xe3, 0x93, 0x4d, 0x7b, 0x65, 0x03, 0xa0, 0x65, 0x54, 0x7b, 0x6e, 
  0x16, 0xdd, 0xed, 0x99, 0x5b, 0x95, 0xbf, 0xb1, 0xc5, 0x13, 0xbb, 0xb4, 
  0x67, 0x24, 0xad, 0x14, 0x32, 0x0e, 0xef, 0x0a, 0x28, 0x97, 0x2e, 0x66, 
  0x0e, 0x4e, 0x24, 0x4e, 0x52, 0xe3, 0x34, 0xae, 0xa2, 0xbc, 0xa4, 0x1c, 
  0xc7, 0x99, 0x40, 0x44, 0x92, 0x2c, 0xec, 0x63, 0x7a, 0x10, 0xf1, 0x8c, 
  0x33, 0x4d, 0x12, 0x6c, 0xb9, 0x9c, 0x2b, 0xf2, 0x3b, 0x18, 0xf1, 0x00, 
  0xd7, 0x6d, 0x15, 0x11, 0x27, 0x4e, 0x25, 0xc4, 0x6d, 0x06, 0x61, 0x1a, 
  0x02, 0x96, 0x5a, 0x06, 0xfd, 0x42, 0xb1, 0xb9, 0x47, 0xf0, 0xcc, 0x40, 
  0x2f, 0x37, 0xa9, 0x28, 0xec, 0x08, 0xc8, 0xc4, 0x82, 0x11, 0xab, 0xe8, 
  0x47, 0x74, 0xfa, 0x96, 0xdc, 0x68, 0x95, 0x23, 0xe2, 0xd3, 0x09, 0x0c, 
  0x9a, 0xcf, 0x74, 0x01, 0xa9, 0x33, 0xea, 0x87, 0x4c, 0x72, 0xf8, 0x39, 
  0x2f, 0x42, 0xd9, 0xf7, 0xab, 0xa6, 0x98, 0xa2, 0xf5, 0x25, 0x50, 0x67, 
  0x00, 0xad, 0xb7, 0x34, 0x75, 0x56, 0x58, 0x29, 0xae, 0x7e, 0xf2, 0x8e, 
  0x45, 0xa4, 0xbe, 0xf5, 0x2b, 0xdf, 0x4b, 0x3e, 0x36, 0xd6, 0xf7, 0xec, 
  0xe8, 0x44, 0x0a, 0x3e, 0xb9, 0xb3, 0x94, 0xb0, 0xe4, 0x2d, 0xcf, 0x89, 
  0x20, 0x2c, 0xe6, 0x6c, 0x76, 0xd1, 0x89, 0x81, 0x85, 0x09, 0x8e, 0x0f, 
  0x49, 0x6a, 0xdd, 0x9d, 0x2f, 0x65, 0x04, 0x7d, 0xbe, 0x29, 0xcb, 0x72, 
  0xd6, 0xaf, 0x55, 0xc5, 0x08, 0x76, 0xb4, 0x71, 0x25, 0x39, 0xd3, 0xcd, 
  0xd8, 0x42, 0xdd, 0x36, 0xb4, 0xac, 0x12, 0xb7, 0x52, 0xe3, 0x94, 0x83, 
  0x46, 0xce, 0x5a, 0x68, 0x33, 0xfe, 0x24, 0x1a, 0x6d, 0x53, 0x87, 0xe5, 
  0xb6, 0xbd, 0xb8, 0xb8, 0x1d, 0x97, 0x74, 0x47, 0x72, 0x82, 0xe6, 0x8f, 
  0xd0, 0xc2, 0x61, 0x62, 0xa2, 0x21, 0x4f, 0x7e, 0x8a, 0x86, 0xe3, 0x99, 
  0xcc, 0x10, 0xb5, 0x8e, 0x7e, 0x24, 0xba, 0xe1, 0x27, 0x7e, 0xda, 0xe0, 
  0x94, 0xb0, 0x8b, 0x37, 0xaf, 0x19, 0xdf, 0x17, 0x65, 0x54, 0x2e, 0xcf, 
  0xf7, 0x4f, 0x2e, 0x5e, 0x89, 0x59, 0xf1, 0x32, 0x0f, 0x0a, 0xb4, 0xa8, 
  0x4d, 0xd6, 0x55, 0x1e, 0x33, 0xd8, 0x27, 0xae, 0x29, 0x11, 0x04, 0x26, 
  0x6b, 0xb1, 0x96, 0x41, 0x13, 0xfa, 0x54, 0x4a, 0xbf, 0x80, 0x61, 0xd3, 
  0x89, 0xda, 0x2c, 0xb7, 0xdc, 0xed, 0x5a, 0x86, 0x98, 0xe9, 0x1e, 0x6e, 
  0x4c, 0xb4, 0x14, 0xf7, 0x10, 0x9f, 0x99, 0x03, 0x1b, 0x8c, 0x7d, 0x2a, 
  0x0c, 0x7d, 0x2d, 0xba, 0xdf, 0x01, 0xe9, 0x1f, 0x43, 0x85, 0x6b, 0x0e, 
  0xb0, 0xe2, 0x9d, 0x29, 0x4a, 0x18, 0xba, 0x02, 0x73, 0xb9, 0xc6, 0xbd, 
  0xe7, 0xd6, 0x37, 0xbd, 0xf9, 0xfb, 0xdd, 0xad, 0xee, 0xe6, 0x2f, 0x7f, 
  0x69, 0xf3, 0xdd, 0x63, 0x37, 0x81, 0xdf, 0xe7, 0x66, 0x6c, 0xfe, 0x7e, 
  0x6f, 0xeb, 0xc1, 0x19, 0x85, 0x69, 0x65, 0xbe, 0x4f, 0x7a, 0x83, 0x07, 
  0x1b, 0xbd, 0xb0, 0xd2, 0x66, 0x7a, 0x11, 0xbb, 0xe8, 0x86, 0xa9, 0x07, 
  0x1c, 0xab, 0x65, 0xe0, 0x73, 0xec, 0xa3, 0x13, 0xff, 0xbc, 0xd3, 0x42, 
  0xc3, 0xf4, 0x51, 0x2c, 0xc9, 0x03, 0xb5, 0x91, 0x36, 0x1e, 0xf2, 0x3c, 
  0x4e, 0xfd, 0x2d, 0xf3, 0x11, 0xfa, 0xde, 0x7b, 0xa0, 0x6f, 0x3f, 0xbb, 
  0x40, 0xd7, 0x65, 0x0f, 0x20, 0x87, 0x10, 0xb1, 0x34, 0xbe, 0xcd, 0x65, 
  0xe6, 0xa5, 0x1f, 0xd7, 0xf7, 0x43, 0xfd, 0x5d, 0x1e, 0xbd, 0x3e, 0xe4, 
  0xda, 0x05, 0x2f, 0x8f, 0x18, 0x4b, 0xea, 0x42, 0xc1, 0xdc, 0x4c, 0xad, 
  0x75, 0x10, 0x97, 0x21, 0xe8, 0xb2, 0xb8, 0xc6, 0x5c, 0xa4, 0x8e, 0x3b, 
  0xff, 0x6e, 0x27, 0xb8, 0x6b, 0x8d, 0x26, 0x2d, 0x2d, 0x65, 0xed, 0x68, 
  0x3a, 0x7c, 0x9d, 0x4f, 0xa0, 0x7a, 0x0d, 0x05, 0xc4, 0x96, 0xde, 0xa2, 
  0x0f, 0xdf, 0x64, 0xf3, 0xda, 0xc7, 0x61, 0x62, 0x9c, 0x6a, 0xd5, 0x1b, 
  0xeb, 0x80, 0xa9, 0x7f, 0xde, 0x1e, 0x0e, 0x51, 0x7c, 0x4c, 0x22, 0x62, 
  0xd4, 0x2e, 0x5e, 0xcb, 0xb7, 0xb7, 0xb3, 0x4f, 0xeb, 0x93, 0xce, 0x56, 
  0xe2, 0xc3, 0x8d, 0x7d, 0xe4, 0x8d, 0xcf, 0x82, 0xbb, 0x46, 0xd9, 0x64, 
  0x67, 0x31, 0x12, 0x9b, 0xd0, 0x46, 0x0d, 0x27, 0x90, 0x85, 0xf3, 0xe4, 
  0xde, 0x47, 0x8e, 0x68, 0x39, 0x8e, 0x7c, 0xb1, 0xc2, 0x24, 0xef, 0x6b, 
  0x5e, 0xe9, 0x4e, 0xd7, 0xd4, 0xcf, 0xf2, 0x4e, 0x0d, 0x8a, 0x5d, 0x7a, 
  0x08, 0x09, 0x50, 0x3f, 0x51, 0xe4, 0xf2, 0xd3, 0x22, 0x60, 0x60, 0x3a, 
  0xec, 0xd8, 0x7c, 0xea, 0x1e, 0x39, 0x30, 0x80, 0x3c, 0xac, 0x8f, 0xd3, 
  0xa3, 0x1d, 0x6e, 0xf0, 0xdd, 0x36, 0x62, 0x33, 0xb1, 0xf9, 0x15, 0x88, 
  0xeb, 0x18, 0x1c, 0x82, 0x66, 0x09, 0x25, 0x9a, 0x99, 0x67, 0xf9, 0xb9, 
  0xfd, 0x61, 0x1f, 0x38, 0xbc, 0x69, 0xd6, 0x31, 0x99, 0xe1, 0x2f, 0x9f, 
  0x4d, 0xcb, 0x6b, 0x15, 0xf5, 0xa6, 0x9c, 0xe4, 0xce, 0x2e, 0x80, 0x9e, 
  0x0c, 0x40, 0x70, 0x1f, 0x84, 0xb6, 0x48, 0xa8, 0x67, 0xb6, 0x66, 0xca, 
  0x89, 0x28, 0x6a, 0x2e, 0xac, 0xd0, 0xd9, 0x4a, 0xc5, 0xd2, 0xc5, 0x7c, 
  0x74, 0xb9, 0x98, 0xc0, 0x9f, 0x2d, 0xb1, 0x7c, 0x2b, 0x2e, 0x8e, 0x58, 
  0x4c, 0xe2, 0x55, 0xc7, 0xe0, 0xdd, 0x77, 0x1f, 0x3a, 0x74, 0x1f, 0x0d, 
  0x8e, 0xeb, 0x54, 0xd3, 0x26, 0x89, 0xe1, 0xb0, 0x3f, 0x4b, 0x4a, 0x8d, 
  0x71, 0x11, 0x68, 0x20, 0x52, 0x41, 0x9a, 0x10, 0x6b, 0x93, 0x95, 0xbd, 
  0x70, 0x98, 0xf9, 0xfc, 0xc4, 0x46, 0x34, 0xbe, 0x49, 0x14, 0x42, 0xda, 
  0x9b, 0xdc, 0xe2, 0x02, 0xd5, 0x3d, 0xea, 0x1b, 0x93, 0x56, 0xb6, 0x17, 
  0x1c, 0x8a, 0xc0, 0x1b, 0x42, 0x44, 0xfe, 0xf2, 0xe8, 0xe0, 0xd2, 0x20, 
  0xcb, 0xa6, 0x7c, 0x87, 0x16, 0xab, 0x0f, 0x2b, 0x61, 0xf0, 0xe0, 0x33, 
  0x93, 0x67, 0x37, 0x09, 0xc9, 0x62, 0xd9, 0xd5, 0xf2, 0xfa, 0xd9, 0x5f, 
  0xe3, 0xe2, 0x3a, 0x28, 0x71, 0xb6, 0xe6, 0xf9, 0x09, 0xb2, 0x71, 0x9e, 
  0x11, 0x57, 0xda, 0x7d, 0xba, 0xfb, 0x48, 0x42, 0xbd, 0x53, 0x2e, 0xad, 
  0x02, 0xa6, 0xd0, 0x9f, 0xf7, 0x25, 0x63, 0x1e, 0x41, 0xe6, 0x2e, 0x4d, 
  0x3e, 0x9b, 0xf4, 0x45, 0xd1, 0x8a, 0xc3, 0x67, 0x27, 0xfa, 0xac, 0xa4, 
  0xed, 0xf6, 0x01, 0xd4, 0x40, 0x8f, 0x73, 0x8e, 0xdb, 0x72, 0xd1, 0x1f, 
  0xd5, 0x8e, 0xf5, 0x7b, 0xe6, 0xca, 0x5d, 0xb8, 0x8a, 0x0d, 0x07, 0xc2, 
  0x88, 0x95, 0x87, 0x5e, 0x15, 0x49, 0x7c, 0xeb, 0x40, 0xdc, 0x83, 0x74, 
  0x7a, 0x33, 0x9a, 0x73, 0x85, 0x39, 0xa0, 0x10, 0x5a, 0xb2, 0x09, 0x96, 
  0x3a, 0x72, 0x96, 0xf6, 0x2d, 0x1e, 0xe5, 0x7b, 0xfa, 0xe7, 0x68, 0xf0, 
  0x67, 0x93, 0xab, 0x0f, 0x78, 0x88, 0x0e, 0x9b, 0xe0, 0x3d, 0xed, 0xd7, 
  0x91, 0xcf, 0x59, 0xda, 0xaf, 0x98, 0xd4, 0x50, 0x7d, 0x87, 0xa8, 0x60, 
  0x53, 0xaa, 0xc4, 0x88, 0xd5, 0x5a, 0x2a, 0x81, 0x6a, 0x61, 0x32, 0x35, 
  0x13, 0xd0, 0xb8, 0xb9, 0xf0, 0xca, 0xcb, 0xfd, 0xb3, 0x40, 0x63, 0x82, 
  0x46, 0xe2, 0xad, 0x43, 0xfc, 0x1c, 0x4b, 0xcb, 0x61, 0x61, 0xb4, 0x81, 
  0x97, 0x73, 0x2b, 0x30, 0xc7, 0xc9, 0x5d, 0x2c, 0x21, 0xc5, 0xb9, 0xde, 
  0x21, 0x30, 0x64, 0x00, 0x4a, 0x79, 0x36, 0x89, 0xe1, 0x38, 0xd2, 0x9b, 
  0x07, 0x42, 0x38, 0xda, 0x4a, 0x35, 0x7a, 0x84, 0xf6, 0xe6, 0x5d, 0xa4, 
  0x61, 0xef, 0x1a, 0xdf, 0x2f, 0xbf, 0xcb, 0x63, 0x9c, 0xd2, 0xb9, 0xb2, 
  0x09, 0x08, 0x53, 0xa6, 0xc1, 0xc7, 0xe5, 0x2d, 0xf1, 0x4f, 0x71, 0x78, 
  0x52, 0xef, 0xe9, 0x38, 0x31, 0x6b, 0xea, 0x24, 0x95, 0xc0, 0x03, 0x5f, 
  0xf8, 0x3b, 0xdc, 0x30, 0xb9, 0x76, 0x58, 0x6d, 0x99, 0x95, 0x89, 0x00, 
  0x8f, 0x45, 0x97, 0xf7, 0xb9, 0x88, 0x9a, 0x2e, 0xa5, 0x5e, 0x22, 0xf7, 
  0xca, 0x65, 0x2a, 0xd8, 0x05, 0x56, 0xf8, 0xfc, 0xc4, 0xa7, 0x7c, 0xf4, 
  0x9c, 0x09, 0xe5, 0xa5, 0xf3, 0x13, 0x5d, 0xbc, 0xfc, 0x26, 0xe2, 0x64, 
  0x64, 0xee, 0xe3, 0x80, 0xe1, 0xcb, 0xd9, 0xe5, 0x3b, 0x87, 0x0a, 0xf1, 
  0xd5, 0x92, 0xcf, 0xfb, 0xc1, 0x4d, 0xbc, 0x60, 0x49, 0x78, 0x77, 0x87, 
  0xf5, 0xee, 0xef, 0x2c, 0xad, 0x89, 0x0f, 0xaa, 0x55, 0x38, 0x2a, 0x7b, 
  0x81, 0x4a, 0x3e, 0x21, 0x55, 0x7a, 0xc6, 0x92, 0x70, 0xdd, 0xda, 0x47, 
  0x57, 0x66, 0xb9, 0x4d, 0xe4, 0xb9, 0x8c, 0x67, 0x25, 0x91, 0x46, 0x51, 
  0x4e, 0x6e, 0xb7, 0xc7, 0xf4, 0xcf, 0xa3, 0x9d, 0x6d, 0x60, 0xe1, 0x55, 
  0x30, 0x8e, 0x31, 0x4d, 0xee, 0xed, 0x3d, 0x79, 0x32, 0x88, 0x7a, 0xae, 
  0xae, 0x1d, 0x93, 0xef, 0x2b, 0xb0, 0x99, 0x5e, 0x28, 0xc7, 0x14, 0xd3, 
  0xf1, 0x30, 0x21, 0xde, 0x99, 0x17, 0x20, 0x32, 0xfa, 0x93, 0xff, 0xc7, 
  0x2f, 0x73, 0x9e, 0x83, 0xe1, 0x3b, 0xdc, 0xe8, 0xdd, 0x0a, 0x3f, 0x94, 
  0x83, 0xbc, 0x30, 0xe2, 0xba, 0xa7, 0xdd, 0x30, 0xb3, 0x04, 0x7b, 0x20, 
  0x16, 0x49, 0xbe, 0x30, 0x9f, 0xda, 0x7c, 0xa5, 0x37, 0x0d, 0x28, 0x2d, 
  0xaa, 0x65, 0x2a, 0xde, 0x48, 0x10, 0x91, 0xe6, 0x91, 0x97, 0xcb, 0xab, 
  0xa1, 0x26, 0x54, 0x8a, 0x9a, 0x91, 0xd2, 0xf9, 0x9d, 0x73, 0xe1, 0x57, 
  0xb5, 0xfe, 0xb6, 0x78, 0xf2, 0x97, 0x51, 0x4f, 0x29, 0x8c, 0x7f, 0x8c, 
  0xe0, 0x12, 0x4b, 0xc6, 0x5c, 0x4c, 0x23, 0x7f, 0xa1, 0x7f, 0xfc, 0xf9, 
  0xcf, 0xd4, 0xec, 0x9f, 0xb9, 0x95, 0x17, 0xbf, 0x2f, 0xab, 0x9b, 0xe0, 
  0x99, 0x9e, 0x92, 0xfd, 0x91, 0x77, 0x08, 0x22, 0xc8, 0x07, 0x78, 0x91, 
  0x48, 0xfc, 0x79, 0x7d, 0xac, 0x7c, 0x79, 0x10, 0xcc, 0x2f, 0x45, 0x4a, 
  0x96, 0xd8, 0xdc, 0x9c, 0x8f, 0xfd, 0x4b, 0x76, 0xd6, 0x25, 0x9c, 0xc9, 
  0x4b, 0xb4, 0x08, 0x40, 0xb0, 0x2d, 0x93, 0x2e, 0x0e, 0x4f, 0xbe, 0x3d, 
  0x3a, 0x3f, 0x3d, 0x79, 0x7d, 0x78, 0x72, 0x19, 0x7d, 0xbb, 0x7f, 0x7e, 
  0xb4, 0xff, 0xe5, 0xb1, 0x26, 0x0c, 0xf3, 0x14, 0x38, 0x34, 0x42, 0xa4, 
  0xee, 0x06, 0x9c, 0x63, 0x90, 0xc0, 0xd1, 0x89, 0x5e, 0xde, 0xa8, 0x57, 
  0xf4, 0x56, 0xe1, 0x81, 0x61, 0x5e, 0x7d, 0x0b, 0xd8, 0xfa, 0x01, 0xfb, 
  0xfb, 0xec, 0x57, 0x81, 0xc0, 0x7f, 0x6b, 0x78, 0xf6, 0x6c, 0xc4, 0x5c, 
  0x05, 0x09, 0xa9, 0x1c, 0xc3, 0xc1, 0x94, 0x6b, 0x3c, 0xcb, 0x17, 0xc6, 
  0x50, 0x44, 0xf7, 0x51, 0xf4, 0x95, 0xe4, 0x34, 0x6b, 0x34, 0x91, 0x7b, 
  0x55, 0xf3, 0x6b, 0xd4, 0xa8, 0x23, 0xff, 0xb9, 0x5f, 0xf6, 0x8f, 0x8f, 
  0x7d, 0x97, 0xfb, 0x22, 0xe1, 0x0e, 0x7d, 0x6a, 0xb0, 0x55, 0x05, 0x42, 
  0x15, 0x6d, 0xc1, 0x5a, 0x91, 0x54, 0x98, 0x1b, 0xab, 0x4a, 0x76, 0x9d, 
  0x7b, 0x04, 0xe4, 0x6c, 0x15, 0x82, 0x1d, 0x73, 0xa7, 0xb4, 0x49, 0x9b, 
  0x02, 0x48, 0xc0, 0x4e, 0x48, 0x3a, 0x5c, 0x69, 0x79, 0x3b, 0x88, 0xfa, 
  0xbf, 0xef, 0x4b, 0x8e, 0x52, 0x02, 0x2c, 0x50, 0xb4, 0x5e, 0xfa, 0x5a, 
  0x64, 0xd1, 0xc9, 0xa9, 0x1f, 0xd3, 0x11, 0x02, 0xe2, 0x99, 0xc4, 0x10, 
  0xff, 0x58, 0x38, 0x9c, 0x99, 0x44, 0x53, 0x7b, 0x87, 0xf0, 0x71, 0x4b, 
  0x9c, 0x36, 0x86, 0x69, 0x2d, 0x7b, 0xaf, 0x69, 0x99, 0x38, 0x80, 0x3e, 
  0xc0, 0xbf, 0x92, 0xb2, 0x16, 0x8f, 0x03, 0x68, 0x57, 0xb1, 0xe1, 0xb0, 
  0xda, 0x0b, 0x51, 0x40, 0x4b, 0x0f, 0xca, 0xba, 0xb2, 0x75, 0x48, 0x1d, 
  0x53, 0xcb, 0x52, 0x59, 0x28, 0x08, 0xea, 0xdd, 0xb6, 0x62, 0x2b, 0x8b, 
  0xb7, 0x8a, 0x03, 0xa8, 0x8b, 0x74, 0xa2, 0x48, 0x61, 0x9d, 0x04, 0x31, 
  0x82, 0x93, 0xe3, 0xfc, 0x00, 0xa8, 0xca, 0x59, 0xfa, 0x2e, 0x00, 0xa1, 
  0x97, 0x60, 0x4b, 0x62, 0x23, 0x05, 0xe7, 0x30, 0x65, 0x2a, 0x85, 0x20, 
  0x80, 0x11, 0x82, 0x79, 0x7c, 0x9d, 0x9b, 0xd0, 0x1d, 0x3b, 0xcf, 0xab, 
  0xe4, 0x26, 0x49, 0x6c, 0x8a, 0xc9, 0x5e, 0x0e, 0x0a, 0xc8, 0x19, 0xbf, 
  0xe0, 0xa3, 0x35, 0x53, 0x33, 0xc7, 0xe3, 0x54, 0x01, 0x66, 0x79, 0x19, 
  0x24, 0xb6, 0xfa, 0x70, 0x6f, 0x66, 0x23, 0xe2, 0x9d, 0x34, 0x6c, 0x1e, 
  0x20, 0x20, 0x59, 0x22, 0x2c, 0x22, 0xc3, 0x30, 0x2c, 0x7e, 0x10, 0x4d, 
  0x6a, 0x90, 0x1f, 0x9a, 0x34, 0x2b, 0x28, 0x1d, 0x9c, 0x19, 0xe7, 0xdc, 
  0x18, 0x13, 0x8a, 0xa3, 0xab, 0xf4, 0x3a, 0x32, 0x03, 0x48, 0xc4, 0xa4, 
  0x00, 0x9c, 0xa6, 0x7c, 0x9e, 0xf0, 0x56, 0x01, 0x85, 0x09, 0x12, 0xfb, 
  0x0d, 0xd7, 0xcd, 0xf4, 0xb0, 0x41, 0x36, 0x93, 0x92, 0x23, 0xd2, 0x9d, 
  0x01, 0x4d, 0x6c, 0xe8, 0x4b, 0x5e, 0x46, 0x8b, 0xde, 0x51, 0x84, 0x61, 
  0x8d, 0x65, 0x62, 0xe3, 0x2c, 0xf0, 0xce, 0x32, 0x64, 0x4e, 0x58, 0x1e, 
  0x2a, 0x96, 0xc1, 0xe2, 0x3c, 0x99, 0x4f, 0xc0, 0xa4, 0x92, 0xcc, 0xa6, 
  0xd1, 0xa6, 0x83, 0x08, 0x46, 0x0d, 0x56, 0xc1, 0x58, 0x64, 0xc2, 0x96, 
  0x30, 0xec, 0x1a, 0x90, 0xbf, 0xed, 0x95, 0x62, 0xe1, 0x4c, 0xa5, 0xd6, 
  0x27, 0x0d, 0x6f, 0x33, 0x60, 0x39, 0x19, 0x51, 0x88, 0x3c, 0x26, 0x4a, 
  0xa3, 0xfe, 0x35, 0x14, 0xbf, 0x25, 0x1d, 0x54, 0x75, 0x60, 0x6e, 0x79, 
  0xdf, 0xb5, 0x48, 0x01, 0x4c, 0xaa, 0x92, 0x90, 0xa2, 0xe2, 0x31, 0x6d, 
  0x97, 0x99, 0xa0, 0x42, 0x0b, 0x56, 0x64, 0x09, 0x0a, 0xb3, 0x59, 0x80, 
  0x11, 0x2c, 0x36, 0x88, 0xb8, 0x25, 0x7c, 0xb8, 0x52, 0x9a, 0xfb, 0x1a, 
  0x2a, 0x21, 0x78, 0xa2, 0xc1, 0x4c, 0x34, 0x08, 0x97, 0xc5, 0xb3, 0x86, 
  0x61, 0x2c, 0xe0, 0x65, 0xe6, 0x67, 0x0d, 0x81, 0x5d, 0x15, 0xa4, 0x3e, 
  0x8d, 0xe7, 0x22, 0x3c, 0x7a, 0xea, 0x9b, 0xaf, 0x24, 0x4c, 0x6b, 0x63, 
  0xe3, 0xe0, 0xcd, 0xc5, 0xe5, 0xe9, 0xeb, 0xe8, 0xf4, 0xcd, 0xe5, 0xd9, 
  0x9b, 0x4b, 0xbd, 0xb4, 0xae, 0x24, 0x90, 0x55, 0x14, 0x43, 0x91, 0x02, 
  0x6c, 0x37, 0xe7, 0xea, 0x3c, 0x46, 0x98, 0x42, 0x0e, 0x6c, 0xb0, 0x00, 
  0x8e, 0xc5, 0x25, 0xb1, 0x00, 0xec, 0x51, 0x20, 0x47, 0xb1, 0xe6, 0xf7, 
  0xb4, 0xe6, 0x48, 0x41, 0x84, 0x41, 0xc7, 0x72, 0x62, 0xa0, 0xec, 0x74, 
  0x17, 0x7c, 0x58, 0xd5, 0x95, 0x17, 0xb8, 0x79, 0xeb, 0xb0, 0x37, 0x3e, 
  0xf0, 0xc4, 0x0c, 0x3a, 0xde, 0xde, 0x13, 0xc6, 0xc0, 0x21, 0xfa, 0x63, 
  0x5c, 0x99, 0x19, 0xd3, 0xc2, 0x10, 0x11, 0x70, 0x52, 0xcf, 0xc5, 0x0a, 
  0x53, 0xc2, 0xaa, 0x9c, 0x66, 0x78, 0xe3, 0x42, 0x88, 0x39, 0x5a, 0x1a, 
  0xa1, 0x53, 0xe2, 0x8a, 0xe7, 0x18, 0x25, 0xab, 0x5a, 0x79, 0xcf, 0xc6, 
  0xef, 0xd6, 0x05, 0x7b, 0x1f, 0xf5, 0xbf, 0x4b, 0xc2, 0x06, 0x7f, 0xfb, 
  0x77, 0xce, 0x74, 0x7b, 0x6b, 0x9f, 0xfc, 0x43, 0xba, 0xfc, 0x4b, 0xd6, 
  0x47, 0xc4, 0x51, 0xdd, 0xe7, 0xfa, 0xcd, 0xe1, 0xf9, 0x97, 0x87, 0xe7, 
  0xa7, 0x17, 0x8f, 0x11, 0x78, 0x62, 0x46, 0xae, 0x36, 0xb5, 0xdf, 0x26, 
  0xc5, 0x55, 0x52, 0xe4, 0xe5, 0x63, 0x57, 0xda, 0xc1, 0x97, 0x94, 0x86, 
  0x3e, 0x94, 0x59, 0xda, 0x93, 0x3d, 0x49, 0x14, 0x30, 0xbe, 0x25, 0x76, 
  0x09, 0x37, 0x4d, 0xcb, 0x93, 0x69, 0x96, 0x58, 0x76, 0x61, 0x6a, 0xda, 
  0x15, 0x37, 0xec, 0x20, 0x73, 0x1c, 0xa9, 0xbe, 0x62, 0xb3, 0xf1, 0xc0, 
  0xc5, 0x25, 0xdd, 0x16, 0x57, 0x43, 0x22, 0xe9, 0x5b, 0x2b, 0x4b, 0x26, 
  0xd1, 0xe1, 0xc4, 0x0f, 0x25, 0x6c, 0xd4, 0x9b, 0x11, 0x6e, 0x99, 0xfc, 
  0xb9, 0x0a, 0x81, 0x95, 0x9d, 0x90, 0x8a, 0x52, 0x16, 0x05, 0xc8, 0x1c, 
  0xf4, 0xa1, 0xcc, 0x7d, 0xea, 0xe7, 0xb1, 0xab, 0x5f, 0x23, 0x46, 0x2c, 
  0xfe, 0xc8, 0x61, 0x17, 0x69, 0xf1, 0x02, 0x44, 0x0e, 0x4d, 0x49, 0xc2, 
  0x5e, 0xdc, 0x4f, 0xf4, 0x92, 0x00, 0x90, 0x6c, 0x26, 0x46, 0x6c, 0xe1, 
  0xd1, 0x4d, 0x57, 0x06, 0x17, 0xdc, 0x41, 0x04, 0xbb, 0xc6, 0xe7, 0x46, 
  0x57, 0xb3, 0x38, 0xbb, 0xc5, 0x6d, 0x85, 0xdb, 0x87, 0x75, 0x4a, 0x1b, 
  0x2a, 0x97, 0x27, 0x82, 0xe7, 0x4a, 0x93, 0xe5, 0x21, 0xdf, 0xcd, 0x98, 
  0x7b, 0xad, 0xac, 0x62, 0xad, 0xda, 0x02, 0x02, 0x1f, 0x0d, 0x8e, 0x8b, 
  0xd6, 0x18, 0x92, 0x6a, 0xb2, 0x2e, 0xde, 0x1e, 0x2a, 0xb7, 0x94, 0x8b, 
  0xb5, 0xa8, 0x11, 0x49, 0x31, 0x4b, 0xc1, 0xa3, 0x84, 0x2f, 0x18, 0xba, 
  0x31, 0xfc, 0x0b, 0xa0, 0x03, 0xe4, 0xd2, 0x95, 0xae, 0x04, 0x80, 0xf2, 
  0x64, 0xe1, 0x4f, 0x00, 0xef, 0xf3, 0x15, 0x01, 0xc2, 0x72, 0x11, 0x0a, 
  0xb6, 0x7c, 0xe0, 0x63, 0x46, 0x62, 0xfb, 0x4e, 0x06, 0xe1, 0x65, 0x4d, 
  0xe7, 0x85, 0xaa, 0x05, 0xfa, 0xaf, 0xdd, 0x21, 0x79, 0xbd, 0x4b, 0xbf, 
  0x07, 0x7f, 0xcb, 0xb4, 0x2a, 0xb0, 0x87, 0x49, 0xb1, 0xe8, 0xcd, 0x7a, 
  0xc4, 0xa4, 0x0d, 0x5c, 0x2b, 0x8b, 0x27, 0x25, 0xe2, 0x9a, 0xc4, 0xb1, 
  0x84, 0x68, 0x3f, 0xbd, 0x5b, 0xab, 0x09, 0x98, 0x49, 0x51, 0x43, 0x92, 
  0x0c, 0x03, 0x15, 0x25, 0x95, 0x1f, 0xa6, 0x3e, 0x09, 0x5d, 0x87, 0x82, 
  0xe2, 0x84, 0xd6, 0xe1, 0x09, 0xdf, 0x04, 0xf9, 0xf0, 0x6a, 0x09, 0x95, 
  0xcb, 0x63, 0x4e, 0x69, 0x3a, 0x1b, 0x69, 0x62, 0x02, 0x32, 0x85, 0xef, 
  0xd9, 0x5f, 0x81, 0x54, 0x61, 0x71, 0x61, 0x20, 0x73, 0xac, 0x0e, 0x40, 
  0xe2, 0x60, 0x27, 0x24, 0x1c, 0x1b, 0x61, 0xa9, 0x1a, 0x7b, 0xab, 0x23, 
  0xd4, 0x4d, 0x76, 0xa1, 0x64, 0x99, 0xd6, 0xcf, 0x82, 0xed, 0xbc, 0x1e, 
  0x7c, 0xea, 0x2a, 0x07, 0x13, 0xd3, 0xe2, 0xf9, 0x26, 0x8a, 0xd1, 0x6c, 
  0x51, 0xa5, 0x16, 0xc3, 0x7e, 0x57, 0x71, 0xe5, 0x15, 0x49, 0x99, 0x8f, 
  0x67, 0x82, 0xa2, 0xbf, 0xf6, 0x92, 0x90, 0x73, 0x54, 0x5d, 0x5e, 0xfe, 
  0x70, 0x76, 0xf8, 0xc2, 0xde, 0x7c, 0x68, 0xcf, 0x04, 0x48, 0x0a, 0x71, 
  0x15, 0x89, 0x82, 0x09, 0x06, 0xf5, 0xde, 0x88, 0xc8, 0x86, 0x95, 0xf9, 
  0x7b, 0xa5, 0x9b, 0x61, 0xf4, 0xfd, 0xcb, 0xa3, 0x8b, 0xb3, 0xe3, 0xd3, 
  0x83, 0x17, 0xcf, 0xbf, 0x37, 0x66, 0xfb, 0x39, 0x23, 0xa7, 0x88, 0x04, 
  0xe6, 0x3e, 0xf3, 0x99, 0xee, 0xfa, 0xde, 0xc9, 0xe1, 0x77, 0x6f, 0x49, 
  0xe4, 0x7f, 0xc1, 0xa0, 0xcb, 0x83, 0xbb, 0x78, 0xa6, 0x2f, 0xb1, 0xde, 
  0xd4, 0x21, 0xb5, 0x05, 0x49, 0x09, 0x5d, 0x0b, 0x8b, 0x12, 0x71, 0x1e, 
  0x01, 0x73, 0x05, 0x21, 0x58, 0x43, 0xad, 0x82, 0xca, 0x2d, 0x71, 0x2d, 
  0xc3, 0xb0, 0xa3, 0x4c, 0x5b, 0xee, 0x2e, 0xf6, 0x7e, 0x25, 0x21, 0x77, 
  0xec, 0x66, 0x0e, 0xbd, 0xb7, 0x08, 0xd0, 0xd4, 0x6f, 0x7c, 0x68, 0xa3, 
  0xc2, 0x9b, 0x16, 0x1c, 0xe4, 0x60, 0x20, 0x39, 0xda, 0xb1, 0xf8, 0x45, 
  0x25, 0x87, 0xc9, 0x10, 0x69, 0xb2, 0x89, 0x0f, 0x2c, 0x36, 0x0e, 0xa6, 
  0xd2, 0x89, 0x1b, 0x4b, 0x3c, 0x1e, 0xd3, 0x0f, 0xc6, 0xf0, 0xe3, 0x7a, 
  0x19, 0x67, 0x5c, 0xef, 0xf5, 0xe2, 0x72, 0x9f, 0x74, 0xa3, 0x83, 0xd3, 
  0x93, 0x93, 0xc3, 0x03, 0x33, 0x29, 0x5b, 0x85, 0x28, 0x24, 0xb0, 0xd7, 
  0xb1, 0x01, 0x43, 0x28, 0xff, 0xda, 0x89, 0x76, 0x0c, 0xae, 0x9e, 0xcf, 
  0xc6, 0x46, 0x02, 0xc9, 0x91, 0x63, 0x11, 0x53, 0x10, 0x2e, 0xe3, 0xa9, 
  0x1d, 0xe0, 0x5c, 0x49, 0xa3, 0x81, 0x68, 0xef, 0xcb, 0x8f, 0xcf, 0xd2, 
  0x2b, 0x6f, 0x04, 0x6f, 0xb8, 0x18, 0xd9, 0x83, 0xad, 0xc8, 0x05, 0xe1, 
  0x11, 0x32, 0xf3, 0xb6, 0x4f, 0x12, 0x2d, 0x73, 0x2b, 0xa4, 0x26, 0xc4, 
  0x0f, 0xf3, 0x73, 0x98, 0xc9, 0xe7, 0xb4, 0x4f, 0x28, 0x19, 0x26, 0x81, 
  0xb9, 0x4f, 0x83, 0x18, 0x45, 0x05, 0xc3, 0x01, 0xb6, 0xa4, 0x32, 0x6b, 
  0x54, 0x2b, 0x95, 0xa4, 0x9c, 0x4c, 0x0a, 0x8e, 0x23, 0xcd, 0x18, 0xb1, 
  0x24, 0x3a, 0xb3, 0x96, 0x70, 0xa1, 0x52, 0xe1, 0x35, 0x67, 0xf3, 0x00, 
  0x71, 0x68, 0xc2, 0x92, 0x14, 0x8c, 0x6b, 0x61, 0x67, 0x76, 0x79, 0xf2, 
  0x0a, 0x5a, 0xd9, 0x61, 0xf1, 0xb6, 0xba, 0xd1, 0x4b, 0xc9, 0x00, 0x2c, 
  0x3c, 0xa2, 0xe8, 0xe2, 0x02, 0x50, 0x7e, 0x95, 0x22, 0x39, 0x9b, 0x4a, 
  0xa3, 0x21, 0x71, 0xa3, 0x3a, 0xba, 0x89, 0xd1, 0xa5, 0xc6, 0xb0, 0x3c, 
  0xb8, 0xa2, 0x6e, 0x35, 0x85, 0x7c, 0x8b, 0xc4, 0x62, 0x5b, 0xc4, 0x76, 
  0x50, 0xb2, 0xff, 0x20, 0xb3, 0x94, 0x0d, 0xc9, 0xbf, 0xe0, 0x18, 0x8f, 
  0x42, 0x81, 0x63, 0x88, 0xfd, 0xb1, 0xa5, 0x18, 0xb5, 0x04, 0x51, 0x09, 
  0x8f, 0x9d, 0x68, 0x06, 0x2a, 0xe6, 0xe0, 0x38, 0x74, 0xb9, 0x03, 0xb2, 
  0x12, 0x73, 0xf9, 0x4a, 0x3b, 0x74, 0xb9, 0xc2, 0xb6, 0x59, 0x03, 0x49, 
  0x3d, 0x89, 0x91, 0xe9, 0x60, 0x26, 0xdb, 0x20, 0x63, 0xae, 0xd4, 0x3c, 
  0x44, 0xe7, 0x80, 0x14, 0x86, 0x87, 0x92, 0x30, 0x3e, 0x73, 0xa7, 0xe6, 
  0xe8, 0x23, 0xc1, 0x71, 0x81, 0xfa, 0x26, 0x63, 0xec, 0x0c, 0x62, 0x3a, 
  0x5d, 0x6b, 0x76, 0x83, 0xf8, 0x95, 0xa2, 0x25, 0x7d, 0xbd, 0x7f, 0x74, 
  0xcc, 0xee, 0xc4, 0x63, 0x3a, 0x4c, 0x17, 0x66, 0xe6, 0x85, 0xcf, 0x15, 
  0xee, 0x50, 0x92, 0x9a, 0x69, 0x61, 0x06, 0x0e, 0x85, 0xd5, 0x42, 0x17, 
  0x41, 0x21, 0x6c, 0x1b, 0x11, 0x26, 0xab, 0xd0, 0x14, 0xc4, 0xda, 0xc6, 
  0x4b, 0x8e, 0x35, 0x64, 0xc1, 0x17, 0x08, 0x50, 0x0c, 0x8d, 0x08, 0x6b, 
  0x14, 0x98, 0x97, 0xf8, 0x87, 0x01, 0xfc, 0xcc, 0x75, 0xb1, 0xef, 0x54, 
  0x42, 0x15, 0x40, 0x9d, 0xaf, 0xd4, 0x04, 0x24, 0x85, 0x5f, 0xaa, 0x8d, 
  0xce, 0x72, 0xca, 0xdb, 0xdc, 0xe7, 0xb6, 0x24, 0x22, 0xfa, 0xfc, 0x32, 
  0xee, 0xde, 0x83, 0x3f, 0x9a, 0xdd, 0x8d, 0xdf, 0x1b, 0x32, 0x37, 0x29, 
  0xe5, 0x02, 0x78, 0x53, 0x6a, 0x0a, 0x51, 0x33, 0x72, 0x43, 0x05, 0x32, 
  0xad, 0x1c, 0x20, 0x0a, 0xcc, 0xc0, 0x60, 0xba, 0x44, 0xed, 0x62, 0x02, 
  0x1c, 0xb0, 0xb0, 0x8b, 0x96, 0xac, 0x0c, 0xe0, 0x40, 0xc2, 0xd7, 0x21, 
  0x71, 0x90, 0x8a, 0x33, 0x88, 0xe0, 0x87, 0x62, 0xba, 0xc3, 0xb3, 0x0c, 
  0x33, 0x14, 0x78, 0x87, 0xe9, 0x4f, 0x09, 0x4d, 0xd2, 0xbf, 0xd0, 0x54, 
  0xb1, 0x04, 0x9a, 0xd5, 0x00, 0x31, 0x82, 0xb0, 0xd9, 0x48, 0xd9, 0x50, 
  0x19, 0xbd, 0x1a, 0x4e, 0x65, 0xfc, 0x2f, 0xcd, 0xae, 0x67, 0x68, 0x42, 
  0x79, 0x61, 0xab, 0x2b, 0xbb, 0x70, 0x25, 0x85, 0x1e, 0xbe, 0x5c, 0xb2, 
  0x39, 0xc1, 0x01, 0x19, 0xf3, 0x28, 0xe6, 0x5c, 0xa0, 0x25, 0x91, 0x9a, 
  0x2a, 0xae, 0x71, 0x3e, 0x3b, 0x4b, 0xda, 0x5d, 0x69, 0xfd, 0x38, 0xbf, 
  0xe7, 0x8a, 0x30, 0xd3, 0x29, 0x17, 0xa3, 0x3c, 0xcd, 0x3c, 0x6a, 0x15, 
  0x5f, 0x41, 0xf2, 0xe0, 0xdc, 0x50, 0xa8, 0x69, 0x6e, 0xd1, 0x62, 0x79, 
  0x35, 0x23, 0xf1, 0xcc, 0x82, 0x4b, 0x46, 0xd1, 0x3e, 0x56, 0x89, 0xc8, 
  0x1a, 0xcd, 0x89, 0x41, 0x14, 0x27, 0xbb, 0x11, 0xcb, 0xa0, 0x75, 0xea, 
  0x38, 0x9a, 0x7b, 0x8e, 0xd2, 0x38, 0xec, 0xb3, 0x9f, 0xe7, 0x99, 0x85, 
  0xa6, 0x2d, 0x4b, 0xc1, 0x30, 0xb1, 0xa2, 0x76, 0x1b, 0xa2, 0xdd, 0xa5, 
  0x33, 0x05, 0x0d, 0x54, 0x1e, 0x88, 0x37, 0xc2, 0xc9, 0x4c, 0x86, 0x8b, 
  0x9b, 0x85, 0xed, 0xb4, 0x1d, 0x36, 0x09, 0x8d, 0xd6, 0x60, 0x28, 0x58, 
  0x15, 0xce, 0xbe, 0x3e, 0x1b, 0x45, 0x87, 0xdc, 0x92, 0x8c, 0x49, 0x59, 
  0x34, 0x2e, 0x43, 0xfa, 0x8e, 0x26, 0x7b, 0xcd, 0x49, 0x8f, 0xa7, 0x05, 
  0xff, 0x85, 0xd6, 0xf4, 0x4b, 0x91, 0x7c, 0xf1, 0x6d, 0xbd, 0x57, 0x6a, 
  0x28, 0xd7, 0xf2, 0xa5, 0x67, 0xf8, 0x9d, 0x8e, 0x0a, 0xe9, 0x02, 0x6e, 
  0x9b, 0x7c, 0x0f, 0x79, 0x51, 0xcb, 0xf7, 0x94, 0x37, 0xa3, 0xab, 0x54, 
  0x54, 0xa9, 0xc5, 0x0a, 0xfb, 0x07, 0xd9, 0x09, 0x49, 0xc2, 0x9a, 0x4c, 
  0x20, 0x0d, 0x04, 0xa4, 0xa5, 0xe4, 0xe7, 0xfc, 0x9e, 0x72, 0xae, 0x0a, 
  0xc9, 0x74, 0x2c, 0x12, 0xf5, 0x12, 0xe7, 0x6a, 0x69, 0x92, 0xab, 0xa3, 
  0x4c, 0x1a, 0xc7, 0x35, 0xc0, 0x41, 0xb6, 0x2f, 0x98, 0xbf, 0xf1, 0x58, 
  0xee, 0xd2, 0x09, 0x6d, 0xc1, 0x68, 0xe3, 0xff, 0x05, 0x9b, 0x7f, 0x68, 
  0xf2, 0x74, 0x7c, 0x01, 0x00, 
};
/* Decompress and send to stdout a gzip-compressed buffer */
void hugehelp(void)
{
  unsigned char buf[0x10000];
  int status,headerlen;
  z_stream z;

  /* Make sure no gzip options are set */
  if (hugehelpgz[3] & 0xfe)
    return;

  headerlen = 10;
  z.avail_in = sizeof(hugehelpgz) - headerlen;
  z.next_in = (unsigned char *)hugehelpgz + headerlen;
  z.zalloc = (alloc_func)Z_NULL;
  z.zfree = (free_func)Z_NULL;
  z.opaque = 0;

  if (inflateInit2(&z, -MAX_WBITS) != Z_OK)
    return;

  while(1) {
    z.avail_out = (int)sizeof(buf);
    z.next_out = buf;
    status = inflate(&z, Z_SYNC_FLUSH);
    if (status == Z_OK || status == Z_STREAM_END) {
      fwrite(buf, sizeof(buf) - z.avail_out, 1, stdout);
      if (status == Z_STREAM_END)
         break;
    }
     else
      break;    /* Error */
  }
  inflateEnd(&z);
}
#endif /* USE_MANUAL */
#endif /* HAVE_LIBZ */
