/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: entity.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 13:08:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_ENTITY_HXX
#define UDM_ENTITY_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/impl_struct.hxx>
	// COMPONENTS
	// PARAMETERS




namespace cosv
{
    class bostream;
    class bistream;
}


namespace udm
{


/** @resp
    Identifying an user object, which may have an id.
*/

template <class SRC, class OBJ_ID = UINT32>
class Entity
{
  public:
    // LIFECYCLE
                        Entity();
                        Entity(
                            const SRC &         i_rObj,
                            OBJ_ID              i_nId = 0 );
                        ~Entity();
    // OPERATIONS
    void                connect(
                            const SRC &         i_rObj,
                            OBJ_ID              i_nId = 0 );
    void                set_id(
                            OBJ_ID              i_nId );
    // INQUIRY
    OBJ_ID              id() const;
    /// Reference is valid as long as this instance exists.
    const Object &      obj() const;
    Object              get(
                            int                 i_nKey ) const
                                                { return aObj.get(i_nKey); }

  private:
    typedef TStruct<SRC>   data_type;

    // Locals
    const data_type &   MyData() const;

    // DATA
    Object              aObj;
    OBJ_ID              nId;
};

}   // namespace udm

template <class SRC, class OBJ_ID>
csv::bostream &     operator<<(
                        csv::bostream &     o_rOut,
                        const udm::Entity<SRC,OBJ_ID> &
                                            i_rSrc );
template <class SRC, class OBJ_ID>
csv::bistream &     operator>>(
                        csv::bistream &     io_rSrc,
                        udm::Entity<SRC,OBJ_ID> &
                                            o_rDest );



// IMPLEMENTATION

namespace udm
{

template <class SRC, class OBJ_ID>
inline const typename Entity<SRC,OBJ_ID>::data_type &
Entity<SRC,OBJ_ID>::MyData() const
    { return static_cast< data_type& >(*aObj); }



template <class SRC, class OBJ_ID>
inline
Entity<SRC,OBJ_ID>::Entity()
    :   aObj( type_traits<SRC>::get_().create_data() ),
        nId(0)
{
}

template <class SRC, class OBJ_ID>
inline
Entity<SRC,OBJ_ID>::Entity( const SRC &   i_rObj,
                            OBJ_ID        i_nId )
    :   aObj( type_traits<SRC>::get_().create_data_for(i_rObj) ),
        nId(i_nId)
{
}

template <class SRC, class OBJ_ID>
inline
Entity<SRC,OBJ_ID>::~Entity()
{
}

template <class SRC, class OBJ_ID>
inline void
Entity<SRC,OBJ_ID>::connect( const SRC &     i_rObj,
                             OBJ_ID          i_nId )
{
    nId = i_nId;
    MyData().connect(i_rObj);
}

template <class SRC, class OBJ_ID>
inline void
Entity<SRC,OBJ_ID>::set_id( OBJ_ID i_nId )
{
    nId = i_nId;
}

template <class SRC, class OBJ_ID>
inline OBJ_ID
Entity<SRC,OBJ_ID>::id() const
{
    return nId;
}

template <class SRC, class OBJ_ID>
inline const Object &
Entity<SRC,OBJ_ID>::obj() const
{
    return aObj;
}

}   // namespace udm



template <class SRC>
csv::bostream &
operator<<( csv::bostream &             o_rOut,
            const udm::Entity<SRC> &    i_rSrc )
{
    i_rSrc.obj().bin_write(o_rOut);
    return o_rOut;
}

template <class SRC>
csv::bistream &
operator>>( csv::bistream &     io_rSrc,
            udm::Entity<SRC> &  o_rDest )
{
    // KORR     Dummy
    return io_rSrc;
}



#include <udm/i_stdstr.hxx>
#include <udm/i_uinteger.hxx>
#include <udm/tt_basics.hxx>



#endif

