/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: registerucb.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 17:23:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_ucbhelper.hxx"

#ifndef _UCBHELPER_REGISTERUCB_HXX_
#include <registerucb.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPARAMETERIZEDCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XParameterizedContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERFACTORY_HPP_
#include <com/sun/star/ucb/XContentProviderFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _VOS_DIAGNOSE_H_
#include <vos/diagnose.hxx>
#endif

#ifndef _UCBHELPER_CONFIGUREUCB_HXX_
#include <ucbhelper/configureucb.hxx>
#endif

using namespace com::sun;
using namespace com::sun::star;

namespace ucb {

//============================================================================
//
//  registerAtUcb
//
//============================================================================

bool
registerAtUcb(
    uno::Reference< star::ucb::XContentProviderManager > const & rManager,
	uno::Reference< lang::XMultiServiceFactory > const & rServiceFactory,
	rtl::OUString const & rName,
	rtl::OUString const & rArguments,
	rtl::OUString const & rTemplate,
	ContentProviderRegistrationInfo * pInfo)
	throw (uno::RuntimeException)
{
	VOS_ENSURE(rServiceFactory.is(),
			   "ucb::registerAtUcb(): No service factory");

	bool bNoProxy
		= rArguments.compareToAscii(RTL_CONSTASCII_STRINGPARAM("{noproxy}"))
		      == 0;
	rtl::OUString
		aProviderArguments(bNoProxy ?
						       rArguments.
						           copy(RTL_CONSTASCII_LENGTH("{noproxy}")) :
						       rArguments);

	// First, try to instantiate proxy for provider:
	uno::Reference< star::ucb::XContentProvider > xProvider;
	if (!bNoProxy)
	{
		uno::Reference< star::ucb::XContentProviderFactory > xProxyFactory;
		try
		{
			xProxyFactory
				= uno::Reference< star::ucb::XContentProviderFactory >(
					  rServiceFactory->
				          createInstance(
							  rtl::OUString(
								  RTL_CONSTASCII_USTRINGPARAM(
							"com.sun.star.ucb.ContentProviderProxyFactory"))),
					  uno::UNO_QUERY);
		}
		catch (uno::Exception const &) {}
		VOS_ENSURE(xProxyFactory.is(), "No ContentProviderProxyFactory");
		if (xProxyFactory.is())
			xProvider = xProxyFactory->createContentProvider(rName);
	}

	// Then, try to instantiate provider directly:
	if (!xProvider.is())
		try
		{
			xProvider = uno::Reference< star::ucb::XContentProvider >(
				            rServiceFactory->createInstance(rName),
							uno::UNO_QUERY);
		}
		catch (uno::RuntimeException const &) { throw; }
		catch (uno::Exception const &) {}

	uno::Reference< star::ucb::XContentProvider >
		xOriginalProvider(xProvider);
	uno::Reference< star::ucb::XParameterizedContentProvider >
		xParameterized(xProvider, uno::UNO_QUERY);
	if (xParameterized.is())
	{
		uno::Reference< star::ucb::XContentProvider > xInstance;
		try
		{
			xInstance = xParameterized->registerInstance(rTemplate,
														 aProviderArguments,
														 true);
				//@@@ if this call replaces an old instance, the commit-or-
				// rollback code below will not work
		}
		catch (lang::IllegalArgumentException const &) {}

		if (xInstance.is())
			xProvider = xInstance;
	}

	bool bSuccess = false;
	if (rManager.is() && xProvider.is())
		try
		{
			rManager->registerContentProvider(xProvider, rTemplate, true);
			bSuccess = true;
		}
		catch (star::ucb::DuplicateProviderException const &)
		{
			if (xParameterized.is())
				try
				{
					xParameterized->deregisterInstance(rTemplate,
													   aProviderArguments);
				}
				catch (lang::IllegalArgumentException const &) {}
		}
		catch (...)
		{
			if (xParameterized.is())
				try
				{
					xParameterized->deregisterInstance(rTemplate,
													   aProviderArguments);
				}
				catch (lang::IllegalArgumentException const &) {}
				catch (uno::RuntimeException const &) {}
			throw;
		}

	if (bSuccess && pInfo)
	{
		pInfo->m_xProvider = xOriginalProvider;
		pInfo->m_aArguments = aProviderArguments;
		pInfo->m_aTemplate = rTemplate;
	}
	return bSuccess;
}

//============================================================================
//
//  deregisterFromUcb
//
//============================================================================

void
deregisterFromUcb(
	uno::Reference< star::ucb::XContentProviderManager > const & rManager,
	ContentProviderRegistrationInfo const & rInfo)
	throw (uno::RuntimeException)
{
	uno::Reference< star::ucb::XContentProvider >
		xProvider(rInfo.m_xProvider);
	uno::Reference< star::ucb::XParameterizedContentProvider >
		xParameterized(xProvider, uno::UNO_QUERY);
	if (xParameterized.is())
	{
		uno::Reference< star::ucb::XContentProvider > xInstance;
		try
		{
			xInstance
				= xParameterized->deregisterInstance(rInfo.m_aTemplate,
													 rInfo.m_aArguments);
		}
		catch (lang::IllegalArgumentException const &) {}

		if (xInstance.is())
			xProvider = xInstance;
	}

	if (rManager.is())
		rManager->deregisterContentProvider(xProvider, rInfo.m_aTemplate);
			//@@@ if this fails, a roll-back of deregisterInstance() is
			// missing
}

}
