/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: strold.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 01:03:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_tools.hxx"

// =======================================================================

static unsigned char const aImplCharLowerArray[] =
{
	0,	 1,   2,   3,	4,	 5,   6,   7,	8,	 9,  10,  11,  12,	13,  14,  15,
   16,	17,  18,  19,  20,	21,  22,  23,  24,	25,  26,  27,  28,	29,  30,  31,
   32,	33,  34,  35,  36,	37,  38,  39,  40,	41,  42,  43,  44,	45,  46,  47,
   48,	49,  50,  51,  52,	53,  54,  55,  56,	57,  58,  59,  60,	61,  62,  63,
   64,	97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
  112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,  91,  92,	93,  94,  95,
   96,	97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
  112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
  128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
  144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
  160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
  176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
  192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
  208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
  224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

// -----------------------------------------------------------------------

int svstricmp( const char* pStr1, const char* pStr2 )
{
	int nCharDiff;

	do
	{
		nCharDiff = (int)aImplCharLowerArray[(unsigned char)(*pStr1)] -
					(int)aImplCharLowerArray[(unsigned char)(*pStr2)];
		if ( nCharDiff )
			return nCharDiff;
	}
	while ( *pStr1++ && *pStr2++ );

	return 0;
}

// -----------------------------------------------------------------------

int svstrnicmp( const char* pStr1, const char* pStr2, xub_StrLen nLen )
{
	int nCharDiff;

	if ( nLen )
	{
		do
		{
			nCharDiff = (int)aImplCharLowerArray[(unsigned char)(*pStr1)] -
						(int)aImplCharLowerArray[(unsigned char)(*pStr2)];
			if ( nCharDiff )
				return nCharDiff;
		}
		while ( --nLen && *pStr1++ && *pStr2++ );
	}

	return 0;
}

// =======================================================================

// Stringbuffer fuer die umgewandelten Zahlen
static char aNToABuf[] = "00000000000000000000000000000000000";
#define NTOABUFLEN (sizeof(aNToABuf))

// -----------------------------------------------------------------------

static xub_StrLen ImplUNToA( ULONG n, char*& rStr )
{
	xub_StrLen nLen = 0;

	// Pointer an das Bufferende setzen
	rStr = aNToABuf + (NTOABUFLEN-1);

	do
	{
		nLen++;
		rStr--;
		*(rStr) = (char)(n % 10) + 48;
		n /= 10;
	}
	while ( n );

	return nLen; // Laenge des Strings
}

// -----------------------------------------------------------------------

static xub_StrLen ImplNToA( long n, char*& rStr )
{
	BOOL bNeg;

	// Ist Zahl negativ
	if ( n < 0 )
	{
		bNeg = TRUE;
		// Zahl positiv
		n *= -1;
	}
	else
		bNeg = FALSE;

	xub_StrLen nLen = ImplUNToA( n, rStr );

	// Ist Zahl negativ, dann noch -
	if ( bNeg )
	{
		nLen++;
		rStr--;
		*(rStr) = '-';
	}

	return nLen; // Laenge des Strings
}

// =======================================================================

ByteString::ByteString( unsigned char c )
	: mpData(NULL)
{
	DBG_CTOR( ByteString, DbgCheckByteString );

	// Ist es kein 0-Character
	if ( !c )
	{
	    STRING_NEW((STRING_TYPE **)&mpData);
	}
	else
	{
		// Verwaltungsdaten anlegen und initialisieren
		mpData = ImplAllocData( 1 );
		mpData->maStr[0] = c;
	}
}

// -----------------------------------------------------------------------

ByteString::ByteString( int n )
{
	DBG_CTOR( ByteString, DbgCheckByteString );

	char*		pStr;	// Pointer auf den String
	xub_StrLen	nLen;	// Laenge des Strings

	// Verwaltungsdaten anlegen, Zahl umwandeln und in die Daten kopieren
	nLen = ImplNToA( n, pStr );
	mpData = ImplAllocData( nLen );
	memcpy( mpData->maStr, pStr, nLen+1 );
}

// -----------------------------------------------------------------------

ByteString::ByteString( unsigned int n )
{
	DBG_CTOR( ByteString, DbgCheckByteString );

	char*		pStr;	// Pointer auf den String
	xub_StrLen	nLen;	// Laenge des Strings

	// Verwaltungsdaten anlegen, Zahl umwandeln und in die Daten kopieren
	nLen = ImplUNToA( n, pStr );
	mpData = ImplAllocData( nLen );
	memcpy( mpData->maStr, pStr, nLen+1 );
}

// -----------------------------------------------------------------------

ByteString::ByteString( short n )
{
	DBG_CTOR( ByteString, DbgCheckByteString );

	char*		pStr;	// Pointer auf den String
	xub_StrLen	nLen;	// Laenge des Strings

	// Verwaltungsdaten anlegen, Zahl umwandeln und in die Daten kopieren
	nLen = ImplNToA( n, pStr );
	mpData = ImplAllocData( nLen );
	memcpy( mpData->maStr, pStr, nLen+1 );
}

// -----------------------------------------------------------------------

ByteString::ByteString( USHORT n )
{
	DBG_CTOR( ByteString, DbgCheckByteString );

	char*		pStr;	// Pointer auf den String
	xub_StrLen	nLen;	// Laenge des Strings

	// Verwaltungsdaten anlegen, Zahl umwandeln und in die Daten kopieren
	nLen = ImplNToA( n, pStr );
	mpData = ImplAllocData( nLen );
	memcpy( mpData->maStr, pStr, nLen+1 );
}

// -----------------------------------------------------------------------

ByteString::ByteString( long n )
{
	DBG_CTOR( ByteString, DbgCheckByteString );

	char*		pStr;	// Pointer auf den String
	xub_StrLen	nLen;	// Laenge des Strings

	// Verwaltungsdaten anlegen, Zahl umwandeln und in die Daten kopieren
	nLen = ImplNToA( n, pStr );
	mpData = ImplAllocData( nLen );
	memcpy( mpData->maStr, pStr, nLen+1 );
}

// -----------------------------------------------------------------------

ByteString::ByteString( ULONG n )
{
	DBG_CTOR( ByteString, DbgCheckByteString );

	char*		pStr;	// Pointer auf den String
	xub_StrLen	nLen;	// Laenge des Strings

	// Verwaltungsdaten anlegen, Zahl umwandeln und in die Daten kopieren
	nLen = ImplUNToA( n, pStr );
	mpData = ImplAllocData( nLen );
	memcpy( mpData->maStr, pStr, nLen+1 );
}

// -----------------------------------------------------------------------

ByteString::operator int() const
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	// String zusammensetzen und umwandeln
	return atoi( mpData->maStr );
}

// -----------------------------------------------------------------------

ByteString::operator unsigned int() const
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	unsigned int n = 0;
	char*	 pStr  = mpData->maStr;

	// Solange es sich um eine Ziffer handelt, String umwandeln
	while( (*pStr >= 48) && (*pStr <= 57) )
	{
		n *= 10;
		n += ((*pStr) - 48);
		pStr++;
	}

	return n;
}

// -----------------------------------------------------------------------

ByteString::operator short() const
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	// String umwandeln
	return atoi( mpData->maStr );
}

// -----------------------------------------------------------------------

ByteString::operator USHORT() const
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	// String umwandeln
	USHORT n	= 0;
	char*  pStr = mpData->maStr;

	// Solange es sich um eine Ziffer handelt, String umwandeln
	while( (*pStr >= 48) && (*pStr <= 57) )
	{
		n *= 10;
		n += (*pStr) - 48;
		pStr++;
	}

	return n;
}

// -----------------------------------------------------------------------

ByteString::operator long() const
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	// String umwandeln
	return atol( mpData->maStr );
}

// -----------------------------------------------------------------------

ByteString::operator ULONG() const
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	// String umwandeln
	ULONG  n	= 0;
	char*  pStr = mpData->maStr;

	// Solange es sich um eine Ziffer handelt, String umwandeln
	while( (*pStr >= 48) && (*pStr <= 57) )
	{
		n *= 10;
		n += ((*pStr) - 48);
		pStr++;
	}

	return n;
}
// -----------------------------------------------------------------------

ByteString& ByteString::operator += ( int n )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	*this += ByteString( n );
	return *this;
}

// -----------------------------------------------------------------------

ByteString& ByteString::operator += ( unsigned int n )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	*this += ByteString( n );
	return *this;
}

// -----------------------------------------------------------------------

ByteString& ByteString::operator += ( short n )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	*this += ByteString( n );
	return *this;
}

// -----------------------------------------------------------------------

ByteString& ByteString::operator += ( USHORT n )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	*this += ByteString( n );
	return *this;
}

// -----------------------------------------------------------------------

ByteString& ByteString::operator += ( long n )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	*this += ByteString( n );
	return *this;
}

// -----------------------------------------------------------------------

ByteString& ByteString::operator += ( ULONG n )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	*this += ByteString( n );
	return *this;
}

// -----------------------------------------------------------------------

ByteString ByteString::Lower() const
{
	ByteString aStr = *this;
	aStr.ToLower();
	return aStr;
}

// -----------------------------------------------------------------------

ByteString ByteString::Upper() const
{
	ByteString aStr = *this;
	aStr.ToUpper();
	return aStr;
}

// -----------------------------------------------------------------------

static BOOL ImplIsPrintable( unsigned char c, rtl_TextEncoding eTextEncoding )
{
	// Alle Zeichen groessergleich 32 sind bis auf das Del-Zeichen
	// Printable, da einige Fonts die Ctrl-Codes zwischen 128 und
	// 150 belegen
	// Fuer MAC sind die Device-Controls auch Printable-Zeichen, da
	// diese im Chicago-Font durch die Apple-Zeichen belegt sind
	// Im PC-Zeichensatz ist zuseatzlich noch das Paragraphen- und das
	// Section-Zeichen printable (alle anderen sind PC-Zeichen sind
	// per Definition nicht printable)
	if ( ((c >= 32) && (c != 127)) ||
		 ((c >= 17) && (c <= 20) && (eTextEncoding == CHARSET_MAC)) ||
		 ((c >= 20) && (c <= 21) &&
		  ((eTextEncoding == CHARSET_IBMPC_437) || (eTextEncoding == CHARSET_IBMPC_850) ||
		   (eTextEncoding == CHARSET_IBMPC_860) || (eTextEncoding == CHARSET_IBMPC_861) ||
		   (eTextEncoding == CHARSET_IBMPC_863) || (eTextEncoding == CHARSET_IBMPC_865))) )
		return TRUE;
	else
		return FALSE;
}

// -----------------------------------------------------------------------

BOOL ByteString::IsPrintable( rtl_TextEncoding eTextEncoding ) const
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

#ifndef NOOLDSTRING
	if ( eTextEncoding == CHARSET_SYSTEM )
		eTextEncoding = GetSystemCharSet();
#endif

	// Den gesammten String nach Printable-Zeichen absuchen
	const char* pStr = mpData->maStr;
	while ( *pStr )
	{
		// Wenn ein Zeichen im String nicht Printable ist, ist der
		// ganze String nicht printable
		if ( !ImplIsPrintable( (unsigned char)*pStr, eTextEncoding ) )
			return FALSE;
		pStr++;
	}

	return TRUE;
}

// -----------------------------------------------------------------------

BOOL ByteString::IsPrintable( char c, rtl_TextEncoding eTextEncoding )
{
#ifndef NOOLDSTRING
	if ( eTextEncoding == CHARSET_SYSTEM )
		eTextEncoding = GetSystemCharSet();
#endif

	return ImplIsPrintable( (unsigned char)c, eTextEncoding );
}

// -----------------------------------------------------------------------

StringCompare ByteString::Compare( const sal_Char* pCharStr,
								   xub_StrLen nLen ) const
{
	StringCompare eComp = CompareTo( pCharStr, nLen );
	if ( eComp == COMPARE_LESS )
		return COMPARE_GREATER;
	else if ( eComp == COMPARE_GREATER )
		return COMPARE_LESS;
	else
		return COMPARE_EQUAL;
}

// -----------------------------------------------------------------------

StringCompare ByteString::ICompare( const sal_Char* pCharStr,
									xub_StrLen nLen ) const
{
	StringCompare eComp = CompareIgnoreCaseToAscii( pCharStr, nLen );
	if ( eComp == COMPARE_LESS )
		return COMPARE_GREATER;
	else if ( eComp == COMPARE_GREATER )
		return COMPARE_LESS;
	else
		return COMPARE_EQUAL;
}

// -----------------------------------------------------------------------

sal_Char& ByteString::operator [] ( xub_StrLen nIndex )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );
	DBG_ASSERT( nIndex <= mpData->mnLen, "ByteString::operator[] - nIndex > ByteString.Len()" );

	// Daten kopieren, wenn noetig
	if ( mpData->mnLen )
		ImplCopyData( this );

	// Referenz auf den Character an der Position nIndex zurueckgeben
	return mpData->maStr[nIndex];
}

// -----------------------------------------------------------------------

ByteString ByteString::Cut( xub_StrLen nIndex, xub_StrLen nCount )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	// Ausschnitt retten, Auschneiden und ausgeschnittenen String zurueckgeben
	ByteString aTempStr = Copy( nIndex, nCount );
	Erase( nIndex, nCount );
	return aTempStr;
}

// -----------------------------------------------------------------------

ByteString& ByteString::Replace( const ByteString& rStr, xub_StrLen nIndex )
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );
	DBG_CHKOBJ( &rStr, ByteString, DbgCheckByteString );

	// Muss ueberhaupt etwas ersetzt werden
	if ( (nIndex >= mpData->mnLen) || !rStr.mpData->mnLen )
		return *this;

	// Daten kopieren, wenn noetig
	ImplCopyData( this );

	// Anzahl der zu ersetzenden Zeichen ermitteln
	xub_StrLen nCount = Min( (xub_StrLen)(mpData->mnLen-nIndex), (xub_StrLen)(rStr.mpData->mnLen) );

	// Zeichen ersetzen
	for ( xub_StrLen i = 0; i < nCount; i++ )
		mpData->maStr[i+nIndex] = rStr.mpData->maStr[i];

	return *this;
}

// -----------------------------------------------------------------------

ByteString& ByteString::SpaceToZero()
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	xub_StrLen	nIndex = 0;
	xub_StrLen	nLen = mpData->mnLen;
	sal_Char*	pStr = mpData->maStr;
	while ( nIndex < nLen )
	{
		// Handelt es sich um ein Space-Zeichen
		if ( *pStr == ' ' )
		{
			// Daten kopieren, wenn noetig
			pStr = ImplCopyStringData( this, pStr );
			*pStr = '0';
		}

		pStr++;
		nIndex++;
	}

	return *this;
}

// -----------------------------------------------------------------------

ByteString& ByteString::ZeroToSpace()
{
	DBG_CHKTHIS( ByteString, DbgCheckByteString );

	xub_StrLen	nIndex = 0;
	xub_StrLen	nLen = mpData->mnLen;
	sal_Char*	pStr = mpData->maStr;
	while ( nIndex < nLen )
	{
		// Handelt es sich um eine '0'
		if ( *pStr == '0' )
		{
			// Daten kopieren, wenn noetig
			pStr = ImplCopyStringData( this, pStr );
			*pStr = ' ';
		}

		pStr++;
		nIndex++;
	}

	return *this;
}
