/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pageiter.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 21:22:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#include "doc.hxx"
#include "pagefrm.hxx"
#include "cntfrm.hxx"
#include "pam.hxx"
#include "pageiter.hxx"
#include "txtfrm.hxx"

SwPageIter::SwPageIter( const SwDoc &rDoc, const SwPosition &rStartPos )
	: rPDoc( rDoc ), pPage(0)
{
	Seek( rStartPos );
}



BOOL SwPageIter::NextPage()
{
	if( IsEnd() )
		return FALSE;
	pPage = (SwPageFrm*)pPage->GetNext();
	return TRUE;
}



const SwPageDesc* SwPageIter::GetPageDesc() const
{
	return	( IsEnd() )? 0 : pPage->GetPageDesc();
}



BOOL SwPageIter::Seek( const SwPosition &rPos )
{
	const SwTxtFrm *pTxt = (SwTxtFrm*)rPDoc.GetNodes()[rPos.nNode.GetIndex()]->
												GetCntntNode()->GetFrm();
	if ( !pTxt )
		return FALSE;

	pTxt = pTxt->GetFrmAtPos( rPos );
	pPage = pTxt->FindPageFrm();
	return TRUE;
}



BOOL SwPageIter::GetPosition( SwPosition &rPos ) const
{
	if( IsEnd() )
		return FALSE;

	const SwCntntFrm *pCnt = pPage->FindFirstBodyCntnt();
	if ( !pCnt )
		return FALSE;

	pCnt = ((SwTxtFrm*)pCnt)->GetFrmAtPos( rPos );
	if ( !pCnt )
		return FALSE;

	rPos.nNode = *pCnt->GetNode();
	rPos.nContent.Assign( rPos.nNode.GetNode().GetCntntNode(),
							((SwTxtFrm*)pCnt)->GetOfst() );

	return TRUE;
}

/*
#ifdef NIE
{
	SwPageIter aIter( MyDoc );

	while( !aIter.IsEnd() )
	{
		SwPosition MyPos( aIter.GetPos() );
		(...)
		aIter.NextPage();
	}
}

#endif // NIE
*/




