/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: insdlg.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: obo $ $Date: 2006/10/12 10:57:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_so3.hxx"

#define _INSDLG_CXX

// include ---------------------------------------------------------------

#include <stdio.h>
#include <insdlg.hxx>

#include <tools/urlobj.hxx>
#include <tools/debug.hxx>
#include <svtools/urihelper.hxx>
#include <svtools/svmedit.hxx>
#include <vcl/button.hxx>
#include <vcl/fixed.hxx>
#include <vcl/group.hxx>
#include <vcl/lstbox.hxx>
#include <vcl/msgbox.hxx>
#include <vcl/svapp.hxx>

#include <svuidlg.hxx>
#include <svuidlg.hrc>
#include <svstor.hxx>
#include <ipobj.hxx>
#include <plugin.hxx>
#include <applet.hxx>
#include <outplace.hxx>
#include "staticbaseurl.hxx"

#ifndef  _COM_SUN_STAR_UI_DIALOGS_TEMPLATEDESCRIPTION_HPP_
#include <com/sun/star/ui/dialogs/TemplateDescription.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFilePicker.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILTERMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterManager.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef  _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <osl/file.hxx>
#include <sot/stg.hxx>

#include <com/sun/star/container/XHierarchicalNameAccess.hpp>
#include <com/sun/star/container/XNameAccess.hpp>
#include <unotools/processfactory.hxx>


using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::rtl;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::ui::dialogs;

#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>

#define SoResid( id )   ResId( id, SOAPP->GetResMgr() )

/********************** SvObjectServerList ********************************
**************************************************************************/
PRV_SV_IMPL_OWNER_LIST( SvObjectServerList, SvObjectServer )

/*************************************************************************
|*    SvObjectServerList::SvObjectServerList()
|*
|*    Beschreibung
*************************************************************************/
const SvObjectServer * SvObjectServerList::Get( const String & rHumanName ) const
{
	for( ULONG i = 0; i < Count(); i++ )
	{
		if( rHumanName == GetObject( i ).GetHumanName() )
			return &GetObject( i );
	}
	return NULL;
}

/*************************************************************************
|*    SvObjectServerList::SvObjectServerList()
|*
|*    Beschreibung
*************************************************************************/
const SvObjectServer * SvObjectServerList::Get( const SvGlobalName & rName ) const
{
	for( ULONG i = 0; i < Count(); i++ )
	{
		if( rName == GetObject( i ).GetClassName() )
			return &GetObject( i );
	}
	return NULL;
}

void SvObjectServerList::Remove( const SvGlobalName & rName )
{
	SvObjectServer * pS = (SvObjectServer *)aTypes.First();
	while( pS )
	{
		if( rName == pS->GetClassName() )
		{
			Remove();
			pS = (SvObjectServer *)aTypes.GetCurObject();
		}
		else
			pS = (SvObjectServer *)aTypes.Next();
	}
}

//---------------------------------------------------------------------
void SvObjectServerList::FillInsertObjects()
/* [Beschreibung]

	Die Liste wird mit allen Typen gef"ullt, die im Insert-Dialog
	ausgew"ahlt werden k"onnen.
*/
{
	try{
	Reference< XMultiServiceFactory > _globalMSFactory= utl::getProcessServiceFactory();
	if( _globalMSFactory.is())
	{
		OUString sProviderService =
		OUString::createFromAscii( "com.sun.star.configuration.ConfigurationProvider" );
		Reference<XMultiServiceFactory > sProviderMSFactory(
			_globalMSFactory->createInstance( sProviderService ),UNO_QUERY );

		if( sProviderMSFactory.is())
		{
			OUString sReaderService =
				OUString::createFromAscii( "com.sun.star.configuration.ConfigurationAccess" );
			Sequence< Any > aArguments( 1 );
			aArguments[0] <<= OUString::createFromAscii( "org.openoffice.Office.Common");

			Reference< XHierarchicalNameAccess > xHierNameAccess(
				sProviderMSFactory->createInstanceWithArguments( sReaderService,aArguments ),
				UNO_QUERY );

			if( xHierNameAccess.is())
			{
				OUString sTagName=  OUString::createFromAscii("OfficeObjects");
				Any _a= xHierNameAccess->getByHierarchicalName(sTagName);
				Reference<XNameAccess> nameAccess;
				_a >>= nameAccess;
				if( nameAccess.is())
				{
					Sequence<OUString> seqNames= nameAccess->getElementNames();
					OUString sSeparator( OUString::createFromAscii("/"));
					for(int i=0; i<seqNames.getLength(); i++)
					{

						OUString sComponentName= sTagName + sSeparator + seqNames[i] + sSeparator +
							OUString::createFromAscii("Name");
						OUString sKey= sTagName + sSeparator + seqNames[i] + sSeparator +
							OUString::createFromAscii("Key");
						Any anyName= xHierNameAccess->getByHierarchicalName(sComponentName);
						Any anyKey= xHierNameAccess->getByHierarchicalName( sKey);

						anyName >>= sComponentName;
						anyKey >>= sKey;

						SvGlobalName aClassName;
						if( aClassName.MakeId( String(sKey.getStr())))
						{
							if( !Get( aClassName ) )
								// noch nicht eingetragen
								Append( SvObjectServer( aClassName, String( sComponentName.getStr() ) ) );

						}
					}
				}
			}
		}

	}


#ifdef WNT
	SvGlobalName aOleFact = *SvOutPlaceObject::ClassFactory();
	String aOleObj( SoResid( STR_FURTHER_OBJECT ) );
	Append( SvObjectServer( aOleFact, aOleObj ) );
#endif

	}catch( com::sun::star::container::NoSuchElementException)
	{
	}catch( ::com::sun::star::uno::Exception)
	{
	}
	catch(...)
	{
	}
}

// class SvInsertOleDlg --------------------------------------------------

class SvInsertOleDlg : public MdInsertOleobject
{
private:
	String      _aOldStr;

	DECL_LINK( DoubleClickHdl, ListBox * );
	DECL_LINK( BrowseHdl, PushButton * );
	DECL_LINK( RadioHdl, RadioButton * );

public:
	SvInsertOleDlg( Window* pParent );

	void        SelectDefault();
	ListBox&    GetObjectTypes()    { return aLbObjecttype; }
	String      GetFilePath() const { return aEdFilepath.GetText(); }
	BOOL        IsLinked() const    { return aCbFilelink.IsChecked(); }
	BOOL        IsCreateNew() const { return aRbNewObject.IsChecked(); }
};

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SvInsertOleDlg, DoubleClickHdl, ListBox *, EMPTYARG )
{
	EndDialog( RET_OK );
	return 0;
}
IMPL_LINK_INLINE_END( SvInsertOleDlg, DoubleClickHdl, ListBox *, pListBox )

// -----------------------------------------------------------------------

IMPL_LINK( SvInsertOleDlg, BrowseHdl, PushButton *, EMPTYARG )
{
    Reference< XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
    if( xFactory.is() )
    {
        Reference< XFilePicker > xFilePicker( xFactory->createInstance( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ui.dialogs.FilePicker" ) ) ), UNO_QUERY );
        DBG_ASSERT( xFilePicker.is(), "could not get FilePicker service" );

        Reference< XInitialization > xInit( xFilePicker, UNO_QUERY );
        Reference< XFilterManager > xFilterMgr( xFilePicker, UNO_QUERY );
        if( xInit.is() && xFilePicker.is() && xFilterMgr.is() )
        {
            Sequence< Any > aServiceType( 1 );
            aServiceType[0] <<= TemplateDescription::FILEOPEN_SIMPLE;
            xInit->initialize( aServiceType );

            // add filter
            try
            {
                xFilterMgr->appendFilter(
                     OUString(),
                     OUString( RTL_CONSTASCII_USTRINGPARAM( "*.*" ) )
                     );
            }
            catch( IllegalArgumentException& )
            {
                DBG_ASSERT( 0, "caught IllegalArgumentException when registering filter\n" );
            }

            if( xFilePicker->execute() == ExecutableDialogResults::OK )
            {
                Sequence< OUString > aPathSeq( xFilePicker->getFiles() );
				INetURLObject aObj( aPathSeq[0] );
				aEdFilepath.SetText( aObj.PathToFileName() );
            }
        }
    }

	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SvInsertOleDlg, RadioHdl, RadioButton *, EMPTYARG )
{
	if ( aRbNewObject.IsChecked() )
	{
		aLbObjecttype.Show();
		aEdFilepath.Hide();
		aBtnFilepath.Hide();
		aCbFilelink.Hide();
		aGbObject.SetText( _aOldStr );
	}
	else
	{
		aLbObjecttype.Hide();
		aEdFilepath.Show();
		aBtnFilepath.Show();
		aGbObject.SetText( aStrFile );
	}
	return 0;
}

// -----------------------------------------------------------------------

SvInsertOleDlg::SvInsertOleDlg( Window* pParent ) :

	MdInsertOleobject( pParent, SoResid( MD_INSERT_OLEOBJECT ) )

{
	_aOldStr = aGbObject.GetText();
	aLbObjecttype.SetDoubleClickHdl(
		LINK( this, SvInsertOleDlg, DoubleClickHdl ) );
	aBtnFilepath.SetClickHdl( LINK( this, SvInsertOleDlg, BrowseHdl ) );
	Link aLink( LINK( this, SvInsertOleDlg, RadioHdl ) );
	aRbNewObject.SetClickHdl( aLink );
	aRbObjectFromfile.SetClickHdl( aLink );
	// Neu als Default
	aRbNewObject.Check( TRUE );
	RadioHdl( NULL );
}

// -----------------------------------------------------------------------

void SvInsertOleDlg::SelectDefault()
{
	aLbObjecttype.SelectEntryPos( 0 );
}

// class SvInsertPlugInDlg -----------------------------------------------

class SvInsertPlugInDlg : public MdInsertObjectPlugin
{
private:
	DECL_LINK( BrowseHdl, PushButton * );

public:
	SvInsertPlugInDlg( Window* pParent );

	String  GetPlugInFile() const { return aEdFileurl.GetText(); }
	String  GetPlugInOptions() const { return aEdPluginsOptions.GetText(); }
};

// -----------------------------------------------------------------------

IMPL_LINK( SvInsertPlugInDlg, BrowseHdl, PushButton *, EMPTYARG )
{
    Sequence< OUString > aFilterNames, aFilterTypes;
    void fillNetscapePluginFilters( Sequence< OUString >& rNames, Sequence< OUString >& rTypes );
    fillNetscapePluginFilters( aFilterNames, aFilterTypes );

    Reference< XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
    if( xFactory.is() )
    {
        Reference< XFilePicker > xFilePicker( xFactory->createInstance( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ui.dialogs.FilePicker" ) ) ), UNO_QUERY );
        DBG_ASSERT( xFilePicker.is(), "could not get FilePicker service" );

        Reference< XInitialization > xInit( xFilePicker, UNO_QUERY );
        Reference< XFilterManager > xFilterMgr( xFilePicker, UNO_QUERY );
        if( xInit.is() && xFilePicker.is() && xFilterMgr.is() )
        {
            Sequence< Any > aServiceType( 1 );
            aServiceType[0] <<= TemplateDescription::FILEOPEN_SIMPLE;
            xInit->initialize( aServiceType );

            // add the filters
            try
            {
                const OUString* pNames = aFilterNames.getConstArray();
                const OUString* pTypes = aFilterTypes.getConstArray();
                for( int i = 0; i < aFilterNames.getLength(); i++ )
                    xFilterMgr->appendFilter( pNames[i], pTypes[i] );
            }
            catch( IllegalArgumentException& )
            {
                DBG_ASSERT( 0, "caught IllegalArgumentException when registering filter\n" );
            }

            if( xFilePicker->execute() == ExecutableDialogResults::OK )
            {
                Sequence< OUString > aPathSeq( xFilePicker->getFiles() );
				INetURLObject aObj( aPathSeq[0] );
				aEdFileurl.SetText( aObj.PathToFileName() );
            }
        }
    }

	return 0;
}

// -----------------------------------------------------------------------

SvInsertPlugInDlg::SvInsertPlugInDlg( Window* pParent ) :

	MdInsertObjectPlugin( pParent, SoResid( MD_INSERT_OBJECT_PLUGIN ) )

{
	aBtnFileurl.SetClickHdl( LINK( this, SvInsertPlugInDlg, BrowseHdl ) );
}

// class SvInsertAppletDlg -----------------------------------------------

class SvInsertAppletDlg : public MdInsertObjectApplet
{
private:
	DECL_LINK( BrowseHdl, PushButton * );

public:
	SvInsertAppletDlg( Window* pParent );

	String  GetClass() const { return aEdClassfile.GetText(); }
	String  GetClassLocation() const { return aEdClasslocation.GetText(); }
	String  GetAppletOptions() const { return aEdAppletOptions.GetText(); }

	void    SetClass( const String &rClass ) { aEdClassfile.SetText(rClass); }
	void    SetClassLocation( const String &rLocation ) { aEdClasslocation.SetText(rLocation); }
	void    SetAppletOptions( const String &rOptions ) { aEdAppletOptions.SetText(rOptions); }
};

// -----------------------------------------------------------------------

IMPL_LINK( SvInsertAppletDlg, BrowseHdl, PushButton *, EMPTYARG )
{
    Reference< XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
    if( xFactory.is() )
    {
        Reference< XFilePicker > xFilePicker( xFactory->createInstance( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ui.dialogs.FilePicker" ) ) ), UNO_QUERY );
        DBG_ASSERT( xFilePicker.is(), "could not get FilePicker service" );

        Reference< XInitialization > xInit( xFilePicker, UNO_QUERY );
        Reference< XFilterManager > xFilterMgr( xFilePicker, UNO_QUERY );
        if( xInit.is() && xFilePicker.is() && xFilterMgr.is() )
        {
            Sequence< Any > aServiceType( 1 );
            aServiceType[0] <<= TemplateDescription::FILEOPEN_SIMPLE;
            xInit->initialize( aServiceType );

            // add filter
            try
            {
                xFilterMgr->appendFilter(
                     OUString( RTL_CONSTASCII_USTRINGPARAM( "Applet" ) ),
                     OUString( RTL_CONSTASCII_USTRINGPARAM( "*.class" ) )
                     );
            }
            catch( IllegalArgumentException& )
            {
                DBG_ASSERT( 0, "caught IllegalArgumentException when registering filter\n" );
            }

            if( xFilePicker->execute() == ExecutableDialogResults::OK )
            {
                Sequence< OUString > aPathSeq( xFilePicker->getFiles() );

				INetURLObject aObj( aPathSeq[0] );
                aEdClassfile.SetText( aObj.getName() );
                aObj.removeSegment();
				aEdClasslocation.SetText( aObj.PathToFileName() );
            }
        }
    }

	return 0;
}

// -----------------------------------------------------------------------

SvInsertAppletDlg::SvInsertAppletDlg( Window* pParent ) :

	MdInsertObjectApplet( pParent, SoResid( MD_INSERT_OBJECT_APPLET ) )

{
	aBtnClass.SetClickHdl( LINK( this, SvInsertAppletDlg, BrowseHdl ) );
}


// class SvInsertOleObjectDialog -----------------------------------------

void SvInsertOleObjectDialog::FillObjectServerList( SvObjectServerList* pList )

/*  [Beschreibung]

	Statische Methode mit der die "ubergebene Liste gef"ullt wird.
*/

{
	pList->FillInsertObjects();
}

// -----------------------------------------------------------------------

SvInPlaceObjectRef SvInsertOleObjectDialog::Execute
(
	Window* pParent,                // Parent f"ur den eigentlichen Dialog
	SvStorage* pStor,               // Storage f"ur die Factory-Methode
	const SvObjectServerList* pServers // wenn NULL, dann Default-Liste
)

/*  [Beschreibung]

	In dieser Methode wird der eigentliche Dialog gestartet. Wenn dieser
	mit <OK> beendet wurde, wird das <SvInPlaceObject> mit dem
	ausgew"ahlten <SvObjectServer> erzeugt. Sonst wird ein leerer
	<SvInPlaceObjectRef> zur"uckgegeben.
*/

{
    pStor = NULL;
	SvInPlaceObjectRef  xRet;
	SvObjectServerList  aObjS;

	// ggf. Serverliste f"ullen
	if ( !pServers )
	{
		aObjS.FillInsertObjects();
		pServers = &aObjS;
	}

	SvInsertOleDlg* pDlg = new SvInsertOleDlg( pParent );
	ListBox& rBox = pDlg->GetObjectTypes();
	rBox.SetUpdateMode( FALSE );

	for ( ULONG i = 0; i < pServers->Count(); i++ )
		rBox.InsertEntry( (*pServers)[ i ].GetHumanName() );
	rBox.SetUpdateMode( TRUE );
	pDlg->SelectDefault();
	pDlg->SetHelpId( nHelpId );

	if ( pDlg->Execute() )
	{
		_aFileName.Erase();
		_bLink = FALSE;
		_bCreateNew = pDlg->IsCreateNew();

		if ( _bCreateNew )
		{
			String aName = rBox.GetSelectEntry();
			const SvObjectServer* pS = pServers->Get( aName );

			if ( pS )
			{
				BOOL bOk;
				if(	pS->GetClassName() == *SvOutPlaceObject::ClassFactory() )
				{
					BOOL bIsInternal = FALSE;
					SvGlobalName aIntClassName;

                    pStor = new SvStorage( FALSE, String() );
					xRet = SvOutPlaceObject::InsertObject( NULL, pStor, bOk, aName, _aFileName, bIsInternal, aIntClassName );
					if ( !xRet.Is() && bIsInternal )
					{
						// it is StarOffice native document format
						// it should be inserted inplace
						if ( _aFileName.Len() && UCBStorage::IsStorageFile( _aFileName ) )
						{
							SvStorageRef pTmpStorHolder = pStor;
							pStor = new SvStorage( TRUE, String() );
							xRet = &((SvFactory*)SvInPlaceObject::ClassFactory())->
								CreateAndInit( _aFileName, pStor, _bLink );
						}
						else if ( aIntClassName != SvGlobalName() )
						{
							SvStorageRef pTmpStorHolder = pStor;
							pStor = NULL;

							xRet = &((SvFactory*)SvInPlaceObject::ClassFactory())->
								CreateAndInit( aIntClassName, pStor );
						}

						bOk = xRet.Is();
					}

					if( _aFileName.Len() )
						_bCreateNew = FALSE;
				}
				else
				{
					xRet = &((SvFactory*)SvInPlaceObject::ClassFactory())->
									CreateAndInit( pS->GetClassName(), pStor );
					bOk = xRet.Is();
				}
				if ( !bOk )
				{
					if( _aFileName.Len() )
					{
						// Objekt konnte nicht aus Datei erzeugt werden
						String aErr( SoResid( STR_ERROR_OBJNOCREATE_FROM_FILE ) );
						aErr.SearchAndReplace( String( '%' ), _aFileName );
						ErrorBox( pParent, WB_3DLOOK | WB_OK, aErr ).Execute();
					}
					else
					{
						// Objekt konnte nicht erzeugt werden
						String aErr( SoResid( STR_ERROR_OBJNOCREATE ) );
						aErr.SearchAndReplace( String( '%' ), aName );
						ErrorBox( pParent, WB_3DLOOK | WB_OK, aErr ).Execute();
					}
				}
			}
		}
		else
		{
			_aFileName = pDlg->GetFilePath();
			_bLink = pDlg->IsLinked();
            pStor = new SvStorage( UCBStorage::IsStorageFile( _aFileName ), String() );

            xRet = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit( _aFileName, pStor, _bLink );
			if ( !xRet.Is() )
			{
				// Objekt konnte nicht aus Datei erzeugt werden
				String aErr( SoResid( STR_ERROR_OBJNOCREATE_FROM_FILE ) );
				aErr.SearchAndReplace( String( '%' ), _aFileName );
				ErrorBox( pParent, WB_3DLOOK | WB_OK, aErr ).Execute();
			}
		}
	}

	delete pDlg;
	return xRet;
}

// class SvInsertPlugInDialog --------------------------------------------

SvInsertPlugInDialog::~SvInsertPlugInDialog()
{
	delete pURL;
}

// -----------------------------------------------------------------------

SvInPlaceObjectRef SvInsertPlugInDialog::Execute
(
	Window* pParent,        // Parent f"ur den eigentlichen Dialog
	SvStorage* pStor        // Storage f"ur die Factory-Methode
)

/*  [Beschreibung]

	In dieser Methode wird der eigentliche Dialog gestartet. Wenn dieser
	mit <OK> beendet wurde, wird das <SvInPlaceObject> mit der
	ausgew"ahlten URL erzeugt. Sonst wird ein leerer
	<SvInPlaceObjectRef> zur"uckgegeben.
*/

{
	aCommands.Erase();
	SvInPlaceObjectRef xRet;
	SvInsertPlugInDlg* pDlg = new SvInsertPlugInDlg( pParent );

	if ( pDlg->Execute() )
	{
		if ( !pURL )
			pURL = new INetURLObject();
		else
			*pURL = INetURLObject();

		pURL->SetSmartProtocol( INET_PROT_FILE );
		aCommands = pDlg->GetPlugInOptions();
		String aURL = pDlg->GetPlugInFile();
        if( aURL.Len() )
            aURL = so3::StaticBaseUrl::SmartRelToAbs( aURL );

		if ( ! aURL.Len() || pURL->SetSmartURL( aURL ) )
		{
			SvFactory* pPlugIn = (SvFactory*) SvPlugInObject::ClassFactory();
			SvPlugInObjectRef xObj =
				&pPlugIn->CreateAndInit( *pPlugIn, pStor );
			xObj->SetPlugInMode( (USHORT)PLUGIN_EMBEDED );
			xObj->SetURL( *pURL );
			USHORT nEaten;
			SvCommandList aLst;
			aLst.AppendCommands( aCommands, &nEaten );
			xObj->SetCommandList( aLst );
			xRet = (SvInPlaceObject*)&xObj;
		}
		else
		{
			// PlugIn konnte nicht erzeugt werden
			String aErr( SoResid( STR_ERROR_OBJNOCREATE_PLUGIN ) );
			aErr.SearchAndReplace( String( '%' ), aURL );
			ErrorBox( pParent, WB_3DLOOK | WB_OK, aErr ).Execute();
		}
	}
	delete pDlg;
	return xRet;
}

// class SvInsertAppletDialog --------------------------------------------

SvInsertAppletDialog::~SvInsertAppletDialog()
{
	delete pURL;
}

// -----------------------------------------------------------------------
#if SUPD<=358

SvInPlaceObjectRef SvInsertAppletDialog::Execute
(
	Window* pParent,        // Parent f"ur den eigentlichen Dialog
	SvStorage* pStor        // Storage f"ur die Factory-Methode
)
{
	return Execute( pParent, pStor, 0 );
}
#endif

SvInPlaceObjectRef SvInsertAppletDialog::Execute
(
	Window* pParent,        // Parent f"ur den eigentlichen Dialog
	SvStorage* pStor,       // Storage f"ur die Factory-Methode
	SvAppletObject* pObj    // != 0 => editieren / == 0 => neu anlegen
)

/*  [Beschreibung]

	In dieser Methode wird der eigentliche Dialog gestartet. Wenn dieser
	mit <OK> beendet wurde, wird das <SvInPlaceObject> mit der
	ausgew"ahlten URL erzeugt. Sonst wird ein leerer
	<SvInPlaceObjectRef> zur"uckgegeben.
*/

{
	aClass.Erase();
	aCommands.Erase();
	SvInPlaceObjectRef xRet;
	SvInsertAppletDlg *pDlg = new SvInsertAppletDlg( pParent );
	SvFactory *pApplet = (SvFactory*) SvAppletObject::ClassFactory();
	SvAppletObjectRef xObj = pObj;
	if ( xObj.Is() )
	{
		pDlg->SetClass( xObj->GetClass() );
		pDlg->SetClassLocation( xObj->GetCodeBase() );
		pDlg->SetAppletOptions( xObj->GetCommandList().GetCommands() );
		XubString aText( SoResid( STR_EDIT_APPLET ) );
		pDlg->SetText( aText );
	}

	if ( pDlg->Execute() )
	{
		if ( !xObj )
			xObj = &pApplet->CreateAndInit( *pApplet, pStor );
		BOOL bIPActive = xObj->GetProtocol().IsInPlaceActive();
		if ( bIPActive )
			xObj->GetProtocol().Reset2Open();
		String aClassLocation = pDlg->GetClassLocation();
		// Hack, aFileName wird auch fuer Class benutzt
		aClass = pDlg->GetClass();
		xObj->SetClass( aClass );

		OUString tmp = aClassLocation;
		::osl::File::getFileURLFromSystemPath(tmp, tmp);
		aClassLocation = tmp;

		xObj->SetCodeBase( aClassLocation );
		USHORT nEaten;
		aCommands = pDlg->GetAppletOptions();
		SvCommandList aLst;
		aLst.AppendCommands( aCommands, &nEaten );
		xObj->SetCommandList( aLst );
		xRet = (SvInPlaceObject*)&xObj;
		if ( bIPActive )
			xObj->DoInPlaceActivate(TRUE);
	}
	delete pDlg;
	return xRet;
}


