/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: stringanimation.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/13 16:04:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_STRINGANIMATION_HXX
#define _SLIDESHOW_STRINGANIMATION_HXX

#include <animation.hxx>

#include <rtl/ustring.hxx>


/* Definition of StringAnimation interface */

namespace slideshow
{
    namespace internal
    {
        /** Interface defining a string animation.

        	This interface is a specialization of the Animation
        	interface, and is used to animate attributes representable
        	by a discrete character string (e.g. font names)
         */
        class StringAnimation : public Animation
        {
        public:
            typedef ::rtl::OUString ValueType;

            /** Set the animation to value rStr

                @param rStr
                Current animation value.
             */
            virtual bool operator()( const ValueType& rStr ) = 0;

            /** Request the underlying value for this animation.

            	This is necessary for pure To or By animations, as the
            	Activity cannot determine a sensible start value
            	otherwise.

                @attention Note that you are only permitted to query
                for the underlying value, if the animation has actually
                been started (via start() call).
             */
            virtual ValueType getUnderlyingValue() const = 0;
        };

        typedef ::boost::shared_ptr< StringAnimation > StringAnimationSharedPtr;

    }
}

#endif /* _SLIDESHOW_STRINGANIMATION_HXX */
