/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewdlg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:04:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SCH_VIEW3D_HXX_
#define _SCH_VIEW3D_HXX_

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif


/*************************************************************************
|*
|* Dialog
|*
\************************************************************************/
class SchView3DDlg : public ModalDialog
{
private:
	FixedText		aFtXAxis;
	MetricField		aMtrFldXAxis;
	FixedText		aFtYAxis;
	MetricField		aMtrFldYAxis;
	FixedText		aFtZAxis;
	MetricField		aMtrFldZAxis;
	FixedLine		aFlAxis;
	OKButton		aBtnOK;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;

public:
			SchView3DDlg( Window* pWindow, short nXAngle = 0L,
						  short nYAngle = 0L, short nZAngle = 0L );
			~SchView3DDlg();

	short	GetXAngle() const { return (short) aMtrFldXAxis.GetValue(); }
	short	GetYAngle() const { return (short) aMtrFldYAxis.GetValue(); }
	short	GetZAngle() const { return (short) aMtrFldZAxis.GetValue(); }

	void	SetMax(short nXMax, short nYMax, short nZMax);
	void	SetMin(short nXMin, short nYMin, short nZMin);

	void    DisableOnPie ();
};



#endif // _SCH_VIEW3D_HXX_
