/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undmovpieseg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:00:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_UNDMOVPIESEG_HXX
#define _SCH_UNDMOVPIESEG_HXX

#include "schundo.hxx"

class SfxItemSet;
/*************************************************************************
|*
|* Undo for moving a pie segment
|*
\************************************************************************/

class SchUndoMovePieSeg : public SchUndoAction
{
public:
	TYPEINFO();

	SchUndoMovePieSeg(ChartModel& rChDoc
		, long nColumn, long nOldOff, long nNewOff );
	virtual ~SchUndoMovePieSeg(){}

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;

private:
	void DoMove(long nOff);

private:
	long	m_nCol;
	long	m_nOldOff;
	long	m_nNewOff;
};

#endif

