/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudgraxi.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:10:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#ifndef _SVX_SVXIDS_HRC //autogen
#include <svx/svxids.hrc>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#include "app.hrc"
#include "schresid.hxx"
#include "schdll.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "attrib.hrc"
#include "attrib.hxx"
#include "objid.hxx"
#include "undgraxi.hxx"
#include "fudgraxi.hxx"
#include "schattr.hxx"
#include "SchRangeChecker.hxx"
#include "glob.hrc"

#define ITEMID_FONTHEIGHT 1



TYPEINIT1(SchFuDiagramAxis, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuDiagramAxis::SchFuDiagramAxis(SchViewShell     *pViewSh,
								   SchWindow        *pWin,
								   SchView          *pView,
								   ChartModel *pDoc,
								   SfxRequest       &rReq,
								   Point            &rMDPos)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	aMDPos       = rMDPos;

	SdrObjGroup      *pAxisObj = NULL;
	const SfxItemSet *pArgs    = rReq.GetArgs();
	UINT16           nAxisId   = 0;
	SdrPage*         pPage     = pDoc->GetPage(0);
	AttrType         eType     = ATTR_AXIS;
    bool             bHasNumberFormatTabPage = false;
    const SfxPoolItem* pPoolItem = NULL;

	if (!pPage) return;
	else
	{
		switch (rReq.GetSlot ())
		{
			case SID_DIAGRAM_AXIS_X:
				nAxisId  = CHOBJID_DIAGRAM_X_AXIS;
				eType    = pDoc->Is3DChart()
							   ? ATTR_X_AXIS_3D
							   : ATTR_X_AXIS_2D;
                bHasNumberFormatTabPage = ( pDoc->IsXYChart() == TRUE );
                break;

			case SID_DIAGRAM_AXIS_Y:
				nAxisId  = CHOBJID_DIAGRAM_Y_AXIS;
				eType    = pDoc->Is3DChart()
							   ? ATTR_Y_AXIS_3D
							   : ATTR_Y_AXIS_2D;
                bHasNumberFormatTabPage = true;
                break;

			case SID_DIAGRAM_AXIS_Z:
				nAxisId  = CHOBJID_DIAGRAM_Z_AXIS;
				eType = ATTR_Z_AXIS;
				break;

			case SID_DIAGRAM_AXIS_A:
				nAxisId  = CHOBJID_DIAGRAM_A_AXIS;
				eType    = pDoc->Is3DChart()
							   ? ATTR_X_AXIS_3D
							   : ATTR_X_AXIS_2D;
                bHasNumberFormatTabPage = ( pDoc->IsXYChart() == TRUE );
				break;

			case SID_DIAGRAM_AXIS_B:
				nAxisId  = CHOBJID_DIAGRAM_B_AXIS;
				eType    = pDoc->Is3DChart()
							   ? ATTR_Y_AXIS_3D
							   : ATTR_Y_AXIS_2D;
                bHasNumberFormatTabPage = true;
				break;

			case SID_DIAGRAM_AXIS_C:
				nAxisId  = CHOBJID_DIAGRAM_C_AXIS;
				eType = ATTR_Z_AXIS;
				break;

            case SID_DIAGRAM_AXIS_ALL:
                bHasNumberFormatTabPage = ( pDoc->IsXYChart() == TRUE );
                eType = ATTR_AXIS;
                break;
		}

		pAxisObj = (SdrObjGroup*) GetObjWithId (nAxisId, *pPage, 0, IM_DEEPWITHGROUPS);
	}

	if (!pArgs)
	{
        BOOL bTextBreak = FALSE;
        bool bDontCareForTextBreak = false;
        switch( nAxisId )
        {
            case CHOBJID_DIAGRAM_X_AXIS:
            case CHOBJID_DIAGRAM_A_AXIS:
                bTextBreak = pDoc->GetFormatXAxisTextInMultipleLinesIfNecessary();
                break;
            case CHOBJID_DIAGRAM_Y_AXIS:
            case CHOBJID_DIAGRAM_B_AXIS:
                bTextBreak = pDoc->GetFormatYAxisTextInMultipleLinesIfNecessary();
                break;
            case CHOBJID_DIAGRAM_Z_AXIS:
            case CHOBJID_DIAGRAM_C_AXIS:
                bTextBreak = pDoc->GetFormatZAxisTextInMultipleLinesIfNecessary();
                break;

            default:
                bDontCareForTextBreak = !
                    ( ( pDoc->GetFormatXAxisTextInMultipleLinesIfNecessary() ==
                        pDoc->GetFormatYAxisTextInMultipleLinesIfNecessary()) &&
                      ( pDoc->GetFormatYAxisTextInMultipleLinesIfNecessary() ==
                        pDoc->GetFormatZAxisTextInMultipleLinesIfNecessary()) );
                if( ! bDontCareForTextBreak )
                    bTextBreak = pDoc->GetFormatXAxisTextInMultipleLinesIfNecessary();
                break;
        }

        // get attributes of specific axis, or of all displayed axes (if pAxisObj == 0)
		SfxItemSet aAttr( pDoc->GetFullAxisAttr( pAxisObj, true ));

        if( bDontCareForTextBreak )
            aAttr.InvalidateItem( SID_TEXTBREAK );
        else
            aAttr.Put( SfxBoolItem( SID_TEXTBREAK, bTextBreak ) );

        // show 'use source format' checkbox if inside Calc/Writer
        if( bHasNumberFormatTabPage &&
            ! pDoc->UsesOwnNumberFormatter() )
        {
            // set item to 'false' if not set yet (so that checkbox will be shown)
            if( SFX_ITEM_SET != aAttr.GetItemState( SID_ATTR_NUMBERFORMAT_SOURCE ))
            {
                aAttr.Put( SfxBoolItem( SID_ATTR_NUMBERFORMAT_SOURCE, TRUE ));
            }
        }

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//	    SchAttribTabDlg *pDlg =	new SchAttribTabDlg(&pViewSh->GetViewFrame()->GetWindow(), eType, &aAttr,
//                                                    pDoc->GetObjectShell(),	pDoc, 0, pDoc->ChartStyle());
		SchAttribTabDlg *pDlg =	new SchAttribTabDlg(NULL, eType, &aAttr,
													pDoc->GetObjectShell(),	pDoc, 0, pDoc->ChartStyle());

		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*pDlg->GetOutputItemSet());
			pArgs = rReq.GetArgs();

			if( pArgs->GetItemState( SID_TEXTBREAK, FALSE, &pPoolItem ) == SFX_ITEM_SET )
			{
				bTextBreak = static_cast< const SfxBoolItem * >( pPoolItem )->GetValue();
                switch( nAxisId )
                {
                    case CHOBJID_DIAGRAM_X_AXIS:
                    case CHOBJID_DIAGRAM_A_AXIS:
                        pDoc->SetFormatXAxisTextInMultipleLinesIfNecessary( bTextBreak );
                        break;
                    case CHOBJID_DIAGRAM_Y_AXIS:
                    case CHOBJID_DIAGRAM_B_AXIS:
                        pDoc->SetFormatYAxisTextInMultipleLinesIfNecessary( bTextBreak );
                        break;
                    case CHOBJID_DIAGRAM_Z_AXIS:
                    case CHOBJID_DIAGRAM_C_AXIS:
                        pDoc->SetFormatZAxisTextInMultipleLinesIfNecessary( bTextBreak );
                        break;

                    default:
                        pDoc->SetFormatXAxisTextInMultipleLinesIfNecessary( bTextBreak );
                        pDoc->SetFormatYAxisTextInMultipleLinesIfNecessary( bTextBreak );
                        pDoc->SetFormatZAxisTextInMultipleLinesIfNecessary( bTextBreak );
                        break;
                }
			}

/*
			//sobald die member bShow*Descr endlich entfallen, kann das hier alles weg
			if( pArgs->GetItemState( SCHATTR_AXIS_SHOWDESCR, FALSE, &pPoolItem ) == SFX_ITEM_SET )
			{
				BOOL bShow = ( (const SfxBoolItem*) pPoolItem)->GetValue();
				switch(nAxisId)
				{
					case CHOBJID_DIAGRAM_A_AXIS:
					case CHOBJID_DIAGRAM_B_AXIS:
					case CHOBJID_DIAGRAM_C_AXIS:
						break; //nothing to do!!!!
					case CHOBJID_DIAGRAM_X_AXIS:
						pDoc->ShowXDescr()=bShow;
						break;
					case CHOBJID_DIAGRAM_Y_AXIS:
						pDoc->ShowYDescr()=bShow;
						break;
					case CHOBJID_DIAGRAM_Z_AXIS:
						pDoc->ShowZDescr()=bShow;
						break;
				}
			}

*/

		}
		else
		{
			delete pDlg;
			return;
		}

		delete pDlg;

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	SfxItemSet aOldAttr			(pDoc->GetAxisAttr(pAxisObj));
	SfxItemSet aOldXAxisAttr	(pDoc->GetAttr(CHOBJID_DIAGRAM_X_AXIS));
	SfxItemSet aOldYAxisAttr	(pDoc->GetAttr(CHOBJID_DIAGRAM_Y_AXIS));
	SfxItemSet aOldZAxisAttr	(pDoc->GetAttr(CHOBJID_DIAGRAM_Z_AXIS));

	if( pViewSh )
		pViewSh->GetViewFrame()->GetDispatcher()->Execute(
			SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

	pAxisObj = (SdrObjGroup*) GetObjWithId (nAxisId, *pPage, 0, IM_DEEPWITHGROUPS);

	if (pDoc->ChangeAxisAttr(*pArgs, pAxisObj))
	{
		SchUndoDiagramAxis* pUndo =	new SchUndoDiagramAxis(*pDoc, nAxisId, aOldXAxisAttr,
														   aOldYAxisAttr, aOldZAxisAttr,
														   aOldAttr, *pArgs);
		pUndo->SetComment(String(SchResId(STR_UNDO_DIAGRAM_AXIS)));

		pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	}

    // refresh if source format should be used
    if( ! pDoc->UsesOwnNumberFormatter() &&
        SFX_ITEM_SET ==
        pArgs->GetItemState( SID_ATTR_NUMBERFORMAT_SOURCE, FALSE, &pPoolItem ) &&
        ( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem )->GetValue() == TRUE ))
    {
        if( pDoc->CheckForNewAxisNumFormat())
            pDoc->BuildChart( FALSE );
    }

	SchRangeChecker	RangeChecker (pDoc);
	if (RangeChecker.TestLogarithmicValues ())
	{
		InfoBox	aInfoBox (NULL, String(SchResId(STR_NO_LOGARITHMIC_MIN_VALUES)));
		aInfoBox.Execute();
	}

	// FG: RemarkObject muss deshalb gerufen werden weil pDoc->ChangeAxisAttr(...)
	//     das Chart komplett neu (BuildChart) aufbaut, das bedeutet die vorher
	//     markierten Objekte existieren nicht mehr. Um die Objekte dennoch
	//     wiederzufinden, verpasst man ihnen eine eindeutige Nummer.
	//     GetObjWithId liefert das passende Object.
	nMarkedID = nAxisId;
	RemarkObject ();
}


void SchFuDiagramAxis::Activate()
{
}

void SchFuDiagramAxis::Deactivate()
{
}



