/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudgraut.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:59:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif


#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>

#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#include "schview.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "viewshel.hxx"
#include "dlggraut.hxx"
#include "undgraut.hxx"
#include "fudgraut.hxx"

#include "chtscene.hxx"
#include "SchRangeChecker.hxx"
#include "glob.hrc"

TYPEINIT1(SchFuDiagramAutoPilot, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuDiagramAutoPilot::SchFuDiagramAutoPilot(SchViewShell* pViewSh,
											 SchWindow* pWin, SchView* pView,
											 ChartModel* pDoc,
											 SfxRequest& rReq) :
	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	SvxChartStyle eOldStyle		= pDoc->ChartStyle();
//	long nOldGapWidth			= pDoc->GapWidth();
//	long nOldOverlap			= pDoc->Overlap();

	BOOL   bOldShowMainTitle	= pDoc->ShowMainTitle();
	String aOldMainTitle		= pDoc->MainTitle();
	BOOL   bOldShowSubTitle		= pDoc->ShowSubTitle();
	String aOldSubTitle			= pDoc->SubTitle();
	BOOL   bOldShowXAxisTitle	= pDoc->ShowXAxisTitle();
	String aOldXAxisTitle		= pDoc->XAxisTitle();
	BOOL   bOldShowYAxisTitle	= pDoc->ShowYAxisTitle();
	String aOldYAxisTitle		= pDoc->YAxisTitle();
	BOOL   bOldShowZAxisTitle	= pDoc->ShowZAxisTitle();
	String aOldZAxisTitle		= pDoc->ZAxisTitle();
	BOOL   bOldShowXAxis		= pDoc->ShowXAxis();
	BOOL   bOldShowXGridMain	= pDoc->ShowXGridMain();
	BOOL   bOldShowXGridHelp	= pDoc->ShowXGridHelp();
	BOOL   bOldShowXDescr		= pDoc->ShowXDescr();
	BOOL   bOldShowYAxis		= pDoc->ShowYAxis();
	BOOL   bOldShowYGridMain	= pDoc->ShowYGridMain();
	BOOL   bOldShowYGridHelp	= pDoc->ShowYGridHelp();
	BOOL   bOldShowYDescr		= pDoc->ShowYDescr();
	BOOL   bOldShowZAxis		= pDoc->ShowZAxis();
	BOOL   bOldShowZGridMain	= pDoc->ShowZGridMain();
	BOOL   bOldShowZGridHelp	= pDoc->ShowZGridHelp();
	BOOL   bOldShowZDescr		= pDoc->ShowZDescr();
	BOOL   bOldSwitchData		= pDoc->IsSwitchData();
	long   nOldChartShapeType   = pDoc->GetChartShapeType();

	const SfxPoolItem *pPoolItem = NULL;
	SfxItemSet aAttr(pDoc->GetLegendAttr());
	SvxChartLegendPos eOldLegendPos =
		(aAttr.GetItemState(SCHATTR_LEGEND_POS, TRUE, &pPoolItem)
			== SFX_ITEM_SET) ?
		((const SvxChartLegendPosItem*)pPoolItem)->GetValue() : CHLEGEND_NONE;

	SchChartDocShell* pChDocSh =
				new SchChartDocShell(SFX_CREATE_MODE_PREVIEW);
	SfxObjectShellLock aDocShellRef = pChDocSh;
	aDocShellRef->DoInitNew(NULL);

	ChartModel &rChDoc    = pChDocSh->GetDoc();
	BOOL             bOldLegend = pDoc->GetShowLegend();
	short            nXAngle;
	short            nYAngle;
	short            nZAngle;

    // #92872# set switch before data !
	rChDoc.SetSwitchData (pDoc->IsSwitchData());
	rChDoc.SetChartData(*pDoc->GetChartData());
	pDoc->GetAngles (nXAngle, nYAngle, nZAngle);
	rChDoc.SetAngles (nXAngle, nYAngle, nZAngle);
	rChDoc.SetShowLegend (pDoc->GetShowLegend());

	rChDoc.ChartStyle ()         = eOldStyle;
//	rChDoc.GapWidth ()           = nOldGapWidth;
//	rChDoc.Overlap ()            = nOldOverlap;
	rChDoc.ShowMainTitle ()      = bOldShowMainTitle;
	rChDoc.MainTitle ()          = aOldMainTitle;
	rChDoc.SubTitle ()           = aOldSubTitle;
	rChDoc.ShowSubTitle ()       = bOldShowSubTitle;
	rChDoc.ShowXAxisTitle ()     = bOldShowXAxisTitle;
	rChDoc.XAxisTitle ()         = aOldXAxisTitle;
	rChDoc.ShowYAxisTitle ()     = bOldShowYAxisTitle;
	rChDoc.YAxisTitle ()         = aOldYAxisTitle;
	rChDoc.ShowZAxisTitle ()     = bOldShowZAxisTitle;
	rChDoc.ZAxisTitle ()         = aOldZAxisTitle;
	rChDoc.ShowXAxis (bOldShowXAxis);
	rChDoc.ShowXGridMain ()      = bOldShowXGridMain;
	rChDoc.ShowXGridHelp ()      = bOldShowXGridHelp;
	rChDoc.ShowXDescr (bOldShowXDescr);
	rChDoc.ShowYAxis (bOldShowYAxis);
	rChDoc.ShowYGridMain ()      = bOldShowYGridMain;
	rChDoc.ShowYGridHelp ()      = bOldShowYGridHelp;
	rChDoc.ShowYDescr (bOldShowYDescr);
	rChDoc.ShowZAxis (bOldShowZAxis);
	rChDoc.ShowZGridMain ()      = bOldShowZGridMain;
	rChDoc.ShowZGridHelp ()      = bOldShowZGridHelp;
	rChDoc.ShowZDescr (bOldShowZDescr);
	rChDoc.DataDescr ()          = CHDESCR_NONE;
	rChDoc.ShowSym ()            = FALSE;
/*	In den Achsenattributen enthalten
	rChDoc.Val Format ()          = pDoc->Va lFormat();
	rChDoc.Perc entValFormat ()   = pDoc->Per centValFormat();
	rChDoc.Desc rFormat ()        = pDoc->Des crFormat();
	rChDoc.Percen tDescrFormat () = pDoc->Des crFormat(); */

	rChDoc.PutTitleAttr(pDoc->GetTitleAttr());
	rChDoc.PutMainTitleAttr(pDoc->GetMainTitleAttr());
	rChDoc.PutSubTitleAttr(pDoc->GetSubTitleAttr());
	rChDoc.PutXAxisTitleAttr(pDoc->GetXAxisTitleAttr());
	rChDoc.PutYAxisTitleAttr(pDoc->GetYAxisTitleAttr());
	rChDoc.PutZAxisTitleAttr(pDoc->GetZAxisTitleAttr());
	rChDoc.PutAxisAttr(pDoc->GetAxisAttr());

	rChDoc.CopyAxisAttributes(pDoc,TRUE);

	rChDoc.PutGridAttr(pDoc->GetGridAttr());
	rChDoc.PutXGridMainAttr(pDoc->GetXGridMainAttr());
	rChDoc.PutYGridMainAttr(pDoc->GetYGridMainAttr());
	rChDoc.PutZGridMainAttr(pDoc->GetZGridMainAttr());
	rChDoc.PutXGridHelpAttr(pDoc->GetXGridHelpAttr());
	rChDoc.PutYGridHelpAttr(pDoc->GetYGridHelpAttr());
	rChDoc.PutZGridHelpAttr(pDoc->GetZGridHelpAttr());
	rChDoc.PutDiagramAreaAttr(pDoc->GetDiagramAreaAttr());
	rChDoc.PutDiagramWallAttr(pDoc->GetDiagramWallAttr());
	rChDoc.PutDiagramFloorAttr(pDoc->GetDiagramFloorAttr());
	rChDoc.PutLegendAttr(pDoc->GetLegendAttr());

	rChDoc.SetAttributes(CHOBJID_DIAGRAM_STOCKLOSS_GROUP,pDoc->GetAttr(CHOBJID_DIAGRAM_STOCKLOSS_GROUP),FALSE);
	rChDoc.SetAttributes(CHOBJID_DIAGRAM_STOCKPLUS_GROUP,pDoc->GetAttr(CHOBJID_DIAGRAM_STOCKPLUS_GROUP),FALSE);
	rChDoc.SetAttributes(CHOBJID_DIAGRAM_STOCKLINE_GROUP,pDoc->GetAttr(CHOBJID_DIAGRAM_STOCKLINE_GROUP),FALSE);
	//Textgroesse wird falsch skaliert, da alle Textattr. relativ zu aInitialSize sind #47892#
	rChDoc.InitialSize() = pDoc->InitialSize();

	rChDoc.SetShowDataDescr(FALSE); //die Datenbeschriftung wird im Autopiloten aus Platzmangel verboten

    rChDoc.InitDataAttrs();

    long nColCnt, nRowCnt, nMax, i,j;
    if( rChDoc.IsPieChart())
    {
        nRowCnt = rChDoc.GetColCount();
        nColCnt = rChDoc.GetRowCount();
    }
	else
    {
        nRowCnt = rChDoc.GetRowCount();
        nColCnt = rChDoc.GetColCount();
    }

	for (i = 0; i < nRowCnt; i++)
		rChDoc.PutDataRowAttr(i, pDoc->GetDataRowAttr(i));

	for (i = 0; i < nColCnt; i++)
		for (j = 0; j < nRowCnt; j++)
			if (pDoc->IsDataPointAttrSet (i, j))
				rChDoc.PutDataPointAttr(i, j, pDoc->GetDataPointAttr(i, j));

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//	SchDiagramAutoPilotDlg* pDlg = new SchDiagramAutoPilotDlg(&pViewSh->GetViewFrame()->GetWindow(),
//			                                                  aDocShellRef);
	SchDiagramAutoPilotDlg* pDlg = new SchDiagramAutoPilotDlg(NULL, aDocShellRef);

	// #74709# this is just a fix for this place again and no general enhancement :-(
	if( rChDoc.IsPieChart() && rChDoc.IsReal3D() )
	{
		ChartScene* pScene = rChDoc.GetScene();
		if( pScene )
		{
			::basegfx::B3DHomMatrix aSceneMatrix;
			aSceneMatrix.rotate( -F_PI/3.0, 0.0, 0.0 );
			pScene->SetTransform( aSceneMatrix );
		}
	}

    // #101164# number of lines for a combi chart has to be saved
    rChDoc.SetNumLinesColChart( pDoc->GetNumLinesColChart());

		// FG: 13.3.97 folgendes ist aus dem Draw fuinsfil.cxx uebernommen
		// Ev. wird eine QueryBox geoeffnet ("Links aktualisieren?"),
		// daher wird der Dialog der aktuelle DefModalDialogParent
	Window* pDefParent = GetpApp()->GetDefDialogParent();
	GetpApp()->SetDefDialogParent(pDlg);

	pDlg->SetLegendPos(eOldLegendPos);

	USHORT nResult = pDlg->Execute();

	GetpApp()->SetDefDialogParent(pDefParent);

	delete pDlg;

	if (nResult == RET_OK)
	{
		rReq.Done();

		if( pViewSh )
			pViewSh->GetViewFrame()->GetDispatcher()->Execute(
				SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

		SvxChartStyle eNewStyle		= rChDoc.ChartStyle();
//		long nNewGapWidth			= rChDoc.GapWidth();
//		long nNewOverlap			= rChDoc.Overlap();

		CheckRange (pDoc, eNewStyle);

		BOOL   bNewShowMainTitle	= rChDoc.ShowMainTitle();
		String aNewMainTitle		= rChDoc.MainTitle();
		BOOL   bNewShowSubTitle		= rChDoc.ShowSubTitle();
		String aNewSubTitle			= rChDoc.SubTitle();
		BOOL   bNewShowXAxisTitle	= rChDoc.ShowXAxisTitle();
		String aNewXAxisTitle		= rChDoc.XAxisTitle();
		BOOL   bNewShowYAxisTitle	= rChDoc.ShowYAxisTitle();
		String aNewYAxisTitle		= rChDoc.YAxisTitle();
		BOOL   bNewShowZAxisTitle	= rChDoc.ShowZAxisTitle();
		String aNewZAxisTitle		= rChDoc.ZAxisTitle();
		BOOL   bNewShowXAxis		= rChDoc.ShowXAxis();
		BOOL   bNewShowXGridMain	= rChDoc.ShowXGridMain();
		BOOL   bNewShowXGridHelp	= rChDoc.ShowXGridHelp();
		BOOL   bNewShowXDescr		= rChDoc.ShowXDescr();
		BOOL   bNewShowYAxis		= rChDoc.ShowYAxis();
		BOOL   bNewShowYGridMain	= rChDoc.ShowYGridMain();
		BOOL   bNewShowYGridHelp	= rChDoc.ShowYGridHelp();
		BOOL   bNewShowYDescr		= rChDoc.ShowYDescr();
		BOOL   bNewShowZAxis		= rChDoc.ShowZAxis();
		BOOL   bNewShowZGridMain	= rChDoc.ShowZGridMain();
		BOOL   bNewShowZGridHelp	= rChDoc.ShowZGridHelp();
		BOOL   bNewShowZDescr		= rChDoc.ShowZDescr();
		BOOL   bNewSwitchData		= rChDoc.IsSwitchData();
		BOOL   bNewShowLegend		= rChDoc.GetShowLegend();
		long   nNewChartShapeType   = rChDoc.GetChartShapeType();

		if (nNewChartShapeType != nOldChartShapeType   ||
			eNewStyle != eOldStyle || /*nNewGapWidth != nOldGapWidth ||
			nNewOverlap != nOldOverlap ||*/
			bNewShowMainTitle != bOldShowMainTitle ||
			aNewMainTitle != aOldMainTitle ||
			bNewShowSubTitle != bOldShowSubTitle ||
			aNewSubTitle != aOldSubTitle ||
			bNewShowXAxisTitle != bOldShowXAxisTitle ||
			aNewXAxisTitle != aOldXAxisTitle ||
			bNewShowYAxisTitle != bOldShowYAxisTitle ||
			aNewYAxisTitle != aOldYAxisTitle ||
			bNewShowZAxisTitle != bOldShowZAxisTitle ||
			aNewZAxisTitle != aOldZAxisTitle ||
			bNewShowXAxis != bOldShowXAxis ||
			bNewShowXGridMain != bOldShowXGridMain ||
			bNewShowXGridHelp != bOldShowXGridHelp ||
			bNewShowXDescr != bOldShowXDescr ||
			bNewShowYAxis != bOldShowYAxis ||
			bNewShowYGridMain != bOldShowYGridMain ||
			bNewShowYGridHelp != bOldShowYGridHelp ||
			bNewShowYDescr != bOldShowYDescr ||
			bNewShowZAxis != bOldShowZAxis ||
			bNewShowZGridMain != bOldShowZGridMain ||
			bNewShowZGridHelp != bOldShowZGridHelp ||
			bNewShowZDescr != bOldShowZDescr ||
			bNewSwitchData != bOldSwitchData ||
			bNewShowLegend != bOldLegend )
		{
/*			for (i = 0; i < nPieSegCnt; i++)
				pDoc->PieSegOfs (i) = pNewPieSegOfs[i];
*/
			pDoc->ShowMainTitle ()  = bNewShowMainTitle;
			pDoc->MainTitle ()      = aNewMainTitle;
			pDoc->ShowSubTitle ()   = bNewShowSubTitle;
			pDoc->SubTitle ()       = aNewSubTitle;
			pDoc->ShowXAxisTitle () = bNewShowXAxisTitle;
			pDoc->XAxisTitle ()     = aNewXAxisTitle;
			pDoc->ShowYAxisTitle () = bNewShowYAxisTitle;
			pDoc->YAxisTitle ()     = aNewYAxisTitle;
			pDoc->ShowZAxisTitle () = bNewShowZAxisTitle;
			pDoc->ZAxisTitle ()     = aNewZAxisTitle;
			pDoc->ShowXAxis (bOldShowXAxis);
			pDoc->ShowXGridMain ()  = bNewShowXGridMain;
			pDoc->ShowXGridHelp ()  = bNewShowXGridHelp;
			pDoc->ShowXDescr (bNewShowXDescr);
			pDoc->ShowYAxis (bNewShowYAxis);
			pDoc->ShowYGridMain ()  = bNewShowYGridMain;
			pDoc->ShowYGridMain ()  = bNewShowYGridMain;
			pDoc->ShowYGridHelp ()  = bNewShowYGridHelp;
			pDoc->ShowYDescr (bNewShowYDescr);
			pDoc->ShowZAxis (bNewShowZAxis);
			pDoc->ShowZGridMain ()  = bNewShowZGridMain;
			pDoc->ShowZGridHelp ()  = bNewShowZGridHelp;
			pDoc->ShowZDescr (bNewShowZDescr);
            if( bNewSwitchData != bOldSwitchData )
                pDoc->ChangeSwitchData (bNewSwitchData);
			pDoc->SetShowLegend (bNewShowLegend);

			if(nNewChartShapeType != nOldChartShapeType)
			{
				SfxItemSet aSet(pDoc->GetPool(),SCHATTR_STYLE_SHAPE,SCHATTR_STYLE_SHAPE);
				aSet.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,nNewChartShapeType));
//				long nCnt=pDoc->GetRowCount();
//				while(nCnt--)
				pDoc->PutDataRowAttrAll(aSet);
			}


			//	Get a list of offsets of the pie segments for passing it to the undo object.
			short nOldPieSegCnt = pDoc->PieSegCount();
			long * pOldPieSegOfs = new long [nOldPieSegCnt];
			for (i=0; i<nOldPieSegCnt; i++)
				pOldPieSegOfs[i] = pDoc->PieSegOfs(i);

			pDoc->ChangeChart( eNewStyle );
			pDoc->BuildChart(FALSE);
			
			//	Again get a list of offsets of the pie segments.  The call to ChangeChart
			//	may have changed the offsets.  Both lists are passed to the undo action which
			//	also takes care of deleting them.
			short nNewPieSegCnt = pDoc->PieSegCount();
			long *pNewPieSegOfs = new long [nNewPieSegCnt];
			for (i=0; i<nNewPieSegCnt; i++)
				pNewPieSegOfs[i] = pDoc->PieSegOfs(i);


			SchUndoDiagramAutoPilot* pUndo =
				new SchUndoDiagramAutoPilot(*pDoc, 
					//	Old values.
					eOldStyle,
					pOldPieSegOfs, nOldPieSegCnt, 
					bOldShowMainTitle, aOldMainTitle, 
					bOldShowSubTitle, aOldSubTitle, 
					bOldShowXAxisTitle, aOldXAxisTitle, 
					bOldShowYAxisTitle, aOldYAxisTitle, 
					bOldShowZAxisTitle, aOldZAxisTitle, 
					bOldShowXAxis, bOldShowXGridMain, bOldShowXGridHelp, bOldShowXDescr,
					bOldShowYAxis, bOldShowYGridMain, bOldShowYGridHelp, bOldShowYDescr,
					bOldShowZAxis, bOldShowZGridMain, bOldShowZGridHelp, bOldShowZDescr,
					bOldSwitchData,
					eOldLegendPos,
					//	New values.
					eNewStyle,
					pNewPieSegOfs, nNewPieSegCnt,
					bNewShowMainTitle, aNewMainTitle,
					bNewShowSubTitle, aNewSubTitle,
					bNewShowXAxisTitle, aNewXAxisTitle,
					bNewShowYAxisTitle, aNewYAxisTitle,
					bNewShowZAxisTitle, aNewZAxisTitle,
					bNewShowXAxis, bNewShowXGridMain, bNewShowXGridHelp, bNewShowXDescr,
					bNewShowYAxis, bNewShowYGridMain, bNewShowYGridHelp, bNewShowYDescr,
					bNewShowZAxis, bNewShowZGridMain, bNewShowZGridHelp, bNewShowZDescr,
					bNewSwitchData,
					bNewShowLegend);
					
			pUndo->SetComment(String(SchResId(STR_UNDO_AUTOFORMAT)));

			pViewSh->GetViewFrame()->GetObjectShell()->
				GetUndoManager()->AddUndoAction(pUndo);

			return;
		}
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramAutoPilot::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramAutoPilot::Deactivate()
{
}



void	SchFuDiagramAutoPilot::CheckRange	(ChartModel * pChartModel,
											SvxChartStyle nStyle)
{
	SchRangeChecker	RangeChecker (pChartModel);
	
	if (RangeChecker.TestAbsoluteValues (nStyle))
	{
		InfoBox	aInfoBox (NULL, String(SchResId(STR_ONLY_ABS_VALUES)));
		aInfoBox.Execute();
	}
	else if (RangeChecker.TestNegativeValues (nStyle))
	{
		InfoBox	aInfoBox (NULL, String(SchResId(STR_NO_MIN_VALUES)));
		aInfoBox.Execute();
	}

	if (RangeChecker.TestLogarithmicValues ())
	{
		InfoBox	aInfoBox (NULL,String(SchResId(STR_NO_LOGARITHMIC_MIN_VALUES)));
		aInfoBox.Execute();
	}
}
