/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccTitle.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:59:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "AccTitle.hxx"

#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif
#ifndef SVX_UNOSHTXT_HXX
#include <svx/unoshtxt.hxx>
#endif
#ifndef _SVX_ACCESSILE_TEXT_HELPER_HXX_
#include <svx/AccessibleTextHelper.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_SCHVIEW_HXX
#include "schview.hxx"
#endif
#ifndef _SCH_VIEWSHEL_HXX
#include "viewshel.hxx"
#endif
#ifndef _SCH_SDWINDOW_HXX
#include "chwindow.hxx"
#endif

using ::rtl::OUString;
using namespace ::com::sun::star;
using namespace ::com::sun::star::accessibility;

namespace accessibility
{

Title::Title( AccessibleBase * pParent, TitleType eType ) :
        AccessibleChartElement( AccessibleUniqueId( static_cast< sal_uInt16 >( eType ) ),
                                pParent,
                                false /* has no children that are managed by base classes */ ),
        m_eType( eType ),
        m_pTextHelper( 0 )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );
    
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        SetItemSet( pModel->GetTitleAttr( static_cast< sal_uInt16 >( eType ) ) );
        // \-- solar
    }
}

Title::~Title()
{
    OSL_ENSURE( m_pTextHelper == 0, "Title was not disposed?" );
    if( m_pTextHelper != 0 )
        delete m_pTextHelper;
}

void Title::InitTextEdit()
{
    CheckDisposeState();

    OSL_ASSERT( m_pTextHelper == 0 );

    SchWindow * pWin = GetWindow();
    if( pWin )
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        SchViewShell * pViewShell = pWin->GetViewShell();
        if( pViewShell )
        {
            SdrView * pView = pViewShell->GetView();
            if( pView )
            {
                SvxEditSource * pEditSource = new SvxTextEditSource(
                    *(GetDrawObject()), *pView, *pWin );
                m_pTextHelper = new ::accessibility::AccessibleTextHelper(
                    ::std::auto_ptr< SvxEditSource >( pEditSource ) );
                OSL_ASSERT( m_pTextHelper );
                m_pTextHelper->SetEventSource( this );
            }
        }
        // \-- solar
    }

    OSL_ASSERT( m_pTextHelper != 0 );
}

// ________ AccessibleBase::XComponent ________
void SAL_CALL Title::dispose()
throw (uno::RuntimeException)
{
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        if( m_pTextHelper != 0 )
        {
            m_pTextHelper->Dispose();
            delete m_pTextHelper;
            m_pTextHelper = 0;
        }
        // \-- solar
    }
    
    AccessibleChartElement::dispose();
}

// ________ XAccessibleContext ________
sal_Int32 SAL_CALL Title::getAccessibleChildCount()
    throw (uno::RuntimeException)
{
    // may throw DisposedException
    CheckDisposeState();

    sal_Int32 nCount = 0;

    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        if( ! m_pTextHelper )
            InitTextEdit();

        if( m_pTextHelper )
            nCount = m_pTextHelper->GetChildCount();
        // \-- solar
    }
 
    return nCount;
}

uno::Reference< XAccessible > SAL_CALL
    Title::getAccessibleChild( sal_Int32 i )
    throw (lang::IndexOutOfBoundsException,
           uno::RuntimeException)
{
    // may throw DisposedException
    CheckDisposeState();

    uno::Reference< XAccessible > xResult;

    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        if( ! m_pTextHelper )
            InitTextEdit();

        if( m_pTextHelper )
            xResult.set( m_pTextHelper->GetChild( i ) );
        // \-- solar
    }

    return xResult;
}

OUString SAL_CALL Title::getAccessibleName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return getToolTipText();
}

OUString SAL_CALL Title::getAccessibleDescription()
    throw (::com::sun::star::uno::RuntimeException)
{
    ChartModel * pModel = GetChartModel();

    if( pModel != NULL )
    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        switch( m_eType )
        {
            case MAIN:
                return OUString( pModel->MainTitle() );
            case SUB:
                return OUString( pModel->SubTitle() );
            case X_AXIS:
                return OUString( pModel->XAxisTitle() );
            case Y_AXIS:
                return OUString( pModel->YAxisTitle() );
            case Z_AXIS:
                return OUString( pModel->ZAxisTitle() );
        }
        // \-- solar
    }

    return getAccessibleName();
}

// ________ XAccessibleEventBroadcaster ________
void SAL_CALL Title::addEventListener(
    const uno::Reference< XAccessibleEventListener >& xListener )
    throw (uno::RuntimeException)
{
    // may throw DisposedException
    CheckDisposeState();

    AccessibleBase::addEventListener( xListener );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    if( ! m_pTextHelper )
        InitTextEdit();

    if( m_pTextHelper )
        m_pTextHelper->AddEventListener( xListener );
    // \-- solar
}

void SAL_CALL Title::removeEventListener(
    const uno::Reference< XAccessibleEventListener >& xListener )
    throw (uno::RuntimeException)
{
    // may throw DisposedException
    CheckDisposeState();

    AccessibleBase::removeEventListener( xListener );    

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    if( ! m_pTextHelper )
        InitTextEdit();

    if( m_pTextHelper )
        m_pTextHelper->RemoveEventListener( xListener );
    // \-- solar
}

// ________ XAccessibleComponent ________
uno::Reference< XAccessible > SAL_CALL Title::getAccessibleAtPoint( const awt::Point& aPoint )
    throw (uno::RuntimeException)
{
    // may throw DisposedException
    CheckDisposeState();

    uno::Reference< XAccessible > xResult;

    {
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        if( ! m_pTextHelper )
            InitTextEdit();

        if( m_pTextHelper )
            xResult.set( m_pTextHelper->GetAt( aPoint ) );
        // \-- solar
    }

    return xResult;
}

OUString SAL_CALL Title::getImplementationName() 
    throw (uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccTitle" ));
}

}  // namespace accessibility
