/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccStatisticsObject.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:59:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SCH_ACCSTATISTICSOBJECT_HXX
#define _SCH_ACCSTATISTICSOBJECT_HXX

#ifndef _SCH_ACCESSIBLECHARTELEMENT_HXX_
#include "AccessibleChartElement.hxx"
#endif

// for CHOBJID_...
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif

namespace accessibility
{

class StatisticsObject : public AccessibleChartElement
{
public:
    enum StatisticsObjectType
    {
        MEAN_VAL_LINE = CHOBJID_DIAGRAM_AVERAGEVALUE,
        ERROR_BARS    = CHOBJID_DIAGRAM_ERROR,
        REGRESSION    = CHOBJID_DIAGRAM_REGRESSION
    };

    StatisticsObject( AccessibleBase * pParent, StatisticsObjectType eType,
                      sal_uInt16 nSeriesIndex );

    virtual ~StatisticsObject();

    // ________ XAccessibleContext ________
    virtual ::rtl::OUString SAL_CALL getAccessibleName() throw (::com::sun::star::uno::RuntimeException);

    // ________ XServiceInfo ________
    virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);

protected:
    // AccessibleChartElement
    virtual SdrObject * GetDrawObject() const;

private:
    const StatisticsObjectType    m_eType;
    const sal_uInt16              m_nSeriesIndex;
};

}  // accessibility

// _SCH_ACCSTATISTICSOBJECT_HXX
#endif
