/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccLegend.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:59:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "AccLegend.hxx"

// for SolarMutex
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

#include "AccLegendEntry.hxx"

using ::rtl::OUString;

namespace accessibility
{

Legend::Legend( AccessibleBase * pParent ) :
        AccessibleChartElement( AccessibleUniqueId( CHOBJID_LEGEND ),
                                pParent,
                                true /* may have children */ ),
    m_nEntries( 0 )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->GetLegendAttr() );
    // \-- solar
}

Legend::~Legend()
{}

// OUString SAL_CALL Legend::getAccessibleName()
//     throw (::com::sun::star::uno::RuntimeException)
// {
//     return OUString( RTL_CONSTASCII_USTRINGPARAM( "Legend" ) );
// }

bool Legend::UpdateChildren()
{
    ChartModel * pModel = GetChartModel();
    sal_uInt16 nNumChildren = 0;

    bool bHasDomain = false;
    bool bIsPieChart = false;
    
    {
        // /-- solar
        ::vos::OClearableGuard aSolarGuard( Application::GetSolarMutex() );
        bHasDomain = (pModel && pModel->IsXYChart());
        bIsPieChart = (pModel && pModel->IsPieChart());

        nNumChildren = static_cast< sal_uInt16 >( bIsPieChart
                                                  ? pModel->GetColCount()
                                                  : pModel->GetRowCount() );
        if( bHasDomain )
        {
            OSL_ASSERT( ! bIsPieChart );
            --nNumChildren;
        }
        // \-- solar
    }

    // /--
    ::osl::ResettableMutexGuard aGuard( GetMutex());
    sal_uInt16 nEntry = 0;
    sal_uInt16 nMemberEntries = m_nEntries;
    sal_uInt16 nOffset = bHasDomain ? 1 : 0;

    aGuard.clear();
    // \--

    // remove legend entries
    for( nEntry = nNumChildren; nEntry < nMemberEntries; ++nEntry )
    {
        UpdateChild( AccessibleUniqueId( LegendEntry::ObjectId, nEntry + nOffset ),
                     true, false );
    }

    // add legend entries
    for( nEntry = nMemberEntries; nEntry < nNumChildren; ++nEntry )
    {
        UpdateChild( AccessibleUniqueId( LegendEntry::ObjectId, nEntry + nOffset ),
                     false, true );
    }

    // /--
    aGuard.reset();

    m_nEntries = nNumChildren;
    return true;
    // \--
}

OUString SAL_CALL Legend::getImplementationName() 
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccLegend" ));
}

}  // namespace accessibility
