/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chtscene.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:56:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include "axisid.hxx"
#include "chtscene.hxx"
#include "chtmodel.hxx"

#ifndef _BGFX_RANGE_B2DRANGE_HXX
#include <basegfx/range/b2drange.hxx>
#endif

#ifndef _BGFX_POLYGON_B2DPOLYGONTOOLS_HXX
#include <basegfx/polygon/b2dpolygontools.hxx>
#endif

#pragma optimize ("",off)


TYPEINIT1(ChartScene, E3dPolyScene);

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

ChartScene::ChartScene(ChartModel* pDocument) :
	E3dPolyScene(),
	pDoc(pDocument),
	bAskForLogicRect(TRUE)
{
    SetModel( pDocument );
    Initialize();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

ChartScene::~ChartScene ()
{
}

/*************************************************************************
|*
|* Einpassen der Projektion aller Szenenobjekte in das
|* umschliessende Rechteck
|*
\************************************************************************/

::basegfx::B3DRange ChartScene::FitInSnapRect()
{
	// untransformiertes BoundVolume holen und parent rufen
	::basegfx::B3DRange aNewVol(E3dScene::FitInSnapRect());

	// Groesse etwas anpassen, umPlatz am Rand des Charts fu schaffen
	aNewVol.expand(::basegfx::B3DPoint(aNewVol.getMinX() * 1.2, aNewVol.getMinY() * 1.2, aNewVol.getMinZ()));
	aNewVol.expand(::basegfx::B3DPoint(aNewVol.getMaxX() * 1.2, aNewVol.getMaxY() * 1.2, aNewVol.getMaxZ()));

	//pDoc->Position3DAxisTitles(GetLogicRect());
	SetRectsDirty(FALSE);
	return aNewVol;
}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void ChartScene::operator=(const SdrObject& rObj)
{
	E3dScene::operator=(rObj);

	pDoc = ((const ChartScene&) rObj).pDoc;
}

/*************************************************************************
|*
|* Erstelle die 3D-Achsenbeschriftung  //war mal in globfunc.cxx
|*
\************************************************************************/

void ChartScene::InsertAllTitleText (DescrList         &rList,
									 E3dObject *pGroup,
									 long              nAxisId)
{
	Rectangle aOldRect;

	for (E3dLabelObj *pLabel = rList.First (); pLabel; pLabel = rList.Next ())
	{
		Insert3DObj(pLabel);
		pLabel->InsertUserData (new SchAxisId (nAxisId));
	}
}
Rectangle ChartScene::Get3DDescrRect(E3dLabelObj *p3DObj,B3dCamera& rCamSet )
{
	const SdrObject* pObj = p3DObj->Get2DLabelObj();
	// View- Abmessungen des Labels holen
	Rectangle  aRect = pObj->GetLogicRect();

	// Position des Objektes in Weltkoordinaten ermitteln
	::basegfx::B3DPoint aObjPos = p3DObj->GetFullTransform() * p3DObj->GetPosition();
	aObjPos = rCamSet.WorldToViewCoor(aObjPos);
	Point aPoint((long)(aObjPos.getX() + 0.5), (long)(aObjPos.getY() + 0.5));

	// Relative Position des Labels in View-Koordinaten
	Point aRelPosOne = pObj->GetRelativePos();
	aRelPosOne += aPoint;

	aRect.SetPos(aRelPosOne);
	return aRect;
}

void ChartScene::ReduceDescrList(DescrList & aList)
{

	Rectangle aIntersect(0,0,0,0);
	Rectangle aPrevRect(0,0,0,0);
	Rectangle aNextRect(0,0,0,0);

	//Transformation berechnen, die spaeter im Paint ausgefuehrt wird,
	//(Derzeit sind die Labelobject-Positionen unbekannt)
	Rectangle aBound(GetSnapRect());
	const ::basegfx::B3DRange aVolume(FitInSnapRect());
	B3dCamera& rSet = GetCameraSet();
	rSet.SetDeviceRectangle(aVolume.getMinX(), aVolume.getMaxX(), aVolume.getMinY(), aVolume.getMaxY(), FALSE);
	rSet.SetFrontClippingPlane(aVolume.getMinZ());
	rSet.SetBackClippingPlane(aVolume.getMaxZ());
	rSet.SetViewportRectangle(aBound);

	E3dLabelObj *p3DObj=aList.First();
	E3dLabelObj *pOld3DObj=p3DObj;
	BOOL bGetCurrent=FALSE;

	if(p3DObj)
	{
		const SdrTextObj* pObj = (const SdrTextObj*)p3DObj->Get2DLabelObj();

		//Es reicht, die Rotation des ersten Elements zu ermitteln,
		//alle in der Liste sind gleichermassen gedreht
		//GetRotateAngle() gibt 100tel, gebraucht werden 10tel Grad.
//		long nAngle = pObj->GetRotateAngle()/10;

		aPrevRect=Get3DDescrRect(p3DObj,rSet);
		if(pObj->GetRotateAngle())
		{
			::basegfx::B2DRange aRange(aPrevRect.Left(), aPrevRect.Top(), aPrevRect.Right(), aPrevRect.Bottom());
			::basegfx::B2DPolygon aPolygon(::basegfx::tools::createPolygonFromRect(aRange));
			::basegfx::B2DHomMatrix aMatrix;

			aMatrix.translate(-aPrevRect.Left(), -aPrevRect.Top());
			aMatrix.rotate(pObj->GetRotateAngle() * nPi180);
			aMatrix.translate(aPrevRect.Left(), aPrevRect.Top());
			aMatrix.rotate(pObj->GetRotateAngle() * -nPi180);

			aPolygon.transform(aMatrix);
			aRange = ::basegfx::tools::getRange(aPolygon);
			aPrevRect = Rectangle(FRound(aRange.getMinX()), FRound(aRange.getMinY()), FRound(aRange.getMaxX()), FRound(aRange.getMaxY()));
		}

		while(p3DObj)
		{
			//naechstes Objekt holen, abhaengig davon, ob das zuletzt behandelte
			//entfernt wurde oder nicht (bGetCurrent)
			if(bGetCurrent)
			{
				p3DObj=aList.GetCurObject();
			}
			else
			{
				p3DObj=aList.Next();
			}
			bGetCurrent=FALSE;

			//Da insbesondere bei Remove() des letzten Objects sowohl Next()
			//als auch GetCurObject() den alten Pointer zurueckgeben,
			//wird getestet, ob tatsaechlich verschiedene Objekte vorliegen
			DBG_ASSERT(p3DObj!=pOld3DObj,"Chart: pointers equal in Scene:reduce...");
			if(p3DObj && p3DObj!=pOld3DObj)
			{
				pOld3DObj=p3DObj;

				aNextRect=Get3DDescrRect(p3DObj,rSet);

				if(pObj->GetRotateAngle())
				{
					::basegfx::B2DRange aRange(aNextRect.Left(), aNextRect.Top(), aNextRect.Right(), aNextRect.Bottom());
					::basegfx::B2DPolygon aPolygon(::basegfx::tools::createPolygonFromRect(aRange));
					::basegfx::B2DHomMatrix aMatrix;

					aMatrix.translate(-aNextRect.Left(), -aNextRect.Top());
					aMatrix.rotate(pObj->GetRotateAngle() * nPi180);
					aMatrix.translate(aNextRect.Left(), aNextRect.Top());
					aMatrix.rotate(pObj->GetRotateAngle() * -nPi180);

					aPolygon.transform(aMatrix);
					aRange = ::basegfx::tools::getRange(aPolygon);
					aNextRect = Rectangle(FRound(aRange.getMinX()), FRound(aRange.getMinY()), FRound(aRange.getMaxX()), FRound(aRange.getMaxY()));
				}

				aIntersect=aNextRect.GetIntersection(aPrevRect);
				if( !  (aIntersect.IsEmpty())
					&& (   (aIntersect.GetHeight()>aNextRect.GetHeight()/100)
						 ||(aIntersect.GetWidth() >aNextRect.GetHeight()/100)//2% Deckung maximal bezogen auf die Fonthoehe
						)
				  )
				{
					E3dObject* pParent=p3DObj->GetParentObj();
					if(pParent)
					{
						//aus der Page streichen
						pParent->Remove3DObj(p3DObj);


						//Die Objekte koennen ruhig in der Liste verbleiben, loeschen fuehrt
						//nur zu Problemen

						//Da das Object entfernt wurde, darf nicht Next gerufen werden.
						//bGetCurrent=TRUE;
						//und aus der Liste streichen
						//aList.Remove();
						//delete p3DObj; (ist offenbar bei Remove() schon geschehen ???)
					}
					else
					{
						DBG_TRACE("Chart:: Object has no parent (Scene)");
					}
				}
				else
				{
					aPrevRect=aNextRect;
				}
			}
		}
	}

}

void ChartScene::Initialize()
{
	// #66930# BM  activate second light source and deactivate first one
    // reason: the first light source is in contrast to the other seven
    //         lightsources specular by default

    // Note: Use items at the scene instead of methods at the subobjects
    //       otherwise settings get overwritten later

    // copy lightsource 1 (Base3DLight0) to lightsource 2
    // color
	SetObjectItem( Svx3DLightcolor2Item( GetLightGroup().GetIntensity( Base3DMaterialDiffuse, Base3DLight0 )));
    // direction
	SetObjectItem( Svx3DLightDirection2Item( GetLightGroup().GetDirection( Base3DLight0 )));

    // enable light source 2
    SetObjectItem( Svx3DLightOnOff2Item( TRUE ));
    // disable light source 1
    SetObjectItem( Svx3DLightOnOff1Item( FALSE ));
}
