/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chtmode7.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:55:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#pragma optimize("",off)

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS
#define ITEMID_CHARTDATADESCR   SCHATTR_DATADESCR_DESCR
#include <svx/chrtitem.hxx>
#endif


#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif

#define ITEMID_FONT        EE_CHAR_FONTINFO
#define ITEMID_COLOR       EE_CHAR_COLOR
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#include <svx/fontitem.hxx>
#include <svx/fhgtitem.hxx>
#include <svx/colritem.hxx>
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _CHTMODEL_HXX
#include <chtmodel.hxx>
#include <globfunc.hxx>
#endif

#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif

#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif

#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif

#include "pairs.hxx"

#include "chaxis.hxx"

// Hier abhaengig von der Reihe den Style zurueckgeben, vorerst ist nur aufsplitten der
// Verbundcharts von noeten:
//TVM: bitte nicht benutzen! renovierungsbeduerftig!
SvxChartStyle ChartModel::GetRowChartStyle(const long nRow)
{
	switch(eChartStyle)
	{
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			if(IsLine(nRow))
				return CHSTYLE_2D_LINESYMBOLS;
			else
				return CHSTYLE_2D_STACKEDCOLUMN;

		   break;

		case CHSTYLE_2D_LINE_COLUMN:

			if(IsLine(nRow))
				return CHSTYLE_2D_LINESYMBOLS;
			else
				return CHSTYLE_2D_COLUMN;

		   break;

		default:
			break;
	}
	return eChartStyle;
}


SchMemChart* ChartModel::GetChartData() const
{
	return pChartData;
}


long ChartModel::GetColCount() const
{
	if( !pChartData ) return 0;			// GPF via GetMenuState
	
	return IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
			   ? pChartData->GetRowCount()
			   : pChartData->GetColCount();
}


long ChartModel::GetRowCount() const
{
	if( !pChartData ) return 0;			// GPF via GetMenuState

	return IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
			   ? pChartData->GetColCount()
			   : pChartData->GetRowCount();
}


const String& ChartModel::ColText( long nCol ) const
{
	if( !pChartData ) return aMainTitle;		// have to return a const String &

	return IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
			   ? pChartData->GetTransRowText(nCol)
			   : pChartData->GetTransColText(nCol);
}


const String& ChartModel::RowText( long nRow ) const
{
	if( !pChartData ) return aMainTitle;		// have to return a const String &

	return IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
			   ? pChartData->GetTransColText(nRow)
			   : pChartData->GetTransRowText(nRow);
}


SvxChartStyle ChartModel::ChartStyle () const
{
	return eChartStyle;
}


SvxChartStyle &ChartModel::ChartStyle()
{
	return eChartStyle;
}

void ChartModel::SetSwitchData(BOOL b)
{
	if(bSwitchData!=b)
		bClearDepth=TRUE;

	bSwitchData=b;
}


long ChartModel::PieSegOfs( long nCol ) const
{
    DBG_ASSERT( nCol < nPieSegCount, "pie segment requested is out of bounds" );

    if( IsPieChart() &&
        nCol < nPieSegCount )
    {
        return pPieSegOfs[ nCol ];
    }

    return 0;
}

BOOL ChartModel::ShowMainTitle () const
{
	return bShowMainTitle;
}


BOOL& ChartModel::ShowMainTitle ()
{
	return bShowMainTitle;
}


const String& ChartModel::MainTitle () const
{
	return aMainTitle;
}


String& ChartModel::MainTitle ()
{
	return aMainTitle;
}


BOOL ChartModel::ShowSubTitle () const
{
	return bShowSubTitle;
}


BOOL& ChartModel::ShowSubTitle()
{
	return bShowSubTitle;
}


const String& ChartModel::SubTitle () const
{
	return aSubTitle;
}


String& ChartModel::SubTitle ()
{
	return aSubTitle;
}


BOOL ChartModel::ShowXAxisTitle () const
{
	return bShowXAxisTitle;
}


BOOL& ChartModel::ShowXAxisTitle ()
{
	return bShowXAxisTitle;
}


String& ChartModel::XAxisTitle ()
{
	return aXAxisTitle;
}


const String& ChartModel::XAxisTitle () const
{
	return aXAxisTitle;
}


BOOL ChartModel::ShowYAxisTitle () const
{
	return bShowYAxisTitle;
}


BOOL& ChartModel::ShowYAxisTitle ()
{
	return bShowYAxisTitle;
}


const String& ChartModel::YAxisTitle () const
{
	return aYAxisTitle;
}


String& ChartModel::YAxisTitle ()
{
	return aYAxisTitle;
}


BOOL ChartModel::ShowZAxisTitle () const
{
	return bShowZAxisTitle;
}


BOOL& ChartModel::ShowZAxisTitle ()
{
	return bShowZAxisTitle;
}


const String& ChartModel::ZAxisTitle () const
{
	return aZAxisTitle;
}


String& ChartModel::ZAxisTitle()
{
	return aZAxisTitle;
}


BOOL ChartModel::HasTitle() const
{
	return bShowMainTitle || bShowSubTitle || IsAxisChart() &&
		   (bShowXAxisTitle || bShowYAxisTitle || Is3DChart() && bShowZAxisTitle);
}

BOOL ChartModel::ShowXAxis () const
{
	return pChartXAxis->IsVisible();
}


void ChartModel::ShowXAxis (BOOL b)
{
	pChartXAxis->ShowAxis(b);
}


BOOL ChartModel::ShowXGridMain () const
{
	return bShowXGridMain;
}


BOOL& ChartModel::ShowXGridMain ()
{
	return bShowXGridMain;
}


BOOL ChartModel::ShowXGridHelp () const
{
	return bShowXGridHelp;
}


BOOL& ChartModel::ShowXGridHelp ()
{
	return bShowXGridHelp;
}


BOOL ChartModel::ShowXDescr () const
{
	return pChartXAxis->HasDescription();
}


void ChartModel::ShowXDescr(BOOL b)
{
	pChartXAxis->ShowDescr(b);
}


BOOL ChartModel::ShowYAxis () const
{
	return pChartYAxis->IsVisible();
}
void ChartModel::ShowYAxis (BOOL b)
{
	pChartYAxis->ShowAxis(b);
}

BOOL ChartModel::ShowYGridMain () const
{
	return bShowYGridMain;
}


BOOL& ChartModel::ShowYGridMain ()
{
	return bShowYGridMain;
}


BOOL ChartModel::ShowYGridHelp () const
{
	return bShowYGridHelp;
}


BOOL& ChartModel::ShowYGridHelp ()
{
	return bShowYGridHelp;
}


BOOL ChartModel::ShowYDescr () const
{
	return pChartYAxis->HasDescription();
}


void ChartModel::ShowYDescr( BOOL b)
{
	pChartYAxis->ShowDescr(b);
}


BOOL ChartModel::ShowZAxis () const
{
	return pChartZAxis->IsVisible();
}


void ChartModel::ShowZAxis(BOOL b)
{
	pChartZAxis->ShowAxis(b);
}


BOOL ChartModel::ShowZGridMain () const
{
	return bShowZGridMain;
}


BOOL& ChartModel::ShowZGridMain ()
{
	return bShowZGridMain;
}


BOOL ChartModel::ShowZGridHelp () const
{
	return bShowZGridHelp;
}


BOOL& ChartModel::ShowZGridHelp ()
{
	return bShowZGridHelp;
}


BOOL ChartModel::ShowZDescr () const
{
	return pChartZAxis->HasDescription();
}


void ChartModel::ShowZDescr (BOOL b)
{
	pChartZAxis->ShowDescr(b);
}


BOOL ChartModel::HasAxis( long nObjectId ) const
{
    if( CHOBJID_ANY == nObjectId )
        return IsAxisChart() &&
            ( pChartXAxis->IsVisible() ||
              pChartYAxis->IsVisible() ||
              pChartAAxis->IsVisible() ||
              pChartBAxis->IsVisible() ||
              (Is3DChart() && pChartZAxis->IsVisible()) );

    switch( nObjectId )
    {
        case CHOBJID_DIAGRAM_X_AXIS:
            return  pChartXAxis->IsVisible();
        case CHOBJID_DIAGRAM_Y_AXIS:
            return  pChartYAxis->IsVisible();
        case CHOBJID_DIAGRAM_Z_AXIS:
            return  (Is3DChart() && pChartZAxis->IsVisible());
        case CHOBJID_DIAGRAM_A_AXIS:
            return  pChartAAxis->IsVisible();
        case CHOBJID_DIAGRAM_B_AXIS:
            return  pChartBAxis->IsVisible();
    }

    return FALSE;
}

bool ChartModel::HasGrid( UINT16 nObjectId ) const
{
    switch( nObjectId )
    {
        case CHOBJID_DIAGRAM_X_GRID_MAIN:
            return (CanAxis( CHART_AXIS_PRIMARY_X ) && bShowXGridMain);
        case CHOBJID_DIAGRAM_Y_GRID_MAIN:
            return (CanAxis( CHART_AXIS_PRIMARY_Y ) && bShowYGridMain);
        case CHOBJID_DIAGRAM_Z_GRID_MAIN:
            return (Is3DChart() && bShowZGridMain);
        case CHOBJID_DIAGRAM_X_GRID_HELP:
            return (CanAxis( CHART_AXIS_PRIMARY_X ) && bShowXGridHelp);
        case CHOBJID_DIAGRAM_Y_GRID_HELP:
            return (CanAxis( CHART_AXIS_PRIMARY_Y ) && bShowYGridHelp);
        case CHOBJID_DIAGRAM_Z_GRID_HELP:
            return (Is3DChart() && bShowZGridHelp);
        default:
            return false;
    }
}

BOOL ChartModel::HasGrid() const
{
	return IsAxisChart() &&
		   (bShowXGridMain || bShowXGridHelp ||
			bShowYGridMain || bShowYGridHelp ||
			Is3DChart() && (bShowZGridMain || bShowZGridHelp));
}
const SfxItemSet& ChartModel::GetTitleAttr() const
{
	return *pTitleAttr;
}

void ChartModel::PutMainTitleAttr(const SfxItemSet& rAttr,BOOL bMerge /*=TRUE*/)
{
	if(!bMerge)
		pMainTitleAttr->ClearItem();
    PutItemSetWithNameCreation( *pMainTitleAttr, rAttr );
}


const SfxItemSet& ChartModel::GetMainTitleAttr() const
{
	return *pMainTitleAttr;
}


void ChartModel::PutSubTitleAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pSubTitleAttr->ClearItem();
    PutItemSetWithNameCreation( *pSubTitleAttr, rAttr );
}


const SfxItemSet& ChartModel::GetSubTitleAttr() const
{
	return *pSubTitleAttr;
}


void ChartModel::PutXAxisTitleAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pXAxisTitleAttr->ClearItem();
    PutItemSetWithNameCreation( *pXAxisTitleAttr, rAttr );
}


const SfxItemSet& ChartModel::GetXAxisTitleAttr() const
{
	return *pXAxisTitleAttr;
}


void ChartModel::PutYAxisTitleAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pYAxisTitleAttr->ClearItem();
    PutItemSetWithNameCreation( *pYAxisTitleAttr, rAttr );
}


const SfxItemSet& ChartModel::GetYAxisTitleAttr() const
{
	return *pYAxisTitleAttr;
}


void ChartModel::PutZAxisTitleAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pZAxisTitleAttr->ClearItem();
    PutItemSetWithNameCreation( *pZAxisTitleAttr, rAttr );
}


const SfxItemSet& ChartModel::GetZAxisTitleAttr() const
{
	return *pZAxisTitleAttr;
}


void ChartModel::PutLegendAttr(const SfxItemSet& rAttr,BOOL bMerge /*=TRUE*/)
{
	if(!bMerge)
		pLegendAttr->ClearItem();
    PutItemSetWithNameCreation( *pLegendAttr, rAttr );
}


const SfxItemSet& ChartModel::GetLegendAttr() const
{
	return *pLegendAttr;
}

void ChartModel::PutChartAttr(const SfxItemSet& rAttr,BOOL bMerge /*=TRUE*/)
{
	if(!bMerge)
		pChartAttr->ClearItem();
	pChartAttr->Put(rAttr);
}


const SfxItemSet& ChartModel::GetChartAttr() const
{
	return *pChartAttr;
}


const SfxItemSet& ChartModel::GetAxisAttr() const
{
	return *pAxisAttr;
}




//ToDo: diese Fkt. ueberfluessig machen (Problem: Austausch der Achseneigenschaften nicht NUR ueber Attr (??? stimmt das ???)
void ChartModel::CopyAxisMembers(const ChartModel* pModel)
{
	pChartXAxis->ReadMembers(*pModel->pChartXAxis);
	pChartYAxis->ReadMembers(*pModel->pChartYAxis);
	pChartZAxis->ReadMembers(*pModel->pChartZAxis);
}
void ChartModel::CopyAxisAttributes(const ChartModel* pModel,BOOL bMerge)
{
	SetAttributes(CHOBJID_DIAGRAM_X_AXIS,pModel->GetAttr(CHOBJID_DIAGRAM_X_AXIS),bMerge);
	SetAttributes(CHOBJID_DIAGRAM_Y_AXIS,pModel->GetAttr(CHOBJID_DIAGRAM_Y_AXIS),bMerge);
	SetAttributes(CHOBJID_DIAGRAM_Z_AXIS,pModel->GetAttr(CHOBJID_DIAGRAM_Z_AXIS),bMerge);
	SetAttributes(CHOBJID_DIAGRAM_A_AXIS,pModel->GetAttr(CHOBJID_DIAGRAM_A_AXIS),bMerge);
	SetAttributes(CHOBJID_DIAGRAM_B_AXIS,pModel->GetAttr(CHOBJID_DIAGRAM_B_AXIS),bMerge);
//	SetAttributes(CHOBJID_DIAGRAM_C_AXIS,pModel->GetAttr(CHOBJID_DIAGRAM_C_AXIS),bMerge);
}


const SfxItemSet& ChartModel::GetGridAttr() const
{
	return *pGridAttr;
}


void ChartModel::PutXGridMainAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pXGridMainAttr->ClearItem();
	pXGridMainAttr->Put(rAttr);
}


const SfxItemSet& ChartModel::GetXGridMainAttr() const
{
	return *pXGridMainAttr;
}


void ChartModel::PutYGridMainAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pYGridMainAttr->ClearItem();
	pYGridMainAttr->Put(rAttr);
}


const SfxItemSet& ChartModel::GetYGridMainAttr() const
{
	return *pYGridMainAttr;
}


void ChartModel::PutZGridMainAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pZGridMainAttr->ClearItem();
	pZGridMainAttr->Put(rAttr);
}


const SfxItemSet& ChartModel::GetZGridMainAttr() const
{
	return *pZGridMainAttr;
}


void ChartModel::PutXGridHelpAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pXGridHelpAttr->ClearItem();
	pXGridHelpAttr->Put(rAttr);
}


const SfxItemSet& ChartModel::GetXGridHelpAttr() const
{
	return *pXGridHelpAttr;
}


void ChartModel::PutYGridHelpAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pYGridHelpAttr->ClearItem();
	pYGridHelpAttr->Put(rAttr);
}

const SfxItemSet& ChartModel::GetYGridHelpAttr() const
{
	return *pYGridHelpAttr;
}


void ChartModel::PutZGridHelpAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pZGridHelpAttr->ClearItem();
	pZGridHelpAttr->Put(rAttr);
}


const SfxItemSet& ChartModel::GetZGridHelpAttr() const
{
	return *pZGridHelpAttr;
}


void ChartModel::PutDiagramAreaAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pDiagramAreaAttr->ClearItem();
    PutItemSetWithNameCreation( *pDiagramAreaAttr, rAttr );

    // inform outliner about change for apadting the color of text using 'auto-color'
    PageColorChanged( *pDiagramAreaAttr );
}


const SfxItemSet& ChartModel::GetDiagramAreaAttr() const
{
	return *pDiagramAreaAttr;
}


void ChartModel::PutDiagramWallAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pDiagramWallAttr->ClearItem();
    PutItemSetWithNameCreation( *pDiagramWallAttr, rAttr );
}


const SfxItemSet& ChartModel::GetDiagramWallAttr() const
{
	return *pDiagramWallAttr;
}


void ChartModel::PutDiagramFloorAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
		pDiagramFloorAttr->ClearItem();
    PutItemSetWithNameCreation( *pDiagramFloorAttr, rAttr );
}


const SfxItemSet& ChartModel::GetDiagramFloorAttr() const
{
	return *pDiagramFloorAttr;
}

SvxChartDataDescr ChartModel::DataDescr () const
{
	return eDataDescr;
}


SvxChartDataDescr& ChartModel::DataDescr()
{
	return eDataDescr;
}


BOOL ChartModel::ShowSym () const
{
	return bShowSym;
}


BOOL& ChartModel::ShowSym()
{
	return bShowSym;
}

SdrOutliner* ChartModel::GetOutliner() const
{
	return pOutliner;
}

/*
UINT32 ChartModel::ValFor mat () const
{
	return nValFo rmat;
}


UINT32& ChartModel::ValForm at()
{
	return nVal Format;
}


UINT32 ChartModel::PercentVa lFormat () const
{
	return nPercentV alFormat;
}


UINT32& ChartModel::Per centValFormat ()
{
	return nPercentValFo rmat;
}


UINT32 ChartModel::Des crFormat () const
{
	return nDescrFor mat;
}


UINT32& ChartModel::Desc rFormat()
{
	return nDes crFormat;
}


UINT32 ChartModel::PercentD escrFormat () const
{
	return nPercentDescrFo rmat;
}


UINT32& ChartModel::Percent DescrF ormat ()
{
	return nPercentDescr Format;
}

*/
BOOL ChartModel::IsInitialized() const
{
	return mbIsInitialized;
}


BOOL ChartModel::ReadError () const
{
	return bReadError;
}


BOOL& ChartModel::ReadError ()
{
	return bReadError;
}


ChartScene* ChartModel::GetScene()
{
	return pScene;
}


const SchMemChart *ChartModel::GetMemChart () const
{
	return pChartData;
}


const Rectangle &ChartModel::GetChartRect () const
{
	return aChartRect;
}


void ChartModel::setLightVec(const ::basegfx::B3DVector& rNew)
{
	*mpLightVec = rNew;
}

const ::basegfx::B3DVector& ChartModel::getLightVec() const
{
	return *mpLightVec;
}

double ChartModel::SpotIntensity () const
{
	return fSpotIntensity;
}


double& ChartModel::SpotIntensity ()
{
	return fSpotIntensity;
}


void ChartModel::CanRebuild (BOOL bNewRebuild)
{
	bCanRebuild = bNewRebuild;
}


void ChartModel::GetStatistics (BOOL              &GetShowAverage,
								SvxChartKindError &GetErrorKind,
								SvxChartIndicate  &GetIndicate,
								double            &GetIndicatePercent,
								double            &GetIndicateBigError,
								double            &GetIndicatePlus,
								double            &GetIndicateMinus,
								SvxChartRegress   &GetRegression) const
{
	GetShowAverage      = bShowAverage;
	GetErrorKind        = eErrorKind;
	GetIndicate         = eIndicate;
	GetRegression       = eRegression;
	GetIndicatePercent  = fIndicatePercent;
	GetIndicateBigError = fIndicateBigError;
	GetIndicatePlus     = fIndicatePlus;
	GetIndicateMinus    = fIndicateMinus;
}

const SfxItemSet& ChartModel::GetRegressAttr( long nRow ) const
{
	return *aRegressAttrList.GetObject(nRow);
}

void ChartModel::PutRegressAttr( long nRow, const SfxItemSet &rAttr, BOOL bMerge )
{
	if(!bMerge)
		aRegressAttrList.GetObject(nRow)->ClearItem();
	aRegressAttrList.GetObject(nRow)->Put(rAttr);
}
void ChartModel::ChangeRegressAttr(const SfxItemSet &rAttr,long nRow,BOOL bMerge)
{
	PutRegressAttr(nRow, rAttr,bMerge);
	BuildChart (FALSE);
}

void ChartModel::PutAverageAttr( long nRow, const SfxItemSet &rAttr, BOOL bMerge )
{
	if(!bMerge)
		aAverageAttrList.GetObject(nRow)->ClearItem();
	aAverageAttrList.GetObject(nRow)->Put(rAttr);
}
const SfxItemSet& ChartModel::GetAverageAttr( long nRow ) const
{
	return *aAverageAttrList.GetObject(nRow);
}
void ChartModel::ChangeAverageAttr(const SfxItemSet &rAttr,long nRow,BOOL bMerge)
{
	PutAverageAttr(nRow,rAttr,bMerge);
	BuildChart (FALSE);
}

void ChartModel::PutErrorAttr( long nRow, const SfxItemSet &rAttr, BOOL bMerge )
{
	if(!bMerge)
		aErrorAttrList.GetObject(nRow)->ClearItem();
	aErrorAttrList.GetObject(nRow)->Put(rAttr);
}
const SfxItemSet& ChartModel::GetErrorAttr( long nRow ) const
{
	return *aErrorAttrList.GetObject(nRow);
}
void ChartModel::ChangeErrorAttr(const SfxItemSet &rAttr,long nRow,BOOL bMerge)
{
	PutErrorAttr(nRow, rAttr,bMerge);
	BuildChart (FALSE);
}

SvNumberFormatter* ChartModel::GetNumFormatter() const
{
	return pNumFormatter;
}

SvxChartKindError ChartModel::ChartKindError () const
{
	return eErrorKind;
}


SvxChartKindError& ChartModel::ChartKindError ()
{
	return eErrorKind;
}


SvxChartIndicate ChartModel::ChartIndicate () const
{
	return eIndicate;
}


SvxChartIndicate& ChartModel::ChartIndicate ()
{
	return eIndicate;
}


SvxChartRegress ChartModel::ChartRegress () const
{
	return eRegression;
}


SvxChartRegress& ChartModel::ChartRegress ()
{
	return eRegression;
}


double ChartModel::IndicatePercent () const
{
	return fIndicatePercent;
}


double& ChartModel::IndicatePercent ()
{
	return fIndicatePercent;
}


double ChartModel::IndicateBigError () const
{
	return fIndicateBigError;
}


double& ChartModel::IndicateBigError ()
{
	return fIndicateBigError;
}


double ChartModel::IndicatePlus () const
{
	return fIndicatePlus;
}


double& ChartModel::IndicatePlus ()
{
	return fIndicatePlus;
}


double ChartModel::IndicateMinus () const
{
	return fIndicateMinus;
}


double& ChartModel::IndicateMinus ()
{
	return fIndicateMinus;
}

int ChartModel::Granularity () const
{
	return nGranularity;
}


int& ChartModel::Granularity ()
{
	return nGranularity;
}


const Size& ChartModel::InitialSize () const
{
	return aInitialSize;
}


Size& ChartModel::InitialSize ()
{
	return aInitialSize;
}


SvxChartStyle ChartModel::OldChartStyle () const
{
	return eOldChartStyle;
}


SvxChartStyle &ChartModel::OldChartStyle ()
{
	return eOldChartStyle;
}


long ChartModel::PieHeight () const
{
	return nPieHeight;
}


long& ChartModel::PieHeight ()
{
	return nPieHeight;
}


short ChartModel::PieSegCount () const
{
	return nPieSegCount;
}


short& ChartModel::PieSegCount ()
{
	return nPieSegCount;
}


void ChartModel::SetAngles (short nNewXAngle,
							short nNewYAngle,
							short nNewZAngle)
{
	nXAngle = nNewXAngle;
	nYAngle = nNewYAngle;
	nZAngle = nNewZAngle;
}


void ChartModel::GetAngles (short &rNewXAngle,
							short &rNewYAngle,
							short &rNewZAngle)
{
	rNewXAngle = nXAngle;
	rNewYAngle = nYAngle;
	rNewZAngle = nZAngle;
}


void ChartModel::SetPieSegOfs( long nCol, long nOfs )
{
    DBG_ASSERT( pPieSegOfs, "Invalid Array" );
    DBG_ASSERT( nCol < nPieSegCount, "trying to set pie offset out of bounds" );

    if( nCol < nPieSegCount )
        pPieSegOfs[ nCol ] = nOfs;
}


String& ChartModel::ColText( long nCol )
{
	return IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
			   ? (String&) pChartData->GetTransRowText(nCol)
			   : (String&) pChartData->GetTransColText(nCol);
}


String& ChartModel::RowText( long nRow )
{
	return IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
			   ? (String&) pChartData->GetTransColText(nRow)
			   : (String&) pChartData->GetTransRowText(nRow);
}

void ChartModel::SetItemSetLists(const ChartModel &rSource)
{

	CHART_TRACE( "ChartModel::SetItemSetLists" );


	long i,nCount;


	ClearItemSetLists(); //An dieser Stelle sind die Listen bereits mit default-werten gefuellt!

	nCount=rSource.aDataRowAttrList.Count();
	SfxItemSet	*	pAttributes;
	for (i=0;i<nCount;i++)
	{
		SfxItemSet *pDataRowAttr = new SfxItemSet (*pItemPool, nRowWhichPairs);
		pDataRowAttr->Put(*(rSource.aDataRowAttrList.GetObject(i)));
		aDataRowAttrList.Insert (pDataRowAttr, LIST_APPEND);
	}

	nCount=rSource.aDataPointAttrList.Count();
	for (i=0;i<nCount;i++)
	 {
	 	pAttributes = rSource.aDataPointAttrList.GetObject(i);
		if (pAttributes == NULL)
			aDataPointAttrList.Insert (NULL, LIST_APPEND);
		else
		{
			SfxItemSet* pSet=new SfxItemSet(*pItemPool, nRowWhichPairs);
			pSet->Put(*pAttributes);
			aDataPointAttrList.Insert (pSet, LIST_APPEND);
		}
	 }

	nCount=rSource.aSwitchDataPointAttrList.Count();
	for (i=0;i<nCount;i++)
	 {
	 	pAttributes = rSource.aSwitchDataPointAttrList.GetObject(i);
		if (pAttributes == NULL)
			aSwitchDataPointAttrList.Insert (NULL, LIST_APPEND);
		else
		{
			SfxItemSet* pSet=new SfxItemSet(*pItemPool, nRowWhichPairs);
			pSet->Put(*pAttributes);
			aSwitchDataPointAttrList.Insert (pSet, LIST_APPEND);
		}
	 }

	nCount=rSource.aRegressAttrList.Count();
	for (i=0;i<nCount;i++)
	 {
		SfxItemSet* pSet=new SfxItemSet(*pItemPool, nGridWhichPairs);
		pSet->Put(*(rSource.aRegressAttrList.GetObject(i)));
		aRegressAttrList.Insert (pSet, LIST_APPEND);
	 }

	nCount = rSource.aAverageAttrList.Count();
	for (i=0;i<nCount;i++)
	 {
		SfxItemSet* pSet=new SfxItemSet(*pItemPool, nGridWhichPairs);
		pSet->Put(*(rSource.aAverageAttrList.GetObject(i)));
		aAverageAttrList.Insert (pSet, LIST_APPEND);
	 }

	nCount = rSource.aErrorAttrList.Count();
	for (i=0;i<nCount;i++)
	 {
		SfxItemSet* pSet=new SfxItemSet(*pItemPool, nGridWhichPairs);
		pSet->Put(*(rSource.aErrorAttrList.GetObject(i)));
		aErrorAttrList.Insert (pSet, LIST_APPEND);
	 }
}

void ChartModel::AllocPieSegOfs (long nPieSegCnt)
{
	delete[] pPieSegOfs;
	pPieSegOfs = new long [nPieSegCnt];
    long i = nPieSegCnt;
    for( ; i < nPieSegCnt; i++ )
		pPieSegOfs[ i ] = 0;
}


// FG: Ist eine Abfrage ob die Beschriftung eines Charts Zentriert unter einem Datenpunkt (Regelfall) steht
//     oder zentriert zwischen 2 Marken.
BOOL ChartModel::IsDescriptionCenteredUnderDataPoint ()
{
	switch (eChartStyle)
	{
		case CHSTYLE_2D_STACKEDCOLUMN :
		case CHSTYLE_2D_COLUMN :
		case CHSTYLE_2D_PERCENTCOLUMN :
			return FALSE;

//  		case CHSTYLE_2D_LINE :
//  		case CHSTYLE_2D_STACKEDLINE :
//  		case CHSTYLE_2D_PERCENTLINE :
//  		case CHSTYLE_2D_LINESYMBOLS :
//  		case CHSTYLE_2D_STACKEDLINESYM :
//  		case CHSTYLE_2D_PERCENTLINESYM :
//  		case CHSTYLE_2D_CUBIC_SPLINE :
//  		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
//  		case CHSTYLE_2D_B_SPLINE :
//  		case CHSTYLE_2D_B_SPLINE_SYMBOL :

//  		case CHSTYLE_2D_XY :
//  		case CHSTYLE_2D_XYSYMBOLS :
//  		case CHSTYLE_2D_XY_LINE :
//  		case CHSTYLE_2D_CUBIC_SPLINE_XY :
//  		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
//  		case CHSTYLE_2D_B_SPLINE_XY :
//  		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :

//  		case CHSTYLE_2D_BAR :
//  		case CHSTYLE_2D_STACKEDBAR:
//  		case CHSTYLE_2D_PERCENTBAR:

//  		case CHSTYLE_2D_AREA :
//  		case CHSTYLE_2D_PERCENTAREA :
//  		case CHSTYLE_2D_STACKEDAREA :

//  		case CHSTYLE_2D_STOCK_1:
//  		case CHSTYLE_2D_STOCK_2:
//  		case CHSTYLE_2D_STOCK_3:
//  		case CHSTYLE_2D_STOCK_4:
		default :
			return TRUE;
	}
}
void ChartModel::LockBuild()
{
	bNoBuildChart=TRUE;
}
void ChartModel::UnlockBuild()
{
	bNoBuildChart=FALSE;
	if(bShouldBuildChart)
		BuildChart(FALSE); //evtl. TRUE, um Ranges zu pruefen???

    // #i42572# the following is now unnecessary as it is done at the end of
    // BuildChart

	// force broadcast SFX_HINT_DOCCHANGED
// 	SfxObjectShell* pObjSh = GetObjectShell();
// 	if( pObjSh )
// 	{
// 		pObjSh->SetModified( pObjSh->IsModified());
// 	}
}
BOOL ChartModel::IsLockedBuild()
{
	return bNoBuildChart;
}

