/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chtmode2.cxx,v $
 *
 *  $Revision: 1.26 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:54:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#ifndef _STREAM_HXX
// enable stream operators >>/<< for UniString (8 Bit !)
#ifndef ENABLE_STRING_STREAM_OPERATORS
#define ENABLE_STRING_STREAM_OPERATORS
#endif
#include <tools/stream.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>
#endif

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _CHTSCENE_HXX
#include "chtscene.hxx"
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <svx/svdmark.hxx>

#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif

#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif

#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _ZFORMAT_HXX //autogen
#include <svtools/zformat.hxx>
#endif
// header for getProcessServiceFactory
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include "chmod3d.hxx" //SchRectObj

#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH   EE_CHAR_FONTWIDTH
#define ITEMID_FONT        EE_CHAR_FONTINFO
#if SUPD > 364
#include <svx/fhgtitem.hxx>
#include <svx/fwdtitem.hxx>
#include <svx/fontitem.hxx>
#endif
#ifndef _SCH_OBJADJ_HXX
#include  "objadj.hxx"
#endif
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "globfunc.hxx"
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SCH_SCHGROUP_HXX
#include "schgroup.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _SCH_SCHIOCMP_HXX
#include "schiocmp.hxx"
#endif

#include "strings.hrc"
#include "glob.hrc"

#if SUPD > 364
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#include <svx/fontitem.hxx>
#else
#include <textitem.hxx>
#endif

#ifndef _TOOLS_TENCCVT_HXX
#include <tools/tenccvt.hxx>
#endif

#include "pairs.hxx"
#include "chaxis.hxx"

#include "chdescr.hxx"
#include "calculat.hxx"


/************************************************************************/
const USHORT nCompatAxisWhichPairs[] =
{
	SCHATTR_TEXT_START, SCHATTR_TEXT_END,
	SCHATTR_Y_AXIS_START, SCHATTR_Z_AXIS_END, //X-Z!
	SCHATTR_AXISTYPE, SCHATTR_AXISTYPE,
	SCHATTR_TEXT_DEGREES,SCHATTR_TEXT_DEGREES,
	SCHATTR_TEXT_OVERLAP, SCHATTR_TEXT_OVERLAP,
	SCHATTR_AXIS_START,SCHATTR_AXIS_END,
	XATTR_LINE_FIRST, XATTR_LINE_LAST,
	EE_ITEMS_START, EE_ITEMS_END,
	SID_TEXTBREAK, SID_TEXTBREAK,
	SID_ATTR_NUMBERFORMAT_VALUE, SID_ATTR_NUMBERFORMAT_VALUE, //10.585
   0
};
/************************************************************************/

enum ChartStyleV0
{
	CHART2D_LINE,
	CHART2D_STACKEDLINE,
	CHART2D_BAR,
	CHART2D_STACKEDBAR,
	CHART2D_COLUMN,
	CHART2D_STACKEDCOLUMN,
	CHART2D_AREA,
	CHART2D_STACKEDAREA,
	CHART2D_PIE,
	CHART3D_STRIPE,
	CHART3D_BAR,
	CHART3D_FLATBAR,
	CHART3D_STACKEDFLATBAR,
	CHART3D_AREA,
	CHART3D_STACKEDAREA,
	CHART3D_SURFACE,
	CHART3D_PIE
};

/*************************************************************************
|*
|* Datenbeschriftung erzeugen
|*
\************************************************************************/

//SdrObject*
void ChartModel::CreateDataDescr(DataDescription& rDescr,long nCol,long nRow,ChartAxis *pAxis,BOOL bRowDescr,BOOL bIsPercent)
{

	UINT32 nDescrFormat=       pAxis ? pAxis->GetNumFormat(FALSE) : GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,FALSE);
	UINT32 nPercentDescrFormat=pAxis ? pAxis->GetNumFormat(TRUE)  : GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,TRUE);
	String aText;
	Color* pDummy = NULL;


	if (pAxis && !bIsPercent && ((rDescr.eDescr == CHDESCR_PERCENT)
					 || (rDescr.eDescr == CHDESCR_TEXTANDPERCENT)))
		rDescr.fValue=pAxis->Data2Percent(rDescr.fValue,nCol,nRow);

	switch (rDescr.eDescr)
	{
		case CHDESCR_VALUE:
			pNumFormatter->GetOutputString(rDescr.fValue, nDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_PERCENT:
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_TEXT:
			aText = bRowDescr ? RowText(nRow) : ColText(nCol);
			break;

		case CHDESCR_TEXTANDPERCENT:
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			aText.Insert( (sal_Unicode)(' '), 0 );
			aText.Insert( bRowDescr ? RowText( nRow ) : ColText( nCol ), 0 );
			break;

		case CHDESCR_TEXTANDVALUE:
			pNumFormatter->GetOutputString(rDescr.fValue, nDescrFormat, aText, &pDummy);
			aText.Insert( sal_Unicode(' '), 0 );
			aText.Insert( bRowDescr ? RowText( nRow ) : ColText( nCol ), 0 );
			break;

		case CHDESCR_NUMFORMAT_PERCENT: //SP3: #49905#
			if(IsAxisChart())
				pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nPercentDescrFormat, aText, &pDummy);
			else //PieChart, hier wird getrickst, um fileformatkompatible den Formatter der X-Achse zu
				// missbrauchen, der NICHT auf Percent gesetzt werden kann, da Pie kein IsPercent()
				// liefert, dieses wird jedoch im Basic bei ...AxisX.Text ausgewertet
				pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nDescrFormat, aText, &pDummy);
			break;

		case CHDESCR_NUMFORMAT_VALUE: //SP3: #49905#
			pNumFormatter->GetOutputString(rDescr.fValue / 100.0, nDescrFormat, aText, &pDummy);
			break;
	}

	SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol, nRow ));
	SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
	aTextAttr.Put(aDataPointAttr);

	SdrObject* pObj;

	// Objekte zuerst mit Position 0,0 anlegen, um dann die relative
	// Position zu setzen; rDescr.aTextPos2D wird dann als AnchorPos verwendet
	if( rDescr.bSymbol )
	{
		pObj = new SchObjGroup;
		pObj->InsertUserData(new SchObjectId( bRowDescr
											  ? CHOBJID_DIAGRAM_DESCR_ROW
											  : CHOBJID_DIAGRAM_DESCR_COL));
		SdrObjList* pObjList = pObj->GetSubList();
		SdrTextObj* pTextObj = CreateTextObj( CHOBJID_TEXT, Point(), aText,
											  aTextAttr, FALSE,
											  CHADJUST_TOP_LEFT,
											  -1);

		long nH = pTextObj->GetLogicRect().GetHeight();

		SfxItemSet aSymbolAttr(aDataPointAttr);
		GenerateSymbolAttr( aSymbolAttr, nRow, SYMBOLMODE_DESCRIPTION );

		SdrRectObj* pRect = new SdrRectObj( Rectangle(Point(), Size(nH, nH)) );
		pRect->SetModel( this );
		pObjList->NbcInsertObject( SetObjectAttr( pRect,
												  CHOBJID_DIAGRAM_DESCR_SYMBOL,
												  TRUE, TRUE, &aSymbolAttr));
		pTextObj->NbcMove(Size(nH + nH/2, 0));
		pObjList->NbcInsertObject(pTextObj);

		Rectangle aRect = pObj->GetLogicRect();
		AdjustRect(aRect, rDescr.eAdjust);
		pObj->NbcSetRelativePos(aRect.TopLeft());
		pObj->NbcSetAnchorPos(Point(FRound(rDescr.aTextPos2D.getX()), FRound(rDescr.aTextPos2D.getY())));
	}
	else
	{
		pObj = CreateTextObj( bRowDescr
							  ? CHOBJID_DIAGRAM_DESCR_ROW
							  : CHOBJID_DIAGRAM_DESCR_COL,
							  Point(), aText,
							  aTextAttr, FALSE, rDescr.eAdjust, -1);

		pObj->NbcSetRelativePos(pObj->GetLogicRect().TopLeft());
		pObj->NbcSetAnchorPos(Point(FRound(rDescr.aTextPos2D.getX()), FRound(rDescr.aTextPos2D.getY())));
	}

	if( bRowDescr )
		pObj->InsertUserData(new SchDataRow((sal_uInt16)nRow));
	else
		pObj->InsertUserData(new SchDataPoint((sal_uInt16)nCol, (sal_uInt16)nRow));
	// #54870# nRow oben immer 0 (?)

	// return
	rDescr.pLabelObj = pObj;
}

USHORT ChartModel::GetRegressStrId( long nRow )
{

	const SfxItemSet& aDataRowAttr = GetDataRowAttr( nRow );
	USHORT nStringID = 0;

	switch (((const SfxInt32Item &) aDataRowAttr.Get (SCHATTR_STAT_REGRESSTYPE)).GetValue ())
	{
		case CHREGRESS_NONE :
			break;

		case CHREGRESS_LINEAR :
			nStringID = STR_REGRESSION_LINEAR;
			break;

		case CHREGRESS_LOG :
			nStringID = STR_REGRESSION_LOG;
			break;

		case CHREGRESS_EXP :
			nStringID = STR_REGRESSION_EXP;
			break;

		case CHREGRESS_POWER :
			nStringID = STR_REGRESSION_POWER;

	}
	return nStringID;
}
/*************************************************************************
|*
|* Diagrammlegende erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::CreateLegend(const Rectangle &aRect)
{
	// Default ist, dass die Legende nicht breiter als 20% der gesamten Seitenbreite
	// verwenden darf, unter der Bedingung, dass sie links oder rechts vom Chart steht.
	// wenn sie ueber oder unter dem Chart steht, dann ist die Seitenbreite das Maximum

	//TVM: obiges ist nicht richtig, CreateLegend wurde stets ohne 2.Argument
	//aufgerufen, daher galt immer fMax...=0.2, ausserdem bezieht sich die maximale
	//Breite auf den Text in der Legende, nicht auf die Legende selbst
	//(Test: 1-Zeiliges Chart mit langem Text!)
	//Obiges klngt aber durchaus plausibel, also sollte man es mal bei Gelegenheit
	//einbauen (ToDo:-Liste)
	const double  fMaximumWidth=0.2;

	SvxChartLegendPos eLegendPos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).
								GetValue();
	BOOL bWide = (eLegendPos == CHLEGEND_TOP || eLegendPos == CHLEGEND_BOTTOM);
	BOOL bRowLegend = !IsPieChart();
	BOOL bReverse = !bWide && IsStackedChart();
	BOOL bForceSolidLine = FALSE;

	SchObjGroup* pGroup = NULL;

	if (bLegendVisible)
	{

		List  aTextList;
		long i;
		long nRowCnt     = GetRowCount();
			// FG: nCnt ist die Anzahl Texte!
		long nCnt        = bRowLegend ? nRowCnt : GetColCount();
		long nMaxX        = 0;
		long nMaxY        = 0;

		long  nLineMaxY = 0; //#50082#

		long* pHeightOfEntry = new long[nCnt*2];    // FG: Wirkliche Hoehe der Zeilen
		long* pWidthOfEntry  = new long[nCnt*2];    // FG: Wirkliche Breite der Zeilen
		long nLines       = 0;                // Anzahl Zeilen
		long nActualColumn = 1; // FG: Zaehlt die Anzahl Spalten

		long* pRegressNr  = new long [nCnt];
		memset (pRegressNr, 0, sizeof (long) * nCnt);

		SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);

		aTextAttr.Put(*pLegendAttr);

		// FG: Hier wird einmal die Liste aller Texte durchgegangen um die maximale Hoehe und
		//     die maximale Breite zu bestimmen. Bei der Gelegenheit merkt man sich auch die
		//     Ausmasse der einzelnen Eintraege.
		for (i = 0; i < nCnt; i++)
		{
			// FG: Mehr als fMaximumWidth des Charts soll die Legende nie einnehmen
			SdrObject *pText = CreateTextObj(CHOBJID_TEXT, Point (),
									 bRowLegend ? RowText(i) : ColText(i),
									 aTextAttr,
									 FALSE,
									 CHADJUST_TOP_LEFT,  //FG: wie der Default
									 GetPage(0)->GetSize().Width() * fMaximumWidth);

            // the text in the legend may not be selected, as there is no valid
            // context menu (original comment by FG)
			pText->SetMarkProtect(TRUE);
			aTextList.Insert(pText, LIST_APPEND);

			pWidthOfEntry[i] = pText->GetLogicRect().GetWidth();
			pHeightOfEntry[i] = pText->GetLogicRect().GetHeight();
			nMaxX  = Max (nMaxX, pWidthOfEntry[i]);
			nMaxY  = Max (nMaxY, pHeightOfEntry[i]);
		}

		if (IsXYChart())
		{
			USHORT nStringID;
			for( i = 1; i < nCnt; i++ )
			{
				nStringID = GetRegressStrId( i );
				if( nStringID )
				{
					SchResId aRegId = SchResId( nStringID );
					String aRegressStr( aRegId );
					String aSeriesName( bRowLegend
										? RowText( i )
										: ColText( i ));
					String aLegendText( SchResId( STR_STATISTICS_IN_LEGEND ));

					aLegendText.SearchAndReplaceAscii( "$(STATTYP)", aRegressStr );
					aLegendText.SearchAndReplaceAscii( "$(ROWNAME)", aSeriesName );

					SdrObject *pText = CreateTextObj( CHOBJID_TEXT, Point(), aLegendText,
													  aTextAttr, FALSE,
													  CHADJUST_TOP_LEFT,
													  GetPage( 0 )->GetSize().Width() * fMaximumWidth );

					pText->SetMarkProtect( TRUE );
					aTextList.Insert(pText, LIST_APPEND);

					pWidthOfEntry[nLines+nCnt]  = pText->GetLogicRect().GetWidth();
					pHeightOfEntry[nLines+nCnt] = pText->GetLogicRect().GetHeight();
					nMaxX  = Max (nMaxX,  pWidthOfEntry[nLines+nCnt]);
					nMaxY  = Max (nMaxY, pHeightOfEntry[nLines+nCnt]);

				   // nMaxX  = Max (nMaxX, pText->GetLogicRect().GetWidth());
				   // nMaxY  = Max (nMaxY, pText->GetLogicRect().GetHeight());

					pRegressNr [nLines] = i;
					nLines ++;
				}
			}
		}

		if (IsXYChart ()) nCnt --;
		nLines += nCnt;

		long nTextRows    = 0;
		long nTextCols    = 0;
		long nShows       = 0;

		ULONG nLegendHeight = ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight();
		long nLittleSpace = nLegendHeight / 3;

		// FG: Hier wird berechnet wieviele Spalten und Zeilen die Legende haben soll
		if (!bWide)  // dann ist die Legende mit den Zeilen untereinander links oder rechts
		{
			// FG: Die Legende darf maximal 90% der Blatthoehe einnehmen und maximal 50% der Blattbreite
			if (nLines * (nMaxY + nLittleSpace) < (aRect.GetHeight() - 0.1 * aRect.GetHeight()))
			{
				nTextRows = nLines;
				nTextCols = 1;      // Also eine Spalte
			}
			else  // Es gibt also mehrere Spalten
			{
				nTextRows = (long) ((aRect.GetHeight() - 0.1 * aRect.GetHeight()) / (nMaxY + nLittleSpace));
				if(!nTextRows)
					nTextRows=1;
				nTextCols = (long) ((nLines % nTextRows) ? nLines / nTextRows + 1 : nLines / nTextRows);
				// FG: Falls die Legende zu breit (mehr als 50% der Chart-Breite) wird muss man nachregeln
				if (nTextCols * (nMaxX + nLittleSpace) > aRect.GetWidth())
				{
					nTextCols = (long) (aRect.GetWidth() * 0.5 / (nMaxX + nLittleSpace));
				}
			}
		}
		else  // die Legende befindet sich also unter oder ueber dem Chart (die wird noch beliebig gross)
		{
			nTextCols = (nLines * (nMaxX + 2*nLittleSpace + nLegendHeight) + nLittleSpace < aRect.GetWidth())
						 ? nLines : (aRect.GetWidth() - nLittleSpace) / (nMaxX + 2*nLittleSpace + nLegendHeight);
			nTextRows = nTextCols
						 ? ((nLines % nTextCols) ? nLines / nTextCols + 1 : nLines / nTextCols) : 0;
		}

		if (nTextRows > 0 && nTextCols > 0)
		{
			pGroup = new SchObjGroup;
			pGroup->InsertUserData(new SchObjectId(CHOBJID_LEGEND));
			// pGroup->SetResizeProtect(TRUE);
			SdrObject*  pObj;
			SdrObjList* pObjList = pGroup->GetSubList();

			Point aTextPos (nLittleSpace, nLegendHeight / 4);

			for (i = 0, nShows = 0;
				 i < nLines;
				 i++, nShows ++)
			{
				// FG: bReverse ist fuer gestapelte Diagramme gedacht, damit die Legendensymbole
				//     optisch der Reihenfolge des stapelns entsprechen.
			   long nIndex = (IsXYChart())
							   ?  i+1
							   : (bReverse)
								   ? nCnt - 1 - i
								   : i;

				if (i < nCnt)
				{
					BOOL bIsSymbol = FALSE;
					BOOL bIsLine   = FALSE;
					if(HasSymbols(nIndex))
					{
						bIsSymbol = TRUE;
						pObj = CreateSymbol (::basegfx::B2DPoint(aTextPos.X () + nLegendHeight / 2,
															aTextPos.Y () + nLegendHeight / 2 + nLittleSpace / 3),
											 nIndex, 0, (SfxItemSet &) GetDataRowAttr(nIndex), nLegendHeight, FALSE);
						if(pObj)
						{
							Rectangle aRect(pObj->GetSnapRect());
							if((aRect.GetHeight() > nLegendHeight) && nLegendHeight)
							{
								Fraction aFract(nLegendHeight,aRect.GetHeight());
								pObj->NbcResize(aRect.Center(),aFract,aFract);
							}
						}
						else //dann Linie als Legendensymbol, sonst geht evtl. garnix mehr
						{
							::basegfx::B2DPolygon aLine;
							aLine.append(::basegfx::B2DPoint(aTextPos.X(), aTextPos.Y()));
							aLine.append(::basegfx::B2DPoint(aTextPos.X() + nLegendHeight, aTextPos.Y() + nLegendHeight));
							bIsLine = TRUE;
							pObj = new SdrPathObj(OBJ_PLIN, ::basegfx::B2DPolyPolygon(aLine));
						}
					}
					else if (IsLine(nIndex))
					{
						::basegfx::B2DPolygon aLine;
						aLine.append(::basegfx::B2DPoint(aTextPos.X(), aTextPos.Y()));
						aLine.append(::basegfx::B2DPoint(aTextPos.X() + nLegendHeight, aTextPos.Y() + nLegendHeight));
						bIsLine = TRUE;
						pObj = new SdrPathObj(OBJ_PLIN, ::basegfx::B2DPolyPolygon(aLine));
					}
					else
					{
						// create rectangular shape as legend symbol
						pObj = new SdrRectObj(Rectangle(Point (aTextPos.X(),
															   aTextPos.Y() + nLittleSpace / 3),
														Size(nLegendHeight, nLegendHeight)));
						bForceSolidLine = TRUE;
					}
					// FG: setzen des Symbols neben dem Legendentext

					SfxItemSet *pSymbolAttr;

					if( bRowLegend )
					{
						pSymbolAttr = new SfxItemSet( GetDataRowAttr( nIndex ) );
						if( ! bIsLine && pSymbolAttr )
						  GenerateSymbolAttr( *pSymbolAttr, nIndex, SYMBOLMODE_LEGEND );
					}
					else
					{
						pSymbolAttr = new SfxItemSet( GetFullDataPointAttr( nIndex, 0 ) );
						if( ! bIsLine && pSymbolAttr )
						  GenerateSymbolAttr( *pSymbolAttr, 0, SYMBOLMODE_LEGEND );
					}

					if( bForceSolidLine )
					{
						XLineStyle eLineStyle =
							SAL_STATIC_CAST( const XLineStyleItem *, &(pSymbolAttr->Get( XATTR_LINESTYLE )) )->GetValue(); // bug in Win-C++ compiler: casting to pointer

						if( eLineStyle == XLINE_NONE )
						{
							pSymbolAttr->ClearItem( XATTR_LINESTYLE );
							pSymbolAttr->ClearItem( XATTR_LINEWIDTH );
							pSymbolAttr->ClearItem( XATTR_LINECOLOR );
						}
					}

//-/					pObj->NbcSetAttributes( *pSymbolAttr, FALSE );
					pObj->SetMergedItemSet(*pSymbolAttr);


					if(bRowLegend)
					{
						pObj->InsertUserData(new SchObjectId(CHOBJID_LEGEND_SYMBOL_ROW));
						pObj->InsertUserData(new SchDataRow(nIndex));
					}
					else
					{
						pObj->InsertUserData(new SchObjectId(CHOBJID_LEGEND_SYMBOL_COL));
						pObj->InsertUserData(new SchDataPoint(nIndex, 0));
					}

					pObj->SetMoveProtect(TRUE);
					pObj->SetResizeProtect(TRUE);
					pObjList->NbcInsertObject(pObj);

					SdrObject *pText = (SdrObject*)aTextList.GetObject(nIndex);

					pText->NbcMove(Size(aTextPos.X() + nLittleSpace + nLegendHeight, aTextPos.Y()));
					pObjList->NbcInsertObject(pText);

					delete pSymbolAttr;
				}
				else //i >= nCnt
				{
					if (pRegressNr [i - nCnt])
					{
						::basegfx::B2DPolygon aLine;
						aLine.append(::basegfx::B2DPoint(aTextPos.X(), aTextPos.Y()));
						aLine.append(::basegfx::B2DPoint(aTextPos.X() + nLegendHeight, aTextPos.Y() + nLegendHeight));
						pObj = new SdrPathObj(OBJ_PLIN, ::basegfx::B2DPolyPolygon(aLine));

						//	Set the object's user data so that the
						//	object can't be deleted via the GUI.
						pObj->InsertUserData(new SchObjectId (CHOBJID_LINE));

//-/						pObj->NbcSetAttributes(GetRegressAttr(pRegressNr[i-nCnt]), FALSE);
						pObj->SetMergedItemSet(GetRegressAttr(pRegressNr[i-nCnt]));


						pObj->SetMoveProtect(TRUE);
						pObj->SetResizeProtect(TRUE);
						pObjList->NbcInsertObject(pObj);

						SdrObject* pText = (SdrObject*)aTextList.GetObject(nIndex);

						pText->Move(Size(aTextPos.X() + nLittleSpace + nLegendHeight, aTextPos.Y()));
						pObjList->NbcInsertObject(pText);
					}
				}

				// FG: Jetzt wird aTextPos fuer den naechsten Legendeneintrag gesetzt
			   if (bWide)
				{
					if (nShows >= nTextCols - 1)
					{
						nLineMaxY = Max(nLineMaxY,pHeightOfEntry[i]);//#50082# #NACHTRAG#
						aTextPos.Y () += nLineMaxY  + nLittleSpace;//#50082#
						aTextPos.X ()  = nLittleSpace;//nLegendHeight / 6;//SP3: #49906#
						nLineMaxY = 0; //#50082# #NACHTRAG#
						nShows = -1;
					}
					else
					{
						nLineMaxY = Max(nLineMaxY,pHeightOfEntry[i]);//#50082#
						aTextPos.X () += nMaxX +  2 * nLittleSpace + nLegendHeight;
					}
				}
				else if (nShows >= nTextRows - 1) // FG: Die Legende wird in mehrere Spalten umgebrochen
				{                                 //     also den Spaltenabstand setzen
					aTextPos.X () += nMaxX + nLittleSpace + nLegendHeight + 2*nLittleSpace;
					aTextPos.Y ()  = nLegendHeight / 4;
					nShows = -1;
					if (nActualColumn >= nTextCols)  // FG: Dann wird die Legende zu breit!
					{
						break;                       // aus der for-Schleife raus,
													 // es muessen noch Felder deleted werden.
					}
					nActualColumn++;
				}
				else
				{

					aTextPos.Y() += pHeightOfEntry[nIndex] + nLittleSpace;
				}
			}

				//FG: Jetzt wird das umschliessende Rechteck berechnet. Man fraegt erst das
				//    BoundingRect des Legenden-Gruppenobjektes ab und addiert an den Raendern ein
				//    wenig Platz dazu.
			Rectangle aLogRect = pGroup->GetLogicRect();
			aLogRect.Left() -= nLittleSpace;
			aLogRect.Right() += nLittleSpace;
			aLogRect.Top() -= nLittleSpace;
			aLogRect.Bottom() += nLittleSpace;
			SdrRectObj* pRectObj = new SchRectObj(aLogRect);
			// FG: Das hier soll verhindern dass das Rechteck um die Legende markiert werden kann
			pRectObj->SetMarkProtect(TRUE);
			pRectObj->SetModel( this );
			pObjList->NbcInsertObject(SetObjectAttr(pRectObj, CHOBJID_LEGEND_BACK,
													TRUE, TRUE, pLegendAttr), 0);
		}

		delete[] pRegressNr;
		delete[] pHeightOfEntry;
		delete[] pWidthOfEntry;
	}

	return pGroup;
}

/*************************************************************************
|*
|* Diagramm erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::CreateChart(const Rectangle &rRect)
{
	if( pDocShell )
		pDocShell->SetWaitCursor( TRUE );

	Rectangle aRect( rRect );
	SdrObjGroup* pGroup;

	switch (eChartStyle)
	{
		case CHSTYLE_2D_AREA:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_2D_PERCENTAREA:
			pGroup = Create2DRowLineChart(aRect);//neu, test!
			break;

		case CHSTYLE_2D_LINE:
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_LINESYMBOLS :
		case CHSTYLE_2D_STACKEDLINESYM :
		case CHSTYLE_2D_PERCENTLINESYM :
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			pGroup = Create2DRowLineChart(aRect);
			break;

		case CHSTYLE_2D_COLUMN:
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_BAR:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_2D_LINE_COLUMN:
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			pGroup = Create2DColChart(aRect);
			break;

		case CHSTYLE_2D_PIE_SEGOF1:
		{
			for (short i = 1; i < nPieSegCount; i++)
				SetPieSegOfs(i, 0);
            SetPieSegOfs( 0, 10 );
			pGroup = Create2DPieChart(aRect);
			break;
		}

		case CHSTYLE_2D_PIE_SEGOFALL:
		{
			for (short i = 0; i < nPieSegCount; i++)
                SetPieSegOfs( i, 10 );
		}

		case CHSTYLE_2D_PIE:
			 pGroup = Create2DPieChart(aRect);
			break;

		case CHSTYLE_2D_DONUT1:  //DonutCharts haben jetzt eigenes Create
		case CHSTYLE_2D_DONUT2:
			pGroup = Create2DDonutChart(aRect);
			break;

		case CHSTYLE_2D_XYSYMBOLS :
		case CHSTYLE_2D_XY_LINE :
		case CHSTYLE_2D_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			pGroup = Create2DXYChart(aRect);
			break;

		case CHSTYLE_2D_NET:
		case CHSTYLE_2D_NET_SYMBOLS:
		case CHSTYLE_2D_NET_STACK:
		case CHSTYLE_2D_NET_SYMBOLS_STACK:
		case CHSTYLE_2D_NET_PERCENT:
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
			pGroup = Create2DNetChart(aRect);
			break;

		case CHSTYLE_3D_COLUMN:
		case CHSTYLE_3D_BAR:
		case CHSTYLE_3D_STRIPE:
		case CHSTYLE_3D_AREA:
		case CHSTYLE_3D_SURFACE:
			pGroup = Create3DDeepChart(aRect);
			break;

		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
			pGroup = Create3DFlatChart(aRect);
			break;

		case CHSTYLE_3D_PIE:
			pGroup = Create3DNewPieChart(aRect);
			break;

		default:
			eChartStyle = CHSTYLE_2D_COLUMN;
			pGroup = Create2DColChart(aRect);
			break;
	}

	if( pDocShell )
		pDocShell->SetWaitCursor( FALSE );

	SdrPage* pPage=GetPage( 0 );
	SdrObject* pObj = GetObjWithId( CHOBJID_DIAGRAM_AREA, *pPage );
	if( pObj )
		pObj->SetMoveProtect( TRUE );

	return pGroup;
}

/*************************************************************************
|*
|* Titel aendern;
|* Liefert TRUE, wenn ein Titel geaendert wurde.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitle(BOOL bShowMain, const String& rMainTitle,
							 BOOL bShowSub, const String& rSubTitle,
							 BOOL bShowX, const String& rXAxisTitle,
							 BOOL bShowY, const String& rYAxisTitle,
							 BOOL bShowZ, const String& rZAxisTitle)
{
	BOOL bMainTitleChanged  = (bShowMain != bShowMainTitle || ! rMainTitle.Equals( aMainTitle ));
	BOOL bSubTitleChanged   = (bShowSub != bShowSubTitle || ! rSubTitle.Equals( aSubTitle ));
	BOOL bXAxisTitleChanged = (bShowX != bShowXAxisTitle || ! rXAxisTitle.Equals( aXAxisTitle ));
	BOOL bYAxisTitleChanged = (bShowY != bShowYAxisTitle || ! rYAxisTitle.Equals( aYAxisTitle ));
	BOOL bZAxisTitleChanged = (bShowZ != bShowZAxisTitle || ! rZAxisTitle.Equals( aZAxisTitle ));

	if (!bMainTitleChanged && !bSubTitleChanged &&
		!bXAxisTitleChanged && !bYAxisTitleChanged &&
		!bZAxisTitleChanged) return FALSE;
	else
	{
		if (bMainTitleChanged)
		{
			bShowMainTitle  = (bMainTitleChanged && (!rMainTitle.Len ()))
								  ? FALSE
								  : bShowMain;
			aMainTitle      = rMainTitle;
		}

		if (bSubTitleChanged)
		{
			bShowSubTitle   = (bSubTitleChanged && (!rSubTitle.Len ()))
								  ? FALSE
								  : bShowSub;
			aSubTitle       = rSubTitle;
		}

		if (bXAxisTitleChanged)
		{
			bShowXAxisTitle = (bXAxisTitleChanged && (!rXAxisTitle.Len ()))
								  ? FALSE
								  : bShowX;
			aXAxisTitle     = rXAxisTitle;
		}

		if (bYAxisTitleChanged)
		{
			bShowYAxisTitle = (bYAxisTitleChanged && (!rYAxisTitle.Len ()))
								  ? FALSE
								  : bShowY;
			aYAxisTitle     = rYAxisTitle;
		}

		if (bZAxisTitleChanged)
		{
			bShowZAxisTitle = (bZAxisTitleChanged && (!rZAxisTitle.Len ()))
								  ? FALSE
								  : bShowZ;
			aZAxisTitle     = rZAxisTitle;
		}

		if (bMainTitleChanged || bSubTitleChanged || bXAxisTitleChanged ||
			bYAxisTitleChanged || bZAxisTitleChanged) BuildChart(FALSE);

		return TRUE;
	}
}
/*************************************************************************
|*
|* Titel-Attribute setzen
|*
\************************************************************************/

void ChartModel::PutTitleAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
	{
		pTitleAttr->ClearItem();
		pMainTitleAttr->ClearItem();
		pSubTitleAttr->ClearItem();
		pXAxisTitleAttr->ClearItem();
		pYAxisTitleAttr->ClearItem();
		pZAxisTitleAttr->ClearItem();
	}
	pTitleAttr->Put(rAttr);
	pMainTitleAttr->Put(rAttr);
	pSubTitleAttr->Put(rAttr);
	pXAxisTitleAttr->Put(rAttr);
	pYAxisTitleAttr->Put(rAttr);
	pZAxisTitleAttr->Put(rAttr);
}

/*************************************************************************
|*
|* Titel-Attribute ermitteln
|*
\************************************************************************/

const SfxItemSet & ChartModel::GetTitleAttr( UINT16 nChobjID ) const
{
    switch( nChobjID )
    {
        case CHOBJID_TITLE_MAIN:
            return *pMainTitleAttr;

        case CHOBJID_TITLE_SUB:
            return *pSubTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_X_AXIS:
            return *pXAxisTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
            return *pYAxisTitleAttr;

        case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
            return *pYAxisTitleAttr;
    }
    return *pTitleAttr;
}

const SfxItemSet & ChartModel::GetTitleAttr( const SdrTextObj* pTextObj ) const
{
	if( pTextObj )
	{
		SchObjectId* pObjId = GetObjectId( * pTextObj );
        if( pObjId )
            return GetTitleAttr( pObjId->GetObjId() );
    }
    return *pTitleAttr;
}

/*************************************************************************
|*
|* Titel-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet ChartModel::GetFullTitleAttr(const SdrTextObj* pTextObj) const
{
	if (pTextObj)
	{
		SfxItemSet aAttr(*pItemPool, nTitleWhichPairs);

		aAttr.ClearItem ();

		SchObjectId* pObjId = GetObjectId(*pTextObj);

		if (pObjId) switch (pObjId->GetObjId())
					{
						case CHOBJID_TITLE_MAIN:
						{
							aAttr.Put(*pMainTitleAttr);
							break;
						}

						case CHOBJID_TITLE_SUB:
						{
							aAttr.Put(*pSubTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
						{
							aAttr.Put(*pXAxisTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
						{
							aAttr.Put(*pYAxisTitleAttr);
							break;
						}

						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
						{
							aAttr.Put(*pZAxisTitleAttr);
							break;
						}
					}
		return aAttr;
	}
	else
	{
		pTitleAttr->ClearItem ();
		pTitleAttr->Put (*pMainTitleAttr);
		CompareSets (*pSubTitleAttr, *pTitleAttr);
		CompareSets (*pXAxisTitleAttr, *pTitleAttr);
		CompareSets (*pYAxisTitleAttr, *pTitleAttr);
		CompareSets (*pZAxisTitleAttr, *pTitleAttr);

		return *pTitleAttr;
	}
}

/*************************************************************************
|*
|* Titel-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitleAttr(const SfxItemSet &rAttr,
								 SdrTextObj       *pTitleObj,
								 BOOL             bMerge)
{
	if (pTitleObj)
	{
		SchObjectId* pObjId = GetObjectId(*pTitleObj);

		if (!pObjId) return FALSE;
		else
		{
			SchObjectAdjust* pObjAdjust = GetObjectAdjust(*pTitleObj);
			DBG_ASSERT( pObjAdjust, "ChartModel::ChangeTitleAttr: no adjustment info in text obj") ;

			const SfxPoolItem  *pPoolItem = NULL;
			SvxChartTextOrient eOldOrient = pObjAdjust->GetOrient();
			SvxChartTextOrient eNewOrient = (rAttr.GetItemState(SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
												? ((const SvxChartTextOrientItem*)pPoolItem)->GetValue()
												: eOldOrient;

			switch (pObjId->GetObjId())
			{
				case CHOBJID_TITLE_MAIN:
					PutMainTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pMainTitleAttr,eOldOrient, eNewOrient);

					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_TITLE_MAIN);
					else
//-/						GetObjWithId(CHOBJID_TITLE_MAIN,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_TITLE_MAIN,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_TITLE_SUB:
					PutSubTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pSubTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_TITLE_SUB);
					else
//-/						GetObjWithId(CHOBJID_TITLE_SUB,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_TITLE_SUB,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					PutXAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pXAxisTitleAttr,eOldOrient, eNewOrient);
					 if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_X_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					PutYAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pYAxisTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_Y_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS,*GetPage(0))->SetMergedItemSet(rAttr);
					break;

				case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					PutZAxisTitleAttr(rAttr,bMerge);
					TitleOrientChanged (pTitleObj, pZAxisTitleAttr,eOldOrient, eNewOrient);
					if(IsAttrChangeNeedsBuildChart(rAttr))
						BuildChart(FALSE, CHOBJID_DIAGRAM_TITLE_Z_AXIS);
					else
//-/						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS,*GetPage(0))->SetAttributes(rAttr,FALSE);
						GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS,*GetPage(0))->SetMergedItemSet(rAttr);
					break;
			}

			return TRUE;
		}
	}
	else
	{
		PutTitleAttr(rAttr,bMerge);
		return SetAllTitleAttributes (rAttr);
	}
}

/*************************************************************************
|*
|* Titel-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeTitleAttr(const SfxItemSet &rMainTitleAttr,
								 const SfxItemSet &rSubTitleAttr,
								 const SfxItemSet &rXAxisTitleAttr,
								 const SfxItemSet &rYAxisTitleAttr,
								 const SfxItemSet &rZAxisTitleAttr,
								 BOOL             bMerge)
{
	PutMainTitleAttr( rMainTitleAttr ,bMerge);
	PutSubTitleAttr(  rSubTitleAttr  ,bMerge);
	PutXAxisTitleAttr(rXAxisTitleAttr,bMerge);
	PutYAxisTitleAttr(rYAxisTitleAttr,bMerge);
	PutZAxisTitleAttr(rZAxisTitleAttr,bMerge);

	return SetAllTitleAttributes (*pMainTitleAttr);
}

/*************************************************************************
|*
|* Ermittelt, ob Legende angezeigt wird
|*
\************************************************************************/

BOOL ChartModel::GetShowLegend() const
{
	SvxChartLegendPos ePos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).GetValue();

	switch (ePos)
	{
		case CHLEGEND_LEFT :
		case CHLEGEND_TOP :
		case CHLEGEND_RIGHT :
		case CHLEGEND_BOTTOM :
			return TRUE;

		default :
			return FALSE;
	}
}
/*************************************************************************
|*
|* Zeigt Legende an bzw. loescht sie.
|*
\************************************************************************/

void ChartModel::SetShowLegend(BOOL bShow)
{
	pLegendAttr->Put(SvxChartLegendPosItem(bShow
											   ? CHLEGEND_RIGHT
											   : CHLEGEND_NONE));
	bLegendVisible = bShow;
}
/*************************************************************************
|*
|* Legenden-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet ChartModel::GetFullLegendAttr() const
{
	SfxItemSet aAttr(*pItemPool, nLegendWhichPairs);
	aAttr.Put(*pLegendAttr);
	return aAttr;
}

/*************************************************************************
|*
|* Legenden-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

void ChartModel::ChangeLegendAttr(const SfxItemSet& rAttr,
								  BOOL              bMerge)
{
	long nWEidth = ((XLineWidthItem &)rAttr.Get (XATTR_LINEWIDTH)).GetValue ();

	SdrPage* pPage = GetPage(0);
	DBG_ASSERT( pPage, "ChangeLegendAttr: page object is NULL" );

	const SfxPoolItem* pPoolItem = NULL;

	SvxChartLegendPos eOldPos = ((const SvxChartLegendPosItem&) pLegendAttr->Get(SCHATTR_LEGEND_POS)).GetValue();

	SvxChartLegendPos eNewPos;
	if (rAttr.GetItemState(SCHATTR_LEGEND_POS, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eNewPos = ((const SvxChartLegendPosItem*)pPoolItem)->GetValue();
	else eNewPos = eOldPos;


	//#50913#: Legende hat neue Position? Wenn ja, dann relative Pos loeschen:
	if(eOldPos!=eNewPos)
		SetLegendHasBeenMoved(FALSE);

	PutLegendAttr(rAttr,bMerge);

	if ((eOldPos != CHLEGEND_NONE) && bLegendVisible)
	{
		SdrObjGroup *pLegendObj = (SdrObjGroup*)GetObjWithId(CHOBJID_LEGEND, *pPage);

		if ((eNewPos != CHLEGEND_NONE) && pLegendObj)
		{
			SdrObjList* pObjList = pLegendObj->GetSubList();
			SdrObject* pObj = GetObjWithId(CHOBJID_LEGEND_BACK, *pObjList);
			DBG_ASSERT(pObj, "ChartModel::ChangeLegendAttr: legend back obj not found");

//-/			pObj->SetAttributes(*pLegendAttr, FALSE);
            // #117446# (BM)
            SfxItemSet aLegendAttrClone( *pLegendAttr );
			pObj->SetMergedItemSetAndBroadcast( aLegendAttrClone );

			SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
			aTextAttr.Put(rAttr);

            // #117446# (BM)
            SfxItemSet aAttrClone( rAttr );
			SdrObjListIter aIterator(*pLegendObj->GetSubList(), IM_FLAT);
			while (aIterator.IsMore())
			{
				SdrObject* pObj = aIterator.Next();
				if (pObj->GetObjIdentifier() == OBJ_TEXT)
				{
					SetTextAttr(*(SdrTextObj*)pObj,aTextAttr);

//-/					pObj->SetAttributes(rAttr,0);
					pObj->SetMergedItemSetAndBroadcast( aAttrClone );
				}
			}
		}
	}
	if(IsAttrChangeNeedsBuildChart(rAttr))
		BuildChart(FALSE, CHOBJID_LEGEND);
}
/*************************************************************************
|*
|* Chart-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/
void ChartModel::ChangeChartAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	PutChartAttr(rAttr,bMerge);

	//Todo: Attr->eChartStyle
	BuildChart(FALSE);
}

/*************************************************************************
|*
|* Erstelle Symbole fuer Diagrammtypen mit Symbolen
|*
\************************************************************************/

BOOL ChartModel::TitleOrientChanged (const SdrTextObj   *pTitleObj,
									 const SfxItemSet   *pAttr,
									 SvxChartTextOrient eOldOrient,
									 SvxChartTextOrient eNewOrient)
{
	if (eOldOrient == eNewOrient) return TRUE;
	else
	{
		if( eNewOrient == CHTXTORIENT_STACKED && pTitleObj )
		{
			pOutliner->SetText( *(pTitleObj->GetOutlinerParaObject()) );
			String aTitle = pOutliner->GetText( pOutliner->GetParagraph( 0 ), pOutliner->GetParagraphCount() );
			pOutliner->Clear();
			SAL_CONST_CAST( SdrTextObj*, pTitleObj )->SetText( StackString( aTitle ) );
		}
		else if( eOldOrient == CHTXTORIENT_STACKED && pTitleObj )
		{
			pOutliner->SetText( *(pTitleObj->GetOutlinerParaObject()) );
			String aTitle = pOutliner->GetText( pOutliner->GetParagraph( 0 ), pOutliner->GetParagraphCount() );
			pOutliner->Clear();
			SAL_CONST_CAST( SdrTextObj*, pTitleObj )->SetText( UnstackString( aTitle ) );
		}

		long nOldHeight = GetOutputSize(*((SdrTextObj *)pTitleObj)).Height();

		SetTextAttr(*((SdrTextObj *) pTitleObj),*pAttr);
		return nOldHeight != GetOutputSize(*((SdrTextObj *)pTitleObj)).Height();
	}
}

/*************************************************************************
|*
|* Aendere die Attribute einer Achse
|*
\************************************************************************/

BOOL ChartModel::SetAllTitleAttributes(const SfxItemSet &rAttr)
{
	SdrPage          *pPage=GetPage(0);
	if (!pPage) return FALSE;
	else
	{
		BOOL               bBuildChart = FALSE;
		const SfxPoolItem  *pPoolItem  = NULL;
		SvxChartTextOrient eOldOrient  = (rAttr.GetItemState(SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
											 ? ((const SvxChartTextOrientItem*)pPoolItem)->GetValue()
											 : CHTXTORIENT_AUTOMATIC;

		if (bShowMainTitle)
			if (TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_TITLE_MAIN, *pPage), pMainTitleAttr,
									 eOldOrient,
									((const SvxChartTextOrientItem&)pMainTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
				bBuildChart = TRUE;

		if (!bBuildChart && bShowSubTitle)
			if (TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_TITLE_SUB, *pPage), pSubTitleAttr,
									 eOldOrient,
									((const SvxChartTextOrientItem&)pSubTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
				bBuildChart = TRUE;

		if (!bBuildChart)
		{
			SdrObjGroup *pGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
			SdrObjList  *pList  = pGroup->GetSubList();

			if (bShowXAxisTitle)
				if (Is3DChart() ||                                                                     //TVMNEW: DEEP unoetig
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS, *pPage) // 0,IM_DEEPWITHGROUPS)
																  , pXAxisTitleAttr, eOldOrient,
										((const SvxChartTextOrientItem&)pXAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;

			if (!bBuildChart && bShowYAxisTitle)
				if (Is3DChart() ||
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS, *pPage)//0,IM_DEEPWITHGROUPS)
																  , pYAxisTitleAttr, eOldOrient,
										((const SvxChartTextOrientItem&)pYAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;

			if (!bBuildChart && Is3DChart() && bShowZAxisTitle)
				if (Is3DChart() ||
					TitleOrientChanged ((SdrTextObj*)GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS, *pPage) // 0,IM_DEEPWITHGROUPS)
																  , pZAxisTitleAttr,eOldOrient,
										((const SvxChartTextOrientItem&)pZAxisTitleAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue()))
					bBuildChart = TRUE;
		}

		if (bBuildChart) BuildChart(FALSE);
		return TRUE;
	}
}

