/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SchRangeChecker.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:48:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

/**	$Revision  
	@descr A RangeChecker has the task to test if the y value range of a given 
		data set complies with a given chart type.
	
	@author
		Andre Fischer (af)
*/

#include	<SchRangeChecker.hxx>

#include	<chaxis.hxx>
#include	<chtmodel.hxx>


SchRangeChecker::SchRangeChecker		(ChartModel * pChartModel)
	:	mpChartModel (pChartModel)	
{
	//	We have to determine minimum and maximum values of the data set here, 
	//	because the values returned by the y-axis are not sufficient.
	
	long	nColCount = pChartModel->GetColCount(),
			nRowCount = pChartModel->GetRowCount(),
			nCol,
			nRow;
	double	fVal;
				
	if ((nColCount <= 0) || (nRowCount <= 0))
	{
		//	Use default values if we have no data.
		mfMin = mfMax = 0;
	}
	else
	{
		mfMin = mfMax = pChartModel->GetData (0,0);
		//	Just iterate over all data points.
		for (nCol=0; nCol<nColCount; nCol++)
			for (nRow=0; nRow<nRowCount; nRow++)
			{
				fVal = pChartModel->GetData (nCol,nRow);
				if (fVal < mfMin)
					mfMin = fVal;
				if (fVal > mfMax)
					mfMax = fVal;
			}
	}
}


	
SchRangeChecker::~SchRangeChecker	(void)	
{
}



BOOL	SchRangeChecker::TestAbsoluteValues	(SvxChartStyle eChartStyle)
{
	return (	(mfMin < 0.0)
			&&	(mfMax > 0.0) 
			&&	( ! mpChartModel->IsSignedChart(&eChartStyle))	);
}



BOOL	SchRangeChecker::TestNegativeValues	(SvxChartStyle eChartStyle)
{
	return (	(mfMin < 0.0)
			&&	( ! mpChartModel->IsNegativeChart(&eChartStyle))	);
}



BOOL	SchRangeChecker::TestLogarithmicValues	(void)
{
	return (	(mfMin <= 0.0)
			&&	((const SfxBoolItem&)mpChartModel->GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Get(
						SCHATTR_AXIS_LOGARITHM)).GetValue());
}
