// autogenerated file with codegen.pl

#include <cppunit/simpleheader.hxx>

#include "cow_wrapper_clients.hxx"

using namespace ::o3tl;


namespace o3tltests
{

class cow_wrapper_test : public CppUnit::TestFixture
{
public:
    template< class T > void test( T& rTestObj1, T& rTestObj2, T& rTestObj3 )
    {
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 is unique", 
                               rTestObj1.is_unique() );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2 is unique", 
                               rTestObj2.is_unique() );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3 is unique", 
                               rTestObj3.is_unique() );

        CPPUNIT_ASSERT_MESSAGE("rTestObj1 != rTestObj2", 
                               rTestObj1 != rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2 != rTestObj3", 
                               rTestObj2 != rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 != rTestObj3", 
                               rTestObj1 != rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 < rTestObj2", 
                               rTestObj1 < rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2 < rTestObj3", 
                               rTestObj2 < rTestObj3 );

        rTestObj2 = rTestObj1;
        rTestObj3 = rTestObj1;
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj2", 
                               rTestObj1 == rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj3", 
                               rTestObj1 == rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1.use_count() == 3", 
                               rTestObj1.use_count() == 3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.use_count() == 3", 
                               rTestObj2.use_count() == 3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.use_count() == 3", 
                               rTestObj3.use_count() == 3 );
        
        rTestObj2.makeUnique();
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj2", 
                               rTestObj1 == rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj3", 
                               rTestObj1 == rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1.use_count() == 2", 
                               rTestObj1.use_count() == 2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.use_count() == 1", 
                               rTestObj2.use_count() == 1 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.is_unique()", 
                               rTestObj2.is_unique() );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.use_count() == 2", 
                               rTestObj3.use_count() == 2 );

        rTestObj2.swap( rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj2", 
                               rTestObj1 == rTestObj2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1 == rTestObj3", 
                               rTestObj1 == rTestObj3 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj1.use_count() == 2", 
                               rTestObj1.use_count() == 2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj2.use_count() == 2", 
                               rTestObj2.use_count() == 2 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.use_count() == 1", 
                               rTestObj3.use_count() == 1 );
        CPPUNIT_ASSERT_MESSAGE("rTestObj3.is_unique()", 
                               rTestObj3.is_unique() );
    }

    void testCowWrapper()
    {
        // setup
        cow_wrapper_client1 aTestObj1;
        cow_wrapper_client1 aTestObj2;
        cow_wrapper_client1 aTestObj3;
        
        cow_wrapper_client2 aTestObj4;
        cow_wrapper_client2 aTestObj5;
        cow_wrapper_client2 aTestObj6;

        cow_wrapper_client3 aTestObj7;
        cow_wrapper_client3 aTestObj8;
        cow_wrapper_client3 aTestObj9;

        {
            aTestObj1 = cow_wrapper_client1( 1 );
            aTestObj2.modify( 2 );
            aTestObj3.modify( 3 );
            
            aTestObj4 = cow_wrapper_client2( 4 );
            aTestObj5.modify( 5 );
            aTestObj6.modify( 6 );

            aTestObj7 = cow_wrapper_client3( 7 );
            aTestObj8.modify( 8 );
            aTestObj9.modify( 9 );
        }
        // all three temporaries are dead now

        // test
        test( aTestObj1, aTestObj2, aTestObj3 );
        test( aTestObj4, aTestObj5, aTestObj6 );
        test( aTestObj7, aTestObj8, aTestObj9 );
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(cow_wrapper_test);
    CPPUNIT_TEST(testCowWrapper);
    CPPUNIT_TEST_SUITE_END();
};

// -----------------------------------------------------------------------------
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(o3tltests::cow_wrapper_test, "cow_wrapper_test");
} // namespace o3tltests


// -----------------------------------------------------------------------------

// this macro creates an empty function, which will called by the RegisterAllFunctions()
// to let the user the possibility to also register some functions by hand.
void RegisterAdditionalFunctions(FktRegFuncPtr )
{
}
// NOADDITIONAL;

