/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wildcard.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 13:51:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_WILDCARD_HXX_
#include <classes/wildcard.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _WLDCRD_HXX
#include <tools/wldcrd.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::rtl	;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported declarations
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	definitions
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
Wildcard::Wildcard()
{
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
Wildcard::~Wildcard()
{
}

//*****************************************************************************************************************
//	interface
//*****************************************************************************************************************
sal_Bool Wildcard::match(	const	OUString&	sText		,
							const	OUString&	sPattern	)
{
	// Safe impossible cases.
	// These method is not defined for all incoming parameter!
	LOG_ASSERT( impldbg_checkParameter_match( sText, sPattern ), "Wildcard::match()\nInvalid parameter detected!\n" )

    WildCard aHelper(sPattern);
    return aHelper.Matches(sText);
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods check parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// Special signs '*' and '?' are allowed in pattern only!
sal_Bool Wildcard::impldbg_checkParameter_match(	const	OUString&	sText	,
													const	OUString&	sPattern)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sText	==	NULL	)	||
			( &sPattern	==	NULL	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif // #ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
//	private debug method for testing class implementation
//*****************************************************************************************************************

#ifdef ENABLE_CLASSDEBUG

void Wildcard::impldbg_testWildcard()
{
	sal_Bool	bMatch		;
	OUString	sText		;
	OUString	sPattern	;

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEFG" );
	bMatch		= Wildcard::match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 1\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF"  );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 2\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEFGI");
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 3\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "_BCDEFG" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 4\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB_DEFG" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 5\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF_" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 6\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "aBCDEFG" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 7\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "abcdefg" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 8\n" )

	//------------------------------------------------------------------------

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "?BCDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 9\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB?DEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 10\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF?");
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 11\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "??CDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 12\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABC??FG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 13\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDE??" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 14\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "?BCDEF"  );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 15\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "_BCDEF?" );
	bMatch		= match( sText, sPattern ); // FALSE
	LOG_ASSERT( !(bMatch==sal_True), "Wildcard::impldbg_testWildcard()\nError at test 16\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "???????" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 17\n" )

	//------------------------------------------------------------------------

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*BCDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 18\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB*DEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 19\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABCDEF*" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 20\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*EFG"	   );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 21\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "ABC*"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 22\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "A*G"     );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 23\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*"       );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 24\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "**CDEFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 25\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB**EFG" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 26\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "AB**"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 27\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*******" );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 28\n" )

	//------------------------------------------------------------------------

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "*?*G"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 29\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "A*?*G"   );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 30\n" )

	sText		= OUString::createFromAscii( "ABCDEFG" );
	sPattern	= OUString::createFromAscii( "A*?*"    );
	bMatch		= match( sText, sPattern ); // TRUE
	LOG_ASSERT( !(bMatch==sal_False), "Wildcard::impldbg_testWildcard()\nError at test 31\n" )
}

#endif	//	#ifdef ENABLE_CLASSDEBUG

}		//	namespace framework
