/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: convert.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 00:42:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_embeddedobj.hxx"

#include "convert.hxx"
#include <sot/clsids.hxx>
#include <comphelper/fileformat.h>

using namespace ::com::sun::star;

//-------------------------------------------------------------------------
uno::Sequence< sal_Int8 > GetSequenceClassID( sal_uInt32 n1, sal_uInt16 n2, sal_uInt16 n3,
												sal_uInt8 b8, sal_uInt8 b9, sal_uInt8 b10, sal_uInt8 b11,
												sal_uInt8 b12, sal_uInt8 b13, sal_uInt8 b14, sal_uInt8 b15 )
{
	uno::Sequence< sal_Int8 > aResult( 16 );
	aResult[0] = (sal_Int8)( n1 >> 24 );
	aResult[1] = (sal_Int8)( ( n1 << 8 ) >> 24 );
	aResult[2] = (sal_Int8)( ( n1 << 16 ) >> 24 );
	aResult[3] = (sal_Int8)( ( n1 << 24 ) >> 24 );
	aResult[4] = (sal_Int8)( n2 >> 8 );
	aResult[5] = (sal_Int8)( ( n2 << 8 ) >> 8 );
	aResult[6] = (sal_Int8)( n3 >> 8 );
	aResult[7] = (sal_Int8)( ( n3 << 8 ) >> 8 );
	aResult[8] = b8;
	aResult[9] = b9;
	aResult[10] = b10;
	aResult[11] = b11;
	aResult[12] = b12;
	aResult[13] = b13;
	aResult[14] = b14;
	aResult[15] = b15;

	return aResult;
}

//-------------------------------------------------------------------------
sal_Bool ClassIDsEqual( const uno::Sequence< sal_Int8 >& aClassID1, const uno::Sequence< sal_Int8 >& aClassID2 )
{
	if ( aClassID1.getLength() != aClassID2.getLength() )
		return sal_False;

	for ( sal_Int32 nInd = 0; nInd < aClassID1.getLength(); nInd++ )
		if ( aClassID1[nInd] != aClassID2[nInd] )
			return sal_False;

	return sal_True;
}

///////////////////////////////////////////////////////////////////////////
// The conversion functions below are just temporary solution
// antil such a table is implemented by configuration

//-------------------------------------------------------------------------
// ::rtl::OUString GetDocumentServiceNameFromClassID( const uno::Sequence< sal_Int8 >& aClassID )
// {
// 	::rtl::OUString aServiceName;
// 
// 	if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SC_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Calc.SpreadsheetDocument");
// 	else if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SW_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Writer.TextDocument");
// 	else if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SWWEB_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Writer.WebDocument");
// 	else if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SWGLOB_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Writer.GlobalDocument");
// 	else if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SIMPRESS_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Draw.PresentationDocument");
// 	else if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SDRAW_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Draw.DrawingDocument");
// 	else if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SCH_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Chart.ChartDocument");
// 	else if( ClassIDsEqual( aClassID, GetSequenceClassID( SO3_SM_CLASSID_60 ) ) )
// 		aServiceName = ::rtl::OUString::createFromAscii("com.sun.star.comp.Math.FormulaDocument");
// 
// 	return aServiceName;
// }

//-----------------------------------------------------------
::rtl::OUString ConvertServiceToImplementationName( const ::rtl::OUString& aServName )
{
	// implementation names must be used to resolve ambiguity
	rtl::OUString aResult;

	if ( aServName.equalsAscii( "com.sun.star.text.TextDocument" ) )
		aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Writer.TextDocument" );
	else if ( aServName.equalsAscii( "com.sun.star.text.GlobalDocument" ) )
		aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Writer.GlobalDocument" );
	else if ( aServName.equalsAscii( "com.sun.star.text.WebDocument" ) )
		aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Writer.WebDocument" );
	else if ( aServName.equalsAscii( "com.sun.star.sheet.SpreadsheetDocument" ) )
		aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Calc.SpreadsheetDocument" );
	else if ( aServName.equalsAscii( "com.sun.star.presentation.PresentationDocument" ) )
		aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Draw.PresentationDocument" );
	else if ( aServName.equalsAscii( "com.sun.star.drawing.DrawingDocument" ) )
		aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Draw.DrawingDocument" );
	else if ( aServName.equalsAscii( "com.sun.star.formula.FormulaProperties" ) )
		aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Math.FormulaDocument" );
    else if ( aServName.equalsAscii( "com.sun.star.chart.ChartDocument" ) )
        aResult = ::rtl::OUString::createFromAscii( "com.sun.star.comp.Chart.ChartDocument" );
	else
		aResult = aServName;

	return aResult;
}

//-------------------------------------------------------------------------
// uno::Sequence< sal_Int8 > GetClassIDFromServName( const ::rtl::OUString& aServiceName )
// {
// 	if ( aServiceName.equalsAscii( "com.sun.star.comp.Calc.SpreadsheetDocument" ) )
// 		return GetSequenceClassID( SO3_SC_CLASSID_60 );
// 	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Writer.TextDocument" ) )
// 		return GetSequenceClassID( SO3_SW_CLASSID_60 );
// 	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Writer.WebDocument" ) )
// 		return GetSequenceClassID( SO3_SWWEB_CLASSID_60 );
// 	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Writer.GlobalDocument" ) )
// 		return GetSequenceClassID( SO3_SWGLOB_CLASSID_60 );
// 	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Draw.PresentationDocument" ) )
// 		return GetSequenceClassID( SO3_SIMPRESS_CLASSID_60 );
// 	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Draw.DrawingDocument" ) )
// 		return GetSequenceClassID( SO3_SDRAW_CLASSID_60 );
// 	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Chart.ChartDocument" ) )
// 		return GetSequenceClassID( SO3_SCH_CLASSID_60 );
// 	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Math.FormulaDocument" ) )
// 		return GetSequenceClassID( SO3_SM_CLASSID_60 );
// 
// 	return uno::Sequence< sal_Int8 >();
// }

//-------------------------------------------------------------------------
// ::rtl::OUString GetClassNameFromServName( const ::rtl::OUString& aServiceName )
// {
// 	// TODO: ClassName will be removed
// 	return ::rtl::OUString();
// }

//-------------------------------------------------------------------------
::rtl::OUString GetDefaultFilterFromServName( const ::rtl::OUString& aServiceName, sal_Int32 nVersion )
{
	rtl::OUString aResult;

	if ( aServiceName.equalsAscii( "com.sun.star.comp.Writer.TextDocument" ) )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
			aResult = ::rtl::OUString::createFromAscii( "StarOffice XML (Writer)" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "writer8" );
	}
	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Writer.GlobalDocument" ) )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
			aResult = ::rtl::OUString::createFromAscii( "writer_globaldocument_StarOffice_XML_Writer_GlobalDocument" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "writerglobal8" );
	}
	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Writer.WebDocument" ) )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
			aResult = ::rtl::OUString::createFromAscii( "StarOffice XML (Writer)" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "writerweb8" );
	}
	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Calc.SpreadsheetDocument" ) )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
			aResult = ::rtl::OUString::createFromAscii( "StarOffice XML (Calc)" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "calc8" );
	}
	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Draw.PresentationDocument" ) )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
			aResult = ::rtl::OUString::createFromAscii( "StarOffice XML (Impress)" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "impress8" );
	}
	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Draw.DrawingDocument" ) )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
			aResult = ::rtl::OUString::createFromAscii( "StarOffice XML (Draw)" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "draw8" );
	}
	else if ( aServiceName.equalsAscii( "com.sun.star.comp.Math.FormulaDocument" ) )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
        	aResult = ::rtl::OUString::createFromAscii( "StarOffice XML (Math)" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "math8" );
	}
    else if ( aServiceName.equalsAscii( "com.sun.star.comp.Chart.ChartDocument") )
	{
		if ( nVersion == SOFFICE_FILEFORMAT_60 )
        	aResult = ::rtl::OUString::createFromAscii( "StarOffice XML (Chart)" );
		else if ( nVersion == SOFFICE_FILEFORMAT_8 )
			aResult = ::rtl::OUString::createFromAscii( "chart8" );
	}

	return aResult;
}

// End of the temporary conversion solution
///////////////////////////////////////////////////////////////////////////


