/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dp_gui_modifiablecontext.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ihi $ $Date: 2006/12/20 14:23:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2006 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_DESKTOP_SOURCE_DEPLOYMENT_GUI_DP_GUI_MODIFIABLECONTEXT_HXX
#define INCLUDED_DESKTOP_SOURCE_DEPLOYMENT_GUI_DP_GUI_MODIFIABLECONTEXT_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef _SALHELPER_SIMPLEREFERENCEOBJECT_HXX_
#include "salhelper/simplereferenceobject.hxx"
#endif

/// @HTML

namespace rtl { class OUString; }

namespace dp_gui {

/**
   Determine whether a deployment context is modifiable.
*/
class ModifiableContext: public salhelper::SimpleReferenceObject {
public:
    ModifiableContext();

    /**
       Determine whether a deployment context can be modified.

       @param context
       a context name (e.g., <code>"user"</code> or <code>"shared"</code>)

       @return
       true iff the given <code>context</code> can be modified (i.e., is not
       the <code>"shared"</code> context when executed from within OOo)
    */
    bool isModifiable(rtl::OUString const & context) const;

private:
    ModifiableContext(ModifiableContext &); // not defined
    void operator =(ModifiableContext &); // not defined

    virtual ~ModifiableContext();

    bool m_sharedModifiable;
};

}

#endif
