/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DoubleStackedBarChartTypeTemplate.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:18:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "DoubleStackedBarChartTypeTemplate.hxx"
#include "macros.hxx"
#include "BarChartType.hxx"
#include "LineChartType.hxx"

#include <rtl/math.hxx>

#include <algorithm>

using namespace ::com::sun::star;

using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::Sequence;
using ::rtl::OUString;

namespace chart
{

DoubleStackedBarChartTypeTemplate::DoubleStackedBarChartTypeTemplate(
    Reference<
        uno::XComponentContext > const & xContext,
    const ::rtl::OUString & rServiceName,
    chart2::StackMode eStackMode1,
    chart2::StackMode eStackMode2 ) :
        ChartTypeTemplate( xContext, rServiceName ),
        m_eStackMode1( eStackMode1 ),
        m_eStackMode2( eStackMode2 )
{}

DoubleStackedBarChartTypeTemplate::~DoubleStackedBarChartTypeTemplate()
{}

Reference< chart2::XDataSeriesTreeParent > DoubleStackedBarChartTypeTemplate::createDataSeriesTree(
    const Sequence< Reference< chart2::XDataSeries > > & aSeriesSeq,
    const Reference< chart2::XBoundedCoordinateSystem > & rCoordSys )
{
    // create series tree nodes
    // root
    Reference< chart2::XDataSeriesTreeParent > aRoot( createRootNode());

    // first stack: 3/4 of series, second stack: 1/4
    sal_Int32 nFirstStackSize = static_cast< sal_Int32 >(
        ::rtl::math::round( static_cast< double >( aSeriesSeq.getLength() * 0.75 )));
    sal_Int32 nSecondStackSize = aSeriesSeq.getLength() - nFirstStackSize;

    // Bar Group
    // ---------
    // chart type group
    Reference< chart2::XDataSeriesTreeNode > aBarNode(
        createChartTypeGroup( new BarChartType() ));

    // 'x-axis' group
    Reference< chart2::XDataSeriesTreeNode > aBarCategoryNode(
        createScaleGroup( true, true, rCoordSys, 0, chart2::StackMode_STACKED ));

    // 'y-axis' group
    Reference< chart2::XDataSeriesTreeNode > aBarValueNode1(
        createScaleGroup( false, true, rCoordSys, 1, m_eStackMode1 ));

    // 'y-axis' group
    Reference< chart2::XDataSeriesTreeNode > aBarValueNode2(
        createScaleGroup( false, true, rCoordSys, 1, m_eStackMode2 ));

    // Build Tree
    // ----------

    // add series node to value nodes
    Sequence< Reference< chart2::XDataSeries > > aFirstSeq( nFirstStackSize );
    ::std::copy( aSeriesSeq.getConstArray(),
                 aSeriesSeq.getConstArray() + nFirstStackSize,
                 aFirstSeq.getArray());
    addDataSeriesToGroup( aBarValueNode1, aFirstSeq );

    Sequence< Reference< chart2::XDataSeries > > aSecondSeq( nSecondStackSize );
    ::std::copy( aSeriesSeq.getConstArray() + nFirstStackSize,
                 aSeriesSeq.getConstArray() + aSeriesSeq.getLength(),
                 aSecondSeq.getArray());
    addDataSeriesToGroup( aBarValueNode2, aSecondSeq );

    // add value nodes to category nodes
    attachNodeToNode( aBarCategoryNode, aBarValueNode1 );
    attachNodeToNode( aBarCategoryNode, aBarValueNode2 );

    // add category node to chart type node
    attachNodeToNode( aBarNode, aBarCategoryNode );

    // add chart type nodes to root of tree
    aRoot->addChild( aBarNode );

    return aRoot;
}

uno::Reference< chart2::XChartType > DoubleStackedBarChartTypeTemplate::getDefaultChartType()
    throw (uno::RuntimeException)
{
    return new LineChartType();
}

} //  namespace chart
