/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: PolarTransformation.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:14:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "PolarTransformation.hxx"
#include "macros.hxx"

#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif

#include <cmath>

using namespace ::com::sun::star;

using ::com::sun::star::uno::Sequence;
using ::com::sun::star::uno::RuntimeException;

namespace chart
{

PolarTransformation::PolarTransformation(
    TransformationType eTransType,
    sal_Int32 nDimension /* = 2 */ )
        : m_eType( eTransType ),
          m_nDim( nDimension )
{}

PolarTransformation::~PolarTransformation()
{}

// ____ XTransformation ____
Sequence< double > SAL_CALL PolarTransformation::transform( const Sequence< double >& aValues )
    throw (RuntimeException,
           lang::IllegalArgumentException)
{
    if( aValues.getLength() != m_nDim )
    {
        lang::IllegalArgumentException aExc(
            C2U( "Dimension Missmatch" ),
            static_cast< ::cppu::OWeakObject * >( this ),
            0 );
        throw aExc;
    }

    Sequence< double > aResult( aValues.getLength() );
    const double * pArr = aValues.getConstArray();

    switch( m_eType )
    {
        case TRANSFORM_FROM:
            if( m_nDim == 2 )
            {
                aResult[ 0 ] = cos( pArr[ 0 ] ) * pArr[ 1 ];
                aResult[ 1 ] = sin( pArr[ 0 ] ) * pArr[ 1 ];
            }
            break;
        case TRANSFORM_TO:
            if( m_nDim == 2 )
            {
                double r = sqrt( pArr[ 0 ]*pArr[ 0 ] + pArr[ 1 ]*pArr[ 1 ] );
                double phi = 0.0;
                if( ::rtl::math::approxEqual( pArr[ 0 ], 0.0 ) )
                    phi = asin( pArr[ 1 ] / r );
                else
                    phi = atan( pArr[ 1 ] / pArr[ 0 ] );

                aResult[ 0 ] = phi;
                aResult[ 1 ] = r;
            }
            break;
    }

    return aResult;
}

sal_Int32 SAL_CALL PolarTransformation::getSourceDimension()
    throw (RuntimeException)
{
    return m_nDim;
}

sal_Int32 SAL_CALL PolarTransformation::getTargetDimension()
    throw (RuntimeException)
{
    return m_nDim;
}


}  // namespace chart
