/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Increment.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:12:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "Increment.hxx"
#include "macros.hxx"

using namespace ::com::sun::star;

namespace chart
{

Increment::Increment()
{
    m_aIncrement.PostEquidistant = uno::makeAny( sal_Bool( sal_True ));
    m_aIncrement.BaseValue = uno::makeAny( sal_Int32( 0 ));

    m_aSubIncrements.realloc( 1 );
    m_aSubIncrements[0].PostEquidistant = uno::makeAny( sal_Bool( sal_False ));
}

Increment::~Increment()
{}

void SAL_CALL Increment::setIncrementData( const chart2::IncrementData& aIncrement )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    m_aIncrement = aIncrement;
}

chart2::IncrementData SAL_CALL Increment::getIncrementData()
    throw (uno::RuntimeException)
{
    return m_aIncrement;
}

void SAL_CALL Increment::setSubIncrements( const uno::Sequence< chart2::SubIncrement >& aSubIncrements )
    throw (uno::RuntimeException)
{
    m_aSubIncrements = aSubIncrements;
}

uno::Sequence< chart2::SubIncrement > SAL_CALL Increment::getSubIncrements()
    throw (uno::RuntimeException)
{
    return m_aSubIncrements;
}

uno::Sequence< ::rtl::OUString > Increment::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.IncrementSupplier" );
    return aServices;
}

APPHELPER_XSERVICEINFO_IMPL( Increment,
                             ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                                                  "com.sun.star.comp.chart2.Increment" )));

} //  namespace chart
