/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FileDataProvider.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:58:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef CHART_FILEDATAPROVIDER_HXX
#define CHART_FILEDATAPROVIDER_HXX

#include "ServiceMacros.hxx"

#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif

#ifndef _COM_SUN_STAR_CHART2_XDATAPROVIDER_HPP_
#include <com/sun/star/chart2/XDataProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif

namespace chart
{

class FileDataProvider : public ::cppu::WeakImplHelper2
    < ::com::sun::star::chart2::XDataProvider,
      ::com::sun::star::lang::XServiceInfo >
{
public:
	FileDataProvider( const ::com::sun::star::uno::Reference<
                      ::com::sun::star::uno::XComponentContext > & xContext );
	virtual ~FileDataProvider();

    /// establish methods for factory instatiation
	APPHELPER_SERVICE_FACTORY_HELPER( FileDataProvider )
    /// declare XServiceInfo methods
    APPHELPER_XSERVICEINFO_DECL()

protected:
    // ____ XDataProvider ____
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSource > SAL_CALL
        getDataByRangeRepresentation( const ::rtl::OUString& aRangeRepresentation )
        throw (::com::sun::star::lang::IllegalArgumentException,
               ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSequence > SAL_CALL
        getDataSequenceByRangeIdentifier( const ::rtl::OUString& aRangeIdentifier )
        throw (::com::sun::star::lang::IllegalArgumentException,
               ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSequence > SAL_CALL
        replaceRange( const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSequence >& aSeq )
        throw (::com::sun::star::lang::IllegalArgumentException,
               ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL addDataChangeListener(
        const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataChangeListener >& aListener, const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSource >& aData )
        throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeDataChangeListener(
        const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataChangeListener >& aListener,
        const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSource >& aData )
        throw (::com::sun::star::lang::IllegalArgumentException,
               ::com::sun::star::uno::RuntimeException);

private:
    ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext >      m_xContext;
    ::com::sun::star::uno::Reference<
        ::com::sun::star::chart2::XDataSource > m_xChartData;
};

} //  namespace chart

// CHART_FILEDATAPROVIDER_HXX
#endif
